#include <iomanip>
#include <iostream>
#include <fstream>
#include "TF1.h"
#include "TCanvas.h"
#include "TMath.h"
#include "Stntuple/loop/TStnAna.hh"
#include "TMyZeeFilterModule_ggX.hh"
#include "TMyVertexFilterModuleA_ntu.hh"

// ClassImp(TMyZeeFilterModule)
//_____________________________________________________________________________
TMyZeeFilterModule::TMyZeeFilterModule(const char* name, const char* title):
  TStnModule(name,title)
{

  //------------------ All default values correspond to standard cuts
  fUseConvCut=0; // conversion cut status: 0--Off, 1--On 
  fUseZeeCut=1;  // 1--selecting Z->ee events; 0-- selecting inclusive electrons
  fUseMyExtraCemCut=0; // 0-do nothing; 1--remove CEM electrons that can potentially give fake MET

  //***** cuts for CEM electrons
  fCemMinEt=20.0;    
  fCemMaxEt=1000.0; 
  fTrkMinPt=10.0; 
  fTrkMaxPt=1000.0; 

  fCemMinHADEM[0]=0.0; 
  fCemMinHADEM[1]=0.0; 
  fCemMaxHADEM[0]=0.055;                      
  fCemMaxHADEM[1]=0.00045;                      
  fCemMinIsoFr=-1.0;  
  fCemMaxIsoFr=0.1;  
  fCemMinLshr=0.0;    
  fCemMaxLshr=0.2;
  fCemMinEP=0.0;    
  fCemMaxEP=2.0;
  fCemMinChi2strip=-10.0E6; 
  fCemMaxChi2strip=10.0;
  fCemMindXQ=-3.0;
  fCemMaxdXQ=1.5; 
  fCemMinCesdZ=0.0; 
  fCemMaxCesdZ=3.0;
  fCemMinTrkZ0=0.0; 
  fCemMaxTrkZ0=60.0;
  fCemFidCut=1; // cut on CEM fiduciality
  fCemConvCut=0; // cut on Conversion status code
  fCemTrkMatch=0; // "0"--all events; "1"--events with TrkInd>=0; "-1"-- events with TrkInd=-1
  fCemMinCotAxSl=3; // cut on number of COT Axial SL with 5 or more hits 
  fCemMaxCotAxSl=8;
  fCemMinCotStSl=2; // cut on number of COT Stereo SL with 5 or more hits 
  fCemMaxCotStSl=8;
  fCemMinRconv=-10.0E6; // cut on Rconv as defined in TMyTrackFilterModule
  fCemMaxRconv=10.0E6;

  //***** conversion cuts
  fConv_dXYmax=0.2; // Ray's cut
  fConv_dCotMax=0.04; // Ray's cut 
  fConv_Rmax=60.0; // my cut, not among official cuts   
  fCovCotAxSegMin=0; // Ray uses 1   
  fCovCotStSegMin=0; // Ray uses 1 

  //***** cuts for PEM electrons
  fPemMinEt=20.0; 
  fPemMaxEt=1000.0; 
  fPemMinEtaPes=1.2; 
  fPemMaxEtaPes=2.0;
  fPemMinHADEM=0.0; 
  fPemMaxHADEM=0.05;       
  fPemMin3x3Chi2=-10.0E6;  
  fPemMax3x3Chi2=10.0;
  fPemMinPes5x9U=0.65; 
//   fPemMaxPes5x9U=1.0; 
  fPemMaxPes5x9U=10.0E6; 
  fPemMinPes5x9V=0.65; 
//   fPemMaxPes5x9V=1.0;
  fPemMaxPes5x9V=10.0E6;
  fPemMinIsoFr=-1.0;  
  fPemMaxIsoFr=0.1;
  fPem3x3FitCut=0; // cut on PEM 3x3 tower fit status code
  fPemTrkCut=1;    // ????????? cut on Trk status code
  fPemPhnxMatchCut=1; // cut on Phoenix track match
  fPemMinPesdR=0.0; 
  fPemMaxPesdR=3.0;
  fPemMinTrkZ0=0.0; 
  fPemMaxTrkZ0=60.0;
  fPemMinPhnxZ0=0.0; 
  fPemMaxPhnxZ0=60.0;
  fPemMinSiHit=3;  // cut on number of Silicon hits 
  fPemMaxSiHit=50;

  //***** cuts for Z candidates
  fMinNele=2; // cut on number of leading+extra electrons which pass ID cuts 
  fMaxNele=10; // both CEM and PEM, tight and loose
  fMinNeleL=0; // cut on number of leading electrons which pass ID cuts 
  fMaxNeleL=10; // both CEM and PEM, tight and loose
  fMinNeleE=0; // cut on number of extra electron candidates which pass ID cuts 
  fMaxNeleE=10; // and have energy in the range Et_extra < Et < MinEt_leading 
  fEleEt_leading=20.0; // cut on Et of leading electrons

  fZeeMinM=76.0; // cut on invariant mass of the Z candidate
  fZeeMaxM=106.0;
  fZeeMinEt=0.0; // cut on Et of the Z candidate
  fZeeMaxEt=1000.0;
  fZeeMinEta=0.0; // cut on event Eta of the Z candidate
  fZeeMaxEta=10.0;
  fZeeMinDeltaPhi=0.0; // cut on dPhi of two electrons from the Z candidate
  fZeeMaxDeltaPhi=6.3;
  fZeeMinDeltaEta=0.0; // cut on dEta of two electrons from the Z candidate
  fZeeMaxDeltaEta=6.0;
  fZeeMinDeltaR=0.0; // cut on dEta of two electrons from the Z candidate
  fZeeMaxDeltaR=9.0;
  fZeeMinFid=0; // cut on fiduciality of the Z candidate: FidEle1+FidEle2 
  fZeeMaxFid=2; //                 (0:CEM+CEM, 1:PEM+CEM, 2:PEM+PEM)
  fZeeMinStat=0; // cut on status of the Z candidate: StatEle1+StatEle2 
  fZeeMaxStat=20; //electron status (tCEM=0, lCEM=7, tPEM=9, lPEM=11)
  fZeeMinQual=0; // cut on quality of the Z candidate: StatZ+FidZ
  fZeeMaxQual=24;
  fZeeMinCharge=0; // cut on "charge" of the Z candidate: ChargeEle1+ChargeEle2
  fZeeMaxCharge=2;                   

  fUseVerbose=0; // service param

  fDatFileName="results/MyZeeFilter_output.dat";


  //------------ part related to beam off-set correction ----------------
  fMyBeamLineFile="Stntuple/ana/myBeamLine_138809_186598_fnl.dat";
  fUseBeamLineDB=1; // 1=use BeamLine DB; 0=read from file  
  //_____________________________________________________________________

  std::cout<<"Hi, entering TMyZeeFilterModule"<<std::endl;
}

//_____________________________________________________________________________
TMyZeeFilterModule::~TMyZeeFilterModule() {
}

void TMyZeeFilterModule::BookEleGeneralHistograms(ElectronGeneral_t& Hist, const char* Folder) {
  char name[200];
  char title[200];

  //_______________________before cuts

  sprintf(name,"EleNcand_b");
  sprintf(title," %s%s",Folder,": number of electron candidates");
  Hist.fEleNcand_b= new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fEleNcand_b,Folder);
  sprintf(name,"EleNtower_b");
  sprintf(title," %s%s",Folder,": number of towers in cluster");
  Hist.fEleNtower_b= new TH1F(name,title,6,-0.5,5.5);
  AddHistogram(Hist.fEleNtower_b,Folder);
  sprintf(name,"EleDetector_b");
  sprintf(title," %s%s",Folder,": Electron fiduciality: 0=CEM, 1=PEM, 2=FEM");
  Hist.fEleDetector_b= new TH1F(name,title,3,-0.5,2.5);
  AddHistogram(Hist.fEleDetector_b,Folder);
  sprintf(name,"EleEt_raw_b");
  sprintf(title," %s%s",Folder,": Electron raw E_{T}(EM+HAD)");
  Hist.fEleEt_raw_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleEt_raw_b,Folder);
  sprintf(name,"EleEt_corr_b");
  sprintf(title," %s%s",Folder,": Electron energy correction");
  Hist.fEleEt_corr_b= new TH1F(name,title,400,-2.0,2.0);
  AddHistogram(Hist.fEleEt_corr_b,Folder);
  sprintf(name,"EleEt_b");
  sprintf(title," %s%s",Folder,": Electron corr. E_{T}(EM)");
  Hist.fEleEt_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleEt_b,Folder);
  sprintf(name,"EleE_em_b");
  sprintf(title," %s%s",Folder,": Electron corr. E_{EM}");
  Hist.fEleE_em_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleE_em_b,Folder);
  sprintf(name,"EleE_total_b");
  sprintf(title," %s%s",Folder,": Electron corr. E_{EM+HAD}");
  Hist.fEleE_total_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleE_total_b,Folder);
  sprintf(name,"EleEta_det_b");
  sprintf(title," %s%s",Folder,": Electron #eta_{det}");
  Hist.fEleEta_det_b= new TH1F(name,title,200,-5.0,5.0);
  AddHistogram(Hist.fEleEta_det_b,Folder);
  sprintf(name,"EleEta_b");
  sprintf(title," %s%s",Folder,": Electron #eta");
  Hist.fEleEta_b= new TH1F(name,title,200,-5.0,5.0);
  AddHistogram(Hist.fEleEta_b,Folder);
  sprintf(name,"ElePhi_b");
  sprintf(title," %s%s",Folder,": #phi_{ele}");
  Hist.fElePhi_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fElePhi_b,Folder);
  sprintf(name,"EleTheta_b");
  sprintf(title," %s%s",Folder,": event #theta_{ele}");
  Hist.fEleTheta_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fEleTheta_b,Folder);
  sprintf(name,"EleHadEm_b");
  sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
  Hist.fEleHadEm_b= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fEleHadEm_b,Folder);
  sprintf(name,"EleCalIso4_raw_b");
  sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
  Hist.fEleCalIso4_raw_b= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fEleCalIso4_raw_b,Folder);
  sprintf(name,"EleCalIso4_corr_b");
  sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
  Hist.fEleCalIso4_corr_b= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fEleCalIso4_corr_b,Folder);
  sprintf(name,"EleCalIso4Fr_raw_b");
  sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)/E_{T}");
  Hist.fEleCalIso4Fr_raw_b= new TH1F(name,title,100,-1.0,1.0);
  AddHistogram(Hist.fEleCalIso4Fr_raw_b,Folder);
  sprintf(name,"EleCalIso4Fr_corr_b");
  sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)/E_{T}");
  Hist.fEleCalIso4Fr_corr_b= new TH1F(name,title,100,-1.0,1.0);
  AddHistogram(Hist.fEleCalIso4Fr_corr_b,Folder);

  //_______________________after cuts

  sprintf(name,"EleNcand_a");
  sprintf(title," %s%s",Folder,": number of electron candidates");
  Hist.fEleNcand_a= new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fEleNcand_a,Folder);
  sprintf(name,"EleNtower_a");
  sprintf(title," %s%s",Folder,": number of towers in cluster");
  Hist.fEleNtower_a= new TH1F(name,title,6,-0.5,5.5);
  AddHistogram(Hist.fEleNtower_a,Folder);
  sprintf(name,"EleDetector_a");
  sprintf(title," %s%s",Folder,": Electron fiduciality: 0=CEM, 1=PEM, 2=FEM");
  Hist.fEleDetector_a= new TH1F(name,title,3,-0.5,2.5);
  AddHistogram(Hist.fEleDetector_a,Folder);
  sprintf(name,"EleEt_raw_a");
  sprintf(title," %s%s",Folder,": Electron raw E_{T}(EM+HAD)");
  Hist.fEleEt_raw_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleEt_raw_a,Folder);
  sprintf(name,"EleEt_corr_a");
  sprintf(title," %s%s",Folder,": Electron energy correction");
  Hist.fEleEt_corr_a= new TH1F(name,title,400,-2.0,2.0);
  AddHistogram(Hist.fEleEt_corr_a,Folder);
  sprintf(name,"EleEt_a");
  sprintf(title," %s%s",Folder,": Electron corr. E_{T}(EM)");
  Hist.fEleEt_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleEt_a,Folder);
  sprintf(name,"EleE_em_a");
  sprintf(title," %s%s",Folder,": Electron corr. E_{EM}");
  Hist.fEleE_em_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleE_em_a,Folder);
  sprintf(name,"EleE_total_a");
  sprintf(title," %s%s",Folder,": Electron corr. E_{EM+HAD}");
  Hist.fEleE_total_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fEleE_total_a,Folder);
  sprintf(name,"EleEta_det_a");
  sprintf(title," %s%s",Folder,": Electron #eta_{det}");
  Hist.fEleEta_det_a= new TH1F(name,title,200,-5.0,5.0);
  AddHistogram(Hist.fEleEta_det_a,Folder);
  sprintf(name,"EleEta_a");
  sprintf(title," %s%s",Folder,": Electron #eta");
  Hist.fEleEta_a= new TH1F(name,title,200,-5.0,5.0);
  AddHistogram(Hist.fEleEta_a,Folder);
  sprintf(name,"ElePhi_a");
  sprintf(title," %s%s",Folder,": #phi_{ele}");
  Hist.fElePhi_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fElePhi_a,Folder);
  sprintf(name,"EleTheta_a");
  sprintf(title," %s%s",Folder,": event #theta_{ele}");
  Hist.fEleTheta_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fEleTheta_a,Folder);
  sprintf(name,"EleHadEm_a");
  sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
  Hist.fEleHadEm_a= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fEleHadEm_a,Folder);
  sprintf(name,"EleCalIso4_raw_a");
  sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
  Hist.fEleCalIso4_raw_a= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fEleCalIso4_raw_a,Folder);
  sprintf(name,"EleCalIso4_corr_a");
  sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
  Hist.fEleCalIso4_corr_a= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fEleCalIso4_corr_a,Folder);
  sprintf(name,"EleCalIso4Fr_raw_a");
  sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)/E_{T}");
  Hist.fEleCalIso4Fr_raw_a= new TH1F(name,title,100,-1.0,1.0);
  AddHistogram(Hist.fEleCalIso4Fr_raw_a,Folder);
  sprintf(name,"EleCalIso4Fr_corr_a");
  sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)/E_{T}");
  Hist.fEleCalIso4Fr_corr_a= new TH1F(name,title,100,-1.0,1.0);
  AddHistogram(Hist.fEleCalIso4Fr_corr_a,Folder);

}

void TMyZeeFilterModule::BookCEMHistograms(CEMElectron_t& Hist, const char* Folder) {
  char name [200];
  char title[200];

  sprintf(name,"CemNcand_b");
  sprintf(title," %s%s",Folder,": number of CEM electron candidates");
  Hist.fCemNcand_b= new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fCemNcand_b,Folder);

  sprintf(name,"CemNcand_a");
  sprintf(title," %s%s",Folder,": number of CEM electron candidates");
  Hist.fCemNcand_a= new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fCemNcand_a,Folder);

  for(int i=0; i<2; i++)
    {
      //_______________________before cuts

      sprintf(name,"CemNtower_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of towers in CEM cluster");
      Hist.fCemNtower_b[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemNtower_b[i],Folder);
      sprintf(name,"CemEt_raw_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron raw E_{T}(EM+HAD)");
      Hist.fCemEt_raw_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemEt_raw_b[i],Folder);
      sprintf(name,"CemEt_corr_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron energy correction");
      Hist.fCemEt_corr_b[i]= new TH1F(name,title,400,-2.0,2.0);
      AddHistogram(Hist.fCemEt_corr_b[i],Folder);
      sprintf(name,"CemEt_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{T}(EM)");
      Hist.fCemEt_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemEt_b[i],Folder);
      sprintf(name,"CemE_em_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM}");
      Hist.fCemE_em_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemE_em_b[i],Folder);
      sprintf(name,"CemE_total_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM+HAD}");
      Hist.fCemE_total_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemE_total_b[i],Folder);
      sprintf(name,"CemEta_det_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta_{det}");
      Hist.fCemEta_det_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemEta_det_b[i],Folder);
      sprintf(name,"CemEta_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta");
      Hist.fCemEta_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemEta_b[i],Folder);
      sprintf(name,"CemPhi_b[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{ele}");
      Hist.fCemPhi_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemPhi_b[i],Folder);
      sprintf(name,"CemTheta_b[%i]",i);
      sprintf(title," %s%s",Folder,": event #theta_{ele}");
      Hist.fCemTheta_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTheta_b[i],Folder);
      sprintf(name,"CemHadEm_b[%i]",i);
      sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
      Hist.fCemHadEm_b[i]= new TH1F(name,title,400,-0.5,1.5);
      AddHistogram(Hist.fCemHadEm_b[i],Folder);
      sprintf(name,"CemLshr_b[%i]",i);
      sprintf(title," %s%s",Folder,": L_{share} (3 towers)");
      Hist.fCemLshr_b[i]= new TH1F(name,title,100,-0.5,0.5);
      AddHistogram(Hist.fCemLshr_b[i],Folder);
      sprintf(name,"CemCalIso4_raw_b[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
      Hist.fCemCalIso4_raw_b[i]= new TH1F(name,title,110,-1.0,10.0);
      AddHistogram(Hist.fCemCalIso4_raw_b[i],Folder);
      sprintf(name,"CemCalIso4_corr_b[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
      Hist.fCemCalIso4_corr_b[i]= new TH1F(name,title,140,-4.0,10.0);
      AddHistogram(Hist.fCemCalIso4_corr_b[i],Folder);
      sprintf(name,"CemCalIso4Fr_raw_b[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)/E_{T}");
      Hist.fCemCalIso4Fr_raw_b[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fCemCalIso4Fr_raw_b[i],Folder);
      sprintf(name,"CemCalIso4Fr_corr_b[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)/E_{T}");
      Hist.fCemCalIso4Fr_corr_b[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fCemCalIso4Fr_corr_b[i],Folder);
      sprintf(name,"CemChi2strip_b[%i]",i);
      sprintf(title," %s%s",Folder,": CES strip #chi^{2}");
      Hist.fCemChi2strip_b[i]= new TH1F(name,title,200,0.0,20.0);
      AddHistogram(Hist.fCemChi2strip_b[i],Folder);
      sprintf(name,"CemChi2_b[%i]",i);
      sprintf(title," %s%s",Folder,": CES (strip+wire)/2 #chi^{2}");
      Hist.fCemChi2_b[i]= new TH1F(name,title,200,0.0,20.0);
      AddHistogram(Hist.fCemChi2_b[i],Folder);
      sprintf(name,"CemFid_b[%i]",i);
      sprintf(title," %s%s",Folder,": Fiduciality: CES-based=1, Trk-based=4");
      Hist.fCemFid_b[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemFid_b[i],Folder);
      sprintf(name,"CemFidCes_b[%i]",i);
      sprintf(title," %s%s",Folder,": CES Fiduciality code");
      Hist.fCemFidCes_b[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemFidCes_b[i],Folder);
      sprintf(name,"CemFidTrk_b[%i]",i);
      sprintf(title," %s%s",Folder,": Trk Fiduciality code");
      Hist.fCemFidTrk_b[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemFidTrk_b[i],Folder);
      sprintf(name,"CemEleXces_b[%i]",i);
      sprintf(title," %s%s",Folder,": X_{CES} of EM cluster");
      Hist.fCemEleXces_b[i]= new TH1F(name,title,500,-25.0,25.0);
      AddHistogram(Hist.fCemEleXces_b[i],Folder);
      sprintf(name,"CemTrkXces_b[%i]",i);
      sprintf(title," %s%s",Folder,": X_{CES} of a track");
      Hist.fCemTrkXces_b[i]= new TH1F(name,title,500,-25.0,25.0);
      AddHistogram(Hist.fCemTrkXces_b[i],Folder);
      sprintf(name,"CemConvStat_b[%i]",i);
      sprintf(title," %s%s",Folder,": Conversion status");
      Hist.fCemConvStat_b[i]= new TH1F(name,title,3,-1.5,1.5);
      AddHistogram(Hist.fCemConvStat_b[i],Folder);
      sprintf(name,"CemEP_b[%i]",i);
      sprintf(title," %s%s",Folder,": E(cal cluster) over P(track)");
      Hist.fCemEP_b[i]= new TH1F(name,title,100,0.0,5.0);
      AddHistogram(Hist.fCemEP_b[i],Folder);

      sprintf(name,"CemTrkPt_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P_{T}");
      Hist.fCemTrkPt_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkPt_b[i],Folder);
      sprintf(name,"CemTrkP_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P");
      Hist.fCemTrkP_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkP_b[i],Folder);
      sprintf(name,"CemTrkEta_b[%i]",i);
      sprintf(title," %s%s",Folder,": #eta_{trk}");
      Hist.fCemTrkEta_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkEta_b[i],Folder);
      sprintf(name,"CemTrkPhi_b[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{trk}");
      Hist.fCemTrkPhi_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkPhi_b[i],Folder);
      sprintf(name,"CemTrkTheta_b[%i]",i);
      sprintf(title," %s%s",Folder,": #theta_{trk}");
      Hist.fCemTrkTheta_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkTheta_b[i],Folder);

      sprintf(name,"CemTrkPtBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P_{T}");
      Hist.fCemTrkPtBc_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkPtBc_b[i],Folder);
      sprintf(name,"CemTrkPBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P");
      Hist.fCemTrkPBc_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkPBc_b[i],Folder);
      sprintf(name,"CemTrkEtaBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #eta_{trk}");
      Hist.fCemTrkEtaBc_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkEtaBc_b[i],Folder);
      sprintf(name,"CemTrkPhiBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #phi_{trk}");
      Hist.fCemTrkPhiBc_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkPhiBc_b[i],Folder);
      sprintf(name,"CemTrkThetaBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #theta_{trk}");
      Hist.fCemTrkThetaBc_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkThetaBc_b[i],Folder);
      sprintf(name,"CemTrkDeltaX_b[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta x=x_{ces}-x_{trk}");
      Hist.fCemTrkDeltaX_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaX_b[i],Folder);
      sprintf(name,"CemTrkDeltaXBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #Delta x=x_{ces}-x_{trk}");
      Hist.fCemTrkDeltaXBc_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaXBc_b[i],Folder);
      sprintf(name,"CemTrkQDeltaX_b[%i]",i);
      sprintf(title," %s%s",Folder,": Q*#Delta x=Q*(x_{ces}-x_{trk})");
      Hist.fCemTrkQDeltaX_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkQDeltaX_b[i],Folder);
      sprintf(name,"CemTrkQDeltaXBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained Q*#Delta x=Q*(x_{ces}-x_{trk})");
      Hist.fCemTrkQDeltaXBc_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkQDeltaXBc_b[i],Folder);
      sprintf(name,"CemTrkDeltaZ_b[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta z=z_{ces}-z_{trk}");
      Hist.fCemTrkDeltaZ_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaZ_b[i],Folder);
      sprintf(name,"CemTrkDeltaZBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #Delta z=z_{ces}-z_{trk}");
      Hist.fCemTrkDeltaZBc_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaZBc_b[i],Folder);
      sprintf(name,"CemTrkZ0_b[%i]",i);
      sprintf(title," %s%s",Folder,": z_{trk}");
      Hist.fCemTrkZ0_b[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fCemTrkZ0_b[i],Folder);
      sprintf(name,"CemTrkZ0Bc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained z_{trk}");
      Hist.fCemTrkZ0Bc_b[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fCemTrkZ0Bc_b[i],Folder);
      sprintf(name,"CemTrkD0_b[%i]",i);
      sprintf(title," %s%s",Folder,": impact d_{0}");
      Hist.fCemTrkD0_b[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fCemTrkD0_b[i],Folder);
      sprintf(name,"CemTrkD0Bc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained impact d_{0}");
      Hist.fCemTrkD0Bc_b[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fCemTrkD0Bc_b[i],Folder);
      sprintf(name,"CemTrkCharge_b[%i]",i);
      sprintf(title," %s%s",Folder,": track charge");
      Hist.fCemTrkCharge_b[i]= new TH1F(name,title,5,-2.5,2.5);
      AddHistogram(Hist.fCemTrkCharge_b[i],Folder);
      sprintf(name,"CemTrkRconv_b[%i]",i);
      sprintf(title," %s%s",Folder,": R_{conv} of track");
      Hist.fCemTrkRconv_b[i]= new TH1F(name,title,3000,-750.0,750.0);
      AddHistogram(Hist.fCemTrkRconv_b[i],Folder);
      sprintf(name,"CemTrkAlgoID_b[%i]",i);
      sprintf(title," %s%s",Folder,": track Algorithm");
      Hist.fCemTrkAlgoID_b[i]= new TH1F(name,title,40,-0.5,39.5);
      AddHistogram(Hist.fCemTrkAlgoID_b[i],Folder);
      sprintf(name,"CemTrkCotAx_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT axial superlayers");
      Hist.fCemTrkCotAx_b[i]= new TH1F(name,title,10,-0.5,9.5);
      AddHistogram(Hist.fCemTrkCotAx_b[i],Folder);
      sprintf(name,"CemTrkCotSt_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT stereo superlayers");
      Hist.fCemTrkCotSt_b[i]= new TH1F(name,title,10,-0.5,9.5);
      AddHistogram(Hist.fCemTrkCotSt_b[i],Folder);
      sprintf(name,"CemTrkCotAxHits_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT axial hits");
      Hist.fCemTrkCotAxHits_b[i]= new TH1F(name,title,97,-0.5,96.5);
      AddHistogram(Hist.fCemTrkCotAxHits_b[i],Folder);
      sprintf(name,"CemTrkCotStHits_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT stereo hits");
      Hist.fCemTrkCotStHits_b[i]= new TH1F(name,title,97,-0.5,96.5);
      AddHistogram(Hist.fCemTrkCotStHits_b[i],Folder);

      sprintf(name,"CemTrkCorrD0_b[%i]",i);
      sprintf(title," %s%s",Folder,": impact d_{0} corrected for beam off-set");
      Hist.fCemTrkCorrD0_b[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fCemTrkCorrD0_b[i],Folder);
      sprintf(name,"CemTrkCorrDelPhi_b[%i]",i);
      sprintf(title," %s%s",Folder,": #delta#phi=#phi-#phi_{corr} -- effect of beam off-set");
      Hist.fCemTrkCorrDelPhi_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkCorrDelPhi_b[i],Folder);


      //_______________________after cuts

      sprintf(name,"CemNtower_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of towers in CEM cluster");
      Hist.fCemNtower_a[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemNtower_a[i],Folder);
      sprintf(name,"CemEt_raw_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron raw E_{T}(EM+HAD)");
      Hist.fCemEt_raw_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemEt_raw_a[i],Folder);
      sprintf(name,"CemEt_corr_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron energy correction");
      Hist.fCemEt_corr_a[i]= new TH1F(name,title,400,-2.0,2.0);
      AddHistogram(Hist.fCemEt_corr_a[i],Folder);
      sprintf(name,"CemEt_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{T}(EM)");
      Hist.fCemEt_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemEt_a[i],Folder);
      sprintf(name,"CemE_em_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM}");
      Hist.fCemE_em_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemE_em_a[i],Folder);
      sprintf(name,"CemE_total_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM+HAD}");
      Hist.fCemE_total_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemE_total_a[i],Folder);
      sprintf(name,"CemEta_det_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta_{det}");
      Hist.fCemEta_det_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemEta_det_a[i],Folder);
      sprintf(name,"CemEta_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta");
      Hist.fCemEta_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemEta_a[i],Folder);
      sprintf(name,"CemPhi_a[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{ele}");
      Hist.fCemPhi_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemPhi_a[i],Folder);
      sprintf(name,"CemTheta_a[%i]",i);
      sprintf(title," %s%s",Folder,": event #theta_{ele}");
      Hist.fCemTheta_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTheta_a[i],Folder);
      sprintf(name,"CemHadEm_a[%i]",i);
      sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
      Hist.fCemHadEm_a[i]= new TH1F(name,title,400,-0.5,1.5);
      AddHistogram(Hist.fCemHadEm_a[i],Folder);
      sprintf(name,"CemLshr_a[%i]",i);
      sprintf(title," %s%s",Folder,": L_{share} (3 towers)");
      Hist.fCemLshr_a[i]= new TH1F(name,title,100,-0.5,0.5);
      AddHistogram(Hist.fCemLshr_a[i],Folder);
      sprintf(name,"CemCalIso4_raw_a[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
      Hist.fCemCalIso4_raw_a[i]= new TH1F(name,title,110,-1.0,10.0);
      AddHistogram(Hist.fCemCalIso4_raw_a[i],Folder);
      sprintf(name,"CemCalIso4_corr_a[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
      Hist.fCemCalIso4_corr_a[i]= new TH1F(name,title,140,-4.0,10.0);
      AddHistogram(Hist.fCemCalIso4_corr_a[i],Folder);
      sprintf(name,"CemCalIso4Fr_raw_a[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)/E_{T}");
      Hist.fCemCalIso4Fr_raw_a[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fCemCalIso4Fr_raw_a[i],Folder);
      sprintf(name,"CemCalIso4Fr_corr_a[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)/E_{T}");
      Hist.fCemCalIso4Fr_corr_a[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fCemCalIso4Fr_corr_a[i],Folder);
      sprintf(name,"CemChi2strip_a[%i]",i);
      sprintf(title," %s%s",Folder,": CES strip #chi^{2}");
      Hist.fCemChi2strip_a[i]= new TH1F(name,title,200,0.0,20.0);
      AddHistogram(Hist.fCemChi2strip_a[i],Folder);
      sprintf(name,"CemChi2_a[%i]",i);
      sprintf(title," %s%s",Folder,": CES (strip+wire)/2 #chi^{2}");
      Hist.fCemChi2_a[i]= new TH1F(name,title,200,0.0,20.0);
      AddHistogram(Hist.fCemChi2_a[i],Folder);
      sprintf(name,"CemFid_a[%i]",i);
      sprintf(title," %s%s",Folder,": Fiduciality: CES-based=1, Trk-based=4");
      Hist.fCemFid_a[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemFid_a[i],Folder);
      sprintf(name,"CemFidCes_a[%i]",i);
      sprintf(title," %s%s",Folder,": CES Fiduciality code");
      Hist.fCemFidCes_a[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemFidCes_a[i],Folder);
      sprintf(name,"CemFidTrk_a[%i]",i);
      sprintf(title," %s%s",Folder,": Trk Fiduciality code");
      Hist.fCemFidTrk_a[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fCemFidTrk_a[i],Folder);
      sprintf(name,"CemConvStat_a[%i]",i);
      sprintf(title," %s%s",Folder,": Conversion status");
      sprintf(name,"CemEleXces_a[%i]",i);
      sprintf(title," %s%s",Folder,": X_{CES} of EM cluster");
      Hist.fCemEleXces_a[i]= new TH1F(name,title,500,-25.0,25.0);
      AddHistogram(Hist.fCemEleXces_a[i],Folder);
      sprintf(name,"CemTrkXces_a[%i]",i);
      sprintf(title," %s%s",Folder,": X_{CES} of a track");
      Hist.fCemTrkXces_a[i]= new TH1F(name,title,500,-25.0,25.0);
      AddHistogram(Hist.fCemTrkXces_a[i],Folder);
      Hist.fCemConvStat_a[i]= new TH1F(name,title,3,-1.5,1.5);
      AddHistogram(Hist.fCemConvStat_a[i],Folder);
      sprintf(name,"CemEP_a[%i]",i);
      sprintf(title," %s%s",Folder,": E(cal cluster) over P(track)");
      Hist.fCemEP_a[i]= new TH1F(name,title,100,0.0,5.0);
      AddHistogram(Hist.fCemEP_a[i],Folder);

      sprintf(name,"CemTrkPt_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P_{T}");
      Hist.fCemTrkPt_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkPt_a[i],Folder);
      sprintf(name,"CemTrkP_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P");
      Hist.fCemTrkP_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkP_a[i],Folder);
      sprintf(name,"CemTrkEta_a[%i]",i);
      sprintf(title," %s%s",Folder,": #eta_{trk}");
      Hist.fCemTrkEta_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkEta_a[i],Folder);
      sprintf(name,"CemTrkPhi_a[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{trk}");
      Hist.fCemTrkPhi_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkPhi_a[i],Folder);
      sprintf(name,"CemTrkTheta_a[%i]",i);
      sprintf(title," %s%s",Folder,": #theta_{trk}");
      Hist.fCemTrkTheta_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkTheta_a[i],Folder);

      sprintf(name,"CemTrkPtBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P_{T}");
      Hist.fCemTrkPtBc_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkPtBc_a[i],Folder);
      sprintf(name,"CemTrkPBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P");
      Hist.fCemTrkPBc_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fCemTrkPBc_a[i],Folder);
      sprintf(name,"CemTrkEtaBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #eta_{trk}");
      Hist.fCemTrkEtaBc_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkEtaBc_a[i],Folder);
      sprintf(name,"CemTrkPhiBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #phi_{trk}");
      Hist.fCemTrkPhiBc_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkPhiBc_a[i],Folder);
      sprintf(name,"CemTrkThetaBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #theta_{trk}");
      Hist.fCemTrkThetaBc_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkThetaBc_a[i],Folder);
      sprintf(name,"CemTrkDeltaX_a[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta x=x_{ces}-x_{trk}");
      Hist.fCemTrkDeltaX_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaX_a[i],Folder);
      sprintf(name,"CemTrkDeltaXBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #Delta x=x_{ces}-x_{trk}");
      Hist.fCemTrkDeltaXBc_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaXBc_a[i],Folder);
      sprintf(name,"CemTrkQDeltaX_a[%i]",i);
      sprintf(title," %s%s",Folder,": Q*#Delta x=Q*(x_{ces}-x_{trk})");
      Hist.fCemTrkQDeltaX_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkQDeltaX_a[i],Folder);
      sprintf(name,"CemTrkQDeltaXBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained Q*#Delta x=Q*(x_{ces}-x_{trk})");
      Hist.fCemTrkQDeltaXBc_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkQDeltaXBc_a[i],Folder);
      sprintf(name,"CemTrkDeltaZ_a[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta z=z_{ces}-z_{trk}");
      Hist.fCemTrkDeltaZ_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaZ_a[i],Folder);
      sprintf(name,"CemTrkDeltaZBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #Delta z=z_{ces}-z_{trk}");
      Hist.fCemTrkDeltaZBc_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fCemTrkDeltaZBc_a[i],Folder);
      sprintf(name,"CemTrkZ0_a[%i]",i);
      sprintf(title," %s%s",Folder,": z_{trk}");
      Hist.fCemTrkZ0_a[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fCemTrkZ0_a[i],Folder);
      sprintf(name,"CemTrkZ0Bc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained z_{trk}");
      Hist.fCemTrkZ0Bc_a[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fCemTrkZ0Bc_a[i],Folder);
      sprintf(name,"CemTrkD0_a[%i]",i);
      sprintf(title," %s%s",Folder,": impact d_{0}");
      Hist.fCemTrkD0_a[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fCemTrkD0_a[i],Folder);
      sprintf(name,"CemTrkD0Bc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained impact d_{0}");
      Hist.fCemTrkD0Bc_a[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fCemTrkD0Bc_a[i],Folder);
      sprintf(name,"CemTrkCharge_a[%i]",i);
      sprintf(title," %s%s",Folder,": track charge");
      Hist.fCemTrkCharge_a[i]= new TH1F(name,title,5,-2.5,2.5);
      AddHistogram(Hist.fCemTrkCharge_a[i],Folder);
      sprintf(name,"CemTrkRconv_a[%i]",i);
      sprintf(title," %s%s",Folder,": R_{conv} of track");
      Hist.fCemTrkRconv_a[i]= new TH1F(name,title,3000,-750.0,750.0);
      AddHistogram(Hist.fCemTrkRconv_a[i],Folder);
      sprintf(name,"CemTrkAlgoID_a[%i]",i);
      sprintf(title," %s%s",Folder,": track Algorithm");
      Hist.fCemTrkAlgoID_a[i]= new TH1F(name,title,40,-0.5,39.5);
      AddHistogram(Hist.fCemTrkAlgoID_a[i],Folder);
      sprintf(name,"CemTrkCotAx_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT axial superlayers");
      Hist.fCemTrkCotAx_a[i]= new TH1F(name,title,10,-0.5,9.5);
      AddHistogram(Hist.fCemTrkCotAx_a[i],Folder);
      sprintf(name,"CemTrkCotSt_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT stereo superlayers");
      Hist.fCemTrkCotSt_a[i]= new TH1F(name,title,10,-0.5,9.5);
      AddHistogram(Hist.fCemTrkCotSt_a[i],Folder);
      sprintf(name,"CemTrkCotAxHits_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT axial hits");
      Hist.fCemTrkCotAxHits_a[i]= new TH1F(name,title,97,-0.5,96.5);
      AddHistogram(Hist.fCemTrkCotAxHits_a[i],Folder);
      sprintf(name,"CemTrkCotStHits_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of COT stereo hits");
      Hist.fCemTrkCotStHits_a[i]= new TH1F(name,title,97,-0.5,96.5);
      AddHistogram(Hist.fCemTrkCotStHits_a[i],Folder);

      sprintf(name,"CemTrkCorrD0_a[%i]",i);
      sprintf(title," %s%s",Folder,": impact d_{0} corrected for beam off-set");
      Hist.fCemTrkCorrD0_a[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fCemTrkCorrD0_a[i],Folder);
      sprintf(name,"CemTrkCorrDelPhi_a[%i]",i);
      sprintf(title," %s%s",Folder,": #delta#phi=#phi-#phi_{corr} -- effect of beam off-set");
      Hist.fCemTrkCorrDelPhi_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fCemTrkCorrDelPhi_a[i],Folder);

    }  
}

void TMyZeeFilterModule::BookPEMHistograms(PEMElectron_t& Hist, const char* Folder) {
  char name [200];
  char title[200];

  sprintf(name,"PemNcand_b");
  sprintf(title," %s%s",Folder,": number of PEM electron candidates");
  Hist.fPemNcand_b= new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fPemNcand_b,Folder);

  sprintf(name,"PemNcand_a");
  sprintf(title," %s%s",Folder,": number of PEM electron candidates");
  Hist.fPemNcand_a= new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fPemNcand_a,Folder);

  for(int i=0; i<2; i++)
    {
      //_______________________before cuts

      sprintf(name,"PemNtower_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of towers in PEM cluster");
      Hist.fPemNtower_b[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fPemNtower_b[i],Folder);
      sprintf(name,"PemEt_raw_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron raw E_{T}(EM+HAD)");
      Hist.fPemEt_raw_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemEt_raw_b[i],Folder);
      sprintf(name,"PemEt_corr_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron energy correction");
      Hist.fPemEt_corr_b[i]= new TH1F(name,title,400,-2.0,2.0);
      AddHistogram(Hist.fPemEt_corr_b[i],Folder);
      sprintf(name,"PemEt_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{T}(EM)");
      Hist.fPemEt_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemEt_b[i],Folder);
      sprintf(name,"PemE_em_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM}");
      Hist.fPemE_em_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemE_em_b[i],Folder);
      sprintf(name,"PemE_ppr_b[%i]",i);
      sprintf(title," %s%s",Folder,": PPR energy");
      Hist.fPemE_ppr_b[i]= new TH1F(name,title,200,0.0,100.0);
      AddHistogram(Hist.fPemE_ppr_b[i],Folder);
      sprintf(name,"PemE_total_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM+HAD}");
      Hist.fPemE_total_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemE_total_b[i],Folder);
      sprintf(name,"PemEta_det_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta_{det}");
      Hist.fPemEta_det_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemEta_det_b[i],Folder);
      sprintf(name,"PemEta_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta");
      Hist.fPemEta_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemEta_b[i],Folder);
      sprintf(name,"PemPhi_b[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{ele}");
      Hist.fPemPhi_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemPhi_b[i],Folder);
      sprintf(name,"PemTheta_b[%i]",i);
      sprintf(title," %s%s",Folder,": event #theta_{ele}");
      Hist.fPemTheta_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTheta_b[i],Folder);
      sprintf(name,"PemEta_pes3x3_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta, 3x3 #chi^{2} fit");
      Hist.fPemEta_pes3x3_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemEta_pes3x3_b[i],Folder);
      sprintf(name,"PemPhi_pes3x3_b[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{ele}, 3x3 #chi^{2} fit");
      Hist.fPemPhi_pes3x3_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemPhi_pes3x3_b[i],Folder);
      sprintf(name,"PemHadEm_b[%i]",i);
      sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
      Hist.fPemHadEm_b[i]= new TH1F(name,title,400,-0.5,1.5);
      AddHistogram(Hist.fPemHadEm_b[i],Folder);
      sprintf(name,"PemCalIso4_raw_b[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
      Hist.fPemCalIso4_raw_b[i]= new TH1F(name,title,110,-1.0,10.0);
      AddHistogram(Hist.fPemCalIso4_raw_b[i],Folder);
      sprintf(name,"PemCalIso4_corr_b[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
      Hist.fPemCalIso4_corr_b[i]= new TH1F(name,title,140,-4.0,10.0);
      AddHistogram(Hist.fPemCalIso4_corr_b[i],Folder);
      sprintf(name,"PemCalIso4Fr_raw_b[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)/E_{T}");
      Hist.fPemCalIso4Fr_raw_b[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fPemCalIso4Fr_raw_b[i],Folder);
      sprintf(name,"PemCalIso4Fr_corr_b[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)/E_{T}");
      Hist.fPemCalIso4Fr_corr_b[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fPemCalIso4Fr_corr_b[i],Folder);
      sprintf(name,"Pem3x3FitTwr_b[%i]",i);
      sprintf(title," %s%s",Folder,": 3x3 fit status code");
      Hist.fPem3x3FitTwr_b[i]= new TH1F(name,title,13,-1.5,11.5);
      AddHistogram(Hist.fPem3x3FitTwr_b[i],Folder);
      sprintf(name,"PemChi2Pes_b[%i]",i);
      sprintf(title," %s%s",Folder,": PES 3x3 #chi^{2}");
      Hist.fPemChi2Pes_b[i]= new TH1F(name,title,200,0.0,20.0);
      AddHistogram(Hist.fPemChi2Pes_b[i],Folder);
      sprintf(name,"PemPes5x9U_b[%i]",i);
      sprintf(title," %s%s",Folder,": PES 5x9 shower profile ratios (U)");
      Hist.fPemPes5x9U_b[i]= new TH1F(name,title,100,0.0,1.0);
      AddHistogram(Hist.fPemPes5x9U_b[i],Folder);
      sprintf(name,"PemPes5x9V_b[%i]",i);
      sprintf(title," %s%s",Folder,": PES 5x9 shower profile ratios (V)");
      Hist.fPemPes5x9V_b[i]= new TH1F(name,title,100,0.0,1.0);
      AddHistogram(Hist.fPemPes5x9V_b[i],Folder);
      sprintf(name,"PemConvStat_b[%i]",i);
      sprintf(title," %s%s",Folder,": Conversion status");
      Hist.fPemConvStat_b[i]= new TH1F(name,title,3,-1.5,1.5);
      AddHistogram(Hist.fPemConvStat_b[i],Folder);

      sprintf(name,"PemTrkPnxPt_b[%i]",i);
      sprintf(title," %s%s",Folder,": Phoenix track P_{T}");
      Hist.fPemTrkPnxPt_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPnxPt_b[i],Folder);
      sprintf(name,"PemTrkPt_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P_{T}");
      Hist.fPemTrkPt_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPt_b[i],Folder);
      sprintf(name,"PemTrkP_b[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P");
      Hist.fPemTrkP_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkP_b[i],Folder);
      sprintf(name,"PemTrkEta_b[%i]",i);
      sprintf(title," %s%s",Folder,": #eta_{trk}");
      Hist.fPemTrkEta_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemTrkEta_b[i],Folder);
      sprintf(name,"PemTrkPhi_b[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{trk}");
      Hist.fPemTrkPhi_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkPhi_b[i],Folder);
      sprintf(name,"PemTrkTheta_b[%i]",i);
      sprintf(title," %s%s",Folder,": #theta_{trk}");
      Hist.fPemTrkTheta_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkTheta_b[i],Folder);
      sprintf(name,"PemTrkPtBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P_{T}");
      Hist.fPemTrkPtBc_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPtBc_b[i],Folder);
      sprintf(name,"PemTrkPBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P");
      Hist.fPemTrkPBc_b[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPBc_b[i],Folder);
      sprintf(name,"PemTrkEtaBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #eta_{trk}");
      Hist.fPemTrkEtaBc_b[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemTrkEtaBc_b[i],Folder);
      sprintf(name,"PemTrkPhiBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #phi_{trk}");
      Hist.fPemTrkPhiBc_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkPhiBc_b[i],Folder);
      sprintf(name,"PemTrkThetaBc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #theta_{trk}");
      Hist.fPemTrkThetaBc_b[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkThetaBc_b[i],Folder);
      sprintf(name,"PemTrkZ0_b[%i]",i);
      sprintf(title," %s%s",Folder,": z_{trk}");
      Hist.fPemTrkZ0_b[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fPemTrkZ0_b[i],Folder);
      sprintf(name,"PemTrkZ0Bc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained z_{trk}");
      Hist.fPemTrkZ0Bc_b[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fPemTrkZ0Bc_b[i],Folder);
      sprintf(name,"PemTrkD0_b[%i]",i);
      sprintf(title," %s%s",Folder,": impact d_{0}");
      Hist.fPemTrkD0_b[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fPemTrkD0_b[i],Folder);
      sprintf(name,"PemTrkD0Bc_b[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained impact d_{0}");
      Hist.fPemTrkD0Bc_b[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fPemTrkD0Bc_b[i],Folder);
      sprintf(name,"PemTrkCharge_b[%i]",i);
      sprintf(title," %s%s",Folder,": track charge");
      Hist.fPemTrkCharge_b[i]= new TH1F(name,title,5,-2.5,2.5);
      AddHistogram(Hist.fPemTrkCharge_b[i],Folder);
      sprintf(name,"PemTrkRconv_b[%i]",i);
      sprintf(title," %s%s",Folder,": R_{conv} of track");
      Hist.fPemTrkRconv_b[i]= new TH1F(name,title,3000,-750.0,750.0);
      AddHistogram(Hist.fPemTrkRconv_b[i],Folder);
      sprintf(name,"PemTrkAlgoID_b[%i]",i);
      sprintf(title," %s%s",Folder,": track Algorithm");
      Hist.fPemTrkAlgoID_b[i]= new TH1F(name,title,40,-0.5,39.5);
      AddHistogram(Hist.fPemTrkAlgoID_b[i],Folder);
      sprintf(name,"PemTrkPesDeltaR_b[%i]",i);
      sprintf(title," %s%s",Folder,": PES-Trk #Delta R");
      Hist.fPemTrkPesDeltaR_b[i]= new TH1F(name,title,300,0.0,30.0);
      AddHistogram(Hist.fPemTrkPesDeltaR_b[i],Folder);
      sprintf(name,"PemPesDeltaR_b[%i]",i);
      sprintf(title," %s%s",Folder,": PES-PEM #Delta R");
      Hist.fPemPesDeltaR_b[i]= new TH1F(name,title,300,0.0,30.0);
      AddHistogram(Hist.fPemPesDeltaR_b[i],Folder);
      sprintf(name,"PemTrkSiHits_b[%i]",i);
      sprintf(title," %s%s",Folder,": number of Silicon hits");
      Hist.fPemTrkSiHits_b[i]= new TH1F(name,title,50,-0.5,49.5);
      AddHistogram(Hist.fPemTrkSiHits_b[i],Folder);

      //_______________________after cuts

      sprintf(name,"PemNtower_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of towers in PEM cluster");
      Hist.fPemNtower_a[i]= new TH1F(name,title,6,-0.5,5.5);
      AddHistogram(Hist.fPemNtower_a[i],Folder);
      sprintf(name,"PemEt_raw_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron raw E_{T}(EM+HAD)");
      Hist.fPemEt_raw_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemEt_raw_a[i],Folder);
      sprintf(name,"PemEt_corr_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron energy correction");
      Hist.fPemEt_corr_a[i]= new TH1F(name,title,400,-2.0,2.0);
      AddHistogram(Hist.fPemEt_corr_a[i],Folder);
      sprintf(name,"PemEt_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{T}(EM)");
      Hist.fPemEt_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemEt_a[i],Folder);
      sprintf(name,"PemE_em_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM}");
      Hist.fPemE_em_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemE_em_a[i],Folder);
      sprintf(name,"PemE_ppr_a[%i]",i);
      sprintf(title," %s%s",Folder,": PPR energy");
      Hist.fPemE_ppr_a[i]= new TH1F(name,title,200,0.0,100.0);
      AddHistogram(Hist.fPemE_ppr_a[i],Folder);
      sprintf(name,"PemE_total_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron corr. E_{EM+HAD}");
      Hist.fPemE_total_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemE_total_a[i],Folder);
      sprintf(name,"PemEta_det_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta_{det}");
      Hist.fPemEta_det_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemEta_det_a[i],Folder);
      sprintf(name,"PemEta_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta");
      Hist.fPemEta_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemEta_a[i],Folder);
      sprintf(name,"PemPhi_a[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{ele}");
      Hist.fPemPhi_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemPhi_a[i],Folder);
      sprintf(name,"PemTheta_a[%i]",i);
      sprintf(title," %s%s",Folder,": event #theta_{ele}");
      Hist.fPemTheta_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTheta_a[i],Folder);
      sprintf(name,"PemEta_pes3x3_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron #eta, 3x3 #chi^{2} fit");
      Hist.fPemEta_pes3x3_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemEta_pes3x3_a[i],Folder);
      sprintf(name,"PemPhi_pes3x3_a[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{ele}, 3x3 #chi^{2} fit");
      Hist.fPemPhi_pes3x3_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemPhi_pes3x3_a[i],Folder);
      sprintf(name,"PemHadEm_a[%i]",i);
      sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
      Hist.fPemHadEm_a[i]= new TH1F(name,title,400,-0.5,1.5);
      AddHistogram(Hist.fPemHadEm_a[i],Folder);
      sprintf(name,"PemCalIso4_raw_a[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
      Hist.fPemCalIso4_raw_a[i]= new TH1F(name,title,110,-1.0,10.0);
      AddHistogram(Hist.fPemCalIso4_raw_a[i],Folder);
      sprintf(name,"PemCalIso4_corr_a[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
      Hist.fPemCalIso4_corr_a[i]= new TH1F(name,title,140,-4.0,10.0);
      AddHistogram(Hist.fPemCalIso4_corr_a[i],Folder);
      sprintf(name,"PemCalIso4Fr_raw_a[%i]",i);
      sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)/E_{T}");
      Hist.fPemCalIso4Fr_raw_a[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fPemCalIso4Fr_raw_a[i],Folder);
      sprintf(name,"PemCalIso4Fr_corr_a[%i]",i);
      sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)/E_{T}");
      Hist.fPemCalIso4Fr_corr_a[i]= new TH1F(name,title,100,-1.0,1.0);
      AddHistogram(Hist.fPemCalIso4Fr_corr_a[i],Folder);
      sprintf(name,"Pem3x3FitTwr_a[%i]",i);
      sprintf(title," %s%s",Folder,": 3x3 fit status code");
      Hist.fPem3x3FitTwr_a[i]= new TH1F(name,title,13,-1.5,11.5);
      AddHistogram(Hist.fPem3x3FitTwr_a[i],Folder);
      sprintf(name,"PemChi2Pes_a[%i]",i);
      sprintf(title," %s%s",Folder,": PES 3x3 #chi^{2}");
      Hist.fPemChi2Pes_a[i]= new TH1F(name,title,200,0.0,20.0);
      AddHistogram(Hist.fPemChi2Pes_a[i],Folder);
      sprintf(name,"PemPes5x9U_a[%i]",i);
      sprintf(title," %s%s",Folder,": PES 5x9 shower profile ratios (U)");
      Hist.fPemPes5x9U_a[i]= new TH1F(name,title,100,0.0,1.0);
      AddHistogram(Hist.fPemPes5x9U_a[i],Folder);
      sprintf(name,"PemPes5x9V_a[%i]",i);
      sprintf(title," %s%s",Folder,": PES 5x9 shower profile ratios (V)");
      Hist.fPemPes5x9V_a[i]= new TH1F(name,title,100,0.0,1.0);
      AddHistogram(Hist.fPemPes5x9V_a[i],Folder);
      sprintf(name,"PemConvStat_a[%i]",i);
      sprintf(title," %s%s",Folder,": Conversion status");
      Hist.fPemConvStat_a[i]= new TH1F(name,title,3,-1.5,1.5);
      AddHistogram(Hist.fPemConvStat_a[i],Folder);

      sprintf(name,"PemTrkPnxPt_a[%i]",i);
      sprintf(title," %s%s",Folder,": Phoenix track P_{T}");
      Hist.fPemTrkPnxPt_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPnxPt_a[i],Folder);
      sprintf(name,"PemTrkPt_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P_{T}");
      Hist.fPemTrkPt_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPt_a[i],Folder);
      sprintf(name,"PemTrkP_a[%i]",i);
      sprintf(title," %s%s",Folder,": Electron track P");
      Hist.fPemTrkP_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkP_a[i],Folder);
      sprintf(name,"PemTrkEta_a[%i]",i);
      sprintf(title," %s%s",Folder,": #eta_{trk}");
      Hist.fPemTrkEta_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemTrkEta_a[i],Folder);
      sprintf(name,"PemTrkPhi_a[%i]",i);
      sprintf(title," %s%s",Folder,": #phi_{trk}");
      Hist.fPemTrkPhi_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkPhi_a[i],Folder);
      sprintf(name,"PemTrkTheta_a[%i]",i);
      sprintf(title," %s%s",Folder,": #theta_{trk}");
      Hist.fPemTrkTheta_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkTheta_a[i],Folder);
      sprintf(name,"PemTrkPtBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P_{T}");
      Hist.fPemTrkPtBc_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPtBc_a[i],Folder);
      sprintf(name,"PemTrkPBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained track P");
      Hist.fPemTrkPBc_a[i]= new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fPemTrkPBc_a[i],Folder);
      sprintf(name,"PemTrkEtaBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #eta_{trk}");
      Hist.fPemTrkEtaBc_a[i]= new TH1F(name,title,200,-5.0,5.0);
      AddHistogram(Hist.fPemTrkEtaBc_a[i],Folder);
      sprintf(name,"PemTrkPhiBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #phi_{trk}");
      Hist.fPemTrkPhiBc_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkPhiBc_a[i],Folder);
      sprintf(name,"PemTrkThetaBc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained #theta_{trk}");
      Hist.fPemTrkThetaBc_a[i]= new TH1F(name,title,800,-1.0,7.0);
      AddHistogram(Hist.fPemTrkThetaBc_a[i],Folder);
      sprintf(name,"PemTrkZ0_a[%i]",i);
      sprintf(title," %s%s",Folder,": z_{trk}");
      Hist.fPemTrkZ0_a[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fPemTrkZ0_a[i],Folder);
      sprintf(name,"PemTrkZ0Bc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained z_{trk}");
      Hist.fPemTrkZ0Bc_a[i]= new TH1F(name,title,130,-65.0,65.0);
      AddHistogram(Hist.fPemTrkZ0Bc_a[i],Folder);
      sprintf(name,"PemTrkD0_a[%i]",i);
      sprintf(title," %s%s",Folder,": impact d_{0}");
      Hist.fPemTrkD0_a[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fPemTrkD0_a[i],Folder);
      sprintf(name,"PemTrkD0Bc_a[%i]",i);
      sprintf(title," %s%s",Folder,": beam-constrained impact d_{0}");
      Hist.fPemTrkD0Bc_a[i]= new TH1F(name,title,10000,-2.0,2.0);
      AddHistogram(Hist.fPemTrkD0Bc_a[i],Folder);
      sprintf(name,"PemTrkCharge_a[%i]",i);
      sprintf(title," %s%s",Folder,": track charge");
      Hist.fPemTrkCharge_a[i]= new TH1F(name,title,5,-2.5,2.5);
      AddHistogram(Hist.fPemTrkCharge_a[i],Folder);
      sprintf(name,"PemTrkRconv_a[%i]",i);
      sprintf(title," %s%s",Folder,": R_{conv} of track");
      Hist.fPemTrkRconv_a[i]= new TH1F(name,title,3000,-750.0,750.0);
      AddHistogram(Hist.fPemTrkRconv_a[i],Folder);
      sprintf(name,"PemTrkAlgoID_a[%i]",i);
      sprintf(title," %s%s",Folder,": track Algorithm");
      Hist.fPemTrkAlgoID_a[i]= new TH1F(name,title,40,-0.5,39.5);
      AddHistogram(Hist.fPemTrkAlgoID_a[i],Folder);
      sprintf(name,"PemTrkPesDeltaR_a[%i]",i);
      sprintf(title," %s%s",Folder,": PES-Trk #Delta R");
      Hist.fPemTrkPesDeltaR_a[i]= new TH1F(name,title,300,0.0,30.0);
      AddHistogram(Hist.fPemTrkPesDeltaR_a[i],Folder);
      sprintf(name,"PemPesDeltaR_a[%i]",i);
      sprintf(title," %s%s",Folder,": PES-PEM #Delta R");
      Hist.fPemPesDeltaR_a[i]= new TH1F(name,title,300,0.0,30.0);
      AddHistogram(Hist.fPemPesDeltaR_a[i],Folder);
      sprintf(name,"PemTrkSiHits_a[%i]",i);
      sprintf(title," %s%s",Folder,": number of Silicon hits");
      Hist.fPemTrkSiHits_a[i]= new TH1F(name,title,50,-0.5,49.5);
      AddHistogram(Hist.fPemTrkSiHits_a[i],Folder);
    }
}

void TMyZeeFilterModule::BookZeeHistograms(ZeeGeneral_t& Hist, const char* Folder) {
  char name [200];
  char title[200];
  //_______________________before cuts
  sprintf(name,"ZeeNCEMtight_b");
  sprintf(title," %s%s",Folder,": number of tight CEM electrons");
  Hist.fZeeNCEMtight_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNCEMtight_b,Folder);
  sprintf(name,"ZeeNCEMloose_b");
  sprintf(title," %s%s",Folder,": number of loose CEM electrons");
  Hist.fZeeNCEMloose_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNCEMloose_b,Folder);
  sprintf(name,"ZeeNPEMtight_b");
  sprintf(title," %s%s",Folder,": number of tight PEM electrons");
  Hist.fZeeNPEMtight_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNPEMtight_b,Folder);
  sprintf(name,"ZeeNPEMloose_b");
  sprintf(title," %s%s",Folder,": number of loose PEM electrons");
  Hist.fZeeNPEMloose_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNPEMloose_b,Folder);
  sprintf(name,"ZeeNele_b");
  sprintf(title," %s%s",Folder,": number of electrons which pass cuts");
  Hist.fZeeNele_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNele_b,Folder);
  sprintf(name,"ZeeNeleE_b");
  sprintf(title," %s%s",Folder,": number of extra electrons which pass cuts");
  Hist.fZeeNeleE_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNeleE_b,Folder);
  sprintf(name,"ZeeM_b");
  sprintf(title," %s%s",Folder,": M_{Zee} using electrons");
  Hist.fZeeM_b= new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fZeeM_b,Folder);
  sprintf(name,"ZeeMtrk_b");
  sprintf(title," %s%s",Folder,": M_{Zee} using tracks");
  Hist.fZeeMtrk_b= new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fZeeMtrk_b,Folder);
  sprintf(name,"ZeeE_b");
  sprintf(title," %s%s",Folder,": E of Zee candidate");
  Hist.fZeeE_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeE_b,Folder);
  sprintf(name,"ZeeEt_b");
  sprintf(title," %s%s",Folder,": E_{T} of Zee candidate");
  Hist.fZeeEt_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeEt_b,Folder);
  sprintf(name,"ZeePhi_b");
  sprintf(title," %s%s",Folder,": #phi of Zee candidate");
  Hist.fZeePhi_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fZeePhi_b,Folder);
  sprintf(name,"ZeeEta_b");
  sprintf(title," %s%s",Folder,": #eta of Zee candidate");
  Hist.fZeeEta_b= new TH1F(name,title,400,-10.0,10.0);
  AddHistogram(Hist.fZeeEta_b,Folder);
  sprintf(name,"ZeeTheta_b");
  sprintf(title," %s%s",Folder,": #theta of Zee candidate");
  Hist.fZeeTheta_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fZeeTheta_b,Folder);
  sprintf(name,"ZeeDeltaPhi_b");
  sprintf(title," %s%s",Folder,": #Delta#phi of two electrons");
  Hist.fZeeDeltaPhi_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fZeeDeltaPhi_b,Folder);
  sprintf(name,"ZeeDeltaEta_b");
  sprintf(title," %s%s",Folder,": #Delta#eta of two electrons");
  Hist.fZeeDeltaEta_b= new TH1F(name,title,800,-4.0,4.0);
  AddHistogram(Hist.fZeeDeltaEta_b,Folder);
  sprintf(name,"ZeeDeltaR_b");
  sprintf(title," %s%s",Folder,": #Delta R of two electrons");
  Hist.fZeeDeltaR_b= new TH1F(name,title,800,0.0,8.0);
  AddHistogram(Hist.fZeeDeltaR_b,Folder);

  sprintf(name,"ZeeFid_b");
  sprintf(title," %s%s",Folder,": fiduciality of Zee (CEM+CEM=0, PEM+CEM=1, PEM+PEM=2)");
  Hist.fZeeFid_b= new TH1F(name,title,3,-0.5,2.5);
  AddHistogram(Hist.fZeeFid_b,Folder);
  sprintf(name,"ZeeStat_b");
  sprintf(title," %s%s",Folder,": status of Zee (StatEle1+StatEle2)");
  Hist.fZeeStat_b= new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fZeeStat_b,Folder);
  sprintf(name,"ZeeQual_b");
  sprintf(title," %s%s",Folder,": quality of Zee (StatZ+FidZ)");
  Hist.fZeeQual_b= new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fZeeQual_b,Folder);
  sprintf(name,"ZeeCharge_b");
  sprintf(title," %s%s",Folder,": charge of Zee");
  Hist.fZeeCharge_b= new TH1F(name,title,5,-2.5,2.5);
  AddHistogram(Hist.fZeeCharge_b,Folder);

  for(int i=0; i<2; i++)
    {
      sprintf(name,"ZeeEleFid_b[%i]",i);
      sprintf(title," %s%s",Folder,": fiduciality of electron (CEM=0, PEM=1)");
      Hist.fZeeEleFid_b[i]= new TH1F(name,title,3,-0.5,2.5);
      AddHistogram(Hist.fZeeEleFid_b[i],Folder);
      sprintf(name,"ZeeEleStat_b[%i]",i);
      sprintf(title," %s%s",Folder,": status of electrons (tCEM=0, lCEM=7, tPEM=9, lPEM=11)");
      Hist.fZeeEleStat_b[i]= new TH1F(name,title,12,-0.5,11.5);
      AddHistogram(Hist.fZeeEleStat_b[i],Folder);      
    }

  sprintf(name,"ZeeNele3_M_b");
  sprintf(title," %s%s",Folder,": M_{ee} for events with N_{ele}=3 (3 combinations)");
  Hist.fZeeNele3_M_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeNele3_M_b,Folder);
  sprintf(name,"ZeeNele4_M_b");
  sprintf(title," %s%s",Folder,": M_{ee} for events with N_{ele}=4 (6 combinations)");
  Hist.fZeeNele4_M_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeNele4_M_b,Folder);

  sprintf(name,"ZeeNele3_M_Zlike_b");
  sprintf(title," %s%s",Folder,": M_{ee} for a pair with min(|M_{ee}-91.2|) in events with N_{ele}>2");
  Hist.fZeeNele3_M_Zlike_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeNele3_M_Zlike_b,Folder);
  sprintf(name,"ZeeNele4_M1_vs_M2_b");
  sprintf(title," %s%s",Folder,": M_{ee}(pair-1) vs. M_{ee}(pair-2) in events with N_{ele}>3");
  Hist.fZeeNele4_M1_vs_M2_b= new TH2F(name,title,100,0.0,200.0,100,0.0,200.0);
  AddHistogram(Hist.fZeeNele4_M1_vs_M2_b,Folder);

  //_______________________after cuts
  sprintf(name,"ZeeNCEMtight_a");
  sprintf(title," %s%s",Folder,": number of tight CEM electrons");
  Hist.fZeeNCEMtight_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNCEMtight_a,Folder);
  sprintf(name,"ZeeNCEMloose_a");
  sprintf(title," %s%s",Folder,": number of loose CEM electrons");
  Hist.fZeeNCEMloose_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNCEMloose_a,Folder);
  sprintf(name,"ZeeNPEMtight_a");
  sprintf(title," %s%s",Folder,": number of tight PEM electrons");
  Hist.fZeeNPEMtight_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNPEMtight_a,Folder);
  sprintf(name,"ZeeNPEMloose_a");
  sprintf(title," %s%s",Folder,": number of loose PEM electrons");
  Hist.fZeeNPEMloose_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNPEMloose_a,Folder);
  sprintf(name,"ZeeNele_a");
  sprintf(title," %s%s",Folder,": number of electrons which pass cuts");
  Hist.fZeeNele_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNele_a,Folder);
  sprintf(name,"ZeeNeleE_a");
  sprintf(title," %s%s",Folder,": number of extra electrons which pass cuts");
  Hist.fZeeNeleE_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fZeeNeleE_a,Folder);
  sprintf(name,"ZeeM_a");
  sprintf(title," %s%s",Folder,": M_{Zee} using electrons");
  Hist.fZeeM_a= new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fZeeM_a,Folder);
  sprintf(name,"ZeeMtrk_a");
  sprintf(title," %s%s",Folder,": M_{Zee} using tracks");
  Hist.fZeeMtrk_a= new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fZeeMtrk_a,Folder);
  sprintf(name,"ZeeE_a");
  sprintf(title," %s%s",Folder,": E of Zee candidate");
  Hist.fZeeE_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeE_a,Folder);
  sprintf(name,"ZeeEt_a");
  sprintf(title," %s%s",Folder,": E_{T} of Zee candidate");
  Hist.fZeeEt_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeEt_a,Folder);
  sprintf(name,"ZeePhi_a");
  sprintf(title," %s%s",Folder,": #phi of Zee candidate");
  Hist.fZeePhi_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fZeePhi_a,Folder);
  sprintf(name,"ZeeEta_a");
  sprintf(title," %s%s",Folder,": #eta of Zee candidate");
  Hist.fZeeEta_a= new TH1F(name,title,400,-10.0,10.0);
  AddHistogram(Hist.fZeeEta_a,Folder);
  sprintf(name,"ZeeTheta_a");
  sprintf(title," %s%s",Folder,": #theta of Zee candidate");
  Hist.fZeeTheta_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fZeeTheta_a,Folder);
  sprintf(name,"ZeeDeltaPhi_a");
  sprintf(title," %s%s",Folder,": #Delta#phi of two electrons");
  Hist.fZeeDeltaPhi_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fZeeDeltaPhi_a,Folder);
  sprintf(name,"ZeeDeltaEta_a");
  sprintf(title," %s%s",Folder,": #Delta#eta of two electrons");
  Hist.fZeeDeltaEta_a= new TH1F(name,title,800,-4.0,4.0);
  AddHistogram(Hist.fZeeDeltaEta_a,Folder);
  sprintf(name,"ZeeDeltaR_a");
  sprintf(title," %s%s",Folder,": #Delta R of two electrons");
  Hist.fZeeDeltaR_a= new TH1F(name,title,800,0.0,8.0);
  AddHistogram(Hist.fZeeDeltaR_a,Folder);

  sprintf(name,"ZeeFid_a");
  sprintf(title," %s%s",Folder,": fiduciality of Zee (0=CEM+CEM, 1=PEM+CEM, 2=PEM+PEM)");
  Hist.fZeeFid_a= new TH1F(name,title,3,-0.5,2.5);
  AddHistogram(Hist.fZeeFid_a,Folder);
  sprintf(name,"ZeeStat_a");
  sprintf(title," %s%s",Folder,": status of Zee (StatEle1+StatEle2)");
  Hist.fZeeStat_a= new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fZeeStat_a,Folder);
  sprintf(name,"ZeeQual_a");
  sprintf(title," %s%s",Folder,": quality of Zee (StatZ+FidZ)");
  Hist.fZeeQual_a= new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fZeeQual_a,Folder);
  sprintf(name,"ZeeCharge_a");
  sprintf(title," %s%s",Folder,": charge of Zee");
  Hist.fZeeCharge_a= new TH1F(name,title,5,-2.5,2.5);
  AddHistogram(Hist.fZeeCharge_a,Folder);

  for(int i=0; i<2; i++)
    {
      sprintf(name,"ZeeEleFid_a[%i]",i);
      sprintf(title," %s%s",Folder,": fiduciality of electron (0=CEM, 1=PEM)");
      Hist.fZeeEleFid_a[i]= new TH1F(name,title,3,-0.5,2.5);
      AddHistogram(Hist.fZeeEleFid_a[i],Folder);
      sprintf(name,"ZeeEleStat_a[%i]",i);
      sprintf(title," %s%s",Folder,": status of electrons (tCEM=0, lCEM=7, tPEM=9, lPEM=11)");
      Hist.fZeeEleStat_a[i]= new TH1F(name,title,12,-0.5,11.5);
      AddHistogram(Hist.fZeeEleStat_a[i],Folder);      
    }

  sprintf(name,"ZeeNele3_M_a");
  sprintf(title," %s%s",Folder,": M_{ee} for events with N_{ele}=3 (3 combinations)");
  Hist.fZeeNele3_M_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeNele3_M_a,Folder);
  sprintf(name,"ZeeNele4_M_a");
  sprintf(title," %s%s",Folder,": M_{ee} for events with N_{ele}=4 (6 combinations)");
  Hist.fZeeNele4_M_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeNele4_M_a,Folder);

  sprintf(name,"ZeeNele3_M_Zlike_a");
  sprintf(title," %s%s",Folder,": M_{ee} for a pair with min(|M_{ee}-91.2|) in events with N_{ele}>2");
  Hist.fZeeNele3_M_Zlike_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fZeeNele3_M_Zlike_a,Folder);
  sprintf(name,"ZeeNele4_M1_vs_M2_a");
  sprintf(title," %s%s",Folder,": M_{ee}(pair-1) vs. M_{ee}(pair-2) in events with N_{ele}>3");
  Hist.fZeeNele4_M1_vs_M2_a= new TH2F(name,title,100,0.0,200.0,100,0.0,200.0);
  AddHistogram(Hist.fZeeNele4_M1_vs_M2_a,Folder);

}

void TMyZeeFilterModule::BookConversionHistograms(ConversionHisto_t& Hist, const char* Folder) {
  char name [200];
  char title[200];

  for(int i=0; i<2; i++)
    {
      sprintf(name,"Ncand[%i]",i);
      sprintf(title," %s%s",Folder,": Number of conversion partners");
      Hist.fConvNcand[i]= new TH1F(name,title,10,-0.5,9.5);	
      AddHistogram(Hist.fConvNcand[i],Folder);
      sprintf(name,"R[%i]",i);
      sprintf(title," %s%s",Folder,": R, radius of best conversion pair");
      Hist.fConvR[i]= new TH1F(name,title,300,0.0,60.0);	
      AddHistogram(Hist.fConvR[i],Folder);
      sprintf(name,"XYsep[%i]",i);
      sprintf(title," %s%s",Folder,": XY separation of best conversion pair");
      Hist.fConvXYsep[i]= new TH1F(name,title,400,-2.0,2.0);	
      AddHistogram(Hist.fConvXYsep[i],Folder);
      sprintf(name,"DelLam[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta Cot(#theta) of best conversion pair");
      Hist.fConvDelLam[i]= new TH1F(name,title,100,-0.2,0.2);	
      AddHistogram(Hist.fConvDelLam[i],Folder);
      sprintf(name,"Chi2[%i]",i);
      sprintf(title," %s%s",Folder,": my #chi^{2} of best conversion pair");
      Hist.fConvChi2[i]= new TH1F(name,title,200,0.0,2.0);	
      AddHistogram(Hist.fConvChi2[i],Folder);
      sprintf(name,"MyRconv[%i]",i);
      sprintf(title," %s%s",Folder,": my R_{conv}, radius of best conversion candidate");
      Hist.fConvMyRconv[i]= new TH1F(name,title,400,-100.0,100.0);	
      AddHistogram(Hist.fConvMyRconv[i],Folder);
      sprintf(name,"DeltaR[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta R= myR_{conv1}-myR_{conv2} of best conversion pair");
      Hist.fConvDeltaR[i]= new TH1F(name,title,800,-200.0,200.0);	
      AddHistogram(Hist.fConvDeltaR[i],Folder);
      sprintf(name,"D0[%i]",i);
      sprintf(title," %s%s",Folder,": impact parameter, D_{0}, of conversion photon");
      Hist.fConvD0[i]= new TH1F(name,title,1000,-2.0,2.0);	
      AddHistogram(Hist.fConvD0[i],Folder);
      sprintf(name,"TrkAlgoID[%i]",i);
      sprintf(title," %s%s",Folder,": Track Algorithm ID of best conversion candidate");
      Hist.fConvTrkAlgoID[i]= new TH1F(name,title,40,-0.5,39.5);	
      AddHistogram(Hist.fConvTrkAlgoID[i],Folder);
      sprintf(name,"EleInd[%i]",i);
      sprintf(title," %s%s",Folder,": Ind+1 of best matching electron (0--no match)");
      Hist.fConvEleInd[i]= new TH1F(name,title,10,-0.5,9.5);	
      AddHistogram(Hist.fConvEleInd[i],Folder);
      sprintf(name,"DeltaPhi[%i]",i);
      sprintf(title," %s%s",Folder,": #Delta#phi of conversion photon and electron");
      Hist.fConvDeltaPhi[i]= new TH1F(name,title,800,-4.0,4.0);	
      AddHistogram(Hist.fConvDeltaPhi[i],Folder);
    }
  sprintf(name,"MyRconv1R");
  sprintf(title," %s%s",Folder,": #Delta R= myR_{parent ele}-R_{pair} of best conversion pair");
  Hist.fConvMyRconv1R= new TH1F(name,title,800,-200.0,200.0);	
  AddHistogram(Hist.fConvMyRconv1R,Folder);
  sprintf(name,"MyRconv2R");
  sprintf(title," %s%s",Folder,": #Delta R= myR_{daughter ele}-R_{pair} of best conversion pair");
  Hist.fConvMyRconv2R= new TH1F(name,title,800,-200.0,200.0);	
  AddHistogram(Hist.fConvMyRconv2R,Folder);
  sprintf(name,"MyRconvEle");
  sprintf(title," %s%s",Folder,": my R_{conv} of original electron");
  Hist.fConvMyRconvEle= new TH1F(name,title,400,-100.0,100.0);	
  AddHistogram(Hist.fConvMyRconvEle,Folder);

  sprintf(name,"TriD0");
  sprintf(title," %s%s",Folder,": impact parameter, D_{0}, of 2^{nd} photon from trident");
  Hist.fConvTriD0= new TH1F(name,title,1000,-2.0,2.0);	
  AddHistogram(Hist.fConvTriD0,Folder);
  sprintf(name,"TriR");
  sprintf(title," %s%s",Folder,": R, radius of 2^{nd} e+e- pair from trident");
  Hist.fConvTriR= new TH1F(name,title,300,0.0,60.0);	
  AddHistogram(Hist.fConvTriR,Folder);
  sprintf(name,"TriMyRconv");
  sprintf(title," %s%s",Folder,": my R_{conv} of 3^{rd} electron from trident");
  Hist.fConvTriMyRconv= new TH1F(name,title,400,-100.0,100.0);	
  AddHistogram(Hist.fConvTriMyRconv,Folder);
  sprintf(name,"TriDeltaR");
  sprintf(title," %s%s",Folder,": #Delta R= myR_{conv2}-myR_{conv3} for 2^{nd} e+e- pair from trident");
  Hist.fConvTriDeltaR= new TH1F(name,title,800,-200.0,200.0);	
  AddHistogram(Hist.fConvTriDeltaR,Folder);

  return;
}

//_____________________________________________________________________________
void TMyZeeFilterModule::BookHistograms() {
  
  TFolder* fol;
  TFolder* hist_folder;
  
  char folder_name[200];
  //-----------------------------------------------------------------------------
  //  clear the histogram list
  //-----------------------------------------------------------------------------
  DeleteHistograms();
  hist_folder = (TFolder*) GetFolder()->FindObject("Hist");
  //-----------------------------------------------------------------------------
  //  general electron histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"GeneralEle");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookEleGeneralHistograms(fEleHist,Form("Hist/%s",folder_name));
  //-----------------------------------------------------------------------------
  //  CEM electron histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"CemEle");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookCEMHistograms(fCEMHist,Form("Hist/%s",folder_name));
  //-----------------------------------------------------------------------------
  //  Conversion histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"Conversion");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookConversionHistograms(fConvHist,Form("Hist/%s",folder_name));
  //-----------------------------------------------------------------------------
  //  PEM electron histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"PemEle");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookPEMHistograms(fPEMHist,Form("Hist/%s",folder_name));
  //-----------------------------------------------------------------------------
  //  Zee histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"Zee");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookZeeHistograms(fZeeHist,Form("Hist/%s",folder_name));

  return;
}

void TMyZeeFilterModule::FillEleGeneralHistogramsB(ElectronGeneral_t& Hist, 
						   TStnElectron* Ele) {
  Hist.fEleDetector_b->Fill(Ele->DetectorCode()); 
  Hist.fEleEt_raw_b->Fill(Ele->ClusterEt());
  Hist.fEleEt_corr_b->Fill(Ele->Etcor());    // make sure it is correction 
  Hist.fEleEt_b->Fill(myCorrEtEle(Ele)); 
  Hist.fEleE_em_b->Fill(myCorrEnergyEle(Ele));                
  Hist.fEleE_total_b->Fill(Ele->TotalE());    
  Hist.fEleEta_det_b->Fill(Ele->DetEta()); 
  Hist.fEleEta_b->Fill(Ele->EmClusEvEta());
  Hist.fElePhi_b->Fill(Ele->EmClusPhi());
  Hist.fEleTheta_b->Fill(2.0*atan(exp(-1.0*Ele->EmClusEvEta())));                   
  Hist.fEleHadEm_b->Fill(Ele->HadEm());
  Hist.fEleCalIso4_raw_b->Fill(Ele->Iso());   
  Hist.fEleCalIso4_corr_b->Fill(myCorrIso(Ele));
  Hist.fEleCalIso4Fr_raw_b->Fill((Ele->Iso())/(Ele->Et())); 
  Hist.fEleCalIso4Fr_corr_b->Fill(myCorrIsoFr(Ele)); 
} 

void TMyZeeFilterModule::FillEleGeneralHistogramsA(ElectronGeneral_t& Hist, 
						   TStnElectron* Ele) {
  Hist.fEleDetector_a->Fill(Ele->DetectorCode()); 
  Hist.fEleEt_raw_a->Fill(Ele->ClusterEt());
  Hist.fEleEt_corr_a->Fill(Ele->Etcor());    // make sure it is correction 
  Hist.fEleEt_a->Fill(myCorrEtEle(Ele)); 
  Hist.fEleE_em_a->Fill(myCorrEnergyEle(Ele));                
  Hist.fEleE_total_a->Fill(Ele->TotalE());    
  Hist.fEleEta_det_a->Fill(Ele->DetEta()); 
  Hist.fEleEta_a->Fill(Ele->EmClusEvEta());
  Hist.fElePhi_a->Fill(Ele->EmClusPhi());
  Hist.fEleTheta_a->Fill(2.0*atan(exp(-1.0*Ele->EmClusEvEta())));                   
  Hist.fEleHadEm_a->Fill(Ele->HadEm());
  Hist.fEleCalIso4_raw_a->Fill(Ele->Iso());   
  Hist.fEleCalIso4_corr_a->Fill(myCorrIso(Ele));
  Hist.fEleCalIso4Fr_raw_a->Fill((Ele->Iso())/(Ele->Et())); 
  Hist.fEleCalIso4Fr_corr_a->Fill(myCorrIsoFr(Ele)); 
} 

void TMyZeeFilterModule::FillCEMHistogramsB(CEMElectron_t& Hist, 
					    TStnElectron* Ele, TStnTrack* Trk, int eleInd, int convStat) {
    //_______________________before cuts

  if(eleInd>=0 && eleInd<2 && (Ele->DetectorCode())==0)
    {
      //      double trkBcTheta=atan(1.0/(Ele->TrackBcLam0()));
      //     Hist.fCemNtower_b[eleInd]->Fill();                 // number of towers in the cluster
      Hist.fCemEt_raw_b[eleInd]->Fill(Ele->ClusterEt()); 
      Hist.fCemEt_corr_b[eleInd]->Fill(Ele->Etcor());
      Hist.fCemEt_b[eleInd]->Fill(myCorrEtEle(Ele)); 
      Hist.fCemE_em_b[eleInd]->Fill(myCorrEnergyEle(Ele));                
      Hist.fCemE_total_b[eleInd]->Fill(Ele->TotalE());    
      Hist.fCemEta_det_b[eleInd]->Fill(Ele->DetEta());
      Hist.fCemEta_b[eleInd]->Fill(Ele->EmClusEvEta());
      Hist.fCemPhi_b[eleInd]->Fill(Ele->EmClusPhi());
      Hist.fCemTheta_b[eleInd]->Fill(2.0*atan(exp(-1.0*Ele->EmClusEvEta()))); 
      Hist.fCemHadEm_b[eleInd]->Fill(Ele->HadEm());
      Hist.fCemLshr_b[eleInd]->Fill(Ele->Lshr());
      Hist.fCemCalIso4_raw_b[eleInd]->Fill(Ele->Iso()); 
      Hist.fCemCalIso4_corr_b[eleInd]->Fill(myCorrIso(Ele)); 
      Hist.fCemCalIso4Fr_raw_b[eleInd]->Fill((Ele->Iso())/(Ele->ClusterEt())); 
      Hist.fCemCalIso4Fr_corr_b[eleInd]->Fill(myCorrIsoFr(Ele));   
      Hist.fCemChi2strip_b[eleInd]->Fill(Ele->Chi2Strip());
      Hist.fCemChi2_b[eleInd]->Fill(Ele->Chi2Mean());      
      Hist.fCemFid_b[eleInd]->Fill(Ele->FidCode());
      Hist.fCemFidCes_b[eleInd]->Fill(Ele->FidEleSmx());
      Hist.fCemFidTrk_b[eleInd]->Fill(Ele->FidEleTrk());
      Hist.fCemConvStat_b[eleInd]->Fill(convStat);
      Hist.fCemEP_b[eleInd]->Fill(Ele->EOverP());
      Hist.fCemEleXces_b[eleInd]->Fill(Ele->XCes());
      if(Trk!=NULL)
	{
	  if((Trk->Algorithm())==2) Hist.fCemTrkXces_b[eleInd]->Fill(Ele->XBcTrkCes());
	  else Hist.fCemTrkXces_b[eleInd]->Fill(Ele->TrackXCes());
	}
//----------- Modified part ---------------------------------------
//
      Hist.fCemTrkPt_b[eleInd]->Fill(Ele->TrackPt());
      Hist.fCemTrkPtBc_b[eleInd]->Fill(Ele->TrackBcPt());
      Hist.fCemTrkPBc_b[eleInd]->Fill(Ele->BcE());              
      Hist.fCemTrkPhi_b[eleInd]->Fill(Ele->TrackPhi());
      Hist.fCemTrkPhiBc_b[eleInd]->Fill(Ele->TrackBcPhi0());
      Hist.fCemTrkCotAx_b[eleInd]->Fill(Ele->Nasl()); 
      Hist.fCemTrkCotSt_b[eleInd]->Fill(Ele->Nssl());       
      if(Trk!=NULL)
	{
	  Hist.fCemTrkP_b[eleInd]->Fill(Trk->Momentum()->P()); 
	  Hist.fCemTrkTheta_b[eleInd]->Fill(Trk->Momentum()->Theta());
	  //	  Hist.fCemTrkThetaBc_b[eleInd]->Fill(trkBcTheta);            
	  Hist.fCemTrkEta_b[eleInd]->Fill(Trk->Eta()); 
	  //	  Hist.fCemTrkEtaBc_b[eleInd]->Fill(-log(tan(trkBcTheta/2.0)));
	  Hist.fCemTrkD0Bc_b[eleInd]->Fill(Trk->BcD0()); 
	  Hist.fCemTrkCharge_b[eleInd]->Fill(Trk->Charge());
	  Hist.fCemTrkRconv_b[eleInd]->Fill(myRawRconv(Trk)); 
	  Hist.fCemTrkAlgoID_b[eleInd]->Fill(Trk->Algorithm());
	  Hist.fCemTrkCotAxHits_b[eleInd]->Fill(Trk->NCotHitsAx()); 
	  Hist.fCemTrkCotStHits_b[eleInd]->Fill(Trk->NCotHitsSt());

	  Hist.fCemTrkCorrDelPhi_b[eleInd]->Fill((Trk->Phi0())-myPhi0_corr(myBeam,myBeamSlope,Trk));
	  Hist.fCemTrkCorrD0_b[eleInd]->Fill(myD0_corr(myBeam,myBeamSlope,Trk));
	}
//----------- End of Modified part ---------------------------------------

      Hist.fCemTrkDeltaX_b[eleInd]->Fill(Ele->DelX());
      Hist.fCemTrkDeltaXBc_b[eleInd]->Fill(Ele->BcDelX()); 
      Hist.fCemTrkQDeltaX_b[eleInd]->Fill(Ele->DelXQ());
      Hist.fCemTrkQDeltaXBc_b[eleInd]->Fill(Ele->BcDelXQ());
      Hist.fCemTrkDeltaZ_b[eleInd]->Fill(Ele->DelZ());
      Hist.fCemTrkDeltaZBc_b[eleInd]->Fill(Ele->BcDelZ());
      Hist.fCemTrkZ0_b[eleInd]->Fill(Ele->Z0());
      Hist.fCemTrkZ0Bc_b[eleInd]->Fill(Ele->TrackBcZ0()); 
      Hist.fCemTrkD0_b[eleInd]->Fill(Ele->D0());
    }
}

void TMyZeeFilterModule::FillCEMHistogramsA(CEMElectron_t& Hist, 
					    TStnElectron* Ele, TStnTrack* Trk, int eleInd, int convStat) {
    //_______________________after cuts

  if(eleInd>=0 && eleInd<2 && (Ele->DetectorCode())==0)
    {
      //      double trkBcTheta=acot(Ele->TrackBcLam0());
      //     Hist.fCemNtower_a[eleInd]->Fill();                 // number of towers in the cluster
      Hist.fCemEt_raw_a[eleInd]->Fill(Ele->ClusterEt()); 
      Hist.fCemEt_corr_a[eleInd]->Fill(Ele->Etcor());
      Hist.fCemEt_a[eleInd]->Fill(myCorrEtEle(Ele)); 
      Hist.fCemE_em_a[eleInd]->Fill(myCorrEnergyEle(Ele));                
      Hist.fCemE_total_a[eleInd]->Fill(Ele->TotalE());    
      Hist.fCemEta_det_a[eleInd]->Fill(Ele->DetEta());
      Hist.fCemEta_a[eleInd]->Fill(Ele->EmClusEvEta());
      Hist.fCemPhi_a[eleInd]->Fill(Ele->EmClusPhi());
      Hist.fCemTheta_a[eleInd]->Fill(2.0*atan(exp(-1.0*Ele->EmClusEvEta()))); 
      Hist.fCemHadEm_a[eleInd]->Fill(Ele->HadEm());
      Hist.fCemLshr_a[eleInd]->Fill(Ele->Lshr());
      Hist.fCemCalIso4_raw_a[eleInd]->Fill(Ele->Iso()); 
      Hist.fCemCalIso4_corr_a[eleInd]->Fill(myCorrIso(Ele)); 
      Hist.fCemCalIso4Fr_raw_a[eleInd]->Fill((Ele->Iso())/(Ele->ClusterEt())); 
      Hist.fCemCalIso4Fr_corr_a[eleInd]->Fill(myCorrIsoFr(Ele));   
      Hist.fCemChi2strip_a[eleInd]->Fill(Ele->Chi2Strip());
      Hist.fCemChi2_a[eleInd]->Fill(Ele->Chi2Mean());      
      Hist.fCemFid_a[eleInd]->Fill(Ele->FidCode());
      Hist.fCemFidCes_a[eleInd]->Fill(Ele->FidEleSmx());
      Hist.fCemFidTrk_a[eleInd]->Fill(Ele->FidEleTrk());
      Hist.fCemConvStat_a[eleInd]->Fill(convStat);
      Hist.fCemEP_a[eleInd]->Fill(Ele->EOverP());
      Hist.fCemEleXces_a[eleInd]->Fill(Ele->XCes());
      if(Trk!=NULL)
	{
	  if((Trk->Algorithm())==2) Hist.fCemTrkXces_a[eleInd]->Fill(Ele->XBcTrkCes());
	  else Hist.fCemTrkXces_a[eleInd]->Fill(Ele->TrackXCes());
	}

//----------- Modified part ---------------------------------------
//
      Hist.fCemTrkPt_a[eleInd]->Fill(Ele->TrackPt());
      Hist.fCemTrkPtBc_a[eleInd]->Fill(Ele->TrackBcPt());
      Hist.fCemTrkPBc_a[eleInd]->Fill(Ele->BcE());              
      Hist.fCemTrkPhi_a[eleInd]->Fill(Ele->TrackPhi());
      Hist.fCemTrkPhiBc_a[eleInd]->Fill(Ele->TrackBcPhi0());
      Hist.fCemTrkCotAx_a[eleInd]->Fill(Ele->Nasl()); 
      Hist.fCemTrkCotSt_a[eleInd]->Fill(Ele->Nssl());       
      if(Trk!=NULL)
	{
	  Hist.fCemTrkP_a[eleInd]->Fill(Trk->Momentum()->P()); 
	  Hist.fCemTrkTheta_a[eleInd]->Fill(Trk->Momentum()->Theta());
	  //	  Hist.fCemTrkThetaBc_a[eleInd]->Fill(trkBcTheta);            
	  Hist.fCemTrkEta_a[eleInd]->Fill(Trk->Eta()); 
	  //	  Hist.fCemTrkEtaBc_a[eleInd]->Fill(-log(tan(trkBcTheta/2.0)));
	  Hist.fCemTrkD0Bc_a[eleInd]->Fill(Trk->BcD0()); 
	  Hist.fCemTrkCharge_a[eleInd]->Fill(Trk->Charge());
	  Hist.fCemTrkRconv_a[eleInd]->Fill(myRawRconv(Trk)); 
	  Hist.fCemTrkAlgoID_a[eleInd]->Fill(Trk->Algorithm());
	  Hist.fCemTrkCotAxHits_a[eleInd]->Fill(Trk->NCotHitsAx()); 
	  Hist.fCemTrkCotStHits_a[eleInd]->Fill(Trk->NCotHitsSt());

	  Hist.fCemTrkCorrDelPhi_a[eleInd]->Fill((Trk->Phi0())-myPhi0_corr(myBeam,myBeamSlope,Trk));
	  Hist.fCemTrkCorrD0_a[eleInd]->Fill(myD0_corr(myBeam,myBeamSlope,Trk));
	}
//----------- End of Modified part ---------------------------------------

      Hist.fCemTrkDeltaX_a[eleInd]->Fill(Ele->DelX());
      Hist.fCemTrkDeltaXBc_a[eleInd]->Fill(Ele->BcDelX()); 
      Hist.fCemTrkQDeltaX_a[eleInd]->Fill(Ele->DelXQ());
      Hist.fCemTrkQDeltaXBc_a[eleInd]->Fill(Ele->BcDelXQ());
      Hist.fCemTrkDeltaZ_a[eleInd]->Fill(Ele->DelZ());
      Hist.fCemTrkDeltaZBc_a[eleInd]->Fill(Ele->BcDelZ());
      Hist.fCemTrkZ0_a[eleInd]->Fill(Ele->Z0());
      Hist.fCemTrkZ0Bc_a[eleInd]->Fill(Ele->TrackBcZ0()); 
      Hist.fCemTrkD0_a[eleInd]->Fill(Ele->D0());
    }
}

void TMyZeeFilterModule::FillPEMHistogramsB(PEMElectron_t& Hist, TStnEvent* Event,
					    TStnElectron* Ele, TStnTrack* Trk, int eleInd, int convStat) {
    //_______________________before cuts

  if(eleInd>=0 && eleInd<2 && (Ele->DetectorCode())==1)
    {
      double E_em=myCorrEnergyEle(Ele);
      double Et_em=myCorrEtEle(Ele);
      double E_tot=E_em*(1.0+Ele->HadEm()); // don't use it

      //     Hist.fPemNtower_b[eleInd]->Fill();                 // number of towers in the cluster
      Hist.fPemEt_raw_b[eleInd]->Fill(Ele->ClusterEt()); 
      Hist.fPemEt_corr_b[eleInd]->Fill(Ele->Etcor());
      Hist.fPemEt_b[eleInd]->Fill(Et_em); 
      Hist.fPemE_em_b[eleInd]->Fill(E_em);                
      Hist.fPemE_ppr_b[eleInd]->Fill(Ele->PprEnergy());                
      Hist.fPemE_total_b[eleInd]->Fill(E_tot);
      Hist.fPemEta_det_b[eleInd]->Fill(Ele->DetEta());
      Hist.fPemEta_b[eleInd]->Fill(Ele->EmClusEvEta());
      Hist.fPemPhi_b[eleInd]->Fill(Ele->EmClusPhi());
      Hist.fPemTheta_b[eleInd]->Fill(2.0*atan(exp(-1.0*Ele->EmClusEvEta()))); 
      Hist.fPemHadEm_b[eleInd]->Fill(Ele->HadEm());
      Hist.fPemEta_pes3x3_b[eleInd]->Fill(Ele->Pem3x3Eta());             
      Hist.fPemPhi_pes3x3_b[eleInd]->Fill(Ele->Pem3x3Phi());             
      Hist.fPemCalIso4_raw_b[eleInd]->Fill(Ele->Iso()); 
      Hist.fPemCalIso4_corr_b[eleInd]->Fill(myCorrIso(Ele)); 
      Hist.fPemCalIso4Fr_raw_b[eleInd]->Fill((Ele->Iso())/(Ele->ClusterEt())); 
      Hist.fPemCalIso4Fr_corr_b[eleInd]->Fill(myCorrIsoFr(Ele));   
      Hist.fPem3x3FitTwr_b[eleInd]->Fill(Ele->Pem3x3FitTower()); 
      Hist.fPemChi2Pes_b[eleInd]->Fill(Ele->Chi2Three());
      Hist.fPemPes5x9U_b[eleInd]->Fill(Ele->Pes5x9(0));               
      Hist.fPemPes5x9V_b[eleInd]->Fill(Ele->Pes5x9(1));               
      Hist.fPemConvStat_b[eleInd]->Fill(convStat);
      
//----------- Modified part ---------------------------------------
//
      Hist.fPemTrkPt_b[eleInd]->Fill(Ele->TrackPt());
      Hist.fPemTrkPtBc_b[eleInd]->Fill(Ele->TrackBcPt());
      Hist.fPemTrkPBc_b[eleInd]->Fill(Ele->BcE());              
      Hist.fPemTrkPhi_b[eleInd]->Fill(Ele->TrackPhi());
      Hist.fPemTrkPhiBc_b[eleInd]->Fill(Ele->TrackBcPhi0());
      if(Trk!=NULL)
	{
	  Hist.fPemTrkP_b[eleInd]->Fill(Trk->Momentum()->P()); 
	  Hist.fPemTrkPnxPt_b[eleInd]->Fill(Trk->Momentum()->Pt()); 
	  Hist.fPemTrkTheta_b[eleInd]->Fill(Trk->Momentum()->Theta());
	  //	  Hist.fPemTrkThetaBc_b[eleInd]->Fill(trkBcTheta);            
	  Hist.fPemTrkEta_b[eleInd]->Fill(Trk->Eta()); 
	  //	  Hist.fPemTrkEtaBc_b[eleInd]->Fill(-log(tan(trkBcTheta/2.0)));
	  Hist.fPemTrkD0Bc_b[eleInd]->Fill(Trk->BcD0()); 
	  Hist.fPemTrkCharge_b[eleInd]->Fill(Trk->Charge());
	  Hist.fPemTrkRconv_b[eleInd]->Fill(myRawRconv(Trk)); 
	  Hist.fPemTrkAlgoID_b[eleInd]->Fill(Trk->Algorithm());
	  Hist.fPemTrkSiHits_b[eleInd]->Fill(Trk->NSvxHits());
	}

//----------- End of Modified part ---------------------------------------

      Hist.fPemTrkZ0_b[eleInd]->Fill(Ele->Z0());
      Hist.fPemTrkZ0Bc_b[eleInd]->Fill(Ele->TrackBcZ0()); 
      Hist.fPemTrkD0_b[eleInd]->Fill(Ele->D0());
      Hist.fPemTrkPesDeltaR_b[eleInd]->Fill(Ele->PesTrkDeltaR());
      TStnPhoton* myPho=TPhotonUtil::MatchPhoton(Event,Ele);
      Hist.fPemPesDeltaR_b[eleInd]->Fill(myPho->PesDeltaR());
    }
}

void TMyZeeFilterModule::FillPEMHistogramsA(PEMElectron_t& Hist, TStnEvent* Event, 
					    TStnElectron* Ele, TStnTrack* Trk, int eleInd, int convStat) {
    //_______________________before cuts

  if(eleInd>=0 && eleInd<2 && (Ele->DetectorCode())==1)
    {
      double E_em=myCorrEnergyEle(Ele);
      double Et_em=myCorrEtEle(Ele);
      double E_tot=E_em*(1.0+Ele->HadEm()); // don't use it

      //     Hist.fPemNtower_a[eleInd]->Fill();                 // number of towers in the cluster
      Hist.fPemEt_raw_a[eleInd]->Fill(Ele->ClusterEt()); 
      Hist.fPemEt_corr_a[eleInd]->Fill(Ele->Etcor());
      Hist.fPemEt_a[eleInd]->Fill(Et_em); 
      Hist.fPemE_em_a[eleInd]->Fill(E_em);                
      Hist.fPemE_ppr_a[eleInd]->Fill(Ele->PprEnergy());                
      Hist.fPemE_total_a[eleInd]->Fill(E_tot);
      Hist.fPemEta_det_a[eleInd]->Fill(Ele->DetEta());
      Hist.fPemEta_a[eleInd]->Fill(Ele->EmClusEvEta());
      Hist.fPemPhi_a[eleInd]->Fill(Ele->EmClusPhi());
      Hist.fPemTheta_a[eleInd]->Fill(2.0*atan(exp(-1.0*Ele->EmClusEvEta()))); 
      Hist.fPemHadEm_a[eleInd]->Fill(Ele->HadEm());
      Hist.fPemEta_pes3x3_a[eleInd]->Fill(Ele->Pem3x3Eta());             
      Hist.fPemPhi_pes3x3_a[eleInd]->Fill(Ele->Pem3x3Phi());             
      Hist.fPemCalIso4_raw_a[eleInd]->Fill(Ele->Iso()); 
      Hist.fPemCalIso4_corr_a[eleInd]->Fill(myCorrIso(Ele)); 
      Hist.fPemCalIso4Fr_raw_a[eleInd]->Fill((Ele->Iso())/(Ele->ClusterEt())); 
      Hist.fPemCalIso4Fr_corr_a[eleInd]->Fill(myCorrIsoFr(Ele));   
      Hist.fPem3x3FitTwr_a[eleInd]->Fill(Ele->Pem3x3FitTower()); 
      Hist.fPemChi2Pes_a[eleInd]->Fill(Ele->Chi2Three());
      Hist.fPemPes5x9U_a[eleInd]->Fill(Ele->Pes5x9(0));               
      Hist.fPemPes5x9V_a[eleInd]->Fill(Ele->Pes5x9(1));               
      Hist.fPemConvStat_a[eleInd]->Fill(convStat);
//----------- Modified part ---------------------------------------
//
      Hist.fPemTrkPt_a[eleInd]->Fill(Ele->TrackPt());
      Hist.fPemTrkPtBc_a[eleInd]->Fill(Ele->TrackBcPt());
      Hist.fPemTrkPBc_a[eleInd]->Fill(Ele->BcE());              
      Hist.fPemTrkPhi_a[eleInd]->Fill(Ele->TrackPhi());
      Hist.fPemTrkPhiBc_a[eleInd]->Fill(Ele->TrackBcPhi0());
      if(Trk!=NULL)
	{
	  Hist.fPemTrkP_a[eleInd]->Fill(Trk->Momentum()->P()); 
	  Hist.fPemTrkPnxPt_a[eleInd]->Fill(Trk->Momentum()->Pt()); 
	  Hist.fPemTrkTheta_a[eleInd]->Fill(Trk->Momentum()->Theta());
	  //	  Hist.fPemTrkThetaBc_a[eleInd]->Fill(trkBcTheta);            
	  Hist.fPemTrkEta_a[eleInd]->Fill(Trk->Eta()); 
	  //	  Hist.fPemTrkEtaBc_a[eleInd]->Fill(-log(tan(trkBcTheta/2.0)));
	  Hist.fPemTrkD0Bc_a[eleInd]->Fill(Trk->BcD0()); 
	  Hist.fPemTrkCharge_a[eleInd]->Fill(Trk->Charge());
	  Hist.fPemTrkRconv_a[eleInd]->Fill(myRawRconv(Trk)); 
	  Hist.fPemTrkAlgoID_a[eleInd]->Fill(Trk->Algorithm());
	  Hist.fPemTrkSiHits_a[eleInd]->Fill(Trk->NSvxHits());
	}

//----------- End of Modified part ---------------------------------------

      Hist.fPemTrkZ0_a[eleInd]->Fill(Ele->Z0());
      Hist.fPemTrkZ0Bc_a[eleInd]->Fill(Ele->TrackBcZ0()); 
      Hist.fPemTrkD0_a[eleInd]->Fill(Ele->D0());
      Hist.fPemTrkPesDeltaR_a[eleInd]->Fill(Ele->PesTrkDeltaR());
      TStnPhoton* myPho=TPhotonUtil::MatchPhoton(Event,Ele);
      Hist.fPemPesDeltaR_a[eleInd]->Fill(myPho->PesDeltaR());
    }
}

void TMyZeeFilterModule::FillZeeHistogramsB(ZeeGeneral_t& Hist, ZeeOutput stuffout) {

    //_______________________before cuts
  if(stuffout.outNele>=2)
    {
      Hist.fZeeNCEMtight_b->Fill(stuffout.outNCEMtight); 
      Hist.fZeeNCEMloose_b->Fill(stuffout.outNCEMloose); 
      Hist.fZeeNPEMtight_b->Fill(stuffout.outNPEMtight);
      Hist.fZeeNPEMloose_b->Fill(stuffout.outNPEMloose);
      Hist.fZeeNele_b->Fill(stuffout.outNeleL+stuffout.outNeleE);
      Hist.fZeeNeleE_b->Fill(stuffout.outNeleE);
      
      TLorentzVector myZeeVec=stuffout.outMyZee;
      TLorentzVector myZeeTrkVec=stuffout.outMyZeeTrk;
      TLorentzVector myEleVec1=stuffout.outMyEle[0];
      TLorentzVector myEleVec2=stuffout.outMyEle[1];
      
      Hist.fZeeM_b->Fill(myZeeVec.M()); 
      Hist.fZeeMtrk_b->Fill(myZeeTrkVec.M());
      Hist.fZeeE_b->Fill(myZeeVec.E());    
      Hist.fZeeEt_b->Fill(myZeeVec.Perp());
      Hist.fZeePhi_b->Fill(TVector2::Phi_0_2pi(myZeeVec.Phi()));
      Hist.fZeeEta_b->Fill(myZeeVec.Eta());
      Hist.fZeeTheta_b->Fill(myZeeVec.Theta());
//       Hist.fZeeDeltaPhi_b->Fill(fabs(TVector2::Phi_0_2pi(myEleVec1.Phi())-
// 				TVector2::Phi_0_2pi(myEleVec2.Phi()))); 
      Hist.fZeeDeltaPhi_b->Fill(fabs(TVector2::Phi_mpi_pi(myEleVec1.DeltaPhi(myEleVec2))));
      Hist.fZeeDeltaEta_b->Fill(myEleVec1.Eta()-myEleVec2.Eta()); 
      Hist.fZeeDeltaR_b->Fill(myEleVec1.DeltaR(myEleVec2)); 

      Hist.fZeeEleFid_b[0]->Fill(stuffout.outEleFid[0]);
      Hist.fZeeEleStat_b[0]->Fill(stuffout.outEleStat[0]);
      Hist.fZeeEleFid_b[1]->Fill(stuffout.outEleFid[1]);
      Hist.fZeeEleStat_b[1]->Fill(stuffout.outEleStat[1]);
      Hist.fZeeFid_b->Fill(stuffout.outZeeFid);
      Hist.fZeeStat_b->Fill(stuffout.outZeeStat);    
      Hist.fZeeQual_b->Fill(stuffout.outZeeQual); 
      Hist.fZeeCharge_b->Fill(stuffout.outZeeCharge);

      if(stuffout.outNele==3)
	{
	  Hist.fZeeNele3_M_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[1]).M());
	  Hist.fZeeNele3_M_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[2]).M());
	  Hist.fZeeNele3_M_b->Fill((stuffout.outMyEle[1]+stuffout.outMyEle[2]).M());
	}
      if(stuffout.outNele==4)
	{
	  Hist.fZeeNele4_M_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[1]).M());
	  Hist.fZeeNele4_M_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[2]).M());
	  Hist.fZeeNele4_M_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[3]).M());
	  Hist.fZeeNele4_M_b->Fill((stuffout.outMyEle[1]+stuffout.outMyEle[2]).M());
	  Hist.fZeeNele4_M_b->Fill((stuffout.outMyEle[1]+stuffout.outMyEle[3]).M());
	  Hist.fZeeNele4_M_b->Fill((stuffout.outMyEle[2]+stuffout.outMyEle[3]).M());
 
	  Hist.fZeeNele4_M1_vs_M2_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[1]).M(),(stuffout.outMyEle[2]+stuffout.outMyEle[3]).M());
	  Hist.fZeeNele4_M1_vs_M2_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[2]).M(),(stuffout.outMyEle[1]+stuffout.outMyEle[3]).M());
	  Hist.fZeeNele4_M1_vs_M2_b->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[3]).M(),(stuffout.outMyEle[1]+stuffout.outMyEle[2]).M());
	}
      double M_Zlike=(stuffout.outMyEle[0]+stuffout.outMyEle[1]).M();
      for(int i=0; i<stuffout.outNele; i++)
	{
	  for(int j=i+1; j<stuffout.outNele; j++)
	    {
	      double _mass=(stuffout.outMyEle[i]+stuffout.outMyEle[j]).M();
	      if(fabs(_mass-91.2)<fabs(M_Zlike-91.2)) M_Zlike=_mass;
	    }
	}
      Hist.fZeeNele3_M_Zlike_b->Fill(M_Zlike);
 
    }
}

void TMyZeeFilterModule::FillZeeHistogramsA(ZeeGeneral_t& Hist, ZeeOutput stuffout) {

    //_______________________after cuts
  if(stuffout.outNele>=2)
    {
      Hist.fZeeNCEMtight_a->Fill(stuffout.outNCEMtight); 
      Hist.fZeeNCEMloose_a->Fill(stuffout.outNCEMloose); 
      Hist.fZeeNPEMtight_a->Fill(stuffout.outNPEMtight);
      Hist.fZeeNPEMloose_a->Fill(stuffout.outNPEMloose);
      Hist.fZeeNele_a->Fill(stuffout.outNeleL+stuffout.outNeleE);
      Hist.fZeeNeleE_a->Fill(stuffout.outNeleE);
      
      TLorentzVector myZeeVec=stuffout.outMyZee;
      TLorentzVector myZeeTrkVec=stuffout.outMyZeeTrk;
      TLorentzVector myEleVec1=stuffout.outMyEle[0];
      TLorentzVector myEleVec2=stuffout.outMyEle[1];
      
      Hist.fZeeM_a->Fill(myZeeVec.M()); 
      Hist.fZeeMtrk_a->Fill(myZeeTrkVec.M());
      Hist.fZeeE_a->Fill(myZeeVec.E());    
      Hist.fZeeEt_a->Fill(myZeeVec.Perp());
      Hist.fZeePhi_a->Fill(TVector2::Phi_0_2pi(myZeeVec.Phi()));
      Hist.fZeeEta_a->Fill(myZeeVec.Eta());
      Hist.fZeeTheta_a->Fill(myZeeVec.Theta());
//       Hist.fZeeDeltaPhi_a->Fill(fabs(TVector2::Phi_0_2pi(myEleVec1.Phi())-
// 				TVector2::Phi_0_2pi(myEleVec2.Phi())));
      Hist.fZeeDeltaPhi_a->Fill(fabs(TVector2::Phi_mpi_pi(myEleVec1.DeltaPhi(myEleVec2))));
      Hist.fZeeDeltaEta_a->Fill(myEleVec1.Eta()-myEleVec2.Eta()); 
      Hist.fZeeDeltaR_a->Fill(myEleVec1.DeltaR(myEleVec2)); 
      
      Hist.fZeeEleFid_a[0]->Fill(stuffout.outEleFid[0]);
      Hist.fZeeEleStat_a[0]->Fill(stuffout.outEleStat[0]);
      Hist.fZeeEleFid_a[1]->Fill(stuffout.outEleFid[1]);
      Hist.fZeeEleStat_a[1]->Fill(stuffout.outEleStat[1]);
      Hist.fZeeFid_a->Fill(stuffout.outZeeFid);
      Hist.fZeeStat_a->Fill(stuffout.outZeeStat);    
      Hist.fZeeQual_a->Fill(stuffout.outZeeQual); 
      Hist.fZeeCharge_a->Fill(stuffout.outZeeCharge); 

      if(stuffout.outNele==3)
	{
	  Hist.fZeeNele3_M_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[1]).M());
	  Hist.fZeeNele3_M_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[2]).M());
	  Hist.fZeeNele3_M_a->Fill((stuffout.outMyEle[1]+stuffout.outMyEle[2]).M());
	}
      if(stuffout.outNele==4)
	{
	  if((stuffout.outEleCharge[0]+stuffout.outEleCharge[1])==0) Hist.fZeeNele4_M_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[1]).M());
	  if((stuffout.outEleCharge[0]+stuffout.outEleCharge[2])==0) Hist.fZeeNele4_M_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[2]).M());
	  if((stuffout.outEleCharge[0]+stuffout.outEleCharge[3])==0) Hist.fZeeNele4_M_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[3]).M());
	  if((stuffout.outEleCharge[1]+stuffout.outEleCharge[2])==0) Hist.fZeeNele4_M_a->Fill((stuffout.outMyEle[1]+stuffout.outMyEle[2]).M());
	  if((stuffout.outEleCharge[1]+stuffout.outEleCharge[3])==0) Hist.fZeeNele4_M_a->Fill((stuffout.outMyEle[1]+stuffout.outMyEle[3]).M());
	  if((stuffout.outEleCharge[2]+stuffout.outEleCharge[3])==0) Hist.fZeeNele4_M_a->Fill((stuffout.outMyEle[2]+stuffout.outMyEle[3]).M());

	  if((stuffout.outEleCharge[0]+stuffout.outEleCharge[1])==0 
	     && (stuffout.outEleCharge[2]+stuffout.outEleCharge[3])==0) 
	    {
	      Hist.fZeeNele4_M1_vs_M2_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[1]).M(),(stuffout.outMyEle[2]+stuffout.outMyEle[3]).M());
	    }
	  if((stuffout.outEleCharge[0]+stuffout.outEleCharge[2])==0 
	     && (stuffout.outEleCharge[1]+stuffout.outEleCharge[3])==0) 
	    {	  
	      Hist.fZeeNele4_M1_vs_M2_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[2]).M(),(stuffout.outMyEle[1]+stuffout.outMyEle[3]).M());
	    }

	  if((stuffout.outEleCharge[0]+stuffout.outEleCharge[3])==0 
	     && (stuffout.outEleCharge[1]+stuffout.outEleCharge[2])==0) 
	    {	  
	      Hist.fZeeNele4_M1_vs_M2_a->Fill((stuffout.outMyEle[0]+stuffout.outMyEle[3]).M(),(stuffout.outMyEle[1]+stuffout.outMyEle[2]).M());
	    }
	}
      double M_Zlike=(stuffout.outMyEle[0]+stuffout.outMyEle[1]).M();
      for(int i=0; i<stuffout.outNele; i++)
	{
	  for(int j=i+1; j<stuffout.outNele; j++)
	    {
	      double _mass=(stuffout.outMyEle[i]+stuffout.outMyEle[j]).M();
	      if(fabs(_mass-91.2)<fabs(M_Zlike-91.2)) M_Zlike=_mass;
	    }
	}
      Hist.fZeeNele3_M_Zlike_a->Fill(M_Zlike);
    }
}

void TMyZeeFilterModule::FillConversionHistograms(ConversionHisto_t& Hist, int eleInd, int triStat) {
  if(eleInd==0 || eleInd==1)
    { 
      if(myConvStuff.conv_Ncand[eleInd]>0)
	{
	  Hist.fConvNcand[eleInd]->Fill(myConvStuff.conv_Ncand[eleInd]); 
	  Hist.fConvR[eleInd]->Fill(myConvStuff.conv_R[eleInd]);     
	  Hist.fConvXYsep[eleInd]->Fill(myConvStuff.conv_dXY[eleInd]); 
	  Hist.fConvDelLam[eleInd]->Fill(myConvStuff.conv_dCot[eleInd]);
	  Hist.fConvChi2[eleInd]->Fill(myConvStuff.conv_Chi2[eleInd]);  
	  Hist.fConvDeltaR[eleInd]->Fill(myConvStuff.conv_dmyRconv[eleInd]);  
	  Hist.fConvTrkAlgoID[eleInd]->Fill(myConvStuff.conv_TrkAlgo[eleInd]);
	  Hist.fConvMyRconv[eleInd]->Fill(myConvStuff.conv_myRconv[eleInd]);
	  Hist.fConvEleInd[eleInd]->Fill(myConvStuff.conv_EleInd[eleInd]);
	  Hist.fConvD0[eleInd]->Fill(myConvStuff.conv_D0[eleInd]);
	  Hist.fConvMyRconv1R->Fill(myConvStuff.conv_dmyRconv[eleInd]+
				    myConvStuff.conv_myRconv[eleInd]-myConvStuff.conv_R[eleInd]);   
	  Hist.fConvMyRconv2R->Fill(myConvStuff.conv_myRconv[eleInd]-myConvStuff.conv_R[eleInd]);   
	  Hist.fConvMyRconvEle->Fill(myConvStuff.conv_dmyRconv[eleInd]+
				     myConvStuff.conv_myRconv[eleInd]);
	  Hist.fConvDeltaPhi[eleInd]->Fill(myConvStuff.conv_dPhi[eleInd]);
	  if(triStat>0) 
	    {
	      Hist.fConvTriD0->Fill(myConvStuff.tri_D0[eleInd]);
	      Hist.fConvTriR->Fill(myConvStuff.tri_R[eleInd]);  
	      Hist.fConvTriMyRconv->Fill(myConvStuff.tri_myRconv[eleInd]);
	      Hist.fConvTriDeltaR->Fill(myConvStuff.conv_myRconv[eleInd]-myConvStuff.tri_myRconv[eleInd]); 
	    }
	}
    }
  return;
}

double TMyZeeFilterModule::myRawRconv(TStnTrack* Trk) {
  double Rconv=0.0;
  double d0=myD0_corr(myBeam,myBeamSlope,Trk);
  double R=1.0E6;
  if(fabs(Trk->C0())>0.0) R=1.0/(2.0*(Trk->Charge())*(Trk->C0()));
  double q=Trk->Charge(); 
  // Q cancels out here, but want to keep it to show the idea
  double R2=d0*d0+2.0*d0*R*q; 
  if(R2>=0.0) Rconv=TMath::Sqrt(R2);
  else Rconv=-1.0*TMath::Sqrt(fabs(R2));
  return Rconv;
}

//____________ extra cut to remove events with badly measured electrons
int TMyZeeFilterModule::MyExtraCemCut(TStnElectron* Ele, TStnTrack* Trk) {
  int passcode=1;
  if((Ele->DetectorCode())!=0) return 0; 
  if(Trk==NULL) return 0;
  if((Ele->EOverP())<0.9) return 0;
  if(Ele->FidEleTrk()==0) return 0;
  if((Trk->Algorithm())==2)
    {
      if(fabs(Ele->XBcTrkCes())>21.0) return 0; // note, beam-constrained track !!!
    }
  else
    {
      if(fabs(Ele->TrackXCes())>21.0) return 0; // note, NOT beam-constrained track !!!
    }
  return passcode;
}

int TMyZeeFilterModule::MyCemLooseIDcut(TStnElectron* Ele, TStnTrack* Trk, int eleInd, int ConvStat) {
  int passcode=1;
  if(Trk==NULL) return 0;
  //  if(eleInd<0 || eleInd>1) return 0; // don't need this cut
  if((Ele->DetectorCode())!=0) return 0;

//-----------------------------------------------------
//++++++++ NO cut on fiduciality if fCemFidCut!= 1 or 4 
  if(fCemFidCut==1) // CES-based fiducial 
    if((Ele->FidEleSmx())!=fCemFidCut) return 0; 
  if(fCemFidCut==4) // Track-based fiducial
    if((Ele->FidEleSmx())!=fCemFidCut) return 0; 
//_____________________________________________________

  if((Ele->TrackNumber())==-1) return 0; // these are junk CEM electrons
  
  if((myCorrEtEle(Ele))<fCemMinEt || (myCorrEtEle(Ele))>fCemMaxEt) return 0;
  if(fabs(Ele->Z0())<fCemMinTrkZ0 || 
     fabs(Ele->Z0())>fCemMaxTrkZ0) return 0; // note, not beam-constrained track !!!
  if((Trk->Algorithm())==2)
    {
      if((Ele->TrackBcPt())<fTrkMinPt || 
	 (Ele->TrackBcPt())>fTrkMaxPt) return 0; // note, beam-constrained track !!! 
    }
  else
    {
      if((Ele->TrackPt())<fTrkMinPt || 
	 (Ele->TrackPt())>fTrkMaxPt) return 0; // note, not beam-constrained track !!! 
    }
  if((Ele->Nasl())<fCemMinCotAxSl || (Ele->Nasl())>fCemMaxCotAxSl) return 0;
  if((Ele->Nssl())<fCemMinCotStSl || (Ele->Nssl())>fCemMaxCotStSl) return 0;
  if(fUseConvCut==1 && ConvStat!=fCemConvCut) return 0; 

  if((Ele->HadEm())<(fCemMinHADEM[0]+fCemMinHADEM[1]*(myCorrEnergyEle(Ele))) || 
     (Ele->HadEm())>(fCemMaxHADEM[0]+fCemMaxHADEM[1]*(myCorrEnergyEle(Ele)))) return 0;
  if((myCorrIsoFr(Ele))<fCemMinIsoFr || (myCorrIsoFr(Ele))>fCemMaxIsoFr) return 0;
  
  return passcode;
}

int TMyZeeFilterModule::MyCemTightIDcut(TStnElectron* Ele, TStnTrack* Trk, int eleInd) {
  int passcode=1;
  if(Trk==NULL) return 0;
  if(fabs(Ele->Lshr())<fCemMinLshr || fabs(Ele->Lshr())>fCemMaxLshr) return 0;

  if((Trk->Algorithm())==2)
    {
      if((Ele->TrackBcPt())<50.0 && 
	 ((Ele->EOverP())<fCemMinEP || (Ele->EOverP())>fCemMaxEP)) return 0;
      if(fabs(Ele->BcDelZ())<fCemMinCesdZ || 
	 fabs(Ele->BcDelZ())>fCemMaxCesdZ) return 0; // note, beam-constrained track !!!
      if((Ele->BcDelXQ())<fCemMindXQ || 
	 (Ele->BcDelXQ())>fCemMaxdXQ) return 0; // note, beam-constrained track !!!
    }
  else
    {
      if((Ele->TrackPt())<50.0 && 
	 ((Ele->EOverP())<fCemMinEP || (Ele->EOverP())>fCemMaxEP)) return 0;
      if(fabs(Ele->DelZ())<fCemMinCesdZ || 
	 fabs(Ele->DelZ())>fCemMaxCesdZ) return 0; // note, NOT beam-constrained track !!!
      if((Ele->DelXQ())<fCemMindXQ || 
	 (Ele->DelXQ())>fCemMaxdXQ) return 0; // note, NOT beam-constrained track !!!
    }
  if((Ele->Chi2Strip())<fCemMinChi2strip || (Ele->Chi2Strip())>fCemMaxChi2strip) return 0;
  if(myRawRconv(Trk)<fCemMinRconv || 
     myRawRconv(Trk)>fCemMaxRconv) return 0; // note, using not beam-constrained params !!! 

  return passcode;
}


int TMyZeeFilterModule::MyPemLooseIDcut(TStnElectron* Ele, int eleInd) {
  int passcode=1;

  double E_em=myCorrEnergyEle(Ele);
  double Et_em=myCorrEtEle(Ele);

  //  if(eleInd<0 || eleInd>1) return 0;  // don't need this cut
  if((Ele->DetectorCode())!=1) return 0;
  if(Et_em<fPemMinEt || Et_em>fPemMaxEt) return 0;   
  if(fabs(Ele->PesEta())<fPemMinEtaPes || fabs(Ele->PesEta())>fPemMaxEtaPes) return 0;
  if((Ele->HadEm())<fPemMinHADEM || (Ele->HadEm())>fPemMaxHADEM) return 0;
  if((Ele->Pem3x3FitTower())==fPem3x3FitCut) return 0;
  if((Ele->Chi2Three())<fPemMin3x3Chi2 || (Ele->Chi2Three())>fPemMax3x3Chi2) return 0;
  if((Ele->Pes5x9(0))<fPemMinPes5x9U || (Ele->Pes5x9(0))>fPemMaxPes5x9U) return 0;
  if((Ele->Pes5x9(1))<fPemMinPes5x9V || (Ele->Pes5x9(1))>fPemMaxPes5x9V) return 0;
  if((myCorrIsoFr(Ele))<fPemMinIsoFr || (myCorrIsoFr(Ele))>fPemMaxIsoFr) return 0;
  TStnPhoton* myPho=TPhotonUtil::MatchPhoton(GetHeaderBlock()->GetEvent(),Ele);
  if((myPho->PesDeltaR())<fPemMinPesdR || (myPho->PesDeltaR())>fPemMaxPesdR) return 0;

  return passcode;
}

//------- This cut is for Phoenix electrons only!!!
int TMyZeeFilterModule::MyPemTightIDcut(TStnElectron* Ele, TStnTrack* Trk, int eleInd) {
  int passcode=1;

  if(Trk==NULL) return 0;
  if(fabs(Trk->Z0())<fPemMinTrkZ0 || 
     fabs(Trk->Z0())>fPemMaxTrkZ0) return 0; // note, using phoenix track !!! 
  if((Trk->NSvxHits())<fPemMinSiHit || (Trk->NSvxHits())>fPemMaxSiHit) return 0;  

  return passcode;
}

int TMyZeeFilterModule::MyZeeIDcut(ZeeOutput stuffout) {
  int passcode=1;
  TLorentzVector myZee=stuffout.outMyZee;

  if(stuffout.outNele<fMinNele || stuffout.outNele>fMaxNele) return 0;
  if(stuffout.outNeleL<fMinNeleL || stuffout.outNeleL>fMaxNeleL) return 0;
  if(stuffout.outNeleE<fMinNeleE || stuffout.outNeleE>fMaxNeleE) return 0; 
  if(myZee.M()<fZeeMinM || myZee.M()>fZeeMaxM) return 0;
  if(myZee.Perp()<fZeeMinEt || myZee.Perp()>fZeeMaxEt) return 0;
  if(fabs(myZee.Eta())<fZeeMinEta || fabs(myZee.Eta())>fZeeMaxEta) return 0; 
  TLorentzVector myEle1=stuffout.outMyEle[0]; 
  TLorentzVector myEle2=stuffout.outMyEle[1];
  double dphi12=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(myEle1.Phi())-
					  TVector2::Phi_0_2pi(myEle2.Phi())));
  double deta12=fabs(myEle1.Eta()-myEle2.Eta());
  double dr12=myEle1.DeltaR(myEle2);
  if(dphi12<fZeeMinDeltaPhi || dphi12>fZeeMaxDeltaPhi) return 0;
  if(deta12<fZeeMinDeltaEta || deta12>fZeeMaxDeltaEta) return 0;
  if(dr12<fZeeMinDeltaR || dr12>fZeeMaxDeltaR) return 0;
  if(stuffout.outZeeFid<fZeeMinFid || stuffout.outZeeFid>fZeeMaxFid) return 0;
  if(stuffout.outZeeStat<fZeeMinStat || stuffout.outZeeStat>fZeeMaxStat) return 0;
  if(stuffout.outZeeQual<fZeeMinQual || stuffout.outZeeQual>fZeeMaxQual) return 0;
  if(abs(stuffout.outZeeCharge)<fZeeMinCharge || abs(stuffout.outZeeCharge)>fZeeMaxCharge) return 0;

  return passcode;
}

void TMyZeeFilterModule::ClearModuleOutput() {
  myZeeStuff.outNCEMtight=0; 
  myZeeStuff.outNCEMloose=0;  
  myZeeStuff.outNPEMtight=0; 
  myZeeStuff.outNPEMloose=0; 
  myZeeStuff.outNele=0; 
  myZeeStuff.outNeleL=0; 
  myZeeStuff.outNeleE=0; 
  
  TLorentzVector dummy(0.0,0.0,0.0,0.0); 
  myZeeStuff.outMyZee=dummy;      
  myZeeStuff.outMyZeeTrk=dummy; 
  myZeeStuff.outMyEle.clear();      
  myZeeStuff.outMyEleRaw.clear();   
  myZeeStuff.outMyEleTrk.clear();
  myZeeStuff.outTrkInd.clear();
  myZeeStuff.outEleInd.clear();
  myZeeStuff.outEleFid.clear();
  myZeeStuff.outEleStat.clear();
  myZeeStuff.outEleCharge.clear();
  myZeeStuff.outEleConvStat.clear();
  myZeeStuff.outEleIso.clear(); 
  myZeeStuff.outEleIsoRaw.clear(); 
  myZeeStuff.outEleDetEta.clear(); 
  myZeeStuff.outEleClusPhi.clear(); 
  myZeeStuff.outEleChi2.clear();
  myZeeStuff.outEleHadEm.clear();
  myZeeStuff.outEleCprPpr.clear();
  myZeeStuff.outEleXces.clear();
  myZeeStuff.outEleZces.clear();
  myZeeStuff.outZeeFid=-1;
  myZeeStuff.outZeeStat=-1; 
  myZeeStuff.outZeeQual=-1; 
  myZeeStuff.outZeeCharge=-999;
  
  myConvStuff.conv_Ncand[0]=0; 
  myConvStuff.conv_Ncand[1]=0; 
  myConvStuff.conv_Chi2[0]=-1.0E6;  
  myConvStuff.conv_Chi2[1]=-1.0E6;  
  myConvStuff.conv_dXY[0]=-1.0E6;
  myConvStuff.conv_dXY[1]=-1.0E6;
  myConvStuff.conv_dCot[0]=-1.0E6; 
  myConvStuff.conv_dCot[1]=-1.0E6; 
  myConvStuff.conv_R[0]=-1.0E6;
  myConvStuff.conv_R[1]=-1.0E6;
  myConvStuff.conv_myRconv[0]=-1.0E6; 
  myConvStuff.conv_myRconv[1]=-1.0E6; 
  myConvStuff.conv_dmyRconv[0]=-1.0E6;
  myConvStuff.conv_dmyRconv[1]=-1.0E6;
  myConvStuff.conv_D0[0]=-1.0E6;
  myConvStuff.conv_D0[1]=-1.0E6;
  myConvStuff.conv_ConvInd[0]=-1;
  myConvStuff.conv_ConvInd[1]=-1;
  myConvStuff.conv_TrkAlgo[0]=-1;
  myConvStuff.conv_TrkAlgo[1]=-1;
  myConvStuff.conv_EleInd[0]=-1;
  myConvStuff.conv_EleInd[1]=-1;
  myConvStuff.conv_pho1=dummy; 
  myConvStuff.conv_pho2=dummy;    
  myConvStuff.conv_dPhi[0]=-1.0E6; 
  myConvStuff.conv_dPhi[1]=-1.0E6; 
  myConvStuff.tri_D0[0]=-1.0E6; 
  myConvStuff.tri_R[0]=-1.0E6;  
  myConvStuff.tri_myRconv[0]=-1.0E6; 
  myConvStuff.tri_D0[1]=-1.0E6; 
  myConvStuff.tri_R[1]=-1.0E6;  
  myConvStuff.tri_myRconv[1]=-1.0E6; 
   
  return;
}

void TMyZeeFilterModule::PrintModuleOutput() {
  if(fUseVerbose==1)
    {
      std::cout<<"______________________________________________________________"<<std::endl;
      std::cout<<"                                                              "<<std::endl;
      std::cout<<"------------ printing output for MyZeeFilterModule  -->>>"<<std::endl;
      std::cout<<"______________________________________________________________"<<std::endl;
      std::cout<<"                                                              "<<std::endl;
      
      std::cout<<"Number of CemTight electrons ="<<myZeeStuff.outNCEMtight<<std::endl; 
      std::cout<<"Number of CemLoose electrons ="<<myZeeStuff.outNCEMloose<<std::endl;  
      std::cout<<"Number of PemTight electrons ="<<myZeeStuff.outNPEMtight<<std::endl; 
      std::cout<<"Number of PemLoose electrons ="<<myZeeStuff.outNPEMloose<<std::endl; 
      std::cout<<"Number of leading electrons after cuts ="<<myZeeStuff.outNele<<std::endl; 
      std::cout<<"Number of extra electrons after cuts ="<<myZeeStuff.outNeleE<<std::endl; 
      
      std::cout<<"Z-candidate using electrons: M, Et, Phi, Eta ="<<myZeeStuff.outMyZee.M()
	       <<" "<<myZeeStuff.outMyZee.Pt()<<" "<<myZeeStuff.outMyZee.Phi()
	       <<" "<<myZeeStuff.outMyZee.Eta()<<std::endl;      
      std::cout<<"Z-candidate using tracks: M, Et, Phi, Eta ="<<myZeeStuff.outMyZeeTrk.M()
	       <<" "<<myZeeStuff.outMyZeeTrk.Pt()<<" "<<myZeeStuff.outMyZeeTrk.Phi()
	       <<" "<<myZeeStuff.outMyZeeTrk.Eta()<<std::endl;      
      std::cout<<"Default Electron-1: Et, Phi, Eta ="<<myZeeStuff.outMyEle[0].Pt()
	       <<" "<<myZeeStuff.outMyEle[0].Phi()
	       <<" "<<myZeeStuff.outMyEle[0].Eta()<<std::endl;      
      std::cout<<"Default Electron-2: Et, Phi, Eta ="<<myZeeStuff.outMyEle[1].Pt()
	       <<" "<<myZeeStuff.outMyEle[1].Phi()
	       <<" "<<myZeeStuff.outMyEle[1].Eta()<<std::endl;            
      std::cout<<"raw Electron-1: Et, Phi, Eta ="<<myZeeStuff.outMyEleRaw[0].Pt()
	       <<" "<<myZeeStuff.outMyEleRaw[0].Phi()
	       <<" "<<myZeeStuff.outMyEleRaw[0].Eta()<<std::endl;      
      std::cout<<"raw Electron-2: Et, Phi, Eta ="<<myZeeStuff.outMyEleRaw[1].Pt()
	       <<" "<<myZeeStuff.outMyEleRaw[1].Phi()
	       <<" "<<myZeeStuff.outMyEleRaw[1].Eta()<<std::endl;      
      std::cout<<"Trk Electron-1: Et, Phi, Eta ="<<myZeeStuff.outMyEleTrk[0].Pt()
	       <<" "<<myZeeStuff.outMyEleTrk[0].Phi()
	       <<" "<<myZeeStuff.outMyEleTrk[0].Eta()<<std::endl;      
      std::cout<<"Trk Electron-2: Et, Phi, Eta ="<<myZeeStuff.outMyEleTrk[1].Pt()
	       <<" "<<myZeeStuff.outMyEleTrk[1].Phi()
	       <<" "<<myZeeStuff.outMyEleTrk[1].Eta()<<std::endl;      

      std::cout<<"index of 1st track ="<<myZeeStuff.outTrkInd[0]<<std::endl;
      std::cout<<"fiduciality of 1st electron ="<<myZeeStuff.outEleFid[0]<<std::endl;
      std::cout<<"status of 1st electron ="<<myZeeStuff.outEleStat[0]<<std::endl;
      std::cout<<"index of 2nd track ="<<myZeeStuff.outTrkInd[1]<<std::endl;
      std::cout<<"fiduciality of 2nd electron ="<<myZeeStuff.outEleFid[1]<<std::endl;
      std::cout<<"status of 2nd electron ="<<myZeeStuff.outEleStat[1]<<std::endl;
      std::cout<<"ISO of 1st electron ="<<myZeeStuff.outEleIso[0]<<std::endl; 
      std::cout<<"Chi2 of 1st electron ="<<myZeeStuff.outEleChi2[0]<<std::endl;
      std::cout<<"Had/Em of 1st electron ="<<myZeeStuff.outEleHadEm[0]<<std::endl;
      std::cout<<"Cpr/Ppr energy of 1st electron ="<<myZeeStuff.outEleCprPpr[0]<<std::endl;
      std::cout<<"ISO of 2nd electron ="<<myZeeStuff.outEleIso[1]<<std::endl;
      std::cout<<"Chi2 of 2nd electron ="<<myZeeStuff.outEleChi2[1]<<std::endl; 
      std::cout<<"Had/Em of 2nd electron ="<<myZeeStuff.outEleHadEm[1]<<std::endl;
      std::cout<<"Cpr/Ppr energy of 2nd electron ="<<myZeeStuff.outEleCprPpr[1]<<std::endl; 
      std::cout<<"fiduciality of Z-candidate ="<<myZeeStuff.outZeeFid<<std::endl;
      std::cout<<"status of Z-candidate ="<<myZeeStuff.outZeeStat<<std::endl; 
      std::cout<<"quality of Z-candidate ="<<myZeeStuff.outZeeQual<<std::endl; 
      std::cout<<"charge of Z-candidate ="<<myZeeStuff.outZeeCharge<<std::endl;
      
    }
  return;
}

//_______________ fills the Module output at the end of every event
void TMyZeeFilterModule::FillModuleOutput(TStnElectron* Ele, TStnTrack* Trk, TStnEvent* Event, int EleInd, 
					  int TrkInd, int EleCharge, int EleStat, int EleConvStat, int N_ele, 
					  int N_eleL, int N_eleE, int N_cemT, int N_cemL, int N_pemT, int N_pemL) {

  TStnPhoton* myPho=TPhotonUtil::MatchPhoton(Event,Ele);
  const TLorentzVector* ele_momentumvec = Ele->Momentum(); // new as of 04/25/07

  //_____________ filling these params only once
  if(myZeeStuff.outMyEle.size()==0)
    {
      myZeeStuff.outNCEMtight=N_cemT; 
      myZeeStuff.outNCEMloose=N_cemL;  
      myZeeStuff.outNPEMtight=N_pemT; 
      myZeeStuff.outNPEMloose=N_pemL; 
      myZeeStuff.outNele=N_ele; 
      myZeeStuff.outNeleE=N_eleE; 
      myZeeStuff.outNeleL=N_eleL; 
    }

  myZeeStuff.outEleInd.push_back(EleInd);
  myZeeStuff.outEleFid.push_back(Ele->DetectorCode());
  myZeeStuff.outEleCharge.push_back(EleCharge);
  myZeeStuff.outEleStat.push_back(EleStat);
  myZeeStuff.outEleConvStat.push_back(EleConvStat);
  myZeeStuff.outTrkInd.push_back(TrkInd);
  myZeeStuff.outEleIso.push_back(myCorrIso(Ele)); 
  myZeeStuff.outEleIsoRaw.push_back(Ele->Iso()); 
  if(Ele->DetectorCode()==0) 
    {
      myZeeStuff.outEleChi2.push_back(Ele->Chi2Strip()); // these are strip Chi2 only
      myZeeStuff.outEleCprPpr.push_back(Ele->CprEnergy());
    }
  if(Ele->DetectorCode()==1) 
    {
      myZeeStuff.outEleChi2.push_back(Ele->Chi2Three());
      myZeeStuff.outEleCprPpr.push_back(Ele->PprEnergy());      
    }
  myZeeStuff.outEleHadEm.push_back(Ele->HadEm());
  myZeeStuff.outEleDetEta.push_back(Ele->DetEta());
  myZeeStuff.outEleClusPhi.push_back(Ele->EmClusPhi());

  if(Ele->DetectorCode()==0)
    {
      myZeeStuff.outEleXces.push_back(Ele->XCes());
      myZeeStuff.outEleZces.push_back(Ele->ZCes());
    }
  else
    {
      myZeeStuff.outEleXces.push_back(-999.9);
      myZeeStuff.outEleZces.push_back(-999.9);
    }

  if(Ele->DetectorCode()==0) myZeeStuff.outEleCprPpr.push_back(Ele->Chi2Strip());
  if(Ele->DetectorCode()==1) myZeeStuff.outEleChi2.push_back(Ele->Chi2Three());

  double e_mass=0.000511;
  double e_pt;
  double e_eta;
  double e_phi;

  //___ clus_* variables are new as of 04/25/07
  double clus_pt;
  double clus_phi;
  double clus_eta;

  double trk_pt;
  double trk_phi; // phi of electron using phi or track, smx, or cal (new as of 04/25/07)
  double trk_eta; // new as of 04/25/07
  double tot_pt;

  //___________________________ old part commented out on 04/25/07
//   e_eta=Ele->EmClusEvEta();
//   e_phi=Ele->EmClusPhi();
//   e_pt=myCorrEtEle(Ele);
//   tot_pt=Ele->TotalEt();

//_____________________________ new part added on 04/25/07
  e_eta=ele_momentumvec->Eta();
  e_phi=ele_momentumvec->Phi();
  e_pt=myCorrEtEle(Ele);
  clus_eta=Ele->EmClusEvEta();
  clus_phi=Ele->EmClusPhi();
  clus_pt=Ele->TotalEt();
  //--------------- end of new part (04/25/07)

//   trk_phi=Ele->TrackPhi(); // new as of 04/25/07

  if(Trk!=NULL)
    {
      if((Trk->Algorithm())==2) 
	{
	  trk_pt=Ele->TrackBcPt(); // beam-constrained params
	  trk_phi=Ele->TrackBcPhi0(); // new as of 04/25/07
	  trk_eta=e_eta; // new as of 04/25/07
	}
      else 
	{
	  trk_pt=Trk->Pt(); // NOT beam-constrained params
	  trk_phi=Trk->Phi0(); // new as of 04/25/07
	  trk_eta=Trk->Eta(); // new as of 04/25/07
	}
    }
  else
    {
      trk_pt=0.0;
    }

  TLorentzVector vec;
  //____________________ corrected electron
  vec.SetPtEtaPhiM(e_pt,e_eta,e_phi,e_mass);
  myZeeStuff.outMyEle.push_back(vec);
  //____________________ raw electron (to be the same as raw photon)
  vec.SetPtEtaPhiM(clus_pt,clus_eta,clus_phi,0.0);
  myZeeStuff.outMyEleRaw.push_back(vec);

  //_________________ This part commented out on 04/25/07 ________________________
//   if(myPho!=NULL) // to be consistent with di-pho when correcting MET, 11/04/05
//     {
//       vec.SetPtEtaPhiM(myPho->Et(),myPho->Eta(),myPho->Phi(),0.0);
//     }
//   else vec.SetPtEtaPhiM(tot_pt,e_eta,e_phi,0.0);
//   myZeeStuff.outMyEleRaw.push_back(vec);

//___________________ track electron
  if(trk_pt>0.0) vec.SetPtEtaPhiM(trk_pt,trk_eta,trk_phi,e_mass);
  else vec.SetPtEtaPhiM(0.0,0.0,0.0,0.0);
  myZeeStuff.outMyEleTrk.push_back(vec);

  //_____________ filling Z params only once
  if(myZeeStuff.outMyEle.size()==2)
    {
      myZeeStuff.outZeeFid=myZeeStuff.outEleFid[0]+myZeeStuff.outEleFid[1];
      myZeeStuff.outZeeStat=myZeeStuff.outEleStat[0]+myZeeStuff.outEleStat[1]; 
      myZeeStuff.outZeeQual=myZeeStuff.outZeeFid+myZeeStuff.outZeeStat; 
      myZeeStuff.outZeeCharge=myZeeStuff.outEleCharge[0]+myZeeStuff.outEleCharge[1];  
      myZeeStuff.outMyZee=myZeeStuff.outMyEle[0]+myZeeStuff.outMyEle[1];      
      myZeeStuff.outMyZeeTrk=myZeeStuff.outMyEleTrk[0]+myZeeStuff.outMyEleTrk[1];
    }
  return;
}

char* TMyZeeFilterModule::HistoSummary(TH1F* myhisto)
{
  //  char* outputstring = "";
  sprintf(histo_outputstring,"...%s   %f   %f   %f",
	  myhisto->GetName(),
	  myhisto->GetEntries(),
	  myhisto->GetMean(),
	  myhisto->GetRMS());
  return histo_outputstring;
}


//=================================================================================
// Beam position corrected helix parameters: Phi0 using not constrained params (for 
// Silicon tracks) 
//=================================================================================
double TMyZeeFilterModule::myPhi0_corr(TVector3 beam, TVector3 slope, TStnTrack* Trk) {
  double tr_d0   = Trk->D0();
  double tr_z0   = Trk->Z0();
  double tr_phi0 = Trk->Phi0();
  double tr_C    = Trk->C0();
  double tr_R    = 1.0e10;
  if (tr_C != 0) tr_R = 1.0/(2*tr_C);
  
  double dx = beam.x() + slope.x()*tr_z0;
  double dy = beam.y() + slope.y()*tr_z0;
  
  double notzero = tr_R - tr_d0;
  if (notzero != 0) 
    {    
      double arg1 = sin(tr_phi0)-(dx/notzero);
      double arg2 = cos(tr_phi0)-(dy/notzero);
      tr_phi0 = atan(arg1/arg2);
      if (arg2 > 0.0 && arg1 < 0.0) tr_phi0 += 6.2831853;
      if (arg2 < 0.0) tr_phi0 += 3.1415927;
      return tr_phi0;
    }
  else return tr_phi0;
}
//=================================================================================
// Beam position corrected helix parameters: D0 using not constrained params (for 
// Silicon tracks) 
//=================================================================================
double TMyZeeFilterModule::myD0_corr(TVector3 beam, TVector3 slope, TStnTrack* Trk) {
  double tr_d0   = Trk->D0();
  double tr_z0   = Trk->Z0();
  double tr_phi0 = Trk->Phi0();
  double dx = beam.x() + slope.x()*tr_z0; 
  double dy = beam.y() + slope.y()*tr_z0; 
  
  return tr_d0 + dx*sin(tr_phi0) - dy*cos(tr_phi0)
    + (dx*cos(tr_phi0) + dy*sin(tr_phi0))*
    tan(0.5*(myPhi0_corr(beam,slope,Trk)-tr_phi0));
}
//=======================================================================================
//      Initialization of my Beam Line parameters 
//=======================================================================================
void TMyZeeFilterModule::InitMyBeamLineOld() {

  int Nrun=0;
  for (int i=0; i<myNruns; i++)
    {
      fBeam.bm_x[i]=0.0;
      fBeam.bm_y[i]=0.0;
      fBeam.bmsl_x[i]=0.0;
      fBeam.bmsl_y[i]=0.0;
    }

  if(fUseBeamLineDB==0) // read beam line from file (old version)
    {
      ifstream beamfile;
      beamfile.open(fMyBeamLineFile);
      double junk;
      double x=0.0;
      double sl_x=0.0;
      double y=0.0;
      double sl_y=0.0;
      
      while (beamfile)
	{
	  beamfile>>Nrun>>x>>sl_x>>y>>sl_y>>junk>>junk>>junk;
	  if(Nrun>(myFirstRun-1))
	    {
	      fBeam.bm_x[Nrun-myFirstRun]=x;
	      fBeam.bm_y[Nrun-myFirstRun]=y;
	      fBeam.bmsl_x[Nrun-myFirstRun]=sl_x;
	      fBeam.bmsl_y[Nrun-myFirstRun]=sl_y;	  
	    }
	}
      beamfile.close();
    }

  return;
}

void TMyZeeFilterModule::InitMyBeamLineNew(int RunNumber) {
  int Nrun=0;
  if(fUseBeamLineDB==1) // read beam line from DB
    {
      TStnDBManager* dbm = TStnDBManager::Instance(); // pointer to DB
      //______ get Beam position blocks
      fCotBeamPosBlock = (TStnBeamPosBlock*) dbm->GetTable("CotBeamPosBlock");
      fSvxBeamPosBlock = (TStnBeamPosBlock*) dbm->GetTable("SvxBeamPosBlock");
      //____________________________________ looping over COT beam pos      
      if(fCotBeamPosBlock->NBeamPos() > 0)
	{
	  for(int i=0; i<fCotBeamPosBlock->NBeamPos(); i++)
	    {
	      TStnBeamPos* fCotBeamPos = fCotBeamPosBlock->BeamPos(i);
	      Nrun=fCotBeamPos->RunNumber();
	      if(Nrun>=myFirstRun && Nrun<=myLastRun && Nrun==RunNumber 
		 && fCotBeamPos->Status()>=0
		 && fabs(fCotBeamPos->X0())<1.0 && fabs(fCotBeamPos->Y0())<1.0)
		{ 
		  fBeam.bm_x[Nrun-myFirstRun]=fCotBeamPos->X0();
		  fBeam.bm_y[Nrun-myFirstRun]=fCotBeamPos->Y0();
		  fBeam.bmsl_x[Nrun-myFirstRun]=fCotBeamPos->DxDz();
		  fBeam.bmsl_y[Nrun-myFirstRun]=fCotBeamPos->DyDz();
		  break; // I only need first entry (average) for each run
		}	
	    }	
	} 
      //____________________________________ looping over SVX beam pos
      if(fSvxBeamPosBlock->NBeamPos() > 0) 
	{
	  for(int i=0; i<fSvxBeamPosBlock->NBeamPos(); i++)
	    {
	      TStnBeamPos* fSvxBeamPos = fSvxBeamPosBlock->BeamPos(i);
	      Nrun=fSvxBeamPos->RunNumber();
	      if(Nrun>=myFirstRun && Nrun<=myLastRun && Nrun==RunNumber
		 && fSvxBeamPos->Status()>=0 
		 && fabs(fSvxBeamPos->X0())<1.0 && fabs(fSvxBeamPos->Y0())<1.0)
		{ 
		  fBeam.bm_x[Nrun-myFirstRun]=fSvxBeamPos->X0();
		  fBeam.bm_y[Nrun-myFirstRun]=fSvxBeamPos->Y0();
		  fBeam.bmsl_x[Nrun-myFirstRun]=fSvxBeamPos->DxDz();
		  fBeam.bmsl_y[Nrun-myFirstRun]=fSvxBeamPos->DyDz();	  
		  break; // I only need first entry (average) for each run
		}	
	    }	
	} 
    }
  return;
}


//========================================================================================
//      Access routine to My Beam Line parameters
//========================================================================================
void TMyZeeFilterModule::GetMyBeamLine(TVector3 &beam, TVector3 &slope, int myRun) {
  beam.SetXYZ(fBeam.bm_x[myRun-myFirstRun],fBeam.bm_y[myRun-myFirstRun],0.0);
  slope.SetXYZ(fBeam.bmsl_x[myRun-myFirstRun],fBeam.bmsl_y[myRun-myFirstRun],0.0);
  return;
}

//____________________________ my routine to get Phoenix track by using Ray's methods
TStnTrack* TMyZeeFilterModule::GetMyPnxTrack(TStnEvent* event, TStnElectron* ele) {
  TStnElectron* phele = TPhotonUtil::MatchPhoenixElectron(event,ele);
  TStnTrack*    phTrk = TPhotonUtil::PhoenixTrack(event,phele);
  return phTrk;
}

//____________________________________________________________________________
// converts helix to circle using D0, Phi calculated w.r.t. origin 
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//   This version is the same as used by Safonov and Ray.  
//___________________________________________________________________
void TMyZeeFilterModule::myHelixToCircle(TStnTrack* Trk, double &x, double &y, double &R)
{
  if(fabs(Trk->C0())>0.0) R=1.0/(2.0*fabs(Trk->C0()));
  else R=1.0E6;
  double rCenter;
  rCenter = R*(Trk->Charge()) + Trk->D0();
  x = -rCenter*sin(Trk->Phi0());
  y =  rCenter*cos(Trk->Phi0());
  
  return;
}


//____________________________________________________________________________
// computes dXY, dCot(Theta), Radius, 4vector of photon candidate
void TMyZeeFilterModule::myConversionComputer(TStnTrack* Trk1, TStnTrack* Trk2, 
					      double &dXY, double &dCot, double &R, 
					      double &convD0, double &dPhi, 
					      TLorentzVector &conv)
{
  const double eM = 0.000510999; // mass of electron

  double x1,y1,R1;        // center coordinates and radius for helix1
  double x2,y2,R2;        // same thing for helix2 

  myHelixToCircle(Trk1,x1,y1,R1); // calculating circle params
  myHelixToCircle(Trk2,x2,y2,R2);
 
  // compute distance between the two flattened helices (i.e., circles)
  double d = sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2)); 
  // 1st conversion parameter: separation in XY plane 
  dXY = d - R1 - R2;
  // 2nd conversion parameter: "angular" separation 
  dCot = Trk1->Lam0() - Trk2->Lam0(); 
  // 3rd conversion parameter: radius of conversion 
  double xa1, xa2, xa, ya1, ya2, ya;
  xa1=x1+(x2-x1)*R1/(R1+R2);
  xa2=x2+(x1-x2)*R2/(R1+R2);
  ya1=y1+(y2-y1)*R1/(R1+R2);
  ya2=y2+(y1-y2)*R2/(R1+R2);
  xa=(xa1+xa2)/2.0;
  ya=(ya1+ya2)/2.0;
  R = sqrt((xa1+xa2)*(xa1+xa2)/4 + (ya1+ya2)*(ya1+ya2)/4);
  // 4th conversion parameter: impact parameter of conversion photon
  double _x[3]={x1,x2,xa};
  double _y[3]={y1,y2,ya};
  double _r[2]={R1,R2};
  convD0=myConversionImpact(_x,_y,_r,Trk1->Z0());
  //5th conversion parameter: dPhi between conv. photon and 1st conv. track(track of interest)
  if(R>0.0) dPhi=acos((cos(Trk1->Phi0())*xa+sin(Trk1->Phi0())*ya)/R); //not corrected for beam offset
  else dPhi=1.0E6;
  // filling 4vector of conversion candidate
  TLorentzVector ele1;
  TLorentzVector ele2;
  ele1.SetPtEtaPhiM(Trk1->Pt(),Trk1->Eta(),myPhi0_corr(myBeam,myBeamSlope,Trk1),eM);
  ele2.SetPtEtaPhiM(Trk2->Pt(),Trk2->Eta(),myPhi0_corr(myBeam,myBeamSlope,Trk2),eM);
  conv = ele1 + ele2;

  return;
}

//____________________________________________________________________________
// computes impact parameter for conversion photon
double TMyZeeFilterModule::myConversionImpact(double x[3], double y[3], double R[2], double z) 
{
  double d0=1.0E6;
  if(x[1]==x[0]) 
    {
      std::cout<<"----!!! WARNING: circles have same x, x1= "<<x[0]<<", x2= "<<x[1]<<std::endl;
//       if(y[1]>0.0) d0=y[1]-R[1]-0.5*(fabs(y[1]-y[0])-R[1]-R[0]); 
//       else d0=y[1]+R[1]+0.5*(fabs(y[1]-y[0])-R[1]-R[0]);
      d0=y[2]-myBeam.y()-myBeamSlope.y()*z; 
      return d0;
    }
  if(y[1]==y[0]) 
    {
      std::cout<<"----!!! WARNING: circles have same y, y1= "<<y[0]<<", y2= "<<y[1]<<std::endl;
//       if(x[1]>0.0) d0=x[1]-R[1]-0.5*(fabs(x[1]-x[0])-R[1]-R[0]); 
//       else d0=x[1]+R[1]+0.5*(fabs(x[1]-x[0])-R[1]-R[0]);
      d0=x[2]-myBeam.x()-myBeamSlope.x()*z;
      return d0;
    }
//   double d=sqrt((x[0]-x[1])*(x[0]-x[1])+(y[0]-y[1])*(y[0]-y[1]));
//   double dxy=d-R[0]-R[1];
//   double xc=x[0]+(R[0]+0.5*dxy)*(x[1]-x[0])/d; // still to be corrected for beam offset
  double xc=x[2]; // not corrected for beam offset 
  double A=(y[0]*x[1]-y[1]*x[0])/(x[1]-x[0]);
  double B=(y[1]-y[0])/(x[1]-x[0]);
  double C=myBeam.y()-B*myBeam.x()+(myBeamSlope.x()-B*myBeamSlope.x())*z; // correction for beam offset
  d0=((A-C)*B/(1.0+B*B)+xc)*sqrt(1.0+B*B);

  return d0;
} 


//____________________________________________________________________________
// applies simple conversion cuts, returns 0--if don't pass and 1--if pass
int TMyZeeFilterModule::myConversionSelector(double dXY, double dCot, double R, double &convChi2)
{
  int convStatus=1;

  if(fabs(dXY)>fConv_dXYmax) return 0;
  if(fabs(dCot)>fConv_dCotMax) return 0;
  if(R>fConv_Rmax) return 0;
  convChi2=(dXY*dXY)/(fConv_dXYmax*fConv_dXYmax)+
    (dCot*dCot)/(fConv_dCotMax*fConv_dCotMax);

  return convStatus;
}


//____________________________________________________________________________
// looks for conversions, returns conversion status code, 
// fills best conversion candidate params. 
int TMyZeeFilterModule::myConversionFilter(TStnTrack* Trk, int trkInd, int eleInd, 
					   TStnTrackBlock* fTrackBlck, 
					   TStnElectronBlock* fEleBlck, int& triStatus)
{
  int ConvStatus=0;
  int TridentStatus=0;
  if(eleInd<2 && Trk!=NULL) 
    {
      int Nconv=0;
      int Ntrident=0;
      int Ntrk=fTrackBlck->NTracks();
      double _bestChi2=1.0E6;
      double _best_dXY=-1.0E6;
      double _best_dCot=-1.0E6;
      double _best_R=-1.0E6;
      double _best_myRconv=-1.0E6;
      double _best_dmyRconv=-1.0E6;
      double _best_D0=-1.0E6;
      double _best_dPhi=-1.0E6;
      int _bestConvInd=-1;
      int _bestTrkAlgo=-1;
      int _bestEleInd=-1;

      double _bestTriChi2=1.0E6;
      double _triD0=-1.0E6;
      double _triR=-1.0E6;
      double _triMyRconv=-1.0E6;

      TLorentzVector _bestConv;
      
      double _R1=myRawRconv(Trk);
      for(int i=0; i<Ntrk; i++)
	{  //+++++_____ first conversion loop
	  TStnTrack* convTrk1 = fTrackBlck->Track(i);
	  if(i!=trkInd && 
	     fabs(Trk->Charge()+convTrk1->Charge())<0.0001 &&
	     (convTrk1->NCotAxSeg(5)>fCovCotAxSegMin && 
	      convTrk1->NCotStSeg(5)>fCovCotStSegMin)) // Ray uses && condition
	    {
	      double _dXY=9999.9;
	      double _dCot=9999.9;
	      double _R=9999.9;
	      double _D0=9999.9;
	      double _convChi2=3.0; // dummy value, _convChi2<=2.0 by definition
	      double _dPhi=9999.9;
	      TLorentzVector _conv4vec(0.0,0.0,0.0,0.0);
	      myConversionComputer(Trk,convTrk1,_dXY,_dCot,_R,_D0,_dPhi,_conv4vec);
	      if(myConversionSelector(_dXY,_dCot,_R,_convChi2)==1) // check if conversion
		{
		  Nconv++;
		  if(_convChi2<_bestChi2) 
		    {
		      _bestChi2=_convChi2;
		      _bestConvInd=i;
		      _bestConv=_conv4vec;
		      _best_dXY=_dXY;
		      _best_dCot=_dCot;
		      _best_R=_R;
		      _best_D0=_D0;
		      _best_dPhi=_dPhi;
		      _best_myRconv=myRawRconv(convTrk1);
		      _best_dmyRconv=_R1-_best_myRconv;
		      _bestTrkAlgo=convTrk1->Algorithm();
		    } 
		}
	    } 
	} //+++++_____ end of first conversion loop
      //________________________________________________________
      //--------------------------------------------------------
      if(Nconv>0) // searching for tridents
	{
	  TStnTrack* convTrk1 = fTrackBlck->Track(_bestConvInd);
	  for(int i=0; i<Ntrk; i++)
	    { //+++++_____ second (trident) conversion loop
	      TStnTrack* convTrk2 = fTrackBlck->Track(i);
	      if(i!=trkInd && i!=_bestConvInd &&
		 fabs(convTrk1->Charge()+convTrk2->Charge())<0.0001 &&
		 (convTrk2->NCotAxSeg(5)>fCovCotAxSegMin && 
		  convTrk2->NCotStSeg(5)>fCovCotStSegMin)) // Ray uses && condition
		{
		  double _dXY=9999.9;
		  double _dCot=9999.9;
		  double _R=9999.9;
		  double _D0=9999.9;
		  double _dPhi=9999.9;
		  double _convChi2=3.0; // dummy value, _convChi2<=2.0 by definition
		  TLorentzVector _conv4vec(0.0,0.0,0.0,0.0);
		  myConversionComputer(convTrk1,convTrk2,_dXY,_dCot,_R,_D0,_dPhi,_conv4vec);
		  if(myConversionSelector(_dXY,_dCot,_R,_convChi2)==1) 
		    {
		      Ntrident++;
		      if(_convChi2<_bestTriChi2)
			{
			  _bestTriChi2=_convChi2;
			  _triD0=_D0;
			  _triR=_R;
			  _triMyRconv=myRawRconv(convTrk2);
			}
		    }
		} 
	    } //+++++_____ end of second (trident) conversion loop
	}
      int _Nele=fEleBlck->NElectrons();
      for(int i=0; i<_Nele && _bestEleInd<0; i++)
	{
	  if(i!=eleInd) 
	    {
	      TStnElectron* _myEle = fEleBlck->Electron(i);
	      if(_bestConvInd==_myEle->TrackNumber() && 
		 _myEle->TrackNumber()>-1) _bestEleInd=i+1; 
	    }
	}
      if(_bestEleInd>0) ConvStatus=_bestEleInd; //there is a match, eleInd+1 is returned 
      else ConvStatus=-Nconv; // non match, -Nconv is returned

      myConvStuff.conv_Ncand[eleInd]=Nconv; 
      if(Nconv>0)
	{
	  myConvStuff.conv_Chi2[eleInd]=_bestChi2;  
	  myConvStuff.conv_dXY[eleInd]=_best_dXY;
	  myConvStuff.conv_dCot[eleInd]=_best_dCot; 
	  myConvStuff.conv_R[eleInd]=_best_R;
	  myConvStuff.conv_myRconv[eleInd]=_best_myRconv; 
	  myConvStuff.conv_dmyRconv[eleInd]=_best_dmyRconv;
	  myConvStuff.conv_D0[eleInd]=_best_D0;
	  myConvStuff.conv_dPhi[eleInd]=_best_dPhi;
	  myConvStuff.conv_ConvInd[eleInd]=_bestConvInd;
	  myConvStuff.conv_TrkAlgo[eleInd]=_bestTrkAlgo;
	  myConvStuff.conv_EleInd[eleInd]=_bestEleInd;
	  if(eleInd==0) myConvStuff.conv_pho1=_bestConv; 
	  if(eleInd==1) myConvStuff.conv_pho2=_bestConv;
	  if(Ntrident>0) 
	    {
	      myConvStuff.tri_D0[eleInd]=_triD0; 
	      myConvStuff.tri_R[eleInd]=_triR;  
	      myConvStuff.tri_myRconv[eleInd]=_triMyRconv; 
	    }
	}
      if(Ntrident>0) triStatus=1;
      else triStatus=0;
    }
  return ConvStatus;
}


//____________________________________________________________________________
// returns Iso corrected for leakage & nvx12
double TMyZeeFilterModule::myCorrIso(TStnElectron* ele) {

  TMyVertexFilterModule* MyVertex=
    (TMyVertexFilterModule*) ((TStnAna*) GetAna()->GetModule("MyVertexFilter")); 
  int nvx12=MyVertex->GetmyNvx12(); //num of class12 vertices  
  double Iso=ele->Iso();
  Iso=Iso - (nvx12>1? 0.3563*(nvx12-1) : 0.0) - ele->LeakageEnergy();
  return Iso;
}

//____________________________________________________________________________
// returns Iso/Et(ele) corrected for leakage & nvx12
double TMyZeeFilterModule::myCorrIsoFr(TStnElectron* ele) {
  return myCorrIso(ele)/ele->Et();
}

//____________returns corrected E of electrons (includes all corrections)_________ 
double TMyZeeFilterModule::myCorrEnergyEle(TStnElectron* ele) {
  return (ele->Et()>0.0? ele->E()*myCorrEtEle(ele)/(ele->Et()) : ele->E());
}

//____________returns corrected Et of electrons (includes all corrections)_________ 
double TMyZeeFilterModule::myCorrEtEle(TStnElectron* ele) {
  double et=ele->Et();
  double factor=1.0;
  factor=ele->Etcor(); // provide that fEtcor has already been corrected by Ray's CorrectElectronEnergy()
  //----------------- Commented out part is absolete
//   int mcFlag=GetHeaderBlock()->McFlag();
//   int detFlag=ele->DetectorCode();
//   if(et>0.0)
//     {
//       if(mcFlag!=0) // correction for MC
// 	{
// 	  if(detFlag==0) factor *= 0.996; // CEM
// 	  if(detFlag==1) factor *= (fabs(ele->DetEta())>1.78? 0.998 : 0.996); // PEM
// 	}
//       else // correction for data 
// 	{ 
// 	  if(detFlag==1) // PEM only
// 	    {
// 	      if(fabs(ele->DetEta())<1.78) factor *= (ele->DetEta()>0.0? 1.020 : 1.015);
// 	      else factor *= (ele->DetEta()>0.0? 1.010 : 1.007);
// 	    }
// 	}
//       if(detFlag==0) 
// 	{
//  	  et=et*(1.0+ele->LeakCorr());
//  	  if(ele->Etcor()!=-1) et *= ele->Etcor();
// 	}
//       if(detFlag==1) 
// 	{
//  	  et=et*(1.0+ele->LeakCorr());
//  	  if(ele->Etcor()!=-1) et *= ele->Etcor();
//  	  et += (ele->Et())*(ele->PprEnergy())/(ele->E());
// 	}
//     }
  et *= factor;
  return et;
}

//_____________________________________________________________________________
int TMyZeeFilterModule::BeginJob() {
				// register the data block

  RegisterDataBlock("TrackBlock"   ,"TStnTrackBlock"   ,&fTrackBlock);
  RegisterDataBlock("ElectronBlock","TStnElectronBlock",&fElectronBlock);
  RegisterDataBlock("PhotonBlock","TStnPhotonBlock",&fPhotonBlock);
  RegisterDataBlock("Phoenix_Electrons","TPhoenixElectronBlock",&fPhxEleBlock); // phoenix stuff
  RegisterDataBlock("PROD@PhoenixSI_Tracking","TStnTrackBlock",&fPhxSiTrackBlock); // phoenix stuff

  BookHistograms(); // book histograms

  InitMyBeamLineOld(); // init my beamline--- beam off-set correction part
  EventCount_b=0;
  EventCount_a=0;

  return 0;
}

//_____________________________________________________________________________
int TMyZeeFilterModule::BeginRun() {

  //----------------------- beam off-set correction part ----------------------------------
  InitMyBeamLineNew(GetHeaderBlock()->RunNumber());
  GetMyBeamLine(myBeam,myBeamSlope,(GetHeaderBlock()->RunNumber()));
  if(fUseVerbose==1) 
    {
      std::cout<<"================================================================"<<std::endl;
      std::cout<<"                                                                "<<std::endl;
      std::cout<<"TMyZeeFilterModule::BeginRun ===> starting run "
	       <<GetHeaderBlock()->RunNumber()<<std::endl;
      std::cout<<"Beam x, y:        "<<myBeam.x()<<"  "<<myBeam.y()<<std::endl;
      std::cout<<"Beam Slope x, y:  "<<myBeamSlope.x()<<"  "<<myBeamSlope.y()<<std::endl;     
      std::cout<<"________________________________________________________________"<<std::endl;
    }
  //_____________________________________________________________________________________

  return 0;
}

//_____________________________________________________________________________
int TMyZeeFilterModule::Event(int ientry) {

  EventCount_b++;
  
  ClearModuleOutput();
  bool pass   = false;
//   if(! fPhotonBlock) 
//     {
//       pass=false;
//       SetPassed(0);
//       return -1;
//     }
//   fPhotonBlock->GetEntry(ientry);

  if(! fTrackBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fTrackBlock->GetEntry(ientry);


  if(! fElectronBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fElectronBlock->GetEntry(ientry);


  if(! fPhxSiTrackBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fPhxSiTrackBlock->GetEntry(ientry);  // getting phoenix tracks


  if(! fPhxEleBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fPhxEleBlock->GetEntry(ientry); // getting phoenix electrons


//==============================================================================================  
//------------------------------------- accessing MyVertexFilterModule
//______________________________________________________________________________________________
  TMyVertexFilterModule* MyVertex=
    (TMyVertexFilterModule*) ((TStnAna*) GetAna()->GetModule("MyVertexFilter")); /* this has to be
     modified later: name of my vertex filter has to be passed from outside (there can be several
     MyVertexFilter modules performing different tasks). Current declaration assumes that I default
     initialize TMyVertexFilterModule in my Root macro. */
  double zvx_best=MyVertex->GetmyZvx_best();
  int my_nvx12=MyVertex->GetmyNvx12(); //num of class12 vertices  
  //______________________________________________________________________________________________
  //_____ applying Ray's electron energy correction
  int eleCor_stat=0;
  eleCor_stat=TStntuple::CorrectElectronEnergy(GetHeaderBlock()->GetEvent(),zvx_best); 

  int _convWrd[10]={0,0,0,0,0,0,0,0,0,0}; // it's highly unlikely to have >10 good electrons per event

  int _myNele=0; // total number of electron candidates
  int _myNcem=0; // total number of CEM electrons
  int _myNpem=0; // total number of PEM electrons
  int _myNeleL=0; // number leading electrons passing cuts
  int _myNeleE=0; // number extra electrons (definition is not final yet)
  int _myNcemT=0; // number of tight CEM eletrons 
  int _myNcemL=0; // number of loose CEM eletrons 
  int _myNpemT=0; // number of tight PEM eletrons 
  int _myNpemL=0; // number of loose PEM eletrons 
  int _myNcem_good=0; // number of CEM electrons that pass MyExtraCemCut
  int _myEleStat[10]={-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}; // it's highly unlikely to have >10 good electrons per event
  int _myEleCharge[10]={0,0,0,0,0,0,0,0,0,0}; // it's highly unlikely to have >10 good electrons per event
  int _trk_ind=-1;
  int _ind_passed[10]; // it's highly unlikely to have >10 good electrons per event
  int _ele_count=0;

  _myNele = fElectronBlock->NElectrons();
  fEleHist.fEleNcand_b->Fill(_myNele); // number of electron candidates before cuts

  for (int i=0; i<_myNele; i++) 
    {
      TStnElectron* _myEle = fElectronBlock->Electron(i);
      if(_myEle->DetectorCode()==0) _myNcem++;
      if(_myEle->DetectorCode()==1) _myNpem++;
      FillEleGeneralHistogramsB(fEleHist,_myEle);
      _trk_ind=_myEle->TrackNumber();
      TStnTrack* _myTrk = NULL; // this needs a double-check; potential source of problems
      if(_trk_ind>-1) _myTrk = fTrackBlock->Track(_trk_ind); // getting "regular" track	
      //*********** ATTN!!! using regular tracks for ConversionFilter 
      int _tridentWord=0;
      int _convWord=myConversionFilter(_myTrk,_trk_ind,i,fTrackBlock,fElectronBlock,_tridentWord);
      int _myConvStat=0;
      if(_convWord!=0 && _tridentWord==0) _myConvStat=1;
      if(_tridentWord!=0) _myConvStat=-1;
      //*********** ATTN!!! using regular and phoenix tracks for all other applications 
      if(_trk_ind>-1 && _myEle->DetectorCode()==0) _myTrk = fTrackBlock->Track(_trk_ind); // getting "regular" track	
      if(_myEle->DetectorCode()==1) _myTrk=GetMyPnxTrack(GetHeaderBlock()->GetEvent(),_myEle);// getting phoenix track      
      FillCEMHistogramsB(fCEMHist,_myEle,_myTrk,i,_myConvStat);
      FillPEMHistogramsB(fPEMHist,GetHeaderBlock()->GetEvent(),_myEle,_myTrk,i,_myConvStat);
      FillConversionHistograms(fConvHist,i,_tridentWord); // fill all conversions

      if(MyCemLooseIDcut(_myEle,_myTrk,i,_convWord)==1)
	{
	  _ind_passed[_ele_count]=i;
	  _convWrd[_ele_count]=_myConvStat;
	  _myNcem_good=_myNcem_good+MyExtraCemCut(_myEle,_myTrk);
	  if(myCorrEtEle(_myEle)>fEleEt_leading) _myNeleL++; // counting number of leading electrons passing at least loose cuts
	  if(MyCemTightIDcut(_myEle,_myTrk,i)==1)
	    {
	      _myEleStat[_ele_count]=0;
	      _myNcemT++;
	    } 
	  else 
	    {
	      _myEleStat[_ele_count]=7;
	      _myNcemL++;
	    }
	  if(_myTrk!=NULL) _myEleCharge[_ele_count]=_myTrk->Charge();
	  _ele_count++;
	}
      if(MyPemLooseIDcut(_myEle,i)==1)
	{
	  _ind_passed[_ele_count]=i;
	  _convWrd[_ele_count]=_myConvStat;

	  if(myCorrEtEle(_myEle)>fEleEt_leading) _myNeleL++; // counting number of leading electrons passing at least loose cuts
	  if(MyPemTightIDcut(_myEle,_myTrk,i)==1)
	    {
	      _myEleStat[_ele_count]=9;
	      _myNpemT++;
	    } 
	  else 
	    {
	      _myEleStat[_ele_count]=11;
	      _myNpemL++;
	    }
	  if(_myTrk!=NULL) _myEleCharge[_ele_count]=_myTrk->Charge();
	  _ele_count++;
	}
    }
  _myNcem=_myNcemT+_myNcemL;
  _myNpem=_myNpemT+_myNpemL;
  _myNeleE=_myNcemT+_myNcemL+_myNpemT+_myNpemL-_myNeleL; 
  fCEMHist.fCemNcand_b->Fill(_myNcem);
  fPEMHist.fPemNcand_b->Fill(_myNpem);

  //_______________________________________________________________________________
  // re-ordering electrons, if needed
  int reorder_word=0;
  int reorder_word_last=0;
  for(int j=0; j<_myNeleL+_myNeleE-1; j++)
    {
      reorder_word_last=reorder_word;
      for(int i=1; i<_myNeleL+_myNeleE; i++)
	{
	  TStnElectron* _myEleThis = fElectronBlock->Electron(_ind_passed[i]);
	  TStnElectron* _myEleLast = fElectronBlock->Electron(_ind_passed[i-1]);   
	  if(myCorrEtEle(_myEleThis)>myCorrEtEle(_myEleLast)) 
	    {
	      int serv_ind=_ind_passed[i-1];   // sorting index
	      _ind_passed[i-1]=_ind_passed[i];
	      _ind_passed[i]=serv_ind;
	      //_______________________________
	      serv_ind=_myEleStat[i-1];        // sorting status
	      _myEleStat[i-1]=_myEleStat[i];
	      _myEleStat[i]=serv_ind;
	      //_______________________________
	      serv_ind=_myEleCharge[i-1];      // sorting charge
	      _myEleCharge[i-1]=_myEleCharge[i];
	      _myEleCharge[i]=serv_ind;
	      //_______________________________
	      serv_ind=_convWrd[i-1];      // sorting conversion word
	      _convWrd[i-1]=_convWrd[i];
	      _convWrd[i]=serv_ind;
	      //_______________________________
	      reorder_word++;
	    }
	}
      if(reorder_word_last==reorder_word) break;
    }
  //___________________________________________________________________________________________

  for(int i=0; i<_myNeleL+_myNeleE; i++)
    {
      TStnElectron* _myEle = fElectronBlock->Electron(_ind_passed[i]);
      _trk_ind=_myEle->TrackNumber();
      TStnTrack* _myTrk = NULL;
      if(_trk_ind>-1 && _myEle->DetectorCode()==0) _myTrk = fTrackBlock->Track(_trk_ind); // getting "regular" track	
      if(_myEle->DetectorCode()==1) 
	{
	  _myTrk=GetMyPnxTrack(GetHeaderBlock()->GetEvent(),_myEle);// getting phoenix track
	  //---- causes "core dump" -- need to look
	  //	  _trk_ind=_myTrk->Number(); // track number in Phoenix block
	}
      FillModuleOutput(_myEle,_myTrk,GetHeaderBlock()->GetEvent(),_ind_passed[i],_trk_ind,
		       _myEleCharge[i],_myEleStat[i],_convWrd[i],_myNeleL+_myNeleE,_myNeleL,
		       _myNeleE,_myNcemT,_myNcemL,_myNpemT,_myNpemL); // fills the Module output 
      if(fUseZeeCut==0 && i<2) // filling electron histograms if "inclusive electron" mode
	{
	  FillCEMHistogramsA(fCEMHist,_myEle,_myTrk,i,_convWrd[i]); 
	  FillPEMHistogramsA(fPEMHist,GetHeaderBlock()->GetEvent(),_myEle,_myTrk,i,_convWrd[i]);
	}
    }

  //  if(fUseZeeCut==0)
  if(fUseZeeCut==0 &&
     _myNeleL>=fMinNeleL && 
     _myNeleL<=fMaxNeleL &&
     (_myNeleL+_myNeleE)>=fMinNele && 
     (_myNeleL+_myNeleE)<=fMaxNele) // modified on 11/28/05
    {
      pass=true;
      fEleHist.fEleNcand_a->Fill(_myNele);   //+++++ Filling final histograms
      fCEMHist.fCemNcand_a->Fill(_myNcem);
      fPEMHist.fPemNcand_a->Fill(_myNpem);
    }

  //--------------------------------------- stopped here ------------------------------------------------

  if(fUseZeeCut==1 && (_myNeleL+_myNeleE)>1 && _myNeleL>0)
    {
      TStnElectron* _myEle1 = fElectronBlock->Electron(_ind_passed[0]);
      TStnElectron* _myEle2 = fElectronBlock->Electron(_ind_passed[1]);
      _trk_ind=_myEle1->TrackNumber();
      TStnTrack* _myTrk1 = NULL; // this needs a double-check; potential source of problems
      if(_trk_ind>-1 && _myEle1->DetectorCode()==0) _myTrk1 = fTrackBlock->Track(_trk_ind); // getting "regular" track	
      if(_myEle1->DetectorCode()==1) _myTrk1=GetMyPnxTrack(GetHeaderBlock()->GetEvent(),_myEle1);// getting phoenix track
      _trk_ind=_myEle2->TrackNumber();
      TStnTrack* _myTrk2 = NULL; // this needs a double-check; potential source of problems
      if(_trk_ind>-1 && _myEle2->DetectorCode()==0) _myTrk2 = fTrackBlock->Track(_trk_ind); // getting "regular" track	
      if(_myEle2->DetectorCode()==1) _myTrk2=GetMyPnxTrack(GetHeaderBlock()->GetEvent(),_myEle2);// getting phoenix track
      FillZeeHistogramsB(fZeeHist,myZeeStuff);

      //-----------------------------------------------------------------------------------
      //---- Final Z->ee ID cuts ----
      if(MyZeeIDcut(myZeeStuff)==1)
	{
	  pass=true;
	  fEleHist.fEleNcand_a->Fill(_myNele);   //+++++ Filling final histograms
 	  FillCEMHistogramsA(fCEMHist,_myEle1,_myTrk1,0,_convWrd[0]); 
 	  FillPEMHistogramsA(fPEMHist,GetHeaderBlock()->GetEvent(),_myEle1,_myTrk1,0,_convWrd[0]);
 	  FillCEMHistogramsA(fCEMHist,_myEle2,_myTrk2,1,_convWrd[1]);
 	  FillPEMHistogramsA(fPEMHist,GetHeaderBlock()->GetEvent(),_myEle2,_myTrk2,1,_convWrd[1]);
	  fCEMHist.fCemNcand_a->Fill(_myNcem);
	  fPEMHist.fPemNcand_a->Fill(_myNpem);
	  FillZeeHistogramsA(fZeeHist,myZeeStuff); 
	}
      else
	{
	  pass=false;
	  if(fUseVerbose==1) 
	    std::cout<<"Event "<<ientry<<" didn't pass Z->ee cuts "<<std::endl;
	  SetPassed(0);
	  return 0;           	      	  
	}
    }

  //------- This part is new, 12/13/07
  if(fUseMyExtraCemCut==1 && _myNcem_good<_myNcem)
    {
      pass=false;
      SetPassed(0);
      return 0;
    }

  if(pass) 
    {
      EventCount_a++;
      //--------------------------------------
      // something else can be done here
      //______________________________________
      for (int i=0; i<_myNele; i++) 
	{
	  TStnElectron* _myEle = fElectronBlock->Electron(i);
	  FillEleGeneralHistogramsA(fEleHist,_myEle);
	}
      PrintModuleOutput();
      SetPassed(1);
    }
  else SetPassed(0);
  return 0;
}

//_____________________________________________________________________________
int TMyZeeFilterModule::EndJob() {

  if(fUseBeamLineDB==1)
    {
      //____________________ writing file with beam line params
      ofstream outfile("results/myBeamLine.dat", std::ios::out);
      char outputstring[200];
      for(int i=0; i<myNruns; i++)
	{
	  if(fabs(fBeam.bm_x[i])>0.0 && fabs(fBeam.bm_y[i])>0.0)
	    {
	      sprintf(outputstring,"%i  %f  %f  %f  %f",i+myFirstRun,fBeam.bm_x[i],fBeam.bmsl_x[i],fBeam.bm_y[i],fBeam.bmsl_y[i]);
	      if(i<myNruns-1) outfile<<outputstring<<"\n";
	      if(i==(myNruns-1)) outfile<<outputstring<<std::endl;
	    }
	}
    }

//   ofstream outfile(fDatFileName, std::ios::out);
  ofstream outfile(fDatFileName, std::ios::app);
  if (! outfile) 
    {
      std::cerr<<"Error of openning of .DAT file\n";
    }
  if(outfile)
    {
      std::cout<<"---------- TMyZeeFilterModule Summary -------------------------"<<std::endl;
      std::cout<<"..........Number of events before cuts "
	       <<EventCount_b<<std::endl;
      std::cout<<"..........Number of events after cuts  "
	       <<EventCount_a<<std::endl;
      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"------  TMyZeeFilterModule Summary  ----------"<<"\n";
      outfile<<"___________________________________________________"<<"\n";

      char outputstring[200];
      sprintf(outputstring,"..........Number of events before cuts = %f",
	      fEleHist.fEleNcand_b->GetEntries());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,"..........Number of events after cuts = %f",
	      fEleHist.fEleNcand_a->GetEntries());
      outfile<<outputstring<<"\n";
      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"-------- BEFORE CUTS ------------------------------"<<"\n";
      outfile<<"Format of output: ___Histo name___Nentries___mean___rms___"<<"\n";
      outfile<<".........................................................."<<"\n";
      outfile<<HistoSummary(fZeeHist.fZeeNCEMtight_b)<<"\n";      
      outfile<<HistoSummary(fZeeHist.fZeeNCEMloose_b)<<"\n"; 
      outfile<<HistoSummary(fZeeHist.fZeeNPEMtight_b)<<"\n";        
      outfile<<HistoSummary(fZeeHist.fZeeNPEMloose_b)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeNele_b)<<"\n";             
      outfile<<HistoSummary(fZeeHist.fZeeNeleE_b)<<"\n";
      outfile<<HistoSummary(fZeeHist.fZeeM_b)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeMtrk_b)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeE_b)<<"\n";         
      outfile<<HistoSummary(fZeeHist.fZeeEt_b)<<"\n";         
      outfile<<HistoSummary(fZeeHist.fZeePhi_b)<<"\n";             
      outfile<<HistoSummary(fZeeHist.fZeeEta_b)<<"\n";             
      outfile<<HistoSummary(fZeeHist.fZeeTheta_b)<<"\n";           
      outfile<<HistoSummary(fZeeHist.fZeeDeltaPhi_b)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeDeltaEta_b)<<"\n";
      outfile<<HistoSummary(fZeeHist.fZeeDeltaR_b)<<"\n";     
      outfile<<HistoSummary(fZeeHist.fZeeFid_b)<<"\n";     
      outfile<<HistoSummary(fZeeHist.fZeeStat_b)<<"\n";    
      outfile<<HistoSummary(fZeeHist.fZeeQual_b)<<"\n";    
      outfile<<HistoSummary(fZeeHist.fZeeCharge_b)<<"\n";
         
      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"-------- AFTER CUTS ------------------------------"<<"\n";
      outfile<<"Format of output: ___Histo name___Nentries___mean___rms___"<<"\n";
      outfile<<".........................................................."<<"\n";
      outfile<<HistoSummary(fZeeHist.fZeeNCEMtight_a)<<"\n";      
      outfile<<HistoSummary(fZeeHist.fZeeNCEMloose_a)<<"\n"; 
      outfile<<HistoSummary(fZeeHist.fZeeNPEMtight_a)<<"\n";        
      outfile<<HistoSummary(fZeeHist.fZeeNPEMloose_a)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeNele_a)<<"\n";             
      outfile<<HistoSummary(fZeeHist.fZeeNeleE_a)<<"\n";
      outfile<<HistoSummary(fZeeHist.fZeeM_a)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeMtrk_a)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeE_a)<<"\n";         
      outfile<<HistoSummary(fZeeHist.fZeeEt_a)<<"\n";         
      outfile<<HistoSummary(fZeeHist.fZeePhi_a)<<"\n";             
      outfile<<HistoSummary(fZeeHist.fZeeEta_a)<<"\n";             
      outfile<<HistoSummary(fZeeHist.fZeeTheta_a)<<"\n";           
      outfile<<HistoSummary(fZeeHist.fZeeDeltaPhi_a)<<"\n";          
      outfile<<HistoSummary(fZeeHist.fZeeDeltaEta_a)<<"\n";
      outfile<<HistoSummary(fZeeHist.fZeeDeltaR_a)<<"\n";     
      outfile<<HistoSummary(fZeeHist.fZeeFid_a)<<"\n";     
      outfile<<HistoSummary(fZeeHist.fZeeStat_a)<<"\n";    
      outfile<<HistoSummary(fZeeHist.fZeeQual_a)<<"\n";    
      outfile<<HistoSummary(fZeeHist.fZeeCharge_a)<<"\n";

      outfile<<"---- The End!------"<<std::endl;
    }
  return 0;
}

