#ifndef TMYVTX_HH
#define TMYVTX_HH

#if !defined (__CINT__) || defined (__MAKECINT__)

#include "TH1.h"
#include "TH2.h"
#include "TProfile.h"
#include "TMath.h"
#include <vector>
#include <Stntuple/loop/TStnModule.hh>

//------declaration of blocks to be read
#include <Stntuple/obj/TStnHeaderBlock.hh>
#include <Stntuple/obj/TStnVertexBlock.hh>
#include <Stntuple/obj/TGenpBlock.hh>
#endif

class TMyUtil; 

class TMyVertexFilterModule: public TStnModule {
public:

  struct Hist_t {
                      //---- before cuts

    TH1F*  fGenpNvx_b; // Number of vertices in OBSP (for MC only) 
    TH1F*  fEvntNvx_b;        //Number of Vertices
    TH1F*  fEvntNvx12_b;      //Number of class>=12 Vertices
    TH1F*  fEvntVxclassbest_b;        // Class of the best vertex
    TH1F*  fEvntZvxbest_b;            // The zvx of the best vertex  
    TH1F*  fEvntVxclassAll_b;     // Class of all vertices
    TH1F*  fEvntZvxAll_b;         // zvx of all vertices  
    TH1F*  fEvntVxclass2nd_b;     // Class of the second best vertex in event
    TH1F*  fEvntZvxsep_b;         // separation between any two vertices
    TH1F*  fEvntZvxsepbest_b;     // separation between two best vertices
    TH1F*  fEvntZvxsepbest2any_b; // separation between the best vertex and any other

//     TH1F*  fEvntZvxSigma_b;       // Sigma_zvx
//     TProfile* fEvntZSigma_Zvxsepbest_b; // Sigma_zvx total vs. separation between two best vertices
//     TProfile* fEvntZSigma1_Zvxsepbest_b; // Sigma_zvx of 1st vertex vs. separation between two best vertices
//     TProfile* fEvntZSigma2_Zvxsepbest_b; // Sigma_zvx of 2nd vertex vs. separation between two best vertices 

    TH1F*  fEvntNtrkVxbest_b;     // number of tracks associated with the best vertex
    TH1F*  fEvntPtsumVxbest_b;    // Ptsum of tracks associated with the best vertex
    TH1F*  fEvntNtrkVx2nd_b;   // number of tracks associated with the second best vertex
    TH1F*  fEvntPtsumVx2nd_b;  // Ptsum of tracks associated with the second best vertex

                      //---- the same histos after cuts 

    TH1F*  fGenpNvx_a; // Number of vertices in GENP (for MC only) 
    TH1F*  fEvntNvx_a;            //Number of Vertices
    TH1F*  fEvntNvx12_a;          //Number of class>=12 Vertices
    TH1F*  fEvntVxclassbest_a;        // Class of the best vertex
    TH1F*  fEvntZvxbest_a;            // The zvx of the best vertex  
    TH1F*  fEvntVxclassAll_a;     // Class of all vertices
    TH1F*  fEvntZvxAll_a;         // zvx of all vertices  
    TH1F*  fEvntVxclass2nd_a;     // Class of the second best vertex in event
    TH1F*  fEvntZvxsep_a;         // separation between any two vertices
    TH1F*  fEvntZvxsepbest2any_a; // separation between the best vertex and any other
    TH1F*  fEvntZvxsepbest_a;     // separation between two best vertices

//     TH1F*  fEvntZvxSigma_a;       // Sigma_zvx
//     TProfile* fEvntZSigma_Zvxsepbest_a; // Sigma_zvx total vs. separation between two best vertices
//     TProfile* fEvntZSigma1_Zvxsepbest_a; // Sigma_zvx of 1st vertex vs. separation between two best vertices
//     TProfile* fEvntZSigma2_Zvxsepbest_a; // Sigma_zvx of 2nd vertex vs. separation between two best vertices 

    TH1F*  fEvntNtrkVxbest_a;     // number of tracks associated with the best vertex
    TH1F*  fEvntPtsumVxbest_a;    // Ptsum of tracks associated with the best vertex
    TH1F*  fEvntNtrkVx2nd_a;   // number of tracks associated with the second best vertex
    TH1F*  fEvntPtsumVx2nd_a;  // Ptsum of tracks associated with the second best vertex

  };

  enum { myNvxArray = 50 };

private:

  TMyUtil*  fMyUtil; // pointer to my UtilityModule
                     // this Module will contain methods
                     // which will be common for all Analysis Modules

protected:

  char histo_outputstring[200];

//________________________________________ pointers to the data blocks used,
					// header block is always available via
                                        // TStnModule::GetHeaderBlock()
  TStnVertexBlock*   fZVertexBlock;
  TGenpBlock*        fGenpBlock;
  

//________________________________________ histograms filled
  Hist_t    fHist;
//________________________________________ cuts
  int fUseVerbose;   // status code to invoke Debugging mode (print out)

  double  fMinZvx;          //  cut on the vertex Z-position (all classes) 
  double  fMaxZvx;     
  double  fMinZvx_best;     //  cut on the Z-position of the best vertex 
  double  fMaxZvx_best;     
  double  fMinZsep;         //  cut on the minimum Z-separation of any two vertices 
  double  fMaxZsep;
  double  fMinZsep_best2any; // cut on separation between the best vertex and any other
  double  fMaxZsep_best2any;     
  double  fMinZsep_best;    //  cut on the minimum Z-separation of two best vertices 
  double  fMaxZsep_best;     
  int  fMinNvx;             // number of vertices in event (all classes)
  int  fMaxNvx;  
  int  fMinNvx12;           // number of vertices in event (class>=12)
  int  fMaxNvx12;  
  int  fMinVxclass_best;    // class of the best vertex
  int  fMaxVxclass_best;   
  int  fMinVxclass_2nd;  // class of the second best vertex
  int  fMaxVxclass_2nd;   

  int fUseVxWeight; // to re-weight vertices

  char* fDatFileName;    //-- summary file name

//_________________________________ results of the Module 
    
  double  fmyZvx_best;      //  the Z-position of the best vertex 
  double  fmyZvx_2nd;       //  the Z-position of the 2-nd vertex 
  double  fmyZsep_best;     //  the Z-separation of two best vertices 
  int  fGenpNvx;              // number of interactions in MC event
  int  fmyNvx;              // number of vertices in event (all classes)
  int  fmyNvx12;            // number of class>=12 vertices in event  
  int  fmyVxclass_best;     // class of the best vertex
  int  fmyVxclass_2nd;      // class of the second best vertex
  int  fmyNtrkVx_best;      // number of tracks associated with the best vertex
  int  fmyNtrkVx_2nd;       // number of tracks associated with the 2nd vertex
  std::vector<int> myVxclass; // class of all vertices in event
  std::vector<double> myZvx;  // zvx of all vertices in event

public:
  TMyVertexFilterModule(const char* name ="MyVertexFilter", 
			  const char* title="MyVertexFilter");
  ~TMyVertexFilterModule();

//________________________________________ ****** accessors

  Hist_t*             GetHist()          { return &fHist; }
  TStnVertexBlock*    GetZVertexBlock()  { return fZVertexBlock; }

  //______________________________________________________ Module results
  double  GetmyZvx_best()   { return fmyZvx_best; }     
  double  GetmyZvx_2nd()    { return fmyZvx_2nd; }     
  double  GetmyZsep_best()  { return fmyZsep_best; }     
  int  GetGenpNvx()         { return fGenpNvx; }
  int  GetmyNvx()           { return fmyNvx; }          
  int  GetmyNvx12()         { return fmyNvx12; }          
  int  GetmyVxclass_best()  { return fmyVxclass_best; }  
  int  GetmyVxclass_2nd()   { return fmyVxclass_2nd; }   
  int  GetmyNtrkVx_best()   { return fmyNtrkVx_best; }      
  int  GetmyNtrkVx_2nd()    { return fmyNtrkVx_2nd; }      
  int  GetmyVxclass(int i)   { 
    if(i>=0 && i<myVxclass.size()) return myVxclass[i];
    else return 0;
  }
  double  GetmyZvx(int i)   { 
    if(i>=0 && i<myZvx.size()) return myZvx[i];
    else return 0.0;
  }

//________________________________________ ****** cut values
  int    GetUseVerbose()           { return fUseVerbose; }

  double  GetMinZvx()            { return fMinZvx; }          
  double  GetMaxZvx()            { return fMaxZvx; }     
  double  GetMinZvx_best()       { return fMinZvx_best; }     
  double  GetMaxZvx_best()       { return fMaxZvx_best; }     
  double  GetMinZsep()           { return fMinZsep; }         
  double  GetMaxZsep()           { return fMaxZsep; }     
  double  GetMinZsep_best()      { return fMinZsep_best; }    
  double  GetMaxZsep_best()      { return fMaxZsep_best; }    
  double  GetMinZsep_best2any()  { return fMinZsep_best2any; }
  double  GetMaxZsep_best2any()  { return fMaxZsep_best2any; }    
  int     GetMinNvx()            { return fMinNvx; }             
  int     GetMaxNvx()            { return fMaxNvx; }  
  int     GetMinNvx12()          { return fMinNvx12; }             
  int     GetMaxNvx12()          { return fMaxNvx12; }  
  int     GetMinVxclass_best()   { return fMinVxclass_best; }    
  int     GetMaxVxclass_best()   { return fMaxVxclass_best; }    
  int     GetMinVxclass_2nd()    { return fMinVxclass_2nd; }  
  int     GetMaxVxclass_2nd()    { return fMaxVxclass_2nd; }  

                                        // ****** utility methods

  int Class2Cut(int class1, int class2) {   //*** this function compares
    int min_class=TMath::Min(class1,class2);    // the quality of two vertices
    if      (min_class >= 60) return 7;           // and returs the index to be  
    else if (min_class >= 28) return 6;           // used in determinig which 
    else if (min_class >= 12) return 5;           // cut value on zvx-sep to apply
    else if (min_class >=  7) return 4;
    else if (min_class >=  4) return 3;
    else if (min_class >=  3) return 2;
    else if (min_class >=  1) return 1;
    else             return 0;
  }

  int Class2Histo(int class1) {    //*** this function returns 
    if      (class1 >= 60) return 7;   // the index of histogram
    else if (class1 >= 28) return 6;   // to be filled
    else if (class1 >= 12) return 5;
    else if (class1 >=  7) return 4;
    else if (class1 >=  4) return 3;
    else if (class1 >=  3) return 2;
    else if (class1 >=  1) return 1;
    else             return 0;
  }

  int Index2Class(int ind) {       //*** this function returns 
    if      (ind == 7) return 60;      // vertex class of events
    else if (ind == 6) return 28;      // corresponding to Histo[ind] 
    else if (ind == 5) return 12;
    else if (ind == 4) return 7;
    else if (ind == 3) return 4;
    else if (ind == 2) return 3;
    else if (ind == 1) return 1;
    else             return 0;
  }

  char* HistoSummary(TH1F* myhisto)
  {
    sprintf(histo_outputstring,"...%s   %f   %f",
	    myhisto->GetName(),
	    myhisto->GetMean(),
	    myhisto->GetRMS());
    
    return histo_outputstring;
  }
 
  char*   GetDatFileName()       { return fDatFileName; }
 
					// ****** setters
  void SetUseVerbose        (int cut)              { fUseVerbose = cut; }

  void  SetMinZvx            (double cut)          { fMinZvx = cut; }          
  void  SetMaxZvx            (double cut)          { fMaxZvx = cut; }     
  void  SetMinZvx_best       (double cut)          { fMinZvx_best = cut; }     
  void  SetMaxZvx_best       (double cut)          { fMaxZvx_best = cut; }     
  void  SetMinZsep           (double cut)          { fMinZsep = cut; }         
  void  SetMaxZsep           (double cut)          { fMaxZsep = cut; }     
  void  SetMinZsep_best2any  (double cut)          { fMinZsep_best2any = cut; }
  void  SetMaxZsep_best2any  (double cut)          { fMaxZsep_best2any = cut; }    
  void  SetMinZsep_best      (double cut)          { fMinZsep_best = cut; }    
  void  SetMaxZsep_best      (double cut)          { fMaxZsep_best = cut; }    
  void  SetMinNvx            (int cut)             { fMinNvx = cut; }             
  void  SetMaxNvx            (int cut)             { fMaxNvx = cut; }  
  void  SetMinNvx12            (int cut)             { fMinNvx12 = cut; }             
  void  SetMaxNvx12            (int cut)             { fMaxNvx12 = cut; }  
  void  SetMinVxclass_best   (int cut)             { fMinVxclass_best = cut; }    
  void  SetMaxVxclass_best   (int cut)             { fMaxVxclass_best = cut; }    
  void  SetMinVxclass_2nd    (int cut)             { fMinVxclass_2nd = cut; }  
  void  SetMaxVxclass_2nd    (int cut)             { fMaxVxclass_2nd = cut; }  
  void  SetUseVxWeight       (int cut)             { fUseVxWeight = cut; }
  //______________________________________________________ Setting Module results
  void  SetmyZvx_best        (double value)        { fmyZvx_best = value; }     
  void  SetmyZvx_2nd         (double value)        { fmyZvx_2nd = value; }     
  void  SetmyZsep_best       (double value)        { fmyZsep_best = value; }     
  void  SetmyNvx             (int value)           { fmyNvx = value; }          
  void  SetmyNvx12           (int value)           { fmyNvx12 = value; }          
  void  SetmyVxclass_best    (int value)           { fmyVxclass_best = value; }  
  void  SetmyVxclass_2nd     (int value)           { fmyVxclass_2nd = value; }   
  void  SetmyNtrkVx_best     (int value)           { fmyNtrkVx_best = value; }      
  void  SetmyNtrkVx_2nd      (int value)           { fmyNtrkVx_2nd = value; }      

  void  SetmyVxclass(int i, int value)   { 
    if(i>=0 && i<myVxclass.size()) myVxclass[i] = value;
    else myVxclass.push_back(value); 
  }
  void  SetmyZvx(int i, double value)   { 
    if(i>=0 && i<myZvx.size()) myZvx[i] = value;
    else myZvx.push_back(value);
  }
  //_____________________________________________________________________________________________
  void ClearModuleOutput()                      // clears the Module output from previous event.		 
  {	
    fGenpNvx=-1;				 
    fmyZvx_best=0.0;      			// -----------------------------       	 
    fmyZvx_2nd=0.0;       			// ******* IMPORTANT!!! ********        	 
    fmyZsep_best=0.0;     			// This method has to be called for every event!
    fmyNvx=0;              
    fmyNvx12=0;              
    fmyVxclass_best=0;     
    fmyVxclass_2nd=0;      
    fmyNtrkVx_best=0;      
    fmyNtrkVx_2nd=0;       
    myVxclass.clear(); 
    myZvx.clear();  
    return;
  }

//______________________________________________________
  void  SetDatFileName       (char* fname)         { fDatFileName = fname; }    

  void    Display();
					// ****** overloaded methods of 
					// TStnModule
  int     BeginJob();
  int     BeginRun();
  int     Event   (int ientry);
  int     EndJob  ();
					// ****** other methods
  void    BookHistograms();
  int     VxWeight(int _Nvx);

  ClassDef(TMyVertexFilterModule,0)
};

#endif
