/*
  Module to filter events based on vertex information, book vertex info Histos
  This is a filter for dijet, pho+jet and dipho events.

  See myEventFilter.C program for example of how to use TMyVertexFilterModule
*/


//_____________________________________________________________________________
// Em filter module
//_____________________________________________________________________________
#include <iomanip>
#include <iostream>
#include <fstream>
#include "TF1.h"
#include <TRandom.h>
#include "TCanvas.h"
#include "Stntuple/loop/TStnAna.hh"
#include "TMyVertexFilterModuleA_ntu.hh"
#include "TMyUtil.hh"

// ClassImp(TMyVertexFilterModule)
//_____________________________________________________________________________
TMyVertexFilterModule::TMyVertexFilterModule(const char* name, const char* title):
  TStnModule(name,title)
{
  //------- setting default cut values
  fUseVerbose=0;

  fMinZvx=-200.0;      
  fMaxZvx=200.0;     
  fMinZvx_best=-200.0; 
  fMaxZvx_best=200.0;  
  fMinZsep=-1.0;        
  fMaxZsep=10000.0;     
  fMinZsep_best2any=-1.0; 
  fMaxZsep_best2any=10000.0;
  fMinZsep_best=-1.0;   
  fMaxZsep_best=10000.0;     
  fMinNvx=-1;             
  fMaxNvx=1000;  
  fMinNvx12=-1;             
  fMaxNvx12=1000;  
  fMinVxclass_best=-1;    
  fMaxVxclass_best=1000000;   
  fMinVxclass_2nd=-1;  
  fMaxVxclass_2nd=1000000;

  fUseVxWeight=0; // 0==do nothing; 1==re-weight events according to vertex distribution 

  // initializing results
  fmyZvx_best=0.0;     
  fmyZvx_2nd=0.0;      
  fmyZsep_best=0.0;    
  fmyNvx=0;   
  fmyNvx12=0;            
  fmyVxclass_best=0;    
  fmyVxclass_2nd=0;
  fmyNtrkVx_best=0;      
  fmyNtrkVx_2nd=0;       
   
  fDatFileName="results/MyVertexFilter_output.dat";
  std::cout<<"Hi, entering TMyVertexFilterModule"<<std::endl;
}

//_____________________________________________________________________________
TMyVertexFilterModule::~TMyVertexFilterModule() {
}

//_____________________________________________________________________________
void TMyVertexFilterModule::BookHistograms() {
  char name[200];
  char title[200];

  DeleteHistograms();

  //------ booking histograms
  //-------------- ideally, histo params has 
  //-------------- to be passed into module 
  //-------------- from outside: <- to be done


                            //---- before cuts

  HBook1F(fHist.fGenpNvx_b,"GenpNvx_b","Number of interactions in MC",100,-0.5,99.5);
  HBook1F(fHist.fEvntNvx_b,"Nvx_b","Number of vertices",100,-0.5,99.5);
  HBook1F(fHist.fEvntNvx12_b,"Nvx12_b","Number of class>=12 vertices",100,-0.5,99.5);
  HBook1F(fHist.fEvntVxclassbest_b,"Vxclassbest_b","Class of best vertex",200,-0.5,1999.5);
  HBook1F(fHist.fEvntZvxbest_b,"Zvxbest_b","Zvx of best vertex",400,-200.0,200.0);  
  HBook1F(fHist.fEvntVxclassAll_b,"VxclassAll_b","Vxclass, all verteces",100,-0.5,99.5);
  HBook1F(fHist.fEvntZvxAll_b,"ZvxAll_b","zvx, all vertices",400,-200.0,200.0);
  HBook1F(fHist.fEvntVxclass2nd_b,"Vxclass2nd_b","Vxclass, 2nd best vertex",100,-0.5,99.5);
  HBook1F(fHist.fEvntZvxsep_b,"Zvxsep_b","dZ of any two vertices",800,-200.0,200.0);
  HBook1F(fHist.fEvntZvxsepbest2any_b,"Zvxsepbest2any_b","dZ of best & any vertex",800,-200.0,200.0);
  HBook1F(fHist.fEvntZvxsepbest_b,"Zvxsepbest_b","dZ of two best vertices",800,-200.0,200.0);

//   HBook1F(fHist.fEvntZvxSigma_b,"ZvxSigma_b","Sigma_zvx",50000,0.0,1.0); 
//   HProf(fHist.fEvntZSigma_Zvxsepbest_b,"ZSigma_Zvxsepbest_b","Sigma_Zsep vs. Zsep",
// 	400,-100.0,100.0,0.0,10.0); 
//   HProf(fHist.fEvntZSigma1_Zvxsepbest_b,"ZSigma1_Zvxsepbest_b","Sigma_Z1st vs. Zsep",
// 	400,-100.0,100.0,0.0,10.0); 
//   HProf(fHist.fEvntZSigma2_Zvxsepbest_b,"ZSigma2_Zvxsepbest_b","Sigma_Z2st vs. Zsep",
// 	400,-100.0,100.0,0.0,10.0);  

  HBook1F(fHist.fEvntNtrkVxbest_b,"NtrkVxbest_b","Ntrk, best vertex",1000,-0.5,999.5);
  HBook1F(fHist.fEvntPtsumVxbest_b,"PtsumVxbest_b","SumPt of tracks, best vertex",1000,-0.5,1999.5);
  HBook1F(fHist.fEvntNtrkVx2nd_b,"NtrkVx2nd_b","Ntrk, 2nd best vertex",1000,-0.5,999.5);
  HBook1F(fHist.fEvntPtsumVx2nd_b,"PtsumVx2nd_b",
	  "SumPt of tracks, 2nd best vertex",1000,-0.5,1999.5); 


                             //---- after cuts

  HBook1F(fHist.fGenpNvx_a,"GenpNvx_a","Number of interactions in MC",100,-0.5,99.5);
  HBook1F(fHist.fEvntNvx_a,"Nvx_a","Number of vertices",100,-0.5,99.5);
  HBook1F(fHist.fEvntNvx12_a,"Nvx12_a","Number of class>=12 vertices",100,-0.5,99.5);
  HBook1F(fHist.fEvntVxclassbest_a,"Vxclassbest_a","Class of best vertex",200,-0.5,1999.5);
  HBook1F(fHist.fEvntZvxbest_a,"Zvxbest_a","Zvx of best vertex",400,-200.0,200.0);  
  HBook1F(fHist.fEvntVxclassAll_a,"VxclassAll_a","Vxclass, all verteces",100,-0.5,99.5);
  HBook1F(fHist.fEvntZvxAll_a,"ZvxAll_a","zvx, all vertices",400,-200.0,200.0);
  HBook1F(fHist.fEvntVxclass2nd_a,"Vxclass2nd_a","Vxclass, 2nd best vertex",100,-0.5,99.5);
  HBook1F(fHist.fEvntZvxsep_a,"Zvxsep_a","dZ of any two vertices",800,-200.0,200.0);
  HBook1F(fHist.fEvntZvxsepbest2any_a,"Zvxsepbest2any_a","dZ of best & any vertex",800,-200.0,200.0);
  HBook1F(fHist.fEvntZvxsepbest_a,"Zvxsepbest_a","dZ of two best vertices",800,-200.0,200.0);

//   HBook1F(fHist.fEvntZvxSigma_a,"ZvxSigma_a","Sigma_zvx",50000,0.0,1.0); 
//   HProf(fHist.fEvntZSigma_Zvxsepbest_a,"ZSigma_Zvxsepbest_a","Sigma_Zsep vs. Zsep",
// 	400,-100.0,100.0,0.0,10.0); 
//   HProf(fHist.fEvntZSigma1_Zvxsepbest_a,"ZSigma1_Zvxsepbest_a","Sigma_Z1st vs. Zsep",
// 	400,-100.0,100.0,0.0,10.0); 
//   HProf(fHist.fEvntZSigma2_Zvxsepbest_a,"ZSigma2_Zvxsepbest_a","Sigma_Z2st vs. Zsep",
// 	400,-100.0,100.0,0.0,10.0);  

  HBook1F(fHist.fEvntNtrkVxbest_a,"NtrkVxbest_a","Ntrk, best vertex",1000,-0.5,999.5);
  HBook1F(fHist.fEvntPtsumVxbest_a,"PtsumVxbest_a","SumPt of tracks, best vertex",1000,-0.5,1999.5);
  HBook1F(fHist.fEvntNtrkVx2nd_a,"NtrkVx2nd_a","Ntrk, 2nd best vertex",1000,-0.5,999.5);
  HBook1F(fHist.fEvntPtsumVx2nd_a,"PtsumVx2nd_a",
	  "SumPt of tracks, 2nd best vertex",1000,-0.5,1999.5); 
}


//_____________________________________________________________________________
int TMyVertexFilterModule::BeginJob() {

				// register the data block
  RegisterDataBlock("ZVertexBlock" ,"TStnVertexBlock"  ,&fZVertexBlock); // ZVertex Collection 
//   bool MC_code =GetHeaderBlock()->McFlag();
//   if(MC_code) RegisterDataBlock("GenpBlock","TGenpBlock",&fGenpBlock); // GENP block
				// book histograms
  BookHistograms();

  return 0;
}


//_____________________________________________________________________________
int TMyVertexFilterModule::BeginRun() {
  return 0;
}

//_____________________________________________________________________________
int TMyVertexFilterModule::Event(int ientry) {

  ClearModuleOutput();    
  bool pass   = true;

  //--------------------------------------------------------------------------------
  // accessing ZVertex Block

  fZVertexBlock->GetEntry(ientry);
//   bool MC_code =GetHeaderBlock()->McFlag();
//   if(MC_code) 
//     {
//       fGenpBlock->GetEntry(ientry);
//       fGenpNvx=fGenpBlock->NInteractions()-1; // read line 40 in  Stntuple/obj/TGenpBlock.hh  
//   }

  TMyUtil* myutil= new TMyUtil();
  int vx_num=fZVertexBlock->NVertices();
  fHist.fEvntNvx_b->Fill(vx_num);   
  double zvx[myNvxArray];
  //  double zvxSigma[myNvxArray];
  double PtSum_vx[myNvxArray];
  int   Ntrk_vx[myNvxArray];
  int   vx_class[myNvxArray];
  int   ind_best=myutil->GetBestVtxInd(fZVertexBlock);  
  int   ind_2nd=myutil->Get2ndVtxInd(fZVertexBlock);  
  double zvx_best=0.0;
  double SumPt_best=0.0;
  int Ntrk_best=0;
  int class_best=0;
  double zvx_2nd=0.0;
  double SumPt_2nd=0.0;
  int Ntrk_2nd=0;
  int class_2nd=0;
  double dz_best=9999.0;
  double dz_best2any[myNvxArray];
  double dz_best2any_min=9999.0;
  double dz_best2any_max=0.0;
  double zall_min=9999.0;
  double zall_max=0.0;
  double zsep_min=9999.0;
  double zsep_max=0.0;
//   double zSigma_1st=0.0;
//   double zSigma_2nd=0.0;
//   double zsepSigma=0.0;

  fmyNvx12=0;
  for (int j=0; j<vx_num; j++) 
    {
      TStnVertex *vertex= fZVertexBlock->Vertex(j);
      zvx[j]= vertex->Z();
      //      zvxSigma[j]= vertex->SigmaZ();
      if(fabs(zvx[j])>=zall_max) zall_max=fabs(zvx[j]);
      if(fabs(zvx[j])<=zall_min) zall_min=fabs(zvx[j]);
      PtSum_vx[j]= vertex->SumPt();
      vx_class[j]= vertex->VClass();
      if(vx_class[j]>=12) fmyNvx12++;
      Ntrk_vx[j]= vertex->NTracks();
      fHist.fEvntVxclassAll_b->Fill(vx_class[j]);
      fHist.fEvntZvxAll_b->Fill(zvx[j]);
      //      fHist.fEvntZvxSigma_b->Fill(zvxSigma[j]);
    }
  fHist.fEvntNvx12_b->Fill(fmyNvx12);   
  fHist.fGenpNvx_b->Fill(fGenpNvx);
  if (vx_num>0 && ind_best>-1)
    {
      zvx_best=zvx[ind_best];
      //      zSigma_1st=zvxSigma[ind_best];
      SumPt_best=PtSum_vx[ind_best];
      Ntrk_best=Ntrk_vx[ind_best];
      class_best=vx_class[ind_best];
      fHist.fEvntVxclassbest_b->Fill(class_best);        
      fHist.fEvntZvxbest_b->Fill(zvx_best);              
      fHist.fEvntNtrkVxbest_b->Fill(Ntrk_best);     
      fHist.fEvntPtsumVxbest_b->Fill(SumPt_best);    
    }
  if (vx_num>1 && ind_2nd>-1)
    {
      zvx_2nd=zvx[ind_2nd];
      //      zSigma_2nd=zvxSigma[ind_2nd];
      //      zsepSigma=sqrt(zSigma_1st*zSigma_1st+zSigma_2nd*zSigma_2nd);
      SumPt_2nd=PtSum_vx[ind_2nd];
      Ntrk_2nd=Ntrk_vx[ind_2nd];
      class_2nd=vx_class[ind_2nd];
      dz_best=zvx_best-zvx_2nd;
      fHist.fEvntVxclass2nd_b->Fill(class_2nd);     
      fHist.fEvntNtrkVx2nd_b->Fill(Ntrk_2nd);   
      fHist.fEvntPtsumVx2nd_b->Fill(SumPt_2nd);
      fHist.fEvntZvxsepbest_b->Fill(dz_best);
//       fHist.fEvntZSigma_Zvxsepbest_b->Fill(dz_best,zsepSigma);
//       fHist.fEvntZSigma1_Zvxsepbest_b->Fill(dz_best,zSigma_1st);
//       fHist.fEvntZSigma2_Zvxsepbest_b->Fill(dz_best,zSigma_2nd);
    }

  double zvx_sep[myNvxArray][myNvxArray];
  for(int i=0; i<vx_num; i++)
    {
      zvx_sep[i][i]=9999.0;
      dz_best2any[i]=9999.0;
      if(i!=ind_best) 
	{
	  dz_best2any[i]=zvx_best-zvx[i];
	  fHist.fEvntZvxsepbest2any_b->Fill(dz_best2any[i]);
	  if(fabs(dz_best2any[i])<=dz_best2any_min) dz_best2any_min=fabs(dz_best2any[i]);
	  if(fabs(dz_best2any[i])>=dz_best2any_max) dz_best2any_max=fabs(dz_best2any[i]);
	}
      for(int j=0; j<i; j++)
	{
	  zvx_sep[i][j]=zvx[i]-zvx[j];
	  zvx_sep[j][i]=-zvx_sep[i][j];
	  if(fabs(zvx_sep[i][j])>=zsep_max) zsep_max=fabs(zvx_sep[i][j]);
	  if(fabs(zvx_sep[i][j])<=zsep_min) zsep_min=fabs(zvx_sep[i][j]);
	  fHist.fEvntZvxsep_b->Fill(zvx_sep[i][j]);
	}
    }

  //-------------------------------------------------------------------------------
  // Filling the return parameters of the Module
  //_______________________________________________________________________________
  fmyZvx_best=zvx_best;     
  fmyZvx_2nd=zvx_2nd;       
  fmyZsep_best=dz_best;     
  fmyNvx=vx_num;            
  fmyVxclass_best=class_best;    
  fmyVxclass_2nd=class_2nd;
  fmyNtrkVx_best=Ntrk_vx[ind_best];      
  if(fmyNvx>1) fmyNtrkVx_2nd=Ntrk_vx[ind_2nd];       

  for (int i=0; i<vx_num; i++)
    {
      myVxclass.push_back(vx_class[i]); 
      myZvx.push_back(zvx[i]);  
    }

 
  //-------------------------------------------------------------------------------
  // Applying event Cuts

  if(vx_num<fMinNvx || vx_num>fMaxNvx) 
    {
      pass=false;
      if(fUseVerbose==1) std::cout<<"Event "<<ientry
				  <<" didn't pass Nvx cut "<<vx_num<<std::endl; 
      SetPassed(0);
      delete myutil;
      return 0;      
    }
  if(fmyNvx12<fMinNvx12 || fmyNvx12>fMaxNvx12) 
    {
      pass=false;
      if(fUseVerbose==1) std::cout<<"Event "<<ientry
				  <<" didn't pass Nvx12 cut "<<fmyNvx12<<std::endl; 
      SetPassed(0);
      delete myutil;
      return 0;      
    }
  if(fabs(zvx_best)<fMinZvx_best || fabs(zvx_best)>fMaxZvx_best) 
    {
      pass=false;
      if(fUseVerbose==1) std::cout<<"Event "<<ientry
				  <<" didn't pass Zvx_best cut "<<zvx_best<<std::endl;
      SetPassed(0);
      delete myutil;
      return 0;      
    } 
  if(class_best<fMinVxclass_best || class_best>fMaxVxclass_best) 
    {
      pass=false;
      if(fUseVerbose==1) std::cout<<"Event "<<ientry
				  <<" didn't pass Vxclass_best cut "<<class_best<<std::endl;
      SetPassed(0);
      delete myutil;
      return 0;      
    } 
  if(vx_num>1 && (class_2nd<fMinVxclass_2nd || class_2nd>fMaxVxclass_2nd)) 
    {
      pass=false;
      if(fUseVerbose==1) std::cout<<"Event "<<ientry
				  <<" didn't pass Vxclass_2nd cut "<<class_2nd<<std::endl;
      SetPassed(0);
      delete myutil;
      return 0;      
    } 
  if(vx_num>1 && (fabs(dz_best)<fMinZsep_best || fabs(dz_best)>fMaxZsep_best)) 
    {
      pass=false;
      if(fUseVerbose==1) std::cout<<"Event "<<ientry
				  <<" didn't pass dZ_best cut "<<fabs(dz_best)<<std::endl;
      SetPassed(0);
      delete myutil;
      return 0;      
    }
  if(fabs(zall_min)<fMinZvx || fabs(zall_max)>fMaxZvx) 
    {
      pass=false;
      if(fUseVerbose==1) 
	{
	  std::cout<<"Event "<<ientry
		   <<" didn't pass Zvx_All cut: z_min= "<<zall_min<<std::endl;
	  std::cout<<"Event "<<ientry
		   <<" ------------------------ z_max= "<<zall_max<<std::endl;
	}
      SetPassed(0);
      delete myutil;
      return 0;      
    }
  if(fabs(dz_best2any_min)<fMinZsep_best2any || fabs(dz_best2any_max)>fMaxZsep_best2any)
    {
      pass=false;
      if(fUseVerbose==1) 
	{
	  std::cout<<"Event "<<ientry
		   <<" didn't pass dZ_best2any cut: dZb2a_min= "<<dz_best2any_min<<std::endl;
	  std::cout<<"Event "<<ientry
		   <<" ------------------------     dZb2a_max= "<<dz_best2any_max<<std::endl;
	}
      SetPassed(0);
      delete myutil;
      return 0;      
    }
  if(fabs(zsep_min)<fMinZsep || fabs(zsep_max)>fMaxZsep) 
    {
      pass=false;
      if(fUseVerbose==1) 
	{
	  std::cout<<"Event "<<ientry
		   <<" didn't pass Zsep_All cut: zsep_min= "<<zsep_min<<std::endl;
	  std::cout<<"Event "<<ientry
		   <<" ------------------------- zsep_max= "<<zsep_max<<std::endl;
	}
      SetPassed(0);
      delete myutil;
      return 0;      
    }
  if(fUseVxWeight==1 && VxWeight(fmyNvx12)==0)
    {
       pass=false;
       if(fUseVerbose==1) std::cout<<"Event "<<ientry<<" is dropped because of Vertex re-weighting"<<std::endl;
       SetPassed(0);
       delete myutil;
       return 0;         
    }

  //-------------------------------------------------------------------------------
  // Filling histos for events which pass the cuts

  if ( pass )
    {
      SetPassed(1);
      fHist.fGenpNvx_a->Fill(fGenpNvx);
      fHist.fEvntNvx_a->Fill(vx_num);   
      fHist.fEvntNvx12_a->Fill(fmyNvx12);   
      if (vx_num>0)
	{
	  fHist.fEvntVxclassbest_a->Fill(class_best);        
	  fHist.fEvntZvxbest_a->Fill(zvx_best);              
	  fHist.fEvntNtrkVxbest_a->Fill(Ntrk_best);     
	  fHist.fEvntPtsumVxbest_a->Fill(SumPt_best);    
	}
      if (vx_num>1)
	{
	  fHist.fEvntVxclass2nd_a->Fill(class_2nd);     
	  fHist.fEvntNtrkVx2nd_a->Fill(Ntrk_2nd);   
	  fHist.fEvntPtsumVx2nd_a->Fill(SumPt_2nd);
	  fHist.fEvntZvxsepbest_a->Fill(dz_best);
// 	  fHist.fEvntZSigma_Zvxsepbest_a->Fill(dz_best,zsepSigma);
// 	  fHist.fEvntZSigma1_Zvxsepbest_a->Fill(dz_best,zSigma_1st);
// 	  fHist.fEvntZSigma2_Zvxsepbest_a->Fill(dz_best,zSigma_2nd);
	}
      for(int i=0; i<vx_num; i++)
	{
	  fHist.fEvntVxclassAll_a->Fill(vx_class[i]);
	  fHist.fEvntZvxAll_a->Fill(zvx[i]);
	  //	  fHist.fEvntZvxSigma_a->Fill(zvxSigma[i]);
	  if(i!=ind_best) fHist.fEvntZvxsepbest2any_a->Fill(dz_best2any[i]);

	  for(int j=0; j<i; j++)
	    {
	      fHist.fEvntZvxsep_a->Fill(zvx_sep[i][j]);
	    }
	}      
    }   
  else SetPassed(0);

  delete myutil;
  return 0;
}

int TMyVertexFilterModule::VxWeight(int _Nvx) {
  int pass=1;
  if(_Nvx<0) return 0;
  if(_Nvx<10)
    {
//       double vx_weight[10]={1.0,1.0,0.574078,0.381316,0.289324,0.286959,0.375765,0.818747,1.0,1.0}; // used in 2 fb-1 analysis
      double vx_weight[10]={1.0,1.0,0.799466,0.634121,0.509235,0.494169,0.588,1.0,1.0,1.0}; // used in 2.6 fb-1 GMSB analysis
      double rnd=gRandom->Rndm();
      if(rnd>vx_weight[_Nvx]) return 0;
    }
  return pass;
}


//--------------------------------------------------------------------------
//------------ STOPPED HERE ------------------------------------------------
//--------------------------------------------------------------------------

//_____________________________________________________________________________
void TMyVertexFilterModule::Display() {

  TCanvas* MyVertex = new TCanvas("MyVertexFilt","MyVertexFilter Printout",100,100,700,900);
  MyVertex->Divide(2,3);
  MyVertex->cd(1); fHist.fEvntNvx_a->Draw();
  MyVertex->cd(2); fHist.fEvntVxclassAll_a->Draw();
  MyVertex->cd(3); fHist.fEvntVxclassbest_a->Draw();
  MyVertex->cd(4); fHist.fEvntZvxbest_a->Draw();
  MyVertex->cd(5); fHist.fEvntVxclass2nd_a->Draw();
  MyVertex->cd(6); fHist.fEvntZvxsepbest_a->Draw();

  return;
}

int TMyVertexFilterModule::EndJob() {

  ofstream outfile(fDatFileName, std::ios::out);
  if (! outfile) 
    {
      std::cerr<<"Error of openning of .DAT file\n";
    }
  if(outfile)
    {

      std::cout<<"---------- Cross Check -------------------------"<<std::endl;
      std::cout<<"..........Number of events before cuts "<<fHist.fEvntNvx_b->GetEntries()<<std::endl;
      std::cout<<"..........Number of events after cuts  "<<fHist.fEvntNvx_a->GetEntries()<<std::endl;

      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"------  TMyVertexFilterModule Summary  -------------"<<"\n";
      outfile<<"___________________________________________________"<<"\n";
      char outputstring[200];
      sprintf(outputstring,"..........Number of events before cuts = %f",fHist.fEvntNvx_b->GetEntries());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,"..........Number of events after cuts = %f",fHist.fEvntNvx_a->GetEntries());
      outfile<<outputstring<<"\n";
      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"-------- BEFORE CUTS ------------------------------"<<"\n";
      outfile<<"Format of output: ___Histo name___mean___rms___"<<"\n";
      outfile<<"..................................................."<<"\n";

      outfile<<HistoSummary(fHist.fEvntNvx_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntNvx12_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntVxclassbest_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxbest_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntVxclassAll_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxAll_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntVxclass2nd_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxsep_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxsepbest_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxsepbest2any_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntNtrkVxbest_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntPtsumVxbest_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntNtrkVx2nd_b)<<"\n";
      outfile<<HistoSummary(fHist.fEvntPtsumVx2nd_b)<<"\n";

      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"-------- AFTER CUTS ------------------------------"<<"\n";
      outfile<<"Format of output: ___Histo name___mean___rms___"<<"\n";
      outfile<<"..................................................."<<"\n";

      outfile<<HistoSummary(fHist.fEvntNvx_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntNvx12_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntVxclassbest_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxbest_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntVxclassAll_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxAll_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntVxclass2nd_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxsep_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxsepbest_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntZvxsepbest2any_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntNtrkVxbest_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntPtsumVxbest_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntNtrkVx2nd_a)<<"\n";
      outfile<<HistoSummary(fHist.fEvntPtsumVx2nd_a)<<"\n";

    }

  outfile<<"---- The End!------"<<std::endl;

  return 0;
}


