#ifndef TMyUtil_hh
#define TMyUtil_hh

#include "TObject.h"
#include <Stntuple/obj/TStnVertexBlock.hh>

// Declare the class
class TMyUtil: public TObject {
public:
//---example
//   enum { _maxvtx  = 3,                  // Maximum number of vertices
//          _maxmcn  = 4,                  // Maximum number of mass constraints
//          _maxtrk  = 10,                 // Maximum number of tracks
//          _maxitr  = 10,                 // Maximum number of iteration steps
//          _maxdim  = 5*(_maxvtx+1)+3*_maxtrk+_maxmcn
//   };
  
protected:

//   int stat;        //---example

//-----------------------------------------------------------------------------
// function members
//-----------------------------------------------------------------------------
public:
                                        // ****** constructors and destructor
  TMyUtil();
  ~TMyUtil();
                                        // ****** initialization methods
  void Init();
                                        // ****** accessors

  int GetBestVtxInd(TStnVertexBlock* MyVertexBlock);     // Accessing best vertex  
  int GetBestVtxClass(TStnVertexBlock* MyVertexBlock);   // which is highest Pt vertex
  float GetBestVtxZ(TStnVertexBlock* MyVertexBlock);

  int Get2ndVtxInd(TStnVertexBlock* MyVertexBlock);      // Accessing 2nd best vertex 
  int Get2ndVtxClass(TStnVertexBlock* MyVertexBlock);    // which is 2nd highest Pt vertex
  float Get2ndVtxZ(TStnVertexBlock* MyVertexBlock);

  int GetMyBestVtxInd(TStnVertexBlock* MyVertexBlock);   // Accessing My best vertex
  int GetMyBestVtxClass(TStnVertexBlock* MyVertexBlock); // which is the vertex with highest
  float GetMyBestVtxZ(TStnVertexBlock* MyVertexBlock);   // number of tracks, Ntrk_vx

  ClassDef(TMyUtil,0)
};

#endif   /* TMyUtil_hh */
 
 
 
 
 
 
 
 
 
 
 
 
 
