/*_______________________________________________________________

  Class contains general methods which are supposed to be used in
  various analysis modules.
  _______________________________________________________________
*/
//_____________________________________________________________________________
// Em filter module
//_____________________________________________________________________________

#include "TMath.h"

#include "TMyUtil.hh"

ClassImp(TMyUtil)
//_____________________________________________________________________________
TMyUtil::TMyUtil() {
  // Initialization
  Init();
}

//_____________________________________________________________________________
void TMyUtil::Init() {
  // move initializations which can be done multiple times
  // into Init() function
}

//_____________________________________________________________________________
TMyUtil::~TMyUtil(){ 
}

//_____________________________________________________________________________
//
//    !!!  Best Vertex is defined here !!!
//
//------ Returns the index of the best vertex ----------
//------ Jet reconstruction requires class_best=>12 (03/09/04)
//------ This version returns highest Pt vertex of any class>0
//------ class cut to be applied later 
//_____________________________________________________________________________
int TMyUtil::GetBestVtxInd(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return -1;
  int vx_num=MyVertexBlock->NVertices();
  const int vxclass=0;
  float sumpt=0.0;
  int best_vx_ind=-1;
  for (int j=0; j<vx_num; j++)
    {
      TStnVertex *vertex= MyVertexBlock->Vertex(j);
      //      if((vertex->SumPt())>=sumpt && (vertex->VClass())>vxclass) // commented out on 08/03/05 to avoid throwing away
                                                                         // events where we have class=0 vertex. If necessary,
                                                                         // these events can be removed by other cuts. 
      if((vertex->SumPt())>=sumpt)
	{
	  sumpt=vertex->SumPt();
	  best_vx_ind=j;
	}
    }
  return best_vx_ind; 
}
//_____________________________________________________________________________
int TMyUtil::GetBestVtxClass(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return -1;
  int ind=GetBestVtxInd(MyVertexBlock);
  int vxclass_best=-1;
  if(ind<0) 
    {return -1;}
  else
    {
     TStnVertex *vertex= MyVertexBlock->Vertex(ind);
     vxclass_best=vertex->VClass();
    }    
  return vxclass_best;
}
//_____________________________________________________________________________
//---
//--- if no vertex found, it returns z=0.0 (to be consistent with JetVertex strategy=1)
float TMyUtil::GetBestVtxZ(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return 0.0;
  int ind=GetBestVtxInd(MyVertexBlock);
  float zvx=0.0;
  if(ind<0) 
    {return 0.0;}
  else
    {
     TStnVertex *vertex= MyVertexBlock->Vertex(ind);
     zvx=vertex->Z();
    }    
  return zvx;
}


//_____________________________________________________________________________
//
//    !!!  Second best Vertex is defined here !!!
//
//------ Returns the index of the second best vertex ----------
//------ Jet reconstruction requires class_best=>12 (03/09/04)
//------ This version returns highest Pt vertex of any class>0
//------ class cut to be applied later 
//_____________________________________________________________________________
int TMyUtil::Get2ndVtxInd(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return -1;
  int ind_best=GetBestVtxInd(MyVertexBlock);
  float sumpt=0.0;
  int vx_num=MyVertexBlock->NVertices();
  const int vxclass=0;
  int best2nd_vx_ind=-1;
  for (int j=0; j<vx_num && vx_num>1; j++)
    {
      TStnVertex *vertex= MyVertexBlock->Vertex(j);
      if((vertex->SumPt())>=sumpt && (vertex->VClass())>vxclass && j!=ind_best)
	{
	  sumpt=vertex->SumPt();
	  best2nd_vx_ind=j;
	}
    }
  return best2nd_vx_ind; 
}
//_____________________________________________________________________________
int TMyUtil::Get2ndVtxClass(TStnVertexBlock* MyVertexBlock) {
  int ind=Get2ndVtxInd(MyVertexBlock);
  int vxclass_2nd=-1;
  if(ind<0) 
    {return -1;}
  else
    {
     TStnVertex *vertex= MyVertexBlock->Vertex(ind);
     vxclass_2nd=vertex->VClass();
    }    
  return vxclass_2nd;
}
//_____________________________________________________________________________
//---
//--- if no vertex found, it returns z=0.0 (to be consistent with JetVertex strategy=1)
float TMyUtil::Get2ndVtxZ(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return 0.0;
  int ind=Get2ndVtxInd(MyVertexBlock);
  float zvx=0.0;
  if(ind<0) 
    {return 0.0;}
  else
    {
     TStnVertex *vertex= MyVertexBlock->Vertex(ind);
     zvx=vertex->Z();
    }    
  return zvx;
}

//_____________________________________________________________________________
//
//    !!!  My best (alternative) Vertex is defined here !!!
//
//------ Returns the index of My best vertex ----------
//------ 
//------ This version returns the vertex with highest number of tracks (class>0)
//------ class cut to be applied later 
//_____________________________________________________________________________
int TMyUtil::GetMyBestVtxInd(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return -1;
  int vx_num=MyVertexBlock->NVertices();
  const int vxclass=0;
  int ntrk_vx=0;
  int mybest_vx_ind=-1;
  for (int j=0; j<vx_num; j++)
    {
      TStnVertex *vertex= MyVertexBlock->Vertex(j);
      if((vertex->NTracks())>=ntrk_vx && (vertex->VClass())>vxclass)
	{
	  ntrk_vx=vertex->NTracks();
	  mybest_vx_ind=j;
	}
    }
  return mybest_vx_ind; 
}
//_____________________________________________________________________________
int TMyUtil::GetMyBestVtxClass(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return -1;
  int ind=GetMyBestVtxInd(MyVertexBlock);
  int vxclass_mybest=-1;
  if(ind<0) 
    {return -1;}
  else
    {
     TStnVertex *vertex= MyVertexBlock->Vertex(ind);
     vxclass_mybest=vertex->VClass();
    }    
  return vxclass_mybest;
}
//_____________________________________________________________________________
//--- if no vertex found, it returns z=0.0 (to be consistent with JetVertex strategy=1)
float TMyUtil::GetMyBestVtxZ(TStnVertexBlock* MyVertexBlock) {
  if (!MyVertexBlock) return 0.0;
  int ind=GetMyBestVtxInd(MyVertexBlock);
  float zvx=0.0;
  if(ind<0) 
    {return 0.0;}
  else
    {
     TStnVertex *vertex= MyVertexBlock->Vertex(ind);
     zvx=vertex->Z();
    }    
  return zvx;
}

