#ifndef TMYEM_HH
#define TMYEM_HH

#if !defined (__CINT__) || defined (__MAKECINT__)

#include "TH1.h"
#include "TH2.h"
#include "TProfile.h"
#include <vector>
#include "TLorentzVector.h"

#include <Stntuple/loop/TStnModule.hh>
#include <Stntuple/obj/TStnHeaderBlock.hh>
#include <Stntuple/obj/TCalDataBlock.hh>
#include <Stntuple/obj/TStnPhotonBlock.hh>
#include <Stntuple/obj/TStnTrackBlock.hh>
#include <Stntuple/obj/TStnElectronBlock.hh> // need for phoenix electrons
#include <Stntuple/obj/TPhoenixElectronBlock.hh> // need for phoenix electrons
#include <Stntuple/obj/TStnJetBlock.hh>
#include <Stntuple/obj/TStnMetBlock.hh>
#include <Stntuple/photon/TPhotonUtil.hh>
#include <Stntuple/alg/TStntuple.hh>
#include <CalorGeometry/CalConstants.hh>
#include <Stntuple/obj/TStnTriggerBlock.hh>
#include <Stntuple/obj/TStnDBManager.hh>
#include <Stntuple/photon/TPhoTrigBits.hh>
#include <Stntuple/obj/TStnEmTimingBlock.hh>

#endif

class TMyEventFilterModule;
class TMyVertexFilterModule;
class TWireChecker;
// class PhotonBackgroundComputer;

//_____________________ timing stuff
class TEmTimingModule; 
class EmTimingTower;
 
class TMyPhotonFilterModule: public TStnModule {
public:

  //-------------------------- parameters for CprWeight
  struct CprStuff {
    double servInd; // service index corresponding to nPhoBac of getCprWeight routine
    int nvx12;   // number of class=>12 vertices
    double SumEtoutJet; // raw SumEt-SumEt(Clu R=0.4 jets, raw Et>10 GeV)
  };

  //-------------------------- parameters for Beam Halo
  struct HaloStuff {
    int seedwedge;
    int sidewedge;
    int seedwedgeH;
    int sidewedgeH;
    int eastNhad;
    int westNhad;
    double emseedE;
    double emsideE;
    double hadseedE;
    double seedwedgeHadE;
  };

  
  struct PhotonGeneral_t {  //------------ General histograms for Photons

    //_______________________before cuts
    
    TH1F* fPhtnNcand_b;                  // number of Photon candidates
    TH1F* fPhtnNtower_b;                 // number of towers in the cluster
    TH1F* fPhtnDetector_b;               // 0: CEM, 1: PEM
    TH1F* fPhtnDelZvx_b;                 // dZvx=Z_pho-Z_bestVx
    TH1F* fPhtnZvx_b;                    // Zvx of photon
    TH1F* fPhtnLike_b;                   // Photon ID likelihood
    TH1F* fPhtnEt_raw_b;                  // raw Et with respect to vertex and CES
    TH1F* fPhtnEt_twr_b;                  // Et corrected for tower response
    TH1F* fPhtnE_total_b;                 // total corrected Energy
    TH1F* fPhtnEta_det_b;                 // detector Eta
    TH1F* fPhtnEta_b;                     // event Eta (respect to vertex and CES)
    TH1F* fPhtnPhi_b;                     // Phi with respect to vertex and CES
    TH1F* fPhtnTheta_b;                   // Theta with respect to vertex and CES
    TH1F* fPhtnHadEm3_b;                  // Had/Em (3 towers)
    TH1F* fPhtnHadEm2_b;                  // Had/Em (2 towers)
    TH1F* fPhtnLshr_b;                    // Lshare (3 towers)
    TH1F* fPhtnCalIso4_raw_b;             // raw cal Iso in cone R=0.4 (sum Et in R=0.4)
    TH1F* fPhtnCalIso4_leak_b;            // cal Iso in cone R=0.4 corrected for phi leakage
    TH1F* fPhtnCalIso4_corr_b;            // cal Iso in cone R=0.4 corrected for leakage & multiple vert.
                                          // it can be negative in histo, however it's >=0.0 for cuts

    TH1F* fPhtnCalIso7_b;                 // ?raw? cal Iso in cone R=0.7
    TH1F* fPhtnCalIso74_b;                // ?raw? CalIso(0.7)-CalIso(0.4)  
    TH1F* fPhtnCalIso74over4_b;           // ?raw? ratio (CalIso(0.7)/CalIso(0.4)-1.0) 
    TH1F* fPhtnTrkIso4_b;                 // sumPt of tracks in cone R=0.4
    TH1F* fPhtnCalTrkIso4_b;              // ?raw? CalIso(0.4)-TrkIso(0.4)
    TH1F* fPhtnN3D_b;                     // number of 3D tracks in the cluster
    TH1F* fPhtnPt1st_b;                   // max Pt trk in cluster
    TH1F* fPhtnPt2nd_b;                   // 2nd highest Pt trk 
    TH1F* fPhtnNTrk4_b;                   // Ntrk in iso cone R=0.4
    TH1F* fPhtnPtmax4_b;                  // max Pt trk iso cone R=0.4
    TH1F* fPhtnCesX_b;                    // CES local X
    TH1F* fPhtnCesZ_b;                    // CES local Z
    TH1F* fPhtnChi2_b;                    // CES(strip+wire) Chi^2
    TH1F* fPhtnCesX2_b;                   // 2nd CES cluster local X
    TH1F* fPhtnCesZ2_b;                   // 2nd CES cluster local Z
    TH1F* fPhtnCesStripE2_b;              // 2nd CES cluster strip E
    TH1F* fPhtnCesWireE2_b;               // 2nd CES cluster wire E
    TH1F* fPhtnCesWght_b;                 // CES background weight
    //-------------------------- ATTN!!! systematics for CES method still to be found
    TH1F* fPhtnCprWght_b;                 // CPR background weight
    TH1F* fPhtnCprWghtB35_b;              // CPR background weight for photons with Et<35 GeV
    TH1F* fPhtnCprWghtA35_b;              // CPR background weight for photons with Et>=35 GeV
 
    TProfile* fPhtnCprWght_Et_b;          // CPR background weight vs. Et_corr of photon
    TProfile* fPhtnCprWghtB35_Et_b;       // CPR background weight vs. Et_corr of photon, if Et<35
    TProfile* fPhtnCesWght_Et_b;          // CES background weight vs. Et_corr of photon

    TH1F* fPhtnCprWghtM1_b[5];            // cross-check: CPR weight & its systematics using Nvx12 
    TH1F* fPhtnCprWghtM2_b[5];            // cross-check: CPR weight & its systematics using SumEt 

    TH1F* fPhtnCprX_b;                    // unbiased CPR local X
    TH1F* fPhtnCprQ_b;                    // unbiased CPR charge
    TH1F* fPhtnCesCprX_b;                 // CES seeded CPR local X
    TH1F* fPhtnCesCprQ_b;                 // CES seeded CPR charge
    TH1F* fPhtnCesCpr_dX_b;               // dX=X_ces-X_cpr (unbiased) 
    TH1F* fPhtn2ndCesCpr_dX_b;            // dX=X_ces(2nd cluster)-X_cpr (unbiased) 

    TH1F* fPhtnHadTDC_b;                  // HadTDC for photon
    TH1F* fPhtnNStub_b;                   // number of muon stabs
    TH1F* fPhtnNStubNoTrk_b;              // number of muon stabs without matched tracks
    TH1F* fPhtnNStub30cone_b;             // number of muon stabs without matched tracks within 30 deg. of photon

    TH1F* fPhtnNphoenix_b;                // number of Phoenix tracks associated with EM cluster
    TH1F* fPhtnNSiHitsTrk_b;              // number of Silicon hits in associated with EM cluster Phoenix track (only r-phi hits)
    TH1F* fPhtnPhnxChi2_b;                // chi^2 of associated with EM cluster Phoenix track   
 
    TH1F* fPhtnEmTime_b;                  // EM timing of photon
    TH1F* fPhtnEmTimeHADTdc_b;            // (EM timing - HadTdc time) of photon
    
    //------ Note! No histo for Plug photons at this moment
        
    //_______________________after cuts
    
    TH1F* fPhtnNcand_a;                  
    TH1F* fPhtnNtower_a;                 
    TH1F* fPhtnDetector_a;               
    TH1F* fPhtnDelZvx_a;                 
    TH1F* fPhtnZvx_a;                    
    TH1F* fPhtnLike_a;                   
    TH1F* fPhtnEt_raw_a;                 
    TH1F* fPhtnEt_twr_a;                 
    TH1F* fPhtnE_total_a;                
    TH1F* fPhtnEta_det_a;                
    TH1F* fPhtnEta_a;                    
    TH1F* fPhtnPhi_a;                    
    TH1F* fPhtnTheta_a;                  
    TH1F* fPhtnHadEm3_a;                 
    TH1F* fPhtnHadEm2_a;                 
    TH1F* fPhtnLshr_a;                   
    TH1F* fPhtnCalIso4_raw_a;            
    TH1F* fPhtnCalIso4_leak_a;           
    TH1F* fPhtnCalIso4_corr_a;           
    TH1F* fPhtnCalIso7_a;                
    TH1F* fPhtnCalIso74_a;               
    TH1F* fPhtnCalIso74over4_a;
    TH1F* fPhtnTrkIso4_a;                
    TH1F* fPhtnCalTrkIso4_a;             
    TH1F* fPhtnN3D_a;                    
    TH1F* fPhtnPt1st_a;                  
    TH1F* fPhtnPt2nd_a;                  
    TH1F* fPhtnNTrk4_a;                  
    TH1F* fPhtnPtmax4_a;                 
    TH1F* fPhtnCesX_a;                   
    TH1F* fPhtnCesZ_a;                   
    TH1F* fPhtnChi2_a;                   
    TH1F* fPhtnCesX2_a;                  
    TH1F* fPhtnCesZ2_a;                  
    TH1F* fPhtnCesStripE2_a;             
    TH1F* fPhtnCesWireE2_a;              
    TH1F* fPhtnCesWght_a;                
    //-------------------------- ATTN!!! systematics for CES method still to be found
    TH1F* fPhtnCprWght_a;         
    TH1F* fPhtnCprWghtB35_a;              
    TH1F* fPhtnCprWghtA35_a;              
 
    TProfile* fPhtnCprWght_Et_a;          
    TProfile* fPhtnCprWghtB35_Et_a;          
    TProfile* fPhtnCesWght_Et_a;          

    TH1F* fPhtnCprWghtM1_a[5];            // cross-check: CPR weight & its systematics using Nvx12 
    TH1F* fPhtnCprWghtM2_a[5];            // cross-check: CPR weight & its systematics using SumEt 

    TH1F* fPhtnCprX_a;                    
    TH1F* fPhtnCprQ_a;                    
    TH1F* fPhtnCesCprX_a;                 
    TH1F* fPhtnCesCprQ_a;                 
    TH1F* fPhtnCesCpr_dX_a;               
    TH1F* fPhtn2ndCesCpr_dX_a;               

    TH1F* fPhtnHadTDC_a;                  
    TH1F* fPhtnNStub_a;                   
    TH1F* fPhtnNStubNoTrk_a;              
    TH1F* fPhtnNStub30cone_a;             

    TH1F* fPhtnNphoenix_a;              
    TH1F* fPhtnNSiHitsTrk_a;            
    TH1F* fPhtnPhnxChi2_a;              

    TH1F* fPhtnEmTime_a;      
    TH1F* fPhtnEmTimeHADTdc_a; 
 
    //------ Note! No histo for Plug photons at this moment    
  };

  
  struct AnalysisHisto_t {  //------------ ggX analysis histograms 

    TH1F* fAnaMgg; // di-photon mass (two leading photons)
    TH1F* fAnaDeltaPhi; // di-photon delta phi
    TH1F* fAnaDeltaEta; // di-photon delta eta
    TH1F* fAnaDeltaR;   // di-photon delta R
    TH1F* fAnaQt;       // di-photon momentum
    TH1F* fAnaThetaS;   // di-photon theta star
    TH1F* fAnaEta;      // di-photon eta
    TH1F* fAnaEt1;      // Et of 1st photon 
    TH1F* fAnaEt2;      // Et of 2nd photon 
    TH1F* fAnaEtE;      // Et of extra photon 
    TH1F* fAnaNpho;     // number of photons after cuts 
    TH1F* fAnaMet4;     // Met4 
    TH1F* fAnaMetPhi4;  // MetPhi4 
    TH1F* fAnaMetX4;  // MetX4 
    TH1F* fAnaMetY4;  // MetY4 
    TH1F* fAnaCorrSumEt;  // CorrSumEt=SumEt2-Et1-Et2-Et_extra 
    TH1F* fAnaSqrtCorrSumEt;  // Sqrt(CorrSumEt=SumEt2-Et1-Et2-Et_extra) 
    TH1F* fAnaHt;  // Ht=Et1+Et2+Et_extra+Met4     
    TH1F* fAnaDelPhiM1; // MetPhi4-phi(pho1)
    TH1F* fAnaDelPhiM2; // MetPhi4-phi(pho2)
    TH1F* fAnaDelPhiMDi; // MetPhi4-phi(di-pho)

    TProfile* fAnaMet4vsZvx; // Met4 vs. Zvx
    TProfile* fAnaMet4vsNvx12; // Met4 vs. Nvx12
    TProfile* fAnaMet4vsLum; // Met4 vs. Lum
    TProfile* fAnaMet4vsMetPhi4; // Met4 vs. MetPhi4
    TProfile* fAnaMet4vsMgg; // Met4 vs. di-pho mass
    TProfile* fAnaDelPhivsMgg; // DelPhi vs. di-pho mass
    TProfile* fAnaMet4vsQt; // Met4 vs. di-pho momentum
    TProfile* fAnaMet4vsDPhi; // Met4 vs. di-pho delta phi
    TProfile* fAnaHtvsDPhi; // Ht vs. di-pho delta phi
    TProfile* fAnaMggvsDPhi; // di-pho mass vs. di-pho delta phi
    TProfile* fAnaMggVsMet4; // di-pho mass vs. Met4 
    TProfile* fAnaQtVsMet4; // di-pho momentum vs. Met4 
    
    TProfile* fAnaMet4vsDPhi1; // Met4 vs. dPhi=Phi(Met)-Phi(pho1)
    TProfile* fAnaMet4vsDPhi2; // Met4 vs. dPhi=Phi(Met)-Phi(pho2)
    TProfile* fAnaMggVsDelR; // di-pho mass Mgg vs. dR(pho1,pho2) 
    TProfile* fAnaMet4VsDelR; // Met4 vs. dR(pho1,pho2) 
    TProfile* fAnaHtVsDelR; // Ht vs. dR(pho1,pho2) 
    TProfile* fAnaQtVsDelR; // Qt vs. dR(pho1,pho2) 

    TProfile* fAnaMet4VsCorrSumEt; // Met4 vs. corrected SumEt  
    TProfile* fAnaMet4VsSqrtCorrSumEt; // Met4 vs. Sqrt(corr SumEt)  
    TH2F* fAnaMet4CorrSumEt; // scatter plot (Met4,corrected SumEt)  
    TH2F* fAnaMet4SqrtCorrSumEt; // scatter plot (Met4,Sqrt(corr SumEt))  

  };

  struct MetStudyHisto_t {  //------------ Met study histograms 

    TProfile* fMet4VsSqrtCorrSumEt_nvx1; // Met4 vs. Sqrt(corr SumEt) for Nvx12=1  
    TProfile* fMet4VsSqrtCorrSumEt_nvx2; // Met4 vs. Sqrt(corr SumEt) for Nvx12=2  
    TProfile* fMet4VsSqrtCorrSumEt_nvx3; // Met4 vs. Sqrt(corr SumEt) for Nvx12=3  
    TProfile* fMet4VsSqrtCorrSumEt_nvx4; // Met4 vs. Sqrt(corr SumEt) for Nvx12=4  
    TProfile* fMet4VsSqrtCorrSumEt_nvx5; // Met4 vs. Sqrt(corr SumEt) for Nvx12=5  

    TH1F* fMet4X[10]; // Met4X for events with any Nvx12 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0
    TH1F* fMet4X_nvx1[10]; // Met4X for Nvx12=1 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4X_nvx2[10]; // Met4X for Nvx12=2 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4X_nvx3[10]; // Met4X for Nvx12=3 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4X_nvx4[10]; // Met4X for Nvx12=4 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4X_nvx5[10]; // Met4X for Nvx12=5 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 

    TH1F* fMet4Y[10]; // Met4Y for events with any Nvx12 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0
    TH1F* fMet4Y_nvx1[10]; // Met4X for Nvx12=1 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4Y_nvx2[10]; // Met4X for Nvx12=2 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4Y_nvx3[10]; // Met4X for Nvx12=3 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4Y_nvx4[10]; // Met4X for Nvx12=4 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 
    TH1F* fMet4Y_nvx5[10]; // Met4X for Nvx12=5 in 10 bins of Sqrt(CorrSumEt); bins size is 2.0 

  };

  //______________________________ Beam Halo study histograms
  struct BeamHaloStudyHisto_t {
    TH1F* fHaloEventStatus; // number of beam halo candidates per event (according to Max code)

    //_____________________ My params
    TH1F* fHaloSeedWedgeH;   // number of seed wedge towers with Had>thresh 
    TH1F* fHaloSideWedgeH;   // number of side wedge towers with Em>thresh
    //______________________ Max's params
    TH1F* fHaloSeedWedge;   // number of seed wedge towers with Em>thresh 
    TH1F* fHaloSideWedge;   // number of side wedge towers with Em>thresh
    TH1F* fHaloEastNHad;    // number of had towers on East side
    TH1F* fHaloWestNHad;    // number of had towers on West side
    TH1F* fHaloEmSeedE;     // EM energy of seed wedge towers
    TH1F* fHaloEmSideE;     // EM energy of side wedge towers
    TH1F* fHaloHadSeedE;    // Plug HAD energy of seed wegde towers
    TH1F* fHaloSeedWedgeHadE; // HAD energy of seed wegde towers
    TH1F* fHaloNHad;        // number of towers on East & West: EastNHad+WestNHad

    TH2F* fHaloSeedWedgeEM_SeedWedgeHAD; // number of EM seed wedge towers vs. number of HAD towers 

    //______________________ Ray's params
    TH1F* fHaloEast;        // output of Pho->HaloEast()
    TH1F* fHaloWest;        // output of Pho->HaloWest()
    TH1F* fHaloEastWest;    // Pho->HaloEast()+Pho->HaloWest()
    TH1F* fHaloSideWedgeR;  // number of towers in side wedges according to Ray's code  
    TH1F* fHaloSeedWedgeR;  // number of towers in seed wedge according to Ray's code  
    TH1F* fHaloTwrInRawR;   // number of continues towers in seed wedge according to Ray's code  

    //______________________ my params
    TH1F* fHaloCesStripEoverE; // CesStripE/E(pho)
    TH1F* fHaloCesWireEoverE;  // CesWireE/E(pho)
    TH1F* fHaloHadTDC;         // Had TDC timing   

    TH1F* fHaloPhiWedge;  // wedge number of halo candidate
    TH1F* fHaloEta;       // eta of halo candidate
    TH1F* fHaloIso;       // iso of halo candidate
    TH1F* fHaloHadEm;     // Had/Em of halo candidate
    TH1F* fHaloCesChi2;   // CES Chi2 of halo candidate
    TH1F* fHaloEt;        // Et of halo candidate
  };

  struct EmTimingHisto_t {
    TH1F* fEmtTimePho1; // timing of highest energy tower in 1st photon
    TH1F* fEmtTimePho2; // timing of highest energy tower in 2nd photon
    TH1F* fEmtNhitsTot[2]; // total number of timing hits
    TH1F* fEmtDelTime;  // dTime=Time1-Time2
    TH2F* fEmtTime1vsTime2; // Time1 vs. Time2
    TH2F* fEmtDelTvsDelPhi; // dT vs. sin(dPhi/2)
  };

protected:

  char histo_outputstring[200];

                           // pointers to the data blocks used
  TStnPhotonBlock* fPhotonBlock;
  TStnTrackBlock*  fTrackBlock;
  TStnJetBlock*    fJetBlockClu04; // need this block to calculate CPR weight
  TStnMetBlock*    fMetBlock;      
  TCalDataBlock*   fCalDataBlock;  // need this block for beam halo ID & ISO studies. 
  TPhoenixElectronBlock* fPhxEleBlock; // phoenix stuff
  TStnTrackBlock* fPhxSiTrackBlock; // phoenix stuff
  TStnEmTimingBlock* fTimingBlock;

  TStnTriggerBlock* fTriggerBlock; // need this to get trigger info 
  TPhoTrigBits trigBits;
  bool trig;
  bool trig12;
  bool trig18;
  bool trig25;
  bool trig50;
  bool trig70;


  TWireChecker* myGoodWire;
//   PhotonBackgroundComputer* myPhoComputer;
  HaloStuff myHaloStuff; // need for beam halo 
  typedef std::vector<TCalTower*> CalDataArray; // need for beam halo
  typedef std::vector<TCalTower*>::iterator CalDataArrayI; // need for beam halo

                           // histograms 
  PhotonGeneral_t  fPhoHist[3]; // [0]--for 1st pho; [1]--for 2nd pho; [2]--for extra pho
  AnalysisHisto_t  fAnaHist; 
  MetStudyHisto_t  fMetStudyHist; 
  BeamHaloStudyHisto_t fNoBeamHaloHist;   // histograms for photons without beam halo candidate
  BeamHaloStudyHisto_t fWithBeamHaloHist; // histograms for photons with beam halo candidate
  EmTimingHisto_t fTimingHisto; // EM timing histo


  //___________________________________________ cuts & service params
  //***** cuts
  double fMinEta; // cut on photon eta
  double fMaxEta; 
  double fMinHADEM[3];        // HADEM cut using 3towers : [0]-value of fixed cut 
  double fMaxHADEM[3];        // **** [1]-const term in sliding cut
                              // **** [2]-linear term in sliding cut
  double fMinCesChi2;         // CES Chi^2 (wire+strip) 
  double fMaxCesChi2;
  int fMinN3D;                // cut on number of 3D tracks in the cluster
  int fMaxN3D;
  double fMinPtmax[2];     // cut on track Pt pointing to the cluster: [0]-const term
  double fMaxPtmax[2];     // **** [1]-linear term
  double fMinCalIso4_corr[3];   // cut on fully corr. CalIso4: [0]-fixed value
  double fMaxCalIso4_corr[3];   // **** [1]-const term in sliding cut, [2]-linear term 
  double fMinTrkIso4[2];        // cut on TrkIso4: [0]-const term, [1]-linear term
  double fMaxTrkIso4[2];
  double fMin2ndCesEt[3];        // cut on energy of 2nd CES cluster: [0]-fixed value
  double fMax2ndCesEt[3];        // **** [1]-const term, [2]-linear term
  double fMinCesX;           // cut on CES X
  double fMaxCesX; 
  double fMinCesZ;           // cut on CES Z
  double fMaxCesZ;           
  double fMinTrkCprX;        // Min distance between track and Cpr cluster

  //________________________________ these cuts applied after photon ID cuts  
  double fMinEtcor[2];       // cut on corr. Et of 1st photon (or 2nd photon if di-photon)
  double fMaxEtcor[2];       
  double fEtfnl_trh;          // Et_cor threshold for photons after ID cut 
  int fMinNpho_Lfnl;          // number of leading photons above Etfnl_trh threshold
  int fMaxNpho_Lfnl;         
  int fMinNpho_Efnl;          // number of extra photons below Etfnl_trh threshold 
  int fMaxNpho_Efnl;
  int fMinNpho_fnl;          // total number of photons NphoL_fnl+NphoE_fnl 
  int fMaxNpho_fnl;


  //***** service parameters
  int fUsePhoTrig; // parameter to involve Trigger selection		    
  int fUseWireCheck;        // parameter to involve Cpr/Ces wire check 
  int fUseCprCheck;         // parameter to involve Cpr check
  int fUseCesCheck;         // parameter to involve Ces check
  int fUseTrkCprCheck;      // parameter to involve TrkCpr check
  int fUseFixed2ndCesCut;   // parameter to involve fixed or sliding cut on 2nd CES cluster energy
  int fUseVerbose;          // parameter to invoke printout
  int fPrintMyEvent;        // parameter to print an event of interest
  int fUseEngCorr;          // parameter to invoke Ray's photon energy corrections
  int fUseBeamHaloCut;      // parameter to invoke beam halo cut
  int HaloCutScenario;      // beam halo cut scenario
  int fUseDiphoMode;        // dipho or incl. photon cuts scenario 
  int fPrintPhoList;        // to print a list of passed photons
  int fUseCosmicsCut;       // parameter to invoke cosmics cut
  int fUsePhoFakeCut;       // parameter to involve ele->fake_pho selection
  int fUseTimingCut;        // parameter to invoke EM timing cut

  double timeWindow[2];     // time window for EM timing
  double phoTimeThr;        // time threshold for photons
  double dTimeThr;          // dT=T1-T2 time threshold 
  double fMinDelRcosm;      // need this cut to separate cosmics and satelite bunch interactions
  double fMaxDelRcosm;

                    //***** global parameters
  double fCprWght_t1[5];    // CprWght & CprWght_syst using Nvx12 
  double fCprWght_t2[5];    // CprWght & CprWght_syst using raw SumEt-SumEt(Clu R=0.4 jets, raw Et>10 GeV)

  std::vector<int> outRun;   // these have to be filled for eached passed event
  std::vector<int> outEvent; // they have to be handled together
  std::vector<int> outNpho;  // number of CEM photons which passed cuts
  std::vector<double> outEt1;// Et of 1st photon
  std::vector<double> outEt2;// Et of 2nd photon
 
//----------------------------------------------------------------------------------------
//  *****  Declaring output parameters/results of the EMfilter Module for ONE event ***** 
//  --- all parameters are for photons with Et>7     
//________________________________________________________________________________________

  int myNpho;                                // number of photons with Et>7 GeV after ID cuts
  int myNpho13;                              // number of photons with Et>13 GeV after ID cuts
  int myNpho20;                              // number of photons with Et>20 GeV after ID cuts

  std::vector<TLorentzVector> myUncorrPho;   // uncorrected photons
  std::vector<TLorentzVector> myCorrPho;     // corrected photons
  std::vector<int> myPhoInd;                 // original index in PhotonBlock
  std::vector<double> phoEtaDet;             // detector eta
  std::vector<double> phoHadEm3;             // HAD/EM (3 towers)
  std::vector<double> phoChi2;               // CES Chi2 (wire & strip)
  std::vector<int> phoN3D;                   // N3D tracks (including projected track)
  std::vector<int> phoNtwr;                  // number of towers in cluster
  std::vector<double> phoISO4;               // fully corrected Cal ISO(R=0.4) 
  std::vector<double> phoISO4leak;           // leakage only corrected Cal ISO(R=0.4) 
  std::vector<double> phoISO4raw;            // raw Cal ISO(R=0.4) 
  std::vector<double> phoISO7raw;            // raw Cal ISO(R=0.7)
  std::vector<double> phoISO4trk;            // raw Trk ISO(R=0.4) or SumPt(R=0.4)  
  std::vector<double> phoTrkMaxPt;           // Max Pt of trk in cluster  
  std::vector<double> phoEtCes2nd;           // Et of 2nd CES cluster
  std::vector<double> phoCesX;               // CESx of photon
  std::vector<double> phoCesZ;               // CESz of photon
  std::vector<double> phoCesX2;              // CESx of 2nd cluster
  std::vector<double> phoCesZ2;              // CESz of 2nd cluster
  std::vector<double> phoCprX;               // unbiased CPR local X
  std::vector<double> phoCprQ;               // unbiased CPR charge
  std::vector<double> phoCesCprX;            // CES seeded CPR local X
  std::vector<double> phoCesCprQ;            // CES seeded CPR charge 
  std::vector<double> phoCesWght;            // photon CES weight
  std::vector<double> phoCprWghtM1;          // photon default CPR weight using Nvx12
  std::vector<double> phoCprSyst1M1;         // photon syst1 CPR weight using Nvx12
  std::vector<double> phoCprSyst2M1;         // photon syst2 CPR weight using Nvx12
  std::vector<double> phoCprSyst3M1;         // photon syst3 CPR weight using Nvx12
  std::vector<double> phoCprSyst4M1;         // photon syst4 CPR weight using Nvx12
  std::vector<double> phoCprWghtM2;          // photon default CPR weight using SumEt
  std::vector<double> phoCprSyst1M2;         // photon syst1 CPR weight using SumEt   
  std::vector<double> phoCprSyst2M2;         // photon syst2 CPR weight using SumEt   
  std::vector<double> phoCprSyst3M2;         // photon syst3 CPR weight using SumEt   
  std::vector<double> phoCprSyst4M2;         // photon syst4 CPR weight using SumEt   
  

  char* fDatFileName;
					
public:
  TMyPhotonFilterModule(const char* name="MyPhotonFilter", 
		    const char* title="MyPhotonFilter");
  ~TMyPhotonFilterModule();
                                         
                                       // ***** accessors

  PhotonGeneral_t*   GetPhoHist(int i)       
  { 
    if(i<3) return &fPhoHist[i];
    else return NULL; 
  }
  AnalysisHisto_t*   GetAnaHist() { return &fAnaHist; }
  MetStudyHisto_t*   GetMetStudyHist() { return &fMetStudyHist; }


  TStnPhotonBlock*   GetPhotonBlock()   { return fPhotonBlock; }
  TStnTrackBlock*    GetTrackBlock()    { return fTrackBlock; }
  TStnJetBlock*      GetJetBlockClu04() { return fJetBlockClu04; }
  TStnMetBlock*      GetMetBlock()      { return fMetBlock; }
  TCalDataBlock*     GetCalDataBlock()  { return fCalDataBlock; }
  TStnTriggerBlock*  GetTriggerBlock()  { return fTriggerBlock; }
  TStnEmTimingBlock* GetTimingBlock()   {return fTimingBlock;}


  double GetMinEta()                   { return fMinEta; }
  double GetMaxEta()                   { return fMaxEta; }
  double GetMinHADEM(int term)         { return fMinHADEM[term]; }    
  double GetMaxHADEM(int term)         { return fMaxHADEM[term]; } 
  double GetMinCesChi2()               { return fMinCesChi2; }        
  double GetMaxCesChi2()               { return fMaxCesChi2; }
  int    GetMinN3D()                   { return fMinN3D; }               
  int    GetMaxN3D()                   { return fMaxN3D; }
  double GetMinPtmax(int term)         { return fMinPtmax[term]; }          
  double GetMaxPtmax(int term)         { return fMaxPtmax[term]; }
  double GetMinCalIso4_corr(int term)  { return fMinCalIso4_corr[term]; }  
  double GetMaxCalIso4_corr(int term)  { return fMaxCalIso4_corr[term]; }
  double GetMinTrkIso4(int term)       { return fMinTrkIso4[term]; }       
  double GetMaxTrkIso4(int term)       { return fMaxTrkIso4[term]; }
  double GetMin2ndCesEt(int term)      { return fMin2ndCesEt[term]; }       
  double GetMax2ndCesEt(int term)      { return fMax2ndCesEt[term]; }
  double GetMinCesX()                  { return fMinCesX; }           
  double GetMaxCesX()                  { return fMaxCesX; }
  double GetMinCesZ()                  { return fMinCesZ; }                           
  double GetMaxCesZ()                  { return fMinCesZ; }                           
  double GetMinTrkCprX()               { return fMinTrkCprX; }

  double GetMinEtcor(int i)            { return fMinEtcor[i]; }       
  double GetMaxEtcor(int i)            { return fMaxEtcor[i]; }       
  double GetEtfnl_trh()                { return fEtfnl_trh; }         
  int GetMinNpho_Lfnl()                { return fMinNpho_Lfnl; }         
  int GetMaxNpho_Lfnl()                { return fMaxNpho_Lfnl; }        
  int GetMinNpho_Efnl()                { return fMinNpho_Efnl; }          
  int GetMaxNpho_Efnl()                { return fMaxNpho_Efnl; }

  double GetTimeWindow(int i) { if(i<2) return timeWindow[i]; else return -999.9; } 
  double GetPhoTimeThr()      { return phoTimeThr; }
  double GetDelTimeThr()      { return dTimeThr; } 

  int    GetUsePhoTrig()               { return fUsePhoTrig; }
  int    GetUseWireCheck()             { return fUseWireCheck; } 
  int    GetUseCprCheck()              { return fUseCprCheck; } 
  int    GetUseCesCheck()              { return fUseCesCheck; } 
  int    GetUseTrkCprCheck()           { return fUseTrkCprCheck; } 
  int    GetUseFixed2ndCesCut()        { return fUseFixed2ndCesCut; }
  int    GetUseVerbose()               { return fUseVerbose; }
  int    GetPrintMyEvent()             { return fPrintMyEvent; }
  int    GetUseEngCorr()               { return fUseEngCorr; }
  int    GetUseBeamHaloCut()           { return fUseBeamHaloCut; }
  int    GetHaloCutScenario()          { return HaloCutScenario; }
  int    GetUseDiphoMode()             { return fUseDiphoMode; }
  int    GetPrintPhoList()             { return fPrintPhoList; }
  int    GetUseCosmicsCut()            { return fUseCosmicsCut; }
  int    GetUsePhoFakeCut()            { return fUsePhoFakeCut; }
  int    GetUseTimingCut()             { return fUseTimingCut; }
  double GetMinDelRcosm()              { return fMinDelRcosm; }
  double GetMaxDelRcosm()              { return fMaxDelRcosm; }


  char*            GetDatFileName()  { return fDatFileName; }

  //__________________________________________________________ accessors to the
  //__________________________________________________________ output params
  int GetmyNpho() { return myNpho; }                                
  TLorentzVector* GetmyUncorrPho(int i) // this should ensure(?) that "myUncorrPho" will   
  {					// not be changed(?) by accident in calling program
    if(i>=0 && i<myUncorrPho.size()) return &myUncorrPho[i];                
    else return NULL;
  }
  TLorentzVector* GetmyCorrPho(int i) // this should ensure(?) that "myCorrPho" will     
  {				      // not be changed(?) by accident in calling program
    if(i>=0 && i<myCorrPho.size()) return &myCorrPho[i];                
    else return NULL;
  }
  int GetmyPhoInd(int i)
  {
    if(i>=0 && i<myCorrPho.size()) return myPhoInd[i];
    else return -1;
  }
  double GetphoEtaDet(int i)
  {
    if(i>=0 && i<phoEtaDet.size()) return phoEtaDet[i]; 
    else return -10.0;
  }
  double GetphoHadEm3(int i)
  {
    if(i>=0 && i<phoHadEm3.size()) return phoHadEm3[i]; 
    else return -10.0;    
  }             
  double GetphoChi2(int i)
  {
    if(i>=0 && i<phoChi2.size()) return phoChi2[i]; 
    else return -10.0;    
  }                 
  int GetphoN3D(int i) 
  {
    if(i>=0 && i<phoN3D.size()) return phoN3D[i]; 
    else return -10;    
  }                                   
  int GetphoNtwr(int i) 
  {
    if(i>=0 && i<phoNtwr.size()) return phoNtwr[i]; 
    else return -10;    
  }                                   
  double GetphoISO4(int i)
  {
    if(i>=0 && i<phoISO4.size()) return phoISO4[i]; 
    else return -10.0;    
  }                                                  
  double GetphoISO4leak(int i)
  {
    if(i>=0 && i<phoISO4leak.size()) return phoISO4leak[i]; 
    else return -10.0;    
  }                                                             
  double GetphoISO4raw(int i)
  {
    if(i>=0 && i<phoISO4raw.size()) return phoISO4raw[i]; 
    else return -10.0;    
  }                                                                         
  double GetphoISO7raw(int i)
  {
    if(i>=0 && i<phoISO7raw.size()) return phoISO7raw[i]; 
    else return -10.0;    
  }           
  double GetphoTrkMaxPt(int i)
  {
    if(i>=0 && i<phoTrkMaxPt.size()) return phoTrkMaxPt[i]; 
    else return -10.0;    
  }                                                                         
  double GetphoISO4trk(int i)
  {
    if(i>=0 && i<phoISO4trk.size()) return phoISO4trk[i]; 
    else return -10.0;    
  }                                                                         
  double GetphoEtCes2nd(int i) 
  {
    if(i>=0 && i<phoEtCes2nd.size()) return phoEtCes2nd[i]; 
    else return -10.0;    
  }                                                                                   
  double GetphoCesX(int i)               
  {
    if(i>=0 && i<phoCesX.size()) return phoCesX[i]; 
    else return -1000.0;    
  }                                                                                   
  double GetphoCesZ(int i)
  {
    if(i>=0 && i<phoCesZ.size()) return phoCesZ[i]; 
    else return -1000.0;    
  }                                                                                                  
  double GetphoCesX2(int i)               
  {
    if(i>=0 && i<phoCesX2.size()) return phoCesX2[i]; 
    else return -1000.0;    
  }                                                                                   
  double GetphoCesZ2(int i)
  {
    if(i>=0 && i<phoCesZ2.size()) return phoCesZ2[i]; 
    else return -1000.0;    
  }                                                                                                  
  double GetphoCprX(int i)               
  {
    if(i>=0 && i<phoCprX.size()) return phoCprX[i]; 
    else return -1000.0;    
  }                                                                                   
  double GetphoCprQ(int i)
  {
    if(i>=0 && i<phoCprQ.size()) return phoCprQ[i]; 
    else return -1000.0;    
  }                                                                                                  
  double GetphoCesCprX(int i)               
  {
    if(i>=0 && i<phoCesCprX.size()) return phoCesCprX[i]; 
    else return -1000.0;    
  }                                                                                   
  double GetphoCesCprQ(int i)
  {
    if(i>=0 && i<phoCesCprQ.size()) return phoCesCprQ[i]; 
    else return -1000.0;    
  }                                                                                                  
  double GetphoCesWght(int i)
  {
    if(i>=0 && i<phoCesWght.size()) return phoCesWght[i]; 
    else return -1000.0;    
  }                                                                                                  
  double GetphoCprWghtM1(int i)
  {
    if(i>=0 && i<phoCprWghtM1.size()) return phoCprWghtM1[i]; 
    else return -1000.0;    
  }                                                                                                      
  double GetphoCprSyst1M1(int i)
  {
    if(i>=0 && i<phoCprSyst1M1.size()) return phoCprSyst1M1[i]; 
    else return -1000.0;    
  }                                                                                              
  double GetphoCprSyst2M1(int i)
  {
    if(i>=0 && i<phoCprSyst2M1.size()) return phoCprSyst2M1[i]; 
    else return -1000.0;    
  }         
  double GetphoCprSyst3M1(int i)         
  {
    if(i>=0 && i<phoCprSyst3M1.size()) return phoCprSyst3M1[i]; 
    else return -1000.0;    
  }
  double GetphoCprSyst4M1(int i)
  {
    if(i>=0 && i<phoCprSyst4M1.size()) return phoCprSyst4M1[i]; 
    else return -1000.0;    
  }         
  double GetphoCprWghtM2(int i)
  {
    if(i>=0 && i<phoCprWghtM2.size()) return phoCprWghtM2[i]; 
    else return -1000.0;    
  }          
  double GetphoCprSyst1M2(int i)
  {
    if(i>=0 && i<phoCprSyst1M2.size()) return phoCprSyst1M2[i]; 
    else return -1000.0;    
  }                   
  double GetphoCprSyst2M2(int i)
  {
    if(i>=0 && i<phoCprSyst2M2.size()) return phoCprSyst2M2[i]; 
    else return -1000.0;    
  }                   
  double GetphoCprSyst3M2(int i) 
  {
    if(i>=0 && i<phoCprSyst3M2.size()) return phoCprSyst3M2[i]; 
    else return -1000.0;    
  }                  
  double GetphoCprSyst4M2(int i)         
  {
    if(i>=0 && i<phoCprSyst4M2.size()) return phoCprSyst4M2[i]; 
    else return -1000.0;    
  }          


                                       // ***** setters
  void  SetDatFileName   (char* fname)       { fDatFileName = fname; }    

  void SetMinEta(double cut)                     { fMinEta=cut; }
  void SetMaxEta(double cut)                     { fMaxEta=cut; }
  void SetMinHADEM(int term, double cut)         { fMinHADEM[term]=cut; }    
  void SetMaxHADEM(int term, double cut)         { fMaxHADEM[term]=cut; } 
  void SetMinCesChi2(double cut)                 { fMinCesChi2=cut; }        
  void SetMaxCesChi2(double cut)                 { fMaxCesChi2=cut; }
  void SetMinN3D(int cut)                        { fMinN3D=cut; }               
  void SetMaxN3D(int cut)                        { fMaxN3D=cut; }
  void SetMinPtmax(int term, double cut)         { fMinPtmax[term]=cut; }          
  void SetMaxPtmax(int term, double cut)         { fMaxPtmax[term]=cut; }
  void SetMinCalIso4_corr(int term, double cut)  { fMinCalIso4_corr[term]=cut; }  
  void SetMaxCalIso4_corr(int term, double cut)  { fMaxCalIso4_corr[term]=cut; }
  void SetMinTrkIso4(int term, double cut)       { fMinTrkIso4[term]=cut; }       
  void SetMaxTrkIso4(int term, double cut)       { fMaxTrkIso4[term]=cut; }
  void SetMin2ndCesEt(int term, double cut)      { fMin2ndCesEt[term]=cut; }       
  void SetMax2ndCesEt(int term, double cut)      { fMax2ndCesEt[term]=cut; }
  void SetMinCesX(double cut)                    { fMinCesX=cut; }           
  void SetMaxCesX(double cut)                    { fMaxCesX=cut; }
  void SetMinCesZ(double cut)                    { fMinCesZ=cut; }                           
  void SetMaxCesZ(double cut)                    { fMaxCesZ=cut; }                           
  void SetMinTrkCprX(double cut)                 { fMinTrkCprX=cut; }

  void SetMinEtcor(int i, double cut)            { fMinEtcor[i]=cut; }       
  void SetMaxEtcor(int i, double cut)            { fMaxEtcor[i]=cut; }       
  void SetEtfnl_trh(double cut)                  { fEtfnl_trh=cut; }         
  void SetMinNpho_Lfnl(int cut)                  { fMinNpho_Lfnl=cut; }         
  void SetMaxNpho_Lfnl(int cut)                  { fMaxNpho_Lfnl=cut; }        
  void SetMinNpho_Efnl(int cut)                  { fMinNpho_Efnl=cut; }          
  void SetMaxNpho_Efnl(int cut)                  { fMaxNpho_Efnl=cut; }
  void SetMinNpho_fnl(int cut)                  { fMinNpho_fnl=cut; }          
  void SetMaxNpho_fnl(int cut)                  { fMaxNpho_fnl=cut; }

  void SetTimeWindow(int i, double cut)          { if(i<2) timeWindow[i]=cut; else return; } 
  void SetPhoTimeThr(double cut)                 { phoTimeThr=cut; }
  void SetDelTimeThr(double cut)                 { dTimeThr=cut; } 
  void SetMinDelRcosm(double cut)                { fMinDelRcosm=cut; }
  void SetMaxDelRcosm(double cut)                { fMaxDelRcosm=cut; }

  void SetUsePhoTrig(int cut)                    { fUsePhoTrig=cut; }
  void SetUseWireCheck(int cut)                  { fUseWireCheck=cut; } 
  void SetUseCprCheck(int cut)                   { fUseCprCheck=cut; } 
  void SetUseCesCheck(int cut)                   { fUseCesCheck=cut; } 
  void SetUseTrkCprCheck(int cut)                { fUseTrkCprCheck=cut; } 
  void SetUseFixed2ndCesCut(int cut)             { fUseFixed2ndCesCut=cut; }
  void SetUseVerbose(int cut)                    { fUseVerbose=cut; }
  void SetPrintMyEvent(int cut)                  { fPrintMyEvent=cut; }
  void SetUseEngCorr(int cut)                    { fUseEngCorr=cut; }
  void SetUseBeamHaloCut(int cut)                { fUseBeamHaloCut=cut; }
  void SetHaloCutScenario(int cut)               { HaloCutScenario=cut; }
  void SetUseDiphoMode(int cut)                  { fUseDiphoMode=cut; }
  void SetPrintPhoList(int cut)                  { fPrintPhoList=cut; }
  void SetUseCosmicsCut(int cut)                 { fUseCosmicsCut=cut; }
  void SetUsePhoFakeCut(int cut)                 { fUsePhoFakeCut=cut; }
  void SetUseTimingCut(int cut)                  { fUseTimingCut=cut; }

  //__________________________________________________________ setters of the
  //__________________________________________________________ output params
  void SetmyNpho(int param) { myNpho = param; }                                
  void SetmyUncorrPho(int i, TLorentzVector vec)    
  {					
    if(i>=0 && i<myUncorrPho.size()) myUncorrPho[i]=vec;                
    else myUncorrPho.push_back(vec);
  }
  void SetmyCorrPho(int i, TLorentzVector vec)      
  {				      
    if(i>=0 && i<myCorrPho.size()) myCorrPho[i]=vec;                
    else myCorrPho.push_back(vec);
  }
  void SetmyPhoInd(int i, int param)
  {
    if(i>=0 && i<myCorrPho.size()) myPhoInd[i]=param;
    else myPhoInd.push_back(param);
  }
  void SetphoEtaDet(int i, double param)
  {
    if(i>=0 && i<phoEtaDet.size()) phoEtaDet[i]=param; 
    else phoEtaDet.push_back(param);
  }
  void SetphoHadEm3(int i, double param)
  {
    if(i>=0 && i<phoHadEm3.size()) phoHadEm3[i]=param; 
    else phoHadEm3.push_back(param);    
  }             
  void SetphoChi2(int i, double param)
  {
    if(i>=0 && i<phoChi2.size()) phoChi2[i]=param; 
    else phoChi2.push_back(param);    
  }                 
  void SetphoN3D(int i, int param) 
  {
    if(i>=0 && i<phoN3D.size()) phoN3D[i]=param; 
    else phoN3D.push_back(param);    
  }                                   
  void SetphoNtwr(int i, int param) 
  {
    if(i>=0 && i<phoNtwr.size()) phoNtwr[i]=param; 
    else phoNtwr.push_back(param);    
  }                                   
  void SetphoISO4(int i, double param)
  {
    if(i>=0 && i<phoISO4.size()) phoISO4[i]=param; 
    else phoISO4.push_back(param);    
  }                                                  
  void SetphoISO4leak(int i, double param)
  {
    if(i>=0 && i<phoISO4leak.size()) phoISO4leak[i]=param; 
    else phoISO4leak.push_back(param);    
  }                                                             
  void SetphoISO4raw(int i, double param)
  {
    if(i>=0 && i<phoISO4raw.size()) phoISO4raw[i]=param; 
    else phoISO4raw.push_back(param);    
  }                                                                         
  void SetphoISO7raw(int i, double param)
  {
    if(i>=0 && i<phoISO7raw.size()) phoISO7raw[i]=param; 
    else phoISO7raw.push_back(param);    
  }                             
  void SetphoTrkMaxPt(int i, double param)
  {
    if(i>=0 && i<phoTrkMaxPt.size()) phoTrkMaxPt[i]=param; 
    else phoTrkMaxPt.push_back(param);    
  }                                                                                                         
  void SetphoISO4trk(int i, double param)
  {
    if(i>=0 && i<phoISO4trk.size()) phoISO4trk[i]=param; 
    else phoISO4trk.push_back(param);    
  }                                                                         
  void SetphoEtCes2nd(int i, double param) 
  {
    if(i>=0 && i<phoEtCes2nd.size()) phoEtCes2nd[i]=param; 
    else phoEtCes2nd.push_back(param);    
  }                                                                                   
  void SetphoCesX(int i, double param)               
  {
    if(i>=0 && i<phoCesX.size()) phoCesX[i]=param; 
    else phoCesX.push_back(param);    
  }                                                                                   
  void SetphoCesZ(int i, double param)
  {
    if(i>=0 && i<phoCesZ.size()) phoCesZ[i]=param; 
    else phoCesZ.push_back(param);    
  }                                                                                                  
  void SetphoCesX2(int i, double param)               
  {
    if(i>=0 && i<phoCesX2.size()) phoCesX2[i]=param; 
    else phoCesX2.push_back(param);    
  }                                                                                   
  void SetphoCesZ2(int i, double param)
  {
    if(i>=0 && i<phoCesZ2.size()) phoCesZ2[i]=param; 
    else phoCesZ2.push_back(param);    
  }                                                                                                  
  void SetphoCprX(int i, double param)               
  {
    if(i>=0 && i<phoCprX.size()) phoCprX[i]=param; 
    else phoCprX.push_back(param);    
  }                                                                                   
  void SetphoCprQ(int i, double param)
  {
    if(i>=0 && i<phoCprQ.size()) phoCprQ[i]=param; 
    else phoCprQ.push_back(param);    
  }                                                                                                  
  void SetphoCesCprX(int i, double param)               
  {
    if(i>=0 && i<phoCesCprX.size()) phoCesCprX[i]=param; 
    else phoCesCprX.push_back(param);    
  }                                                                                   
  void SetphoCesCprQ(int i, double param)
  {
    if(i>=0 && i<phoCesCprQ.size()) phoCesCprQ[i]=param; 
    else phoCesCprQ.push_back(param);    
  }                                                                                                  
  void SetphoCesWght(int i, double param)
  {
    if(i>=0 && i<phoCesWght.size()) phoCesWght[i]=param; 
    else phoCesWght.push_back(param);    
  }                                                                                                  
  void SetphoCprWghtM1(int i, double param)
  {
    if(i>=0 && i<phoCprWghtM1.size()) phoCprWghtM1[i]=param; 
    else phoCprWghtM1.push_back(param);    
  }                                                                                                      
  void SetphoCprSyst1M1(int i, double param)
  {
    if(i>=0 && i<phoCprSyst1M1.size()) phoCprSyst1M1[i]=param; 
    else phoCprSyst1M1.push_back(param);    
  }                                                                                              
  void SetphoCprSyst2M1(int i, double param)
  {
    if(i>=0 && i<phoCprSyst2M1.size()) phoCprSyst2M1[i]=param; 
    else phoCprSyst2M1.push_back(param);    
  }         
  void SetphoCprSyst3M1(int i, double param)         
  {
    if(i>=0 && i<phoCprSyst3M1.size()) phoCprSyst3M1[i]=param; 
    else phoCprSyst3M1.push_back(param);    
  }
  void SetphoCprSyst4M1(int i, double param)
  {
    if(i>=0 && i<phoCprSyst4M1.size()) phoCprSyst4M1[i]=param; 
    else phoCprSyst4M1.push_back(param);    
  }         
  void SetphoCprWghtM2(int i, double param)
  {
    if(i>=0 && i<phoCprWghtM2.size()) phoCprWghtM2[i]=param; 
    else phoCprWghtM2.push_back(param);    
  }          
  void SetphoCprSyst1M2(int i, double param)
  {
    if(i>=0 && i<phoCprSyst1M2.size()) phoCprSyst1M2[i]=param; 
    else phoCprSyst1M2.push_back(param);    
  }                   
  void SetphoCprSyst2M2(int i, double param)
  {
    if(i>=0 && i<phoCprSyst2M2.size()) phoCprSyst2M2[i]=param; 
    else phoCprSyst2M2.push_back(param);    
  }                   
  void SetphoCprSyst3M2(int i, double param) 
  {
    if(i>=0 && i<phoCprSyst3M2.size()) phoCprSyst3M2[i]=param; 
    else phoCprSyst3M2.push_back(param);    
  }                  
  void SetphoCprSyst4M2(int i, double param)         
  {
    if(i>=0 && i<phoCprSyst4M2.size()) phoCprSyst4M2[i]=param; 
    else phoCprSyst4M2.push_back(param);    
  }          

					// ****** overloaded methods of 
					// TStnModule
  int     BeginJob();
  int     BeginRun();
  int     Event   (int ientry);
  int     EndJob  ();
                                        // ****** other methods

  void  ClearModuleOutput(); // clears the Module output in the beginning of every event
  void  FillModuleOutput(TStnPhoton* Pho, int pho_ind);  // fills the Module output in the end of every event
  void  PrintModuleOutput(); // prints the Module output in the end of every event

  void  BookHistograms();
  void  BookPhotonHistograms(PhotonGeneral_t& Hist, const char* Folder);
  void  BookAnaHistograms(AnalysisHisto_t& Hist, const char* Folder); 
  void  BookMetStudyHistograms(MetStudyHisto_t& Hist, const char* Folder); 
  void  BookBeamHaloStudyHistograms(BeamHaloStudyHisto_t& Hist, const char* Folder); 
  void  BookTimingHistograms(EmTimingHisto_t& Hist, const char* Folder); 


  void  FillAnaHistograms(AnalysisHisto_t& Hist, double zvx, int nvx); 
  void  FillMetStudyHistograms(MetStudyHisto_t& Hist, int nvx);
  void  FillBeamHaloStudyHistograms(BeamHaloStudyHisto_t& Hist, HaloStuff *beamhalo, TStnPhoton* Pho);
  void  FillPhotonHistogramsB(PhotonGeneral_t& Hist, TStnPhoton* Pho, double zvx, int pho_ind); // before cuts
  void  FillPhotonHistogramsA(PhotonGeneral_t& Hist, TStnPhoton* Pho, double zvx, int pho_ind); // after cuts
  char* HistoSummary(TH1F* myhisto);
  char* OutputSummary(int ind);

  void  DoMyEmTiming(int pho_ind[2],int mode_code,double &t1,double &t2);
  void  DoMyBeamHalo(int pho_ind);
//   void  getBeamHaloInfo(int pho_ind, int& seedWedge, 
// 			int& sideWedge, int& eastNHads,
// 			int& westNHads,double& emSeedE,
// 			double& emSideE,double& hadSeedE);
  void  getBeamHaloInfo(int pho_ind, int& seedWedge, int& seedWedgeH, 
			int& sideWedge, int& sideWedgeH, int& eastNHads,
			int& westNHads, double& emSeedE, double& emSideE, 
			double& hadSeedE, double& seedWedgeHadE);
  int   BeamHaloCut(HaloStuff *beamhalo, int nvx12, int scenario=0);
  int   MyCosmicsCut(TStnPhoton* Pho);
  void  MatchCalorTowers(int pho_ind, CalDataArray* cdholder);

  int MyCEMPhotonIDcut(TStnPhoton* Pho, TStnTrackBlock* TrkBlock);
  int MyPhoFakeIDcut(TStnPhoton* Pho, TStnEvent* event);

//   double MyCPRweights(TStnPhoton* Pho, CprStuff input, 
// 		      double &phoProb, double &bckgProb, double &servPar,
// 		      double &cprsyst1, double &cprsyst2, double &cprsyst3, double &cprsyst4);

  //_____________________________________________________________ theta* -- di-pho scattering angle
  double GetThetaStar(double y1, double y2);
  double GetThetaStar(std::vector<TLorentzVector> vec);
  //__________________________________________________ returns Kt of two leading photons
  double GetMyQt(std::vector<TLorentzVector> vec);
  //__________________________________________________ returns Phi of di-photon system
  double GetMyQtPhi(std::vector<TLorentzVector> vec);
  //__________________________________________________ returns Ht=Met+Et1+Et2+...Eti
  double GetMyHt(std::vector<TLorentzVector> vec, double met);
  //__________________________________________________ returns corrected sumEt=SumEt-Et1-Et2-...Eti
  double GetMyCorrSumEt(std::vector<TLorentzVector> vec, double sumet);
  //__________________________________________________ returns di-photon mass
  double GetMyDiPhoMass(std::vector<TLorentzVector> vec);


  ClassDef(TMyPhotonFilterModule,0)

};

#endif
