#include <iomanip>
#include <iostream>
#include <fstream>
#include <algorithm>
#include "TF1.h"
#include "TCanvas.h"
#include "TMath.h"
#include "Stntuple/loop/TStnAna.hh"
#include "TMyPhotonFilterModule_ggX.hh"
#include "TMyEventFilterModule_ggX.hh"
#include "TMyVertexFilterModuleA_ntu.hh"
#include "Stntuple/photon/TWireChecker.hh"
// #include "PhotonBackgroundComputer.hh"
#include "Stntuple/obj/TStnTriggerTable.hh"
#include "Stntuple/ana/TEmTimingModule.hh"

bool SortTowersByEnergy(TCalTower* c1, TCalTower* c2){
  if(c1->EmEnergy() > c2->EmEnergy()) return true;
  else return false;
}

// ClassImp(TMyPhotonFilterModule)
//_____________________________________________________________________________
TMyPhotonFilterModule::TMyPhotonFilterModule(const char* name, const char* title):
  TStnModule(name,title)
{

  //------------------ All default values correspond to standard cuts
  //__________________ *** All photons should "pass" MinCut values (except CesZ cut) 
  fMinEta=0.0;
  fMaxEta=1.1;
  fMinHADEM[0]=0.0;         
  fMinHADEM[1]=0.0;         
  fMinHADEM[2]=0.0;         
  fMaxHADEM[0]=0.125;        
  fMaxHADEM[1]=0.055;        
  fMaxHADEM[2]=0.00045;                                      
  fMinCesChi2=-1.0E6;   // dummy limit, just in case          
  fMaxCesChi2=20.0;
  fMinN3D=0;   // CPR methods require no tracks in cluster. However,
  fMaxN3D=1;   // there can be 1 track in cluster for CES meth. We use N3D=1 for ggX analysis
  fMinPtmax[0]=-1.0E6; // has to be this dummy value     
  fMinPtmax[1]=0.0;     
  fMaxPtmax[0]=1.0;     
  fMaxPtmax[1]=0.005;     
  fMinCalIso4_corr[0]=-100.0;   
  fMinCalIso4_corr[1]=-100.0;   
  fMinCalIso4_corr[2]=0.0;   
  fMaxCalIso4_corr[0]=0.1;    
  fMaxCalIso4_corr[1]=2.0;    
  fMaxCalIso4_corr[2]=0.02;    
  fMinTrkIso4[0]=0.0;        
  fMinTrkIso4[1]=0.0;        
  fMaxTrkIso4[0]=2.0;
  fMaxTrkIso4[1]=0.005;
  fMin2ndCesEt[0]=-1.0E6;  // ATTN!!! According to Ray Culbertson,        
  fMin2ndCesEt[1]=-1.0E6;  // standard sliding cut on 2nd CES cluster Et   
  fMin2ndCesEt[2]=-1.0E6;  // should be applied for both CPR and CES methods in 5.3.1 data
  fMax2ndCesEt[0]=0.14; 
  fMax2ndCesEt[1]=2.4;      
  fMax2ndCesEt[2]=0.01;         
  fMinCesX=0.0;           
  fMaxCesX=21.0; // 17.5 (instead of 21.0) was used in di-photon analysis note6312
  fMinCesZ=9.0;    // 14.0 (instead of 9.0) was used in di-photon analysis note6312         
  fMaxCesZ=230.0;   // 217.0 (instead of 230.0) was used in di-photon analysis note6312         
  fMinTrkCprX=10.0; // 

  //________________________________ these cuts applied after photon ID cuts  
  fMinEtcor[0]=13.0;     // as in cdf6389 (ggX note) 
  fMinEtcor[1]=13.0;     // as in cdf6389 (ggX note)  
  fMaxEtcor[0]=1000.0;       
  fMaxEtcor[1]=1000.0;       

  fEtfnl_trh=13.0;          // should be min of fMinEtcor[0] and fMinEtcor[1] in ggX analysis 
  fMinNpho_Lfnl=2;           // number of leading photons above Etfnl_trh threshold
  fMaxNpho_Lfnl=100;         
  fMinNpho_Efnl=0;          // number of extra photons below Etfnl_trh threshold 
  fMaxNpho_Efnl=100;
  fMinNpho_fnl=2;           // total number of photons NphoL_fnl+NphoE_fnl 
  fMaxNpho_fnl=100;

  fDatFileName="results/MyPhotonFilter_output.dat";

  fUseWireCheck=0;   // both Cpr & Ces wire check 0--Off, 1--On (default ggX is 0)
  fUseCprCheck=0;    // Cpr wire check 0--Off, 1--On (default ggX is 0)
  fUseCesCheck=0;    // Ces wire check 0--Off, 1--On (default ggX is 0)
  fUseTrkCprCheck=0; // TrkCpr check 0--Off, 1--On (default ggX is 0)
  fUseFixed2ndCesCut=0; // 0--sliding cut, 1--fixed cut; if fixed cut then 
                        //  fMin2ndCesEt[0] and fMax2ndCesEt[0] has to be set to cut values
  fUseVerbose=0;     // default: 0=no printout; 1=printout
  fUseEngCorr=0;     // Ray's photon energy correction: have to be ==1 for cdip0da_diphoton
  fPrintMyEvent=0;   // default: 0=no printout; 1=printout
  fUseBeamHaloCut=0; // default: 0=beam halo cut is off; 1=remove beam halo; -1=select beam halo 
  HaloCutScenario=0; // beam halo cut scenario: 0=Max's default version; 1=modified using seedHadE; 2=modified using SeedWedgeH
  fUseDiphoMode=1;   // use diphoton mode by default (=1), 0=incl. photon mode
  fPrintPhoList=1;   // photon list printout 
  fUseCosmicsCut=0;  // default: 0=cosmics cut is off; 1=remove cosmics; -1=select cosmics 
  fUsePhoTrig=0; // default: 0=no trigger cut; 1=select events passing trigger; -1=remove events passing trigger 
  fUsePhoFakeCut=0;  // default: 0=PhoFake cut is off; 1=remove PhoFakes; -1=select PhoFakes
  fUseTimingCut=0; // default: 0=no EM timing cut; 1=remove out of time events; -1=out of time events

  timeWindow[0]=-80.0;     // time window suggested by Max
  timeWindow[1]=160.0;
  phoTimeThr=4.0*1.665; // 4 sigma
  dTimeThr=4.0*1.021;   // 4 sigma 
  fMinDelRcosm=0.4;     // need this cut to separate cosmics and satelite bunch interactions
  fMaxDelRcosm=100.0;

  myGoodWire=new TWireChecker();
//   myPhoComputer=new PhotonBackgroundComputer();
 
  std::cout<<"Hi, entering TMyPhotonFilterModule"<<std::endl;
}

//_____________________________________________________________________________
TMyPhotonFilterModule::~TMyPhotonFilterModule() {
  delete myGoodWire;
//   delete myPhoComputer;
}

void TMyPhotonFilterModule::BookPhotonHistograms(PhotonGeneral_t& Hist, const char* Folder) {
  char name [200];
  char title[200];
  // book histograms  
  //__________________________________ before cuts

  sprintf(name,"Ncand_b");
  sprintf(title," %s%s",Folder,": number of Photon candidates");
  Hist.fPhtnNcand_b= new TH1F(name,title,40,-0.5,39.5);
  AddHistogram(Hist.fPhtnNcand_b,Folder);
  sprintf(name,"Ntower_b");
  sprintf(title," %s%s",Folder,": N_tower in cluster");
  Hist.fPhtnNtower_b= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fPhtnNtower_b,Folder);
  sprintf(name,"Detector_b");
  sprintf(title," %s%s",Folder,": Detector -- 0=CEM, 1=PEM");
  Hist.fPhtnDetector_b= new TH1F(name,title,4,-1.5,2.5);
  AddHistogram(Hist.fPhtnDetector_b,Folder);
  sprintf(name,"DelZvx_b");
  sprintf(title," %s%s",Folder,": dZ=Z_pho-Z_bestVx");
  Hist.fPhtnDelZvx_b= new TH1F(name,title,1000,-120.0,120.0);
  AddHistogram(Hist.fPhtnDelZvx_b,Folder);
  sprintf(name,"Zvx_b");
  sprintf(title," %s%s",Folder,": Z_pho");
  Hist.fPhtnZvx_b= new TH1F(name,title,1000,-120.0,120.0);
  AddHistogram(Hist.fPhtnZvx_b,Folder);
  sprintf(name,"Like_b");
  sprintf(title," %s%s",Folder,": Photon Likelihood");
  Hist.fPhtnLike_b= new TH1F(name,title,200,-10.0,10.0);
  AddHistogram(Hist.fPhtnLike_b,Folder);
  sprintf(name,"Et_raw_b");
  sprintf(title," %s%s",Folder,": raw Et(pho) w.r.t. vx & CES");
  Hist.fPhtnEt_raw_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fPhtnEt_raw_b,Folder);
  sprintf(name,"Et_twr_b");
  sprintf(title," %s%s",Folder,": tower corr. Et(pho) w.r.t. vx & CES");
  Hist.fPhtnEt_twr_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fPhtnEt_twr_b,Folder);
  sprintf(name,"E_total_b");
  sprintf(title," %s%s",Folder,": total corr. E(pho)");
  Hist.fPhtnE_total_b= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fPhtnE_total_b,Folder);
  sprintf(name,"Eta_det_b");
  sprintf(title," %s%s",Folder,": detector Eta(pho)");
  Hist.fPhtnEta_det_b= new TH1F(name,title,100,-5.0,5.0);
  AddHistogram(Hist.fPhtnEta_det_b,Folder);
  sprintf(name,"Eta_b");
  sprintf(title," %s%s",Folder,": event Eta(pho)");
  Hist.fPhtnEta_b= new TH1F(name,title,100,-5.0,5.0);
  AddHistogram(Hist.fPhtnEta_b,Folder);
  sprintf(name,"Phi_b");
  sprintf(title," %s%s",Folder,": Phi(pho)");
  Hist.fPhtnPhi_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fPhtnPhi_b,Folder);
  sprintf(name,"Theta_b");
  sprintf(title," %s%s",Folder,": event Theta(pho)");
  Hist.fPhtnTheta_b= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fPhtnTheta_b,Folder);
  sprintf(name,"HadEm3_b");
  sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
  Hist.fPhtnHadEm3_b= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fPhtnHadEm3_b,Folder);
  sprintf(name,"HadEm2_b");
  sprintf(title," %s%s",Folder,": Had/Em (2 towers)");
  Hist.fPhtnHadEm2_b= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fPhtnHadEm2_b,Folder);
  sprintf(name,"Lshr_b");
  sprintf(title," %s%s",Folder,": Lshare (3 towers)");
  Hist.fPhtnLshr_b= new TH1F(name,title,100,-5.0,5.0);
  AddHistogram(Hist.fPhtnLshr_b,Folder);
  sprintf(name,"CalIso4_raw_b");
  sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
  Hist.fPhtnCalIso4_raw_b= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnCalIso4_raw_b,Folder);
  sprintf(name,"CalIso4_leak_b");
  sprintf(title," %s%s",Folder,": corr. for leakage CalIso(R=0.4)");
  Hist.fPhtnCalIso4_leak_b= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fPhtnCalIso4_leak_b,Folder);
  sprintf(name,"CalIso4_corr_b");
  sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
  Hist.fPhtnCalIso4_corr_b= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fPhtnCalIso4_corr_b,Folder);
  sprintf(name,"CalIso7_b");
  sprintf(title," %s%s",Folder,": ?raw? CalIso(R=0.7)");
  Hist.fPhtnCalIso7_b= new TH1F(name,title,210,-1.0,20.0);
  AddHistogram(Hist.fPhtnCalIso7_b,Folder);
  sprintf(name,"CalIso74_b");
  sprintf(title," %s%s",Folder,": ?raw? CalIso(R=0.7)-CalIso(R=0.4)");
  Hist.fPhtnCalIso74_b= new TH1F(name,title,300,-10.0,20.0);
  AddHistogram(Hist.fPhtnCalIso74_b,Folder);
  sprintf(name,"CalIso74over4_b");
  sprintf(title," %s%s",Folder,": ?raw? CalIso(R=0.7)/CalIso(R=0.4)-1.0");
  Hist.fPhtnCalIso74over4_b= new TH1F(name,title,1000,-25.0,25.0);
  AddHistogram(Hist.fPhtnCalIso74over4_b,Folder);
  sprintf(name,"TrkIso4_b");
  sprintf(title," %s%s",Folder,": TrkIso4(SumPt in R=0.4)");
  Hist.fPhtnTrkIso4_b= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnTrkIso4_b,Folder);
  sprintf(name,"CalTrkIso4_b");
  sprintf(title," %s%s",Folder,": CalIso4-TrkIso4");
  Hist.fPhtnCalTrkIso4_b= new TH1F(name,title,220,-10.0,10.0);
  AddHistogram(Hist.fPhtnCalTrkIso4_b,Folder);
  sprintf(name,"N3D_b");
  sprintf(title," %s%s",Folder,": N3Dtrk in cluster");
  Hist.fPhtnN3D_b= new TH1F(name,title,11,-1.5,9.5);
  AddHistogram(Hist.fPhtnN3D_b,Folder);
  sprintf(name,"Pt1st_b");
  sprintf(title," %s%s",Folder,": max Pt(trk) in cluster");
  Hist.fPhtnPt1st_b= new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fPhtnPt1st_b,Folder);
  sprintf(name,"Pt2nd_b");
  sprintf(title," %s%s",Folder,": 2nd Pt(trk) in cluster");
  Hist.fPhtnPt2nd_b= new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fPhtnPt2nd_b,Folder);
  sprintf(name,"NTrk4_b");
  sprintf(title," %s%s",Folder,": Ntrk in cone R=0.4");
  Hist.fPhtnNTrk4_b= new TH1F(name,title,21,-1.5,19.5);
  AddHistogram(Hist.fPhtnNTrk4_b,Folder);
  sprintf(name,"Ptmax4_b");
  sprintf(title," %s%s",Folder,": max Pt(trk) in cone R=0.4");
  Hist.fPhtnPtmax4_b= new TH1F(name,title,500,0.0,20.0);
  AddHistogram(Hist.fPhtnPtmax4_b,Folder);
  sprintf(name,"CesX_b");
  sprintf(title," %s%s",Folder,": CES local X");
  Hist.fPhtnCesX_b= new TH1F(name,title,600,-30.0,30.0);
  AddHistogram(Hist.fPhtnCesX_b,Folder);
  sprintf(name,"CesZ_b");
  sprintf(title," %s%s",Folder,": CES local Z");
  Hist.fPhtnCesZ_b= new TH1F(name,title,6000,-300.0,300.0);
  AddHistogram(Hist.fPhtnCesZ_b,Folder);
  sprintf(name,"Chi2_b");
  sprintf(title," %s%s",Folder,": CES(strip+wire) Chi^2");
  Hist.fPhtnChi2_b= new TH1F(name,title,500,0.0,100.0);
  AddHistogram(Hist.fPhtnChi2_b,Folder);
  sprintf(name,"CesX2_b");
  sprintf(title," %s%s",Folder,": 2nd cluster CES local X");
  Hist.fPhtnCesX2_b= new TH1F(name,title,600,-30.0,30.0);
  AddHistogram(Hist.fPhtnCesX2_b,Folder);
  sprintf(name,"CesZ2_b");
  sprintf(title," %s%s",Folder,": 2nd cluster CES local Z");
  Hist.fPhtnCesZ2_b= new TH1F(name,title,6000,-300.0,300.0);
  AddHistogram(Hist.fPhtnCesZ2_b,Folder);
  sprintf(name,"CesStripE2_b");
  sprintf(title," %s%s",Folder,": 2nd CES cluster strip Energy");
  Hist.fPhtnCesStripE2_b= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnCesStripE2_b,Folder);
  sprintf(name,"CesWireE2_b");
  sprintf(title," %s%s",Folder,": 2nd CES cluster wire Energy");
  Hist.fPhtnCesWireE2_b= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnCesWireE2_b,Folder);

  sprintf(name,"CprX_b");
  sprintf(title," %s%s",Folder,": unbiased CPR local X");
  Hist.fPhtnCprX_b= new TH1F(name,title,240,-30.0,30.0);                    
  AddHistogram(Hist.fPhtnCprX_b,Folder);
  sprintf(name,"CprQ_b");
  sprintf(title," %s%s",Folder,": unbiased CPR charge Q");
  Hist.fPhtnCprQ_b= new TH1F(name,title,201,-5.0,10045.0);                    
  AddHistogram(Hist.fPhtnCprQ_b,Folder);
  sprintf(name,"CesCprX_b");
  sprintf(title," %s%s",Folder,": CES seeded CPR local X");
  Hist.fPhtnCesCprX_b= new TH1F(name,title,240,-30.0,30.0);                    
  AddHistogram(Hist.fPhtnCesCprX_b,Folder);
  sprintf(name,"CesCprQ_b");
  sprintf(title," %s%s",Folder,": CES seeded CPR charge Q");
  Hist.fPhtnCesCprQ_b= new TH1F(name,title,201,-5.0,10045.0);                    
  AddHistogram(Hist.fPhtnCesCprQ_b,Folder);
  sprintf(name,"CesCpr_dX_b");
  sprintf(title," %s%s",Folder,": dX= X_ces - X_cpr");
  Hist.fPhtnCesCpr_dX_b= new TH1F(name,title,480,-60.0,60.0);;               
  AddHistogram(Hist.fPhtnCesCpr_dX_b,Folder);
  sprintf(name,"2ndCesCpr_dX_b");
  sprintf(title," %s%s",Folder,": dX= X_ces(2nd cluster) - X_cpr");
  Hist.fPhtn2ndCesCpr_dX_b= new TH1F(name,title,480,-60.0,60.0);;               
  AddHistogram(Hist.fPhtn2ndCesCpr_dX_b,Folder);

  sprintf(name,"CesWght_b");
  sprintf(title," %s%s",Folder,": CES background Weight, Et(pho)<35 GeV");
  Hist.fPhtnCesWght_b= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCesWght_b,Folder);
  sprintf(name,"CprWght_b");
  sprintf(title," %s%s",Folder,": CPR background Weight");
  Hist.fPhtnCprWght_b= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCprWght_b,Folder);
  sprintf(name,"CprWghtB35_b");
  sprintf(title," %s%s",Folder,": CPR background Weight, Et(pho)<35 GeV");
  Hist.fPhtnCprWghtB35_b= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCprWghtB35_b,Folder);
  sprintf(name,"CprWghtA35_b");
  sprintf(title," %s%s",Folder,": CPR background Weight, Et(pho)>=35 GeV");
  Hist.fPhtnCprWghtA35_b= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCprWghtA35_b,Folder);

  sprintf(name,"CprWght_Et_b");
  sprintf(title,"CprWght vs. corr. Et(pho)");
  Hist.fPhtnCprWght_Et_b= new TProfile(name,title,100,0.0,300.0,-100.0,100.0);
  AddHistogram(Hist.fPhtnCprWght_Et_b,Folder);
  sprintf(name,"CesWght_Et_b");
  sprintf(title,"CesWght vs. corr. Et(pho)");          
  Hist.fPhtnCesWght_Et_b= new TProfile(name,title,50,0.0,50.0,-100.0,100.0);          
  AddHistogram(Hist.fPhtnCesWght_Et_b,Folder);
  sprintf(name,"CprWghtB35_Et_b");
  sprintf(title,"CprWght vs. corr. Et(pho), Et<35");          
  Hist.fPhtnCprWghtB35_Et_b= new TProfile(name,title,50,0.0,50.0,-100.0,100.0);          
  AddHistogram(Hist.fPhtnCprWghtB35_Et_b,Folder);

  for(int i=0; i<5; i++)
    {
      sprintf(name,"fPhtnCprWghtM1_b[%i]",i);
      if(i==0) sprintf(title,"CesWght using Nvx12: cpr_default");
      else sprintf(title,"CesWght using Nvx12: cpr_syst%i",i);
      Hist.fPhtnCprWghtM1_b[i]=new TH1F(name,title,400,-20.0,20.0);
      AddHistogram(Hist.fPhtnCprWghtM1_b[i],Folder);

      sprintf(name,"fPhtnCprWghtM2_b[%i]",i);
      if(i==0) sprintf(title,"CesWght using SumEt: cpr_default");
      else sprintf(title,"CesWght using SumEt: cpr_syst%i",i);
      Hist.fPhtnCprWghtM2_b[i]=new TH1F(name,title,400,-20.0,20.0);
      AddHistogram(Hist.fPhtnCprWghtM2_b[i],Folder);      
    }

  sprintf(name,"HadTDC_b");
  sprintf(title,"photon's Had TDC");
  Hist.fPhtnHadTDC_b=new TH1F(name,title,800,-100.0,100.0);
  AddHistogram(Hist.fPhtnHadTDC_b,Folder);
  sprintf(name,"NStub_b");
  sprintf(title,"number of muon stabs");
  Hist.fPhtnNStub_b=new TH1F(name,title,21,-0.5,20.5);
  AddHistogram(Hist.fPhtnNStub_b,Folder);
  sprintf(name,"NStubNoTrk_b");
  sprintf(title,"number of muon stabs with no tracks");
  Hist.fPhtnNStubNoTrk_b=new TH1F(name,title,21,-0.5,20.5);
  AddHistogram(Hist.fPhtnNStubNoTrk_b,Folder);
  sprintf(name,"NStub30cone_b");
  sprintf(title,"number of muon stabs with no tracks within 30^{o} cone");
  Hist.fPhtnNStub30cone_b=new TH1F(name,title,21,-0.5,20.5);
  AddHistogram(Hist.fPhtnNStub30cone_b,Folder);

  sprintf(name,"Nphoenix_b");
  sprintf(title,"number of Phoenix tracks associated with EM cluster");
  Hist.fPhtnNphoenix_b=new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fPhtnNphoenix_b,Folder);
  sprintf(name,"NSiHitsTrk_b");
  sprintf(title,"number of Silicon hits in associated with EM cluster Phoenix track");
  Hist.fPhtnNSiHitsTrk_b=new TH1F(name,title,29,-0.5,28.5);
  AddHistogram(Hist.fPhtnNSiHitsTrk_b,Folder);
  sprintf(name,"PhnxChi2_b");
  sprintf(title,"#chi^{2} of associated with EM cluster Phoenix track");
  Hist.fPhtnPhnxChi2_b=new TH1F(name,title,500,0.0,50.0);
  AddHistogram(Hist.fPhtnPhnxChi2_b,Folder);

  sprintf(name,"PhtnEmTime_b");
  sprintf(title,"EM Time of photon");
  Hist.fPhtnEmTime_b=new TH1F(name,title,480,-80.0,160.0);
  AddHistogram(Hist.fPhtnEmTime_b,Folder);
  sprintf(name,"PhtnEmTimeHADTdc_b");
  sprintf(title,"(EM Time)-(HADTDC time) of photon");
  Hist.fPhtnEmTimeHADTdc_b=new TH1F(name,title,480,-240.0,240.0);
  AddHistogram(Hist.fPhtnEmTimeHADTdc_b,Folder);

  //__________________________________ after cuts

  sprintf(name,"Ncand_a");
  sprintf(title," %s%s",Folder,": number of Photon candidates");
  Hist.fPhtnNcand_a= new TH1F(name,title,40,-0.5,39.5);
  AddHistogram(Hist.fPhtnNcand_a,Folder);
  sprintf(name,"Ntower_a");
  sprintf(title," %s%s",Folder,": N_tower in cluster");
  Hist.fPhtnNtower_a= new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fPhtnNtower_a,Folder);
  sprintf(name,"Detector_a");
  sprintf(title," %s%s",Folder,": Detector -- 0=CEM, 1=PEM");
  Hist.fPhtnDetector_a= new TH1F(name,title,4,-1.5,2.5);
  AddHistogram(Hist.fPhtnDetector_a,Folder);
  sprintf(name,"DelZvx_a");
  sprintf(title," %s%s",Folder,": dZ=Z_pho-Z_bestVx");
  Hist.fPhtnDelZvx_a= new TH1F(name,title,1000,-120.0,120.0);
  AddHistogram(Hist.fPhtnDelZvx_a,Folder);
  sprintf(name,"Zvx_a");
  sprintf(title," %s%s",Folder,": Z_pho");
  Hist.fPhtnZvx_a= new TH1F(name,title,1000,-120.0,120.0);
  AddHistogram(Hist.fPhtnZvx_a,Folder);
  sprintf(name,"Like_a");
  sprintf(title," %s%s",Folder,": Photon Likelihood");
  Hist.fPhtnLike_a= new TH1F(name,title,200,-10.0,10.0);
  AddHistogram(Hist.fPhtnLike_a,Folder);
  sprintf(name,"Et_raw_a");
  sprintf(title," %s%s",Folder,": raw Et(pho) w.r.t. vx & CES");
  Hist.fPhtnEt_raw_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fPhtnEt_raw_a,Folder);
  sprintf(name,"Et_twr_a");
  sprintf(title," %s%s",Folder,": tower corr. Et(pho) w.r.t. vx & CES");
  Hist.fPhtnEt_twr_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fPhtnEt_twr_a,Folder);
  sprintf(name,"E_total_a");
  sprintf(title," %s%s",Folder,": total corr. E(pho)");
  Hist.fPhtnE_total_a= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fPhtnE_total_a,Folder);
  sprintf(name,"Eta_det_a");
  sprintf(title," %s%s",Folder,": detector Eta(pho)");
  Hist.fPhtnEta_det_a= new TH1F(name,title,100,-5.0,5.0);
  AddHistogram(Hist.fPhtnEta_det_a,Folder);
  sprintf(name,"Eta_a");
  sprintf(title," %s%s",Folder,": event Eta(pho)");
  Hist.fPhtnEta_a= new TH1F(name,title,100,-5.0,5.0);
  AddHistogram(Hist.fPhtnEta_a,Folder);
  sprintf(name,"Phi_a");
  sprintf(title," %s%s",Folder,": Phi(pho)");
  Hist.fPhtnPhi_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fPhtnPhi_a,Folder);
  sprintf(name,"Theta_a");
  sprintf(title," %s%s",Folder,": event Theta(pho)");
  Hist.fPhtnTheta_a= new TH1F(name,title,800,-1.0,7.0);
  AddHistogram(Hist.fPhtnTheta_a,Folder);
  sprintf(name,"HadEm3_a");
  sprintf(title," %s%s",Folder,": Had/Em (3 towers)");
  Hist.fPhtnHadEm3_a= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fPhtnHadEm3_a,Folder);
  sprintf(name,"HadEm2_a");
  sprintf(title," %s%s",Folder,": Had/Em (2 towers)");
  Hist.fPhtnHadEm2_a= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fPhtnHadEm2_a,Folder);
  sprintf(name,"Lshr_a");
  sprintf(title," %s%s",Folder,": Lshare (3 towers)");
  Hist.fPhtnLshr_a= new TH1F(name,title,100,-5.0,5.0);
  AddHistogram(Hist.fPhtnLshr_a,Folder);
  sprintf(name,"CalIso4_raw_a");
  sprintf(title," %s%s",Folder,": raw CalIso(R=0.4)");
  Hist.fPhtnCalIso4_raw_a= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnCalIso4_raw_a,Folder);
  sprintf(name,"CalIso4_leak_a");
  sprintf(title," %s%s",Folder,": corr. for leakage CalIso(R=0.4)");
  Hist.fPhtnCalIso4_leak_a= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fPhtnCalIso4_leak_a,Folder);
  sprintf(name,"CalIso4_corr_a");
  sprintf(title," %s%s",Folder,": fully corr. (leak & Nvx12) CalIso(R=0.4)");
  Hist.fPhtnCalIso4_corr_a= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fPhtnCalIso4_corr_a,Folder);
  sprintf(name,"CalIso7_a");
  sprintf(title," %s%s",Folder,": ?raw? CalIso(R=0.7)");
  Hist.fPhtnCalIso7_a= new TH1F(name,title,210,-1.0,20.0);
  AddHistogram(Hist.fPhtnCalIso7_a,Folder);
  sprintf(name,"CalIso74_a");
  sprintf(title," %s%s",Folder,": ?raw? CalIso(R=0.7)-CalIso(R=0.4)");
  Hist.fPhtnCalIso74_a= new TH1F(name,title,300,-10.0,20.0);
  AddHistogram(Hist.fPhtnCalIso74_a,Folder);
  sprintf(name,"CalIso74over4_a");
  sprintf(title," %s%s",Folder,": ?raw? CalIso(R=0.7)/CalIso(R=0.4)-1.0");
  Hist.fPhtnCalIso74over4_a= new TH1F(name,title,1000,-25.0,25.0);
  AddHistogram(Hist.fPhtnCalIso74over4_a,Folder);
  sprintf(name,"TrkIso4_a");
  sprintf(title," %s%s",Folder,": TrkIso4(SumPt in R=0.4)");
  Hist.fPhtnTrkIso4_a= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnTrkIso4_a,Folder);
  sprintf(name,"CalTrkIso4_a");
  sprintf(title," %s%s",Folder,": CalIso4-TrkIso4");
  Hist.fPhtnCalTrkIso4_a= new TH1F(name,title,220,-10.0,10.0);
  AddHistogram(Hist.fPhtnCalTrkIso4_a,Folder);
  sprintf(name,"N3D_a");
  sprintf(title," %s%s",Folder,": N3Dtrk in cluster");
  Hist.fPhtnN3D_a= new TH1F(name,title,11,-1.5,9.5);
  AddHistogram(Hist.fPhtnN3D_a,Folder);
  sprintf(name,"Pt1st_a");
  sprintf(title," %s%s",Folder,": max Pt(trk) in cluster");
  Hist.fPhtnPt1st_a= new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fPhtnPt1st_a,Folder);
  sprintf(name,"Pt2nd_a");
  sprintf(title," %s%s",Folder,": 2nd Pt(trk) in cluster");
  Hist.fPhtnPt2nd_a= new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fPhtnPt2nd_a,Folder);
  sprintf(name,"NTrk4_a");
  sprintf(title," %s%s",Folder,": Ntrk in cone R=0.4");
  Hist.fPhtnNTrk4_a= new TH1F(name,title,21,-1.5,19.5);
  AddHistogram(Hist.fPhtnNTrk4_a,Folder);
  sprintf(name,"Ptmax4_a");
  sprintf(title," %s%s",Folder,": max Pt(trk) in cone R=0.4");
  Hist.fPhtnPtmax4_a= new TH1F(name,title,500,0.0,20.0);
  AddHistogram(Hist.fPhtnPtmax4_a,Folder);
  sprintf(name,"CesX_a");
  sprintf(title," %s%s",Folder,": CES local X");
  Hist.fPhtnCesX_a= new TH1F(name,title,600,-30.0,30.0);
  AddHistogram(Hist.fPhtnCesX_a,Folder);
  sprintf(name,"CesZ_a");
  sprintf(title," %s%s",Folder,": CES local Z");
  Hist.fPhtnCesZ_a= new TH1F(name,title,6000,-300.0,300.0);
  AddHistogram(Hist.fPhtnCesZ_a,Folder);
  sprintf(name,"Chi2_a");
  sprintf(title," %s%s",Folder,": CES(strip+wire) Chi^2");
  Hist.fPhtnChi2_a= new TH1F(name,title,500,0.0,100.0);
  AddHistogram(Hist.fPhtnChi2_a,Folder);
  sprintf(name,"CesX2_a");
  sprintf(title," %s%s",Folder,": 2nd cluster CES local X");
  Hist.fPhtnCesX2_a= new TH1F(name,title,600,-30.0,30.0);
  AddHistogram(Hist.fPhtnCesX2_a,Folder);
  sprintf(name,"CesZ2_a");
  sprintf(title," %s%s",Folder,": 2nd cluster CES local Z");
  Hist.fPhtnCesZ2_a= new TH1F(name,title,6000,-300.0,300.0);
  AddHistogram(Hist.fPhtnCesZ2_a,Folder);
  sprintf(name,"CesStripE2_a");
  sprintf(title," %s%s",Folder,": 2nd CES cluster strip Energy");
  Hist.fPhtnCesStripE2_a= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnCesStripE2_a,Folder);
  sprintf(name,"CesWireE2_a");
  sprintf(title," %s%s",Folder,": 2nd CES cluster wire Energy");
  Hist.fPhtnCesWireE2_a= new TH1F(name,title,110,-1.0,10.0);
  AddHistogram(Hist.fPhtnCesWireE2_a,Folder);

  sprintf(name,"CprX_a");
  sprintf(title," %s%s",Folder,": unbiased CPR local X");
  Hist.fPhtnCprX_a= new TH1F(name,title,240,-30.0,30.0);                    
  AddHistogram(Hist.fPhtnCprX_a,Folder);
  sprintf(name,"CprQ_a");
  sprintf(title," %s%s",Folder,": unbiased CPR charge Q");
  Hist.fPhtnCprQ_a= new TH1F(name,title,201,-5.0,10045.0);                    
  AddHistogram(Hist.fPhtnCprQ_a,Folder);
  sprintf(name,"CesCprX_a");
  sprintf(title," %s%s",Folder,": CES seeded CPR local X");
  Hist.fPhtnCesCprX_a= new TH1F(name,title,240,-30.0,30.0);                    
  AddHistogram(Hist.fPhtnCesCprX_a,Folder);
  sprintf(name,"CesCprQ_a");
  sprintf(title," %s%s",Folder,": CES seeded CPR charge Q");
  Hist.fPhtnCesCprQ_a= new TH1F(name,title,201,-5.0,10045.0);                    
  AddHistogram(Hist.fPhtnCesCprQ_a,Folder);
  sprintf(name,"CesCpr_dX_a");
  sprintf(title," %s%s",Folder,": dX= X_ces - X_cpr");
  Hist.fPhtnCesCpr_dX_a= new TH1F(name,title,480,-60.0,60.0);;               
  AddHistogram(Hist.fPhtnCesCpr_dX_a,Folder);
  sprintf(name,"2ndCesCpr_dX_a");
  sprintf(title," %s%s",Folder,": dX= X_ces(2nd cluster) - X_cpr");
  Hist.fPhtn2ndCesCpr_dX_a= new TH1F(name,title,480,-60.0,60.0);;               
  AddHistogram(Hist.fPhtn2ndCesCpr_dX_a,Folder);

  sprintf(name,"CesWght_a");
  sprintf(title," %s%s",Folder,": CES background Weight, Et(pho)<35 GeV");
  Hist.fPhtnCesWght_a= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCesWght_a,Folder);
  sprintf(name,"CprWght_a");
  sprintf(title," %s%s",Folder,": CPR background Weight");
  Hist.fPhtnCprWght_a= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCprWght_a,Folder);
  sprintf(name,"CprWghtB35_a");
  sprintf(title," %s%s",Folder,": CPR background Weight, Et(pho)<35 GeV");
  Hist.fPhtnCprWghtB35_a= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCprWghtB35_a,Folder);
  sprintf(name,"CprWghtA35_a");
  sprintf(title," %s%s",Folder,": CPR background Weight, Et(pho)>=35 GeV");
  Hist.fPhtnCprWghtA35_a= new TH1F(name,title,400,-20.0,20.0);
  AddHistogram(Hist.fPhtnCprWghtA35_a,Folder);

  sprintf(name,"CprWght_Et_a");
  sprintf(title,"CprWght vs. corr. Et(pho)");
  Hist.fPhtnCprWght_Et_a= new TProfile(name,title,100,0.0,300.0,-100.0,100.0);
  AddHistogram(Hist.fPhtnCprWght_Et_a,Folder);
  sprintf(name,"CesWght_Et_a");
  sprintf(title,"CesWght vs. corr. Et(pho)");          
  Hist.fPhtnCesWght_Et_a= new TProfile(name,title,50,0.0,50.0,-100.0,100.0);          
  AddHistogram(Hist.fPhtnCesWght_Et_a,Folder);
  sprintf(name,"CprWghtB35_Et_a");
  sprintf(title,"CprWght vs. corr. Et(pho), Et<35");          
  Hist.fPhtnCprWghtB35_Et_a= new TProfile(name,title,50,0.0,50.0,-100.0,100.0);          
  AddHistogram(Hist.fPhtnCprWghtB35_Et_a,Folder);

  for(int i=0; i<5; i++)
    {
      sprintf(name,"fPhtnCprWghtM1_a[%i]",i);
      if(i==0) sprintf(title,"CesWght using Nvx12: cpr_default");
      else sprintf(title,"CesWght using Nvx12: cpr_syst%i",i);
      Hist.fPhtnCprWghtM1_a[i]=new TH1F(name,title,400,-20.0,20.0);
      AddHistogram(Hist.fPhtnCprWghtM1_a[i],Folder);

      sprintf(name,"fPhtnCprWghtM2_a[%i]",i);
      if(i==0) sprintf(title,"CesWght using SumEt: cpr_default");
      else sprintf(title,"CesWght using SumEt: cpr_syst%i",i);
      Hist.fPhtnCprWghtM2_a[i]=new TH1F(name,title,400,-20.0,20.0);
      AddHistogram(Hist.fPhtnCprWghtM2_a[i],Folder);      
    }

  sprintf(name,"HadTDC_a");
  sprintf(title,"photon's Had TDC");
  Hist.fPhtnHadTDC_a=new TH1F(name,title,800,-100.0,100.0);
  AddHistogram(Hist.fPhtnHadTDC_a,Folder);
  sprintf(name,"NStub_a");
  sprintf(title,"number of muon stabs");
  Hist.fPhtnNStub_a=new TH1F(name,title,21,-0.5,20.5);
  AddHistogram(Hist.fPhtnNStub_a,Folder);
  sprintf(name,"NStubNoTrk_a");
  sprintf(title,"number of muon stabs with no tracks");
  Hist.fPhtnNStubNoTrk_a=new TH1F(name,title,21,-0.5,20.5);
  AddHistogram(Hist.fPhtnNStubNoTrk_a,Folder);
  sprintf(name,"NStub30cone_a");
  sprintf(title,"number of muon stabs with no tracks within 30^{o} cone");
  Hist.fPhtnNStub30cone_a=new TH1F(name,title,21,-0.5,20.5);
  AddHistogram(Hist.fPhtnNStub30cone_a,Folder);

  sprintf(name,"Nphoenix_a");
  sprintf(title,"number of Phoenix tracks associated with EM cluster");
  Hist.fPhtnNphoenix_a=new TH1F(name,title,11,-0.5,10.5);
  AddHistogram(Hist.fPhtnNphoenix_a,Folder);
  sprintf(name,"NSiHitsTrk_a");
  sprintf(title,"number of Silicon hits in associated with EM cluster Phoenix track");
  Hist.fPhtnNSiHitsTrk_a=new TH1F(name,title,29,-0.5,28.5);
  AddHistogram(Hist.fPhtnNSiHitsTrk_a,Folder);
  sprintf(name,"PhnxChi2_a");
  sprintf(title,"#chi^{2} of associated with EM cluster Phoenix track");
  Hist.fPhtnPhnxChi2_a=new TH1F(name,title,500,0.0,50.0);
  AddHistogram(Hist.fPhtnPhnxChi2_a,Folder);

  sprintf(name,"PhtnEmTime_a");
  sprintf(title,"EM Time of photon");
  Hist.fPhtnEmTime_a=new TH1F(name,title,480,-80.0,160.0);
  AddHistogram(Hist.fPhtnEmTime_a,Folder);
  sprintf(name,"PhtnEmTimeHADTdc_a");
  sprintf(title,"(EM Time)-(HADTDC time) of photon");
  Hist.fPhtnEmTimeHADTdc_a=new TH1F(name,title,480,-240.0,240.0);
  AddHistogram(Hist.fPhtnEmTimeHADTdc_a,Folder);

  return;
}


//_____________________________________________________________________________
void TMyPhotonFilterModule::BookHistograms() {
  
  TFolder* fol;
  TFolder* hist_folder;
  
  char folder_name[200];
  //-----------------------------------------------------------------------------
  //  clear the histogram list
  //-----------------------------------------------------------------------------
  DeleteHistograms();
  hist_folder = (TFolder*) GetFolder()->FindObject("Hist");
  //-----------------------------------------------------------------------------
  //  individual photon histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"Photon_1st");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookPhotonHistograms(fPhoHist[0],Form("Hist/%s",folder_name));

  sprintf(folder_name,"Photon_2nd");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookPhotonHistograms(fPhoHist[1],Form("Hist/%s",folder_name));

  sprintf(folder_name,"Photon_extra");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookPhotonHistograms(fPhoHist[2],Form("Hist/%s",folder_name));

  sprintf(folder_name,"Analysis_ggX");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookAnaHistograms(fAnaHist,Form("Hist/%s",folder_name));

//   sprintf(folder_name,"MetStudy");
//   fol = (TFolder*) hist_folder->FindObject(folder_name);
//   if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
//   BookMetStudyHistograms(fMetStudyHist,Form("Hist/%s",folder_name)); 

  sprintf(folder_name,"NoBeamHalo");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookBeamHaloStudyHistograms(fNoBeamHaloHist,Form("Hist/%s",folder_name));

  sprintf(folder_name,"WithBeamHalo");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookBeamHaloStudyHistograms(fWithBeamHaloHist,Form("Hist/%s",folder_name));

  sprintf(folder_name,"EmTiming");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookTimingHistograms(fTimingHisto,Form("Hist/%s",folder_name));

  return;
}

void TMyPhotonFilterModule::BookAnaHistograms(AnalysisHisto_t& Hist, const char* Folder) {

  char name [200];
  char title[200];

  sprintf(name,"Mgg");
  sprintf(title,"di-photon mass, M_{#gamma#gamma}");          
  Hist.fAnaMgg= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fAnaMgg,Folder);
  sprintf(name,"DeltaPhi");
  sprintf(title,"#Delta#phi_{#gamma#gamma}=#phi_{#gamma,1}-#phi_{#gamma,2}");          
  Hist.fAnaDeltaPhi= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fAnaDeltaPhi,Folder);
  sprintf(name,"DeltaEta");
  sprintf(title,"#Delta#eta_{#gamma#gamma}=#eta_{#gamma,1}-#eta_{#gamma,2}");          
  Hist.fAnaDeltaEta= new TH1F(name,title,300,-3.0,3.0);          
  AddHistogram(Hist.fAnaDeltaEta,Folder);
  sprintf(name,"DeltaR");
  sprintf(title,"#Delta R_{#gamma#gamma}=#sqrt{(#eta_{#gamma,1}-#eta_{#gamma,2})^{2}+(#phi_{#gamma,1}-#phi_{#gamma,2})^{2}}");  
  Hist.fAnaDeltaR= new TH1F(name,title,600,0.0,6.0);          
  AddHistogram(Hist.fAnaDeltaR,Folder);
  sprintf(name,"Qt");
  sprintf(title,"di-photon momentum, Q_{T}");          
  Hist.fAnaQt= new TH1F(name,title,1000,0.0,1000.0);          
  AddHistogram(Hist.fAnaQt,Folder);
  sprintf(name,"Eta");
  sprintf(title,"#eta of di-photon system");
  Hist.fAnaEta= new TH1F(name,title,400,-10.0,10.0);
  AddHistogram(Hist.fAnaEta,Folder);
  sprintf(name,"ThetaS");
  sprintf(title,"di-pho scattering angle, #theta_{s}");          
  Hist.fAnaThetaS= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fAnaThetaS,Folder);
  sprintf(name,"Et1");
  sprintf(title,"E_{T} of 1^{st} photon");          
  Hist.fAnaEt1= new TH1F(name,title,1000,0.0,1000.0);          
  AddHistogram(Hist.fAnaEt1,Folder);
  sprintf(name,"Et2");
  sprintf(title,"E_{T} of 2^{nd} photon");          
  Hist.fAnaEt2= new TH1F(name,title,1000,0.0,1000.0);          
  AddHistogram(Hist.fAnaEt2,Folder);
  sprintf(name,"EtE");
  sprintf(title,"E_{T} of extra photon");          
  Hist.fAnaEtE= new TH1F(name,title,1000,0.0,1000.0);          
  AddHistogram(Hist.fAnaEtE,Folder);
  sprintf(name,"Npho");
  sprintf(title,"Number of photons");          
  Hist.fAnaNpho= new TH1F(name,title,10,-0.5,9.5);          
  AddHistogram(Hist.fAnaNpho,Folder);

  sprintf(name,"Met4");
  sprintf(title,"MEt_4");
  Hist.fAnaMet4=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAnaMet4,Folder);
  sprintf(name,"MetX4");
  sprintf(title,"MEt_4, x-projection");
  Hist.fAnaMetX4=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fAnaMetX4,Folder);
  sprintf(name,"MetY4");
  sprintf(title,"MEt_4, y-projection");
  Hist.fAnaMetY4=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fAnaMetY4,Folder);
  sprintf(name,"MetPhi4");
  sprintf(title,"#phi of MEt_4");
  Hist.fAnaMetPhi4=new TH1F(name,title,140,-0.5,6.5);
  AddHistogram(Hist.fAnaMetPhi4,Folder);
  sprintf(name,"CorrSumEt");
  sprintf(title,"corrected #sum E_{T}=#sum E_{T}-E_{T,1}-E_{T,2}-...");
  Hist.fAnaCorrSumEt=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fAnaCorrSumEt,Folder);
  sprintf(name,"SqrtCorrSumEt");
  sprintf(title,"#sqrt{#sum E_{T}^{corr.}=#sum E_{T}-E_{T,1}-E_{T,2}-...}");
  Hist.fAnaSqrtCorrSumEt=new TH1F(name,title,45,0.0,45.0);
  AddHistogram(Hist.fAnaSqrtCorrSumEt,Folder);
  sprintf(name,"Ht");
  sprintf(title,"H_{T}=ME_{T}+E_{T,1}+E_{T,2}+...");
  Hist.fAnaHt=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fAnaHt,Folder);
  sprintf(name,"DelPhiM1");
  sprintf(title,"#Delta#phi_{ME_{T},#gamma 1}=#phi_{ME_{T}}-#phi_{#gamma,1}");          
  Hist.fAnaDelPhiM1= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fAnaDelPhiM1,Folder);
  sprintf(name,"DelPhiM2");
  sprintf(title,"#Delta#phi_{ME_{T},#gamma 2}=#phi_{ME_{T}}-#phi_{#gamma,2}");          
  Hist.fAnaDelPhiM2= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fAnaDelPhiM2,Folder);
  sprintf(name,"DelPhiMDi");
  sprintf(title,"#Delta#phi_{ME_{T},#gamma#gamma}=#phi_{ME_{T}}-#phi_{#gamma#gamma}");          
  Hist.fAnaDelPhiMDi= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fAnaDelPhiMDi,Folder);

  sprintf(name,"Met4vsZvx");
  sprintf(title,"MEt_4 vs z_{vx}");
  Hist.fAnaMet4vsZvx=new TProfile(name,title,24,-60.0,60.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsZvx,Folder);
  sprintf(name,"Met4vsNvx12");
  sprintf(title,"MEt_4 vs N_{vx12}");
  Hist.fAnaMet4vsNvx12=new TProfile(name,title,10,-0.5,9.5,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsNvx12,Folder);
  sprintf(name,"Met4vsLum");
  sprintf(title,"MEt_4 vs Lum");
  Hist.fAnaMet4vsLum=new TProfile(name,title,40,0.0,200.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsLum,Folder);
  sprintf(name,"Met4vsMetPhi4");
  sprintf(title,"MEt_4 vs #phi of MEt_4");
  Hist.fAnaMet4vsMetPhi4=new TProfile(name,title,70,-0.5,6.5,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsMetPhi4,Folder);
  sprintf(name,"Met4vsMgg");
  sprintf(title,"MEt_4 vs M_{#gamma#gamma}");
  Hist.fAnaMet4vsMgg=new TProfile(name,title,400,0.0,2000.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsMgg,Folder);
  sprintf(name,"DelPhivsMgg");
  sprintf(title,"#Delta#phi_{#gamma#gamma} vs M_{#gamma#gamma}");
  Hist.fAnaDelPhivsMgg=new TProfile(name,title,400,0.0,2000.0,-1.0,4.0);
  AddHistogram(Hist.fAnaDelPhivsMgg,Folder);
  sprintf(name,"Met4vsQt");
  sprintf(title,"MEt_4 vs Q_{T}");
  Hist.fAnaMet4vsQt=new TProfile(name,title,500,0.0,1000.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsQt,Folder);
  sprintf(name,"MggVsMet4");
  sprintf(title,"M_{#gamma#gamma} vs MEt_4");
  Hist.fAnaMggVsMet4=new TProfile(name,title,200,0.0,1000.0,-1.0,2000.0);
  AddHistogram(Hist.fAnaMggVsMet4,Folder);
  sprintf(name,"QtVsMet4");
  sprintf(title,"Q_{T} vs MEt_4");
  Hist.fAnaQtVsMet4=new TProfile(name,title,200,0.0,1000.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaQtVsMet4,Folder);

  sprintf(name,"Met4vsDPhi");
  sprintf(title,"MEt_4 vs di-photon #phi");
  Hist.fAnaMet4vsDPhi=new TProfile(name,title,32,0.0,3.2,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsDPhi,Folder);
  sprintf(name,"HtvsDPhi");
  sprintf(title,"H_{T} vs di-photon #phi");
  Hist.fAnaHtvsDPhi=new TProfile(name,title,32,0.0,3.2,-1.0,1000.0);
  AddHistogram(Hist.fAnaHtvsDPhi,Folder);
  sprintf(name,"MggvsDPhi");
  sprintf(title,"M_{#gamma#gamma} vs di-photon #phi");
  Hist.fAnaMggvsDPhi=new TProfile(name,title,32,0.0,3.2,-1.0,2000.0);
  AddHistogram(Hist.fAnaMggvsDPhi,Folder);

  sprintf(name,"Met4vsDPhi1");
  sprintf(title,"MEt_4 vs #Delta#phi_{1}=#phi_{met}-#phi_{#gamma,1}");
  Hist.fAnaMet4vsDPhi1=new TProfile(name,title,32,0.0,3.2,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsDPhi1,Folder);
  sprintf(name,"Met4vsDPhi2");
  sprintf(title,"MEt_4 vs #Delta#phi_{2}=#phi_{met}-#phi_{#gamma,2}");
  Hist.fAnaMet4vsDPhi2=new TProfile(name,title,32,0.0,3.2,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4vsDPhi2,Folder);

  sprintf(name,"MggVsDelR");
  sprintf(title,"M_{#gamma#gamma} vs. #Delta R_{#gamma#gamma} ");
  Hist.fAnaMggVsDelR=new TProfile(name,title,40,0.0,4.0,-1.0,2000.0);
  AddHistogram(Hist.fAnaMggVsDelR,Folder);
  sprintf(name,"Met4VsDelR");
  sprintf(title,"MEt_4 vs. #Delta R_{#gamma#gamma} ");
  Hist.fAnaMet4VsDelR=new TProfile(name,title,40,0.0,4.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4VsDelR,Folder);
  sprintf(name,"HtVsDelR");
  sprintf(title,"H_{T} vs. #Delta R_{#gamma#gamma} ");
  Hist.fAnaHtVsDelR=new TProfile(name,title,40,0.0,4.0,-1.0,2000.0);
  AddHistogram(Hist.fAnaHtVsDelR,Folder);
  sprintf(name,"QtVsDelR");
  sprintf(title,"Q_{T} vs. #Delta R_{#gamma#gamma} ");
  Hist.fAnaQtVsDelR=new TProfile(name,title,40,0.0,4.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaQtVsDelR,Folder);

  sprintf(name,"Met4VsCorrSumEt");
  sprintf(title,"MEt_4 vs #sum E_{T}^{corr}");
  Hist.fAnaMet4VsCorrSumEt=new TProfile(name,title,200,0.0,1000.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4VsCorrSumEt,Folder);
  sprintf(name,"Met4VsSqrtCorrSumEt");
  sprintf(title,"MEt_4 vs #sqrt{#sum E_{T}^{corr}}");
  Hist.fAnaMet4VsSqrtCorrSumEt=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fAnaMet4VsSqrtCorrSumEt,Folder);
  sprintf(name,"Met4CorrSumEt");
  sprintf(title,"scatter plot: MEt_4 vs #sum E_{T}^{corr}");
  Hist.fAnaMet4CorrSumEt=new TH2F(name,title,100,0.0,500.0,50,0.0,200.0);
  AddHistogram(Hist.fAnaMet4CorrSumEt,Folder);
  sprintf(name,"Met4SqrtCorrSumEt");
  sprintf(title,"scatter plot: MEt_4 vs #sqrt{#sum E_{T}^{corr}}");
  Hist.fAnaMet4SqrtCorrSumEt=new TH2F(name,title,22,0.0,44.0,50,0.0,200.0);
  AddHistogram(Hist.fAnaMet4SqrtCorrSumEt,Folder);

  return;
}

void TMyPhotonFilterModule::BookMetStudyHistograms(MetStudyHisto_t& Hist, const char* Folder) {

  char name [200];
  char title[200];
  sprintf(name,"Met4VsSqrtCorrSumEt_nvx1");
  sprintf(title,"MEt_4 vs #sqrt{#sum E_{T}^{corr}} for N_{vx12}=1");
  Hist.fMet4VsSqrtCorrSumEt_nvx1=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsSqrtCorrSumEt_nvx1,Folder);
  sprintf(name,"Met4VsSqrtCorrSumEt_nvx2");
  sprintf(title,"MEt_4 vs #sqrt{#sum E_{T}^{corr}} for N_{vx12}=2");
  Hist.fMet4VsSqrtCorrSumEt_nvx2=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsSqrtCorrSumEt_nvx2,Folder);
  sprintf(name,"Met4VsSqrtCorrSumEt_nvx3");
  sprintf(title,"MEt_4 vs #sqrt{#sum E_{T}^{corr}} for N_{vx12}=3");
  Hist.fMet4VsSqrtCorrSumEt_nvx3=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsSqrtCorrSumEt_nvx3,Folder);
  sprintf(name,"Met4VsSqrtCorrSumEt_nvx4");
  sprintf(title,"MEt_4 vs #sqrt{#sum E_{T}^{corr}} for N_{vx12}=4");
  Hist.fMet4VsSqrtCorrSumEt_nvx4=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsSqrtCorrSumEt_nvx4,Folder);
  sprintf(name,"Met4VsSqrtCorrSumEt_nvx5");
  sprintf(title,"MEt_4 vs #sqrt{#sum E_{T}^{corr}} for N_{vx12}=5");
  Hist.fMet4VsSqrtCorrSumEt_nvx5=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsSqrtCorrSumEt_nvx5,Folder);

  for(int i=0; i<10; i++)
    {
      //---- any number of vertices
      sprintf(name,"Met4X[%i]",i);
      sprintf(title,"meth4 MEtX, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4X[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4X[i],Folder);
      sprintf(name,"Met4Y[%i]",i);
      sprintf(title,"meth4 MEtY, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4Y[i],Folder);
      //---- nvx12=1
      sprintf(name,"Met4X_nvx1[%i]",i);
      sprintf(title,"meth4 MEtX for N_{vx12}=1, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_nvx1[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4X_nvx1[i],Folder);
      sprintf(name,"Met4Y_nvx1[%i]",i);
      sprintf(title,"meth4 MEtY for N_{vx12}=1, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_nvx1[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4Y_nvx1[i],Folder);
      //---- nvx12=2
      sprintf(name,"Met4X_nvx2[%i]",i);
      sprintf(title,"meth4 MEtX for N_{vx12}=2, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_nvx2[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4X_nvx2[i],Folder);
      sprintf(name,"Met4Y_nvx2[%i]",i);
      sprintf(title,"meth4 MEtY for N_{vx12}=2, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_nvx2[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4Y_nvx2[i],Folder);
      //---- nvx12=3
      sprintf(name,"Met4X_nvx3[%i]",i);
      sprintf(title,"meth4 MEtX for N_{vx12}=3, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_nvx3[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4X_nvx3[i],Folder);
      sprintf(name,"Met4Y_nvx3[%i]",i);
      sprintf(title,"meth4 MEtY for N_{vx12}=3, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_nvx3[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4Y_nvx3[i],Folder);
      //---- nvx12=4
      sprintf(name,"Met4X_nvx4[%i]",i);
      sprintf(title,"meth4 MEtX for N_{vx12}=4, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_nvx4[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4X_nvx4[i],Folder);
      sprintf(name,"Met4Y_nvx4[%i]",i);
      sprintf(title,"meth4 MEtY for N_{vx12}=4, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_nvx4[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4Y_nvx4[i],Folder);
      //---- nvx12=5
      sprintf(name,"Met4X_nvx5[%i]",i);
      sprintf(title,"meth4 MEtX for N_{vx12}=5, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_nvx5[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4X_nvx5[i],Folder);
      sprintf(name,"Met4Y_nvx5[%i]",i);
      sprintf(title,"meth4 MEtY for N_{vx12}=5, %i<#sqrt{#sum E_{T}^{corr}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_nvx5[i]=new TH1F(name,title,200,-100.0,100.0);
      AddHistogram(Hist.fMet4Y_nvx5[i],Folder);
    }

  return;
}


void TMyPhotonFilterModule::BookBeamHaloStudyHistograms(BeamHaloStudyHisto_t& Hist, const char* Folder) {

  char name [200];
  char title[200];

  sprintf(name,"HaloSeedWedgeEM_SeedWedgeHAD");
  sprintf(title,"N_{EMtwr} vs. N_{HADtwr} in seed wedge");
  Hist.fHaloSeedWedgeEM_SeedWedgeHAD=new TH2F(name,title,25,-0.5,24.5,25,-0.5,24.5);
  AddHistogram(Hist.fHaloSeedWedgeEM_SeedWedgeHAD,Folder);

  sprintf(name,"HaloEventStatus");
  sprintf(title,"Number of Beam Halo candidates per event");
  Hist.fHaloEventStatus=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fHaloEventStatus,Folder);
  sprintf(name,"HaloSeedWedge");
  sprintf(title,"number of EM towers in seed wedge, Max's version");
  Hist.fHaloSeedWedge=new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fHaloSeedWedge,Folder);
  sprintf(name,"HaloSideWedge");
  sprintf(title,"number of EM towers in side wedges, Max's version");
  Hist.fHaloSideWedge=new TH1F(name,title,45,-0.5,44.5);
  AddHistogram(Hist.fHaloSideWedge,Folder);
  sprintf(name,"HaloSeedWedgeH");
  sprintf(title,"number of HAD towers in seed wedge, my version");
  Hist.fHaloSeedWedgeH=new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fHaloSeedWedgeH,Folder);
  sprintf(name,"HaloSideWedgeH");
  sprintf(title,"number of HAD towers in side wedges, my version");
  Hist.fHaloSideWedgeH=new TH1F(name,title,45,-0.5,44.5);
  AddHistogram(Hist.fHaloSideWedgeH,Folder);
  sprintf(name,"HaloEastNHad");
  sprintf(title,"number of HAD towers on East side");
  Hist.fHaloEastNHad=new TH1F(name,title,35,-0.5,34.5);
  AddHistogram(Hist.fHaloEastNHad,Folder);
  sprintf(name,"HaloWestNHad");
  sprintf(title,"number of HAD towers on West side");
  Hist.fHaloWestNHad=new TH1F(name,title,35,-0.5,34.5);
  AddHistogram(Hist.fHaloWestNHad,Folder);
  sprintf(name,"HaloNHad");
  sprintf(title,"number of HAD towers on East+West");
  Hist.fHaloNHad=new TH1F(name,title,70,-0.5,69.5);
  AddHistogram(Hist.fHaloNHad,Folder);
  sprintf(name,"HaloEmSeedE");
  sprintf(title,"EM energy of seed wedge towers");
  Hist.fHaloEmSeedE=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fHaloEmSeedE,Folder);
  sprintf(name,"HaloEmSideE");
  sprintf(title,"EM energy of side wedge towers");
  Hist.fHaloEmSideE=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fHaloEmSideE,Folder);
  sprintf(name,"HaloHadSeedE");
  sprintf(title,"Plug HAD energy of seed wedge towers");
  Hist.fHaloHadSeedE=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fHaloHadSeedE,Folder);
  sprintf(name,"HaloSeedWedgeHadE");
  sprintf(title,"HAD energy of seed wedge towers");
  Hist.fHaloSeedWedgeHadE=new TH1F(name,title,5000,0.0,100.0);
  AddHistogram(Hist.fHaloSeedWedgeHadE,Folder);
  sprintf(name,"HaloEast");
  sprintf(title,"HaloEast");
  Hist.fHaloEast=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fHaloEast,Folder);
  sprintf(name,"HaloWest");
  sprintf(title,"HaloWest");
  Hist.fHaloWest=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fHaloWest,Folder);
  sprintf(name,"HaloEastWest");
  sprintf(title,"HaloWest+HaloEast");
  Hist.fHaloEastWest=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fHaloEastWest,Folder);
  sprintf(name,"HaloSeedWedgeR");
  sprintf(title,"number of towers in seed wedge, Ray's version");
  Hist.fHaloSeedWedgeR=new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fHaloSeedWedgeR,Folder);
  sprintf(name,"HaloSideWedgeR");
  sprintf(title,"number of towers in side wedges, Ray's version");
  Hist.fHaloSideWedgeR=new TH1F(name,title,45,-0.5,44.5);
  AddHistogram(Hist.fHaloSideWedgeR,Folder);
  sprintf(name,"HaloTwrInRawR");
  sprintf(title,"number of continues towers in seed wedge, Ray's version");
  Hist.fHaloTwrInRawR=new TH1F(name,title,25,-0.5,24.5);
  AddHistogram(Hist.fHaloTwrInRawR,Folder);

  sprintf(name,"HaloCesStripEoverE");
  sprintf(title,"strip energy E_{CES}/E_{#gamma}");
  Hist.fHaloCesStripEoverE=new TH1F(name,title,500,0.0,5.0);
  AddHistogram(Hist.fHaloCesStripEoverE,Folder);
  sprintf(name,"HaloCesWireEoverE");
  sprintf(title,"wire energy E_{CES}/E_{#gamma}");
  Hist.fHaloCesWireEoverE=new TH1F(name,title,500,0.0,5.0);
  AddHistogram(Hist.fHaloCesWireEoverE,Folder);
  sprintf(name,"HaloHadTDC");
  sprintf(title,"photons Had TDC");
  Hist.fHaloHadTDC=new TH1F(name,title,800,-100.0,100.0);
  AddHistogram(Hist.fHaloHadTDC,Folder);

  sprintf(name,"HaloPhiWedge");
  sprintf(title,"wedge number of halo candidate");
  Hist.fHaloPhiWedge=new TH1F(name,title,24,-0.5,23.5);
  AddHistogram(Hist.fHaloPhiWedge,Folder);
  sprintf(name,"HaloEta");
  sprintf(title,"#eta of halo candidate");
  Hist.fHaloEta=new TH1F(name,title,120,-3.0,3.0);
  AddHistogram(Hist.fHaloEta,Folder);
  sprintf(name,"HaloIso");
  sprintf(title," CalIso of halo candidate");
  Hist.fHaloIso= new TH1F(name,title,140,-4.0,10.0);
  AddHistogram(Hist.fHaloIso,Folder);
  sprintf(name,"HaloHadEm");
  sprintf(title,"Had/Em of halo candidate");
  Hist.fHaloHadEm= new TH1F(name,title,400,-0.5,1.5);
  AddHistogram(Hist.fHaloHadEm,Folder);
  sprintf(name,"HaloCesChi2");
  sprintf(title," %s%s",Folder,": CES(strip+wire) #chi^{2} of halo candidate");
  Hist.fHaloCesChi2= new TH1F(name,title,500,0.0,100.0);
  AddHistogram(Hist.fHaloCesChi2,Folder);
  sprintf(name,"HaloEt");
  sprintf(title," corrected E_{T} of halo candidate");
  Hist.fHaloEt= new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fHaloEt,Folder);

  return;
}

void TMyPhotonFilterModule::BookTimingHistograms(EmTimingHisto_t& Hist, const char* Folder) {
  char name [200];
  char title[200];

  sprintf(name,"EmtTime1vsTime2");
  sprintf(title,"Time1 vs. Time2");
  Hist.fEmtTime1vsTime2=new TH2F(name,title,120,-80.0,160.0,120,-80.0,160.0);
  AddHistogram(Hist.fEmtTime1vsTime2,Folder);
  sprintf(name,"EmtDelTvsDelPhi");
  sprintf(title,"#DeltaT vs. sin(#Delta#phi_{#gamma#gamma}/2)");
  Hist.fEmtDelTvsDelPhi=new TH2F(name,title,20,0.0,1.0,120,0.0,30.0);
  AddHistogram(Hist.fEmtDelTvsDelPhi,Folder);
  sprintf(name,"EmtTimePho1");
  sprintf(title,"Time of 1^{st} photon");
  Hist.fEmtTimePho1=new TH1F(name,title,480,-80.0,160.0);
  AddHistogram(Hist.fEmtTimePho1,Folder);
  sprintf(name,"EmtTimePho2");
  sprintf(title,"Time of 2^{nd} photon");
  Hist.fEmtTimePho2=new TH1F(name,title,480,-80.0,160.0);
  AddHistogram(Hist.fEmtTimePho2,Folder);
  sprintf(name,"EmtDelTime");
  sprintf(title,"#DeltaT=T_{#gamma_{1}}-T_{#gamma_{2}}");
  Hist.fEmtDelTime=new TH1F(name,title,1000,-50.0,50.0);
  AddHistogram(Hist.fEmtDelTime,Folder);
  sprintf(name,"EmtNhitsTot[0]");
  sprintf(title,"Number of timing hits for 1^{st} photon");
  Hist.fEmtNhitsTot[0]=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fEmtNhitsTot[0],Folder);
  sprintf(name,"EmtNhitsTot[1]");
  sprintf(title,"Number of timing hits for 2^{nd} photon");
  Hist.fEmtNhitsTot[1]=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fEmtNhitsTot[1],Folder);

  return;
}


void TMyPhotonFilterModule::FillAnaHistograms(AnalysisHisto_t& Hist, double zvx, int nvx) {

  if(myCorrPho.size()>1)
    {
      Hist.fAnaMgg->Fill(GetMyDiPhoMass(myCorrPho)); 
      Hist.fAnaDeltaPhi->Fill(fabs(TVector2::Phi_mpi_pi(myCorrPho[0].DeltaPhi(myCorrPho[1])))); 
      Hist.fAnaDeltaEta->Fill(myCorrPho[0].Eta()-myCorrPho[1].Eta());
      Hist.fAnaDeltaR->Fill(myCorrPho[0].DeltaR(myCorrPho[1])); 
      Hist.fAnaQt->Fill(GetMyQt(myCorrPho));
      Hist.fAnaEta->Fill((myCorrPho[0]+myCorrPho[1]).Eta());
      Hist.fAnaThetaS->Fill(GetThetaStar(myCorrPho)); 
      Hist.fAnaEt1->Fill(myCorrPho[0].Pt());
      Hist.fAnaEt2->Fill(myCorrPho[1].Pt());
      for(int i=2; i<myCorrPho.size(); i++) { Hist.fAnaEtE->Fill(myCorrPho[i].Pt()); } 
      Hist.fAnaNpho->Fill(myNpho);
      
      TMyEventFilterModule* MyEventInfo=
	(TMyEventFilterModule*) ((TStnAna*) GetAna()->GetModule("MyEventFilter")); 
      
      Hist.fAnaMet4->Fill(MyEventInfo->GetMet(4));
      Hist.fAnaMetPhi4->Fill(MyEventInfo->GetMetPhi(4));
      Hist.fAnaMetX4->Fill(MyEventInfo->GetMetX(4));
      Hist.fAnaMetY4->Fill(MyEventInfo->GetMetY(4)); 
      Hist.fAnaCorrSumEt->Fill(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2)));
      Hist.fAnaSqrtCorrSumEt->Fill(sqrt(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2))));
      Hist.fAnaHt->Fill(GetMyHt(myCorrPho,MyEventInfo->GetMet(4)));
      Hist.fAnaDelPhiM1->Fill(fabs(TVector2::Phi_mpi_pi(MyEventInfo->GetMetPhi(4)-
							myCorrPho[0].Phi())));
      Hist.fAnaDelPhiM2->Fill(fabs(TVector2::Phi_mpi_pi(MyEventInfo->GetMetPhi(4)-
							myCorrPho[1].Phi()))); 
      Hist.fAnaDelPhiMDi->Fill(fabs(TVector2::Phi_mpi_pi(MyEventInfo->GetMetPhi(4)-
							 GetMyQtPhi(myCorrPho))));
      
      Hist.fAnaMet4vsZvx->Fill(zvx,MyEventInfo->GetMet(4));
      Hist.fAnaMet4vsNvx12->Fill(nvx,MyEventInfo->GetMet(4));
      Hist.fAnaMet4vsLum->Fill((GetHeaderBlock()->InstLum())*1.0E-30,MyEventInfo->GetMet(4));
      Hist.fAnaMet4vsMetPhi4->Fill(MyEventInfo->GetMetPhi(4),MyEventInfo->GetMet(4));
      Hist.fAnaMet4vsMgg->Fill(GetMyDiPhoMass(myCorrPho),MyEventInfo->GetMet(4));
      Hist.fAnaDelPhivsMgg->Fill(GetMyDiPhoMass(myCorrPho),fabs(TVector2::Phi_mpi_pi(myCorrPho[0].DeltaPhi(myCorrPho[1]))));
      Hist.fAnaMet4vsQt->Fill(GetMyQt(myCorrPho),MyEventInfo->GetMet(4));
      Hist.fAnaMet4vsDPhi->Fill(fabs(TVector2::Phi_mpi_pi(myCorrPho[0].DeltaPhi(myCorrPho[1]))),
				MyEventInfo->GetMet(4));
      
      Hist.fAnaHtvsDPhi->Fill(fabs(TVector2::Phi_mpi_pi(myCorrPho[0].DeltaPhi(myCorrPho[1]))),
			      GetMyHt(myCorrPho,MyEventInfo->GetMet(4)));
      Hist.fAnaMggvsDPhi->Fill(fabs(TVector2::Phi_mpi_pi(myCorrPho[0].DeltaPhi(myCorrPho[1]))),
			       GetMyDiPhoMass(myCorrPho));
      Hist.fAnaMggVsMet4->Fill(MyEventInfo->GetMet(4),GetMyDiPhoMass(myCorrPho));
      Hist.fAnaQtVsMet4->Fill(MyEventInfo->GetMet(4),GetMyQt(myCorrPho));
      Hist.fAnaMet4vsDPhi1->Fill(fabs(TVector2::Phi_mpi_pi(MyEventInfo->GetMetPhi(4)-
							   myCorrPho[0].Phi())),MyEventInfo->GetMet(4)); 
      Hist.fAnaMet4vsDPhi2->Fill(fabs(TVector2::Phi_mpi_pi(MyEventInfo->GetMetPhi(4)-
							   myCorrPho[1].Phi())),MyEventInfo->GetMet(4)); 
      Hist.fAnaMggVsDelR->Fill(myCorrPho[0].DeltaR(myCorrPho[1]),GetMyDiPhoMass(myCorrPho));
      Hist.fAnaMet4VsDelR->Fill(myCorrPho[0].DeltaR(myCorrPho[1]),MyEventInfo->GetMet(4)); 
      Hist.fAnaHtVsDelR->Fill(myCorrPho[0].DeltaR(myCorrPho[1]),GetMyHt(myCorrPho,MyEventInfo->GetMet(4)));
      Hist.fAnaQtVsDelR->Fill(myCorrPho[0].DeltaR(myCorrPho[1]),GetMyQt(myCorrPho));
      
      Hist.fAnaMet4VsCorrSumEt->Fill(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2)),MyEventInfo->GetMet(4));
      Hist.fAnaMet4VsSqrtCorrSumEt->Fill(sqrt(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2))),MyEventInfo->GetMet(4));
      Hist.fAnaMet4CorrSumEt->Fill(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2)),MyEventInfo->GetMet(4));
      Hist.fAnaMet4SqrtCorrSumEt->Fill(sqrt(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2))),MyEventInfo->GetMet(4));
    }
  return;
}

void TMyPhotonFilterModule::FillMetStudyHistograms(MetStudyHisto_t& Hist, int nvx) {

  TMyEventFilterModule* MyEventInfo=
    (TMyEventFilterModule*) ((TStnAna*) GetAna()->GetModule("MyEventFilter")); 
 
  double sqrtSumEt=sqrt(GetMyCorrSumEt(myCorrPho,MyEventInfo->GetSumEt(2)));
  double met=MyEventInfo->GetMet(4);
  double metx=MyEventInfo->GetMetX(4);
  double mety=MyEventInfo->GetMetY(4);

  if(nvx==1) Hist.fMet4VsSqrtCorrSumEt_nvx1->Fill(sqrtSumEt,met);  
  if(nvx==2) Hist.fMet4VsSqrtCorrSumEt_nvx2->Fill(sqrtSumEt,met);  
  if(nvx==3) Hist.fMet4VsSqrtCorrSumEt_nvx3->Fill(sqrtSumEt,met);  
  if(nvx==4) Hist.fMet4VsSqrtCorrSumEt_nvx4->Fill(sqrtSumEt,met);  
  if(nvx==5) Hist.fMet4VsSqrtCorrSumEt_nvx5->Fill(sqrtSumEt,met);  

  for(int i=0; i<10; i++)
    {
      if(sqrtSumEt>i*2.0 && sqrtSumEt<=(i+1)*2.0)
	{
	  Hist.fMet4X[i]->Fill(metx);
	  Hist.fMet4Y[i]->Fill(mety);	  
	  if(nvx==1)
	    {
	      Hist.fMet4X_nvx1[i]->Fill(metx);
	      Hist.fMet4Y_nvx1[i]->Fill(mety);
	      break;
	    }
	  if(nvx==2)
	    {
	      Hist.fMet4X_nvx2[i]->Fill(metx);
	      Hist.fMet4Y_nvx2[i]->Fill(mety);
	      break;
	    }
	  if(nvx==3)
	    {
	      Hist.fMet4X_nvx3[i]->Fill(metx);
	      Hist.fMet4Y_nvx3[i]->Fill(mety);
	      break;
	    }
	  if(nvx==4)
	    {
	      Hist.fMet4X_nvx4[i]->Fill(metx);
	      Hist.fMet4Y_nvx4[i]->Fill(mety);
	      break;
	    }
	  if(nvx==5)
	    {
	      Hist.fMet4X_nvx5[i]->Fill(metx);
	      Hist.fMet4Y_nvx5[i]->Fill(mety);
	      break;
	    }
	  break; // just in case if nvx>5
	}
    }
  return;
}

//_____________________________ Filling beam halo histograms 
void  TMyPhotonFilterModule::FillBeamHaloStudyHistograms(BeamHaloStudyHisto_t& Hist, 
							 HaloStuff *beamhalo, TStnPhoton* Pho) {

  Hist.fHaloSeedWedgeEM_SeedWedgeHAD->Fill(beamhalo->seedwedgeH,beamhalo->seedwedge);
    //______________________ Max's params
  Hist.fHaloSeedWedgeH->Fill(beamhalo->seedwedgeH);   
  Hist.fHaloSideWedgeH->Fill(beamhalo->sidewedgeH); 
  Hist.fHaloSeedWedge->Fill(beamhalo->seedwedge);   
  Hist.fHaloSideWedge->Fill(beamhalo->sidewedge); 
  Hist.fHaloEastNHad->Fill(beamhalo->eastNhad);
  Hist.fHaloWestNHad->Fill(beamhalo->westNhad);
  Hist.fHaloEmSeedE->Fill(beamhalo->emseedE);  
  Hist.fHaloEmSideE->Fill(beamhalo->emsideE);   
  Hist.fHaloHadSeedE->Fill(beamhalo->hadseedE); 
  Hist.fHaloSeedWedgeHadE->Fill(beamhalo->seedwedgeHadE);
  Hist.fHaloNHad->Fill(beamhalo->eastNhad+beamhalo->westNhad);  
    //______________________ Ray's params
  Hist.fHaloEast->Fill(Pho->HaloEast()); 
  Hist.fHaloWest->Fill(Pho->HaloWest());
  Hist.fHaloEastWest->Fill(Pho->HaloWest()+Pho->HaloEast());
  Hist.fHaloCesStripEoverE->Fill(Pho->CesStripE()/Pho->Momentum()->E());
  Hist.fHaloCesWireEoverE->Fill(Pho->CesWireE()/Pho->Momentum()->E()); 
  Hist.fHaloHadTDC->Fill(Pho->Time());     
  Hist.fHaloSideWedgeR->Fill(Pho->Seedwedge()); 
  Hist.fHaloSeedWedgeR->Fill(Pho->Sidewedges()); 
  Hist.fHaloTwrInRawR->Fill(Pho->Ncontig());  

  Hist.fHaloPhiWedge->Fill(Pho->PhiSeedIndex()); 
  Hist.fHaloEta->Fill(Pho->Eta());    
  Hist.fHaloIso->Fill(Pho->EIso4(2));    
  Hist.fHaloHadEm->Fill(Pho->HadEm());
  Hist.fHaloCesChi2->Fill(Pho->Chi2()); 
  Hist.fHaloEt->Fill(Pho->Etc());
   
  return;
}

//_____________________________ Filling photon histograms before cuts
void TMyPhotonFilterModule::FillPhotonHistogramsB(PhotonGeneral_t& Hist, TStnPhoton* Pho, double zvx, int pho_ind) {

  Hist.fPhtnNtower_b->Fill(Pho->NTower());                 
  Hist.fPhtnDetector_b->Fill(Pho->Detector());          
  Hist.fPhtnDelZvx_b->Fill((Pho->VertexZ())-zvx);               
  Hist.fPhtnZvx_b->Fill(Pho->VertexZ());                   
  Hist.fPhtnLike_b->Fill(Pho->Likelihood());                   
  Hist.fPhtnEt_raw_b->Fill(Pho->Et());                 
  Hist.fPhtnEt_twr_b->Fill(Pho->Etc());                 
  Hist.fPhtnE_total_b->Fill(Pho->Momentum()->E());                 
  Hist.fPhtnEta_det_b->Fill(Pho->DetEta());                
  Hist.fPhtnEta_b->Fill(Pho->Eta());                     
  Hist.fPhtnPhi_b->Fill(Pho->Phi());                     
  Hist.fPhtnTheta_b->Fill((Pho->Momentum())->Theta());  
  Hist.fPhtnHadEm3_b->Fill(Pho->HadEm());                 
  Hist.fPhtnHadEm2_b->Fill(Pho->HadEmT());                  
  Hist.fPhtnLshr_b->Fill(Pho->LShr());                   
  Hist.fPhtnCalIso4_raw_b->Fill(Pho->EIso4(0));             
  Hist.fPhtnCalIso4_leak_b->Fill(Pho->EIso4(1));            
  Hist.fPhtnCalIso4_corr_b->Fill(Pho->EIso4(2));            

  Hist.fPhtnCalIso7_b->Fill(Pho->Iso7());                 
  Hist.fPhtnCalIso74_b->Fill((Pho->Iso7())-(Pho->EIso4(0)));
  if(fabs(Pho->EIso4(0))>0.0) Hist.fPhtnCalIso74over4_b->Fill((Pho->Iso7())/(Pho->EIso4(0))-1.0);
  else Hist.fPhtnCalIso74over4_b->Fill(20.0);
  Hist.fPhtnTrkIso4_b->Fill(Pho->SumPt4());                
  Hist.fPhtnCalTrkIso4_b->Fill((Pho->EIso4(0))-(Pho->SumPt4()));              
  Hist.fPhtnN3D_b->Fill(Pho->N3d());                    
  if((Pho->N3d())>0) Hist.fPhtnPt1st_b->Fill(Pho->Pt());   // max Pt trk in cluster ?
  if((Pho->N3d())>1) Hist.fPhtnPt2nd_b->Fill(Pho->Pt2());  // 2nd highest Pt trk ?
  Hist.fPhtnNTrk4_b->Fill(Pho->NIsoTrk());          
  if((Pho->NIsoTrk())>0) Hist.fPhtnPtmax4_b->Fill(Pho->MaxIsoTrk());  
  Hist.fPhtnCesX_b->Fill(Pho->XCes());                    
  Hist.fPhtnCesZ_b->Fill(Pho->ZCes());                   
  Hist.fPhtnChi2_b->Fill(Pho->Chi2());                    
  Hist.fPhtnCesX2_b->Fill(Pho->XCes2());                   
  Hist.fPhtnCesZ2_b->Fill(Pho->ZCes2());   

  Hist.fPhtnCprX_b->Fill(Pho->XCpr());                    
  Hist.fPhtnCprQ_b->Fill(Pho->CprQ());                    
  Hist.fPhtnCesCprX_b->Fill(Pho->XCesCpr());              
  Hist.fPhtnCesCprQ_b->Fill(Pho->CesCprQ());              
  Hist.fPhtnCesCpr_dX_b->Fill((Pho->XCes())-(Pho->XCesCpr()));    
  if(Pho->CesStripE2()>0.0 || Pho->CesWireE2()>0.0) 
    Hist.fPhtn2ndCesCpr_dX_b->Fill((Pho->XCes2())-(Pho->XCesCpr())); 
                
  Hist.fPhtnCesStripE2_b->Fill((Pho->CesStripE2())*(Pho->SinTheta()));           
  Hist.fPhtnCesWireE2_b->Fill((Pho->CesWireE2())*(Pho->SinTheta()));              
  if((Pho->Etc())<35.0) Hist.fPhtnCesWght_b->Fill(Pho->CesWht());                 
  Hist.fPhtnCprWght_b->Fill(Pho->CprWht());
  if((Pho->Etc())<35.0) Hist.fPhtnCprWghtB35_b->Fill(Pho->CprWht());
  if((Pho->Etc())>=35.0) Hist.fPhtnCprWghtA35_b->Fill(Pho->CprWht());

  Hist.fPhtnCprWght_Et_b->Fill((Pho->Etc()),Pho->CprWht());          
  if((Pho->Etc())<50.0) Hist.fPhtnCprWghtB35_Et_b->Fill((Pho->Etc()),Pho->CprWht());          
  if((Pho->Etc())<50.0) Hist.fPhtnCesWght_Et_b->Fill((Pho->Etc()),Pho->CesWht());          

  //_________________________ filling CprWght cross-check histograms
  for(int i=0; i<5; i++)
    {
      Hist.fPhtnCprWghtM1_b[i]->Fill(fCprWght_t1[i]);
      Hist.fPhtnCprWghtM2_b[i]->Fill(fCprWght_t2[i]);
    }

  Hist.fPhtnHadTDC_b->Fill(Pho->Time());                  
  Hist.fPhtnNStub_b->Fill(Pho->NStub());                   
  Hist.fPhtnNStubNoTrk_b->Fill(Pho->NCosStub());              
  Hist.fPhtnNStub30cone_b->Fill(Pho->NCosStubPho());             

  if(MyPhoFakeIDcut(Pho,GetHeaderBlock()->GetEvent())==1) 
    {
      TStnElectron* phele = TPhotonUtil::MatchPhoenixElectron(GetHeaderBlock()->GetEvent(),Pho);
      TStnTrack*    phTrk = TPhotonUtil::PhoenixTrack(GetHeaderBlock()->GetEvent(),phele);
      if(phTrk!=NULL)
	{
	  Hist.fPhtnNphoenix_b->Fill(1.0);
	  Hist.fPhtnNSiHitsTrk_b->Fill(phTrk->NSvxHits());  
	  float chi2 = phTrk->Chi2()/phTrk->NSvxHits();
	  Hist.fPhtnPhnxChi2_b->Fill(chi2 );       
	}
    }
  else Hist.fPhtnNphoenix_b->Fill(0.0);

  //__________________________ filling timing info
  int phoind[]={pho_ind,-1};
  double time_pho1;
  double time_pho2;
  DoMyEmTiming(phoind,0,time_pho1,time_pho2); // in this case, time_pho2 not used
  Hist.fPhtnEmTime_b->Fill(time_pho1);      
  Hist.fPhtnEmTimeHADTdc_b->Fill(time_pho1-(Pho->Time())); 

  return;
}

//_____________________________ Filling photon histograms after cuts
void TMyPhotonFilterModule::FillPhotonHistogramsA(PhotonGeneral_t& Hist, TStnPhoton* Pho, double zvx, int pho_ind) {

  Hist.fPhtnNtower_a->Fill(Pho->NTower());                 
  Hist.fPhtnDetector_a->Fill(Pho->Detector());          
  Hist.fPhtnDelZvx_a->Fill((Pho->VertexZ())-zvx);               
  Hist.fPhtnZvx_a->Fill(Pho->VertexZ());                   
  Hist.fPhtnLike_a->Fill(Pho->Likelihood());                   
  Hist.fPhtnEt_raw_a->Fill(Pho->Et());                 
  Hist.fPhtnEt_twr_a->Fill(Pho->Etc());                 
  Hist.fPhtnE_total_a->Fill(Pho->Momentum()->E());                 
  Hist.fPhtnEta_det_a->Fill(Pho->DetEta());                
  Hist.fPhtnEta_a->Fill(Pho->Eta());                     
  Hist.fPhtnPhi_a->Fill(Pho->Phi());                     
  Hist.fPhtnTheta_a->Fill((Pho->Momentum())->Theta());  
  Hist.fPhtnHadEm3_a->Fill(Pho->HadEm());                 
  Hist.fPhtnHadEm2_a->Fill(Pho->HadEmT());                  
  Hist.fPhtnLshr_a->Fill(Pho->LShr());                   
  Hist.fPhtnCalIso4_raw_a->Fill(Pho->EIso4(0));             
  Hist.fPhtnCalIso4_leak_a->Fill(Pho->EIso4(1));            
  Hist.fPhtnCalIso4_corr_a->Fill(Pho->EIso4(2));            


  Hist.fPhtnCalIso7_a->Fill(Pho->Iso7());                 
  Hist.fPhtnCalIso74_a->Fill((Pho->Iso7())-(Pho->EIso4(0)));
  if(fabs(Pho->EIso4(0))>0.0) Hist.fPhtnCalIso74over4_a->Fill((Pho->Iso7())/(Pho->EIso4(0))-1.0);
  else Hist.fPhtnCalIso74over4_a->Fill(20.0);
  Hist.fPhtnTrkIso4_a->Fill(Pho->SumPt4());                
  Hist.fPhtnCalTrkIso4_a->Fill((Pho->EIso4(0))-(Pho->SumPt4()));              

// +++++ need to use stillN3D in place of Pho->N3d() after ID cuts
  int stillN3D=0;
  if(fUseTrkCprCheck==1 && (Pho->N3d())==0) 
    {
      double dxcpr=TPhotonUtil::CprTrack(Pho,fTrackBlock);
      if(fabs(dxcpr)<=fMinTrkCprX) stillN3D=1; 
    }
  else stillN3D=Pho->N3d();
  Hist.fPhtnN3D_a->Fill(stillN3D); // need to use stillN3D in place of Pho->N3d() after ID cuts                 
  if(stillN3D>0) Hist.fPhtnPt1st_a->Fill(Pho->Pt());   // max Pt trk in cluster ?
  if(stillN3D>1) Hist.fPhtnPt2nd_a->Fill(Pho->Pt2());  // 2nd highest Pt trk ?
  Hist.fPhtnNTrk4_a->Fill(Pho->NIsoTrk());          
  if((Pho->NIsoTrk())>0) Hist.fPhtnPtmax4_a->Fill(Pho->MaxIsoTrk());  
  Hist.fPhtnCesX_a->Fill(Pho->XCes());                    
  Hist.fPhtnCesZ_a->Fill(Pho->ZCes());                   
  Hist.fPhtnChi2_a->Fill(Pho->Chi2());                    
  Hist.fPhtnCesX2_a->Fill(Pho->XCes2());                   
  Hist.fPhtnCesZ2_a->Fill(Pho->ZCes2());    

  Hist.fPhtnCprX_a->Fill(Pho->XCpr());                    
  Hist.fPhtnCprQ_a->Fill(Pho->CprQ());                    
  Hist.fPhtnCesCprX_a->Fill(Pho->XCesCpr());              
  Hist.fPhtnCesCprQ_a->Fill(Pho->CesCprQ());              
  Hist.fPhtnCesCpr_dX_a->Fill((Pho->XCes())-(Pho->XCesCpr()));    
  if(Pho->CesStripE2()>0.0 || Pho->CesWireE2()>0.0) 
    Hist.fPhtn2ndCesCpr_dX_a->Fill((Pho->XCes2())-(Pho->XCesCpr())); 
               
  Hist.fPhtnCesStripE2_a->Fill((Pho->CesStripE2())*(Pho->SinTheta()));           
  Hist.fPhtnCesWireE2_a->Fill((Pho->CesWireE2())*(Pho->SinTheta()));              
  if((Pho->Etc())<35.0) Hist.fPhtnCesWght_a->Fill(Pho->CesWht());                 
  Hist.fPhtnCprWght_a->Fill(Pho->CprWht());
  if((Pho->Etc())<35.0) Hist.fPhtnCprWghtB35_a->Fill(Pho->CprWht());
  if((Pho->Etc())>=35.0) Hist.fPhtnCprWghtA35_a->Fill(Pho->CprWht());

  Hist.fPhtnCprWght_Et_a->Fill((Pho->Etc()),Pho->CprWht());          
  if((Pho->Etc())<50.0) Hist.fPhtnCprWghtB35_Et_a->Fill((Pho->Etc()),Pho->CprWht());          
  if((Pho->Etc())<50.0) Hist.fPhtnCesWght_Et_a->Fill((Pho->Etc()),Pho->CesWht());          

  //_________________________ filling CprWght cross-check histograms
  for(int i=0; i<5; i++)
    {
      Hist.fPhtnCprWghtM1_a[i]->Fill(fCprWght_t1[i]);
      Hist.fPhtnCprWghtM2_a[i]->Fill(fCprWght_t2[i]);
    }
  
  Hist.fPhtnHadTDC_a->Fill(Pho->Time());                  
  Hist.fPhtnNStub_a->Fill(Pho->NStub());                   
  Hist.fPhtnNStubNoTrk_a->Fill(Pho->NCosStub());              
  Hist.fPhtnNStub30cone_a->Fill(Pho->NCosStubPho());             

  if(MyPhoFakeIDcut(Pho,GetHeaderBlock()->GetEvent())==1) 
    {
      TStnElectron* phele = TPhotonUtil::MatchPhoenixElectron(GetHeaderBlock()->GetEvent(),Pho);
      TStnTrack*    phTrk = TPhotonUtil::PhoenixTrack(GetHeaderBlock()->GetEvent(),phele);
      if(phTrk!=NULL)
	{
	  Hist.fPhtnNphoenix_a->Fill(1.0);
	  Hist.fPhtnNSiHitsTrk_a->Fill(phTrk->NSvxHits());  
	  float chi2 = phTrk->Chi2()/phTrk->NSvxHits();
	  Hist.fPhtnPhnxChi2_a->Fill(chi2 );       
	}
    }
  else Hist.fPhtnNphoenix_a->Fill(0.0);

  //__________________________ filling timing info
  int phoind[]={pho_ind,-1};
  double time_pho1;
  double time_pho2;
  DoMyEmTiming(phoind,0,time_pho1,time_pho2); // in this case, time_pho2 not used
  Hist.fPhtnEmTime_a->Fill(time_pho1);      
  Hist.fPhtnEmTimeHADTdc_a->Fill(time_pho1-(Pho->Time())); 

  return;
}

//_____________________________________________________________________________
int TMyPhotonFilterModule::BeginJob() {
				// register the data block

  RegisterDataBlock("PhotonBlock" ,"TStnPhotonBlock",&fPhotonBlock );
  RegisterDataBlock("TrackBlock"  ,"TStnTrackBlock" ,&fTrackBlock );
  RegisterDataBlock("JetBlock"    ,"TStnJetBlock"   ,&fJetBlockClu04);// registring JetClue04
  RegisterDataBlock("Phoenix_Electrons","TPhoenixElectronBlock",&fPhxEleBlock); // phoenix stuff
  RegisterDataBlock("PROD@PhoenixSI_Tracking","TStnTrackBlock",&fPhxSiTrackBlock); // phoenix stuff
  RegisterDataBlock("MetBlock"    ,"TStnMetBlock"   ,&fMetBlock);
  RegisterDataBlock("CalDataBlock","TCalDataBlock"  ,&fCalDataBlock);
  RegisterDataBlock("EmTimingBlock","TStnEmTimingBlock", &fTimingBlock);

  RegisterDataBlock("TriggerBlock","TStnTriggerBlock",&fTriggerBlock);
  if(fUsePhoTrig!=0) trigBits.SetTriggerBlock(fTriggerBlock);

  if(fEtfnl_trh>fMinEtcor[0] || fEtfnl_trh>fMinEtcor[1])
    {
      if(fMinEtcor[0]<fMinEtcor[1]) fEtfnl_trh=fMinEtcor[0];
      else fEtfnl_trh=fMinEtcor[1];
    }

  outRun.clear();   // clearing output
  outEvent.clear(); 
  outNpho.clear();  // number of CEM photons which passed cuts
  outEt1.clear();   // Et of 1st photon
  outEt2.clear();   // Et of 2nd photon

  BookHistograms(); // book histograms
  return 0;
}
//_____________________________________________________________________________
int TMyPhotonFilterModule::BeginRun() {
  int runN=GetHeaderBlock()->RunNumber();
  myGoodWire->setRunNumber(runN);
  if(fUsePhoTrig!=0) trigBits.BeginRun();
  return 0;
}

//_____________________________________________________________________________
int TMyPhotonFilterModule::Event(int ientry) {

  ClearModuleOutput();
//   bool pass   = false;
  bool pass   = true;

  if(! fCalDataBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fCalDataBlock->GetEntry(ientry);

  if(! fPhotonBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fPhotonBlock->GetEntry(ientry);

  if(! fTrackBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fTrackBlock->GetEntry(ientry);

  if(! fJetBlockClu04)
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fJetBlockClu04->GetEntry(ientry);
  int fNJetClu04=fJetBlockClu04->NJets();
  double fSumEt_jet04=0.0; // SumEt of Clu(R=0.4) jets with raw Et>10 GeV 
  for(int j=0; j<fNJetClu04; j++) 
    {
      TStnJet *mjJet04=fJetBlockClu04->Jet(j);
      if((mjJet04->Et())>=10.0) fSumEt_jet04=fSumEt_jet04+(mjJet04->Et());
    }

  if(! fMetBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fMetBlock->GetEntry(ientry);
  double fSumEt=fMetBlock->fSumet;

  if(! fPhxSiTrackBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fPhxSiTrackBlock->GetEntry(ientry);  // getting phoenix tracks

  if(! fPhxEleBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fPhxEleBlock->GetEntry(ientry); // getting phoenix electrons

  if(! fTriggerBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fTriggerBlock->GetEntry(ientry);

  if(! fTimingBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fTimingBlock->GetEntry(ientry);

  //_____ applying Ray's isolation energy correction for events with Nvx12>1.
  //need to do that only for dev_242 and dev_243_01
  TPhotonUtil::CorrectPhotonIsolation(GetHeaderBlock()->GetEvent());

//==============================================================================================  
//------------------------------------- accessing MyVertexFilterModule
//______________________________________________________________________________________________
  TMyVertexFilterModule* MyVertex=
    (TMyVertexFilterModule*) ((TStnAna*) GetAna()->GetModule("MyVertexFilter")); /* this has to be
     modified later: name of my vertex filter has to be passed from outside (there can be several
     MyVertexFilter modules performing different tasks). Current declaration assumes that I default
     initialize TMyVertexFilterModule in my Root macro. */
  double zvx_best=MyVertex->GetmyZvx_best();
  int my_nvx12=MyVertex->GetmyNvx12(); //num of class12 vertices  
//______________________________________________________________________________________________

  //_____ applying Ray's photon energy correction
  int phoCor_stat=0;
  if(fUseEngCorr==1) phoCor_stat=TStntuple::CorrectPhotonEnergy(GetHeaderBlock()->GetEvent(),zvx_best); 

  CprStuff input1; // using Nvx12
  CprStuff input2; // using SumEt-SumEtJet10(Clu R=0.4)
  input1.servInd=-1.0;
  input2.servInd=-1.0;
  input1.nvx12=my_nvx12;
  input2.nvx12=-1;
  input1.SumEtoutJet=-1.0;
  input2.SumEtoutJet=fSumEt-fSumEt_jet04;

  int _myNcluster = fPhotonBlock->NPhotons();
  fPhoHist[0].fPhtnNcand_b->Fill(_myNcluster); // number of photon clusters before cuts
  fPhoHist[1].fPhtnNcand_b->Fill(_myNcluster); // number of photon clusters before cuts
  fPhoHist[2].fPhtnNcand_b->Fill(_myNcluster); // number of photon clusters before cuts
  int _myNclusterCEM=0;
  int ind_passed[20];

  for(int i=0; i<20; i++)
    {
      ind_passed[i]=-1;
    }

  for (int i=0; i<_myNcluster; i++) 
    {
      double cpr_w=0.0;
      double cpr_ws1=0.0;
      double cpr_ws2=0.0;
      double cpr_ws3=0.0;
      double cpr_ws4=0.0;
      double serv_phoProb=0.0;
      double serv_bckgProb=0.0;
      double serv_par=-1.0;

      TStnPhoton* _myPho = fPhotonBlock->Photon(i);

      //_______________ CprWght using Nvx12
//       cpr_w=MyCPRweights(_myPho,input1,serv_phoProb,serv_bckgProb,serv_par,
// 			 cpr_ws1,cpr_ws2,cpr_ws3,cpr_ws4);
      fCprWght_t1[0]=cpr_w;
      fCprWght_t1[1]=cpr_ws1;
      fCprWght_t1[2]=cpr_ws2;
      fCprWght_t1[3]=cpr_ws3;
      fCprWght_t1[4]=cpr_ws4;
      //_______________ CprWght using SumEt
//       cpr_w=MyCPRweights(_myPho,input2,serv_phoProb,serv_bckgProb,serv_par,
// 			 cpr_ws1,cpr_ws2,cpr_ws3,cpr_ws4);
      fCprWght_t2[0]=cpr_w;
      fCprWght_t2[1]=cpr_ws1;
      fCprWght_t2[2]=cpr_ws2;
      fCprWght_t2[3]=cpr_ws3;
      fCprWght_t2[4]=cpr_ws4;
      
      if(i<2) FillPhotonHistogramsB(fPhoHist[i],_myPho,zvx_best,i);
      else FillPhotonHistogramsB(fPhoHist[2],_myPho,zvx_best,i);
    }

  int NphoL_fnl=0;
  int NphoE_fnl=0;

  //____________________________________ trigger selection happens here
  if(fUsePhoTrig!=0) 
    {
      trigBits.Event();
      trig12 = trigBits.DiPhoton12();
      trig18 = trigBits.DiPhoton18();
      trig25 = trigBits.Pho25Iso();
      trig50 = trigBits.Pho50();
      trig70 = trigBits.Pho70();
      //   trig = trig12 || trig18 || trig50 || trig70; // to select all possible photon triggers
      trig= trig12 || trig18; // to select only di-pho events
    }
  if(fUsePhoTrig==1 && trig==false) // remove event because it has no required triggers
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't trigger cut"<<std::endl;
      SetPassed(0);
      return 0;      
    }
  if(fUsePhoTrig==-1 && trig==true) // remove event because it has triggers I don't want
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't trigger cut"<<std::endl;
      SetPassed(0);
      return 0;      
    }


  //____________________________________ looping over photon candidates
  for (int i=0; i<_myNcluster; i++) 
    {
      TStnPhoton* _myPho = fPhotonBlock->Photon(i);
      //___________________________________________________Applying ID photon cuts
      if(MyCEMPhotonIDcut(_myPho,fTrackBlock)==1)
	{
	  pass=true;
	  if(_myPho->Etc()>fEtfnl_trh) NphoL_fnl++;
	  else NphoE_fnl++;
	  ind_passed[_myNclusterCEM]=i;   
	  _myNclusterCEM++;
	}
    }

  if(NphoL_fnl<fMinNpho_Lfnl || NphoL_fnl>fMaxNpho_Lfnl)
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't pass NphoL_fnl cut "
		 <<NphoL_fnl<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  if(NphoE_fnl<fMinNpho_Efnl || NphoE_fnl>fMaxNpho_Efnl)
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't pass NphoE_fnl cut "
		 <<NphoE_fnl<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  if((NphoL_fnl+NphoE_fnl)<fMinNpho_fnl || (NphoL_fnl+NphoE_fnl)>fMaxNpho_fnl)
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't pass NphoE_fnl+NphoL_fnl cut "
		 <<NphoL_fnl+NphoE_fnl<<std::endl;
      SetPassed(0);
      return 0;           	      
    }

  // re-ordering photons, if needed
  int reorder_word=0;
  int reorder_word_last=0;
  for(int j=0; j<_myNclusterCEM-1; j++)
    {
      reorder_word_last=reorder_word;
      for(int i=1; i<_myNclusterCEM; i++)
	{
	  TStnPhoton* _myPhoThis = fPhotonBlock->Photon(ind_passed[i]);
	  TStnPhoton* _myPhoLast = fPhotonBlock->Photon(ind_passed[i-1]);   
	  if(_myPhoThis->Etc()>_myPhoLast->Etc()) 
	    {
	      int serv_ind=ind_passed[i-1];
	      ind_passed[i-1]=ind_passed[i];
	      ind_passed[i]=serv_ind;
	      reorder_word++;
	    }
	}
      if(reorder_word_last==reorder_word) break;
    }

  if(fUseDiphoMode==1)
    {
      // applying cuts on Et of two leading photons
      for(int i=0; i<2; i++)
	{
	  TStnPhoton* _myPho = fPhotonBlock->Photon(ind_passed[i]);
	  if(_myPho->Etc()<fMinEtcor[i] || _myPho->Etc()>fMaxEtcor[i])
	    {
	      pass=false;
	      if(fUseVerbose==1) 
		std::cout<<"Event "<<ientry<<" Photon "<<i<<" didn't pass Etcor cut "
			 <<_myPho->Etc()<<std::endl;
	      SetPassed(0);
	      return 0;           	      
	    }
	}
    }

  //____________________________ Beam Halo removal part
  int N_beamhalo=0;
  double cut_dPhi=10.0; // dummy value
  std::vector<int> bh_ind;
  bh_ind.clear();
  for (int i=0; i<_myNcluster; i++) // loop over all candidates
    {
      double haloIso_cut=0.0;
      if((fPhotonBlock->Photon(i)->Etc())<20.0) haloIso_cut=0.15*(fPhotonBlock->Photon(i)->Etc());
      else haloIso_cut=3.0+0.02*(fPhotonBlock->Photon(i)->Etc()-20.0);
//       haloIso_cut=1.0E6; // 03/03/06 for cosmics studies only; to be removed in default

      if(fPhotonBlock->Photon(i)->Detector()==0 && // minimum quality cuts for beam halo candidates
 	 fPhotonBlock->Photon(i)->HadEm()<0.125 && // minimum quality cuts for beam halo candidates
	 fPhotonBlock->Photon(i)->EIso4(2)<haloIso_cut)
	{
	  DoMyBeamHalo(i);
	  if(BeamHaloCut(&myHaloStuff,my_nvx12,HaloCutScenario)==0)
	    {
	      FillBeamHaloStudyHistograms(fNoBeamHaloHist,&myHaloStuff,fPhotonBlock->Photon(i));
	    }
	  else
	    {
	      bh_ind.push_back(i);
	      N_beamhalo++;
	      FillBeamHaloStudyHistograms(fWithBeamHaloHist,&myHaloStuff,fPhotonBlock->Photon(i));
	    }
	}
    }
  if(N_beamhalo==0) fNoBeamHaloHist.fHaloEventStatus->Fill(0.0);
  if(N_beamhalo>0) fWithBeamHaloHist.fHaloEventStatus->Fill(N_beamhalo);
  if(N_beamhalo>1)
    {
      for(int i=0; i<bh_ind.size(); i++)
	{
	  for(int j=i+1; j<bh_ind.size(); j++)
	    {
	      double d_phi=fabs(TVector2::Phi_mpi_pi(fPhotonBlock->Photon(bh_ind[i])->Phi() - fPhotonBlock->Photon(bh_ind[j])->Phi()));
	      if(d_phi<cut_dPhi) cut_dPhi=d_phi;
	    }
	}
    }
 //  if(fUseBeamHaloCut==1 && N_beamhalo>0) // removing beam halo
  if(fUseBeamHaloCut==1 && N_beamhalo>1 && cut_dPhi<0.524) // removing beam halo (new cut as of 06/01/06)
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't pass Beam Halo cut"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
//   if((fUseBeamHaloCut+N_beamhalo)<0) // selecting beam halo 
  if(fUseBeamHaloCut==-1 
     && ((fUseBeamHaloCut+N_beamhalo)<0 || N_beamhalo<2 || cut_dPhi>0.524)) // for selecting beam halo ONLY (new cut as of 06/01/06)
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" has no Beam Halo candidate"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  //________________________________________________________


  //____________________________ Cosmics removal part
  int N_cosmics=0;
  for (int i=0; i<_myNclusterCEM; i++) // loop only over candidates which passed ID cuts
    {
      N_cosmics += MyCosmicsCut(fPhotonBlock->Photon(ind_passed[i]));
    }
  if(fUseCosmicsCut==1 && N_cosmics>0) // removing cosmics
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" didn't pass Cosmics cut"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  if((fUseCosmicsCut+N_cosmics)<0) // selecting cosmics 
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" has no Cosmics candidate"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  //________________________________________________________

  //______________________ removing Ele->Fake_Photon
  int N_phofake=0;
  for(int i=0; i<_myNclusterCEM; i++) // loop only over candidates which passed ID cuts
    {
      if(fPhotonBlock->Photon(ind_passed[i])->Etc()>fEtfnl_trh)
	{
	  int phnxID= MyPhoFakeIDcut(fPhotonBlock->Photon(ind_passed[i]),GetHeaderBlock()->GetEvent());
	  N_phofake += phnxID;
	}
    }
  if(fUsePhoFakeCut==1 && N_phofake>0) // removing Ele->Fake_Photon
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" has Ele->Fake_Photon"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  if((fUsePhoFakeCut+N_phofake)<0) // selecting  Ele->Fake_Photon
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" has no Ele->Fake_Photon candidate"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  //________________________________________________________

  //_________________________ EM timing action happens here
  //
  int phoind[]={ind_passed[0],ind_passed[1]};
  double time_pho1;
  double time_pho2;
  DoMyEmTiming(phoind,1,time_pho1,time_pho2);
  int N_badEmTime=0;
//   TLorentzVector* vec1=fPhotonBlock->Photon(ind_passed[0])->Momentum(); // to be used in cosmics studies
//   TLorentzVector* vec2=fPhotonBlock->Photon(ind_passed[1])->Momentum(); // to be used in cosmics studies
//   double delR=vec1->DeltaR(*vec2); // to be used in cosmic cuts below
//   //--------------- Temporary stuff for BH & CR studies------------------------
//   TMyEventFilterModule* MyEventInfo=
//     (TMyEventFilterModule*) ((TStnAna*) GetAna()->GetModule("MyEventFilter")); 
//   double met=MyEventInfo->GetMet(4);
//   std::cout<<"____________________________________________________________________________________"<<std::endl;
//   std::cout<<">>>> Run="<<GetHeaderBlock()->RunNumber()<<" Event="<<GetHeaderBlock()->EventNumber()<<std::endl;
//   std::cout<<"---- dPhi="<<fabs(TVector2::Phi_mpi_pi(vec1->DeltaPhi(*vec2)))<<" MET="<<met<<std::endl;
//   std::cout<<"---- T1="<<time_pho1<<" T2="<<time_pho2<<std::endl;
//   //_______________ end of Temporary part for BH & CR studies____________________

  if(time_pho1>timeWindow[0] && time_pho1<timeWindow[1] 
     && time_pho2>timeWindow[0] && time_pho2<timeWindow[1]) // applying EM timing cuts only to photons within time window
    {
      if(fabs(time_pho1)>phoTimeThr) N_badEmTime++;
      if(fabs(time_pho2)>phoTimeThr) N_badEmTime++;
      if(fabs(time_pho1-time_pho2)>dTimeThr) N_badEmTime++;
//       if(delR<fMinDelRcosm || delR>fMaxDelRcosm) N_badEmTime++; // to be used in cosmics studies
    }
  if(fUseTimingCut==1 && N_badEmTime>0) // removing events with out of time photons
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" has out of time photons"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  if((fUseTimingCut+N_badEmTime)<0) // selecting events with out of time photons 
    {
      pass=false;
      if(fUseVerbose==1) 
	std::cout<<"Event "<<ientry<<" has no out of time photons"<<std::endl;
      SetPassed(0);
      return 0;           	      
    }
  //________________________________________ end of EM timing part


  //------------------------------------ filling the output and final histograms
  if(pass) 
    {
      fPhoHist[0].fPhtnNcand_a->Fill(_myNclusterCEM); // number of photon clusters after cuts
      fPhoHist[1].fPhtnNcand_a->Fill(_myNclusterCEM); // number of photon clusters after cuts
      fPhoHist[2].fPhtnNcand_a->Fill(_myNclusterCEM); // number of photon clusters after cuts
      for(int i=0; i<_myNclusterCEM; i++)
	{
	  double cpr_w=0.0;
	  double cpr_ws1=0.0;
	  double cpr_ws2=0.0;
	  double cpr_ws3=0.0;
	  double cpr_ws4=0.0;
	  double serv_phoProb=0.0;
	  double serv_bckgProb=0.0;
	  double serv_par=-1.0;
	  
	  TStnPhoton* _myPho = fPhotonBlock->Photon(ind_passed[i]);
	  
	  //_______________ CprWght using Nvx12
// 	  cpr_w=MyCPRweights(_myPho,input1,serv_phoProb,serv_bckgProb,serv_par,
// 			     cpr_ws1,cpr_ws2,cpr_ws3,cpr_ws4);
	  fCprWght_t1[0]=cpr_w;
	  fCprWght_t1[1]=cpr_ws1;
	  fCprWght_t1[2]=cpr_ws2;
	  fCprWght_t1[3]=cpr_ws3;
	  fCprWght_t1[4]=cpr_ws4;
	  //_______________ CprWght using SumEt
// 	  cpr_w=MyCPRweights(_myPho,input2,serv_phoProb,serv_bckgProb,serv_par,
// 			     cpr_ws1,cpr_ws2,cpr_ws3,cpr_ws4);
	  fCprWght_t2[0]=cpr_w;
	  fCprWght_t2[1]=cpr_ws1;
	  fCprWght_t2[2]=cpr_ws2;
	  fCprWght_t2[3]=cpr_ws3;
	  fCprWght_t2[4]=cpr_ws4;	
	  if(i<2) FillPhotonHistogramsA(fPhoHist[i],_myPho,zvx_best,ind_passed[i]);
	  else FillPhotonHistogramsA(fPhoHist[2],_myPho,zvx_best,ind_passed[i]);
	  FillModuleOutput(_myPho,ind_passed[i]); // filling passed photons
	}
      //---- filling summary
      outRun.push_back(GetHeaderBlock()->RunNumber());
      outEvent.push_back(GetHeaderBlock()->EventNumber());
      outNpho.push_back(myNpho);  // number of CEM photons which passed cuts
      if(myNpho>0) outEt1.push_back(myCorrPho[0].Pt());   // Et of 1st photon
      else outEt1.push_back(0.0);
      if(myNpho>1) outEt2.push_back(myCorrPho[1].Pt());   // Et of 2nd photon
      else outEt2.push_back(0.0);
      FillAnaHistograms(fAnaHist,zvx_best,my_nvx12);
      //      FillMetStudyHistograms(fMetStudyHist,my_nvx12);
      if((_myNclusterCEM>2 && fUseVerbose==1) || fPrintMyEvent==1) PrintModuleOutput();
      SetPassed(1);
    }
  else SetPassed(0);
  return 0;
}

//_____________________________________________________________________________
int TMyPhotonFilterModule::EndJob() {

  ofstream outfile(fDatFileName, std::ios::out);
  if (! outfile) 
    {
      std::cerr<<"Error of openning of .DAT file\n";
    }
  if(outfile)
    {
      std::cout<<"---------- TMyPhotonFilterModule Summary -------------------------"<<std::endl;
      std::cout<<"..........Number of events before cuts "
	       <<fPhoHist[0].fPhtnNcand_b->GetEntries()<<std::endl;
      std::cout<<"..........Number of events after cuts  "
	       <<fPhoHist[0].fPhtnNcand_a->GetEntries()<<std::endl;
      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"------  TMyPhotonFilterModule Summary  ----------"<<"\n";
      outfile<<"___________________________________________________"<<"\n";

      char outputstring[200];
      sprintf(outputstring,"..........Number of events before cuts = %f",
	      fPhoHist[0].fPhtnNcand_b->GetEntries());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,"..........Number of events after cuts = %f",
	      fPhoHist[0].fPhtnNcand_a->GetEntries());
      outfile<<outputstring<<"\n";

      if(fUseVerbose==1) 
	{
	  for(int i=0; i<3; i++)
	    {
	      outfile<<"---------------------------------------------------"<<"\n";
	      outfile<<"-------- BEFORE CUTS ------------------------------"<<"\n";
	      outfile<<"Format of output: ___Histo name___Nentries___mean___rms___"<<"\n";
	      outfile<<".........................................................."<<"\n";
	      outfile<<HistoSummary(fPhoHist[i].fPhtnNcand_b)<<"\n";      
	      outfile<<HistoSummary(fPhoHist[i].fPhtnNtower_b)<<"\n"; 
	      outfile<<HistoSummary(fPhoHist[i].fPhtnDetector_b)<<"\n";        
	      outfile<<HistoSummary(fPhoHist[i].fPhtnDelZvx_b)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnZvx_b)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnLike_b)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEt_raw_b)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEt_twr_b)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnE_total_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEta_det_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEta_b)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPhi_b)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnTheta_b)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnHadEm3_b)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnHadEm2_b)<<"\n";
	      outfile<<HistoSummary(fPhoHist[i].fPhtnLshr_b)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso4_raw_b)<<"\n";     
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso4_leak_b)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso4_corr_b)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso7_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso74_b)<<"\n";        
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso74over4_b)<<"\n";   
	      outfile<<HistoSummary(fPhoHist[i].fPhtnTrkIso4_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalTrkIso4_b)<<"\n";        
	      outfile<<HistoSummary(fPhoHist[i].fPhtnN3D_b)<<"\n"; 
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPt1st_b)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPt2nd_b)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnNTrk4_b)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPtmax4_b)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesX_b)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesZ_b)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnChi2_b)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesX2_b)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesZ2_b)<<"\n";  
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprX_b)<<"\n";                    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprQ_b)<<"\n";                    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesCprX_b)<<"\n";              
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesCprQ_b)<<"\n";              
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesCpr_dX_b)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtn2ndCesCpr_dX_b)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesStripE2_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesWireE2_b)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesWght_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprWght_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprWghtB35_b)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprWghtA35_b)<<"\n";         
	      outfile<<"---------------------------------------------------"<<"\n";
	      outfile<<"-------- AFTER CUTS ------------------------------"<<"\n";
	      outfile<<"Format of output: ___Histo name___Nentries___mean___rms___"<<"\n";
	      outfile<<".........................................................."<<"\n";
	      outfile<<HistoSummary(fPhoHist[i].fPhtnNcand_a)<<"\n";      
	      outfile<<HistoSummary(fPhoHist[i].fPhtnNtower_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnDetector_a)<<"\n";        
	      outfile<<HistoSummary(fPhoHist[i].fPhtnDelZvx_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnZvx_a)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnLike_a)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEt_raw_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEt_twr_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnE_total_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEta_det_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnEta_a)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPhi_a)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnTheta_a)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnHadEm3_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnHadEm2_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnLshr_a)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso4_raw_a)<<"\n";     
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso4_leak_a)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso4_corr_a)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso7_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso74_a)<<"\n";        
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalIso74over4_a)<<"\n";   
	      outfile<<HistoSummary(fPhoHist[i].fPhtnTrkIso4_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCalTrkIso4_a)<<"\n";        
	      outfile<<HistoSummary(fPhoHist[i].fPhtnN3D_a)<<"\n";             
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPt1st_a)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPt2nd_a)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnNTrk4_a)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnPtmax4_a)<<"\n";          
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesX_a)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesZ_a)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnChi2_a)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesX2_a)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesZ2_a)<<"\n";           
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprX_a)<<"\n";                    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprQ_a)<<"\n";                    
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesCprX_a)<<"\n";              
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesCprQ_a)<<"\n";              
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesCpr_dX_a)<<"\n";    
	      outfile<<HistoSummary(fPhoHist[i].fPhtn2ndCesCpr_dX_a)<<"\n"; 
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesStripE2_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesWireE2_a)<<"\n";            
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCesWght_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprWght_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprWghtB35_a)<<"\n";         
	      outfile<<HistoSummary(fPhoHist[i].fPhtnCprWghtA35_a)<<"\n";         
	    }
	}
      	      
      if(fPrintPhoList==1)
	{
	  outfile<<"+++++++++++++++++++++++++++++++++++++++++++++++++++"<<"\n";
	  outfile<<"------     List of passed events             ------"<<"\n";
	  outfile<<"___________________________________________________"<<"\n";
	  outfile<<"                                                   "<<"\n";
	  outfile<<"Format: __Run___Event___Npho___Et1___Et2__"<<"\n";
	  outfile<<"                                                   "<<"\n";
	  for(int i=0; i<outRun.size(); i++)
	    {
	      if(outNpho[i]>0) outfile<<OutputSummary(i)<<"\n";
	    }
	  outfile<<"+++++++++++++++++++++++++++++++++++++++++++++++++++"<<"\n";
	  outfile<<"------     End of event list                 ------"<<"\n";
	  outfile<<"___________________________________________________"<<"\n";
	}
	  
      outfile<<"---- The End!------"<<std::endl;
    }
  return 0;
}

char* TMyPhotonFilterModule::HistoSummary(TH1F* myhisto)
{
  //  char* outputstring = "";
  sprintf(histo_outputstring,"...%s   %f   %f   %f",
	  myhisto->GetName(),
	  myhisto->GetEntries(),
	  myhisto->GetMean(),
	  myhisto->GetRMS());
  return histo_outputstring;
}

char* TMyPhotonFilterModule::OutputSummary(int ind)
{
  //  char* outputstring = "";
  if(outNpho[ind]>1) sprintf(histo_outputstring,"  %i  %i  %i  %f  %f",
			     outRun[ind],outEvent[ind],outNpho[ind],outEt1[ind],outEt2[ind]);
  if(outNpho[ind]>0 && outNpho[ind]<2) sprintf(histo_outputstring,"  %i  %i  %i  %f",
			     outRun[ind],outEvent[ind],outNpho[ind],outEt1[ind]);
  return histo_outputstring;
}

//-------------------------------------------------------------------------
//.............. !!! COMMENT !!! ..........................................
// In TMyPhotonFilterModule::MyCEMPhotonIDcut, I use "float" instead of
// "double" to be consistent with Ray.
// Everywhere else in my code I use "double".
//_________________________________________________________________________
int TMyPhotonFilterModule::MyCEMPhotonIDcut(TStnPhoton* Pho, TStnTrackBlock* TrkBlock)
{
  int passcode=1;
  //______________________________________ only CEM photons with Et>7 GeV
  if((Pho->Detector())!=0 || (Pho->Etc())<7.0) return 0;
  if(fabs(Pho->Eta())<fMinEta || fabs(Pho->Eta())>fMaxEta) return 0;
  //______________________________________ HADEM cut using 3 towers
  // simple sliding cut on Had/Em for ggX analysis  
  float cutMin_HADEM=fMinHADEM[1]+fMinHADEM[2]*(Pho->Momentum()->E());
  float cutMax_HADEM=fMaxHADEM[1]+fMaxHADEM[2]*(Pho->Momentum()->E());
  if((Pho->HadEm())<cutMin_HADEM || (Pho->HadEm())>cutMax_HADEM) return 0;
  // complex sliding Had/Em cut is not used in ggX
  //   if((Pho->HadEm())<fMinHADEM[0] || (Pho->HadEm())>fMaxHADEM[0])
  //     {
  //       if((Pho->HadEm())<cutMin_HADEM || (Pho->HadEm())>cutMax_HADEM) return 0;
  //     }

  //______________________________________ CES Chi^2 cut 
  if((Pho->Chi2())<fMinCesChi2 || (Pho->Chi2())>fMaxCesChi2) return 0;
  //______________________________________ N3D cut
  if((Pho->N3d())<fMinN3D || (Pho->N3d())>fMaxN3D) return 0;
  int stillN3D=0;
  if(fUseTrkCprCheck==1 && (Pho->N3d())==0) 
    {
      float dxcpr=TPhotonUtil::CprTrack(Pho,TrkBlock);
      if(fabs(dxcpr)<=fMinTrkCprX) stillN3D=1; 
    }
  if(stillN3D<fMinN3D || stillN3D>fMaxN3D) return 0;
  //______________________________________ cut on max Pt of track in cluster if N3D=1
  if((Pho->N3d())>0 || stillN3D>0)
    {
      float trkPtcut_min=fMinPtmax[0]+fMinPtmax[1]*(Pho->Etc());
      float trkPtcut_max=fMaxPtmax[0]+fMaxPtmax[1]*(Pho->Etc());
      if((Pho->Pt())<trkPtcut_min || (Pho->Pt())>trkPtcut_max) return 0;
    }
  //______________________________________ CalIso4 cut
  float cutMin_CalIso=0.0;
  float cutMax_CalIso=0.0;
  if((Pho->Etc())<20.0)
    {
      cutMin_CalIso=fMinCalIso4_corr[0]*(Pho->Etc()); 
      cutMax_CalIso=fMaxCalIso4_corr[0]*(Pho->Etc());
    } 
  else 
    {
      cutMin_CalIso=fMinCalIso4_corr[1]+fMinCalIso4_corr[2]*(Pho->Etc()-20.0);
      cutMax_CalIso=fMaxCalIso4_corr[1]+fMaxCalIso4_corr[2]*(Pho->Etc()-20.0);      
    }
//   cutMin_CalIso=fMinCalIso4_corr[1]; // for X-section studies
//   cutMax_CalIso=fMaxCalIso4_corr[1]; // for X-section studies    
  
  if((Pho->EIso4(2))<cutMin_CalIso || (Pho->EIso4(2))>cutMax_CalIso) return 0; // test
  //______________________________________ TrkIso4 cut
  if((Pho->SumPt4())<(fMinTrkIso4[0]+fMinTrkIso4[1]*(Pho->Etc())) || 
     (Pho->SumPt4())>(fMaxTrkIso4[0]+fMaxTrkIso4[1]*(Pho->Etc()))) return 0;
  //______________________________________ Energy of 2nd CES cluster (Wire & Strip)
  float _Et2ndCES=0.0;
  if((Pho->CesStripE2())>(Pho->CesWireE2())) _Et2ndCES=(Pho->CesStripE2())*(Pho->SinTheta());
  else _Et2ndCES=(Pho->CesWireE2())*(Pho->SinTheta());
  float cutMin_2ndCes=0.0;
  float cutMax_2ndCes=0.0;  
  if(fUseFixed2ndCesCut==0) // sliding cut 
    {
      if((Pho->Etc())<18.0) 
	{
	  cutMin_2ndCes=fMin2ndCesEt[0]*(Pho->Etc());
	  cutMax_2ndCes=fMax2ndCesEt[0]*(Pho->Etc());	  
	} else {
	  cutMin_2ndCes=fMin2ndCesEt[1]+fMin2ndCesEt[2]*(Pho->Etc());
	  cutMax_2ndCes=fMax2ndCesEt[1]+fMax2ndCesEt[2]*(Pho->Etc());	  	  
	}
    }
  if(fUseFixed2ndCesCut==1) // fixed cut
    {
      cutMin_2ndCes=fMin2ndCesEt[0];
      cutMax_2ndCes=fMax2ndCesEt[0];	  
    }
  if(_Et2ndCES<cutMin_2ndCes || _Et2ndCES>cutMax_2ndCes) return 0;
  //_______________________________________ Fiducial cuts
  if(fabs(Pho->XCes())<fMinCesX || fabs(Pho->XCes())>fMaxCesX) return 0;
  if(fabs(Pho->ZCes())<fMinCesZ || fabs(Pho->ZCes())>fMaxCesZ) return 0;

  //_______________________________________ Checking good Cpr & Ces wires
  if(fUseWireCheck==1)
    {
      bool goodCpr=myGoodWire->GoodCprCluster(Pho,5);
      bool goodCes=myGoodWire->GoodCesCluster(Pho,11,11);
      if(fUseCprCheck==1 && goodCpr==false) return 0;
      if(fUseCesCheck==1 && goodCes==false) return 0;
    }

  return passcode;
}

//__________________________ cuts to identify Photon fakes
int TMyPhotonFilterModule::MyPhoFakeIDcut(TStnPhoton* Pho, TStnEvent* event) {
  int passcode=0;
  TStnElectron* phele = TPhotonUtil::MatchPhoenixElectron(event,Pho);
  TStnTrack*    phTrk = TPhotonUtil::PhoenixTrack(event,phele);
  if(phTrk!=NULL) passcode=1; 
  return passcode;
}

int TMyPhotonFilterModule::MyCosmicsCut(TStnPhoton* Pho) {
  int stat=0;
  double hadE=0.0;
  int runN=GetHeaderBlock()->RunNumber();
  if(runN<190851) // first run for EM timing system
    {
      if((Pho->NCosStubPho())>0) stat=1;
//       if(Pho->HadEm()>=0.0) hadE=(Pho->E())*(Pho->HadEm())/(1.0+Pho->HadEm());
//       if((Pho->NCosStubPho())>0 && ((Pho->Time())>15.0 && hadE>0.5)) stat=1;
    }
//   if((Pho->NCosStubPho())>0) stat=1; // for cosmic studies only
  return stat;
}

void TMyPhotonFilterModule::DoMyBeamHalo(int pho_ind) {
  int _seedWedge=0;
  int _sideWedge=0;
  int _seedWedgeH=0;
  int _sideWedgeH=0;
  int _eastNHads=0;
  int _westNHads=0;
  double _emSeedE=0.0; 
  double _emSideE=0.0; 
  double _hadSeedE=0.0;
  double _hadSeedWedgeE=0.0;
//   getBeamHaloInfo(pho_ind,_seedWedge,_sideWedge,
// 		  _eastNHads,_westNHads,_emSeedE,_emSideE,_hadSeedE);
  getBeamHaloInfo(pho_ind,_seedWedge,_seedWedgeH,_sideWedge,_sideWedgeH,
		  _eastNHads,_westNHads,_emSeedE,_emSideE,_hadSeedE,_hadSeedWedgeE);
  myHaloStuff.seedwedgeH=_seedWedgeH;
  myHaloStuff.sidewedgeH=_sideWedgeH;
  myHaloStuff.seedwedge=_seedWedge;
  myHaloStuff.sidewedge=_sideWedge;
  myHaloStuff.eastNhad=_eastNHads;
  myHaloStuff.westNhad=_westNHads;
  myHaloStuff.emseedE=_emSeedE;
  myHaloStuff.emsideE=_emSideE;
  myHaloStuff.hadseedE=_hadSeedE;
  myHaloStuff.seedwedgeHadE=_hadSeedWedgeE;
 
  return;
}
  
int TMyPhotonFilterModule::BeamHaloCut(HaloStuff *beamhalo, int nvx12, int scenario) {
  int bh_code=0;
  double ue=0.013; // underlying event EM+HAD energy per tower
  double mi=0.019; // multiple interaction EM+HAD energy per tower
  if(scenario==0) // Max's cut
    {
      if((beamhalo->seedwedge) > 9 || ((beamhalo->eastNhad + beamhalo->westNhad) > 2)) return 1; // Max's version of beam halo cut
    }
  if(scenario==1) // my modified version_1 of Max's cut
    {
      if(((beamhalo->seedwedge)>9 && (beamhalo->seedwedgeHadE)<(0.4+(ue+mi*(nvx12-1))*(beamhalo->seedwedge))) || 
	 ((beamhalo->eastNhad + beamhalo->westNhad) > 2)) return 1; 
    }
  if(scenario==2) // my modified version_2 of Max's cut
    {
      if((beamhalo->seedwedge)>4 && 
	 ((beamhalo->eastNhad + beamhalo->westNhad) > 2)) return 1; 
    }
  if(scenario==3) // my modified version_3 of Max's cut
    {
      if((beamhalo->seedwedge)>4 && (beamhalo->seedwedgeHadE)<(0.4+(ue+mi*(nvx12-1))*(beamhalo->seedwedge)) &&
	 ((beamhalo->eastNhad + beamhalo->westNhad) > 2)) return 1; 
    }
  if(scenario==4) // my modified version_4 of Max's cut
    {
      if((beamhalo->seedwedge)>9 && ((beamhalo->eastNhad + beamhalo->westNhad) > 2)) return 1; 
    }
  if(scenario==5) // my modified version_5 of Max's cut
    {
      if((beamhalo->seedwedge)>9 && (beamhalo->seedwedgeHadE)<(0.4+(ue+mi*(nvx12-1))*(beamhalo->seedwedge)) &&
	 ((beamhalo->eastNhad + beamhalo->westNhad) > 2)) return 1; 
    }
  
//   //___________ Peter Onyisi's version of beam halo cut
//   if((sideWedge<=2 && (seedWedge-1.5*sideWedge)>=6.0) && ) return 1; 
//   if((sideWedge>2 && sideWedge<=12 && (seedWedge-0.5*sideWedge)>=8.0)) return 1;
//   if((sideWedge>12 && seedWedge>=14)) return 1;

  return bh_code;
}

//___________________________________________ Max's routine for beam halo
void TMyPhotonFilterModule::getBeamHaloInfo(int pho_ind, int& seedWedge, int& seedWedgeH,
					    int& sideWedge, int& sideWedgeH, int& eastNHads,
					    int& westNHads, double& emSeedE, double& emSideE, 
					    double& hadSeedE, double& seedWedgeHadE) {
  CalDataArray calholder;
  MatchCalorTowers(pho_ind, &calholder);
  TCalTower* tower1 = calholder[0];
  int iPhiEmO = tower1->IPhi();

  float thresh = 0.1;
  float threshH = 0.1; // added by Sasha
  seedWedge = 0;
  sideWedge = 0;
  seedWedgeH = 0;  // added by Sasha
  sideWedgeH = 0;  // added by Sasha
  eastNHads = 0;
  westNHads = 0;
  emSeedE = 0.;
  emSideE = 0.;
  hadSeedE = 0.;
  seedWedgeHadE=0.0;

  for(int iEta = TENETA/2-14; iEta < TENETA/2 + 14; iEta++ )
    {
      int iPhi = (TETTYP[iEta] == 5) ? iPhiEmO*2 : iPhiEmO;
      TCalTower* c1 = fCalDataBlock->Tower(iEta,iPhi);

      if(iEta-TENETA/2 > -11 && iEta-TENETA/2 < 10)
	{
	  if(c1==NULL || c1->EmEnergy() < thresh) continue;
	  seedWedge++;
	  emSeedE = emSeedE + c1->EmEnergy();
	  seedWedgeHadE = seedWedgeHadE + c1->HadEnergy(); // added by Sasha;
	  if(c1->HadEnergy() > threshH) seedWedgeH++; // added by Sasha;
	}
      else
	{
	  TCalTower* c2 = (TETTYP[iEta] == 5) ? fCalDataBlock->Tower(iEta,iPhi+1) : NULL;
	  
	  bool pass = false;
	  if(c1 != NULL && c1->HadEnergy() > thresh) pass = true;
	  if(c2 != NULL && c2->HadEnergy() > thresh) pass = true;
	  if(!pass) continue;

	  if(c1) hadSeedE = hadSeedE + c1->HadEnergy();
	  if(c2) hadSeedE = hadSeedE + c2->HadEnergy();

	  if(iEta < TENETA/2) westNHads++;
	  if(iEta > TENETA/2) eastNHads++;

	}
    }

  int iphi1 = iPhiEmO==0 ? 23 : iPhiEmO-1;
  int iphi2 = iPhiEmO==23 ? 0 : iPhiEmO+1;
  for(int iEta = TENETA/2-10; iEta < TENETA/2 + 10; iEta++ )
    {
      TCalTower* ctower1 = fCalDataBlock->Tower(iEta,iphi1);
      TCalTower* ctower2 = fCalDataBlock->Tower(iEta,iphi2);
      if(ctower1 != NULL && ctower1->EmEnergy() > thresh)
	{
	  sideWedge++;
	  emSideE = emSideE + ctower1->EmEnergy();
	  if(ctower1->HadEnergy() > threshH) sideWedgeH++; // added by Sasha;
	}
      if(ctower2 != NULL && ctower2->Energy() > thresh)
	{
	  sideWedge++;
	  emSideE = emSideE + ctower2->EmEnergy();
	  if(ctower2->HadEnergy() > threshH) sideWedgeH++; // added by Sasha;
	}
    }
  
  return;
}

void TMyPhotonFilterModule::MatchCalorTowers(int pho_ind, CalDataArray* cdholder){
  cdholder->clear();
  if(pho_ind>-1)
    {
      TStnLinkBlock* links = fPhotonBlock->TowerLinkList();
      int nptow = links->NLinks(pho_ind);
      
      TCalTower* ctower = NULL;
      for(int j=0; j<nptow; j++) 
	{
	  int iptow = links->Index(pho_ind,j);
	  int iphi = iptow & 0x3F;
	  int ieta = (iptow>>8) & 0x3F;
	  
	  ctower = fCalDataBlock->Tower(ieta,iphi);
	  cdholder->push_back(ctower);
	}

      std::sort(cdholder->begin(), cdholder->end(), SortTowersByEnergy);
    }
  return;
}

void TMyPhotonFilterModule::DoMyEmTiming(int pho_ind[2],int mode_code,double &t1,double &t2) {

  float _time[]={-9999.9,9999.9};
  int runN=GetHeaderBlock()->RunNumber();
  if(runN>=190851) // first run for EM timing system
    {
      TEmTimingModule* MaxEmTiming = (TEmTimingModule*) ((TStnAna*) GetAna()->GetModule("EmTimingAna"));
      
      //__________________ timing for photons
      for(int j=0; j<2; j++)
	{
	  int Nhits=-1;
	  int NGoodHits=-1;
	  EmTimingTower* _emTimeTower=NULL;
	  CalDataArray calholder;
	  if(pho_ind[j]>-1) 
	    {
	      MatchCalorTowers(pho_ind[j], &calholder);
	      for(int icount = 0 ; icount < calholder.size(); icount++)
		{
		  TCalTower* ctower = calholder[icount];
		  int iEta = ctower->IEta();
		  int iPhi = ctower->IPhi();
		  
		  _emTimeTower=MaxEmTiming->TEmTimingModule::getTimingTower(0,iEta,iPhi); // 0=CEM; 1=PEM; 2=CHA; 3=WHA; 4=PHA 
		  if(TETTYP[iEta] == 5 && iPhi%2 != 0) _emTimeTower=MaxEmTiming->TEmTimingModule::getTimingTower(0,iEta,iPhi-1);
		  if(_emTimeTower!=NULL)
		    {
		      Nhits=_emTimeTower->nHits();
		      for(int i=0; i<Nhits; i++)
			{
			  int status = _emTimeTower->getStatus(i);
			  if(TStnEmTimingBlock::EnergyTooLow(status)) continue;
			  if(TStnEmTimingBlock::SigmasFromThreshold(status) < 3) continue;
			  if(_emTimeTower->getT0(i)<-80.0 || _emTimeTower->getT0(i)>160.0) continue;
			  NGoodHits++;
			  _time[j]=_emTimeTower->getT0(i);
			  break;
			}
		    }
		  if(NGoodHits==0) break;
		}
	    }
	  if(mode_code==1) fTimingHisto.fEmtNhitsTot[j]->Fill(Nhits);
	}
      if(mode_code==1 && pho_ind[0]>-1 && pho_ind[1]>-1) 
	{
	  fTimingHisto.fEmtTimePho1->Fill(_time[0]);
	  fTimingHisto.fEmtTimePho2->Fill(_time[1]);
	  fTimingHisto.fEmtDelTime->Fill(_time[0]-_time[1]);
	  fTimingHisto.fEmtTime1vsTime2->Fill(_time[0],_time[1]);
	  double delphi= TVector2::Phi_mpi_pi(fPhotonBlock->Photon(pho_ind[0])->Phi() - fPhotonBlock->Photon(pho_ind[1])->Phi());
	  fTimingHisto.fEmtDelTvsDelPhi->Fill(sin(fabs(delphi)/2.0),fabs(_time[0]-_time[1]));
	}
    }
  t1=_time[0];
  t2=_time[1];

  return;
}

// double TMyPhotonFilterModule::MyCPRweights(TStnPhoton* Pho, CprStuff input, 
// 					     double &phoProb, double &bckgProb, double &servPar,
// 					     double &cprsyst1, double &cprsyst2, 
// 					     double &cprsyst3, double &cprsyst4)
// {
//   double myWeight=0.0;
//   double cprQ=Pho->CesCprQ();
//   double phoPt=Pho->Etc();
//   double signTheta=Pho->SinTheta();
//   double my_nPhoBac=input.servInd;
//   int my_nVert=input.nvx12;
//   double my_sumEtNojets=input.SumEtoutJet;
//   myWeight=myPhoComputer->getCprWeight(cprQ,phoPt,signTheta,  
// 				       phoProb,bckgProb,servPar,
// 				       cprsyst1,cprsyst2,cprsyst3,cprsyst4,
// 				       my_nPhoBac,my_nVert,my_sumEtNojets);
//   return myWeight;
// }

void TMyPhotonFilterModule::ClearModuleOutput()
{
  myNpho=0;  
  myNpho13=0;
  myNpho20=0;
  myUncorrPho.clear();           
  myCorrPho.clear();
  myPhoInd.clear();
  phoEtaDet.clear();             
  phoHadEm3.clear();             
  phoChi2.clear();               
  phoN3D.clear();                
  phoNtwr.clear();                
  phoISO4.clear();               
  phoISO4leak.clear();           
  phoISO4raw.clear();            
  phoISO7raw.clear();
  phoTrkMaxPt.clear();         
  phoISO4trk.clear();            
  phoEtCes2nd.clear();           
  phoCesX.clear();               
  phoCesZ.clear();  
  phoCesX2.clear();               
  phoCesZ2.clear();  
  phoCprX.clear();               
  phoCprQ.clear();               
  phoCesCprX.clear();            
  phoCesCprQ.clear();                                        
  phoCesWght.clear();            
  phoCprWghtM1.clear();          
  phoCprSyst1M1.clear();         
  phoCprSyst2M1.clear();         
  phoCprSyst3M1.clear();         
  phoCprSyst4M1.clear();         
  phoCprWghtM2.clear();          
  phoCprSyst1M2.clear();         
  phoCprSyst2M2.clear();         
  phoCprSyst3M2.clear();         
  phoCprSyst4M2.clear();         
  return;  
}

void TMyPhotonFilterModule::PrintModuleOutput()
{
  std::cout<<"______________________________________________________________"<<std::endl;
  std::cout<<"                                                              "<<std::endl;
  std::cout<<"------------ printing output for MyPhotonFilterModule  -->>>  "<<std::endl;
  std::cout<<"______________________________________________________________"<<std::endl;
  std::cout<<"                                                              "<<std::endl;
  std::cout<<"-->>> Number of Photons with Et>7 GeV ="<<myNpho<<std::endl;
  std::cout<<"-->>> Number of Photons with Et>13 GeV ="<<myNpho13<<std::endl;
  std::cout<<"-->>> Number of Photons with Et>20 GeV ="<<myNpho20<<std::endl;
  for(int i=0; i<myNpho; i++)
    {
      std::cout<<"________ printing Photon #= "<<i<<std::endl;
      std::cout<<"                            "<<std::endl;
      std::cout<<"   uncorrected  Et, eta, phi = "
	       <<myUncorrPho[i].Perp()<<" "
	       <<myUncorrPho[i].Eta()<<" "
	       <<myUncorrPho[i].Phi()<<std::endl;
      std::cout<<"   corrected  Et, eta, phi   = "
	       <<myCorrPho[i].Perp()<<" "
	       <<myCorrPho[i].Eta()<<" "
	       <<myCorrPho[i].Phi()<<std::endl;
      std::cout<<"   detector Eta  = "<<phoEtaDet[i]<<std::endl;
      std::cout<<"   HAD/EM(3 twr) = "<<phoHadEm3[i]<<std::endl;             
      std::cout<<"   Chi2          = "<<phoChi2[i]<<std::endl;               
      std::cout<<"   N3D in clust. = "<<phoN3D[i]<<std::endl;                
      std::cout<<"   corr. CalIso4 = "<<phoISO4[i]<<std::endl;               
      std::cout<<"   leak. CalIso4 = "<<phoISO4leak[i]<<std::endl;           
      std::cout<<"   raw CalIso4   = "<<phoISO4raw[i]<<std::endl;            
      std::cout<<"   raw CalIso7   = "<<phoISO7raw[i]<<std::endl;            
      std::cout<<"   TrkIso4(SumPt)= "<<phoISO4trk[i]<<std::endl;
      std::cout<<"   Trk MaxPt     = "<<phoTrkMaxPt[i]<<std::endl;            
      std::cout<<"   2nd Ces Et    = "<<phoEtCes2nd[i]<<std::endl;           
      std::cout<<"   pho CesX      = "<<phoCesX[i]<<std::endl;               
      std::cout<<"   pho CesZ      = "<<phoCesZ[i]<<std::endl;               
//       std::cout<<"   CesWght       = "<<phoCesWght[i]<<std::endl;            
//       std::cout<<"   CprWght(using Nvx12) def, syst1, syst2, syst3, syst4"<<std::endl;
//       std::cout<<"   --->>> "<<phoCprWghtM1[i]<<" "          
// 	       <<phoCprSyst1M1[i]<<" "         
// 	       <<phoCprSyst2M1[i]<<" "         
// 	       <<phoCprSyst3M1[i]<<" "         
// 	       <<phoCprSyst4M1[i]<<std::endl; 
//       std::cout<<"   CprWght(using SumEt) def, syst1, syst2, syst3, syst4"<<std::endl;
//       std::cout<<"   --->>> "<<phoCprWghtM2[i]<<" "          
// 	       <<phoCprSyst1M2[i]<<" "         
// 	       <<phoCprSyst2M2[i]<<" "         
// 	       <<phoCprSyst3M2[i]<<" "         
// 	       <<phoCprSyst4M2[i]<<std::endl; 
//       std::cout<<"                      "<<std::endl;
    } 
  std::cout<<"______________________________________________________________"<<std::endl;
  std::cout<<"                                                              "<<std::endl;
  std::cout<<"--------- end of printoutput for MyPhotonFilterModule  --<<<"<<std::endl;
  std::cout<<"______________________________________________________________"<<std::endl;
  std::cout<<"                                                              "<<std::endl;
  return;
}

void TMyPhotonFilterModule::FillModuleOutput(TStnPhoton* Pho, int pho_ind)
{
  myNpho++;
  TLorentzVector _tmpPho;
  _tmpPho.SetPx(Pho->Momentum()->Px());
  _tmpPho.SetPy(Pho->Momentum()->Py());
  _tmpPho.SetPz(Pho->Momentum()->Pz());
  _tmpPho.SetE(Pho->Momentum()->E());
  myCorrPho.push_back(_tmpPho);
  if(_tmpPho.Pt()>=13.0) myNpho13++;
  if(_tmpPho.Pt()>=20.0) myNpho20++;
  _tmpPho.SetPtEtaPhiM(Pho->Et(),Pho->Eta(),Pho->Phi(),0.0);
  myUncorrPho.push_back(_tmpPho);
  myPhoInd.push_back(pho_ind);
  phoEtaDet.push_back(Pho->DetEta());             
  phoHadEm3.push_back(Pho->HadEm());             
  phoChi2.push_back(Pho->Chi2());
  int stillN3D=0;
  if(fUseTrkCprCheck==1 && (Pho->N3d())==0) 
    {
      double dxcpr=TPhotonUtil::CprTrack(Pho,fTrackBlock);
      if(fabs(dxcpr)<=fMinTrkCprX) stillN3D=1; 
    }
  else stillN3D=Pho->N3d();
  phoN3D.push_back(stillN3D);
  if(stillN3D==0) phoTrkMaxPt.push_back(0.0);
  else phoTrkMaxPt.push_back(Pho->Pt());
  phoNtwr.push_back(Pho->NTower());                
  phoISO4.push_back(Pho->IsoCorr());               
  phoISO4leak.push_back(Pho->EIso4(1));           
  phoISO4raw.push_back(Pho->Iso());            
  phoISO7raw.push_back(Pho->Iso7());            
  phoISO4trk.push_back(Pho->Tiso());
  double _Et2ndCES=0.0;
  if((Pho->CesStripE2())>(Pho->CesWireE2())) _Et2ndCES=(Pho->CesStripE2())*(Pho->SinTheta());
  else _Et2ndCES=(Pho->CesWireE2())*(Pho->SinTheta());
  if(_Et2ndCES<0.0)_Et2ndCES=0.0;
  phoEtCes2nd.push_back(_Et2ndCES);           
  phoCesX.push_back(Pho->XCes());               
  phoCesZ.push_back(Pho->ZCes());
  phoCesX2.push_back(Pho->XCes2());               
  phoCesZ2.push_back(Pho->ZCes2());
  phoCprX.push_back(Pho->XCpr());               
  phoCprQ.push_back(Pho->CprQ());               
  phoCesCprX.push_back(Pho->XCesCpr());            
  phoCesCprQ.push_back(Pho->CesCprQ());                           
  phoCesWght.push_back(Pho->CesWht());            
  phoCprWghtM1.push_back(fCprWght_t1[0]);          
  phoCprSyst1M1.push_back(fCprWght_t1[1]);         
  phoCprSyst2M1.push_back(fCprWght_t1[2]);         
  phoCprSyst3M1.push_back(fCprWght_t1[3]);         
  phoCprSyst4M1.push_back(fCprWght_t1[4]);         
  phoCprWghtM2.push_back(fCprWght_t2[0]);          
  phoCprSyst1M2.push_back(fCprWght_t2[1]);         
  phoCprSyst2M2.push_back(fCprWght_t2[2]);         
  phoCprSyst3M2.push_back(fCprWght_t2[3]);         
  phoCprSyst4M2.push_back(fCprWght_t2[4]);         

  return;
}

  //_____________________________________________________________ theta* -- di-pho scattering angle
double TMyPhotonFilterModule::GetThetaStar(double y1, double y2) {
  double tcos;
  double y=(y1-y2)/2.0;
  double t=0.0;
  tcos=(TMath::Exp(y)-TMath::Exp(-y))/(TMath::Exp(y)+TMath::Exp(-y));
  if(fabs(tcos)<=1.0) t=TMath::ACos(tcos);
  return t;
}
double TMyPhotonFilterModule::GetThetaStar(std::vector<TLorentzVector> vec) {
  double t=-1.0E6;
  if(vec.size()>=2)
    {
      double Y1=vec[0].Rapidity();
      double Y2=vec[1].Rapidity();
      t=GetThetaStar(Y1, Y2);
    }
  return t;
}
  //__________________________________________________ returns Kt of two leading photons
double TMyPhotonFilterModule::GetMyQt(std::vector<TLorentzVector> vec) {
  double kt_kick=-1.0E6;
  if(vec.size()>=2) kt_kick=(vec[0]+vec[1]).Pt();
  return kt_kick;
}
  //__________________________________________________ returns Phi of di-photon system
double TMyPhotonFilterModule::GetMyQtPhi(std::vector<TLorentzVector> vec) {
  double phi_kick=-1.0E6;
  if(vec.size()>=2) phi_kick=(vec[0]+vec[1]).Phi();
  return phi_kick;
}
  //__________________________________________________ returns Ht=Met+Et1+Et2+...Eti
double TMyPhotonFilterModule::GetMyHt(std::vector<TLorentzVector> vec, double met) {
  double ht=met;
  for(int i=0; i<vec.size(); i++)
    {
      ht=ht+vec[i].Pt();
    }
  return ht;
}
  //__________________________________________________ returns corrected sumEt=SumEt-Et1-Et2-...Eti
double TMyPhotonFilterModule::GetMyCorrSumEt(std::vector<TLorentzVector> vec, double sumet) {
  double se=sumet;
  for(int i=0; i<vec.size(); i++)
    {
      se=se-vec[i].Pt();
    }
  return se;
}
  //__________________________________________________ returns di-photon mass
double TMyPhotonFilterModule::GetMyDiPhoMass(std::vector<TLorentzVector> vec) {
  double mass=-1.0E6;
  if(vec.size()>=2) mass=(vec[0]+vec[1]).M();
  return mass;
}

  //--------------------------------------------------------------
  //==============================================================
  //              !!! STOPPED HERE !!!
  //==============================================================
  //______________________________________________________________

