/*

This is a modified version of TMyJetFilterModule. It is to be used in
ggX analysis.
  
*/
//_____________________________________________________________________________
#include <iomanip>
#include <iostream>
#include <fstream>
#include "TF1.h"
#include "TCanvas.h"
#include "TMath.h"
#include <TRandom.h>
#include "Stntuple/loop/TStnAna.hh"

#include "TMyJetFilterModule_GMSB_newMetModel_U2Gv8sig.hh"
#include "TMyEventFilterModule_ggX.hh"
#include "TMyVertexFilterModuleA_ntu.hh"
#include "TMyPhotonFilterModule_ggX.hh"
#include "TMyZeeFilterModule_ggX.hh"
#include "TMyUtil.hh"

//------- need this for jet-EM matching
bool SortTowersByEnergy(TCalTower* c1, TCalTower* c2){
  if(c1->Energy() > c2->Energy()) return true;
  else return false;
}

//------- Function for MET resolution due to unclustered energy
double UnclMetResolution(double* x, double* par){
  double value=0.0;
  double mean=par[0];
  double sigma1=par[1];
  double sigma2=par[3]*sigma1;
  double arg=x[0];
//   value=(sigma1*TMath::Gaus(arg,mean,sigma1)+par[2]*sigma2*TMath::Gaus(arg,mean,sigma2))/(sigma1+sigma2*par[2]);
  value=(TMath::Gaus(arg,mean,sigma1)+par[2]*TMath::Gaus(arg,mean,sigma2))/(1.0+par[2]);
  return value;
}

//-------- Jet Energy Resolution: centered at zero 
// //-------------- fit function: [Const*Gaus(-x/(1+x))+Landau(-x/(1+x))]/(1+Const)
double MyJER(double* x, double* par) {
  double value=0.0;
  double arg=-x[0]/(x[0]+1.0);
  double arg_L=-x[0]/(x[0]+1.0);
  double mean=par[0];
  double sigmaG=par[1];
  double mpv=par[2];
  double sigmaL=par[3];
  double normL=par[4];
  if(normL<0.0) normL=0.0;
  double f1=normL/(1.0+normL)*TMath::Gaus(arg,mean,sigmaG);
  double f2=TMath::Landau(arg_L,mpv,sigmaL)/(1.0+normL);
  value=f1+f2;
  if(value<0.0) return 0.0;
  return value;
}


//________________ returns correlation coefficients for JER params
double JERCorrCoeff(int i, int j)
{
  double corr_param[15][11]; // [eta][param]
  corr_param[0][0]=-0.953359; // Gauss mean: c01
  corr_param[0][1]=-0.883424; // Gauss mean: c02
  corr_param[0][2]=0.783976; // Gauss mean: c12
  corr_param[0][3]=-0.769484; // Gauss sigma: c01
  corr_param[0][4]=-0.916005; // Landau mpv: c01
  corr_param[0][5]=-0.920646; // Landau mpv: c02
  corr_param[0][6]=0.774913; // Landau mpv: c12
  corr_param[0][7]=-0.798127; // Landau sigma: c01
  corr_param[0][8]=-0.979048; // norm: c01
  corr_param[0][9]=0.914083; // norm: c02
  corr_param[0][10]=-0.972488; // norm: c12
  corr_param[1][0]=-0.930448; // Gauss mean: c01
  corr_param[1][1]=-0.893613; // Gauss mean: c02
  corr_param[1][2]=0.743464; // Gauss mean: c12
  corr_param[1][3]=-0.855253; // Gauss sigma: c01
  corr_param[1][4]=-0.93506; // Landau mpv: c01
  corr_param[1][5]=-0.790079; // Landau mpv: c02
  corr_param[1][6]=0.633928; // Landau mpv: c12
  corr_param[1][7]=-0.791488; // Landau sigma: c01
  corr_param[1][8]=-0.979059; // norm: c01
  corr_param[1][9]=0.935759; // norm: c02
  corr_param[1][10]=-0.978165; // norm: c12
  corr_param[2][0]=-0.933467; // Gauss mean: c01
  corr_param[2][1]=-0.903664; // Gauss mean: c02
  corr_param[2][2]=0.769636; // Gauss mean: c12
  corr_param[2][3]=-0.834006; // Gauss sigma: c01
  corr_param[2][4]=-0.941456; // Landau mpv: c01
  corr_param[2][5]=-0.863316; // Landau mpv: c02
  corr_param[2][6]=0.730447; // Landau mpv: c12
  corr_param[2][7]=-0.795485; // Landau sigma: c01
  corr_param[2][8]=-0.973561; // norm: c01
  corr_param[2][9]=0.922559; // norm: c02
  corr_param[2][10]=-0.979269; // norm: c12
  corr_param[3][0]=-0.92146; // Gauss mean: c01
  corr_param[3][1]=-0.875047; // Gauss mean: c02
  corr_param[3][2]=0.720247; // Gauss mean: c12
  corr_param[3][3]=-0.820492; // Gauss sigma: c01
  corr_param[3][4]=-0.932934; // Landau mpv: c01
  corr_param[3][5]=-0.806167; // Landau mpv: c02
  corr_param[3][6]=0.666462; // Landau mpv: c12
  corr_param[3][7]=-0.752656; // Landau sigma: c01
  corr_param[3][8]=-0.97604; // norm: c01
  corr_param[3][9]=0.916931; // norm: c02
  corr_param[3][10]=-0.970166; // norm: c12
  corr_param[4][0]=-0.921373; // Gauss mean: c01
  corr_param[4][1]=-0.865997; // Gauss mean: c02
  corr_param[4][2]=0.713135; // Gauss mean: c12
  corr_param[4][3]=-0.812212; // Gauss sigma: c01
  corr_param[4][4]=-0.933552; // Landau mpv: c01
  corr_param[4][5]=-0.826206; // Landau mpv: c02
  corr_param[4][6]=0.696959; // Landau mpv: c12
  corr_param[4][7]=-0.731748; // Landau sigma: c01
  corr_param[4][8]=-0.972365; // norm: c01
  corr_param[4][9]=0.900603; // norm: c02
  corr_param[4][10]=-0.96338; // norm: c12
  corr_param[5][0]=-0.945056; // Gauss mean: c01
  corr_param[5][1]=-0.918674; // Gauss mean: c02
  corr_param[5][2]=0.808282; // Gauss mean: c12
  corr_param[5][3]=-0.811252; // Gauss sigma: c01
  corr_param[5][4]=-0.941345; // Landau mpv: c01
  corr_param[5][5]=-0.908828; // Landau mpv: c02
  corr_param[5][6]=0.805962; // Landau mpv: c12
  corr_param[5][7]=-0.737379; // Landau sigma: c01
  corr_param[5][8]=-0.974342; // norm: c01
  corr_param[5][9]=0.878683; // norm: c02
  corr_param[5][10]=-0.952568; // norm: c12
  corr_param[6][0]=-0.863692; // Gauss mean: c01
  corr_param[6][1]=-0.898828; // Gauss mean: c02
  corr_param[6][2]=0.683443; // Gauss mean: c12
  corr_param[6][3]=-0.864674; // Gauss sigma: c01
  corr_param[6][4]=-0.910948; // Landau mpv: c01
  corr_param[6][5]=-0.878636; // Landau mpv: c02
  corr_param[6][6]=0.709797; // Landau mpv: c12
  corr_param[6][7]=-0.790837; // Landau sigma: c01
  corr_param[6][8]=-0.976028; // norm: c01
  corr_param[6][9]=0.920123; // norm: c02
  corr_param[6][10]=-0.976345; // norm: c12
  corr_param[7][0]=-0.901329; // Gauss mean: c01
  corr_param[7][1]=-0.868814; // Gauss mean: c02
  corr_param[7][2]=0.664341; // Gauss mean: c12
  corr_param[7][3]=-0.879818; // Gauss sigma: c01
  corr_param[7][4]=-0.910909; // Landau mpv: c01
  corr_param[7][5]=-0.848758; // Landau mpv: c02
  corr_param[7][6]=0.654596; // Landau mpv: c12
  corr_param[7][7]=-0.854805; // Landau sigma: c01
  corr_param[7][8]=-0.98475; // norm: c01
  corr_param[7][9]=0.944593; // norm: c02
  corr_param[7][10]=-0.983111; // norm: c12
  corr_param[8][0]=-0.93546; // Gauss mean: c01
  corr_param[8][1]=-0.919387; // Gauss mean: c02
  corr_param[8][2]=0.775089; // Gauss mean: c12
  corr_param[8][3]=-0.885525; // Gauss sigma: c01
  corr_param[8][4]=-0.902932; // Landau mpv: c01
  corr_param[8][5]=-0.858334; // Landau mpv: c02
  corr_param[8][6]=0.664962; // Landau mpv: c12
  corr_param[8][7]=-0.83488; // Landau sigma: c01
  corr_param[8][8]=-0.989491; // norm: c01
  corr_param[8][9]=0.946333; // norm: c02
  corr_param[8][10]=-0.980041; // norm: c12
  corr_param[9][0]=-0.958622; // Gauss mean: c01
  corr_param[9][1]=-0.92783; // Gauss mean: c02
  corr_param[9][2]=0.813899; // Gauss mean: c12
  corr_param[9][3]=-0.918357; // Gauss sigma: c01
  corr_param[9][4]=-0.946212; // Landau mpv: c01
  corr_param[9][5]=-0.874383; // Landau mpv: c02
  corr_param[9][6]=0.732471; // Landau mpv: c12
  corr_param[9][7]=-0.890866; // Landau sigma: c01
  corr_param[9][8]=-0.993186; // norm: c01
  corr_param[9][9]=0.965285; // norm: c02
  corr_param[9][10]=-0.987298; // norm: c12
  corr_param[10][0]=-0.959116; // Gauss mean: c01
  corr_param[10][1]=-0.934235; // Gauss mean: c02
  corr_param[10][2]=0.822224; // Gauss mean: c12
  corr_param[10][3]=-0.929578; // Gauss sigma: c01
  corr_param[10][4]=-0.945125; // Landau mpv: c01
  corr_param[10][5]=-0.889286; // Landau mpv: c02
  corr_param[10][6]=0.741957; // Landau mpv: c12
  corr_param[10][7]=-0.900695; // Landau sigma: c01
  corr_param[10][8]=-0.992615; // norm: c01
  corr_param[10][9]=0.967849; // norm: c02
  corr_param[10][10]=-0.989424; // norm: c12
  corr_param[11][0]=-0.961204; // Gauss mean: c01
  corr_param[11][1]=-0.933701; // Gauss mean: c02
  corr_param[11][2]=0.822536; // Gauss mean: c12
  corr_param[11][3]=-0.938163; // Gauss sigma: c01
  corr_param[11][4]=-0.95; // Landau mpv: c01
  corr_param[11][5]=-0.875959; // Landau mpv: c02
  corr_param[11][6]=0.737455; // Landau mpv: c12
  corr_param[11][7]=-0.895806; // Landau sigma: c01
  corr_param[11][8]=-0.993612; // norm: c01
  corr_param[11][9]=0.968624; // norm: c02
  corr_param[11][10]=-0.988782; // norm: c12
  corr_param[12][0]=-0.961494; // Gauss mean: c01
  corr_param[12][1]=-0.888003; // Gauss mean: c02
  corr_param[12][2]=0.756614; // Gauss mean: c12
  corr_param[12][3]=-0.940026; // Gauss sigma: c01
  corr_param[12][4]=-0.971454; // Landau mpv: c01
  corr_param[12][5]=-0.907369; // Landau mpv: c02
  corr_param[12][6]=0.819359; // Landau mpv: c12
  corr_param[12][7]=-0.890781; // Landau sigma: c01
  corr_param[12][8]=-0.995606; // norm: c01
  corr_param[12][9]=0.976755; // norm: c02
  corr_param[12][10]=-0.991439; // norm: c12
  corr_param[13][0]=-0.979353; // Gauss mean: c01
  corr_param[13][1]=-0.901815; // Gauss mean: c02
  corr_param[13][2]=0.819153; // Gauss mean: c12
  corr_param[13][3]=-0.906452; // Gauss sigma: c01
  corr_param[13][4]=-0.977947; // Landau mpv: c01
  corr_param[13][5]=-0.902621; // Landau mpv: c02
  corr_param[13][6]=0.821221; // Landau mpv: c12
  corr_param[13][7]=-0.907155; // Landau sigma: c01
  corr_param[13][8]=-0.996171; // norm: c01
  corr_param[13][9]=0.98616; // norm: c02
  corr_param[13][10]=-0.996056; // norm: c12
  corr_param[14][0]=0; // Gauss mean: c01
  corr_param[14][1]=0; // Gauss mean: c02
  corr_param[14][2]=0; // Gauss mean: c12
  corr_param[14][3]=0; // Gauss sigma: c01
  corr_param[14][4]=-0.993129; // Landau mpv: c01
  corr_param[14][5]=-0.979168; // Landau mpv: c02
  corr_param[14][6]=0.957156; // Landau mpv: c12
  corr_param[14][7]=-0.895607; // Landau sigma: c01
  corr_param[14][8]=0; // norm: c01
  corr_param[14][9]=0; // norm: c02
  corr_param[14][10]=0; // norm: c12

  double value=0.0;
  if(i<15 && j<11) value=corr_param[i][j];

  return value;
}


//________________ returns JER param or its uncertainty
double JERparam(int code, int i, int j)
{
  double jer_param[15][13]; // [eta][param] 
  double jer_param_er[15][13]; // [eta][param]
  double value=0.0;

  jer_param[0][0]=-0.00505533;  jer_param_er[0][0]=0.00366313;
  jer_param[0][1]=-7.37332E-5;  jer_param_er[0][1]=1.02366E-5;
  jer_param[0][2]=5.06548;  jer_param_er[0][2]=0.198112;
  jer_param[0][3]=1.03604;  jer_param_er[0][3]=0.0162871;
  jer_param[0][4]=0.000363984;  jer_param_er[0][4]=9.99763E-5;
  jer_param[0][5]=0.0404354;  jer_param_er[0][5]=0.00394954;
  jer_param[0][6]=7.70406E-5;  jer_param_er[0][6]=1.80066E-5;
  jer_param[0][7]=-1.05943;  jer_param_er[0][7]=0.148324;
  jer_param[0][8]=0.157408;  jer_param_er[0][8]=0.00948233;
  jer_param[0][9]=0.00745406;  jer_param_er[0][9]=0.000132492;
  jer_param[0][10]=-4.48426;  jer_param_er[0][10]=0.997815;
  jer_param[0][11]=1.14401;  jer_param_er[0][11]=0.269919;
  jer_param[0][12]=0.0459092;  jer_param_er[0][12]=0.0168848;
  jer_param[1][0]=0.0928237;  jer_param_er[1][0]=0.00248223;
  jer_param[1][1]=-0.000201847;  jer_param_er[1][1]=8.82907E-6;
  jer_param[1][2]=0.177168;  jer_param_er[1][2]=0.137301;
  jer_param[1][3]=0.670063;  jer_param_er[1][3]=0.0119732;
  jer_param[1][4]=0.00308811;  jer_param_er[1][4]=9.34083E-5;
  jer_param[1][5]=0.000336138;  jer_param_er[1][5]=0.00152807;
  jer_param[1][6]=5.34059E-6;  jer_param_er[1][6]=5.37503E-6;
  jer_param[1][7]=-1.15979;  jer_param_er[1][7]=0.0761452;
  jer_param[1][8]=0.137285;  jer_param_er[1][8]=0.00491652;
  jer_param[1][9]=0.0020658;  jer_param_er[1][9]=3.46802E-5;
  jer_param[1][10]=-14.7515;  jer_param_er[1][10]=0.612517;
  jer_param[1][11]=4.80581;  jer_param_er[1][11]=0.195418;
  jer_param[1][12]=-0.127518;  jer_param_er[1][12]=0.0109911;
  jer_param[2][0]=0.100634;  jer_param_er[2][0]=0.00241696;
  jer_param[2][1]=-0.000253429;  jer_param_er[2][1]=8.43763E-6;
  jer_param[2][2]=-0.688927;  jer_param_er[2][2]=0.125514;
  jer_param[2][3]=0.655545;  jer_param_er[2][3]=0.0103474;
  jer_param[2][4]=0.00300742;  jer_param_er[2][4]=8.73698E-5;
  jer_param[2][5]=0.0105033;  jer_param_er[2][5]=0.00178783;
  jer_param[2][6]=-3.76786E-5;  jer_param_er[2][6]=5.83178E-6;
  jer_param[2][7]=-1.85956;  jer_param_er[2][7]=0.096736;
  jer_param[2][8]=0.139571;  jer_param_er[2][8]=0.00510727;
  jer_param[2][9]=0.00227237;  jer_param_er[2][9]=3.75247E-5;
  jer_param[2][10]=-19.2885;  jer_param_er[2][10]=1.05958;
  jer_param[2][11]=5.66883;  jer_param_er[2][11]=0.262952;
  jer_param[2][12]=-0.161499;  jer_param_er[2][12]=0.013508;
  jer_param[3][0]=0.0952545;  jer_param_er[3][0]=0.00263113;
  jer_param[3][1]=-0.000189574;  jer_param_er[3][1]=9.63887E-6;
  jer_param[3][2]=0.236287;  jer_param_er[3][2]=0.12846;
  jer_param[3][3]=0.731283;  jer_param_er[3][3]=0.0128143;
  jer_param[3][4]=0.00341218;  jer_param_er[3][4]=0.00011154;
  jer_param[3][5]=0.0258263;  jer_param_er[3][5]=0.0016674;
  jer_param[3][6]=-4.83423E-5;  jer_param_er[3][6]=5.80565E-6;
  jer_param[3][7]=-2.22975;  jer_param_er[3][7]=0.0737835;
  jer_param[3][8]=0.179229;  jer_param_er[3][8]=0.00515981;
  jer_param[3][9]=0.0024204;  jer_param_er[3][9]=4.113E-5;
  jer_param[3][10]=-10.4553;  jer_param_er[3][10]=0.561997;
  jer_param[3][11]=3.36745;  jer_param_er[3][11]=0.171045;
  jer_param[3][12]=-0.0618917;  jer_param_er[3][12]=0.00980421;
  jer_param[4][0]=0.115229;  jer_param_er[4][0]=0.0027871;
  jer_param[4][1]=-0.000157746;  jer_param_er[4][1]=9.95943E-6;
  jer_param[4][2]=-0.0905143;  jer_param_er[4][2]=0.134539;
  jer_param[4][3]=0.795373;  jer_param_er[4][3]=0.016243;
  jer_param[4][4]=0.00635758;  jer_param_er[4][4]=0.000146956;
  jer_param[4][5]=0.0345064;  jer_param_er[4][5]=0.00216488;
  jer_param[4][6]=-5.72569E-5;  jer_param_er[4][6]=7.07075E-6;
  jer_param[4][7]=-2.21206;  jer_param_er[4][7]=0.0958281;
  jer_param[4][8]=0.212192;  jer_param_er[4][8]=0.00725209;
  jer_param[4][9]=0.00349351;  jer_param_er[4][9]=6.06418E-5;
  jer_param[4][10]=-10.6021;  jer_param_er[4][10]=0.660483;
  jer_param[4][11]=3.23948;  jer_param_er[4][11]=0.191871;
  jer_param[4][12]=-0.0236045;  jer_param_er[4][12]=0.0106671;
  jer_param[5][0]=0.0900639;  jer_param_er[5][0]=0.00267652;
  jer_param[5][1]=-8.17704E-5;  jer_param_er[5][1]=7.7302E-6;
  jer_param[5][2]=-0.567021;  jer_param_er[5][2]=0.160166;
  jer_param[5][3]=0.706037;  jer_param_er[5][3]=0.0137402;
  jer_param[5][4]=0.0066424;  jer_param_er[5][4]=0.000110101;
  jer_param[5][5]=0.0161473;  jer_param_er[5][5]=0.00313166;
  jer_param[5][6]=-3.72664E-5;  jer_param_er[5][6]=8.95092E-6;
  jer_param[5][7]=-3.40086;  jer_param_er[5][7]=0.154954;
  jer_param[5][8]=0.163174;  jer_param_er[5][8]=0.00755835;
  jer_param[5][9]=0.00291679;  jer_param_er[5][9]=6.87186E-5;
  jer_param[5][10]=-10.8209;  jer_param_er[5][10]=1.39492;
  jer_param[5][11]=2.05925;  jer_param_er[5][11]=0.352187;
  jer_param[5][12]=0.184539;  jer_param_er[5][12]=0.0192903;
  jer_param[6][0]=0.110669;  jer_param_er[6][0]=0.00336557;
  jer_param[6][1]=-0.000302301;  jer_param_er[6][1]=1.15245E-5;
  jer_param[6][2]=-1.70381;  jer_param_er[6][2]=0.17128;
  jer_param[6][3]=0.84678;  jer_param_er[6][3]=0.0199186;
  jer_param[6][4]=0.00418531;  jer_param_er[6][4]=0.00022283;
  jer_param[6][5]=-0.00347175;  jer_param_er[6][5]=0.0027646;
  jer_param[6][6]=8.50977E-5;  jer_param_er[6][6]=1.10633E-5;
  jer_param[6][7]=-3.2283;  jer_param_er[6][7]=0.126136;
  jer_param[6][8]=0.0758951;  jer_param_er[6][8]=0.00708642;
  jer_param[6][9]=0.00415232;  jer_param_er[6][9]=8.11982E-5;
  jer_param[6][10]=-16.6687;  jer_param_er[6][10]=1.09606;
  jer_param[6][11]=5.18449;  jer_param_er[6][11]=0.288507;
  jer_param[6][12]=-0.190928;  jer_param_er[6][12]=0.016249;
  jer_param[7][0]=0.0658253;  jer_param_er[7][0]=0.00272349;
  jer_param[7][1]=-0.000196113;  jer_param_er[7][1]=1.14286E-5;
  jer_param[7][2]=-1.07207;  jer_param_er[7][2]=0.137955;
  jer_param[7][3]=0.889453;  jer_param_er[7][3]=0.015712;
  jer_param[7][4]=0.00152891;  jer_param_er[7][4]=0.000140114;
  jer_param[7][5]=-0.0287057;  jer_param_er[7][5]=0.00306348;
  jer_param[7][6]=0.000128678;  jer_param_er[7][6]=1.50299E-5;
  jer_param[7][7]=-2.67266;  jer_param_er[7][7]=0.129521;
  jer_param[7][8]=0.170338;  jer_param_er[7][8]=0.00800203;
  jer_param[7][9]=0.00119121;  jer_param_er[7][9]=7.89355E-5;
  jer_param[7][10]=-8.77829;  jer_param_er[7][10]=1.94651;
  jer_param[7][11]=2.5475;  jer_param_er[7][11]=0.581462;
  jer_param[7][12]=0.0673843;  jer_param_er[7][12]=0.0379263;
  jer_param[8][0]=0.058632;  jer_param_er[8][0]=0.00246133;
  jer_param[8][1]=-8.6882E-5;  jer_param_er[8][1]=7.27552E-6;
  jer_param[8][2]=-2.81222;  jer_param_er[8][2]=0.177198;
  jer_param[8][3]=0.87612;  jer_param_er[8][3]=0.0135608;
  jer_param[8][4]=0.000862571;  jer_param_er[8][4]=8.72723E-5;
  jer_param[8][5]=-0.0272999;  jer_param_er[8][5]=0.00336864;
  jer_param[8][6]=5.7274E-5;  jer_param_er[8][6]=1.19158E-5;
  jer_param[8][7]=-3.16373;  jer_param_er[8][7]=0.187887;
  jer_param[8][8]=0.218132;  jer_param_er[8][8]=0.00804389;
  jer_param[8][9]=-0.000115495;  jer_param_er[8][9]=5.26047E-5;
  jer_param[8][10]=6.59552;  jer_param_er[8][10]=4.14997;
  jer_param[8][11]=-3.91415;  jer_param_er[8][11]=1.16124;
  jer_param[8][12]=0.689584;  jer_param_er[8][12]=0.0728198;
  jer_param[9][0]=0.047587;  jer_param_er[9][0]=0.00405247;
  jer_param[9][1]=-3.67703E-5;  jer_param_er[9][1]=1.32232E-5;
  jer_param[9][2]=-2.82013;  jer_param_er[9][2]=0.277916;
  jer_param[9][3]=0.90659;  jer_param_er[9][3]=0.0207463;
  jer_param[9][4]=0.00138775;  jer_param_er[9][4]=0.000128634;
  jer_param[9][5]=-0.0150813;  jer_param_er[9][5]=0.00500665;
  jer_param[9][6]=4.34831E-5;  jer_param_er[9][6]=1.98595E-5;
  jer_param[9][7]=-4.24538;  jer_param_er[9][7]=0.258383;
  jer_param[9][8]=0.235095;  jer_param_er[9][8]=0.0112121;
  jer_param[9][9]=-0.000176939;  jer_param_er[9][9]=7.11021E-5;
  jer_param[9][10]=17.7377;  jer_param_er[9][10]=6.10388;
  jer_param[9][11]=-6.60975;  jer_param_er[9][11]=1.55793;
  jer_param[9][12]=0.757554;  jer_param_er[9][12]=0.0890909;
  jer_param[10][0]=0.0702999;  jer_param_er[10][0]=0.00524409;
  jer_param[10][1]=-0.0001322;  jer_param_er[10][1]=1.44554E-5;
  jer_param[10][2]=-4.64174;  jer_param_er[10][2]=0.433494;
  jer_param[10][3]=1.06671;  jer_param_er[10][3]=0.0316977;
  jer_param[10][4]=0.00105544;  jer_param_er[10][4]=0.000168547;
  jer_param[10][5]=-0.02437;  jer_param_er[10][5]=0.00587413;
  jer_param[10][6]=2.26747E-5;  jer_param_er[10][6]=1.97589E-5;
  jer_param[10][7]=-3.8046;  jer_param_er[10][7]=0.382791;
  jer_param[10][8]=0.268162;  jer_param_er[10][8]=0.0148949;
  jer_param[10][9]=-6.26511E-5;  jer_param_er[10][9]=8.37528E-5;
  jer_param[10][10]=10.2852;  jer_param_er[10][10]=7.77639;
  jer_param[10][11]=-4.34279;  jer_param_er[10][11]=1.80774;
  jer_param[10][12]=0.564928;  jer_param_er[10][12]=0.0947709;
  jer_param[11][0]=0.0276176;  jer_param_er[11][0]=0.00700865;
  jer_param[11][1]=-1.08182E-5;  jer_param_er[11][1]=1.77066E-5;
  jer_param[11][2]=-4.30341;  jer_param_er[11][2]=0.642783;
  jer_param[11][3]=1.15381;  jer_param_er[11][3]=0.0466366;
  jer_param[11][4]=0.000660203;  jer_param_er[11][4]=0.000219101;
  jer_param[11][5]=-0.0365288;  jer_param_er[11][5]=0.007012;
  jer_param[11][6]=5.34815E-5;  jer_param_er[11][6]=2.21572E-5;
  jer_param[11][7]=-4.83064;  jer_param_er[11][7]=0.460712;
  jer_param[11][8]=0.28416;  jer_param_er[11][8]=0.0195007;
  jer_param[11][9]=-4.88533E-7;  jer_param_er[11][9]=0.000101491;
  jer_param[11][10]=14.821;  jer_param_er[11][10]=8.92697;
  jer_param[11][11]=-5.32396;  jer_param_er[11][11]=2.01108;
  jer_param[11][12]=0.568491;  jer_param_er[11][12]=0.10153;
  jer_param[12][0]=-0.00456382;  jer_param_er[12][0]=0.00797029;
  jer_param[12][1]=5.93327E-5;  jer_param_er[12][1]=2.2512E-5;
  jer_param[12][2]=-6.05263;  jer_param_er[12][2]=0.641518;
  jer_param[12][3]=1.01168;  jer_param_er[12][3]=0.0580327;
  jer_param[12][4]=0.00124107;  jer_param_er[12][4]=0.000266261;
  jer_param[12][5]=-0.0672398;  jer_param_er[12][5]=0.0103374;
  jer_param[12][6]=0.000144969;  jer_param_er[12][6]=3.13729E-5;
  jer_param[12][7]=-7.44458;  jer_param_er[12][7]=0.643695;
  jer_param[12][8]=0.236166;  jer_param_er[12][8]=0.0233694;
  jer_param[12][9]=0.000272798;  jer_param_er[12][9]=0.000115376;
  jer_param[12][10]=15.9149;  jer_param_er[12][10]=16.3677;
  jer_param[12][11]=-5.06773;  jer_param_er[12][11]=3.26237;
  jer_param[12][12]=0.515062;  jer_param_er[12][12]=0.14614;
  jer_param[13][0]=-0.0364159;  jer_param_er[13][0]=0.0230243;
  jer_param[13][1]=0.000103308;  jer_param_er[13][1]=6.3942E-5;
  jer_param[13][2]=-2.04414;  jer_param_er[13][2]=1.61387;
  jer_param[13][3]=1.16241;  jer_param_er[13][3]=0.154151;
  jer_param[13][4]=0.00449765;  jer_param_er[13][4]=0.000680983;
  jer_param[13][5]=-0.0713694;  jer_param_er[13][5]=0.0128;
  jer_param[13][6]=6.17634E-5;  jer_param_er[13][6]=3.50159E-5;
  jer_param[13][7]=-6.69936;  jer_param_er[13][7]=0.883717;
  jer_param[13][8]=0.401773;  jer_param_er[13][8]=0.0401819;
  jer_param[13][9]=0.00048766;  jer_param_er[13][9]=0.000171866;
  jer_param[13][10]=-6.84164;  jer_param_er[13][10]=15.4788;
  jer_param[13][11]=1.14003;  jer_param_er[13][11]=2.85757;
  jer_param[13][12]=0.063226;  jer_param_er[13][12]=0.116727;
  jer_param[14][0]=0;  jer_param_er[14][0]=0;
  jer_param[14][1]=0;  jer_param_er[14][1]=0;
  jer_param[14][2]=0;  jer_param_er[14][2]=0;
  jer_param[14][3]=0;  jer_param_er[14][3]=0;
  jer_param[14][4]=0;  jer_param_er[14][4]=0;
  jer_param[14][5]=-0.127208;  jer_param_er[14][5]=0.0191958;
  jer_param[14][6]=5.65717E-5;  jer_param_er[14][6]=3.57586E-5;
  jer_param[14][7]=-4.42422;  jer_param_er[14][7]=1.87829;
  jer_param[14][8]=0.9097;  jer_param_er[14][8]=0.0515384;
  jer_param[14][9]=-0.000149165;  jer_param_er[14][9]=0.000158924;
  jer_param[14][10]=0;  jer_param_er[14][10]=0;
  jer_param[14][11]=0;  jer_param_er[14][11]=0;
  jer_param[14][12]=0;  jer_param_er[14][12]=0;

  if(i<15 && j<13)
    {
      if(code==0) value=jer_param[i][j];
      if(code==1) value=jer_param_er[i][j];
    }
  return value;
}

//________________ returns index for eta_bin in JER
int WhatJEReta(double eta_det)
{
  int eta_bin;
  for(int i=0; i<14; i++)
    {
      if(fabs(eta_det)>=i*0.2 && fabs(eta_det)<(i+1)*0.2)
	{
	  eta_bin=i;
	  break;
	}
    }
  if(fabs(eta_det)>=2.8) eta_bin=14;
  return eta_bin;
}

//_________________ returns mean of Gauss in JER: A0+A1*Pt+A2/E
double MyJer_meanG(double jet_E, double eta_det, int stat_code, int syst_code)
{
  int bin=WhatJEReta(eta_det);
  double p1=JERparam(0,bin,0);
  double p2=JERparam(0,bin,1);
  double p3=JERparam(0,bin,2);
  double val_err=0.0;
  double val=0.0;
  if(jet_E>0.0)
    {
      if(abs(syst_code)==1)
	{
	  double t1=JERparam(1,bin,0);
	  double t2=JERparam(1,bin,1)*jet_E;
	  double t3=JERparam(1,bin,2)/jet_E;
	  double t12=2.0*t1*t2*JERCorrCoeff(bin,0);
	  double t13=2.0*t1*t3*JERCorrCoeff(bin,1);
	  double t23=2.0*t2*t3*JERCorrCoeff(bin,2);
	  double t=t1*t1+t2*t2+t3*t3+t12+t13+t23;
	  if(t>0.0) val_err=(syst_code>0) ? sqrt(t) : -1.0*sqrt(t);
	}
      val=p1+p2*jet_E+p3/jet_E+val_err;
      if(val<-1.0 || val>5.0) val=0.0;
    }
  return val;
}
//_________________ returns sigma of Gauss in JER: sqrt(A3/E+A4)
double MyJer_sigmaG(double jet_E, double eta_det, int stat_code, int syst_code)
{
  int bin=WhatJEReta(eta_det);
  double p1=JERparam(0,bin,3);
  double p2=JERparam(0,bin,4);
  double val=0.0;
  double val_err=0.0;
  if(jet_E>0.0) 
    {
      val=p1/jet_E+p2;
      if(val>0.0)
	{
	  if(abs(syst_code)==2)
	    {
	      double t1=JERparam(1,bin,3)/jet_E;
	      double t2=JERparam(1,bin,4);
	      double t12=2.0*t1*t2*JERCorrCoeff(bin,3);
	      double t=0.25*(t1*t1+t2*t2+t12)/val;
	      if(t>0.0) val_err=(syst_code>0) ? sqrt(t) : -1.0*sqrt(t);
	    }
	  val=sqrt(val)+val_err;
	}
      if(val<0.0) val=0.0;
    }
  return val;
}
//_________________ returns mpv of Landau in JER: A5+A6*Pt+A7/E
double MyJer_mpvL(double jet_E, double eta_det, int stat_code, int syst_code)
{
  int bin=WhatJEReta(eta_det);
  double p1=JERparam(0,bin,5);
  double p2=JERparam(0,bin,6);
  double p3=JERparam(0,bin,7);
  double val_err=0.0;
  double val=0.0;
  if(jet_E>0.0)
    {
      if(abs(syst_code)==3)
	{
	  double t1=JERparam(1,bin,5);
	  double t2=JERparam(1,bin,6)*jet_E;
	  double t3=JERparam(1,bin,7)/jet_E;
	  double t12=2.0*t1*t2*JERCorrCoeff(bin,4);
	  double t13=2.0*t1*t3*JERCorrCoeff(bin,5);
	  double t23=2.0*t2*t3*JERCorrCoeff(bin,6);
	  double t=t1*t1+t2*t2+t3*t3+t12+t13+t23;
	  if(t>0.0) val_err=(syst_code>0) ? sqrt(t) : -1.0*sqrt(t);
	}
      val=p1+p2*jet_E+p3/jet_E+val_err;
      if(val<-1.0 || val>5.0) val=0.0;
    }
  return val;
}
//_________________ returns sigma of Landau in JER: sqrt(A8/E+A9)
double MyJer_sigmaL(double jet_E, double eta_det, int stat_code, int syst_code)
{
  int bin=WhatJEReta(eta_det);
  double p1=JERparam(0,bin,8);
  double p2=JERparam(0,bin,9);
  double val=0.0;
  double val_err=0.0;
  if(jet_E>0.0) 
    {
      val=p1/jet_E+p2;
      if(val>0.0)
	{
	  if(abs(syst_code)==4)
	    {
	      double t1=JERparam(1,bin,8)/jet_E;
	      double t2=JERparam(1,bin,9);
	      double t12=2.0*t1*t2*JERCorrCoeff(bin,7);
	      double t=0.25*(t1*t1+t2*t2+t12)/val;
	      if(t>0.0) val_err=(syst_code>0) ? sqrt(t) : -1.0*sqrt(t);
	    }
	  val=sqrt(val)+val_err;
	}
      if(val<0.0) val=0.0;
    }
  return val;
}

//_________________ returns normalization of Gauss: [A10+A11*sqrt(E)]/E+A12
double MyJer_normG(double jet_E, double eta_det, int stat_code, int syst_code)
{
  int bin=WhatJEReta(eta_det);
  double p1=JERparam(0,bin,10);
  double p2=JERparam(0,bin,11);
  double p3=JERparam(0,bin,12);
  double val=0.0;
  double val_err=0.0;
  if(jet_E>0.0) 
    {
      if(abs(syst_code)==5)
	{
	  double t1=JERparam(1,bin,10)/jet_E;
	  double t2=JERparam(1,bin,11)/sqrt(jet_E);
	  double t3=JERparam(1,bin,12);
	  double t12=2.0*t1*t2*JERCorrCoeff(bin,8);
	  double t13=2.0*t1*t3*JERCorrCoeff(bin,9);
	  double t23=2.0*t2*t3*JERCorrCoeff(bin,10);
	  double t=t1*t1+t2*t2+t3*t3+t12+t13+t23;
	  if(t>0.0) val_err=(syst_code>0) ? sqrt(t) : -1.0*sqrt(t);
	}
      val=(p1+p2*sqrt(jet_E))/jet_E+p3+val_err;
    }
  if(val<0.0) val=0.0;
  return val;
}

//___ generates Sigma and Mean for "unclustered" Met
//___ takes into account correlations between params
//___ systcode=0 -default param
//___ systcode=1 -choice of parameterization: Z->ee vs. dipho-sideband
//___ systcode=2(+/-) -Met Model Uncl. En. systematics: mean+/-G
//___ systcode=3(+/-) -Met Model Uncl. En. systematics: sigma+/-G
//___ systcode=4(+/-) -Met Model Uncl. En. systematics: scale+/-G
//___ systcode=5(+/-) -Met Model Uncl. En. systematics: norm+/-G   
void GetMyUnclMetResolution(double sumEt, int isData, int ParamSwitch, int systcode, 
			    double &sigmaMx, double &sigmaMy, double &meanMx, double &meanMy,
			    double &normX, double &normY, double &scaleX, double &scaleY) {
  
  double sigmaX_err=0.0;
  double meanX_err=0.0;
  double sigmaY_err=0.0;
  double meanY_err=0.0;
  double normX_err=0.0;
  double normY_err=0.0;
  double scaleX_err=0.0;
  double scaleY_err=0.0;
  double dummypar=0.0;

  if(sumEt<0.0) sumEt=0.0;

//--------------------------------------------------------------------------------
//_______________ ***** met model parametrization.
//                for MetX & MetY: sigma=p0+p1*sqrt(SumEt)
//                for MetX & MetY: mean=p0+p1*SumEt
//                first index is for di-pho sideband ([0]) & central Z->ee ([1]) parametrizations   
  double metmodel_sigmaX[2][2];    // sigmaX=p[0]+p[1]*sqrt(corrSumEt)
  double metmodel_sigmaX_er[2][2];
  double metmodel_sigmaY[2][2];    // sigmaY=p[0]+p[1]*sqrt(corrSumEt) 
  double metmodel_sigmaY_er[2][2];
  double metmodel_meanX[2][2];     // meanX=p[0]+p[1]*corrSumEt
  double metmodel_meanX_er[2][2];
  double metmodel_meanY[2][2];     // meanY=p[0]+p[1]*corrSumEt
  double metmodel_meanY_er[2][2];

  double metmodel_normX[2]; // normX=p[0]
  double metmodel_normX_er[2]; 
  double metmodel_normY[2]; // normY=p[0]
  double metmodel_normY_er[2]; 
  double metmodel_sigmaScaleX[2][2];    // sigmaScaleX=p[0]+p[1]*sqrt(corrSumEt)
  double metmodel_sigmaScaleX_er[2][2];
  double metmodel_sigmaScaleY[2][2];    // sigmaScaleY=p[0]+p[1]*sqrt(corrSumEt) 
  double metmodel_sigmaScaleY_er[2][2];

  //-------------- For unclustered MetModel with Njet(cut)=0
  double metmodel_sigmaXcorr[2]; // correlation coefficient for sigmaX
  double metmodel_sigmaYcorr[2]; // correlation coefficient for sigmaY
  double metmodel_meanXcorr[2]; // correlation coefficient for meanX
  double metmodel_meanYcorr[2]; // correlation coefficient for meanY
  double metmodel_sigmaScaleXcorr[2]; // correlation coefficient for sigmaScaleX
  double metmodel_sigmaScaleYcorr[2]; // correlation coefficient for sigmaScaleY

  if(isData==1)   //---------- Data 
    {
      //____________________________ Data di-pho sideband parameterization for events with Njet15 = 0
      //------------- parametrization after 09/12/07
      metmodel_sigmaX[0][0]=0.82;
      metmodel_sigmaX[0][1]=0.372;
      metmodel_sigmaX_er[0][0]=0.25;
      metmodel_sigmaX_er[0][1]=0.031;
      metmodel_sigmaY[0][0]=0.60;
      metmodel_sigmaY[0][1]=0.387;
      metmodel_sigmaY_er[0][0]=0.25;
      metmodel_sigmaY_er[0][1]=0.022;
      metmodel_meanX[0][0]=-0.022;
      metmodel_meanX[0][1]=0.00647;
      metmodel_meanX_er[0][0]=0.057;
      metmodel_meanX_er[0][1]=0.00076;
      metmodel_meanY[0][0]=-0.016;
      metmodel_meanY[0][1]=-0.00337;
      metmodel_meanY_er[0][0]=0.038;
      metmodel_meanY_er[0][1]=0.00033;
      
      metmodel_sigmaXcorr[0]=-0.911;
      metmodel_sigmaYcorr[0]=-0.906;
      metmodel_meanXcorr[0]=-0.814;
      metmodel_meanYcorr[0]=-0.764;
      
      metmodel_normX[0]=0.080;
      metmodel_normX_er[0]=0.022; 
      metmodel_normY[0]=0.147;
      metmodel_normY_er[0]=0.036; 
      metmodel_sigmaScaleX[0][0]=2.16;  
      metmodel_sigmaScaleX[0][1]=-0.064;
      metmodel_sigmaScaleX_er[0][0]=0.17;
      metmodel_sigmaScaleX_er[0][1]=0.020;
      metmodel_sigmaScaleY[0][0]=1.99; 
      metmodel_sigmaScaleY[0][1]=-0.046;
      metmodel_sigmaScaleY_er[0][0]=0.17;
      metmodel_sigmaScaleY_er[0][1]=0.020;
      metmodel_sigmaScaleXcorr[0]=-0.973;
      metmodel_sigmaScaleYcorr[0]=-0.976;
      
      //------------- Data Z->ee (CC) parameterization (as of 09/12/07)
      metmodel_sigmaX[1][0]=1.03;
      metmodel_sigmaX[1][1]=0.371;
      metmodel_sigmaX_er[1][0]=0.36;
      metmodel_sigmaX_er[1][1]=0.042;
      metmodel_sigmaY[1][0]=1.04;
      metmodel_sigmaY[1][1]=0.389;
      metmodel_sigmaY_er[1][0]=0.32;
      metmodel_sigmaY_er[1][1]=0.034;
      metmodel_meanX[1][0]=-0.048;
      metmodel_meanX[1][1]=0.00674;
      metmodel_meanX_er[1][0]=0.057;
      metmodel_meanX_er[1][1]=0.00073;
      metmodel_meanY[1][0]=-0.117;
      metmodel_meanY[1][1]=-0.00323;
      metmodel_meanY_er[1][0]=0.053;
      metmodel_meanY_er[1][1]=0.00073;
      
      metmodel_sigmaXcorr[1]=-0.921;
      metmodel_sigmaYcorr[1]=-0.903;
      metmodel_meanXcorr[1]=-0.774;
      metmodel_meanYcorr[1]=-0.827;
      
      metmodel_normX[1]=0.281;
      metmodel_normX_er[1]=0.076; 
      metmodel_normY[1]=0.235;
      metmodel_normY_er[1]=0.078; 
      metmodel_sigmaScaleX[1][0]=1.94;  
      metmodel_sigmaScaleX[1][1]=-0.051;
      metmodel_sigmaScaleX_er[1][0]=0.11;
      metmodel_sigmaScaleX_er[1][1]=0.013;
      metmodel_sigmaScaleY[1][0]=2.19; 
      metmodel_sigmaScaleY[1][1]=-0.079;
      metmodel_sigmaScaleY_er[1][0]=0.16;
      metmodel_sigmaScaleY_er[1][1]=0.019;
      metmodel_sigmaScaleXcorr[1]=-0.944;
      metmodel_sigmaScaleYcorr[1]=-0.965;
    }
  else //--------- MC 
    {
      if(ParamSwitch==0) // 0=dipho parametrization
	{
	  //____________________________ Pythia di-pho signal parametrization for events with Njet15 = 0
	  //------------- parametrization after 06/19/08 (new Pythia with Min Bias)
	  metmodel_sigmaX[0][0]=0.67;
	  metmodel_sigmaX[0][1]=0.385;
	  metmodel_sigmaX_er[0][0]=0.24;
	  metmodel_sigmaX_er[0][1]=0.028;
	  metmodel_sigmaY[0][0]=0.80;
	  metmodel_sigmaY[0][1]=0.364;
	  metmodel_sigmaY_er[0][0]=0.21;
	  metmodel_sigmaY_er[0][1]=0.024;
	  metmodel_meanX[0][0]=0.020;
	  metmodel_meanX[0][1]=0.00166;
	  metmodel_meanX_er[0][0]=0.023;
	  metmodel_meanX_er[0][1]=0.00032;
	  metmodel_meanY[0][0]=-0.012;
	  metmodel_meanY[0][1]=0.00004;
	  metmodel_meanY_er[0][0]=0.024;
	  metmodel_meanY_er[0][1]=0.00031;
	  
	  metmodel_sigmaXcorr[0]=-0.916;
	  metmodel_sigmaYcorr[0]=-0.912;
	  metmodel_meanXcorr[0]=-0.845;
	  metmodel_meanYcorr[0]=-0.870;
	  
	  metmodel_normX[0]=0.15;
	  metmodel_normX_er[0]=0.02; 
	  metmodel_normY[0]=0.122;
	  metmodel_normY_er[0]=0.018; 
	  metmodel_sigmaScaleX[0][0]=1.969;  
	  metmodel_sigmaScaleX[0][1]=-0.04819;
	  metmodel_sigmaScaleX_er[0][0]=0.072;
	  metmodel_sigmaScaleX_er[0][1]=0.0078;
	  metmodel_sigmaScaleY[0][0]=2.013; 
	  metmodel_sigmaScaleY[0][1]=-0.0515;
	  metmodel_sigmaScaleY_er[0][0]=0.075;
	  metmodel_sigmaScaleY_er[0][1]=0.0075;
	  metmodel_sigmaScaleXcorr[0]=-0.954;
	  metmodel_sigmaScaleYcorr[0]=-0.962;

	  //------------- Pythia Z->ee (CC) parametrization is the same as Pythia di-pho (for now)
	  metmodel_sigmaX[1][0]=0.67;
	  metmodel_sigmaX[1][1]=0.385;
	  metmodel_sigmaX_er[1][0]=0.24;
	  metmodel_sigmaX_er[1][1]=0.028;
	  metmodel_sigmaY[1][0]=0.80;
	  metmodel_sigmaY[1][1]=0.364;
	  metmodel_sigmaY_er[1][0]=0.21;
	  metmodel_sigmaY_er[1][1]=0.024;
	  metmodel_meanX[1][0]=0.020;
	  metmodel_meanX[1][1]=0.00166;
	  metmodel_meanX_er[1][0]=0.023;
	  metmodel_meanX_er[1][1]=0.00032;
	  metmodel_meanY[1][0]=-0.012;
	  metmodel_meanY[1][1]=0.00004;
	  metmodel_meanY_er[1][0]=0.024;
	  metmodel_meanY_er[1][1]=0.00031;
	  
	  metmodel_sigmaXcorr[1]=-0.916;
	  metmodel_sigmaYcorr[1]=-0.912;
	  metmodel_meanXcorr[1]=-0.845;
	  metmodel_meanYcorr[1]=-0.870;
	  
	  metmodel_normX[1]=0.15;
	  metmodel_normX_er[1]=0.02; 
	  metmodel_normY[1]=0.122;
	  metmodel_normY_er[1]=0.018; 
	  metmodel_sigmaScaleX[1][0]=1.969;  
	  metmodel_sigmaScaleX[1][1]=-0.04819;
	  metmodel_sigmaScaleX_er[1][0]=0.072;
	  metmodel_sigmaScaleX_er[1][1]=0.0078;
	  metmodel_sigmaScaleY[1][0]=2.013; 
	  metmodel_sigmaScaleY[1][1]=-0.0515;
	  metmodel_sigmaScaleY_er[1][0]=0.075;
	  metmodel_sigmaScaleY_er[1][1]=0.0075;
	  metmodel_sigmaScaleXcorr[1]=-0.954;
	  metmodel_sigmaScaleYcorr[1]=-0.962;

	}
      else // 1= cem-cem Z->ee parametrization
	{
	  //------------- Pythia Z->ee (CC) parametrization (as of 09/11/07: double Gaussian)
	  metmodel_sigmaX[1][0]=0.98;
	  metmodel_sigmaX[1][1]=0.457;
	  metmodel_sigmaX_er[1][0]=0.25;
	  metmodel_sigmaX_er[1][1]=0.027;
	  metmodel_sigmaY[1][0]=1.66;
	  metmodel_sigmaY[1][1]=0.367;
	  metmodel_sigmaY_er[1][0]=0.17;
	  metmodel_sigmaY_er[1][1]=0.027;
	  metmodel_meanX[1][0]=0.155;
	  metmodel_meanX[1][1]=0.00137;
	  metmodel_meanX_er[1][0]=0.020;
	  metmodel_meanX_er[1][1]=0.00035;
	  metmodel_meanY[1][0]=-0.179;
	  metmodel_meanY[1][1]=-0.00333;
	  metmodel_meanY_er[1][0]=0.026;
	  metmodel_meanY_er[1][1]=0.00044;
	  
	  metmodel_sigmaXcorr[1]=-0.893;
	  metmodel_sigmaYcorr[1]=-0.857;
	  metmodel_meanXcorr[1]=-0.857;
	  metmodel_meanYcorr[1]=-0.807;
	  
	  metmodel_normX[1]=0.110;
	  metmodel_normX_er[1]=0.025; 
	  metmodel_normY[1]=0.134;
	  metmodel_normY_er[1]=0.029; 
	  metmodel_sigmaScaleX[1][0]=1.755;  
	  metmodel_sigmaScaleX[1][1]=-0.046;
	  metmodel_sigmaScaleX_er[1][0]=0.091;
	  metmodel_sigmaScaleX_er[1][1]=0.011;
	  metmodel_sigmaScaleY[1][0]=1.697; 
	  metmodel_sigmaScaleY[1][1]=-0.035;
	  metmodel_sigmaScaleY_er[1][0]=0.083;
	  metmodel_sigmaScaleY_er[1][1]=0.011;
	  metmodel_sigmaScaleXcorr[1]=-0.966;
	  metmodel_sigmaScaleYcorr[1]=-0.961;
	  
	  //----------------------- di-pho papamertization for studies with Pythia Zee events
	  metmodel_sigmaX[0][0]=0.98;
	  metmodel_sigmaX[0][1]=0.457;
	  metmodel_sigmaX_er[0][0]=0.25;
	  metmodel_sigmaX_er[0][1]=0.027;
	  metmodel_sigmaY[0][0]=1.66;
	  metmodel_sigmaY[0][1]=0.367;
	  metmodel_sigmaY_er[0][0]=0.17;
	  metmodel_sigmaY_er[0][1]=0.027;
	  metmodel_meanX[0][0]=0.155;
	  metmodel_meanX[0][1]=0.00137;
	  metmodel_meanX_er[0][0]=0.020;
	  metmodel_meanX_er[0][1]=0.00035;
	  metmodel_meanY[0][0]=-0.179;
	  metmodel_meanY[0][1]=-0.00333;
	  metmodel_meanY_er[0][0]=0.026;
	  metmodel_meanY_er[0][1]=0.00044;
	  
	  metmodel_sigmaXcorr[0]=-0.893;
	  metmodel_sigmaYcorr[0]=-0.857;
	  metmodel_meanXcorr[0]=-0.857;
	  metmodel_meanYcorr[0]=-0.807;
	  
	  metmodel_normX[0]=0.110;
	  metmodel_normX_er[0]=0.025; 
	  metmodel_normY[0]=0.134;
	  metmodel_normY_er[0]=0.029; 
	  metmodel_sigmaScaleX[0][0]=1.755;  
	  metmodel_sigmaScaleX[0][1]=-0.046;
	  metmodel_sigmaScaleX_er[0][0]=0.091;
	  metmodel_sigmaScaleX_er[0][1]=0.011;
	  metmodel_sigmaScaleY[0][0]=1.697; 
	  metmodel_sigmaScaleY[0][1]=-0.035;
	  metmodel_sigmaScaleY_er[0][0]=0.083;
	  metmodel_sigmaScaleY_er[0][1]=0.011;
	  metmodel_sigmaScaleXcorr[0]=-0.966;
	  metmodel_sigmaScaleYcorr[0]=-0.961;
	}
    }

//___ systcode=4(+/-) -Met Model Uncl. En. systematics: scale+/-G
//___ systcode=5(+/-) -Met Model Uncl. En. systematics: norm+/-G   
//_____________________ systcode=0 -default param
  if(systcode==0) 
    {
      //___________ X-axis
      //-sigma
      sigmaMx=metmodel_sigmaX[ParamSwitch][0]+metmodel_sigmaX[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMx<0.0) sigmaMx=0.0;      
      //-mean
      meanMx=metmodel_meanX[ParamSwitch][0]+metmodel_meanX[ParamSwitch][1]*sumEt;
      //-norm
      normX=metmodel_normX[ParamSwitch];
      if(normX<0.0) normX=0.0;
      //-scale
      scaleX=metmodel_sigmaScaleX[ParamSwitch][0]+metmodel_sigmaScaleX[ParamSwitch][1]*sqrt(sumEt);
      if(scaleX<1.0) scaleX=1.0;
      //___________ Y-axis
      //-sigma
      sigmaMy=metmodel_sigmaY[ParamSwitch][0]+metmodel_sigmaY[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMy<0.0) sigmaMy=0.0;
      //-mean
      meanMy=metmodel_meanY[ParamSwitch][0]+metmodel_meanY[ParamSwitch][1]*sumEt;
      //-norm
      normY=metmodel_normY[ParamSwitch];
      if(normY<0.0) normY=0.0;
      //-scale
      scaleY=metmodel_sigmaScaleY[ParamSwitch][0]+metmodel_sigmaScaleY[ParamSwitch][1]*sqrt(sumEt);
      if(scaleY<1.0) scaleY=1.0;
    }
  //________________________ systcode=1 -choice of parameterization: Z->ee vs. dipho-sideband
  if(abs(systcode)==1)
    {
      //___________ X-axis
      //-sigma
      sigmaMx=metmodel_sigmaX[1-ParamSwitch][0]+metmodel_sigmaX[1-ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMx<0.0) sigmaMx=0.0;      
      //-mean
      meanMx=metmodel_meanX[1-ParamSwitch][0]+metmodel_meanX[1-ParamSwitch][1]*sumEt;
      //-norm
      normX=metmodel_normX[1-ParamSwitch];
      if(normX<0.0) normX=0.0;
      //-scale
      scaleX=metmodel_sigmaScaleX[1-ParamSwitch][0]+metmodel_sigmaScaleX[1-ParamSwitch][1]*sqrt(sumEt);
      if(scaleX<1.0) scaleX=1.0;
      //___________ Y-axis
      //-sigma
      sigmaMy=metmodel_sigmaY[1-ParamSwitch][0]+metmodel_sigmaY[1-ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMy<0.0) sigmaMy=0.0;
      //-mean
      meanMy=metmodel_meanY[1-ParamSwitch][0]+metmodel_meanY[1-ParamSwitch][1]*sumEt;
      //-norm
      normY=metmodel_normY[1-ParamSwitch];
      if(normY<0.0) normY=0.0;
      //-scale
      scaleY=metmodel_sigmaScaleY[1-ParamSwitch][0]+metmodel_sigmaScaleY[1-ParamSwitch][1]*sqrt(sumEt);
      if(scaleY<1.0) scaleY=1.0;
    }
  
  //___________________ calculating systematics
  if(abs(systcode)>1)
    {
      //___________ X-axis
      //-sigma
      dummypar=metmodel_sigmaX_er[ParamSwitch][0]*metmodel_sigmaX_er[ParamSwitch][0]
	+ metmodel_sigmaX_er[ParamSwitch][1]*metmodel_sigmaX_er[ParamSwitch][1]*sumEt
	+ 2.0*metmodel_sigmaXcorr[ParamSwitch]*metmodel_sigmaX_er[ParamSwitch][0]*metmodel_sigmaX_er[ParamSwitch][1]*sqrt(sumEt);
      if(dummypar<0.0) dummypar=0.0;
      sigmaX_err=sqrt(dummypar);
      //-mean
      dummypar=metmodel_meanX_er[ParamSwitch][0]*metmodel_meanX_er[ParamSwitch][0]
	+ metmodel_meanX_er[ParamSwitch][1]*metmodel_meanX_er[ParamSwitch][1]*sumEt*sumEt
	+ 2.0*metmodel_meanXcorr[ParamSwitch]*metmodel_meanX_er[ParamSwitch][0]*metmodel_meanX_er[ParamSwitch][1]*sumEt;
      if(dummypar<0.0) dummypar=0.0;
      meanX_err=sqrt(dummypar);
      //-norm
      dummypar=metmodel_normX_er[ParamSwitch]*metmodel_normX_er[ParamSwitch];
      normX_err=sqrt(dummypar);
      //-scale
      dummypar=metmodel_sigmaScaleX_er[ParamSwitch][0]*metmodel_sigmaScaleX_er[ParamSwitch][0]
	+ metmodel_sigmaScaleX_er[ParamSwitch][1]*metmodel_sigmaScaleX_er[ParamSwitch][1]*sumEt
	+ 2.0*metmodel_sigmaScaleXcorr[ParamSwitch]*metmodel_sigmaScaleX_er[ParamSwitch][0]*metmodel_sigmaScaleX_er[ParamSwitch][1]*sqrt(sumEt);
      if(dummypar<0.0) dummypar=0.0;
      scaleX_err=sqrt(dummypar);
      //___________ Y-axis
      //-sigma
      dummypar=metmodel_sigmaY_er[ParamSwitch][0]*metmodel_sigmaY_er[ParamSwitch][0]
	+ metmodel_sigmaY_er[ParamSwitch][1]*metmodel_sigmaY_er[ParamSwitch][1]*sumEt
	+ 2.0*metmodel_sigmaYcorr[ParamSwitch]*metmodel_sigmaY_er[ParamSwitch][0]*metmodel_sigmaY_er[ParamSwitch][1]*sqrt(sumEt);
      if(dummypar<0.0) dummypar=0.0;
      sigmaY_err=sqrt(dummypar);
      //-mean
      dummypar=metmodel_meanY_er[ParamSwitch][0]*metmodel_meanY_er[ParamSwitch][0]
	+ metmodel_meanY_er[ParamSwitch][1]*metmodel_meanY_er[ParamSwitch][1]*sumEt*sumEt
	+ 2.0*metmodel_meanYcorr[ParamSwitch]*metmodel_meanY_er[ParamSwitch][0]*metmodel_meanY_er[ParamSwitch][1]*sumEt;
      if(dummypar<0.0) dummypar=0.0;
      meanY_err=sqrt(dummypar);  
      //-norm
      dummypar=metmodel_normY_er[ParamSwitch]*metmodel_normY_er[ParamSwitch];
      normY_err=sqrt(dummypar);
      //-scale
      dummypar=metmodel_sigmaScaleY_er[ParamSwitch][0]*metmodel_sigmaScaleY_er[ParamSwitch][0]
	+ metmodel_sigmaScaleY_er[ParamSwitch][1]*metmodel_sigmaScaleY_er[ParamSwitch][1]*sumEt
	+ 2.0*metmodel_sigmaScaleYcorr[ParamSwitch]*metmodel_sigmaScaleY_er[ParamSwitch][0]*metmodel_sigmaScaleY_er[ParamSwitch][1]*sqrt(sumEt);
      if(dummypar<0.0) dummypar=0.0;
      scaleY_err=sqrt(dummypar);
    }
  //____________________ systcode=2(+/-) -Met Model Uncl. En. systematics: mean+/-G
  if(abs(systcode)==2)
    {
      int int_systcode=(systcode>0) ? 1 : -1 ;
      //___________ X-axis
      //-sigma
      sigmaMx=metmodel_sigmaX[ParamSwitch][0]+metmodel_sigmaX[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMx<0.0) sigmaMx=0.0;      
      //-mean
      meanMx=metmodel_meanX[ParamSwitch][0]+metmodel_meanX[ParamSwitch][1]*sumEt+int_systcode*meanX_err;
      //-norm
      normX=metmodel_normX[ParamSwitch];
      if(normX<0.0) normX=0.0;
      //-scale
      scaleX=metmodel_sigmaScaleX[ParamSwitch][0]+metmodel_sigmaScaleX[ParamSwitch][1]*sqrt(sumEt);
      if(scaleX<1.0) scaleX=1.0;
      //___________ Y-axis
      //-sigma
      sigmaMy=metmodel_sigmaY[ParamSwitch][0]+metmodel_sigmaY[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMy<0.0) sigmaMy=0.0;
      //-mean
      meanMy=metmodel_meanY[ParamSwitch][0]+metmodel_meanY[ParamSwitch][1]*sumEt+int_systcode*meanY_err;
      //-norm
      normY=metmodel_normY[ParamSwitch];
      if(normY<0.0) normY=0.0;
      //-scale
      scaleY=metmodel_sigmaScaleY[ParamSwitch][0]+metmodel_sigmaScaleY[ParamSwitch][1]*sqrt(sumEt);
      if(scaleY<1.0) scaleY=1.0;
    }
  //____________________ systcode=3(+/-) -Met Model Uncl. En. systematics: sigma+/-G
  if(abs(systcode)==3)
    {
      int int_systcode=(systcode>0) ? 1 : -1 ;
      //___________ X-axis
      //-sigma
      sigmaMx=metmodel_sigmaX[ParamSwitch][0]+metmodel_sigmaX[ParamSwitch][1]*sqrt(sumEt)+int_systcode*sigmaX_err;
      if(sigmaMx<0.0) sigmaMx=0.0;      
      //-mean
      meanMx=metmodel_meanX[ParamSwitch][0]+metmodel_meanX[ParamSwitch][1]*sumEt;
      //-norm
      normX=metmodel_normX[ParamSwitch];
      if(normX<0.0) normX=0.0;
      //-scale
      scaleX=metmodel_sigmaScaleX[ParamSwitch][0]+metmodel_sigmaScaleX[ParamSwitch][1]*sqrt(sumEt);
      if(scaleX<1.0) scaleX=1.0;
      //___________ Y-axis
      //-sigma
      sigmaMy=metmodel_sigmaY[ParamSwitch][0]+metmodel_sigmaY[ParamSwitch][1]*sqrt(sumEt)+int_systcode*sigmaY_err;
      if(sigmaMy<0.0) sigmaMy=0.0;
      //-mean
      meanMy=metmodel_meanY[ParamSwitch][0]+metmodel_meanY[ParamSwitch][1]*sumEt;
      //-norm
      normY=metmodel_normY[ParamSwitch];
      if(normY<0.0) normY=0.0;
      //-scale
      scaleY=metmodel_sigmaScaleY[ParamSwitch][0]+metmodel_sigmaScaleY[ParamSwitch][1]*sqrt(sumEt);
      if(scaleY<1.0) scaleY=1.0;
    }
  //____________________ systcode=4(+/-) -Met Model Uncl. En. systematics: scale+/-G
  if(abs(systcode)==4)
    {
      int int_systcode=(systcode>0) ? 1 : -1 ;
      //___________ X-axis
      //-sigma
      sigmaMx=metmodel_sigmaX[ParamSwitch][0]+metmodel_sigmaX[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMx<0.0) sigmaMx=0.0;      
      //-mean
      meanMx=metmodel_meanX[ParamSwitch][0]+metmodel_meanX[ParamSwitch][1]*sumEt;
      //-norm
      normX=metmodel_normX[ParamSwitch];
      if(normX<0.0) normX=0.0;
      //-scale
      scaleX=metmodel_sigmaScaleX[ParamSwitch][0]+metmodel_sigmaScaleX[ParamSwitch][1]*sqrt(sumEt)+int_systcode*scaleX_err;
      if(scaleX<1.0) scaleX=1.0;
      //___________ Y-axis
      //-sigma
      sigmaMy=metmodel_sigmaY[ParamSwitch][0]+metmodel_sigmaY[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMy<0.0) sigmaMy=0.0;
      //-mean
      meanMy=metmodel_meanY[ParamSwitch][0]+metmodel_meanY[ParamSwitch][1]*sumEt;
      //-norm
      normY=metmodel_normY[ParamSwitch];
      if(normY<0.0) normY=0.0;
      //-scale
      scaleY=metmodel_sigmaScaleY[ParamSwitch][0]+metmodel_sigmaScaleY[ParamSwitch][1]*sqrt(sumEt)+int_systcode*scaleY_err;
      if(scaleY<1.0) scaleY=1.0;
    }
  //____________________ systcode=5(+/-) -Met Model Uncl. En. systematics: scale+/-G
  if(abs(systcode)==5)
    {
      int int_systcode=(systcode>0) ? 1 : -1 ;
      //___________ X-axis
      //-sigma
      sigmaMx=metmodel_sigmaX[ParamSwitch][0]+metmodel_sigmaX[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMx<0.0) sigmaMx=0.0;      
      //-mean
      meanMx=metmodel_meanX[ParamSwitch][0]+metmodel_meanX[ParamSwitch][1]*sumEt;
      //-norm
      normX=metmodel_normX[ParamSwitch]+int_systcode*normX_err;
      if(normX<0.0) normX=0.0;
      //-scale
      scaleX=metmodel_sigmaScaleX[ParamSwitch][0]+metmodel_sigmaScaleX[ParamSwitch][1]*sqrt(sumEt);
      if(scaleX<1.0) scaleX=1.0;
      //___________ Y-axis
      //-sigma
      sigmaMy=metmodel_sigmaY[ParamSwitch][0]+metmodel_sigmaY[ParamSwitch][1]*sqrt(sumEt);
      if(sigmaMy<0.0) sigmaMy=0.0;
      //-mean
      meanMy=metmodel_meanY[ParamSwitch][0]+metmodel_meanY[ParamSwitch][1]*sumEt;
      //-norm
      normY=metmodel_normY[ParamSwitch]+int_systcode*normY_err;
      if(normY<0.0) normY=0.0;
      //-scale
      scaleY=metmodel_sigmaScaleY[ParamSwitch][0]+metmodel_sigmaScaleY[ParamSwitch][1]*sqrt(sumEt);
      if(scaleY<1.0) scaleY=1.0;
    }
  return;
}

//=====================================================================
//-------------- raw MetSig fit function: p0*exp(-p1*x+p2*x*x)+p3*exp(-p4*x)
double rawMetSigFunc(double *x, double *par)
{
  double fitval=0.0;
  if(x[0]>0.0)
    {
      fitval=par[0]*exp(-1.0*par[1]*x[0]+par[2]*x[0]*x[0])+par[3]*exp(-1.0*par[4]*x[0]);
    }
  else fitval=-1.0E6;
  return fitval;
}


// ClassImp(TMyJetFilterModule)
//_____________________________________________________________________________
TMyJetFilterModule::TMyJetFilterModule(const char* name, const char* title):
  TStnModule(name,title)
{

  fUnclParamSwitch=0; // 0=sideband (default); 1=Z->ee unclustered energy parametrizations

  Npoints=1; // number of random points to generate

//______________________________________ setting default cut values
  fEventWeight=1.0; // event weight for background samples
  fUseEventWeight=0; // code to turn ON/OFF event weight
  fAnalysisMode=0; // 0==OFF, 1==ON
  fUseVerbose=0;
  fDumpEvent=0;
  fSampleID=0; // need to set it from *.C script
  fJetAlgo=0;      // by default it's JetClu(0.4)
  fMyMetScenario=3; // by default met is corrected for jets with Et>15
  MetToy_max=200.0; // max value of toy Met 
  MetToy_min=0.0; // min value of toy Met
  fSelectSigMetEvent=0; // 0= do nothing; -1=reject event; 1=select event
  fMetSig_cut=4.0; // MetSig=4.0 by default (i.e., 10E-4 events with fake MET to be selected for true MetSig)

  MinEtThr=15.0; 
  MaxEtThr=1000.0; 
  MinNjetThr=0; 
  MaxNjetThr=100; 
  MinJetEta=0.0; 
  MaxJetEta=3.0;
  MinEt1st=0.0; 
  MaxEt1st=1000.0;
  MinEt2nd=0.0;
  MaxEt2nd=1000.0;
  MinDeltaRgjMin=0.0;
  MaxDeltaRgjMin=1.0E6; 
  MinDeltaEtagjMin=0.0;
  MaxDeltaEtagjMin=1.0E6; 
  MinDeltaPhigjMin=0.0;
  MaxDeltaPhigjMin=1.0E6; 
  MinDeltaRgj=0.0;
  MaxDeltaRgj=1.0E6; 
  MinDeltaEtagj=0.0; 
  MaxDeltaEtagj=1.0E6; 
  MinDeltaPhigj=0.0; 
  MaxDeltaPhigj=1.0E6; 
//   MinDeltaPhiJMet=0.056*2.0*asin(1.0); // ~10 degrees
//   MaxDeltaPhiJMet=0.944*2.0*asin(1.0); // ~170 degrees
  MinDeltaPhiJMet=-10.0;
  MaxDeltaPhiJMet=0.3;
  MinMet2Et=0.0;
  MaxMet2Et=1.0E6;
  MinMet2Etlev6=0.0;
  MaxMet2Etlev6=1.0E6;
  MindZ=0.0;
  MaxdZ=1.0E6;
  MinMjj=0.0;
  MaxMjj=1.0E6;
  MinMj1g1=0.0;
  MaxMj1g1=1.0E6;
  MinMj1g2=0.0;
  MaxMj1g2=1.0E6;
  MinMj2g1=0.0;
  MaxMj2g1=1.0E6;
  MinMj2g2=0.0;
  MaxMj2g2=1.0E6;
  MinMjg=0.0;
  MaxMjg=1.0E6; 
  MinQtJet=0.0;
  MaxQtJet=1.0E6;
  MinHt=0.0;
  MaxHt=1.0E6;
  MinNjet=0;
  MaxNjet=100;
  MinNjet5=0;
  MaxNjet5=100;
  MinNjet10=0;
  MaxNjet10=100;
  MinNjet15=0;
  MaxNjet15=100;
  MinNjet20=0;
  MaxNjet20=100;
  MinNjet25=0;
  MaxNjet25=100;
  fSelectMetEvent=0; // 0=no selection; 1=select events
  fSelectExoticEvent=0; // 0=no selection; 1=select events
  fRemoveDuplicate=0; // 0=no selection; 1=remove events; -1=select event
  fRemoveBadMet=0; // 0=do nothing; 1=remove event; -1=select event  
  fDoVxSwap=0; // 0=do nothing; 1= swap vertices to minimize MET
  //________________________
  //________________________
  fDatFileName="results/MyJetFilter_output.dat";
  fRearEventFileName="results/exoticEventList.dat";
  fExoticEventFileName="results/veryExoticEventList.dat";
  fLargeMetEventFileName="results/largeMetEventList.dat";
  fDumpEventFileName="results/dumpEvent.dat";
  //________________________
  fJTC_coneSize=1;  // JetClue R=0.7
  fJTC_version=5;   // version of correction, suggested by Anwar for 5.3.1, may change later
  fJTC_level=7;     // full correction
  fJTC_systcode=0;  // default correction
  fJTC_imode=1;     // DATA is default

  //______________ GMSB stuff
  fSelectGMSBevent=0; // 0= do nothing; -1=reject event; 1=select event
  GMSBcut_Et1pho[0]=40.0; // Njet15=0
  GMSBcut_Et1pho[1]=40.0; // Njet15=1
  GMSBcut_Et1pho[2]=40.0; // Njet15>1
  GMSBcut_Ht[0]=175.0; // Njet15=0
  GMSBcut_Ht[1]=175.0; // Njet15=1
  GMSBcut_Ht[2]=175.0; // Njet15>1
  GMSBcut_metsig[0]=9.0; // Njet15=0
  GMSBcut_metsig[1]=4.0; // Njet15=1
  GMSBcut_metsig[2]=3.0; // Njet15>1
  GMSBcut_dPhi0[0]=10.0; // Njet15=0, by default "pass all"
  GMSBcut_dPhi0[1]=10.0; // Njet15=1, by default "pass all"
  GMSBcut_dPhi0[2]=10.0; // Njet15>1, by default "pass all"
  GMSBcut_dPhi2[0]=0.0; // Njet15=0, by default "pass all"
  GMSBcut_dPhi2[1]=0.0; // Njet15=1, by default "pass all"
  GMSBcut_dPhi2[2]=0.0; // Njet15>1, by default "pass all"

  std::cout<<"Hi, entering TMyJetFilterModule"<<std::endl;
}

//_____________________________________________________________________________
TMyJetFilterModule::~TMyJetFilterModule() {
}

//_____________________________________________________________________________
void TMyJetFilterModule::BookHistograms() {
  char folder_name[200];
  TFolder* fol;
  TFolder* hist_folder;

  //-----------------------------------------------------------------------------
  //  clear the histogram list
  //-----------------------------------------------------------------------------
  DeleteHistograms();
  hist_folder = (TFolder*) GetFolder()->FindObject("Hist");

  //------ booking generic histograms

  sprintf(folder_name,"JetClu-0.4"); //----- Cone 0.4
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookJetHistograms(fHistJet04,Form("Hist/%s",folder_name),folder_name); 

  //------ booking matching histograms
  sprintf(folder_name,"MatchPhoJet0.4"); //----- Cone 0.4
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookMatchStudyHistograms(fMatchPhoJet04,Form("Hist/%s",folder_name),folder_name);

  sprintf(folder_name,"VxMetStudy0.4"); //----- Cone 0.4, effect of wrong vertex on MET
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookVxMetStudyHistograms(fVxMetStudy,Form("Hist/%s",folder_name));

  if(fAnalysisMode==1)
    {
      //________________ data
      sprintf(folder_name,"Ana_data");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_data,Form("Hist/%s",folder_name));

      //________________ Met Model total prediction (stat+syst)
      sprintf(folder_name,"Ana_bckg");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_bckg,Form("Hist/%s",folder_name));
      //________________ Met Model default prediction
      sprintf(folder_name,"Ana_def");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_def,Form("Hist/%s",folder_name));
      //________________ Met Model systematics: z->ee vs. dipho sideband parameterization
      sprintf(folder_name,"Ana_ue1");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue1,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: mean-G
      sprintf(folder_name,"Ana_ue2");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue2,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: mean+G
      sprintf(folder_name,"Ana_ue3");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue3,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: sigma-G
      sprintf(folder_name,"Ana_ue4");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue4,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: sigma+G
      sprintf(folder_name,"Ana_ue5");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue5,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: scale-G
      sprintf(folder_name,"Ana_ue6");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue6,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: scale+G
      sprintf(folder_name,"Ana_ue7");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue7,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: norm-G
      sprintf(folder_name,"Ana_ue8");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue8,Form("Hist/%s",folder_name));
      //________________ Met Model Uncl. En. systematics: norm+G
      sprintf(folder_name,"Ana_ue9");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_ue9,Form("Hist/%s",folder_name));


      //________________ Met Model JER systematics: meanG-G
      sprintf(folder_name,"Ana_jer1");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer1,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: meanG+G
      sprintf(folder_name,"Ana_jer2");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer2,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: sigmaG-G
      sprintf(folder_name,"Ana_jer3");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer3,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: sigmaG+G
      sprintf(folder_name,"Ana_jer4");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer4,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: mpvG-G
      sprintf(folder_name,"Ana_jer5");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer5,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: mpvG+G
      sprintf(folder_name,"Ana_jer6");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer6,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: sigmaL-G
      sprintf(folder_name,"Ana_jer7");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer7,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: sigmaL+G
      sprintf(folder_name,"Ana_jer8");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer8,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: norm-G
      sprintf(folder_name,"Ana_jer9");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer9,Form("Hist/%s",folder_name));
      //________________ Met Model JER systematics: norm+G
      sprintf(folder_name,"Ana_jer10");
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookAnalysisHistograms(fAna_jer10,Form("Hist/%s",folder_name));

      if(fUseEventWeight==1) 
	{
	  FinalAnalysisHistoStep1(fAna_data);
	  FinalAnalysisHistoStep1(fAna_def);
	}
    }
  else
    {
      //_______________________ booking met study histograms
      //----- Cone 0.4, Et>15
      sprintf(folder_name,"METJetClu0.4_scen3"); 
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookMetStudyHistograms(fMetStudyJet04sc3,Form("Hist/%s",folder_name),folder_name);
      //------- booking X-section histograms
      sprintf(folder_name,"Xsection0.4"); //----- Cone 0.4
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookXsecStudyHistograms(fDiphoXsec,Form("Hist/%s",folder_name),folder_name);
      
      //------- booking met cleanup histograms
      sprintf(folder_name,"MetCleanup0.4"); //----- Cone 0.4
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookMetCleanupHistograms(fCleanup,Form("Hist/%s",folder_name),folder_name);
      
      //------- booking generated met cleanup histograms
      sprintf(folder_name,"GenMetCleanup0.4"); //----- Cone 0.4, default MetModel
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookMetCleanupHistograms(fGenCleanup,Form("Hist/%s",folder_name),folder_name);

      sprintf(folder_name,"PhoMetStudy0.4"); //----- Cone 0.4, correlation between Photon and MET
      fol = (TFolder*) hist_folder->FindObject(folder_name);
      if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
      BookPhoMetStudyHistograms(fPhoMetStudy,Form("Hist/%s",folder_name));      
    }

  return;
}

//______________________ Booking final analysis histograms
void TMyJetFilterModule::BookAnalysisHistograms(AnalysisHisto_t& Hist, const char* Folder) 
{
  char name [200];
  char title[200];

  sprintf(name,"MetAll");
  sprintf(title,"#slash{E}_{T}, all events");
  Hist.fAna_MetAll=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_MetAll,Folder);
  sprintf(name,"MetSig");
  sprintf(title,"#slash{E}_{T}-significance, all events");
  Hist.fAna_MetSig=new TH1F(name,title,200,0.0,20.0);
  AddHistogram(Hist.fAna_MetSig,Folder);

    // the following histrograms are only for events that pass MetSig cut
  sprintf(name,"Met");
  sprintf(title,"#slash{E}_{T}, after cuts");
  Hist.fAna_Met=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Met,Folder);
  sprintf(name,"M");
  sprintf(title,"Mass of two leading EM objects, after cuts");
  Hist.fAna_M=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_M,Folder);
  sprintf(name,"dPhi");
  sprintf(title,"#Delta#phi of two leading EM objects, after cuts");          
  Hist.fAna_dPhi= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi,Folder);
  sprintf(name,"Njet15");
  sprintf(title,"N_{jet}(E_{T}^{jet}>15 GeV), after cuts");          
  Hist.fAna_Njet15= new TH1F(name,title,21,-0.5,20.5);          
  AddHistogram(Hist.fAna_Njet15,Folder);
  sprintf(name,"Njet20");
  sprintf(title,"N_{jet}(E_{T}^{jet}>20 GeV), after cuts");          
  Hist.fAna_Njet20= new TH1F(name,title,21,-0.5,20.5);          
  AddHistogram(Hist.fAna_Njet20,Folder);
  sprintf(name,"Njet25");
  sprintf(title,"N_{jet}(E_{T}^{jet}>25 GeV), after cuts");          
  Hist.fAna_Njet25= new TH1F(name,title,21,-0.5,20.5);          
  AddHistogram(Hist.fAna_Njet25,Folder);
  sprintf(name,"Qt");
  sprintf(title,"Q_{T} of two leading EM objects, after cuts");
  Hist.fAna_Qt=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Qt,Folder);
  sprintf(name,"Et1");
  sprintf(title,"E_{T} of 1^{st} EM object, after cuts");
  Hist.fAna_Et1=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Et1,Folder);
  sprintf(name,"Et2");
  sprintf(title,"E_{T} of 2^{nd} EM object, after cuts");
  Hist.fAna_Et2=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Et2,Folder);
  sprintf(name,"Etjet");
  sprintf(title,"E_{T} of 1^{st} jet, after cuts");
  Hist.fAna_Etjet=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Etjet,Folder);
  sprintf(name,"Ht");
  sprintf(title,"H_{T}, after cuts");
  Hist.fAna_Ht=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Ht,Folder);
  sprintf(name,"Mjj");
  sprintf(title,"M_{jj}-- mass of two leading jets, after cuts");
  Hist.fAna_Mjj=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Mjj,Folder);
  sprintf(name,"Nem");
  sprintf(title,"N_{em}-- number of EM objects (e/#gamma), after cuts");          
  Hist.fAna_Nem= new TH1F(name,title,11,-0.5,10.5);          
  AddHistogram(Hist.fAna_Nem,Folder);
  sprintf(name,"Mej");
  sprintf(title,"M_{em-jet}, after cuts");
  Hist.fAna_Mej=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Mej,Folder);
  sprintf(name,"Mextra");
  sprintf(title,"M_{emL-emE}-- mass of leadingEM-extraEM if N_{em}>2, after cuts");
  Hist.fAna_Mextra=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Mextra,Folder);
  sprintf(name,"Etem");
  sprintf(title,"E_{T} of extra EM objects, after cuts");
  Hist.fAna_Etem=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fAna_Etem,Folder);
  sprintf(name,"dPhi1");
  sprintf(title,"#Delta#phi(#slash{E}_{T}-em1), after cuts");          
  Hist.fAna_dPhi1= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi1,Folder);
  sprintf(name,"dPhi2");
  sprintf(title,"#Delta#phi(#slash{E}_{T}-em2), after cuts");          
  Hist.fAna_dPhi2= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi2,Folder);
  sprintf(name,"dPhi3");
  sprintf(title,"#Delta#phi(#slash{E}_{T}-jet1) if E_{T}^{jet}>15 GeV, after cuts");          
  Hist.fAna_dPhi3= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi3,Folder);
  sprintf(name,"dPhi4");
  sprintf(title,"#Delta#phi(#slash{E}_{T}-jet1) if E_{T}^{jet}>20 GeV, after cuts");          
  Hist.fAna_dPhi4= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi4,Folder);
  sprintf(name,"dPhi5");
  sprintf(title,"#Delta#phi(#slash{E}_{T}-jet1) if E_{T}^{jet}>25 GeV, after cuts");          
  Hist.fAna_dPhi5= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi5,Folder);
  sprintf(name,"dPhi6");
  sprintf(title,"(#Delta#phi(#slash{E}_{T}-#gamma1)+#Delta#phi(#slash{E}_{T}-#gamma2)+#Delta#phi(#gamma#gamma))-2#pi , after cuts");          
  Hist.fAna_dPhi6= new TH1F(name,title,100,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_dPhi6,Folder);


  sprintf(name,"Ht2Et1");
  sprintf(title,"H_{T}/E_{T}^{#gamma1}");          
  Hist.fAna_Ht2Et1= new TH1F(name,title,100,0.0,10.0);          
  AddHistogram(Hist.fAna_Ht2Et1,Folder);

  sprintf(name,"Ht2Et1_vs_Ht");
  sprintf(title,"H_{T}/E_{T}^{#gamma1} vs. H_{T}");          
  Hist.fAna_Ht2Et1_vs_Ht= new TH2F(name,title,50,0.0,1000.0,50,0.0,10.0);          
  AddHistogram(Hist.fAna_Ht2Et1_vs_Ht,Folder);
  sprintf(name,"Ht2Et1_vs_dPhi");
  sprintf(title,"H_{T}/E_{T}^{#gamma1} vs. #Delta#phi_{#gamma1,#gamma2}");          
  Hist.fAna_Ht2Et1_vs_dPhi= new TH2F(name,title,31,0.0,TMath::Pi(),50,0.0,10.0);          
  AddHistogram(Hist.fAna_Ht2Et1_vs_dPhi,Folder);
  sprintf(name,"Ht2Et1_vs_dPhi2");
  sprintf(title,"H_{T}/E_{T}^{#gamma1} vs. #Delta#phi_{#slash{E}_{T},#gamma2}");          
  Hist.fAna_Ht2Et1_vs_dPhi2= new TH2F(name,title,31,0.0,TMath::Pi(),50,0.0,10.0);          
  AddHistogram(Hist.fAna_Ht2Et1_vs_dPhi2,Folder);
  sprintf(name,"Et1_vs_Ht");
  sprintf(title,"H_{T} vs. E_{T}^{#gamma1}");          
  Hist.fAna_Et1_vs_Ht= new TH2F(name,title,100,0.0,1000.0,50,0.0,1000.0);          
  AddHistogram(Hist.fAna_Et1_vs_Ht,Folder);
  sprintf(name,"Et1_vs_dPhi");
  sprintf(title,"#Delta#phi_{#gamma1,#gamma2} vs. E_{T}^{#gamma1}");          
  Hist.fAna_Et1_vs_dPhi= new TH2F(name,title,100,0.0,1000.0,31,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_Et1_vs_dPhi,Folder);
  sprintf(name,"Et1_vs_dPhi2");
  sprintf(title,"#Delta#phi_{#slash{E}_{T},#gamma2} vs. E_{T}^{#gamma1}");          
  Hist.fAna_Et1_vs_dPhi2= new TH2F(name,title,100,0.0,1000.0,31,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_Et1_vs_dPhi2,Folder);
  sprintf(name,"Ht_vs_dPhi");
  sprintf(title,"#Delta#phi_{#gamma1,#gamma2} vs. H_{T}");          
  Hist.fAna_Ht_vs_dPhi= new TH2F(name,title,50,0.0,1000.0,31,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_Ht_vs_dPhi,Folder);
  sprintf(name,"Ht_vs_dPhi2");
  sprintf(title,"#Delta#phi_{#slash{E}_{T},#gamma2} vs. H_{T}");          
  Hist.fAna_Ht_vs_dPhi2= new TH2F(name,title,50,0.0,1000.0,31,0.0,TMath::Pi());          
  AddHistogram(Hist.fAna_Ht_vs_dPhi2,Folder);
  sprintf(name,"dPhi_vs_dPhi2");
  sprintf(title,"#Delta#phi_{#gamma1,#gamma2} vs. #Delta#phi_{#slash{E}_{T},#gamma2}");
  Hist.fAna_dPhi_vs_dPhi2= new TH2F(name,title,31,0.0,TMath::Pi(),31,0.0,TMath::Pi());
  AddHistogram(Hist.fAna_dPhi_vs_dPhi2,Folder);
  sprintf(name,"dPhi_vs_dPhi1");
  sprintf(title,"#Delta#phi_{#gamma1,#gamma2} vs. #Delta#phi_{#slash{E}_{T},#gamma1}");
  Hist.fAna_dPhi_vs_dPhi1= new TH2F(name,title,31,0.0,TMath::Pi(),31,0.0,TMath::Pi());
  AddHistogram(Hist.fAna_dPhi_vs_dPhi1,Folder);
  sprintf(name,"MetSig_vs_dPhi");
  sprintf(title,"#Delta#phi_{#gamma1,#gamma2} vs. MetSig");
  Hist.fAna_MetSig_vs_dPhi= new TH2F(name,title,200,0.0,20.0,31,0.0,TMath::Pi());
  AddHistogram(Hist.fAna_MetSig_vs_dPhi,Folder);
  return;
}


//______________________ Booking general jet histograms
void TMyJetFilterModule::BookJetHistograms(JetGeneral_t& Hist, const char* Folder, const char* algoname) {
  char name [200];
  char title[200];
  // book histograms

  sprintf(name,"toyMET_all");
  sprintf(title,"#slash{E}_{T}^{toy}, all events");
  Hist.fEvnt_toyMET_all=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fEvnt_toyMET_all,Folder);
  sprintf(name,"toyMET_cut");
  sprintf(title,"#slash{E}_{T}^{toy}, events after Cleanup cuts");
  Hist.fEvnt_toyMET_cut=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fEvnt_toyMET_cut,Folder);
  sprintf(name,"corMET_all");
  sprintf(title,"#slash{E}_{T}^{cor}, all events before Cleanup cuts");
  Hist.fEvnt_corMET_all=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fEvnt_corMET_all,Folder);
  
  //__________________________________ before cuts

  sprintf(title,"%s%s",algoname,": Number of Jets");
  Hist.fEvntNjet_b= new TH1F("Njet_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet_b,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>5 GeV");
  Hist.fEvntNjet5_b= new TH1F("Njet5_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet5_b,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>10 GeV");
  Hist.fEvntNjet10_b= new TH1F("Njet10_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet10_b,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>15 GeV");
  Hist.fEvntNjet15_b= new TH1F("Njet15_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet15_b,Folder);
  Hist.fEvntNjet20_b= new TH1F("Njet20_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet20_b,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>25 GeV");
  Hist.fEvntNjet25_b= new TH1F("Njet25_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet25_b,Folder);

  sprintf(title," %s%s",algoname,": dZ, jet & best vertex");
  Hist.fEvntdZ_b= new TH1F("dZ_b",title,400,-200.0,200.0); 
  AddHistogram(Hist.fEvntdZ_b,Folder);
  sprintf(title," %s%s",algoname,": raw Et, 1st jet");
  Hist.fEvntEt0_b[0]= new TH1F("Et0_b[0]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_b[0],Folder);
  sprintf(title," %s%s",algoname,": raw Et, 2nd jet");
  Hist.fEvntEt0_b[1]= new TH1F("Et0_b[1]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_b[1],Folder);
  sprintf(title," %s%s",algoname,": Et(lev6), 1st jet");
  Hist.fEvntEt_b[0]= new TH1F("Et_b[0]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_b[0],Folder);
  sprintf(title," %s%s",algoname,": Et(lev6), 2nd jet");
  Hist.fEvntEt_b[1]= new TH1F("Et_b[1]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_b[1],Folder);
  sprintf(title," %s%s",algoname,": detector Eta, 1st jet");
  Hist.fEvntEtaDet_b[0]= new TH1F("EtaDet_b[0]",title,200,-5.0,5.0);  
  AddHistogram(Hist.fEvntEtaDet_b[0],Folder);
  sprintf(title," %s%s",algoname,": detector Eta, 2nd jet");
  Hist.fEvntEtaDet_b[1]= new TH1F("EtaDet_b[1]",title,200,-5.0,5.0);
  AddHistogram(Hist.fEvntEtaDet_b[1],Folder);
  sprintf(title," %s%s",algoname,": Eta, 1st jet");
  Hist.fEvntEta_b[0]= new TH1F("Eta_b[0]",title,200,-5.0,5.0);
  AddHistogram(Hist.fEvntEta_b[0],Folder);
  sprintf(title," %s%s",algoname,": Eta, 2nd jet");
  Hist.fEvntEta_b[1]= new TH1F("Eta_b[1]",title,200,-5.0,5.0);
  AddHistogram(Hist.fEvntEta_b[1],Folder);
  sprintf(title," %s%s",algoname,": Phi, 1st jet");
  Hist.fEvntPhi_b[0]= new TH1F("Phi_b[0]",title,700,-0.5,6.5); 
  AddHistogram(Hist.fEvntPhi_b[0],Folder);
  sprintf(title," %s%s",algoname,": Phi, 2nd jet");
  Hist.fEvntPhi_b[1]= new TH1F("Phi_b[1]",title,700,-0.5,6.5); 
  AddHistogram(Hist.fEvntPhi_b[1],Folder);
  sprintf(title," %s%s",algoname,": Theta, 1st jet");
  Hist.fEvntTheta_b[0]= new TH1F("Theta_b[0]",title,400,-0.5,3.5); 
  AddHistogram(Hist.fEvntTheta_b[0],Folder);
  sprintf(title," %s%s",algoname,": Theta, 2nd jet");
  Hist.fEvntTheta_b[1]= new TH1F("Theta_b[1]",title,400,-0.5,3.5); 
  AddHistogram(Hist.fEvntTheta_b[1],Folder);
  sprintf(title," %s%s",algoname,": Em Fraction, 1st jet");
  Hist.fEvntEmFr_b[0]= new TH1F("EmFr_b[0]",title,200,0.0,2.0);  
  AddHistogram(Hist.fEvntEmFr_b[0],Folder);
  sprintf(title," %s%s",algoname,": Em Fraction, 2nd jet");
  Hist.fEvntEmFr_b[1]= new TH1F("EmFr_b[1]",title,200,0.0,2.0);  
  AddHistogram(Hist.fEvntEmFr_b[1],Folder);
  sprintf(title," %s%s",algoname,": Number of towers, 1st jet");
  Hist.fEvntNTowers_b[0]= new TH1F("NTowers_b[0]",title,100,-0.5,99.5); 
  AddHistogram(Hist.fEvntNTowers_b[0],Folder);
  sprintf(title," %s%s",algoname,": Number of towers, 2nd jet");
  Hist.fEvntNTowers_b[1]= new TH1F("NTowers_b[1]",title,100,-0.5,99.5); 
  AddHistogram(Hist.fEvntNTowers_b[1],Folder);
  sprintf(title," %s%s",algoname,": Number of tracks, 1st jet");
  Hist.fEvntNTracks_b[0]= new TH1F("NTracks_b[0]",title,100,-0.5,99.5); 
  AddHistogram(Hist.fEvntNTracks_b[0],Folder);
  sprintf(title," %s%s",algoname,": Number of tracks, 2nd jet");
  Hist.fEvntNTracks_b[1]= new TH1F("NTracks_b[1]",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNTracks_b[1],Folder);
  sprintf(title," %s%s",algoname,": raw Et, extra jets");
  Hist.fEvntEt0X_b= new TH1F("Et0X_b",title,1000,0.0,1000.0);   
  AddHistogram(Hist.fEvntEt0X_b,Folder);
  sprintf(title," %s%s",algoname,": Et(lev6), extra jets");
  Hist.fEvntEtX_b= new TH1F("EtX_b",title,1000,0.0,1000.0);   
  AddHistogram(Hist.fEvntEtX_b,Folder);
  sprintf(title," %s%s",algoname,": detector Eta, extra jets");
  Hist.fEvntEtaDetX_b= new TH1F("EtaDetX_b",title,200,-5.0,5.0);    
  AddHistogram(Hist.fEvntEtaDetX_b,Folder);
  sprintf(title," %s%s",algoname,": Eta, extra jets");
  Hist.fEvntEtaX_b= new TH1F("EtaX_b",title,200,-5.0,5.0); 
  AddHistogram(Hist.fEvntEtaX_b,Folder);
  sprintf(title," %s%s",algoname,": Phi, extra jets");
  Hist.fEvntPhiX_b= new TH1F("PhiX_b",title,700,-0.5,6.5);       
  AddHistogram(Hist.fEvntPhiX_b,Folder);
  sprintf(title," %s%s",algoname,": Theta, extra jets");
  Hist.fEvntThetaX_b= new TH1F("ThetaX_b",title,400,-0.5,3.5);     
  AddHistogram(Hist.fEvntThetaX_b,Folder);
  sprintf(title," %s%s",algoname,": Em Fraction, extra jets");
  Hist.fEvntEmFrX_b= new TH1F("EmFrX_b",title,200,0.0,2.0);      
  AddHistogram(Hist.fEvntEmFrX_b,Folder);
  sprintf(title," %s%s",algoname,": Number of towers, extra jets");
  Hist.fEvntNTowersX_b= new TH1F("NTowersX_b",title,100,-0.5,99.5);   
  AddHistogram(Hist.fEvntNTowersX_b,Folder);
  sprintf(title," %s%s",algoname,": Number of tracks, extra jets");
  Hist.fEvntNTracksX_b= new TH1F("NTracksX_b",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNTracksX_b,Folder);   
  sprintf(title," %s%s",algoname,": My Invariant Mass, 2 leading jets");
  Hist.fEvntMjj_b= new TH1F("Mjj_b",title,2000,0.0,2000.0);
  AddHistogram(Hist.fEvntMjj_b,Folder);
  sprintf(title," %s%s",algoname,": Theta* of 2 leading jets");
  Hist.fEvntThetaStar_b= new TH1F("ThetaStar_b",title,400,-0.5,3.5);   
  AddHistogram(Hist.fEvntThetaStar_b,Folder);
  sprintf(title," %s%s",algoname,": Delta Phi of 2 leading jets");
  Hist.fEvntDeltaPhi_b= new TH1F("DeltaPhi_b",title,350,0.0,3.5);   
  AddHistogram(Hist.fEvntDeltaPhi_b,Folder);
  sprintf(title," %s%s",algoname,": Delta Eta of 2 leading jets");
  Hist.fEvntDeltaEta_b= new TH1F("DeltaEta_b",title,800,-8.0,8.0);   
  AddHistogram(Hist.fEvntDeltaEta_b,Folder);
  sprintf(title," %s%s",algoname,": Delta R of 2 leading jets");
  Hist.fEvntDeltaR_b= new TH1F("DeltaR_b",title,800,0.0,8.0);   
  AddHistogram(Hist.fEvntDeltaR_b,Folder);
  sprintf(title," %s%s",algoname,": dR, 1st jet & any extra jet");
  Hist.fEvntDeltaR1x_b= new TH1F("DeltaR1x_b",title,800,0.0,8.0); 
  AddHistogram(Hist.fEvntDeltaR1x_b,Folder);
  sprintf(title," %s%s",algoname,": dR, 2nd jet & any extra jet");
  Hist.fEvntDeltaR2x_b= new TH1F("DeltaR2x_b",title,800,0.0,8.0);
  AddHistogram(Hist.fEvntDeltaR2x_b,Folder);
  sprintf(title," %s%s",algoname,": Kt of two best jets");
  Hist.fEvntKt2jet_b= new TH1F("Kt2jet_b",title,1000,0.0,1000.0);      
  AddHistogram(Hist.fEvntKt2jet_b,Folder);
  sprintf(title," %s%s",algoname,": Kt of all jets");
  Hist.fEvntKtAll_b= new TH1F("KtAll_b",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntKtAll_b,Folder);

  sprintf(title," %s%s",algoname,": Njet vs. Nvx(class>=12)");
  Hist.fEvntNJet_Nvx_b= new TProfile("NJet_Nvx_b",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet_Nvx_b,Folder);     
  sprintf(title," %s%s",algoname,": Njet5 vs. Nvx(class>=12)");
  Hist.fEvntNJet5_Nvx_b= new TProfile("NJet5_Nvx_b",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet5_Nvx_b,Folder);     
  sprintf(title," %s%s",algoname,": Njet10 vs. Nvx(class>=12)");
  Hist.fEvntNJet10_Nvx_b= new TProfile("NJet10_Nvx_b",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet10_Nvx_b,Folder);     
  sprintf(title," %s%s",algoname,": Njet15 vs. Nvx(class>=12)");
  Hist.fEvntNJet15_Nvx_b= new TProfile("NJet15_Nvx_b",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet15_Nvx_b,Folder);     
  sprintf(title," %s%s",algoname,": Njet20 vs. Nvx(class>=12)");
  Hist.fEvntNJet20_Nvx_b= new TProfile("NJet20_Nvx_b",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet20_Nvx_b,Folder);     
  sprintf(title," %s%s",algoname,": Njet25 vs. Nvx(class>=12)");
  Hist.fEvntNJet25_Nvx_b= new TProfile("NJet25_Nvx_b",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet25_Nvx_b,Folder);     

  sprintf(title," %s%s",algoname,": 2 leading jets, Kt vs. Mjj");
  Hist.fEvntKt_Mjj_b= new TProfile("Kt_Mjj_b",title,400,0.0,1000.0,0.0,1000.0);
  AddHistogram(Hist.fEvntKt_Mjj_b,Folder);
  sprintf(title," %s%s",algoname,": KtAll vs. Mjj");
  Hist.fEvntKtAll_Mjj_b= new TProfile("KtAll_Mjj_b",title,400,0.0,1000.0,0.0,1000.0);
  AddHistogram(Hist.fEvntKtAll_Mjj_b,Folder);
  sprintf(title," %s%s",algoname,": raw Et vs. Njet");
  Hist.fEvntEt0_Njet_b= new TProfile("Et0_Njet_b",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_Njet_b,Folder);
  sprintf(title," %s%s",algoname,": Et(lev6) vs. Njet");
  Hist.fEvntEt_Njet_b= new TProfile("Et_Njet_b",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_Njet_b,Folder);
  sprintf(title," %s%s",algoname,": raw Et vs. Nvx(class>=12)");  
  Hist.fEvntEt0_Nvx12_b= new TProfile("Et0_Nvx12_b",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_Nvx12_b,Folder);
  sprintf(title," %s%s",algoname,": Et(lev6) vs. Nvx(class>=12)");   
  Hist.fEvntEt_Nvx12_b= new TProfile("Et_Nvx12_b",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_Nvx12_b,Folder);
  sprintf(title," %s%s",algoname,": Njet vs. Lum for events with Nvx12=1");
  Hist.fEvntNjet_Lum_b= new TProfile("Njet_Lum_b",title,50,0.0,100.0,0.0,1000.0);
  AddHistogram(Hist.fEvntNjet_Lum_b,Folder);


//________________________________________________________________ after cuts
  sprintf(title,"%s%s",algoname,": Number of Jets");
  Hist.fEvntNjet_a= new TH1F("Njet_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet_a,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>5 GeV");
  Hist.fEvntNjet5_a= new TH1F("Njet5_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet5_a,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>10 GeV");
  Hist.fEvntNjet10_a= new TH1F("Njet10_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet10_a,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>15 GeV");
  Hist.fEvntNjet15_a= new TH1F("Njet15_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet15_a,Folder);
  Hist.fEvntNjet20_a= new TH1F("Njet20_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet20_a,Folder);
  sprintf(title,"%s%s",algoname,": Number of Jets with E_{T}>25 GeV");
  Hist.fEvntNjet25_a= new TH1F("Njet25_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNjet25_a,Folder);

  sprintf(title," %s%s",algoname,": dZ, jet & best vertex");
  Hist.fEvntdZ_a= new TH1F("dZ_a",title,400,-200.0,200.0); 
  AddHistogram(Hist.fEvntdZ_a,Folder);
  sprintf(title," %s%s",algoname,": raw Et, 1st jet");
  Hist.fEvntEt0_a[0]= new TH1F("Et0_a[0]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_a[0],Folder);
  sprintf(title," %s%s",algoname,": raw Et, 2nd jet");
  Hist.fEvntEt0_a[1]= new TH1F("Et0_a[1]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_a[1],Folder);
  sprintf(title," %s%s",algoname,": Et(lev6), 1st jet");
  Hist.fEvntEt_a[0]= new TH1F("Et_a[0]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_a[0],Folder);
  sprintf(title," %s%s",algoname,": Et(lev6), 2nd jet");
  Hist.fEvntEt_a[1]= new TH1F("Et_a[1]",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_a[1],Folder);
  sprintf(title," %s%s",algoname,": detector Eta, 1st jet");
  Hist.fEvntEtaDet_a[0]= new TH1F("EtaDet_a[0]",title,200,-5.0,5.0);  
  AddHistogram(Hist.fEvntEtaDet_a[0],Folder);
  sprintf(title," %s%s",algoname,": detector Eta, 2nd jet");
  Hist.fEvntEtaDet_a[1]= new TH1F("EtaDet_a[1]",title,200,-5.0,5.0);
  AddHistogram(Hist.fEvntEtaDet_a[1],Folder);
  sprintf(title," %s%s",algoname,": Eta, 1st jet");
  Hist.fEvntEta_a[0]= new TH1F("Eta_a[0]",title,200,-5.0,5.0);
  AddHistogram(Hist.fEvntEta_a[0],Folder);
  sprintf(title," %s%s",algoname,": Eta, 2nd jet");
  Hist.fEvntEta_a[1]= new TH1F("Eta_a[1]",title,200,-5.0,5.0);
  AddHistogram(Hist.fEvntEta_a[1],Folder);
  sprintf(title," %s%s",algoname,": Phi, 1st jet");
  Hist.fEvntPhi_a[0]= new TH1F("Phi_a[0]",title,700,-0.5,6.5); 
  AddHistogram(Hist.fEvntPhi_a[0],Folder);
  sprintf(title," %s%s",algoname,": Phi, 2nd jet");
  Hist.fEvntPhi_a[1]= new TH1F("Phi_a[1]",title,700,-0.5,6.5); 
  AddHistogram(Hist.fEvntPhi_a[1],Folder);
  sprintf(title," %s%s",algoname,": Theta, 1st jet");
  Hist.fEvntTheta_a[0]= new TH1F("Theta_a[0]",title,400,-0.5,3.5); 
  AddHistogram(Hist.fEvntTheta_a[0],Folder);
  sprintf(title," %s%s",algoname,": Theta, 2nd jet");
  Hist.fEvntTheta_a[1]= new TH1F("Theta_a[1]",title,400,-0.5,3.5); 
  AddHistogram(Hist.fEvntTheta_a[1],Folder);
  sprintf(title," %s%s",algoname,": Em Fraction, 1st jet");
  Hist.fEvntEmFr_a[0]= new TH1F("EmFr_a[0]",title,200,0.0,2.0);  
  AddHistogram(Hist.fEvntEmFr_a[0],Folder);
  sprintf(title," %s%s",algoname,": Em Fraction, 2nd jet");
  Hist.fEvntEmFr_a[1]= new TH1F("EmFr_a[1]",title,200,0.0,2.0);  
  AddHistogram(Hist.fEvntEmFr_a[1],Folder);
  sprintf(title," %s%s",algoname,": Number of towers, 1st jet");
  Hist.fEvntNTowers_a[0]= new TH1F("NTowers_a[0]",title,100,-0.5,99.5); 
  AddHistogram(Hist.fEvntNTowers_a[0],Folder);
  sprintf(title," %s%s",algoname,": Number of towers, 2nd jet");
  Hist.fEvntNTowers_a[1]= new TH1F("NTowers_a[1]",title,100,-0.5,99.5); 
  AddHistogram(Hist.fEvntNTowers_a[1],Folder);
  sprintf(title," %s%s",algoname,": Number of tracks, 1st jet");
  Hist.fEvntNTracks_a[0]= new TH1F("NTracks_a[0]",title,100,-0.5,99.5); 
  AddHistogram(Hist.fEvntNTracks_a[0],Folder);
  sprintf(title," %s%s",algoname,": Number of tracks, 2nd jet");
  Hist.fEvntNTracks_a[1]= new TH1F("NTracks_a[1]",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNTracks_a[1],Folder);
  sprintf(title," %s%s",algoname,": raw Et, extra jets");
  Hist.fEvntEt0X_a= new TH1F("Et0X_a",title,1000,0.0,1000.0);   
  AddHistogram(Hist.fEvntEt0X_a,Folder);
  sprintf(title," %s%s",algoname,": Et(lev6), extra jets");
  Hist.fEvntEtX_a= new TH1F("EtX_a",title,1000,0.0,1000.0);   
  AddHistogram(Hist.fEvntEtX_a,Folder);
  sprintf(title," %s%s",algoname,": detector Eta, extra jets");
  Hist.fEvntEtaDetX_a= new TH1F("EtaDetX_a",title,200,-5.0,5.0);    
  AddHistogram(Hist.fEvntEtaDetX_a,Folder);
  sprintf(title," %s%s",algoname,": Eta, extra jets");
  Hist.fEvntEtaX_a= new TH1F("EtaX_a",title,200,-5.0,5.0); 
  AddHistogram(Hist.fEvntEtaX_a,Folder);
  sprintf(title," %s%s",algoname,": Phi, extra jets");
  Hist.fEvntPhiX_a= new TH1F("PhiX_a",title,700,-0.5,6.5);       
  AddHistogram(Hist.fEvntPhiX_a,Folder);
  sprintf(title," %s%s",algoname,": Theta, extra jets");
  Hist.fEvntThetaX_a= new TH1F("ThetaX_a",title,400,-0.5,3.5);     
  AddHistogram(Hist.fEvntThetaX_a,Folder);
  sprintf(title," %s%s",algoname,": Em Fraction, extra jets");
  Hist.fEvntEmFrX_a= new TH1F("EmFrX_a",title,200,0.0,2.0);      
  AddHistogram(Hist.fEvntEmFrX_a,Folder);
  sprintf(title," %s%s",algoname,": Number of towers, extra jets");
  Hist.fEvntNTowersX_a= new TH1F("NTowersX_a",title,100,-0.5,99.5);   
  AddHistogram(Hist.fEvntNTowersX_a,Folder);
  sprintf(title," %s%s",algoname,": Number of tracks, extra jets");
  Hist.fEvntNTracksX_a= new TH1F("NTracksX_a",title,100,-0.5,99.5);
  AddHistogram(Hist.fEvntNTracksX_a,Folder);   
  sprintf(title," %s%s",algoname,": My Invariant Mass, 2 leading jets");
  Hist.fEvntMjj_a= new TH1F("Mjj_a",title,2000,0.0,2000.0);
  AddHistogram(Hist.fEvntMjj_a,Folder);
  sprintf(title," %s%s",algoname,": Theta* of 2 leading jets");
  Hist.fEvntThetaStar_a= new TH1F("ThetaStar_a",title,400,-0.5,3.5);   
  AddHistogram(Hist.fEvntThetaStar_a,Folder);
  sprintf(title," %s%s",algoname,": Delta Phi of 2 leading jets");
  Hist.fEvntDeltaPhi_a= new TH1F("DeltaPhi_a",title,350,0.0,3.5);   
  AddHistogram(Hist.fEvntDeltaPhi_a,Folder);
  sprintf(title," %s%s",algoname,": Delta Eta of 2 leading jets");
  Hist.fEvntDeltaEta_a= new TH1F("DeltaEta_a",title,800,-8.0,8.0);   
  AddHistogram(Hist.fEvntDeltaEta_a,Folder);
  sprintf(title," %s%s",algoname,": Delta R of 2 leading jets");
  Hist.fEvntDeltaR_a= new TH1F("DeltaR_a",title,800,0.0,8.0);   
  AddHistogram(Hist.fEvntDeltaR_a,Folder);
  sprintf(title," %s%s",algoname,": dR, 1st jet & any extra jet");
  Hist.fEvntDeltaR1x_a= new TH1F("DeltaR1x_a",title,800,0.0,8.0); 
  AddHistogram(Hist.fEvntDeltaR1x_a,Folder);
  sprintf(title," %s%s",algoname,": dR, 2nd jet & any extra jet");
  Hist.fEvntDeltaR2x_a= new TH1F("DeltaR2x_a",title,800,0.0,8.0);
  AddHistogram(Hist.fEvntDeltaR2x_a,Folder);
  sprintf(title," %s%s",algoname,": Kt of two best jets");
  Hist.fEvntKt2jet_a= new TH1F("Kt2jet_a",title,1000,0.0,1000.0);      
  AddHistogram(Hist.fEvntKt2jet_a,Folder);
  sprintf(title," %s%s",algoname,": Kt of all jets");
  Hist.fEvntKtAll_a= new TH1F("KtAll_a",title,1000,0.0,1000.0);
  AddHistogram(Hist.fEvntKtAll_a,Folder);

  sprintf(title," %s%s",algoname,": Njet vs. Nvx(class>=12)");
  Hist.fEvntNJet_Nvx_a= new TProfile("NJet_Nvx_a",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet_Nvx_a,Folder);     
  sprintf(title," %s%s",algoname,": Njet5 vs. Nvx(class>=12)");
  Hist.fEvntNJet5_Nvx_a= new TProfile("NJet5_Nvx_a",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet5_Nvx_a,Folder);     
  sprintf(title," %s%s",algoname,": Njet10 vs. Nvx(class>=12)");
  Hist.fEvntNJet10_Nvx_a= new TProfile("NJet10_Nvx_a",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet10_Nvx_a,Folder);     
  sprintf(title," %s%s",algoname,": Njet15 vs. Nvx(class>=12)");
  Hist.fEvntNJet15_Nvx_a= new TProfile("NJet15_Nvx_a",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet15_Nvx_a,Folder);     
  sprintf(title," %s%s",algoname,": Njet20 vs. Nvx(class>=12)");
  Hist.fEvntNJet20_Nvx_a= new TProfile("NJet20_Nvx_a",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet20_Nvx_a,Folder);     
  sprintf(title," %s%s",algoname,": Njet25 vs. Nvx(class>=12)");
  Hist.fEvntNJet25_Nvx_a= new TProfile("NJet25_Nvx_a",title,50,-0.5,49.5,-0.5,50.0); 
  AddHistogram(Hist.fEvntNJet25_Nvx_a,Folder);     

  sprintf(title," %s%s",algoname,": 2 leading jets, Kt vs. Mjj");
  Hist.fEvntKt_Mjj_a= new TProfile("Kt_Mjj_a",title,400,0.0,1000.0,0.0,1000.0);
  AddHistogram(Hist.fEvntKt_Mjj_a,Folder);
  sprintf(title," %s%s",algoname,": KtAll vs. Mjj");
  Hist.fEvntKtAll_Mjj_a= new TProfile("KtAll_Mjj_a",title,400,0.0,1000.0,0.0,1000.0);
  AddHistogram(Hist.fEvntKtAll_Mjj_a,Folder);
  sprintf(title," %s%s",algoname,": raw Et vs. Njet");
  Hist.fEvntEt0_Njet_a= new TProfile("Et0_Njet_a",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_Njet_a,Folder);
  sprintf(title," %s%s",algoname,": Et(lev6) vs. Njet");
  Hist.fEvntEt_Njet_a= new TProfile("Et_Njet_a",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_Njet_a,Folder);
  sprintf(title," %s%s",algoname,": raw Et vs. Nvx(class>=12)");  
  Hist.fEvntEt0_Nvx12_a= new TProfile("Et0_Nvx12_a",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt0_Nvx12_a,Folder);
  sprintf(title," %s%s",algoname,": Et(lev6) vs. Nvx(class>=12)");   
  Hist.fEvntEt_Nvx12_a= new TProfile("Et_Nvx12_a",title,50,-0.5,49.5,0.0,1000.0);
  AddHistogram(Hist.fEvntEt_Nvx12_a,Folder);
  sprintf(title," %s%s",algoname,": Njet vs. Lum for events with Nvx12=1");
  Hist.fEvntNjet_Lum_a= new TProfile("Njet_Lum_a",title,50,0.0,100.0,0.0,1000.0);
  AddHistogram(Hist.fEvntNjet_Lum_a,Folder);

  return;
}


//_________________________________________________ booking met histo
void TMyJetFilterModule::BookMetStudyHistograms(MetStudyHisto_t& Hist, const char* Folder, const char* algoname) {

  char name [200];
  char title[200];

  //------ upper limit on MetSignificance for real MET
  for(int i=0; i<5; i++)
    {
      char range[200];
      if(i==0) sprintf(range,"closest object");
      if(i==1) sprintf(range,"closest EM object");
      if(i==2) sprintf(range,"closest jet");
      if(i==3) sprintf(range,"1^{st} EM object");
      if(i==4) sprintf(range,"1^{st} jet");      
      sprintf(name,"fMetSig_vs_dPhi[%i]",i);
      sprintf(title,"#slash{E}_{T}-significance vs. #Delta#phi, %s",range);          
      Hist.fMetSig_vs_dPhi[i]= new TH2F(name,title,100,0.0,20,60,0.0,TMath::Pi()); 
      AddHistogram(Hist.fMetSig_vs_dPhi[i],Folder);
      sprintf(name,"fMetSigCalib_vs_dPhi[%i]",i);
      sprintf(title,"Pseudo-experiments: #slash{E}_{T}-significance vs. #Delta#phi, %s",range);          
      Hist.fMetSigCalib_vs_dPhi[i]= new TH2F(name,title,100,0.0,20,60,0.0,TMath::Pi()); 
      AddHistogram(Hist.fMetSigCalib_vs_dPhi[i],Folder);
    }

  sprintf(name,"fMetSig_vs_sqrtHt");
  sprintf(title,"#slash{E}_{T}-significance vs. #sqrt{H_{T}}");          
  Hist.fMetSig_vs_sqrtHt= new TH2F(name,title,100,0.0,20,100,0.0,30.0); 
  AddHistogram(Hist.fMetSig_vs_sqrtHt,Folder);
  sprintf(name,"fMetSig_vs_sqrtMet");
  sprintf(title,"#slash{E}_{T}-significance vs. #sqrt{#slash{E}_{T}}");          
  Hist.fMetSig_vs_sqrtMet= new TH2F(name,title,100,0.0,20,100,0.0,30.0); 
  AddHistogram(Hist.fMetSig_vs_sqrtMet,Folder);
  sprintf(name,"fMetSig_vs_sqrtSumEt");
  sprintf(title,"#slash{E}_{T}-significance vs. #sqrt{#SigmaE_{T}}");          
  Hist.fMetSig_vs_sqrtSumEt= new TH2F(name,title,100,0.0,20,100,0.0,30.0); 
  AddHistogram(Hist.fMetSig_vs_sqrtSumEt,Folder);

  sprintf(name,"fMetSig_vs_Xces");
  sprintf(title,"#slash{E}_{T}-significance vs. X_{CES} for #gamma/e if #Delta#phi_{#slash{E}_{T}-#gamma/e}<0.4");          
  Hist.fMetSig_vs_Xces= new TH2F(name,title,100,0.0,20,100,0.0,25.0); 
  AddHistogram(Hist.fMetSig_vs_Xces,Folder);
  sprintf(name,"fMetSig_vs_etaEM");
  sprintf(title,"#slash{E}_{T}-significance vs. |#eta_{det}| for #gamma/e if #Delta#phi_{#slash{E}_{T}-#gamma/e}<0.4");          
  Hist.fMetSig_vs_etaEM= new TH2F(name,title,100,0.0,20,150,0.0,3.0); 
  AddHistogram(Hist.fMetSig_vs_etaEM,Folder);
  sprintf(name,"fMetSig_Xces_vs_etaEM");
  sprintf(title,"|X_{ces}| vs. |#eta_{rel}| for #gamma/e if siginificance>4.0 and #Delta#phi_{#slash{E}_{T}-#gamma/e}<0.4");          
  Hist.fMetSig_Xces_vs_etaEM= new TH2F(name,title,100,0.0,25.0,100,0.0,1.0); 
  AddHistogram(Hist.fMetSig_Xces_vs_etaEM,Folder);
  sprintf(name,"fMetSig_vs_etaJET");
  sprintf(title,"#slash{E}_{T}-significance vs. |#eta_{det}| for jet if #Delta#phi_{#slash{E}_{T}-jet}<0.4");          
  Hist.fMetSig_vs_etaJET= new TH2F(name,title,100,0.0,20,150,0.0,3.0); 
  AddHistogram(Hist.fMetSig_vs_etaJET,Folder);
  sprintf(name,"ObjType");
  sprintf(title,"Type of closest to #slash{E}_{T} object (0=e/#gamma, 1=jet, 2=b-tag, 3=#mu, 4=#tau, 5=trk) for events MetSig>4.0");     
  Hist.fObjType= new TH1F(name,title,6,-0.5,5.5);          
  AddHistogram(Hist.fObjType,Folder);

  sprintf(name,"fMetSig_corrFactor");
  sprintf(title,"Correction factor for estimated #slash{E}_{T}-significance");
  Hist.fMetSig_corrFactor=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSig_corrFactor,Folder);

  sprintf(name,"fMetSig_estimate");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance");
  Hist.fMetSig_estimate=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSig_estimate,Folder);
  sprintf(name,"fMetSig_estimate_njet0");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance if N_{jet15}=0");
  Hist.fMetSig_estimate_njet0=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSig_estimate_njet0,Folder);
  sprintf(name,"fMetSig_estimate_njet1");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance if N_{jet15}=1");
  Hist.fMetSig_estimate_njet1=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSig_estimate_njet1,Folder);
  sprintf(name,"fMetSig_estimate_njet2");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance if N_{jet15}>=2");
  Hist.fMetSig_estimate_njet2=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSig_estimate_njet2,Folder);

  //------ upper limit on MetSignificance for MET from pseudo-experiments
  sprintf(name,"fMetSigCalib_estimate");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance for pseudo-experiments");
  Hist.fMetSigCalib_estimate=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSigCalib_estimate,Folder);
  sprintf(name,"fMetSigCalib_estimate_njet0");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance for pseudo-experiments with N_{jet15}=0");
  Hist.fMetSigCalib_estimate_njet0=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSigCalib_estimate_njet0,Folder);
  sprintf(name,"fMetSigCalib_estimate_njet1");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance for pseudo-experiments with N_{jet15}=1");
  Hist.fMetSigCalib_estimate_njet1=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSigCalib_estimate_njet1,Folder);
  sprintf(name,"fMetSigCalib_estimate_njet2");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance for pseudo-experiments with N_{jet15}>=2");
  Hist.fMetSigCalib_estimate_njet2=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSigCalib_estimate_njet2,Folder);

  //------ upper limit on MetSignificance for toy MET
  sprintf(name,"fMetSigToy_estimate");
  sprintf(title,"Estimated upper limit on #slash{E}_{T}-significance for toy MC");
  Hist.fMetSigToy_estimate=new TH1F(name,title,1000,0.0,20.0);
  AddHistogram(Hist.fMetSigToy_estimate,Folder);

  for(int i=0; i<5; i++)
    {
      sprintf(name,"fMetSig_Met[%i]",i);
      sprintf(title,"#slash{E}_{T} for events with Significance>%i",i);
      Hist.fMetSig_Met[i]=new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fMetSig_Met[i],Folder);

      sprintf(name,"fMetSigCalib_Met[%i]",i);
      sprintf(title,"pseudo-experiments: #slash{E}_{T} for events with Significance>%i",i);
      Hist.fMetSigCalib_Met[i]=new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fMetSigCalib_Met[i],Folder);

      sprintf(name,"fMetSigToy_Met[%i]",i);
      if(i==0) sprintf(title,"toy MC: #slash{E}_{T} for events with Significance>%i",i);
      else sprintf(title,"toy MC: #slash{E}_{T} for events with Significance>%i",i+2);
      Hist.fMetSigToy_Met[i]=new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fMetSigToy_Met[i],Folder);

      if(i<4)
	{
	  sprintf(name,"fMetSigToy_eff[%i]",i);
	  sprintf(title,"toy MC: efficiency of MetSig>%i cut",i+3);
	  Hist.fMetSigToy_eff[i]=new TH1F(name,title,1000,0.0,1000.0);
	  AddHistogram(Hist.fMetSigToy_eff[i],Folder);
	  Hist.fMetSigToy_eff[i]->Sumw2();
	}
    }

  sprintf(name,"SumEtCorr");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T}");
  Hist.fSumEtCorr=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorr,Folder);
  sprintf(name,"SqrtSumEtCorr");
  sprintf(title," %s%s",algoname,": corrected #sqrt{#sum E_{T}}");
  Hist.fSqrtSumEtCorr=new TH1F(name,title,180,0.0,45.0);
  AddHistogram(Hist.fSqrtSumEtCorr,Folder);

  sprintf(name,"SumEtCorr_noJet_vx1");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T}, N_{jet15}=0, N_{vx}=1");
  Hist.fSumEtCorr_noJet_vx1=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorr_noJet_vx1,Folder);
  sprintf(name,"SumEtCorr_noJet_vx2");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T}, N_{jet15}=0, N_{vx}=2");
  Hist.fSumEtCorr_noJet_vx2=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorr_noJet_vx2,Folder);
  sprintf(name,"SumEtCorr_noJet_vx3");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T}, N_{jet15}=0, N_{vx}=3");
  Hist.fSumEtCorr_noJet_vx3=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorr_noJet_vx3,Folder);
  sprintf(name,"SumEtCorrNoJet_vs_Nvx");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T} .vs. N_{vx} for N_{jet15}=0 events");
  Hist.fSumEtCorrNoJet_vs_Nvx=new TProfile(name,title,11,-0.5,10.5,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorrNoJet_vs_Nvx,Folder);


  sprintf(name,"SumEtCorr_withJet");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T} for events with N_{jet}(E_{T}>Threshold)>0");
  Hist.fSumEtCorr_withJet=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorr_withJet,Folder);
  sprintf(name,"SqrtSumEtCorr_withJet");
  sprintf(title," %s%s",algoname,": corrected #sqrt{#sum E_{T}} for events with N_{jet}(E_{T}>Threshold)>0");
  Hist.fSqrtSumEtCorr_withJet=new TH1F(name,title,180,0.0,45.0);
  AddHistogram(Hist.fSqrtSumEtCorr_withJet,Folder);
  sprintf(name,"SumEtCorr_noJet");
  sprintf(title," %s%s",algoname,": corrected #sum E_{T} for events with N_{jet}(E_{T}>Threshold)=0");
  Hist.fSumEtCorr_noJet=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtCorr_noJet,Folder);
  sprintf(name,"SqrtSumEtCorr_noJet");
  sprintf(title," %s%s",algoname,": corrected #sqrt{#sum E_{T}} for events with N_{jet}(E_{T}>Threshold)=0");
  Hist.fSqrtSumEtCorr_noJet=new TH1F(name,title,180,0.0,45.0);
  AddHistogram(Hist.fSqrtSumEtCorr_noJet,Folder);

  sprintf(name,"MetRaw");
  sprintf(title," %s%s",algoname,": MEt_4 before corr. for jets (corrected events)");
  Hist.fMetRaw=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fMetRaw,Folder);
  sprintf(name,"MetCorr");
  sprintf(title," %s%s",algoname,": MEt_4 after corr. for jets (corrected events)");
  Hist.fMetCorr=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fMetCorr,Folder);
  sprintf(name,"MetPhiRaw");
  sprintf(title," %s%s",algoname,": #phi of MEt_4 before corr. for jets (corrected events)");
  Hist.fMetPhiRaw=new TH1F(name,title,128,0.0,6.4);
  AddHistogram(Hist.fMetPhiRaw,Folder);
  sprintf(name,"MetPhiCorr");
  sprintf(title," %s%s",algoname,": #phi of MEt_4 after corr. for jets (corrected events)");
  Hist.fMetPhiCorr=new TH1F(name,title,128,0.0,6.4);
  AddHistogram(Hist.fMetPhiCorr,Folder);
  sprintf(name,"MetRawAll");
  sprintf(title," %s%s",algoname,": MEt_4 before corr. for jets (all events)" );
  Hist.fMetRawAll=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fMetRawAll,Folder);
  sprintf(name,"MetCorrAll");
  sprintf(title," %s%s",algoname,": MEt_4 after corr. for jets (all events)");
  Hist.fMetCorrAll=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fMetCorrAll,Folder);
  sprintf(name,"MetPhiRawAll");
  sprintf(title," %s%s",algoname,": #phi of MEt_4 before corr. for jets (all events)");
  Hist.fMetPhiRawAll=new TH1F(name,title,128,0.0,6.4);
  AddHistogram(Hist.fMetPhiRawAll,Folder);
  sprintf(name,"MetPhiCorrAll");
  sprintf(title," %s%s",algoname,": #phi of MEt_4 after corr. for jets (all events)");
  Hist.fMetPhiCorrAll=new TH1F(name,title,128,0.0,6.4);
  AddHistogram(Hist.fMetPhiCorrAll,Folder);
  sprintf(name,"MetRawAll_X");
  sprintf(title," %s%s",algoname,": MEtX_4 before corr. for jets (all events)" );
  Hist.fMetRawAll_X=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fMetRawAll_X,Folder);
  sprintf(name,"MetCorrAll_X");
  sprintf(title," %s%s",algoname,": MEtX_4 after corr. for jets (all events)");
  Hist.fMetCorrAll_X=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fMetCorrAll_X,Folder);
  sprintf(name,"MetRawAll_Y");
  sprintf(title," %s%s",algoname,": MEtY_4 before corr. for jets (all events)" );
  Hist.fMetRawAll_Y=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fMetRawAll_Y,Folder);
  sprintf(name,"MetCorrAll_Y");
  sprintf(title," %s%s",algoname,": MEtY_4 after corr. for jets (all events)");
  Hist.fMetCorrAll_Y=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fMetCorrAll_Y,Folder);

  sprintf(name,"Met4VsNjet");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{jet}");
  Hist.fMet4VsNjet=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNjet,Folder);
  sprintf(name,"Met4VsNjet_th5");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{jet} with E_{T}>5 GeV");
  Hist.fMet4VsNjet_th5=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNjet_th5,Folder);
  sprintf(name,"Met4VsNjet_th10");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{jet} with E_{T}>10 GeV");
  Hist.fMet4VsNjet_th10=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNjet_th10,Folder);
  sprintf(name,"Met4VsNjet_th15");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{jet} with E_{T}>15 GeV");
  Hist.fMet4VsNjet_th15=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNjet_th15,Folder);
  sprintf(name,"Met4VsNjet_th20");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{jet} with E_{T}>20 GeV");
  Hist.fMet4VsNjet_th20=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNjet_th20,Folder);
  sprintf(name,"Met4VsNjet_th25");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{jet} with E_{T}>25 GeV");
  Hist.fMet4VsNjet_th25=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNjet_th25,Folder);
  sprintf(name,"MetGenVsNjet");
  sprintf(title," %s%s",algoname,": generated (def parametrization) #slash{E}_{T} vs N_{jet}");
 
  sprintf(name,"Met4VsRun");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} Vs. Run for N_{vx12}=1");
  Hist.fMet4VsRun=new TProfile(name,title,100,130000.0,230000.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsRun,Folder);
  sprintf(name,"Nvx12VsRun");
  sprintf(title,"N_{vx12} Vs. Run");
  Hist.fNvx12VsRun=new TProfile(name,title,200,130000.0,230000.0,-1.0,100.0);
  AddHistogram(Hist.fNvx12VsRun,Folder);
  sprintf(name,"Met4VsNvx12");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs N_{vx12}");
  Hist.fMet4VsNvx12=new TProfile(name,title,10,-0.5,9.5,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsNvx12,Folder);

  sprintf(name,"SumEtJetFrac");
  sprintf(title," %s%s",algoname,": #Sigma E^{jets}_{T}/#Sigma E^{tot}_{T}");
  Hist.fSumEtJetFrac=new TH1F(name,title,100,0.0,1.0);
  AddHistogram(Hist.fSumEtJetFrac,Folder);
  sprintf(name,"SumEtJet");
  sprintf(title," %s%s",algoname,": corrected #sum E^{jets}_{T}");
  Hist.fSumEtJet=new TH1F(name,title,2000,0.0,2000.0);
  AddHistogram(Hist.fSumEtJet,Folder);
  sprintf(name,"SqrtSumEtJet");
  sprintf(title," %s%s",algoname,": corrected #sqrt{#sum E^{jets}_{T}}");
  Hist.fSqrtSumEtJet=new TH1F(name,title,180,0.0,45.0);
  AddHistogram(Hist.fSqrtSumEtJet,Folder);
  sprintf(name,"Met4VsJetFr");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs #Sigma E^{jets}_{T}/#Sigma E^{tot}_{T}");
  Hist.fMet4VsJetFr=new TProfile(name,title,20,0.0,1.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsJetFr,Folder);

  sprintf(name,"Met4VsSqrtSumEtJet");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T} vs #sqrt{#Sigma E^{jets}_{T}}");
  Hist.fMet4VsSqrtSumEtJet=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMet4VsSqrtSumEtJet,Folder);
  sprintf(name,"JetFrVsSumEt");
  sprintf(title," %s%s",algoname,": #Sigma E^{jets}_{T}/#Sigma E^{tot}_{T} vs #Sigma E^{tot}_{T}}");
  Hist.fJetFrVsSumEt=new TProfile(name,title,40,0.0,400.0,-1.0,10.0);
  AddHistogram(Hist.fJetFrVsSumEt,Folder);

  sprintf(name,"Met4X_vs_Met4Y");
  sprintf(title," %s%s",algoname,": meth4 #slash{E}_{T}^{X} vs. #slash{E}_{T}^{Y}");
  Hist.fMet4X_vs_Met4Y=new TH2F(name,title,40,-40.0,40.0,40,-40.0,40.0);
  AddHistogram(Hist.fMet4X_vs_Met4Y,Folder);

  for(int i=0; i<10; i++)
    {

      sprintf(name,"Met4[%i]",i);
      sprintf(title,"%s: meth4 #slash{E}_{T}, %i<#sqrt{#sum E_{T}^{corr}}<%i",algoname,i*2,(i+1)*2);
      Hist.fMet4[i]=new TH1F(name,title,500,0.0,500.0);
      AddHistogram(Hist.fMet4[i],Folder);
      sprintf(name,"Met4Phi[%i]",i);
      sprintf(title,"%s: #phi of meth4 #slash{E}_{T}, %i<#sqrt{#sum E_{T}^{corr}}<%i",algoname,i*2,(i+1)*2);
      Hist.fMet4Phi[i]=new TH1F(name,title,128,0.0,6.4);
      AddHistogram(Hist.fMet4Phi[i],Folder);

      //---- any number of vertices
      sprintf(name,"Met4X[%i]",i);
      sprintf(title,"%s: meth4 MEtX, %i<#sqrt{#sum E_{T}^{corr}}<%i",algoname,i*2,(i+1)*2);
      Hist.fMet4X[i]=new TH1F(name,title,400,-200.0,200.0);
      AddHistogram(Hist.fMet4X[i],Folder);
      sprintf(name,"Met4Y[%i]",i);
      sprintf(title,"%s: meth4 MEtY, %i<#sqrt{#sum E_{T}^{corr}}<%i",algoname,i*2,(i+1)*2);
      Hist.fMet4Y[i]=new TH1F(name,title,400,-200.0,200.0);
      AddHistogram(Hist.fMet4Y[i],Folder);

      //---- Njet_thr*=0
      sprintf(name,"Met4X_noJet[%i]",i);
      sprintf(title,"#slash{E}_{T}^{X}: N_{jet15}=0 and %i<#sqrt{#sum E_{T}^{uncl}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_noJet[i]=new TH1F(name,title,400,-200.0,200.0);
      AddHistogram(Hist.fMet4X_noJet[i],Folder);
      sprintf(name,"Met4Y_noJet[%i]",i);
      sprintf(title,"#slash{E}_{T}^{Y}: N_{jet15}=0 and %i<#sqrt{#sum E_{T}^{uncl}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_noJet[i]=new TH1F(name,title,400,-200.0,200.0);
      AddHistogram(Hist.fMet4Y_noJet[i],Folder);
      //---- Njet_thr*>0
      sprintf(name,"Met4X_withJet[%i]",i);
      sprintf(title,"#slash{E}_{T}^{X}: N_{jet15}>0 and %i<#sqrt{#sum E_{T}^{uncl}}<%i",i*2,(i+1)*2);
      Hist.fMet4X_withJet[i]=new TH1F(name,title,400,-200.0,200.0);
      AddHistogram(Hist.fMet4X_withJet[i],Folder);
      sprintf(name,"Met4Y_withJet[%i]",i);
      sprintf(title,"#slash{E}_{T}^{Y}: N_{jet15}>0 and %i<#sqrt{#sum E_{T}^{uncl}}<%i",i*2,(i+1)*2);
      Hist.fMet4Y_withJet[i]=new TH1F(name,title,400,-200.0,200.0);
      AddHistogram(Hist.fMet4Y_withJet[i],Folder);
    }

  //______________________________________________________________________ histograms for MetModel-2
  sprintf(name,"GenV2Met_def_proj");
  sprintf(title,"projection of generated #slash{E}_{T} (default parametrization) on #slash{E}_{T}^{det} direction");
  Hist.fGenV2Met_def_proj=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fGenV2Met_def_proj,Folder);
  sprintf(name,"GenV2MetXY_def_proj");
  sprintf(title,"2D projection of generated #slash{E}_{T} (default parametrization) on #slash{E}_{T}^{det} direction");
  Hist.fGenV2MetXY_def_proj=new TH2F(name,title,100,-100.0,100.0,100,-100.0,100.0);
  AddHistogram(Hist.fGenV2MetXY_def_proj,Folder);
  sprintf(name,"GenV2Met_def_projNjet15");
  sprintf(title,"projection of generated #slash{E}_{T} (default parametrization) on #slash{E}_{T}^{det} direction if N_{jet15}>0");
  Hist.fGenV2Met_def_projNjet15=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fGenV2Met_def_projNjet15,Folder);
  sprintf(name,"GenV2MetXY_def_projNjet15");
  sprintf(title,"2D projection of generated #slash{E}_{T} (default parametrization) on #slash{E}_{T}^{det} direction if N_{jet15}>0");
  Hist.fGenV2MetXY_def_projNjet15=new TH2F(name,title,100,-100.0,100.0,100,-100.0,100.0);
  AddHistogram(Hist.fGenV2MetXY_def_projNjet15,Folder);
  sprintf(name,"GenV2_dPhiMet_def");
  sprintf(title,"#Delta#phi(#slash{E}_{T}^{gen}-#slash{E}_{T}^{det}) (default parametrization)");
  Hist.fGenV2_dPhiMet_def=new TH1F(name,title,157,0.0,TMath::Pi());
  AddHistogram(Hist.fGenV2_dPhiMet_def,Folder);
  sprintf(name,"GenV2_dPhiMet_def_Njet15");
  sprintf(title,"#Delta#phi(#slash{E}_{T}^{gen}-#slash{E}_{T}^{det}) (default parametrization) if N_{jet15}>0");
  Hist.fGenV2_dPhiMet_def_Njet15=new TH1F(name,title,157,0.0,TMath::Pi());
  AddHistogram(Hist.fGenV2_dPhiMet_def_Njet15,Folder);


  sprintf(name,"GenV2Met_max_def_proj");
  sprintf(title,"projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det} direction");
  Hist.fGenV2Met_max_def_proj=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fGenV2Met_max_def_proj,Folder);
  sprintf(name,"GenV2MetXY_max_def_proj");
  sprintf(title,"2D projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det} direction");
  Hist.fGenV2MetXY_max_def_proj=new TH2F(name,title,100,-100.0,100.0,100,-100.0,100.0);
  AddHistogram(Hist.fGenV2MetXY_max_def_proj,Folder);
  sprintf(name,"GenV2Met_max_def_projNjet15");
  sprintf(title,"projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det} direction if N_{jet15}>0");
  Hist.fGenV2Met_max_def_projNjet15=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fGenV2Met_max_def_projNjet15,Folder);
  sprintf(name,"GenV2MetXY_max_def_projNjet15");
  sprintf(title,"2D projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det} direction if N_{jet15}>0");
  Hist.fGenV2MetXY_max_def_projNjet15=new TH2F(name,title,100,-100.0,100.0,100,-100.0,100.0);
  AddHistogram(Hist.fGenV2MetXY_max_def_projNjet15,Folder);
  sprintf(name,"GenV2_dPhiMet_max_def");
  sprintf(title,"#Delta#phi(#slash{E}_{T}^{gen}-#slash{E}_{T}^{det}) (default parametrization), using maximum #slash{E}_{T}^{gen}");
  Hist.fGenV2_dPhiMet_max_def=new TH1F(name,title,157,0.0,TMath::Pi());
  AddHistogram(Hist.fGenV2_dPhiMet_max_def,Folder);
  sprintf(name,"GenV2_dPhiMet_max_def_Njet15");
  sprintf(title,"#Delta#phi(#slash{E}_{T}^{gen}-#slash{E}_{T}^{det}) (default parametrization) if N_{jet15}>0, using maximum #slash{E}_{T}^{gen}");
  Hist.fGenV2_dPhiMet_max_def_Njet15=new TH1F(name,title,157,0.0,TMath::Pi());
  AddHistogram(Hist.fGenV2_dPhiMet_max_def_Njet15,Folder);


  sprintf(name,"GenV2Met_max_def_projMet10");
  sprintf(title,"projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det}>10 direction");
  Hist.fGenV2Met_max_def_projMet10=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fGenV2Met_max_def_projMet10,Folder);
  sprintf(name,"GenV2MetXY_max_def_projMet10");
  sprintf(title,"2D projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det}>10 direction");
  Hist.fGenV2MetXY_max_def_projMet10=new TH2F(name,title,100,-100.0,100.0,100,-100.0,100.0);
  AddHistogram(Hist.fGenV2MetXY_max_def_projMet10,Folder);
  sprintf(name,"GenV2Met_max_def_projMet10Njet15");
  sprintf(title,"projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det}>10 direction if N_{jet15}>0");
  Hist.fGenV2Met_max_def_projMet10Njet15=new TH1F(name,title,1000,-500.0,500.0);
  AddHistogram(Hist.fGenV2Met_max_def_projMet10Njet15,Folder);
  sprintf(name,"GenV2MetXY_max_def_projMet10Njet15");
  sprintf(title,"2D projection of maximum #slash{E}_{T}^{gen} (default parametrization) on #slash{E}_{T}^{det}>10 direction if N_{jet15}>0");
  Hist.fGenV2MetXY_max_def_projMet10Njet15=new TH2F(name,title,100,-100.0,100.0,100,-100.0,100.0);
  AddHistogram(Hist.fGenV2MetXY_max_def_projMet10Njet15,Folder);
  sprintf(name,"GenV2_dPhiMet_max_def_Met10");
  sprintf(title,"#Delta#phi(#slash{E}_{T}^{gen}-#slash{E}_{T}^{det}) (default parametrization), if #slash{E}_{T}^{det}>10 and using max #slash{E}_{T}^{gen}");
  Hist.fGenV2_dPhiMet_max_def_Met10=new TH1F(name,title,157,0.0,TMath::Pi());
  AddHistogram(Hist.fGenV2_dPhiMet_max_def_Met10,Folder);
  sprintf(name,"GenV2_dPhiMet_max_def_Met10Njet15");
  sprintf(title,"#Delta#phi(#slash{E}_{T}^{gen}-#slash{E}_{T}^{det}) (default parametrization) if #slash{E}_{T}^{det}>10 N_{jet15}>0, using max #slash{E}_{T}^{gen}");
  Hist.fGenV2_dPhiMet_max_def_Met10Njet15=new TH1F(name,title,157,0.0,TMath::Pi());
  AddHistogram(Hist.fGenV2_dPhiMet_max_def_Met10Njet15,Folder);


  sprintf(name,"GenV2Met_def");
  sprintf(title," %s%s",algoname,": generated Model-2 #slash{E}_{T} (default parametrization)");
  Hist.fGenV2Met_def=new TH1F(name,title,500,0.0,500.0);
  AddHistogram(Hist.fGenV2Met_def,Folder);
  sprintf(name,"GenV2MetPhi_def");
  sprintf(title," %s%s",algoname,": #phi of generated Model-2 #slash{E}_{T} (default parametrization)");
  Hist.fGenV2MetPhi_def=new TH1F(name,title,128,0.0,6.4);
  AddHistogram(Hist.fGenV2MetPhi_def,Folder);
  sprintf(name,"GenV2MetX_def");
  sprintf(title," %s%s",algoname,": generated Model-2 #slash{E}_{T}^{X} (default parametrization)");
  Hist.fGenV2MetX_def=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fGenV2MetX_def,Folder);
  sprintf(name,"GenV2MetY_def");
  sprintf(title," %s%s",algoname,": generated Model-2 #slash{E}_{T}^{Y} (default parametrization)");
  Hist.fGenV2MetY_def=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fGenV2MetY_def,Folder);

  sprintf(name,"MetGenV2VsNjet");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{jet}");
  Hist.fMetGenV2VsNjet=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNjet,Folder);
  sprintf(name,"MetGenV2VsNjet_th5");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{jet} with E_{T}>5 GeV");
  Hist.fMetGenV2VsNjet_th5=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNjet_th5,Folder);
  sprintf(name,"MetGenV2VsNjet_th10");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{jet} with E_{T}>10 GeV");
  Hist.fMetGenV2VsNjet_th10=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNjet_th10,Folder);
  sprintf(name,"MetGenV2VsNjet_th15");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{jet} with E_{T}>15 GeV");
  Hist.fMetGenV2VsNjet_th15=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNjet_th15,Folder);
  sprintf(name,"MetGenV2VsNjet_th20");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{jet} with E_{T}>20 GeV");
  Hist.fMetGenV2VsNjet_th20=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNjet_th20,Folder);
  sprintf(name,"MetGenV2VsNjet_th25");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{jet} with E_{T}>25 GeV");
  Hist.fMetGenV2VsNjet_th25=new TProfile(name,title,40,-0.5,39.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNjet_th25,Folder);


  sprintf(name,"MetGenV2VsRun");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} Vs. Run for N_{vx12}=1");
  Hist.fMetGenV2VsRun=new TProfile(name,title,100,130000.0,230000.0,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsRun,Folder);
  sprintf(name,"MetGenV2VsNvx12");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs N_{vx12}");
  Hist.fMetGenV2VsNvx12=new TProfile(name,title,10,-0.5,9.5,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsNvx12,Folder);
    
  sprintf(name,"MetGenV2VsJetFr");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs #Sigma E^{jets}_{T}/#Sigma E^{tot}_{T}");
  Hist.fMetGenV2VsJetFr=new TProfile(name,title,20,0.0,1.0,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsJetFr,Folder);
  sprintf(name,"MetGenV2VsSqrtSumEtJet");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T} vs #sqrt{#Sigma E^{jets}_{T}}");
  Hist.fMetGenV2VsSqrtSumEtJet=new TProfile(name,title,45,0.0,45.0,-1.0,1000.0);
  AddHistogram(Hist.fMetGenV2VsSqrtSumEtJet,Folder);
  sprintf(name,"GenV2MetX_vs_MetY");
  sprintf(title," %s%s",algoname,": generated Model-2 (def parametrization) #slash{E}_{T}^{X} vs. #slash{E}_{T}^{Y}");
  Hist.fGenV2MetX_vs_MetY=new TH2F(name,title,40,-40.0,40.0,40,-40.0,40.0);
  AddHistogram(Hist.fGenV2MetX_vs_MetY,Folder);
  
  sprintf(name,"Met4GenV2Met");
  sprintf(title," %s%s",algoname,": #slash{E}_{T}-#slash{E}_{T}^{gen}");
  Hist.fMet4GenV2Met=new TH1F(name,title,400,-200.0,200.0);
  AddHistogram(Hist.fMet4GenV2Met,Folder);
  sprintf(name,"Met4_vs_Met4GenV2Met");
  sprintf(title," %s%s",algoname,": #slash{E}_{T} .vs. #slash{E}_{T}-#slash{E}_{T}^{gen}");
  Hist.fMet4_vs_Met4GenV2Met=new TH2F(name,title,60,-150.0,150.0,30,0.0,150.0);
  AddHistogram(Hist.fMet4_vs_Met4GenV2Met,Folder);
  sprintf(name,"Met4_vs_GenV2Met");
  sprintf(title," %s%s",algoname,": #slash{E}_{T} .vs. #slash{E}_{T}^{gen}");
  Hist.fMet4_vs_GenV2Met=new TH2F(name,title,50,0.0,250.0,50,0.0,250.0);
  AddHistogram(Hist.fMet4_vs_GenV2Met,Folder);

  sprintf(name,"MetCorr_vs_dZvx");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. #DeltaZ_{vx} for N_{vx12}>1");
  Hist.fMetCorr_vs_dZvx=new TH2F(name,title,40,0.0,200.0,100,0.0,250.0);
  AddHistogram(Hist.fMetCorr_vs_dZvx,Folder);
  sprintf(name,"MetCorr_vs_dZvxWorse");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. worse #DeltaZ_{vx} for N_{vx}>1");
  Hist.fMetCorr_vs_dZvxWorse=new TH2F(name,title,40,0.0,200.0,100,0.0,250.0);
  AddHistogram(Hist.fMetCorr_vs_dZvxWorse,Folder);

  sprintf(name,"MetCorr_vs_ZvxBest");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. Z_{vx} of best vertex");
  Hist.fMetCorr_vs_ZvxBest=new TH2F(name,title,30,0.0,150.0,100,0.0,250.0);
  AddHistogram(Hist.fMetCorr_vs_ZvxBest,Folder);
  sprintf(name,"MetCorr_vs_Zvx2ndBest");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. Z_{vx} of 2nd best vertex");
  Hist.fMetCorr_vs_Zvx2ndBest=new TH2F(name,title,30,0.0,150.0,100,0.0,250.0);
  AddHistogram(Hist.fMetCorr_vs_Zvx2ndBest,Folder);
  sprintf(name,"MetCorr_vs_ZvxWorse");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. largest Z_{vx}");
  Hist.fMetCorr_vs_ZvxWorse=new TH2F(name,title,30,0.0,150.0,100,0.0,250.0);
  AddHistogram(Hist.fMetCorr_vs_ZvxWorse,Folder);
  sprintf(name,"Met0Met4_vs_Zvx");
  sprintf(title," %s%s",algoname,": #slash{E}_{T}^{meth0}-#slash{E}_{T}^{meth4} .vs. Z_{vx}");
  Hist.fMet0Met4_vs_Zvx=new TH2F(name,title,20,0.0,60.0,200,-250.0,250.0);
  AddHistogram(Hist.fMet0Met4_vs_Zvx,Folder);
  sprintf(name,"Met0_vs_Zvx");
  sprintf(title," %s%s",algoname,": #slash{E}_{T}^{meth0} .vs. Z_{vx}");
  Hist.fMet0_vs_Zvx=new TH2F(name,title,20,0.0,60.0,100,0.0,250.0);
  AddHistogram(Hist.fMet0_vs_Zvx,Folder);
  sprintf(name,"MetCorrVsZvxBest");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. Z_{vx} of best vertex");
  Hist.fMetCorrVsZvxBest=new TProfile(name,title,30,0.0,150.0,-1.0,250.0);
  AddHistogram(Hist.fMetCorrVsZvxBest,Folder);
  sprintf(name,"MetCorrVsZvx2ndBest");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. Z_{vx} of 2nd best vertex");
  Hist.fMetCorrVsZvx2ndBest=new TProfile(name,title,30,0.0,150.0,-1.0,250.0);
  AddHistogram(Hist.fMetCorrVsZvx2ndBest,Folder);
  sprintf(name,"MetCorrVsZvxWorse");
  sprintf(title," %s%s",algoname,": corrected #slash{E}_{T} .vs. largest Z_{vx}");
  Hist.fMetCorrVsZvxWorse=new TProfile(name,title,30,0.0,150.0,-1.0,250.0);
  AddHistogram(Hist.fMetCorrVsZvxWorse,Folder);

  return;
}

//________________________________________________booking pho-jet match histo
void TMyJetFilterModule::BookMatchStudyHistograms(MatchStudyHisto_t& Hist, const char* Folder, const char* algoname) {

  char name [200];
  char title[200];

  sprintf(name,"MatchNtwr");
  sprintf(title,"%s: Number of towers in matched jet",algoname);
  Hist.fMatchNtwr=new TH1F(name,title,50,-0.5,49.5);
  AddHistogram(Hist.fMatchNtwr,Folder);
  sprintf(name,"MatchDelR");
  sprintf(title,"%s: #Delta R between jet and matched EM object",algoname);
  Hist.fMatchDelR=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fMatchDelR,Folder);
  sprintf(name,"MatchDelPhi");
  sprintf(title,"%s: #Delta#phi between jet and matched EM object",algoname);
  Hist.fMatchDelPhi=new TH1F(name,title,200,0.0,4.0);
  AddHistogram(Hist.fMatchDelPhi,Folder);
  sprintf(name,"MatchDelEta");
  sprintf(title,"%s: #Delta#eta between jet and matched EM object",algoname);
  Hist.fMatchDelEta=new TH1F(name,title,200,0.0,4.0);
  AddHistogram(Hist.fMatchDelEta,Folder);
  sprintf(name,"MatchDelEtaDet");
  sprintf(title,"%s: #Delta#eta_{det} between jet and matched EM object",algoname);
  Hist.fMatchDelEtaDet=new TH1F(name,title,200,0.0,4.0);
  AddHistogram(Hist.fMatchDelEtaDet,Folder);
  sprintf(name,"MatchNmatch");
  sprintf(title," %s%s",algoname,": Number of matched EM objects");
  Hist.fMatchNmatch=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fMatchNmatch,Folder);
  sprintf(name,"MatchEt_raw_b");
  sprintf(title," %s%s",algoname,": raw E_{T} of jet before matching");
  Hist.fMatchEt_raw_b=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fMatchEt_raw_b,Folder);
  sprintf(name,"MatchEt_raw_a");
  sprintf(title," %s%s",algoname,": raw E_{T} of jet after matching");
  Hist.fMatchEt_raw_a=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fMatchEt_raw_a,Folder);
  sprintf(name,"MatchEt_lev6_b");
  sprintf(title," %s%s",algoname,": lev6 E_{T} of jet before matching");
  Hist.fMatchEt_lev6_b=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fMatchEt_lev6_b,Folder);
  sprintf(name,"MatchEt_lev6_a");
  sprintf(title," %s%s",algoname,": lev6 E_{T} of jet after matching");
  Hist.fMatchEt_lev6_a=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fMatchEt_lev6_a,Folder);
  sprintf(name,"MatchEtJet2EtPho_b");
  sprintf(title," %s%s",algoname,": raw E^{jet}_{T}/E^{EMobj}_{T} before removing EM object");
  Hist.fMatchEtJet2EtPho_b=new TH1F(name,title,1000,0.0,10.0);
  AddHistogram(Hist.fMatchEtJet2EtPho_b,Folder);
  sprintf(name,"MatchEtJet2EtPho_a");
  sprintf(title," %s%s",algoname,": raw E^{jet}_{T}/E^{EMobj}_{T} after removing EM object");
  Hist.fMatchEtJet2EtPho_a=new TH1F(name,title,1000,0.0,10.0);
  AddHistogram(Hist.fMatchEtJet2EtPho_a,Folder);
  sprintf(name,"MatchDelRoldnew");
  sprintf(title,"%s: #Delta R between new and old jet",algoname);
  Hist.fMatchDelRoldnew=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fMatchDelRoldnew,Folder);
  sprintf(name,"MatchDelEtaDetoldnew");
  sprintf(title,"%s: #Delta#eta_{det} between new and old jet",algoname);
  Hist.fMatchDelEtaDetoldnew=new TH1F(name,title,200,-4.0,4.0);
  AddHistogram(Hist.fMatchDelEtaDetoldnew,Folder);

  return;
}

//___________________________________________________diphoton Xsec hist
void TMyJetFilterModule::BookXsecStudyHistograms(DiphoXsecHisto_t& Hist, const char* Folder, const char* algoname) {

  char name [200];
  char title[200];

  sprintf(name,"XsecEt2toEt1");
  sprintf(title," %s%s",algoname,": E_{T}^{#gamma2}/E_{T}^{#gamma1}");
  Hist.fXsecEt2toEt1=new TH1F(name,title,100,0.0,1.0);
  AddHistogram(Hist.fXsecEt2toEt1,Folder);
  sprintf(name,"XsecEt2toEt1_reg1");
  sprintf(title," %s%s",algoname,": E_{T}^{#gamma2}/E_{T}^{#gamma1} if d#phi_{#gamma#gamma}<#pi/2");
  Hist.fXsecEt2toEt1_reg1=new TH1F(name,title,100,0.0,1.0);
  AddHistogram(Hist.fXsecEt2toEt1_reg1,Folder);
  sprintf(name,"XsecEt2toEt1_reg2");
  sprintf(title," %s%s",algoname,": E_{T}^{#gamma2}/E_{T}^{#gamma1} if d#phi_{#gamma#gamma}>#pi/2");
  Hist.fXsecEt2toEt1_reg2=new TH1F(name,title,100,0.0,1.0);
  AddHistogram(Hist.fXsecEt2toEt1_reg2,Folder);
  sprintf(name,"XsecMgg");
  sprintf(title," %s%s",algoname,": di-photon mass, M_{#gamma#gamma}");          
  Hist.fXsecMgg= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg,Folder);
  sprintf(name,"XsecMgg_reg1");
  sprintf(title," %s%s",algoname,": di-photon mass, M_{#gamma#gamma} if d#phi_{#gamma#gamma}<#pi/2");          
  Hist.fXsecMgg_reg1= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg_reg1,Folder);
  sprintf(name,"XsecMgg_reg2");
  sprintf(title," %s%s",algoname,": di-photon mass, M_{#gamma#gamma} if d#phi_{#gamma#gamma}>#pi/2");          
  Hist.fXsecMgg_reg2= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg_reg2,Folder);
  sprintf(name,"XsecQt");
  sprintf(title," %s%s",algoname,": di-photon momentum, q_{T}");          
  Hist.fXsecQt= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecQt,Folder);
  sprintf(name,"XsecQt_reg1");
  sprintf(title," %s%s",algoname,": di-photon momentum, q_{T} if d#phi_{#gamma#gamma}<#pi/2");          
  Hist.fXsecQt_reg1= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecQt_reg1,Folder);
  sprintf(name,"XsecQt_reg2");
  sprintf(title," %s%s",algoname,": di-photon momentum, q_{T} if d#phi_{#gamma#gamma}>#pi/2");          
  Hist.fXsecQt_reg2= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecQt_reg2,Folder);
  sprintf(name,"XsecEtjet");
  sprintf(title," %s%s",algoname,": E_{T} of leading jet");          
  Hist.fXsecEtjet= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecEtjet,Folder);
  sprintf(name,"XsecEtjet_reg1");
  sprintf(title," %s%s",algoname,": E_{T} of leading jet if d#phi_{#gamma#gamma}<#pi/2");          
  Hist.fXsecEtjet_reg1= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecEtjet_reg1,Folder);
  sprintf(name,"XsecEtjet_reg2");
  sprintf(title," %s%s",algoname,": E_{T} of leading jet if d#phi_{#gamma#gamma}>#pi/2");          
  Hist.fXsecEtjet_reg2= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecEtjet_reg2,Folder);
  sprintf(name,"XsecDelR_jetpho1");
  sprintf(title," %s%s",algoname,": #Delta R_{j#gamma1}");          
  Hist.fXsecDelR_jetpho1= new TH1F(name,title,600,0.0,6.0);          
  AddHistogram(Hist.fXsecDelR_jetpho1,Folder);
  sprintf(name,"XsecDelR_jetpho2");
  sprintf(title," %s%s",algoname,": #Delta R_{j#gamma2}");          
  Hist.fXsecDelR_jetpho2= new TH1F(name,title,600,0.0,6.0);          
  AddHistogram(Hist.fXsecDelR_jetpho2,Folder);
  sprintf(name,"XsecNjet15vsMgg");
  sprintf(title,"N_{jet15} vs M_{#gamma#gamma}");
  Hist.fXsecNjet15vsMgg=new TProfile(name,title,200,0.0,1000.0,-1.0,100.0);
  AddHistogram(Hist.fXsecNjet15vsMgg,Folder);
  sprintf(name,"XsecNjet20vsMgg");
  sprintf(title,"N_{jet20} vs M_{#gamma#gamma}");
  Hist.fXsecNjet20vsMgg=new TProfile(name,title,200,0.0,1000.0,-1.0,100.0);
  AddHistogram(Hist.fXsecNjet20vsMgg,Folder);
  sprintf(name,"XsecNjet25vsMgg");
  sprintf(title,"N_{jet25} vs M_{#gamma#gamma}");
  Hist.fXsecNjet25vsMgg=new TProfile(name,title,200,0.0,1000.0,-1.0,100.0);
  AddHistogram(Hist.fXsecNjet25vsMgg,Folder);

  sprintf(name,"XsecMgg_noJet15");
  sprintf(title," %s%s",algoname,": M_{#gamma#gamma} for events with N_{jet15}=0");          
  Hist.fXsecMgg_noJet15= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg_noJet15,Folder);
  sprintf(name,"XsecMgg_withJet15");
  sprintf(title," %s%s",algoname,": M_{#gamma#gamma} for events with N_{jet15}>0");          
  Hist.fXsecMgg_withJet15= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg_withJet15,Folder);

  sprintf(name,"XsecMgg_t1");
  sprintf(title," %s%s",algoname,": M_{#gamma#gamma} for events with M_{#gamma#gamma}<q_{T}");          
  Hist.fXsecMgg_t1= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg_t1,Folder);
  sprintf(name,"XsecMgg_t2");
  sprintf(title," %s%s",algoname,": M_{#gamma#gamma} for events with M_{#gamma#gamma}>=q_{T}");          
  Hist.fXsecMgg_t2= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecMgg_t2,Folder);
  sprintf(name,"XsecQt_t1");
  sprintf(title," %s%s",algoname,": di-photon momentum, q_{T}, for events with M_{#gamma#gamma}<q_{T}");          
  Hist.fXsecQt_t1= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecQt_t1,Folder);
  sprintf(name,"XsecQt_t2");
  sprintf(title," %s%s",algoname,": di-photon momentum, q_{T}, for events with M_{#gamma#gamma}>=q_{T}");          
  Hist.fXsecQt_t2= new TH1F(name,title,2000,0.0,2000.0);          
  AddHistogram(Hist.fXsecQt_t2,Folder);
  sprintf(name,"XsecQtvsMgg");
  sprintf(title,"q_{T} vs M_{#gamma#gamma}");
  Hist.fXsecQtvsMgg=new TProfile(name,title,100,0.0,500.0,-1.0,1000.0);
  AddHistogram(Hist.fXsecQtvsMgg,Folder);
  sprintf(name,"XsecMetVsQt");
  sprintf(title,"#slash{E}_{T} vs. q_{T}");
  Hist.fXsecMetVsQt=new TH2F(name,title,70,0.0,210.0,70,0.0,210.0);
  AddHistogram(Hist.fXsecMetVsQt,Folder);
  sprintf(name,"XsecDelPhi_t1");
  sprintf(title,"#Delta#phi_{#gamma#gamma} for events with M_{#gamma#gamma}<q_{T}");          
  Hist.fXsecDelPhi_t1= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fXsecDelPhi_t1,Folder);
  sprintf(name,"XsecDelPhi_t2");
  sprintf(title,"#Delta#phi_{#gamma#gamma} for events with M_{#gamma#gamma}>=q_{T}");          
  Hist.fXsecDelPhi_t2= new TH1F(name,title,315,0.0,3.15);          
  AddHistogram(Hist.fXsecDelPhi_t2,Folder);
  
  return;
}

//_________________________________________________ filling met cleanup histo (for studies)
void TMyJetFilterModule::BookMetCleanupHistograms(MetCleanupHisto_t& Hist, const char* Folder, const char* algoname) {

  char name [200];
  char title[200];

  sprintf(name,"CleanupDelPhiVsEtaDet_jet");
  sprintf(title," %s%s",algoname,": d#phi=#phi_{jet}-#phi_{#slash{E}_{T}} vs. #eta^{det}_{jet}");          
  Hist.fCleanupDelPhiVsEtaDet_jet= new TH2F(name,title,37,-3.7,3.7,16,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhiVsEtaDet_jet,Folder);
  sprintf(name,"CleanupDelPhiVsEtaDet_em");
  sprintf(title," %s%s",algoname,": d#phi=#phi_{e,#gamma}-#phi_{#slash{E}_{T}} vs. #eta^{det}_{e,#gamma}");          
  Hist.fCleanupDelPhiVsEtaDet_em= new TH2F(name,title,37,-3.7,3.7,16,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhiVsEtaDet_em,Folder);
  
  sprintf(name,"CleanupMetEtemVsDelPhi");
  sprintf(title," %s%s",algoname,": #slash{E}_{T}/E_{T}^{e,#gamma} vs. d#phi=#phi_{e,#gamma}-#phi_{#slash{E}_{T}}");          
  Hist.fCleanupMetEtemVsDelPhi= new TH2F(name,title,16,0.0,TMath::Pi(),50,0.0,10.0);          
  AddHistogram(Hist.fCleanupMetEtemVsDelPhi,Folder);
  sprintf(name,"CleanupDelPhi_metem");
  sprintf(title," %s%s",algoname,": d#phi=#phi_{e,#gamma}-#phi_{#slash{E}_{T}}");          
  Hist.fCleanupDelPhi_metem= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_metem,Folder);
  sprintf(name,"CleanupMetEtem");
  sprintf(title," %s%s",algoname,": #slash{E}_{T}/E_{T}^{e,#gamma}");          
  Hist.fCleanupMetEtem= new TH1F(name,title,800,0.0,20.0);          
  AddHistogram(Hist.fCleanupMetEtem,Folder);
  
  for(int i=0; i<3; i++)
    {
      char range[200];
      if(i==0) sprintf(range,", jet in crack");
      if(i==1) sprintf(range,", jet away from crack");
      if(i==2) sprintf(range,", jet in |#eta_{det}|>2.6");
      
      sprintf(name,"CleanupMetEtjetVsDelPhi[%i]",i);
      sprintf(title," %s: #slash{E}_{T}/E_{T}^{jet} vs. d#phi=#phi_{jet}-#phi_{#slash{E}_{T}}%s",algoname,range);          
      Hist.fCleanupMetEtjetVsDelPhi[i]= new TH2F(name,title,16,0.0,TMath::Pi(),50,0.0,10.0);          
      AddHistogram(Hist.fCleanupMetEtjetVsDelPhi[i],Folder);
      sprintf(name,"CleanupDelPhi_metjet[%i]",i);
      sprintf(title," %s: d#phi=#phi_{jet}-#phi_{#slash{E}_{T}}%s",algoname,range);          
      Hist.fCleanupDelPhi_metjet[i]= new TH1F(name,title,128,0.0,TMath::Pi());          
      AddHistogram(Hist.fCleanupDelPhi_metjet[i],Folder);
      sprintf(name,"CleanupMetEtjet[%i]",i);
      sprintf(title," %s: #slash{E}_{T}/E_{T}^{jet}%s",algoname,range);          
      Hist.fCleanupMetEtjet[i]= new TH1F(name,title,800,0.0,20.0);          
      AddHistogram(Hist.fCleanupMetEtjet[i],Folder);
    }
  
  sprintf(name,"CleanupDelPhi_RawMetRawJet3");
  sprintf(title," %s%s",algoname,": #Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}^{raw}}, closest jet with E_{T}^{raw}>3 GeV");          
  Hist.fCleanupDelPhi_RawMetRawJet3= new TH1F(name,title,126,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_RawMetRawJet3,Folder);
  sprintf(name,"CleanupDelPhi_RawMetRawJet5");
  sprintf(title," %s%s",algoname,": #Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}^{raw}}, closest jet with E_{T}^{raw}>5 GeV");          
  Hist.fCleanupDelPhi_RawMetRawJet5= new TH1F(name,title,126,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_RawMetRawJet5,Folder);
  sprintf(name,"CleanupDelPhi_RawMetRawJet10");
  sprintf(title," %s%s",algoname,": #Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}^{raw}}, closest jet with E_{T}^{raw}>10 GeV");          
  Hist.fCleanupDelPhi_RawMetRawJet10= new TH1F(name,title,126,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_RawMetRawJet10,Folder);
  sprintf(name,"CleanupDelPhi_RawMet1stRawJet");
  sprintf(title," %s%s",algoname,": #Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}^{raw}}, 1^{st} jet with E_{T}^{raw}>3 GeV");          
  Hist.fCleanupDelPhi_RawMet1stRawJet= new TH1F(name,title,126,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_RawMet1stRawJet,Folder);
  
  //----------------------------------------- histograms added on 04/03/07
  sprintf(name,"CleanupDelPhi_metjet5");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, E_{T}^{lev6}>5 GeV");          
  Hist.fCleanupDelPhi_metjet5= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_metjet5,Folder);
  sprintf(name,"CleanupDelPhi_metjet15");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, E_{T}^{lev6}>15 GeV");          
  Hist.fCleanupDelPhi_metjet15= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_metjet15,Folder);
  sprintf(name,"CleanupDelPhi_metjet25");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, E_{T}^{lev6}>25 GeV");          
  Hist.fCleanupDelPhi_metjet25= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_metjet25,Folder);
  sprintf(name,"CleanupDelPhi_met10jet15");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, E_{T}^{lev6}>15 GeV and #slash{E}_{T}>10 GeV");          
  Hist.fCleanupDelPhi_met10jet15= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_met10jet15,Folder);
  sprintf(name,"CleanupDelPhi_metjet1st15");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, 1^{st} jet with E_{T}^{lev6}>15 GeV");          
  Hist.fCleanupDelPhi_metjet1st15= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_metjet1st15,Folder);
  sprintf(name,"CleanupDelPhi_met10jet1st15");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, 1^{st} jet with E_{T}^{lev6}>15 GeV and #slash{E}_{T}>10 GeV");          
  Hist.fCleanupDelPhi_met10jet1st15= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_met10jet1st15,Folder);
  sprintf(name,"CleanupDelPhi_metjet15_dPhiMin");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, E_{T}^{lev6}>15 GeV and min(#Delta#phi)");          
  Hist.fCleanupDelPhi_metjet15_dPhiMin= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_metjet15_dPhiMin,Folder);
  sprintf(name,"CleanupDelPhi_met10jet15_dPhiMin");
  sprintf(title,"#Delta#phi=#phi_{jet}-#phi_{#slash{E}_{T}}, E_{T}^{lev6}>15 GeV, min(#Delta#phi), and #slash{E}_{T}>10 GeV");          
  Hist.fCleanupDelPhi_met10jet15_dPhiMin= new TH1F(name,title,128,0.0,TMath::Pi());          
  AddHistogram(Hist.fCleanupDelPhi_met10jet15_dPhiMin,Folder);
  
  return;
}

//______________________ MET-Vertex study histo
void TMyJetFilterModule::BookVxMetStudyHistograms(VxMetStudyHisto_t& Hist, const char* Folder) {
  char name [200];
  char title[200];

  sprintf(name,"SwapFrq");
  sprintf(title,"Frequency of vertex swap");          
  Hist.MetVxSwapFrq= new TH1F(name,title,3,-0.5,2.5);          
  AddHistogram(Hist.MetVxSwapFrq,Folder);
  sprintf(name,"DelMet");
  sprintf(title,"#slash{E}_{T}^{old}-#slash{E}_{T}^{new} after vertex swap");          
  Hist.MetVxDelMet= new TH1F(name,title,100,0.0,100.0);          
  AddHistogram(Hist.MetVxDelMet,Folder);
  sprintf(name,"OldMet");
  sprintf(title,"#slash{E}_{T}^{old} after vertex swap");          
  Hist.MetVxOldMet= new TH1F(name,title,500,0.0,500.0);          
  AddHistogram(Hist.MetVxOldMet,Folder);
  sprintf(name,"NewMet");
  sprintf(title,"#slash{E}_{T}^{new} after vertex swap");          
  Hist.MetVxNewMet= new TH1F(name,title,500,0.0,500.0);          
  AddHistogram(Hist.MetVxNewMet,Folder);
  sprintf(name,"Njet15");
  sprintf(title,"N_{jet15} in events after vertex swap");          
  Hist.MetVxNjet15= new TH1F(name,title,21,-0.5,20.5);          
  AddHistogram(Hist.MetVxNjet15,Folder);

  sprintf(name,"MetVxOldMet_vs_dZworse");
  sprintf(title,"corrected #slash{E}_{T}^{old} .vs. worse #DeltaZ_{vx} for N_{vx}>1");
  Hist.MetVxOldMet_vs_dZworse=new TProfile(name,title,30,0.0,150.0,-1.0,250.0);
  AddHistogram(Hist.MetVxOldMet_vs_dZworse,Folder);
  sprintf(name,"MetVxNewMet_vs_dZworse");
  sprintf(title,"corrected #slash{E}_{T}^{new} .vs. worse #DeltaZ_{vx} for N_{vx}>1");
  Hist.MetVxNewMet_vs_dZworse=new TProfile(name,title,30,0.0,150.0,-1.0,250.0);
  AddHistogram(Hist.MetVxNewMet_vs_dZworse,Folder);

  return;
}

//______________________________________________________________ booking Pho-Met study histograms
void TMyJetFilterModule::BookPhoMetStudyHistograms(PhoMetStudyHisto_t& Hist, const char* Folder) {
  char name [200];
  char title[200];

  sprintf(name,"eta");
  sprintf(title,"|#eta_{det}^{#gamma}|");
  Hist.fPhoMet_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_eta,Folder);
  sprintf(name,"xces");
  sprintf(title,"|X_{CES}|");
  Hist.fPhoMet_xces=new TH1F(name,title,86,0.0,23.0);
  AddHistogram(Hist.fPhoMet_xces,Folder);
  sprintf(name,"zces");
  sprintf(title,"|Z_{CES}|");
  Hist.fPhoMet_zces=new TH1F(name,title,240,0.0,240.0);
  AddHistogram(Hist.fPhoMet_zces,Folder);

  sprintf(name,"signeta");
  sprintf(title,"sign(Z_{vx})*#eta_{det}^{#gamma}");
  Hist.fPhoMet_signeta=new TH1F(name,title,240,-1.2,1.2);
  AddHistogram(Hist.fPhoMet_signeta,Folder);
  sprintf(name,"signzces");
  sprintf(title,"sign(Z_{vx})*Z_{CES}");
  Hist.fPhoMet_signzces=new TH1F(name,title,480,-240.0,240.0);
  AddHistogram(Hist.fPhoMet_signzces,Folder);
  sprintf(name,"MetSig5dPhi02_signeta");
  sprintf(title,"sign(Z_{vx})*#eta_{det}^{#gamma} if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi02_signeta=new TH1F(name,title,240,-1.2,1.2);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi02_signeta,Folder);
  sprintf(name,"MetSig5dPhi02_signzces");
  sprintf(title,"sign(Z_{vx})*Z_{CES} if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi02_signzces=new TH1F(name,title,480,-240.0,240.0);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi02_signzces,Folder);
  sprintf(name,"Fr_MetSig5dPhi02_signeta");
  sprintf(title,"Fraction of photons as a function of sign(Z_{vx})*#eta_{det}^{#gamma} if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi02_signeta=new TH1F(name,title,240,-1.2,1.2);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi02_signeta,Folder);
  sprintf(name,"Fr_MetSig5dPhi02_signzces");
  sprintf(title,"Fraction of photons as a function of sign(Z_{vx})*Z_{CES} if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi02_signzces=new TH1F(name,title,480,-240.0,240.0);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi02_signzces,Folder);

  sprintf(name,"dPhi02_eta");
  sprintf(title,"|#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2");
  Hist.fPhoMet_dPhi02_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_dPhi02_eta,Folder);
  sprintf(name,"dPhi02_xces");
  sprintf(title,"|X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2");
  Hist.fPhoMet_dPhi02_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_dPhi02_xces,Folder);
  sprintf(name,"dPhi02_zces");
  sprintf(title,"|Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2");
  Hist.fPhoMet_dPhi02_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_dPhi02_zces,Folder);
  sprintf(name,"dPhi01_eta");
  sprintf(title,"|#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1");
  Hist.fPhoMet_dPhi01_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_dPhi01_eta,Folder);
  sprintf(name,"dPhi01_xces");
  sprintf(title,"|X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1");
  Hist.fPhoMet_dPhi01_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_dPhi01_xces,Folder);
  sprintf(name,"dPhi01_zces");
  sprintf(title,"|Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1");
  Hist.fPhoMet_dPhi01_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_dPhi01_zces,Folder);

  sprintf(name,"Fr_dPhi02_eta");
  sprintf(title,"Fraction of photons as a function of |#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2");
  Hist.fPhoMet_Fr_dPhi02_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_Fr_dPhi02_eta,Folder);
  sprintf(name,"Fr_dPhi02_xces");
  sprintf(title,"Fraction of photons as a function of |X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2");
  Hist.fPhoMet_Fr_dPhi02_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_Fr_dPhi02_xces,Folder);
  sprintf(name,"Fr_dPhi02_zces");
  sprintf(title,"Fraction of photons as a function of |Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2");
  Hist.fPhoMet_Fr_dPhi02_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_Fr_dPhi02_zces,Folder);
  sprintf(name,"Fr_dPhi01_eta");
  sprintf(title,"Fraction of photons as a function of |#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1");
  Hist.fPhoMet_Fr_dPhi01_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_Fr_dPhi01_eta,Folder);
  sprintf(name,"Fr_dPhi01_xces");
  sprintf(title,"Fraction of photons as a function of |X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1");
  Hist.fPhoMet_Fr_dPhi01_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_Fr_dPhi01_xces,Folder);
  sprintf(name,"Fr_dPhi01_zces");
  sprintf(title,"Fraction of photons as a function of |Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1");
  Hist.fPhoMet_Fr_dPhi01_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_Fr_dPhi01_zces,Folder);

  sprintf(name,"MetSig5dPhi02_eta");
  sprintf(title,"|#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi02_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi02_eta,Folder);
  sprintf(name,"MetSig5dPhi02_xces");
  sprintf(title,"|X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi02_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi02_xces,Folder);
  sprintf(name,"MetSig5dPhi02_zces");
  sprintf(title,"|Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi02_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi02_zces,Folder);
  sprintf(name,"MetSig5dPhi01_eta");
  sprintf(title,"|#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi01_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi01_eta,Folder);
  sprintf(name,"MetSig5dPhi01_xces");
  sprintf(title,"|X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi01_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi01_xces,Folder);
  sprintf(name,"MetSig5dPhi01_zces");
  sprintf(title,"|Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_MetSig5dPhi01_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_MetSig5dPhi01_zces,Folder);

  sprintf(name,"Fr_MetSig5dPhi02_eta");
  sprintf(title,"Fraction of photons as a function of |#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi02_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi02_eta,Folder);
  sprintf(name,"Fr_MetSig5dPhi02_xces");
  sprintf(title,"Fraction of photons as a function of |X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi02_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi02_xces,Folder);
  sprintf(name,"Fr_MetSig5dPhi02_zces");
  sprintf(title,"Fraction of photons as a function of |Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi02_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi02_zces,Folder);
  sprintf(name,"Fr_MetSig5dPhi01_eta");
  sprintf(title,"Fraction of photons as a function of |#eta_{det}^{#gamma}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi01_eta=new TH1F(name,title,120,0.0,1.2);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi01_eta,Folder);
  sprintf(name,"Fr_MetSig5dPhi01_xces");
  sprintf(title,"Fraction of photons as a function of |X_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi01_xces=new TH1F(name,title,86,0.0,23);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi01_xces,Folder);
  sprintf(name,"Fr_MetSig5dPhi01_zces");
  sprintf(title,"Fraction of photons as a function of |Z_{CES}| if #Delta#phi_{#gamma#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{#gamma}}>5");
  Hist.fPhoMet_Fr_MetSig5dPhi01_zces=new TH1F(name,title,240,0.0,240);
  AddHistogram(Hist.fPhoMet_Fr_MetSig5dPhi01_zces,Folder);


  //--------------------------- correlation between electrons and met
  sprintf(name,"Ele_eta");
  sprintf(title,"|#eta_{det}^{ele}|");
  Hist.fEleMet_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_eta,Folder);
  sprintf(name,"Ele_phi");
  sprintf(title,"#phi_{det}");
  Hist.fEleMet_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_phi,Folder);

  sprintf(name,"Ele_dPhi02_eta");
  sprintf(title,"|#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.2");
  Hist.fEleMet_dPhi02_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_dPhi02_eta,Folder);
  sprintf(name,"Ele_dPhi02_phi");
  sprintf(title,"#phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.2");
  Hist.fEleMet_dPhi02_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_dPhi02_phi,Folder);
  sprintf(name,"Ele_dPhi01_eta");
  sprintf(title,"|#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.1");
  Hist.fEleMet_dPhi01_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_dPhi01_eta,Folder);
  sprintf(name,"Ele_dPhi01_phi");
  sprintf(title,"#phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.1");
  Hist.fEleMet_dPhi01_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_dPhi01_phi,Folder);

  sprintf(name,"Ele_Fr_dPhi02_eta");
  sprintf(title,"Fraction of electrons as a function of |#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.2");
  Hist.fEleMet_Fr_dPhi02_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_Fr_dPhi02_eta,Folder);
  sprintf(name,"Ele_Fr_dPhi02_phi");
  sprintf(title,"Fraction of electrons as a function of #phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.2");
  Hist.fEleMet_Fr_dPhi02_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_Fr_dPhi02_phi,Folder);
  sprintf(name,"Ele_Fr_dPhi01_eta");
  sprintf(title,"Fraction of electrons as a function of |#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.1");
  Hist.fEleMet_Fr_dPhi01_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_Fr_dPhi01_eta,Folder);
  sprintf(name,"Ele_Fr_dPhi01_phi");
  sprintf(title,"Fraction of electrons as a function of #phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.1");
  Hist.fEleMet_Fr_dPhi01_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_Fr_dPhi01_phi,Folder);

  sprintf(name,"Ele_MetSig5dPhi02_eta");
  sprintf(title,"|#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_MetSig5dPhi02_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_MetSig5dPhi02_eta,Folder);
  sprintf(name,"Ele_MetSig5dPhi02_phi");
  sprintf(title,"#phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_MetSig5dPhi02_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_MetSig5dPhi02_phi,Folder);
  sprintf(name,"Ele_MetSig5dPhi01_eta");
  sprintf(title,"|#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_MetSig5dPhi01_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_MetSig5dPhi01_eta,Folder);
  sprintf(name,"Ele_MetSig5dPhi01_phi");
  sprintf(title,"#phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_MetSig5dPhi01_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_MetSig5dPhi01_phi,Folder);

  sprintf(name,"Ele_Fr_MetSig5dPhi02_eta");
  sprintf(title,"Fraction of electrons as a function of |#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_Fr_MetSig5dPhi02_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_Fr_MetSig5dPhi02_eta,Folder);
  sprintf(name,"Ele_Fr_MetSig5dPhi02_phi");
  sprintf(title,"Fraction of electrons as a function of #phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.2 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_Fr_MetSig5dPhi02_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_Fr_MetSig5dPhi02_phi,Folder);
  sprintf(name,"Ele_Fr_MetSig5dPhi01_eta");
  sprintf(title,"Fraction of electrons as a function of |#eta_{det}^{ele}| if #Delta#phi_{e-#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_Fr_MetSig5dPhi01_eta=new TH1F(name,title,300,0.0,3.0);
  AddHistogram(Hist.fEleMet_Fr_MetSig5dPhi01_eta,Folder);
  sprintf(name,"Ele_Fr_MetSig5dPhi01_phi");
  sprintf(title,"Fraction of electrons as a function of #phi_{det} if #Delta#phi_{e-#slash{E}_{T}}<0.1 and #slash{E}_{T}/#sigma_{E_{T}^{ele}}>5");
  Hist.fEleMet_Fr_MetSig5dPhi01_phi=new TH1F(name,title,630,0.0,2.0*TMath::Pi());
  AddHistogram(Hist.fEleMet_Fr_MetSig5dPhi01_phi,Folder);

  return;
}

//___________________ filling analysis histograms
void TMyJetFilterModule::FillAnalysisHistograms(AnalysisHisto_t& Hist,JetStuff jetstuff,CommonStuff miscstuff,TVector2 Met,double metsig) {

  Hist.fAna_MetAll->Fill(Met.Mod()); // MET for all events
  Hist.fAna_MetSig->Fill(metsig); // MET-significance for all events
  // the following histrograms are only for events that pass MetSig cut
  if(metsig>=fMetSig_cut)
    {  
      double _dphi;
      double ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+Met.Mod();
      Hist.fAna_Ht->Fill(ht); // Ht--sum Et of all objects
      Hist.fAna_Met->Fill(Met.Mod()); // MET 
      Hist.fAna_Njet15->Fill(jetstuff.myNjet_th15); // Njet(Et>15)
      Hist.fAna_Njet20->Fill(jetstuff.myNjet_th20); // Njet(Et>20)
      Hist.fAna_Njet25->Fill(jetstuff.myNjet_th25); // Njet(Et>25)
      if(jetstuff.myNjet_th15>0) 
	{
	  _dphi=fabs(TVector2::Phi_mpi_pi(Met.Phi()-jetstuff.Jet_lev6_noEMobj[0].Phi()));
	  Hist.fAna_Etjet->Fill(jetstuff.Jet_lev6_noEMobj[0].Pt()); // Et of 1st jet with Et>15
	  Hist.fAna_dPhi3->Fill(_dphi); // dPhi(met-jet1)
	  if(jetstuff.myNjet_th20>0) Hist.fAna_dPhi4->Fill(_dphi); // dPhi(met-jet1)
	  if(jetstuff.myNjet_th25>0) Hist.fAna_dPhi5->Fill(_dphi); // dPhi(met-jet1)
	  
	}
      if(jetstuff.myNjet_th15>1) Hist.fAna_Mjj->Fill((jetstuff.Jet_lev6_noEMobj[0]+jetstuff.Jet_lev6_noEMobj[1]).M()); // Mjj (of two highest Et jets) if Njet15>=2
      Hist.fAna_Nem->Fill(miscstuff.myCorrElectron.size()+miscstuff.myCorrPhoton.size()); // number of EM objects: ele+pho

      //_______________ di-pho mode
      if(miscstuff.myCorrPhoton.size()>=2)
	{
	  _dphi=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[0].Phi()-miscstuff.myCorrPhoton[1].Phi()));
	  double dphi0=_dphi;
	  Hist.fAna_M->Fill((miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[1]).M()); // invariant mass of di-EM system 
	  Hist.fAna_dPhi->Fill(_dphi); // dPhi between two EM objects
	  Hist.fAna_Qt->Fill((miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[1]).Pt()); // qT of di-EM system
	  Hist.fAna_Et1->Fill(miscstuff.myCorrPhoton[0].Pt()); // Et of first EM object
	  Hist.fAna_Et2->Fill(miscstuff.myCorrPhoton[1].Pt()); // Et of second EM object
	  _dphi=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[0].Phi()-Met.Phi()));
	  double dphi1=_dphi;
	  Hist.fAna_dPhi1->Fill(_dphi); // dPhi(met-em1)
	  _dphi=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-Met.Phi()));
	  Hist.fAna_dPhi2->Fill(_dphi); // dPhi(met-em2)
	  double dphi2=_dphi;
	  if(jetstuff.myNjet_th15>0) 
	    {
	      Hist.fAna_Mej->Fill((miscstuff.myCorrPhoton[0]+jetstuff.Jet_lev6_noEMobj[0]).M()); // M(em-jet1) if Njet15>=1
	      Hist.fAna_Mej->Fill((miscstuff.myCorrPhoton[1]+jetstuff.Jet_lev6_noEMobj[0]).M()); // M(em-jet1) if Njet15>=1
	    }
	  for(int i=2; i<miscstuff.myCorrPhoton.size(); i++)
	    {
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Etem->Fill(miscstuff.myCorrPhoton[i].Pt()); // Et of extra EM objetcs
	    }
	  for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
	    {
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrPhoton[0]+miscstuff.myCorrElectron[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrElectron[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Etem->Fill(miscstuff.myCorrElectron[i].Pt()); // Et of extra EM objetcs
	    }
	  //----- new GMSB motivated histograms
          Hist.fAna_MetSig_vs_dPhi->Fill(metsig,dphi0);
          Hist.fAna_dPhi_vs_dPhi1->Fill(dphi1,dphi0);
          Hist.fAna_dPhi_vs_dPhi2->Fill(dphi2,dphi0);
	  Hist.fAna_Et1_vs_Ht->Fill(miscstuff.myCorrPhoton[0].Pt(),ht);
	  Hist.fAna_Et1_vs_dPhi->Fill(miscstuff.myCorrPhoton[0].Pt(),dphi0); 
	  Hist.fAna_Et1_vs_dPhi2->Fill(miscstuff.myCorrPhoton[0].Pt(),dphi2);
	  Hist.fAna_Ht_vs_dPhi->Fill(ht,dphi0);
	  Hist.fAna_Ht_vs_dPhi2->Fill(ht,dphi2);
	  Hist.fAna_dPhi6->Fill(fabs(TVector2::Phi_mpi_pi(dphi0+dphi1+dphi2-2.0*TMath::Pi()))); 
	  if(miscstuff.myCorrPhoton[0].Pt()>0.0) 
	    {
	      Hist.fAna_Ht2Et1->Fill(ht/miscstuff.myCorrPhoton[0].Pt());
	      Hist.fAna_Ht2Et1_vs_Ht->Fill(ht,ht/miscstuff.myCorrPhoton[0].Pt());
	      Hist.fAna_Ht2Et1_vs_dPhi->Fill(dphi0,ht/miscstuff.myCorrPhoton[0].Pt());
	      Hist.fAna_Ht2Et1_vs_dPhi2->Fill(dphi2,ht/miscstuff.myCorrPhoton[0].Pt()); 
	    }
	}
      //_______________ di-ele mode
      if(miscstuff.myCorrElectron.size()>=2 && miscstuff.myCorrPhoton.size()<2)
	{
	  _dphi=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrElectron[0].Phi()-miscstuff.myCorrElectron[1].Phi()));
	  Hist.fAna_M->Fill((miscstuff.myCorrElectron[0]+miscstuff.myCorrElectron[1]).M()); // invariant mass of di-EM system 
	  Hist.fAna_dPhi->Fill(_dphi); // dPhi between two EM objects
	  Hist.fAna_Qt->Fill((miscstuff.myCorrElectron[0]+miscstuff.myCorrElectron[1]).Pt()); // qT of di-EM system
	  Hist.fAna_Et1->Fill(miscstuff.myCorrElectron[0].Pt()); // Et of first EM object
	  Hist.fAna_Et2->Fill(miscstuff.myCorrElectron[1].Pt()); // Et of second EM object
	  _dphi=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrElectron[0].Phi()-Met.Phi()));
	  Hist.fAna_dPhi1->Fill(_dphi); // dPhi(met-em1)
	  _dphi=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrElectron[1].Phi()-Met.Phi()));
	  Hist.fAna_dPhi2->Fill(_dphi); // dPhi(met-em2)
	  if(jetstuff.myNjet_th15>0) 
	    {
	      Hist.fAna_Mej->Fill((miscstuff.myCorrElectron[0]+jetstuff.Jet_lev6_noEMobj[0]).M()); // M(em-jet1) if Njet15>=1
	      Hist.fAna_Mej->Fill((miscstuff.myCorrElectron[1]+jetstuff.Jet_lev6_noEMobj[0]).M()); // M(em-jet1) if Njet15>=1
	    }
	  for(int i=2; i<miscstuff.myCorrElectron.size(); i++)
	    {
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrElectron[0]+miscstuff.myCorrElectron[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrElectron[1]+miscstuff.myCorrElectron[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Etem->Fill(miscstuff.myCorrElectron[i].Pt()); // Et of extra EM objetcs
	    }
	  for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
	    {
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrElectron[0]+miscstuff.myCorrPhoton[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Mextra->Fill((miscstuff.myCorrElectron[1]+miscstuff.myCorrPhoton[i]).M()); // M(em1-emN) & M(em2-emN) if Nem>=3
	      Hist.fAna_Etem->Fill(miscstuff.myCorrPhoton[i].Pt()); // Et of extra EM objetcs
	    }	  
	}
    }

  return;
}



//____________________________________________________________________ filling histograms for pho-met study
void TMyJetFilterModule::FillPhoMetStudyHistograms(PhoMetStudyHisto_t& Hist, TVector2 Met, CommonStuff miscstuff, double zvx) {
  for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
    {
      double _dphi=fabs(TVector2::Phi_mpi_pi(Met.Phi()-miscstuff.myCorrPhoton[i].Phi()));
      double p0, p1;
      if(fabs(miscstuff.myPhoEtaDet[i])<1.1)
	{
	  p0=0.135*0.135;
	  p1=0.015*0.015;
	}
      else
	{
	  p0=0.16*0.16;
	  p1=0.01*0.01;	  
	}
      double metsig=Met.Mod()*cos(_dphi)/sqrt(miscstuff.myCorrPhoton[i].Pt()*p0+miscstuff.myCorrPhoton[i].Pt()*miscstuff.myCorrPhoton[i].Pt()*p1);
      Hist.fPhoMet_eta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
      Hist.fPhoMet_xces->Fill(fabs(miscstuff.myPhoXces[i]));
      Hist.fPhoMet_zces->Fill(fabs(miscstuff.myPhoZces[i])); 

      if(zvx*miscstuff.myPhoEtaDet[i]>0.0) Hist.fPhoMet_signeta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
      else Hist.fPhoMet_signeta->Fill(-1.0*fabs(miscstuff.myPhoEtaDet[i]));
      if(zvx*miscstuff.myPhoZces[i]>0.0) Hist.fPhoMet_signzces->Fill(fabs(miscstuff.myPhoZces[i]));
      else Hist.fPhoMet_signzces->Fill(-1.0*fabs(miscstuff.myPhoZces[i]));

      if(Met.Mod()>0.0 && _dphi<0.2)
	{
	  Hist.fPhoMet_dPhi02_eta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
	  Hist.fPhoMet_dPhi02_xces->Fill(fabs(miscstuff.myPhoXces[i]));
	  Hist.fPhoMet_dPhi02_zces->Fill(fabs(miscstuff.myPhoZces[i]));
	  if(metsig>5.0)
	    {
	      Hist.fPhoMet_MetSig5dPhi02_eta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
	      Hist.fPhoMet_MetSig5dPhi02_xces->Fill(fabs(miscstuff.myPhoXces[i]));
	      Hist.fPhoMet_MetSig5dPhi02_zces->Fill(fabs(miscstuff.myPhoZces[i]));	      
	      if(zvx*miscstuff.myPhoEtaDet[i]>0.0) Hist.fPhoMet_MetSig5dPhi02_signeta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
	      else Hist.fPhoMet_MetSig5dPhi02_signeta->Fill(-1.0*fabs(miscstuff.myPhoEtaDet[i]));
	      if(zvx*miscstuff.myPhoZces[i]>0.0) Hist.fPhoMet_MetSig5dPhi02_signzces->Fill(fabs(miscstuff.myPhoZces[i]));
	      else Hist.fPhoMet_MetSig5dPhi02_signzces->Fill(-1.0*fabs(miscstuff.myPhoZces[i]));
	    }
	  if(_dphi<0.1)
	    {
	      Hist.fPhoMet_dPhi01_eta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
	      Hist.fPhoMet_dPhi01_xces->Fill(fabs(miscstuff.myPhoXces[i]));
	      Hist.fPhoMet_dPhi01_zces->Fill(fabs(miscstuff.myPhoZces[i]));
	      if(metsig>5.0)
		{
		  Hist.fPhoMet_MetSig5dPhi01_eta->Fill(fabs(miscstuff.myPhoEtaDet[i]));
		  Hist.fPhoMet_MetSig5dPhi01_xces->Fill(fabs(miscstuff.myPhoXces[i]));
		  Hist.fPhoMet_MetSig5dPhi01_zces->Fill(fabs(miscstuff.myPhoZces[i]));
		}
	    }
	}
    }

  for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
    {
      double _dphi=fabs(TVector2::Phi_mpi_pi(Met.Phi()-miscstuff.myCorrElectron[i].Phi()));
      double p0, p1;
      if(fabs(miscstuff.myEleEtaDet[i])<1.1)
	{
	  p0=0.135*0.135;
	  p1=0.015*0.015;
	}
      else
	{
	  p0=0.16*0.16;
	  p1=0.01*0.01;	  
	}
      double metsig=Met.Mod()*cos(_dphi)/sqrt(miscstuff.myCorrElectron[i].Pt()*p0+miscstuff.myCorrElectron[i].Pt()*miscstuff.myCorrElectron[i].Pt()*p1);
      Hist.fEleMet_eta->Fill(fabs(miscstuff.myEleEtaDet[i]));
      Hist.fEleMet_phi->Fill(fabs(miscstuff.myElePhiDet[i]));

      if(Met.Mod()>0.0 && _dphi<0.2)
	{
	  Hist.fEleMet_dPhi02_eta->Fill(fabs(miscstuff.myEleEtaDet[i]));
	  Hist.fEleMet_dPhi02_phi->Fill(fabs(miscstuff.myElePhiDet[i]));
	  if(metsig>5.0)
	    {
	      Hist.fEleMet_MetSig5dPhi02_eta->Fill(fabs(miscstuff.myEleEtaDet[i]));
	      Hist.fEleMet_MetSig5dPhi02_phi->Fill(fabs(miscstuff.myElePhiDet[i]));
	    }
	  if(_dphi<0.1)
	    {
	      Hist.fEleMet_dPhi01_eta->Fill(fabs(miscstuff.myEleEtaDet[i]));
	      Hist.fEleMet_dPhi01_phi->Fill(fabs(miscstuff.myElePhiDet[i]));
	      if(metsig>5.0)
		{
		  Hist.fEleMet_MetSig5dPhi01_eta->Fill(fabs(miscstuff.myEleEtaDet[i]));
		  Hist.fEleMet_MetSig5dPhi01_phi->Fill(fabs(miscstuff.myElePhiDet[i]));
		}
	    }
	}
    }

  return;
}

//_____________________________________________ finalize histograms for pho-met study
void TMyJetFilterModule::DoFinalPhoMetHisto(PhoMetStudyHisto_t& Hist) {

  Hist.fPhoMet_Fr_dPhi02_eta->Sumw2(); 
  Hist.fPhoMet_Fr_dPhi02_xces->Sumw2();
  Hist.fPhoMet_Fr_dPhi02_zces->Sumw2();
  Hist.fPhoMet_Fr_dPhi01_eta->Sumw2(); 
  Hist.fPhoMet_Fr_dPhi01_xces->Sumw2();
  Hist.fPhoMet_Fr_dPhi01_zces->Sumw2();

  Hist.fPhoMet_Fr_MetSig5dPhi02_eta->Sumw2(); 
  Hist.fPhoMet_Fr_MetSig5dPhi02_xces->Sumw2();
  Hist.fPhoMet_Fr_MetSig5dPhi02_zces->Sumw2();
  Hist.fPhoMet_Fr_MetSig5dPhi01_eta->Sumw2(); 
  Hist.fPhoMet_Fr_MetSig5dPhi01_xces->Sumw2();
  Hist.fPhoMet_Fr_MetSig5dPhi01_zces->Sumw2();

  Hist.fPhoMet_Fr_MetSig5dPhi02_signeta->Sumw2(); 
  Hist.fPhoMet_Fr_MetSig5dPhi02_signzces->Sumw2();

  Hist.fPhoMet_Fr_dPhi02_eta->Divide(Hist.fPhoMet_dPhi02_eta,Hist.fPhoMet_eta); 
  Hist.fPhoMet_Fr_dPhi02_xces->Divide(Hist.fPhoMet_dPhi02_xces,Hist.fPhoMet_xces);
  Hist.fPhoMet_Fr_dPhi02_zces->Divide(Hist.fPhoMet_dPhi02_zces,Hist.fPhoMet_zces);
  Hist.fPhoMet_Fr_dPhi01_eta->Divide(Hist.fPhoMet_dPhi01_eta,Hist.fPhoMet_eta); 
  Hist.fPhoMet_Fr_dPhi01_xces->Divide(Hist.fPhoMet_dPhi01_xces,Hist.fPhoMet_xces);
  Hist.fPhoMet_Fr_dPhi01_zces->Divide(Hist.fPhoMet_dPhi01_zces,Hist.fPhoMet_zces);

  Hist.fPhoMet_Fr_MetSig5dPhi02_eta->Divide(Hist.fPhoMet_MetSig5dPhi02_eta,Hist.fPhoMet_eta); 
  Hist.fPhoMet_Fr_MetSig5dPhi02_xces->Divide(Hist.fPhoMet_MetSig5dPhi02_xces,Hist.fPhoMet_xces);
  Hist.fPhoMet_Fr_MetSig5dPhi02_zces->Divide(Hist.fPhoMet_MetSig5dPhi02_zces,Hist.fPhoMet_zces);
  Hist.fPhoMet_Fr_MetSig5dPhi01_eta->Divide(Hist.fPhoMet_MetSig5dPhi01_eta,Hist.fPhoMet_eta); 
  Hist.fPhoMet_Fr_MetSig5dPhi01_xces->Divide(Hist.fPhoMet_MetSig5dPhi01_xces,Hist.fPhoMet_xces);
  Hist.fPhoMet_Fr_MetSig5dPhi01_zces->Divide(Hist.fPhoMet_MetSig5dPhi01_zces,Hist.fPhoMet_zces);

  Hist.fPhoMet_Fr_MetSig5dPhi02_signeta->Divide(Hist.fPhoMet_MetSig5dPhi02_signeta,Hist.fPhoMet_signeta); 
  Hist.fPhoMet_Fr_MetSig5dPhi02_signzces->Divide(Hist.fPhoMet_MetSig5dPhi02_signzces,Hist.fPhoMet_signzces);


  //-------------------- correlation between electron and met ---------------------

  Hist.fEleMet_Fr_dPhi02_eta->Sumw2(); 
  Hist.fEleMet_Fr_dPhi02_phi->Sumw2();
  Hist.fEleMet_Fr_dPhi01_eta->Sumw2(); 
  Hist.fEleMet_Fr_dPhi01_phi->Sumw2();

  Hist.fEleMet_Fr_MetSig5dPhi02_eta->Sumw2(); 
  Hist.fEleMet_Fr_MetSig5dPhi02_phi->Sumw2();
  Hist.fEleMet_Fr_MetSig5dPhi01_eta->Sumw2(); 
  Hist.fEleMet_Fr_MetSig5dPhi01_phi->Sumw2();

  Hist.fEleMet_Fr_dPhi02_eta->Divide(Hist.fEleMet_dPhi02_eta,Hist.fEleMet_eta); 
  Hist.fEleMet_Fr_dPhi02_phi->Divide(Hist.fEleMet_dPhi02_phi,Hist.fEleMet_phi);
  Hist.fEleMet_Fr_dPhi01_eta->Divide(Hist.fEleMet_dPhi01_eta,Hist.fEleMet_eta); 
  Hist.fEleMet_Fr_dPhi01_phi->Divide(Hist.fEleMet_dPhi01_phi,Hist.fEleMet_phi);

  Hist.fEleMet_Fr_MetSig5dPhi02_eta->Divide(Hist.fEleMet_MetSig5dPhi02_eta,Hist.fEleMet_eta); 
  Hist.fEleMet_Fr_MetSig5dPhi02_phi->Divide(Hist.fEleMet_MetSig5dPhi02_phi,Hist.fEleMet_phi);
  Hist.fEleMet_Fr_MetSig5dPhi01_eta->Divide(Hist.fEleMet_MetSig5dPhi01_eta,Hist.fEleMet_eta); 
  Hist.fEleMet_Fr_MetSig5dPhi01_phi->Divide(Hist.fEleMet_MetSig5dPhi01_phi,Hist.fEleMet_phi);

  return;
}

//__________________________________ Filling histograms for Met cleanup studies
void TMyJetFilterModule::FillMetCleanupHistograms(MetCleanupHisto_t& Hist, JetStuff jetstuff, CommonStuff miscstuff, int metcode) {
  
  double dphi;
  double ratio;
  double etadet;
  double ptcut=0.0;
  TVector2 metvec(0.0,0.0);
  TVector2 metvec_raw(0.0,0.0);
  
  double dphi_3=10.0;
  double dphi_5=10.0;
  double dphi_10=10.0;
  double dphi_1st=10.0;
  
  if(metcode==1)
    {
      metvec.Set(jetstuff.myMETcorr_th5.Px(),jetstuff.myMETcorr_th5.Py());
      ptcut=5.0;
    }
  if(metcode==2)
    {
      metvec.Set(jetstuff.myMETcorr_th10.Px(),jetstuff.myMETcorr_th10.Py());
      ptcut=10.0;
    }
  if(metcode==3)
    {
      metvec.Set(jetstuff.myMETcorr_th15.Px(),jetstuff.myMETcorr_th15.Py());
      ptcut=15.0;
    }
  if(metcode==4)
    {
      metvec.Set(jetstuff.myMETcorr_th20.Px(),jetstuff.myMETcorr_th20.Py());
      ptcut=20.0;
    }
  if(metcode<1 || metcode>4)
    {
      metvec.Set(miscstuff.myMET_raw.Px(),miscstuff.myMET_raw.Py());
      ptcut=0.0;
    }
  metvec_raw.Set(miscstuff.myMET_raw.Px(),miscstuff.myMET_raw.Py());
  
  if(metvec.Mod()>0.0)
    {
      for(int i=0; i<miscstuff.myRawPhoton.size(); i++)
	{
	  dphi=fabs(TVector2::Phi_mpi_pi(metvec.Phi()-miscstuff.myRawPhoton[i].Phi()));
	  ratio=metvec.Mod()/miscstuff.myRawPhoton[i].Pt();
	  etadet=miscstuff.myPhoEtaDet[i];
	  Hist.fCleanupDelPhiVsEtaDet_em->Fill(etadet,dphi);
	  Hist.fCleanupDelPhi_metem->Fill(dphi);
	  Hist.fCleanupMetEtem->Fill(ratio);
	  Hist.fCleanupMetEtemVsDelPhi->Fill(dphi,ratio);
	}
      for(int i=0; i<miscstuff.myRawElectron.size(); i++)
	{
	  dphi=fabs(TVector2::Phi_mpi_pi(metvec.Phi()-miscstuff.myRawElectron[i].Phi()));
	  ratio=metvec.Mod()/miscstuff.myRawElectron[i].Pt();
	  etadet=miscstuff.myEleEtaDet[i];
	  Hist.fCleanupDelPhiVsEtaDet_em->Fill(etadet,dphi);
	  Hist.fCleanupDelPhi_metem->Fill(dphi);
	  Hist.fCleanupMetEtem->Fill(ratio);
	  Hist.fCleanupMetEtemVsDelPhi->Fill(dphi,ratio);
	}
      
      double maxEt=15.0; // new part as of 04/03/07
      double minDelPhi=10.0;  // new part as of 04/03/07
      double minDelPhi_1st=10.0;  // new part as of 04/03/07
      for(int i=0; i<jetstuff.Jet_lev6_noEMobj.size(); i++)
 	{
	  dphi=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(metvec.Phi())-TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[i].Phi()))); 
	  etadet=jetstuff.EtaDetCorr[i];
	  if((fabs(etadet)>0.2 && fabs(etadet)<0.9)
	     || (fabs(etadet)>1.3 && fabs(etadet)<2.6))
	    {
	      if(jetstuff.Jet_lev6_noEMobj[i].Pt()>maxEt && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<3.0)  // new part as of 04/03/07
		{
		  maxEt=jetstuff.Jet_lev6_noEMobj[i].Pt();
		  minDelPhi_1st=dphi;
		}
	      if(jetstuff.Jet_lev6_noEMobj[i].Pt()>15.0 
		 && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<3.0 
		 && dphi<minDelPhi) minDelPhi=dphi;  // new part as of 04/03/07
	      if(jetstuff.Jet_lev6_noEMobj[i].Pt()>5.0 
		 && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<3.0) Hist.fCleanupDelPhi_metjet5->Fill(dphi);  // new part as of 04/03/07
	      if(jetstuff.Jet_lev6_noEMobj[i].Pt()>15.0 
		 && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<3.0)   // new part as of 04/03/07
		{
		  Hist.fCleanupDelPhi_metjet15->Fill(dphi);
		  if(metvec.Mod()>10.0) Hist.fCleanupDelPhi_met10jet15->Fill(dphi);
		}
	      if(jetstuff.Jet_lev6_noEMobj[i].Pt()>25 
		 && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<3.0) Hist.fCleanupDelPhi_metjet25->Fill(dphi);  // new part as of 04/03/07
	    }
 	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>ptcut)
	    {
	      ratio=metvec.Mod()/jetstuff.Jet_lev6_noEMobj[i].Pt();
	      Hist.fCleanupDelPhiVsEtaDet_jet->Fill(etadet,dphi);	     
	      int j=1;
	      if(fabs(etadet)>2.6) j=2;
	      if(fabs(etadet)<0.2 || (fabs(etadet)>0.9 && fabs(etadet)<1.3)) j=0;	      
	      Hist.fCleanupDelPhi_metjet[j]->Fill(dphi);
	      Hist.fCleanupMetEtjet[j]->Fill(ratio);
	      Hist.fCleanupMetEtjetVsDelPhi[j]->Fill(dphi,ratio);
	    }
	}  
      if(minDelPhi_1st<=TMath::Pi())  // new part as of 04/03/07
	{
	  Hist.fCleanupDelPhi_metjet1st15->Fill(minDelPhi_1st);
	  if(metvec.Mod()>10.0) Hist.fCleanupDelPhi_met10jet1st15->Fill(minDelPhi_1st);
	}
      if(minDelPhi<=TMath::Pi())  // new part as of 04/03/07
	{
	  Hist.fCleanupDelPhi_metjet15_dPhiMin->Fill(minDelPhi);
	  if(metvec.Mod()>10.0) Hist.fCleanupDelPhi_met10jet15_dPhiMin->Fill(minDelPhi);
	}
    }  
  
  if(metvec_raw.Mod()>0.0)
    {
      double rawEtmax=0.0;
      for(int i=0; i<jetstuff.Jet_raw_noEMobj.size(); i++)
 	{
	  double _dphi=15.0; // dummy value 
	  if(jetstuff.Jet_raw_noEMobj[i].Pt()>3.0)
	    {
	      _dphi=fabs(TVector2::Phi_mpi_pi(metvec_raw.Phi()-jetstuff.Jet_raw_noEMobj[i].Phi()));
	      if(jetstuff.Jet_raw_noEMobj[i].Pt()>rawEtmax)
		{
		  rawEtmax=jetstuff.Jet_raw_noEMobj[i].Pt();
		  dphi_1st=_dphi;
		}
	      if(_dphi<dphi_3) dphi_3=_dphi;
	      if(jetstuff.Jet_raw_noEMobj[i].Pt()>5.0 && _dphi<dphi_5) dphi_5=_dphi;
	      if(jetstuff.Jet_raw_noEMobj[i].Pt()>10.0 && _dphi<dphi_10) dphi_10=_dphi;
	    }
	}
      if(dphi_3<3.2) Hist.fCleanupDelPhi_RawMetRawJet3->Fill(dphi_3);
      if(dphi_5<3.2) Hist.fCleanupDelPhi_RawMetRawJet5->Fill(dphi_5);
      if(dphi_10<3.2) Hist.fCleanupDelPhi_RawMetRawJet10->Fill(dphi_10);
      if(dphi_1st<3.2) Hist.fCleanupDelPhi_RawMet1stRawJet->Fill(dphi_1st);
    } 
  
  return;
}

//__________________________________ Filling histograms for GenMet cleanup studies
void TMyJetFilterModule::FillGenMetCleanupHistograms(MetCleanupHisto_t& Hist, JetStuff jetstuff, CommonStuff miscstuff, 
						     TVector2 genMet, std::vector<TLorentzVector> vec) {
  
  double dphi;
  double ratio;
  double etadet;
  double ptcut=15.0;
  if(genMet.Mod()>0.0 && genMet.Mod()<2000.0)
    {
      for(int i=0; i<miscstuff.myRawPhoton.size(); i++)
	{
	  dphi=fabs(TVector2::Phi_mpi_pi(genMet.Phi()-miscstuff.myRawPhoton[i].Phi()));
	  ratio=genMet.Mod()/miscstuff.myRawPhoton[i].Pt();
	  etadet=miscstuff.myPhoEtaDet[i];
	  Hist.fCleanupDelPhiVsEtaDet_em->Fill(etadet,dphi);
	  Hist.fCleanupDelPhi_metem->Fill(dphi);
	  Hist.fCleanupMetEtem->Fill(ratio);
	  Hist.fCleanupMetEtemVsDelPhi->Fill(dphi,ratio);
	}
      for(int i=0; i<miscstuff.myRawElectron.size(); i++)
	{
	  dphi=fabs(TVector2::Phi_mpi_pi(genMet.Phi()-miscstuff.myRawElectron[i].Phi()));
	  ratio=genMet.Mod()/miscstuff.myRawElectron[i].Pt();
	  etadet=miscstuff.myEleEtaDet[i];
	  Hist.fCleanupDelPhiVsEtaDet_em->Fill(etadet,dphi);
	  Hist.fCleanupDelPhi_metem->Fill(dphi);
	  Hist.fCleanupMetEtem->Fill(ratio);
	  Hist.fCleanupMetEtemVsDelPhi->Fill(dphi,ratio);
	}

      double maxEt=15.0; // new part as of 04/03/07
      double minDelPhi=10.0;  // new part as of 04/03/07
      double minDelPhi_1st=10.0;  // new part as of 04/03/07
      for(int i=0; i<vec.size(); i++)
 	{
	  dphi=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(genMet.Phi())-TVector2::Phi_0_2pi(vec[i].Phi())));
	  if(vec[i].Pt()>0.0) ratio=genMet.Mod()/vec[i].Pt();
	  else ratio=9999.0; // dummy value
	  etadet=jetstuff.EtaDetCorr[i];
	  if((fabs(etadet)>0.2 && fabs(etadet)<0.9)
	     || (fabs(etadet)>1.3 && fabs(etadet)<2.6))
	    {
	     if(vec[i].Pt()>maxEt && fabs(vec[i].Eta())<3.0)  // new part as of 04/03/07
	       {
		 maxEt=vec[i].Pt();
		 minDelPhi_1st=dphi;
	       }
	     if(vec[i].Pt()>15.0 
		&& fabs(vec[i].Eta())<3.0 
		&& dphi<minDelPhi) minDelPhi=dphi;  // new part as of 04/03/07
	     if(vec[i].Pt()>5.0 && fabs(vec[i].Eta())<3.0) Hist.fCleanupDelPhi_metjet5->Fill(dphi);  // new part as of 04/03/07
	     if(vec[i].Pt()>15.0 && fabs(vec[i].Eta())<3.0)   // new part as of 04/03/07
	       {
		 Hist.fCleanupDelPhi_metjet15->Fill(dphi);
		 if(genMet.Mod()>10.0) Hist.fCleanupDelPhi_met10jet15->Fill(dphi);
	       }
	     if(vec[i].Pt()>25 && fabs(vec[i].Eta())<3.0) Hist.fCleanupDelPhi_metjet25->Fill(dphi);  // new part as of 04/03/07
	    }
	  if(vec[i].Pt()>ptcut)
	    {
	      Hist.fCleanupDelPhiVsEtaDet_jet->Fill(etadet,dphi);	     
	      int j=1;
	      if(fabs(etadet)>2.6) j=2;
	      if(fabs(etadet)<0.2 || (fabs(etadet)>0.9 && fabs(etadet)<1.3)) j=0;	      
	      Hist.fCleanupDelPhi_metjet[j]->Fill(dphi);
	      Hist.fCleanupMetEtjet[j]->Fill(ratio);
	      Hist.fCleanupMetEtjetVsDelPhi[j]->Fill(dphi,ratio);
	    }
	}
      if(minDelPhi_1st<=TMath::Pi())  // new part as of 04/03/07
	{
	  Hist.fCleanupDelPhi_metjet1st15->Fill(minDelPhi_1st);
	  if(genMet.Mod()>10.0) Hist.fCleanupDelPhi_met10jet1st15->Fill(minDelPhi_1st);
	}
      if(minDelPhi<=TMath::Pi())  // new part as of 04/03/07
	{
	  Hist.fCleanupDelPhi_metjet15_dPhiMin->Fill(minDelPhi);
	  if(genMet.Mod()>10.0) Hist.fCleanupDelPhi_met10jet15_dPhiMin->Fill(minDelPhi);
	}
    }  
  return;
}

//_____________________________ calculates dPhi for metsig.vs.dPhi studies
void TMyJetFilterModule::CalculateMetDelPhi(MetSigDelPhiStuff &msdp_stuff,JetStuff jetstuff,CommonStuff miscstuff,TVector2 MetVec) {
  msdp_stuff.eta_det_em=10.0; // detEta of closest EM object
  msdp_stuff.eta_det_jet=10.0; // detEta of closest jet
  msdp_stuff.xces_em=25.0; // X_ces of closest EM
  for(int ij=0; ij<5; ij++)
    {
      msdp_stuff.dPhi_det[ij]=10.0; // initial dummy value
    }

  for(int ij=0; ij<miscstuff.myCorrPhoton.size(); ij++)
    {
      double _dphi_d=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(miscstuff.myCorrPhoton[ij].Phi())-TVector2::Phi_0_2pi(MetVec.Phi())));
      if(ij==0) msdp_stuff.dPhi_det[3]=_dphi_d;
      if(_dphi_d<msdp_stuff.dPhi_det[1]) 
	{
	  msdp_stuff.dPhi_det[1]=_dphi_d;
	  msdp_stuff.eta_det_em=miscstuff.myPhoEtaDet[ij];
	  msdp_stuff.xces_em=miscstuff.myPhoXces[ij];
	} 
    }
  for(int ij=0; ij<miscstuff.myCorrElectron.size(); ij++)
    {
      double _dphi_d=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(miscstuff.myCorrElectron[ij].Phi())-TVector2::Phi_0_2pi(MetVec.Phi())));
      if(ij==0) 
	{
	  if(miscstuff.myCorrPhoton.size()>0) // make sure there are photons before next step
	    {
	      if(miscstuff.myCorrElectron[0].Pt()>miscstuff.myCorrPhoton[0].Pt()) msdp_stuff.dPhi_det[3]=_dphi_d;
	    }
	  else msdp_stuff.dPhi_det[3]=_dphi_d;
	}
      if(_dphi_d<msdp_stuff.dPhi_det[1]) 
	{
	  msdp_stuff.dPhi_det[1]=_dphi_d;
	  msdp_stuff.eta_det_em=miscstuff.myEleEtaDet[ij];
	  msdp_stuff.xces_em=miscstuff.myEleXces[ij];
	} 
    }
  double max_jet_Pt=0.0;
  for(int ij=0; ij<jetstuff.Jet_lev6_noEMobj.size(); ij++)
    {
      if(jetstuff.Jet_lev6_noEMobj[ij].Pt()>3.0 && (jetstuff.Npho_match[ij]+jetstuff.Nele_match[ij])==0)
	{
	  double _dphi_d=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[ij].Phi())-TVector2::Phi_0_2pi(MetVec.Phi())));
	  if(jetstuff.Jet_lev6_noEMobj[ij].Pt()>max_jet_Pt) 
	    {
	      max_jet_Pt=jetstuff.Jet_lev6_noEMobj[ij].Pt();
	      msdp_stuff.dPhi_det[4]=_dphi_d;
	    }
	  if(_dphi_d<msdp_stuff.dPhi_det[2]) 
	    {
	      msdp_stuff.dPhi_det[2]=_dphi_d;
	      msdp_stuff.eta_det_jet=jetstuff.EtaDetCorr[ij];
	    } 
	}
    }
  if(msdp_stuff.dPhi_det[2]<msdp_stuff.dPhi_det[1]) msdp_stuff.dPhi_det[0]=msdp_stuff.dPhi_det[2];
  else msdp_stuff.dPhi_det[0]=msdp_stuff.dPhi_det[1];

  return;
}

//_______________________ returns difference between two histograms in bin=bin_ind
double TMyJetFilterModule::HistoBinDiff(TH1F* h,TH1F* h1,TH1F* h2,int bin_ind)
{
  double value=0.0;
  double v0=h->GetBinContent(bin_ind+1);
  double err=h->GetBinError(bin_ind+1);
  double v1=h1->GetBinContent(bin_ind+1);
  double v2=h2->GetBinContent(bin_ind+1);
  value=(fabs(v0-v1) > fabs(v0-v2)) ? sqrt(err*err+(v0-v1)*(v0-v1)) : sqrt(err*err+(v0-v2)*(v0-v2));
  return value;
}

//_______________________ finalize analysis histograms
void TMyJetFilterModule::DoFinalAnalysisHisto(AnalysisHisto_t& HistF,AnalysisHisto_t Hist1,AnalysisHisto_t Hist2) {

  for(int i=0; i<23; i++)
    {
      int nbins=0;
      if(i==0) nbins=HistF.fAna_MetAll->GetNbinsX(); 
      if(i==1) nbins=HistF.fAna_MetSig->GetNbinsX();
      if(i==2) nbins=HistF.fAna_Met->GetNbinsX();
      if(i==3) nbins=HistF.fAna_M->GetNbinsX();
      if(i==4) nbins=HistF.fAna_dPhi->GetNbinsX();
      if(i==5) nbins=HistF.fAna_Njet15->GetNbinsX();
      if(i==6) nbins=HistF.fAna_Qt->GetNbinsX();
      if(i==7) nbins=HistF.fAna_Et1->GetNbinsX();
      if(i==8) nbins=HistF.fAna_Et2->GetNbinsX();
      if(i==9) nbins=HistF.fAna_Etjet->GetNbinsX();
      if(i==10) nbins=HistF.fAna_Ht->GetNbinsX();
      if(i==11) nbins=HistF.fAna_Mjj->GetNbinsX();
      if(i==12) nbins=HistF.fAna_Nem->GetNbinsX();
      if(i==13) nbins=HistF.fAna_Mej->GetNbinsX();
      if(i==14) nbins=HistF.fAna_Mextra->GetNbinsX();
      if(i==15) nbins=HistF.fAna_Etem->GetNbinsX();
      if(i==16) nbins=HistF.fAna_dPhi1->GetNbinsX();
      if(i==17) nbins=HistF.fAna_dPhi2->GetNbinsX();
      if(i==18) nbins=HistF.fAna_dPhi3->GetNbinsX();
      if(i==19) nbins=HistF.fAna_dPhi4->GetNbinsX();
      if(i==20) nbins=HistF.fAna_dPhi5->GetNbinsX();
      if(i==21) nbins=HistF.fAna_Njet20->GetNbinsX();
      if(i==22) nbins=HistF.fAna_Njet25->GetNbinsX();
   
      for(int j=0; j<nbins; j++)
	{
	  if(i==0) HistF.fAna_MetAll->SetBinError(j+1,HistoBinDiff(HistF.fAna_MetAll,Hist1.fAna_MetAll,Hist2.fAna_MetAll,j)); 
	  if(i==1) HistF.fAna_MetSig->SetBinError(j+1,HistoBinDiff(HistF.fAna_MetSig,Hist1.fAna_MetSig,Hist2.fAna_MetSig,j));
	  if(i==2) HistF.fAna_Met->SetBinError(j+1,HistoBinDiff(HistF.fAna_Met,Hist1.fAna_Met,Hist2.fAna_Met,j));
	  if(i==3) HistF.fAna_M->SetBinError(j+1,HistoBinDiff(HistF.fAna_M,Hist1.fAna_M,Hist2.fAna_M,j));
	  if(i==4) HistF.fAna_dPhi->SetBinError(j+1,HistoBinDiff(HistF.fAna_dPhi,Hist1.fAna_dPhi,Hist2.fAna_dPhi,j));
	  if(i==5) HistF.fAna_Njet15->SetBinError(j+1,HistoBinDiff(HistF.fAna_Njet15,Hist1.fAna_Njet15,Hist2.fAna_Njet15,j));
	  if(i==6) HistF.fAna_Qt->SetBinError(j+1,HistoBinDiff(HistF.fAna_Qt,Hist1.fAna_Qt,Hist2.fAna_Qt,j));
	  if(i==7) HistF.fAna_Et1->SetBinError(j+1,HistoBinDiff(HistF.fAna_Et1,Hist1.fAna_Et1,Hist2.fAna_Et1,j));
	  if(i==8) HistF.fAna_Et2->SetBinError(j+1,HistoBinDiff(HistF.fAna_Et2,Hist1.fAna_Et2,Hist2.fAna_Et2,j));
	  if(i==9) HistF.fAna_Etjet->SetBinError(j+1,HistoBinDiff(HistF.fAna_Etjet,Hist1.fAna_Etjet,Hist2.fAna_Etjet,j));
	  if(i==10) HistF.fAna_Ht->SetBinError(j+1,HistoBinDiff(HistF.fAna_Ht,Hist1.fAna_Ht,Hist2.fAna_Ht,j));
	  if(i==11) HistF.fAna_Mjj->SetBinError(j+1,HistoBinDiff(HistF.fAna_Mjj,Hist1.fAna_Mjj,Hist2.fAna_Mjj,j));
	  if(i==12) HistF.fAna_Nem->SetBinError(j+1,HistoBinDiff(HistF.fAna_Nem,Hist1.fAna_Nem,Hist2.fAna_Nem,j));
	  if(i==13) HistF.fAna_Mej->SetBinError(j+1,HistoBinDiff(HistF.fAna_Mej,Hist1.fAna_Mej,Hist2.fAna_Mej,j));
	  if(i==14) HistF.fAna_Mextra->SetBinError(j+1,HistoBinDiff(HistF.fAna_Mextra,Hist1.fAna_Mextra,Hist2.fAna_Mextra,j));
	  if(i==15) HistF.fAna_Etem->SetBinError(j+1,HistoBinDiff(HistF.fAna_Etem,Hist1.fAna_Etem,Hist2.fAna_Etem,j));
	  if(i==16) HistF.fAna_dPhi1->SetBinError(j+1,HistoBinDiff(HistF.fAna_dPhi1,Hist1.fAna_dPhi1,Hist2.fAna_dPhi1,j));
	  if(i==17) HistF.fAna_dPhi2->SetBinError(j+1,HistoBinDiff(HistF.fAna_dPhi2,Hist1.fAna_dPhi2,Hist2.fAna_dPhi2,j));
	  if(i==18) HistF.fAna_dPhi3->SetBinError(j+1,HistoBinDiff(HistF.fAna_dPhi3,Hist1.fAna_dPhi3,Hist2.fAna_dPhi3,j));
	  if(i==19) HistF.fAna_dPhi4->SetBinError(j+1,HistoBinDiff(HistF.fAna_dPhi4,Hist1.fAna_dPhi4,Hist2.fAna_dPhi4,j));
	  if(i==20) HistF.fAna_dPhi5->SetBinError(j+1,HistoBinDiff(HistF.fAna_dPhi5,Hist1.fAna_dPhi5,Hist2.fAna_dPhi5,j));
	  if(i==21) HistF.fAna_Njet20->SetBinError(j+1,HistoBinDiff(HistF.fAna_Njet20,Hist1.fAna_Njet20,Hist2.fAna_Njet20,j));
	  if(i==22) HistF.fAna_Njet25->SetBinError(j+1,HistoBinDiff(HistF.fAna_Njet25,Hist1.fAna_Njet25,Hist2.fAna_Njet25,j));

	}
    }
  return;
}

//_____ counts data & background(metmodel) events with MetSig>cut
//----- systcode=-1 is for data, systcode=0,..19 for background
void TMyJetFilterModule::MyEventCount(double met,double metsig,int systcode,MetResults &metstuff)
{
  if(metsig>=fMetSig_cut)
    {
      int njet15=0;
      int njet20=0;
      int njet25=0;
      njet15= (jet04stuff.myNjet_th15 < 10) ? jet04stuff.myNjet_th15 : 9; 
      njet20= (jet04stuff.myNjet_th20 < 10) ? jet04stuff.myNjet_th20 : 9; 
      njet25= (jet04stuff.myNjet_th25 < 10) ? jet04stuff.myNjet_th25 : 9; 
  
      if(met>20) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana20Njet_dt[0][njet15]++;
	      metstuff.ana20Njet_dt[1][njet20]++;
	      metstuff.ana20Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana20Njet_bg[systcode][0][njet15]++;
	      metstuff.ana20Njet_bg[systcode][1][njet20]++;
	      metstuff.ana20Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>25) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana25Njet_dt[0][njet15]++;
	      metstuff.ana25Njet_dt[1][njet20]++;
	      metstuff.ana25Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana25Njet_bg[systcode][0][njet15]++;
	      metstuff.ana25Njet_bg[systcode][1][njet20]++;
	      metstuff.ana25Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>30) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana30Njet_dt[0][njet15]++;
	      metstuff.ana30Njet_dt[1][njet20]++;
	      metstuff.ana30Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana30Njet_bg[systcode][0][njet15]++;
	      metstuff.ana30Njet_bg[systcode][1][njet20]++;
	      metstuff.ana30Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>35) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana35Njet_dt[0][njet15]++;
	      metstuff.ana35Njet_dt[1][njet20]++;
	      metstuff.ana35Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana35Njet_bg[systcode][0][njet15]++;
	      metstuff.ana35Njet_bg[systcode][1][njet20]++;
	      metstuff.ana35Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>40) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana40Njet_dt[0][njet15]++;
	      metstuff.ana40Njet_dt[1][njet20]++;
	      metstuff.ana40Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana40Njet_bg[systcode][0][njet15]++;
	      metstuff.ana40Njet_bg[systcode][1][njet20]++;
	      metstuff.ana40Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>45) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana45Njet_dt[0][njet15]++;
	      metstuff.ana45Njet_dt[1][njet20]++;
	      metstuff.ana45Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana45Njet_bg[systcode][0][njet15]++;
	      metstuff.ana45Njet_bg[systcode][1][njet20]++;
	      metstuff.ana45Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>50) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana50Njet_dt[0][njet15]++;
	      metstuff.ana50Njet_dt[1][njet20]++;
	      metstuff.ana50Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana50Njet_bg[systcode][0][njet15]++;
	      metstuff.ana50Njet_bg[systcode][1][njet20]++;
	      metstuff.ana50Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>75) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana75Njet_dt[0][njet15]++;
	      metstuff.ana75Njet_dt[1][njet20]++;
	      metstuff.ana75Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana75Njet_bg[systcode][0][njet15]++;
	      metstuff.ana75Njet_bg[systcode][1][njet20]++;
	      metstuff.ana75Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>100) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana100Njet_dt[0][njet15]++;
	      metstuff.ana100Njet_dt[1][njet20]++;
	      metstuff.ana100Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana100Njet_bg[systcode][0][njet15]++;
	      metstuff.ana100Njet_bg[systcode][1][njet20]++;
	      metstuff.ana100Njet_bg[systcode][2][njet25]++;
	    }
	}
      if(met>150) 
	{
	  if(systcode==-1)
	    {
	      metstuff.ana150Njet_dt[0][njet15]++;
	      metstuff.ana150Njet_dt[1][njet20]++;
	      metstuff.ana150Njet_dt[2][njet25]++;
	    }
	  else
	    {
	      metstuff.ana150Njet_bg[systcode][0][njet15]++;
	      metstuff.ana150Njet_bg[systcode][1][njet20]++;
	      metstuff.ana150Njet_bg[systcode][2][njet25]++;
	    }
	}
    }
  return;
}

//_____________________________________ generates Met predictions and fills out analysis histograms
void TMyJetFilterModule::DoMyAnalysis(JetStuff jetstuff,CommonStuff miscstuff) {
  if(fAnalysisMode==1)
    {

      int metcode=3;
      //______________________ data
      double metSig_est=MyTotalMetSignificance(jetstuff,jetstuff.myMETcorr_th15,0,0);
      myMetSig=metSig_est; // filling my Met Significance
      int Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,jetstuff.myMETcorr_th15); // met cleanup cut
      int gmsb_event=1;
      double _dPhi0=0.0; //dummy
      double _dPhi2=10.0; //dummy
      if(miscstuff.myCorrPhoton.size()>1) 
	{
	  _dPhi0=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[0].Phi()-miscstuff.myCorrPhoton[1].Phi()));
	  _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-jetstuff.myMETcorr_th15.Phi()));
	}
      if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),MyHtAll(jetstuff,miscstuff,3),myMetSig,jetstuff.myNjet_th15)<1) gmsb_event=0;
      if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),MyHtAll(jetstuff,miscstuff,3),myMetSig,jetstuff.myNjet_th15)>0) gmsb_event=0;
      if(Nbadmet==0 && gmsb_event==1) 
	{
	  FillAnalysisHistograms(fAna_data,jetstuff,miscstuff,jetstuff.myMETcorr_th15,metSig_est);// filling analysis histograms
	  MyEventCount(jetstuff.myMETcorr_th15.Mod(),metSig_est,-1,met_results);
	} 
      //______________________ MetModel part: pseudo-experiments
      for(int k=0; k<Npoints; k++)
	{
	  //______________________ Met Model default prediction
	  int rnd_seed=gRandom->GetSeed();
	  TVector2 myGenMet(0.0,0.0);
	  int jer_code=0; // JER systematics code
	  int ue_code=0; // unclustered energy parameterization systematics 
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  myMetSig_gen=metSig_est;
	  myGenMetVec.Set(myGenMet.Px(),myGenMet.Py());
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;
	  double ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_def,jetstuff,miscstuff,myGenMet,metSig_est);
	      FillAnalysisHistograms(fAna_bckg,jetstuff,miscstuff,myGenMet,metSig_est); // Met Model total prediction (stat+syst)
	      MyEventCount(myGenMet.Mod(),metSig_est,0,met_results); 
	    }
	  //______________________ Met Model systematics: z->ee vs. dipho sideband parameterization
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=1;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue1,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,1,met_results); 
	    }
	  //______________________ Met Model Uncl. En. systematics: mean-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=-2;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue2,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,2,met_results); 
	    }
	  //______________________ Met Model Uncl. En. systematics: mean+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=2;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue3,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,3,met_results); 
	    }
	  //______________________ Met Model Uncl. En. systematics: sigma-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=-3;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue4,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,4,met_results); 
	    }	  
	  //______________________ Met Model Uncl. En. systematics: sigma+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=3;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue5,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,5,met_results); 
	    }	  
	  //______________________ Met Model Uncl. En. systematics: scale-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=-4;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue6,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,6,met_results); 
	    }	  
	  //______________________ Met Model Uncl. En. systematics: scale+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=4;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue7,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,7,met_results); 
	    }	  
	  //______________________ Met Model Uncl. En. systematics: norm-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=-5;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue8,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,8,met_results); 
	    }	  
	  //______________________ Met Model Uncl. En. systematics: norm+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=0;
	  ue_code=5;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_ue9,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,9,met_results);
	    }

	  //______________________ Met Model JER systematics: meanG-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=-1;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer1,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,10,met_results);
	    }
	  //______________________ Met Model JER systematics: meanG+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=1;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer2,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,11,met_results);
	    }
	  //______________________ Met Model JER systematics: sigmaG-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=-2;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer3,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,12,met_results);
	    }
	  //______________________ Met Model JER systematics: sigmaG+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=2;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer4,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,13,met_results);
	    }
	  //______________________ Met Model JER systematics: mpvL-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=-3;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer5,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,14,met_results);
	    }
	  //______________________ Met Model JER systematics: mpvL+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=3;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer6,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,15,met_results);
	    }
	  //______________________ Met Model JER systematics: sigmaL-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=-4;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer7,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,16,met_results);
	    }
	  //______________________ Met Model JER systematics: sigmaL+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=4;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer8,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,17,met_results);
	    }
	  //______________________ Met Model JER systematics: norm-G
	  myGenMet.Set(0.0,0.0);
	  jer_code=-5;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer9,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,18,met_results);
	    }
	  //______________________ Met Model JER systematics: norm+G
	  myGenMet.Set(0.0,0.0);
	  jer_code=5;
	  ue_code=0;
	  GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,jer_code,ue_code,metcode,rnd_seed,myGenMet);
	  metSig_est=MyTotalMetSignificance(jetstuff,myGenMet,jer_code,ue_code);
	  Nbadmet=MyMetCleanUpCut(jetstuff,miscstuff,jetstuff.Jet_lev6_noEMobj,myGenMet); // met cleanup cut     
	  gmsb_event=1;	  
	  ht=MyHtAll(jetstuff,miscstuff,3)-jetstuff.myMETcorr_th15.Mod()+myGenMet.Mod();
	  if(miscstuff.myCorrPhoton.size()>1) _dPhi2=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[1].Phi()-myGenMet.Phi()));
	  if(fSelectGMSBevent==1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)<1) gmsb_event=0;
	  if(fSelectGMSBevent==-1 && MyGMSBevent(_dPhi0,_dPhi2,miscstuff.myCorrPhoton[0].Pt(),ht,myMetSig_gen,jetstuff.myNjet_th15)>0) gmsb_event=0;
	  if(Nbadmet==0 && gmsb_event==1) 
	    {
	      FillAnalysisHistograms(fAna_jer10,jetstuff,miscstuff,myGenMet,metSig_est);
	      MyEventCount(myGenMet.Mod(),metSig_est,19,met_results);
	    }
	}      
    }
  return;
}


//_________________________________________________ filling met histo
void TMyJetFilterModule::FillMetStudyHistograms(MetStudyHisto_t& Hist, JetStuff jetstuff, CommonStuff miscstuff, 
						int metcode, int nvx, double dzvx, double dzvx_worse, double zvx[3]) {
  
  double mgg=0.0;
  if(miscstuff.myCorrPhoton.size()>1) mgg=(miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[1]).M();
  double ht=MyHtAll(jetstuff,miscstuff,metcode);

  double sqrtSumEt;
  double SumEt;
  double sqrtSumEt_jet;
  double SumEt_jet;
  double JetFr=0.0;
  double met;
  double metR=miscstuff.myMET_raw.Mod();
  double metR0=miscstuff.myMET0_raw.Mod();
  double metx;
  double mety;
  double metRx=miscstuff.myMET_raw.Px();
  double metRy=miscstuff.myMET_raw.Py();
  double metphiR=miscstuff.myMET_raw.Phi();
  double metphiC;
  int njet=0;

  if(metcode==1)
    {
      SumEt=jetstuff.mySumEtCorr_th5;
      sqrtSumEt=sqrt(jetstuff.mySumEtCorr_th5);
      SumEt_jet=jetstuff.mySumEtJet_th5;
      sqrtSumEt_jet=sqrt(jetstuff.mySumEtJet_th5);
      met=jetstuff.myMETcorr_th5.Mod();
      metx=jetstuff.myMETcorr_th5.Px();
      mety=jetstuff.myMETcorr_th5.Py();
      metphiC=jetstuff.myMETcorr_th5.Phi();
      njet=jetstuff.myNjet_th5;
    }
  if(metcode==2)
    {
      SumEt=jetstuff.mySumEtCorr_th10;
      sqrtSumEt=sqrt(jetstuff.mySumEtCorr_th10);
      SumEt_jet=jetstuff.mySumEtJet_th10;
      sqrtSumEt_jet=sqrt(jetstuff.mySumEtJet_th10);
      met=jetstuff.myMETcorr_th10.Mod();
      metx=jetstuff.myMETcorr_th10.Px();
      mety=jetstuff.myMETcorr_th10.Py();
      metphiC=jetstuff.myMETcorr_th10.Phi();
      njet=jetstuff.myNjet_th10;
    }
  if(metcode==3)
    {
      SumEt=jetstuff.mySumEtCorr_th15;
      sqrtSumEt=sqrt(jetstuff.mySumEtCorr_th15);
      SumEt_jet=jetstuff.mySumEtJet_th15;
      sqrtSumEt_jet=sqrt(jetstuff.mySumEtJet_th15);
      met=jetstuff.myMETcorr_th15.Mod();
      metx=jetstuff.myMETcorr_th15.Px();
      mety=jetstuff.myMETcorr_th15.Py();
      metphiC=jetstuff.myMETcorr_th15.Phi();
      njet=jetstuff.myNjet_th15;
    }
  if(metcode==4)
    {
      SumEt=jetstuff.mySumEtCorr_th20;
      sqrtSumEt=sqrt(jetstuff.mySumEtCorr_th20);
      SumEt_jet=jetstuff.mySumEtJet_th20;
      sqrtSumEt_jet=sqrt(jetstuff.mySumEtJet_th20);
      met=jetstuff.myMETcorr_th20.Mod();
      metx=jetstuff.myMETcorr_th20.Px();
      mety=jetstuff.myMETcorr_th20.Py();
      metphiC=jetstuff.myMETcorr_th20.Phi();
      njet=jetstuff.myNjet_th20;
    }

  if(metcode<1 || metcode>4)
    {
      SumEt=miscstuff.mySumEt_raw;
      sqrtSumEt=sqrt(miscstuff.mySumEt_raw);
      SumEt_jet=0.0; // not defined for this case
      sqrtSumEt_jet=0.0; // not defined for this case
      met=miscstuff.myMET_raw.Mod();
      metx=miscstuff.myMET_raw.Px();
      mety=miscstuff.myMET_raw.Py();
      metphiC=miscstuff.myMET_raw.Phi();
      njet=jetstuff.myNjet;
    }
  if(SumEt>0.0) JetFr=SumEt_jet/SumEt;

  if(fabs(met-metR)>0.0)
    {
      Hist.fMetRaw->Fill(metR); 
      Hist.fMetCorr->Fill(met);
      Hist.fMetPhiRaw->Fill(metphiR); 
      Hist.fMetPhiCorr->Fill(metphiC);
    }

  Hist.fSumEtCorr->Fill(SumEt);    
  Hist.fSqrtSumEtCorr->Fill(sqrtSumEt);

  if(njet>0)
    {
      Hist.fSumEtCorr_withJet->Fill(SumEt);    
      Hist.fSqrtSumEtCorr_withJet->Fill(sqrtSumEt);
    }
  else
    {
      Hist.fSumEtCorr_noJet->Fill(SumEt);    
      Hist.fSqrtSumEtCorr_noJet->Fill(sqrtSumEt);   
      if(nvx==1) Hist.fSumEtCorr_noJet_vx1->Fill(SumEt);     
      if(nvx==2) Hist.fSumEtCorr_noJet_vx2->Fill(SumEt);     
      if(nvx==3) Hist.fSumEtCorr_noJet_vx3->Fill(SumEt);
      Hist.fSumEtCorrNoJet_vs_Nvx->Fill(nvx,SumEt);
    }
 
  Hist.fMetRawAll->Fill(metR); 
  Hist.fMetCorrAll->Fill(met);
  Hist.fMetRawAll_X->Fill(metRx); 
  Hist.fMetCorrAll_X->Fill(metx);
  Hist.fMetRawAll_Y->Fill(metRy); 
  Hist.fMetCorrAll_Y->Fill(mety);
  Hist.fMetPhiRawAll->Fill(metphiR); 
  Hist.fMetPhiCorrAll->Fill(metphiC);
    
//   if(nvx>1) Hist.fMetCorr_vs_dZvx->Fill(fabs(dzvx),met);
  if(dzvx_worse>0.0) 
    {
      Hist.fMetCorr_vs_dZvx->Fill(fabs(dzvx),met);
      Hist.fMetCorr_vs_dZvxWorse->Fill(fabs(dzvx_worse),met);
      Hist.fMetCorr_vs_Zvx2ndBest->Fill(zvx[1],met);
      Hist.fMetCorr_vs_ZvxWorse->Fill(zvx[2],met);
      Hist.fMetCorrVsZvx2ndBest->Fill(zvx[1],met);
      Hist.fMetCorrVsZvxWorse->Fill(zvx[2],met);
    }
  Hist.fMetCorr_vs_ZvxBest->Fill(fabs(zvx[0]),met);
  Hist.fMetCorrVsZvxBest->Fill(fabs(zvx[0]),met);
  if(nvx=1)
    {
      Hist.fMet0Met4_vs_Zvx->Fill(zvx[0],metR0-metR);
      Hist.fMet0_vs_Zvx->Fill(zvx[0],metR0);
    }

  //---- Below this point, all histograms for met model will be filled using the last generated value of met 

  Hist.fMet4VsNjet->Fill(jetstuff.myNjet,met);
  Hist.fMet4VsNjet_th5->Fill(jetstuff.myNjet_th5,met);
  Hist.fMet4VsNjet_th10->Fill(jetstuff.myNjet_th10,met);
  Hist.fMet4VsNjet_th15->Fill(jetstuff.myNjet_th15,met);
  Hist.fMet4VsNjet_th20->Fill(jetstuff.myNjet_th20,met);
  Hist.fMet4VsNjet_th25->Fill(jetstuff.myNjet_th25,met);

  Hist.fMet4VsNvx12->Fill(nvx,met);
  Hist.fMet4X_vs_Met4Y->Fill(metx,mety);

  if(nvx==1) Hist.fMet4VsRun->Fill(GetHeaderBlock()->RunNumber(),met);
  Hist.fNvx12VsRun->Fill(GetHeaderBlock()->RunNumber(),nvx);

  if(SumEt_jet>0.0)
    {
      Hist.fSumEtJetFrac->Fill(JetFr);
      Hist.fSumEtJet->Fill(SumEt_jet);
      Hist.fSqrtSumEtJet->Fill(sqrtSumEt_jet);
    }
  Hist.fMet4VsJetFr->Fill(JetFr,met);
  Hist.fMet4VsSqrtSumEtJet->Fill(sqrtSumEt_jet,met);
  Hist.fJetFrVsSumEt->Fill(SumEt,JetFr); 

  for(int i=0; i<10; i++)
    {
      if(sqrtSumEt>i*2.0 && sqrtSumEt<=(i+1)*2.0)
	{

	  Hist.fMet4[i]->Fill(met);
	  Hist.fMet4Phi[i]->Fill(metphiC);

	  if(njet==0)
	    {
	      Hist.fMet4X_noJet[i]->Fill(metx);
	      Hist.fMet4Y_noJet[i]->Fill(mety);
	    }
	  else
	    {
	      Hist.fMet4X_withJet[i]->Fill(metx);
	      Hist.fMet4Y_withJet[i]->Fill(mety);
	    }
	  
	  Hist.fMet4X[i]->Fill(metx);
	  Hist.fMet4Y[i]->Fill(mety);
	  break; // just in case if nvx>5
	}
    }

  //__________________________ filling histograms for Met Model-2
  TVector2 myGenV2Met_def(0.0,0.0);
  TVector2 myGenV2Met_def_max(0.0,0.0);

  double metSig_est=MyTotalMetSignificance(jetstuff,jetstuff.myMETcorr_th15,0,0);
  myMetSig=metSig_est; // filling my Met Significance

  MetSigDelPhiStuff msdpStuff_dt;
  CalculateMetDelPhi(msdpStuff_dt,jetstuff,miscstuff,jetstuff.myMETcorr_th15);

  //______________ calculating dPhi(met-obj)
  int object_type=-1; // 0=e/pho, 1=jet, 2=b-tag, 3=mu, 4=tau, 5=trk
  if(msdpStuff_dt.dPhi_det[2]<msdpStuff_dt.dPhi_det[1]) object_type=1;
  else object_type=0;	      

  for(int ij=0; ij<5; ij++)
    {
      if(msdpStuff_dt.dPhi_det[ij]<7.0) Hist.fMetSig_vs_dPhi[ij]->Fill(metSig_est,msdpStuff_dt.dPhi_det[ij]);
    }
  if(ht>=0.0) Hist.fMetSig_vs_sqrtHt->Fill(metSig_est,sqrt(ht));
  if(met>=0.0) Hist.fMetSig_vs_sqrtMet->Fill(metSig_est,sqrt(met));
  if(SumEt>=0.0) Hist.fMetSig_vs_sqrtSumEt->Fill(metSig_est,sqrt(SumEt));

  if(msdpStuff_dt.dPhi_det[1]<0.4 && metSig_est>4.0)
    {
      Hist.fMetSig_vs_Xces->Fill(metSig_est,fabs(msdpStuff_dt.xces_em));
      Hist.fMetSig_vs_etaEM->Fill(metSig_est,fabs(msdpStuff_dt.eta_det_em));
      Hist.fMetSig_Xces_vs_etaEM->Fill(fabs(msdpStuff_dt.xces_em),MyInCemTowerEta(msdpStuff_dt.eta_det_em));
    }
  if(msdpStuff_dt.dPhi_det[2]<0.4 && metSig_est>4.0) Hist.fMetSig_vs_etaJET->Fill(metSig_est,fabs(msdpStuff_dt.eta_det_jet));
  if(object_type>-1) Hist.fObjType->Fill(object_type);
  
  Hist.fMetSig_estimate->Fill(metSig_est);
  if(njet==0) Hist.fMetSig_estimate_njet0->Fill(metSig_est);
  if(njet==1) Hist.fMetSig_estimate_njet1->Fill(metSig_est);
  if(njet>1) Hist.fMetSig_estimate_njet2->Fill(metSig_est);
  int sig_bin=0;
  for(int i_sig=0; i_sig<5; i_sig++)
    {
      if(metSig_est>=1.0*i_sig) 
	{
	  sig_bin=i_sig;
	  Hist.fMetSig_Met[sig_bin]->Fill(met);
	}
    }
  //__ 09/18/07: end of test

  for(int k=0; k<Npoints; k++)
    {
      //------------------------ default parametrization
      int rnd_seed=gRandom->GetSeed();
      GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,0,0,metcode,rnd_seed,myGenV2Met_def);
      //_________________________________________________________________________________________
      //------------- MetSignificance for pseudo-experiments ------------------------------------
      metSig_est=MyTotalMetSignificance(jetstuff,myGenV2Met_def,0,0);
      myMetSig_gen=metSig_est;
      myGenMetVec.Set(myGenV2Met_def.Px(),myGenV2Met_def.Py());
      MetSigDelPhiStuff msdpStuff_gn;
      CalculateMetDelPhi(msdpStuff_gn,jetstuff,miscstuff,myGenV2Met_def); // calculating dPhi(met-obj)
      for(int ij=0; ij<5; ij++)
	{
	  if(msdpStuff_gn.dPhi_det[ij]<7.0) Hist.fMetSigCalib_vs_dPhi[ij]->Fill(metSig_est,msdpStuff_gn.dPhi_det[ij]);
	}

      Hist.fMetSigCalib_estimate->Fill(metSig_est);
      if(njet==0) Hist.fMetSigCalib_estimate_njet0->Fill(metSig_est);
      if(njet==1) Hist.fMetSigCalib_estimate_njet1->Fill(metSig_est);
      if(njet>1) Hist.fMetSigCalib_estimate_njet2->Fill(metSig_est);
      sig_bin=0;
      for(int i_sig=0; i_sig<5; i_sig++)
	{
	  if(metSig_est>=1.0*i_sig) 
	    {
	      sig_bin=i_sig;
	      Hist.fMetSigCalib_Met[sig_bin]->Fill(myGenV2Met_def.Mod());
	    }
	}
      //____________ End of MetSignificance for pseudo-experiments _______________________________

      //_________________________________________________________________________________________
      //------------- Study of MetSig efficiency: pseudo-experiments and toy MET ----------------
      //------------------------ default parametrization
      double toyMet=MetToy_min+(MetToy_max-MetToy_min)*(gRandom->Rndm());
      double toyMetPhi=TMath::TwoPi()*(gRandom->Rndm());
      double toyMet_x=toyMet*cos(toyMetPhi);
      double toyMet_y=toyMet*sin(toyMetPhi);
      TVector2 MetToy(toyMet_x,toyMet_y);
      TVector2 myGenV2Met_gen(0.0,0.0);
      GenerateMyTotalMet(jetstuff,miscstuff,fGenCleanup,0,0,metcode,rnd_seed,myGenV2Met_gen);
      TVector2 myMetSum(myGenV2Met_gen.Px()+MetToy.Px(),myGenV2Met_gen.Py()+MetToy.Py());
      metSig_est=MyTotalMetSignificance(jetstuff,myMetSum,0,0);
      Hist.fMetSigToy_estimate->Fill(metSig_est);
      sig_bin=0;
      Hist.fMetSigToy_Met[0]->Fill(MetToy.Mod());
      for(int i_sig=1; i_sig<5; i_sig++)
	{
	  if(metSig_est>=(1.0*i_sig+2.0)) 
	    {
	      sig_bin=i_sig;
	      Hist.fMetSigToy_Met[sig_bin]->Fill(MetToy.Mod());
	    }
	}
      //____________ End of Study of MetSig efficiency _______________________________

      if(myGenV2Met_def.Mod()>myGenV2Met_def_max.Mod()) myGenV2Met_def_max.Set(myGenV2Met_def.X(),myGenV2Met_def.Y());

      double _met_dphi=TVector2::Phi_0_2pi(myGenV2Met_def.Phi()-metphiC);
      Hist.fGenV2Met_def_proj->Fill(myGenV2Met_def.Mod()*cos(_met_dphi));
      Hist.fGenV2MetXY_def_proj->Fill(myGenV2Met_def.Mod()*cos(_met_dphi),myGenV2Met_def.Mod()*sin(_met_dphi));
      Hist.fGenV2_dPhiMet_def->Fill(fabs(TVector2::Phi_mpi_pi(myGenV2Met_def.Phi()-metphiC)));
      if(jetstuff.myNjet_th15>0)
	{
	  Hist.fGenV2Met_def_projNjet15->Fill(myGenV2Met_def.Mod()*cos(_met_dphi));
	  Hist.fGenV2MetXY_def_projNjet15->Fill(myGenV2Met_def.Mod()*cos(_met_dphi),myGenV2Met_def.Mod()*sin(_met_dphi));
	  Hist.fGenV2_dPhiMet_def_Njet15->Fill(fabs(TVector2::Phi_mpi_pi(myGenV2Met_def.Phi()-metphiC)));	  
	}
      if(myGenV2Met_def.Mod()<2000.0) // new as of 04/04/07
	{	  
	  Hist.fMet4GenV2Met->Fill(met-myGenV2Met_def.Mod()); // Met4-MetGen
	  Hist.fMet4_vs_Met4GenV2Met->Fill(met-myGenV2Met_def.Mod(),met); // Met4 .vs. Met4-MetGen
	  Hist.fMet4_vs_GenV2Met->Fill(myGenV2Met_def.Mod(),met); // Met4 .vs. MetGen
	  
	  Hist.fGenV2Met_def->Fill(myGenV2Met_def.Mod());    
	  Hist.fGenV2MetX_def->Fill(myGenV2Met_def.Px());   
	  Hist.fGenV2MetY_def->Fill(myGenV2Met_def.Py());   
	  Hist.fGenV2MetPhi_def->Fill(myGenV2Met_def.Phi()); 
	  
	  //---- profile histograms
	  Hist.fMetGenV2VsNjet->Fill(jetstuff.myNjet,myGenV2Met_def.Mod()); 
	  Hist.fMetGenV2VsNjet_th5->Fill(jetstuff.myNjet_th5,myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsNjet_th10->Fill(jetstuff.myNjet_th10,myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsNjet_th15->Fill(jetstuff.myNjet_th15,myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsNjet_th20->Fill(jetstuff.myNjet_th20,myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsNjet_th25->Fill(jetstuff.myNjet_th25,myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsNvx12->Fill(nvx,myGenV2Met_def.Mod());
	  Hist.fGenV2MetX_vs_MetY->Fill(myGenV2Met_def.Px(),myGenV2Met_def.Py());
	  if(nvx==1) Hist.fMetGenV2VsRun->Fill(GetHeaderBlock()->RunNumber(),myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsJetFr->Fill(JetFr,myGenV2Met_def.Mod());
	  Hist.fMetGenV2VsSqrtSumEtJet->Fill(sqrtSumEt_jet,myGenV2Met_def.Mod());
	}
      //______ Warning!!! this has to be changed in future to be independent of "if(metcode==3)" condition
      if(metcode==3) MyMetModelEventCount(jetstuff,myGenV2Met_def,met_results); // count generated events with Met>cut       
    }
  
  double _metMax_dphi=TVector2::Phi_0_2pi(myGenV2Met_def_max.Phi()-metphiC);
  Hist.fGenV2Met_max_def_proj->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi));
  Hist.fGenV2MetXY_max_def_proj->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi),myGenV2Met_def_max.Mod()*sin(_metMax_dphi));
  Hist.fGenV2_dPhiMet_max_def->Fill(fabs(TVector2::Phi_mpi_pi(myGenV2Met_def_max.Phi()-metphiC)));
  if(jetstuff.myNjet_th15>0)
    {
      Hist.fGenV2Met_max_def_projNjet15->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi));
      Hist.fGenV2MetXY_max_def_projNjet15->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi),myGenV2Met_def_max.Mod()*sin(_metMax_dphi));
      Hist.fGenV2_dPhiMet_max_def_Njet15->Fill(fabs(TVector2::Phi_mpi_pi(myGenV2Met_def_max.Phi()-metphiC)));	  
    }
  if(met>10.0)
    {
      Hist.fGenV2Met_max_def_projMet10->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi));
      Hist.fGenV2MetXY_max_def_projMet10->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi),myGenV2Met_def_max.Mod()*sin(_metMax_dphi));
      Hist.fGenV2_dPhiMet_max_def_Met10->Fill(fabs(TVector2::Phi_mpi_pi(myGenV2Met_def_max.Phi()-metphiC)));
      if(jetstuff.myNjet_th15>0)
	{
	  Hist.fGenV2Met_max_def_projMet10Njet15->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi));
	  Hist.fGenV2MetXY_max_def_projMet10Njet15->Fill(myGenV2Met_def_max.Mod()*cos(_metMax_dphi),myGenV2Met_def_max.Mod()*sin(_metMax_dphi));
	  Hist.fGenV2_dPhiMet_max_def_Met10Njet15->Fill(fabs(TVector2::Phi_mpi_pi(myGenV2Met_def_max.Phi()-metphiC)));	  
	}
    }
  
  return;
}

//_________________________________________ filling general histo for particular Jet Cone
void TMyJetFilterModule::FillJetHistogramsB(JetGeneral_t& Hist, JetStuff stuff, double dz, int nvx12) { 


//   double toyMet=MetToy_min+(MetToy_max-MetToy_min)*(gRandom->Rndm());
//   double toyMetPhi=TMath::TwoPi()*(gRandom->Rndm());
//   double toyMet_x=toyMet*cos(toyMetPhi);
//   double toyMet_y=toyMet*sin(toyMetPhi);
//   TVector2 MetToy(toyMet_x,toyMet_y);
//   TVector2 MetToyEvnt(stuff.myMETcorr_th15.Px()+toyMet_x,stuff.myMETcorr_th15.Py()+toyMet_y);
//   if(MyMetCleanUpCut(stuff,allstuff,stuff.Jet_lev6_noEMobj,MetToyEvnt)==0) Hist.fEvnt_toyMET_cut->Fill(MetToy.Mod());
//   Hist.fEvnt_toyMET_all->Fill(MetToy.Mod());
  Hist.fEvnt_corMET_all->Fill(stuff.myMETcorr_th15.Mod());

  TLorentzVector jetsum(0.0,0.0,0.0,0.0);
  double ave_et=0.0;
  double ave_et0=0.0;
  Hist.fEvntNjet_b->Fill(stuff.myNjet);
  Hist.fEvntNjet5_b->Fill(stuff.myNjet_th5);
  Hist.fEvntNjet10_b->Fill(stuff.myNjet_th10);
  Hist.fEvntNjet15_b->Fill(stuff.myNjet_th15);
  Hist.fEvntNjet20_b->Fill(stuff.myNjet_th20);
  Hist.fEvntNjet25_b->Fill(stuff.myNjet_th25);
  Hist.fEvntdZ_b->Fill(dz);

  for(int i=0; i<stuff.Jet_raw_noEMobj.size(); i++)
    { 
      if((stuff.Npho_match[i]+stuff.Nele_match[i])==0) 
	{
	  jetsum=jetsum+stuff.Jet_lev6_noEMobj[i];
	  ave_et=ave_et+stuff.Jet_lev6_noEMobj[i].Pt();
	  ave_et0=ave_et0+stuff.Jet_raw_noEMobj[i].Pt();
	  Hist.fEvntEt0_Njet_b->Fill(stuff.myNjet,stuff.Jet_raw_noEMobj[i].Pt());
	  Hist.fEvntEt_Njet_b->Fill(stuff.myNjet,stuff.Jet_lev6_noEMobj[i].Pt());
	  if(i<2)
	    {
	      Hist.fEvntEt0_b[i]->Fill(stuff.Jet_raw_noEMobj[i].Pt()); 
	      Hist.fEvntEt_b[i]->Fill(stuff.Jet_lev6_noEMobj[i].Pt()); 
	      Hist.fEvntEtaDet_b[i]->Fill(stuff.EtaDet[i]);
	      Hist.fEvntEta_b[i]->Fill(stuff.Jet_lev6_noEMobj[i].Eta());
	      Hist.fEvntPhi_b[i]->Fill(TVector2::Phi_0_2pi(stuff.Jet_lev6_noEMobj[i].Phi()));
	      Hist.fEvntTheta_b[i]->Fill(stuff.Jet_lev6_noEMobj[i].Theta());
	      Hist.fEvntEmFr_b[i]->Fill(stuff.EmFrRaw[i]);
	      Hist.fEvntNTowers_b[i]->Fill(stuff.JetNtwr[i]);
	      Hist.fEvntNTracks_b[i]->Fill(stuff.JetNtrk[i]); 
	    }
	  else
	    {
	      Hist.fEvntEt0X_b->Fill(stuff.Jet_raw_noEMobj[i].Pt());
	      Hist.fEvntEtX_b->Fill(stuff.Jet_lev6_noEMobj[i].Pt());        
	      Hist.fEvntEtaDetX_b->Fill(stuff.EtaDet[i]);    
	      Hist.fEvntEtaX_b->Fill(stuff.Jet_lev6_noEMobj[i].Eta());       
	      Hist.fEvntPhiX_b->Fill(TVector2::Phi_0_2pi(stuff.Jet_lev6_noEMobj[i].Phi()));       
	      Hist.fEvntThetaX_b->Fill(stuff.Jet_lev6_noEMobj[i].Theta());     
	      Hist.fEvntEmFrX_b->Fill(stuff.EmFrRaw[i]);      
	      Hist.fEvntNTowersX_b->Fill(stuff.JetNtwr[i]);   
	      Hist.fEvntNTracksX_b->Fill(stuff.JetNtrk[i]);
	      Hist.fEvntDeltaR1x_b->Fill(stuff.Jet_lev6_noEMobj[i].DeltaR(stuff.Jet_lev6[0]));
	      Hist.fEvntDeltaR2x_b->Fill(stuff.Jet_lev6_noEMobj[i].DeltaR(stuff.Jet_lev6[1]));
	    }   
	}
    }
  if(stuff.Jet_raw_noEMobj.size()>1 
     && (stuff.Npho_match[0]+stuff.Nele_match[0])==0 
     && (stuff.Npho_match[1]+stuff.Nele_match[1])==0)
    {
      Hist.fEvntThetaStar_b->Fill(GetThetaStar(stuff.Jet_lev6_noEMobj));
      Hist.fEvntDeltaPhi_b->Fill(fabs(TVector2::Phi_mpi_pi(stuff.Jet_lev6_noEMobj[0].DeltaPhi(stuff.Jet_lev6_noEMobj[1]))));
      Hist.fEvntDeltaEta_b->Fill(stuff.Jet_lev6_noEMobj[0].Eta()-stuff.Jet_lev6_noEMobj[1].Eta());
      Hist.fEvntDeltaR_b->Fill(stuff.Jet_lev6_noEMobj[1].DeltaR(stuff.Jet_lev6_noEMobj[0])); 
      Hist.fEvntMjj_b->Fill((stuff.Jet_lev6_noEMobj[0]+stuff.Jet_lev6_noEMobj[1]).M()); 
      Hist.fEvntKt2jet_b->Fill(GetMyKtKick(stuff.Jet_lev6_noEMobj));  
      Hist.fEvntKtAll_b->Fill(jetsum.Pt());
      Hist.fEvntKt_Mjj_b->Fill((stuff.Jet_lev6_noEMobj[0]+stuff.Jet_lev6_noEMobj[1]).M(),GetMyKtKick(stuff.Jet_lev6_noEMobj));
      Hist.fEvntKtAll_Mjj_b->Fill((stuff.Jet_lev6_noEMobj[0]+stuff.Jet_lev6_noEMobj[1]).M(),jetsum.Pt());      
    }
  Hist.fEvntNJet_Nvx_b->Fill(nvx12,stuff.myNjet);        
  Hist.fEvntNJet5_Nvx_b->Fill(nvx12,stuff.myNjet_th5);        
  Hist.fEvntNJet10_Nvx_b->Fill(nvx12,stuff.myNjet_th10);        
  Hist.fEvntNJet15_Nvx_b->Fill(nvx12,stuff.myNjet_th15);        
  Hist.fEvntNJet20_Nvx_b->Fill(nvx12,stuff.myNjet_th20);        
  Hist.fEvntNJet25_Nvx_b->Fill(nvx12,stuff.myNjet_th25);        
  if(stuff.myNjet>0)
    {
      Hist.fEvntEt0_Nvx12_b->Fill(nvx12,ave_et0/(stuff.myNjet)); 
      Hist.fEvntEt_Nvx12_b->Fill(nvx12,ave_et/(stuff.myNjet));
    }
  
  if(nvx12==1) Hist.fEvntNjet_Lum_b->Fill((GetHeaderBlock()->InstLum())*1.0E-30,stuff.myNjet); 
  return;
}
//_________________________________________ filling general histo for particular Jet Cone
void TMyJetFilterModule::FillJetHistogramsA(JetGeneral_t& Hist, JetStuff stuff, double dz, int nvx12) {
  TLorentzVector jetsum(0.0,0.0,0.0,0.0);
  double ave_et=0.0;
  double ave_et0=0.0;
  Hist.fEvntNjet_a->Fill(stuff.myNjet);
  Hist.fEvntNjet5_a->Fill(stuff.myNjet_th5);
  Hist.fEvntNjet10_a->Fill(stuff.myNjet_th10);
  Hist.fEvntNjet15_a->Fill(stuff.myNjet_th15);
  Hist.fEvntNjet20_a->Fill(stuff.myNjet_th20);
  Hist.fEvntNjet25_a->Fill(stuff.myNjet_th25);
  Hist.fEvntdZ_a->Fill(dz);

  for(int i=0; i<stuff.Jet_raw_noEMobj.size(); i++)
    { 
      if((stuff.Npho_match[i]+stuff.Nele_match[i])==0) 
	{
	  jetsum=jetsum+stuff.Jet_lev6_noEMobj[i];
	  ave_et=ave_et+stuff.Jet_lev6_noEMobj[i].Pt();
	  ave_et0=ave_et0+stuff.Jet_raw_noEMobj[i].Pt();
	  Hist.fEvntEt0_Njet_a->Fill(stuff.myNjet,stuff.Jet_raw_noEMobj[i].Pt());
	  Hist.fEvntEt_Njet_a->Fill(stuff.myNjet,stuff.Jet_lev6_noEMobj[i].Pt());
	  if(i<2)
	    {
	      Hist.fEvntEt0_a[i]->Fill(stuff.Jet_raw_noEMobj[i].Pt()); 
	      Hist.fEvntEt_a[i]->Fill(stuff.Jet_lev6_noEMobj[i].Pt()); 
	      Hist.fEvntEtaDet_a[i]->Fill(stuff.EtaDet[i]);
	      Hist.fEvntEta_a[i]->Fill(stuff.Jet_lev6_noEMobj[i].Eta());
	      Hist.fEvntPhi_a[i]->Fill(TVector2::Phi_0_2pi(stuff.Jet_lev6_noEMobj[i].Phi()));
	      Hist.fEvntTheta_a[i]->Fill(stuff.Jet_lev6_noEMobj[i].Theta());
	      Hist.fEvntEmFr_a[i]->Fill(stuff.EmFrRaw[i]);
	      Hist.fEvntNTowers_a[i]->Fill(stuff.JetNtwr[i]);
	      Hist.fEvntNTracks_a[i]->Fill(stuff.JetNtrk[i]); 
	    }
	  else
	    {
	      Hist.fEvntEt0X_a->Fill(stuff.Jet_raw_noEMobj[i].Pt());
	      Hist.fEvntEtX_a->Fill(stuff.Jet_lev6_noEMobj[i].Pt());        
	      Hist.fEvntEtaDetX_a->Fill(stuff.EtaDet[i]);    
	      Hist.fEvntEtaX_a->Fill(stuff.Jet_lev6_noEMobj[i].Eta());       
	      Hist.fEvntPhiX_a->Fill(TVector2::Phi_0_2pi(stuff.Jet_lev6_noEMobj[i].Phi()));       
	      Hist.fEvntThetaX_a->Fill(stuff.Jet_lev6_noEMobj[i].Theta());     
	      Hist.fEvntEmFrX_a->Fill(stuff.EmFrRaw[i]);      
	      Hist.fEvntNTowersX_a->Fill(stuff.JetNtwr[i]);   
	      Hist.fEvntNTracksX_a->Fill(stuff.JetNtrk[i]);
	      Hist.fEvntDeltaR1x_a->Fill(stuff.Jet_lev6_noEMobj[i].DeltaR(stuff.Jet_lev6_noEMobj[0]));
	      Hist.fEvntDeltaR2x_a->Fill(stuff.Jet_lev6_noEMobj[i].DeltaR(stuff.Jet_lev6_noEMobj[1]));
	    }   
	}
    }
  if(stuff.Jet_raw_noEMobj.size()>1 
     && (stuff.Npho_match[0]+stuff.Nele_match[0])==0 
     && (stuff.Npho_match[1]+stuff.Nele_match[1])==0) 
    {
      Hist.fEvntThetaStar_a->Fill(GetThetaStar(stuff.Jet_lev6_noEMobj));
      Hist.fEvntDeltaPhi_a->Fill(fabs(TVector2::Phi_mpi_pi(stuff.Jet_lev6_noEMobj[0].DeltaPhi(stuff.Jet_lev6_noEMobj[1]))));
      Hist.fEvntDeltaEta_a->Fill(stuff.Jet_lev6_noEMobj[0].Eta()-stuff.Jet_lev6_noEMobj[1].Eta());
      Hist.fEvntDeltaR_a->Fill(stuff.Jet_lev6_noEMobj[1].DeltaR(stuff.Jet_lev6_noEMobj[0])); 
      Hist.fEvntMjj_a->Fill((stuff.Jet_lev6_noEMobj[0]+stuff.Jet_lev6_noEMobj[1]).M()); 
      Hist.fEvntKt2jet_a->Fill(GetMyKtKick(stuff.Jet_lev6_noEMobj));  
      Hist.fEvntKtAll_a->Fill(jetsum.Pt());
      Hist.fEvntKt_Mjj_a->Fill((stuff.Jet_lev6_noEMobj[0]+stuff.Jet_lev6_noEMobj[1]).M(),GetMyKtKick(stuff.Jet_lev6_noEMobj));
      Hist.fEvntKtAll_Mjj_a->Fill((stuff.Jet_lev6_noEMobj[0]+stuff.Jet_lev6_noEMobj[1]).M(),jetsum.Pt());      
    }
  Hist.fEvntNJet_Nvx_a->Fill(nvx12,stuff.myNjet);        
  Hist.fEvntNJet5_Nvx_a->Fill(nvx12,stuff.myNjet_th5);        
  Hist.fEvntNJet10_Nvx_a->Fill(nvx12,stuff.myNjet_th10);        
  Hist.fEvntNJet15_Nvx_a->Fill(nvx12,stuff.myNjet_th15);        
  Hist.fEvntNJet20_Nvx_a->Fill(nvx12,stuff.myNjet_th20);        
  Hist.fEvntNJet25_Nvx_a->Fill(nvx12,stuff.myNjet_th25);        

  if(stuff.myNjet>0)
    {
      Hist.fEvntEt0_Nvx12_a->Fill(nvx12,ave_et0/(stuff.myNjet)); 
      Hist.fEvntEt_Nvx12_a->Fill(nvx12,ave_et/(stuff.myNjet));
    }
  if(nvx12==1) Hist.fEvntNjet_Lum_a->Fill((GetHeaderBlock()->InstLum())*1.0E-30,stuff.myNjet); 
  return;
}

//______________________________________________________ filling match histo
void TMyJetFilterModule::FillMatchingHistograms(MatchStudyHisto_t& Hist, JetStuff jetstuff, CommonStuff miscstuff, MatchStuff match) {
  Hist.fMatchNtwr->Fill(jetstuff.JetNtwr[match.JetInd_match]);
  if(match.EmObjType_match==0) 
    {
      Hist.fMatchDelR->Fill(jetstuff.Jet_raw[match.JetInd_match].DeltaR(miscstuff.myRawPhoton[match.EmInd_match]));
      Hist.fMatchDelPhi->Fill(fabs(TVector2::Phi_mpi_pi(jetstuff.Jet_raw[match.JetInd_match].Phi()-
							miscstuff.myRawPhoton[match.EmInd_match].Phi())));
      Hist.fMatchDelEta->Fill(fabs(jetstuff.Jet_raw[match.JetInd_match].Eta()-
				   miscstuff.myRawPhoton[match.EmInd_match].Eta()));
      Hist.fMatchDelEtaDet->Fill(fabs(jetstuff.EtaDet[match.JetInd_match]-
				      miscstuff.myPhoEtaDet[match.EmInd_match]));
      
      Hist.fMatchEtJet2EtPho_b->Fill(jetstuff.Jet_raw[match.JetInd_match].Pt()/miscstuff.myRawPhoton[match.EmInd_match].Pt());
      Hist.fMatchEtJet2EtPho_a->Fill(jetstuff.Jet_raw_noEMobj[match.JetInd_match].Pt()/miscstuff.myRawPhoton[match.EmInd_match].Pt());
//       Hist.fMatchEtJet2EtPho_b->Fill(jetstuff.Jet_raw[match.JetInd_match].E()/miscstuff.myRawPhoton[match.EmInd_match].E());
//       Hist.fMatchEtJet2EtPho_a->Fill(jetstuff.Jet_raw_noEMobj[match.JetInd_match].E()/miscstuff.myRawPhoton[match.EmInd_match].E());
    }
  if(match.EmObjType_match==1) 
    {
      Hist.fMatchDelR->Fill(jetstuff.Jet_raw[match.JetInd_match].DeltaR(miscstuff.myRawElectron[match.EmInd_match]));
      Hist.fMatchDelPhi->Fill(fabs(TVector2::Phi_mpi_pi(jetstuff.Jet_raw[match.JetInd_match].Phi()-
							miscstuff.myRawElectron[match.EmInd_match].Phi())));
      Hist.fMatchDelEta->Fill(fabs(jetstuff.Jet_raw[match.JetInd_match].Eta()-
				   miscstuff.myRawElectron[match.EmInd_match].Eta()));
      Hist.fMatchDelEtaDet->Fill(fabs(jetstuff.EtaDet[match.JetInd_match]-
				      miscstuff.myEleEtaDet[match.EmInd_match]));
      
      Hist.fMatchEtJet2EtPho_b->Fill(jetstuff.Jet_raw[match.JetInd_match].Pt()/miscstuff.myRawElectron[match.EmInd_match].Pt());
      Hist.fMatchEtJet2EtPho_a->Fill(jetstuff.Jet_raw_noEMobj[match.JetInd_match].Pt()/miscstuff.myRawElectron[match.EmInd_match].Pt());
//       Hist.fMatchEtJet2EtPho_b->Fill(jetstuff.Jet_raw[match.JetInd_match].E()/miscstuff.myRawElectron[match.EmInd_match].E());
//       Hist.fMatchEtJet2EtPho_a->Fill(jetstuff.Jet_raw_noEMobj[match.JetInd_match].E()/miscstuff.myRawElectron[match.EmInd_match].E());
    }
  Hist.fMatchNmatch->Fill(jetstuff.Npho_match[match.JetInd_match]+jetstuff.Nele_match[match.JetInd_match]); 
  Hist.fMatchEt_raw_b->Fill(jetstuff.Jet_raw[match.JetInd_match].Pt());
  Hist.fMatchEt_raw_a->Fill(jetstuff.Jet_raw_noEMobj[match.JetInd_match].Pt()); 
  Hist.fMatchEt_lev6_b->Fill(jetstuff.Jet_lev6[match.JetInd_match].Pt());
  Hist.fMatchEt_lev6_a->Fill(jetstuff.Jet_lev6_noEMobj[match.JetInd_match].Pt());
  if(jetstuff.Jet_raw_noEMobj[match.JetInd_match].Pt()>0.0)
    {
      Hist.fMatchDelRoldnew->Fill(jetstuff.Jet_raw[match.JetInd_match].DeltaR(jetstuff.Jet_raw_noEMobj[match.JetInd_match]));
      Hist.fMatchDelEtaDetoldnew->Fill(jetstuff.EtaDet[match.JetInd_match]-jetstuff.EtaDetCorr[match.JetInd_match]); 
    }
  return;
}

//______________________________________________________ filling diphoton Xsec histo
void TMyJetFilterModule::FillXsecStudyHistograms(DiphoXsecHisto_t& Hist, JetStuff jetstuff, CommonStuff miscstuff) {

  if(miscstuff.myCorrPhoton.size()>1)
    {
      Hist.fXsecNjet15vsMgg->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M(),jetstuff.myNjet_th15);
      Hist.fXsecNjet20vsMgg->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M(),jetstuff.myNjet_th20);
      Hist.fXsecNjet25vsMgg->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M(),jetstuff.myNjet_th25);    
      
      Hist.fXsecEt2toEt1->Fill(miscstuff.myCorrPhoton[1].Pt()/miscstuff.myCorrPhoton[0].Pt());
      Hist.fXsecMgg->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M());
      Hist.fXsecQt->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).Pt());

      double mass_gg=(miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M();
      double qt_gg=(miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).Pt();
      double dphi_gg=fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[0].Phi()-miscstuff.myCorrPhoton[1].Phi()));
      
      if(jetstuff.myNjet_th15==0) Hist.fXsecMgg_noJet15->Fill(mass_gg);
      else Hist.fXsecMgg_withJet15->Fill(mass_gg); 

      if(mass_gg<qt_gg)
	{
	  Hist.fXsecMgg_t1->Fill(mass_gg);
	  Hist.fXsecQt_t1->Fill(qt_gg);
	  Hist.fXsecDelPhi_t1->Fill(dphi_gg);
	}
      else
	{
	  Hist.fXsecMgg_t2->Fill(mass_gg);
	  Hist.fXsecQt_t2->Fill(qt_gg);
	  Hist.fXsecDelPhi_t2->Fill(dphi_gg);
	}
      Hist.fXsecQtvsMgg->Fill(mass_gg,qt_gg);
      Hist.fXsecMetVsQt->Fill(qt_gg,jetstuff.myMETcorr_th15.Mod());

      if(jetstuff.Jet_lev6_noEMobj.size()>0)
	{
	  if(jetstuff.Npho_match[0]==0)
	    {
	      Hist.fXsecEtjet->Fill(jetstuff.Jet_lev6_noEMobj[0].Pt());
	      Hist.fXsecDelR_jetpho1->Fill(jetstuff.Jet_lev6_noEMobj[0].DeltaR(miscstuff.myCorrPhoton[0])); 
	      Hist.fXsecDelR_jetpho2->Fill(jetstuff.Jet_lev6_noEMobj[0].DeltaR(miscstuff.myCorrPhoton[1])); 
	    }
	}

      if(fabs(TVector2::Phi_mpi_pi(miscstuff.myCorrPhoton[0].Phi()-miscstuff.myCorrPhoton[1].Phi()))<TMath::Pi()/2)
	{
	  Hist.fXsecEt2toEt1_reg1->Fill(miscstuff.myCorrPhoton[1].Pt()/miscstuff.myCorrPhoton[0].Pt());
	  Hist.fXsecMgg_reg1->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M());
	  Hist.fXsecQt_reg1->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).Pt());
	  if(jetstuff.Jet_lev6_noEMobj.size()>0)
	    {
	      if(jetstuff.Npho_match[0]==0) Hist.fXsecEtjet_reg1->Fill(jetstuff.Jet_lev6_noEMobj[0].Pt());
	    } 
	}
      else
	{
	  Hist.fXsecEt2toEt1_reg2->Fill(miscstuff.myCorrPhoton[1].Pt()/miscstuff.myCorrPhoton[0].Pt());
	  Hist.fXsecMgg_reg2->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).M());
	  Hist.fXsecQt_reg2->Fill((miscstuff.myCorrPhoton[1]+miscstuff.myCorrPhoton[0]).Pt());
	  if(jetstuff.Jet_lev6_noEMobj.size()>0)
	    {
	      if(jetstuff.Npho_match[0]==0) Hist.fXsecEtjet_reg2->Fill(jetstuff.Jet_lev6_noEMobj[0].Pt());
	    } 
	}
    }
  return;
}

//_________________________________ returns normalized kT_perp. for resolution studies 
float TMyJetFilterModule::GetMyKtPerp(std::vector<TLorentzVector> vec)
{
  float kT_perp=0.0;
  if(vec.size()>=2)
    {
      float phi12=vec[0].DeltaPhi(vec[1]);
      kT_perp=2*cos(phi12/2.0);
    }  
  return kT_perp;
}  
//_________________________________ returns normalized kT_parl. for resolution studies 
float TMyJetFilterModule::GetMyKtParl(std::vector<TLorentzVector> vec)
{
  float kT_parl=0.0;
    if(vec.size()>=2)
    {
      float pt_1=vec[0].Pt();
      float pt_2=vec[1].Pt();
      float phi12=vec[0].DeltaPhi(vec[1]);
      kT_parl=2.0*(pt_1-pt_2)*sin(phi12/2.0)/(pt_1+pt_2);
    }  
  return kT_parl;
}  


//______________________________________ reads raw Met, pho, ele info and fills CommonStuff
void TMyJetFilterModule::DoCommonStuff(CommonStuff &miscstuff) {

//_______________________________________talk to TMyPhotonFilterModule and get my photon info
  TMyPhotonFilterModule* MyPhoton=
    (TMyPhotonFilterModule*) ((TStnAna*) GetAna()->GetModule("MyPhotonFilter")); // "MyPhotonFilter" is a default name
  int _myNpho=MyPhoton->GetmyNpho();
  for(int i=0; i<_myNpho; i++)
    {
      TLorentzVector* _pho_raw=MyPhoton->GetmyUncorrPho(i);
      TLorentzVector* _pho_cor=MyPhoton->GetmyCorrPho(i);
      miscstuff.myPhoInd.push_back(MyPhoton->GetmyPhoInd(i));
      miscstuff.myRawPhoton.push_back(*_pho_raw);
      miscstuff.myCorrPhoton.push_back(*_pho_cor);
      double hadem=MyPhoton->GetphoHadEm3(i);
      miscstuff.myPhoEmFr.push_back(1.0/(hadem+1.0));
      miscstuff.myPhoEtaDet.push_back(MyPhoton->GetphoEtaDet(i));
      miscstuff.myPhoXces.push_back(MyPhoton->GetphoCesX(i));
      miscstuff.myPhoZces.push_back(MyPhoton->GetphoCesZ(i));
    }

//_______________________________________talk to TMyZeeFilterModule and get my electron info
  TMyZeeFilterModule* MyZee=
    (TMyZeeFilterModule*) ((TStnAna*) GetAna()->GetModule("MyZee")); // "MyZee" is a default name
  int _myNele=MyZee->GetmyNele();
  for(int i=0; i<_myNele; i++)
    {
      TLorentzVector* _ele_raw=MyZee->GetmyEleRaw(i);
      TLorentzVector* _ele_cor=MyZee->GetmyEle(i);
      miscstuff.myEleInd.push_back(MyZee->GetmyZeeEleInd(i));
      miscstuff.myRawElectron.push_back(*_ele_raw); 
      miscstuff.myCorrElectron.push_back(*_ele_cor);
      double hadem=MyZee->GetmyEleHadEm(i);
      miscstuff.myEleEmFr.push_back(1.0/(hadem+1.0));   
      miscstuff.myEleEtaDet.push_back(MyZee->GetmyEleDetEta(i));
      miscstuff.myElePhiDet.push_back(MyZee->GetmyEleClusPhi(i));
      miscstuff.myEleXces.push_back(MyZee->GetmyEleXces(i));
      miscstuff.myEleZces.push_back(MyZee->GetmyEleZces(i));

      double factor=1.0; // added on 11/07/05
      double extra_PemEleEt=0.0; // extra PEM ele Et due to difference in energy scale, added on 11/07/04 
      if(fabs(MyZee->GetmyEleDetEta(i))>1.1) // added on 11/07/05
	{
	  if(fabs(MyZee->GetmyEleDetEta(i))<1.78) factor *= (MyZee->GetmyEleDetEta(i)>0.0? 1.020 : 1.015);
	  else factor *= (MyZee->GetmyEleDetEta(i)>0.0? 1.010 : 1.007);
	  extra_PemEleEt=(factor-1.0)*(_ele_raw->Pt());
	}
      else factor=0.0;
      double pprEt=extra_PemEleEt+factor*(MyZee->GetmyEleCprPpr(i))*
	fabs((MyZee->GetmyEleFid(i))*sin(_ele_raw->Theta())); // added on 11/04/05
      if(pprEt<0.0) pprEt=0.0; // added on 11/04/05
      miscstuff.myElePprEt.push_back(pprEt); // added on 11/04/05
    }

//_______________________________________talk to TMyEventFilterModule and get my raw MET & SumET info
  TMyEventFilterModule* MyEventInfo=
    (TMyEventFilterModule*) ((TStnAna*) GetAna()->GetModule("MyEventFilter")); // "MyEventFilter" is a default name
  miscstuff.mySumEt_raw=MyEventInfo->GetSumEt(2);
  miscstuff.myMET_raw.Set(MyEventInfo->GetMetX(4),MyEventInfo->GetMetY(4));
  miscstuff.myMET0_raw.Set(MyEventInfo->GetMetX(0),MyEventInfo->GetMetY(0));

  //____________________________ these are to be added later ______________________________
  //
//     std::vector<TLorentzVector> myRawMuon;      // raw muons
//     std::vector<TLorentzVector> myCorrMuon;     // corrected muons (corrections???)
//     std::vector<TLorentzVector> myRawTau;       // raw taus
//     std::vector<TLorentzVector> myCorrTau;      // corrected taus  (corrections???, for consistency)
//     std::vector<TLorentzVector> myRawBjet;      // raw b-jets
//     std::vector<TLorentzVector> myCorrBjet;     // corrected b-jets  (b-specific corrections???, for consistency)

  return;
}

//___________________________________ corrects Met & SumEt for jets
void TMyJetFilterModule::DoMyMet(CommonStuff miscstuff, JetStuff &jetstuff) {
  //-----correcting SumET
  jetstuff.mySumEtCorr_th5=miscstuff.mySumEt_raw;  // make it the same for a moment
  jetstuff.mySumEtCorr_th10=miscstuff.mySumEt_raw; 
  jetstuff.mySumEtCorr_th15=miscstuff.mySumEt_raw; 
  jetstuff.mySumEtCorr_th20=miscstuff.mySumEt_raw; 
  jetstuff.mySumEtJet_th5=0.0;  // make it the same for a moment
  jetstuff.mySumEtJet_th10=0.0; 
  jetstuff.mySumEtJet_th15=0.0; 
  jetstuff.mySumEtJet_th20=0.0; 
  //_________ correcting all SumEt for photons 
  for(int i=0; i<miscstuff.myRawPhoton.size(); i++)
    {
      jetstuff.mySumEtCorr_th5=jetstuff.mySumEtCorr_th5-miscstuff.myRawPhoton[i].Pt();  
      jetstuff.mySumEtCorr_th10=jetstuff.mySumEtCorr_th10-miscstuff.myRawPhoton[i].Pt(); 
      jetstuff.mySumEtCorr_th15=jetstuff.mySumEtCorr_th15-miscstuff.myRawPhoton[i].Pt(); 
      jetstuff.mySumEtCorr_th20=jetstuff.mySumEtCorr_th20-miscstuff.myRawPhoton[i].Pt();       
    }
  //_________ correcting all SumEt for electrons 
  for(int i=0; i<miscstuff.myRawElectron.size(); i++)
    {
      jetstuff.mySumEtCorr_th5=jetstuff.mySumEtCorr_th5-miscstuff.myRawElectron[i].Pt();  
      jetstuff.mySumEtCorr_th10=jetstuff.mySumEtCorr_th10-miscstuff.myRawElectron[i].Pt(); 
      jetstuff.mySumEtCorr_th15=jetstuff.mySumEtCorr_th15-miscstuff.myRawElectron[i].Pt(); 
      jetstuff.mySumEtCorr_th20=jetstuff.mySumEtCorr_th20-miscstuff.myRawElectron[i].Pt();  
    }
  //_________ correcting Met for photons and electrons, new as of 09/20/06
  TLorentzVector MetPho(0.0,0.0,0.0,0.0);
  TLorentzVector MetEle(0.0,0.0,0.0,0.0);
  for(int i=0; i<miscstuff.myRawPhoton.size(); i++)
    {
      MetPho=MetPho+miscstuff.myCorrPhoton[i]-miscstuff.myRawPhoton[i];
    }
  for(int i=0; i<miscstuff.myRawElectron.size(); i++)
    {
      MetEle=MetEle+miscstuff.myCorrElectron[i]-miscstuff.myRawElectron[i];
    }
  if(MetPho.E()<MetPho.P() || MetPho.E()<0.0) MetPho.SetPxPyPzE(0.0,0.0,0.0,0.0);
  if(MetEle.E()<MetEle.P() || MetEle.E()<0.0) MetEle.SetPxPyPzE(0.0,0.0,0.0,0.0);

  //_________ correcting all SumEt and calculating Met correction for jets
  TLorentzVector MetJet5(0.0,0.0,0.0,0.0);
  TLorentzVector MetJet10(0.0,0.0,0.0,0.0);
  TLorentzVector MetJet15(0.0,0.0,0.0,0.0);
  TLorentzVector MetJet20(0.0,0.0,0.0,0.0);
  for(int i=0; i<jetstuff.Jet_raw_noEMobj.size(); i++)
    {
      //--------- may need an eta cut here
      if(fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())>=MinJetEta && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<=MaxJetEta)
	{
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>5.0) 
	    {
	      // corr=U.E.+M.I-raw=lev5-lev6-raw+lev1-lev4, 
	      jetstuff.mySumEtCorr_th5=jetstuff.mySumEtCorr_th5-jetstuff.Jet_raw_noEMobj[i].Pt()
		+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt()
		-jetstuff.Jet_lev6_noEMobj[i].Pt();
	      jetstuff.mySumEtJet_th5=jetstuff.mySumEtJet_th5+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt();
	      MetJet5=MetJet5+jetstuff.Jet_lev5_noEMobj[i]
		+jetstuff.Jet_lev1_noEMobj[i]
		-jetstuff.Jet_lev4_noEMobj[i]
		-jetstuff.Jet_raw_noEMobj[i];
	    } 
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>10.0) 
	    {
	      // corr=lev5-raw+M.I.=lev5-raw+lev1-lev4, 
	      jetstuff.mySumEtCorr_th10=jetstuff.mySumEtCorr_th10-jetstuff.Jet_raw_noEMobj[i].Pt()
		+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt()
		-jetstuff.Jet_lev6_noEMobj[i].Pt();
	      jetstuff.mySumEtJet_th10=jetstuff.mySumEtJet_th10+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt();
	      MetJet10=MetJet10+jetstuff.Jet_lev5_noEMobj[i]
		+jetstuff.Jet_lev1_noEMobj[i]
		-jetstuff.Jet_lev4_noEMobj[i]
		-jetstuff.Jet_raw_noEMobj[i];
	    } 
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>15.0) 
	    {
	      // corr=lev5-raw+M.I.=lev5-raw+lev1-lev4, 
	      jetstuff.mySumEtCorr_th15=jetstuff.mySumEtCorr_th15-jetstuff.Jet_raw_noEMobj[i].Pt()
		+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt()
		-jetstuff.Jet_lev6_noEMobj[i].Pt();
	      jetstuff.mySumEtJet_th15=jetstuff.mySumEtJet_th15+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt();
	      MetJet15=MetJet15+jetstuff.Jet_lev5_noEMobj[i]
		+jetstuff.Jet_lev1_noEMobj[i]
		-jetstuff.Jet_lev4_noEMobj[i]
		-jetstuff.Jet_raw_noEMobj[i];
	    } 
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>20.0) 
	    {
	      // corr=lev5-raw+M.I.=lev5-raw+lev1-lev4, 
	      jetstuff.mySumEtCorr_th20=jetstuff.mySumEtCorr_th20-jetstuff.Jet_raw_noEMobj[i].Pt()
		+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt()
		-jetstuff.Jet_lev6_noEMobj[i].Pt();
	      jetstuff.mySumEtJet_th20=jetstuff.mySumEtJet_th20+jetstuff.Jet_lev5_noEMobj[i].Pt()
		+jetstuff.Jet_lev1_noEMobj[i].Pt()
		-jetstuff.Jet_lev4_noEMobj[i].Pt();
	      MetJet20=MetJet20+jetstuff.Jet_lev5_noEMobj[i]
		+jetstuff.Jet_lev1_noEMobj[i]
		-jetstuff.Jet_lev4_noEMobj[i]
		-jetstuff.Jet_raw_noEMobj[i];
	    }
	}
    }
  //---- making sure all MetJet makes sense:
  if(MetJet5.E()<MetJet5.P()) MetJet5.SetPxPyPzE(0.0,0.0,0.0,0.0);
  if(MetJet10.E()<MetJet10.P()) MetJet10.SetPxPyPzE(0.0,0.0,0.0,0.0);
  if(MetJet15.E()<MetJet15.P()) MetJet15.SetPxPyPzE(0.0,0.0,0.0,0.0);
  if(MetJet20.E()<MetJet20.P()) MetJet20.SetPxPyPzE(0.0,0.0,0.0,0.0);
 
 //---- this part was modified on 09/20/06
  MetJet5=MetJet5+MetEle+MetPho; // modified on 09/20/06
  MetJet10=MetJet10+MetEle+MetPho; // modified on 09/20/06
  MetJet15=MetJet15+MetEle+MetPho; // modified on 09/20/06
  MetJet20=MetJet20+MetEle+MetPho; // modified on 09/20/06
  
  jetstuff.myMETcorr_th5.Set(MetJet5.Px(),MetJet5.Py());
  jetstuff.myMETcorr_th10.Set(MetJet10.Px(),MetJet10.Py());
  jetstuff.myMETcorr_th15.Set(MetJet15.Px(),MetJet15.Py());
  jetstuff.myMETcorr_th20.Set(MetJet20.Px(),MetJet20.Py());
  //---- finally, calculating corrected MET
  jetstuff.myMETcorr_th5=miscstuff.myMET_raw-jetstuff.myMETcorr_th5;
  jetstuff.myMETcorr_th10=miscstuff.myMET_raw-jetstuff.myMETcorr_th10;
  jetstuff.myMETcorr_th15=miscstuff.myMET_raw-jetstuff.myMETcorr_th15;
  jetstuff.myMETcorr_th20=miscstuff.myMET_raw-jetstuff.myMETcorr_th20;

  return;
}

//__________________________________ does my jets; main routine  
void TMyJetFilterModule::DoMyJet(TStnJetBlock* fJetBlock, CommonStuff miscstuff, JetStuff &jetstuff, MatchStudyHisto_t& Hist) {
  DoMyJetNoMatch(fJetBlock,jetstuff);
  DoMyJetWithMatch(fJetBlock,miscstuff,jetstuff,Hist);
  ReorderMyJets(jetstuff);
  return;
}

//--the following three functions could have been replaced by one which works with generic data type (to be done)
void TMyJetFilterModule::myExchange_tlv(TLorentzVector& val1, TLorentzVector& val2) { //exchanges val1 and val2
  TLorentzVector dummy=val1;
  val1=val2;
  val2=dummy;
  return;
}
void TMyJetFilterModule::myExchange_dbl(double& val1, double& val2) { //exchanges val1 and val2
  double dummy=val1;
  val1=val2;
  val2=dummy;
  return;
}
void TMyJetFilterModule::myExchange_int(int& val1, int& val2) { //exchanges val1 and val2
  int dummy=val1;
  val1=val2;
  val2=dummy;
  return;
}
//_________________________________________ reorders jets after removing EM objects
void TMyJetFilterModule::ReorderMyJets(JetStuff &jetstuff) {
  int reorder_word=0;
  int reorder_word_last=0;
  for(int j=0; j<jetstuff.myNjet-1; j++)
    {
      reorder_word_last=reorder_word;
      for(int i=1; i<jetstuff.myNjet; i++)
	{
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>jetstuff.Jet_lev6_noEMobj[i-1].Pt()) 
	    {
	      myExchange_tlv(jetstuff.Jet_raw[i-1],jetstuff.Jet_raw[i]);
	      myExchange_tlv(jetstuff.Jet_lev1[i-1],jetstuff.Jet_lev1[i]);
	      myExchange_tlv(jetstuff.Jet_lev4[i-1],jetstuff.Jet_lev4[i]);
	      myExchange_tlv(jetstuff.Jet_lev5[i-1],jetstuff.Jet_lev5[i]);
	      myExchange_tlv(jetstuff.Jet_lev6[i-1],jetstuff.Jet_lev6[i]);
	      myExchange_tlv(jetstuff.Jet_lev7[i-1],jetstuff.Jet_lev7[i]);
	      myExchange_tlv(jetstuff.Jet_raw_noEMobj[i-1],jetstuff.Jet_raw_noEMobj[i]);
	      myExchange_tlv(jetstuff.Jet_lev1_noEMobj[i-1],jetstuff.Jet_lev1_noEMobj[i]);
	      myExchange_tlv(jetstuff.Jet_lev4_noEMobj[i-1],jetstuff.Jet_lev4_noEMobj[i]);
	      myExchange_tlv(jetstuff.Jet_lev5_noEMobj[i-1],jetstuff.Jet_lev5_noEMobj[i]);
	      myExchange_tlv(jetstuff.Jet_lev6_noEMobj[i-1],jetstuff.Jet_lev6_noEMobj[i]);
	      myExchange_tlv(jetstuff.Jet_lev7_noEMobj[i-1],jetstuff.Jet_lev7_noEMobj[i]);
	      
	      myExchange_dbl(jetstuff.EtaDet[i-1],jetstuff.EtaDet[i]);
	      myExchange_dbl(jetstuff.EtaDetCorr[i-1],jetstuff.EtaDetCorr[i]);
	      myExchange_dbl(jetstuff.EmFrRaw[i-1],jetstuff.EmFrRaw[i]);
	      myExchange_dbl(jetstuff.EmFrCorr[i-1],jetstuff.EmFrCorr[i]);

	      myExchange_int(jetstuff.JetNtrk[i-1],jetstuff.JetNtrk[i]);
	      myExchange_int(jetstuff.JetNtwr[i-1],jetstuff.JetNtwr[i]);
	      myExchange_int(jetstuff.Nobj_match[i-1],jetstuff.Nobj_match[i]); 
	      myExchange_int(jetstuff.Npho_match[i-1],jetstuff.Npho_match[i]); 
	      myExchange_int(jetstuff.Nele_match[i-1],jetstuff.Nele_match[i]); 
	      myExchange_int(jetstuff.Nmu_match[i-1],jetstuff.Nmu_match[i]);
	      myExchange_int(jetstuff.Ntau_match[i-1],jetstuff.Ntau_match[i]); 
	      myExchange_int(jetstuff.Nbtag_match[i-1],jetstuff.Nbtag_match[i]);
	      myExchange_int(jetstuff.JetBlockInd[i-1],jetstuff.JetBlockInd[i]);

	      reorder_word++;
	    }
	}
      if(reorder_word_last==reorder_word) break;
    }  
  return;
}

//____________________________________ re-calculates jet EmFr after removing EM object
double TMyJetFilterModule::CorrectEmFr(double emfr_old, double emfr_obj, double e_old, double e_obj) {
  double emfr_new=emfr_old;
  if(e_old>e_obj)
    {
      double term1=emfr_obj*e_obj/e_old;
      double denom=1.0-e_obj/e_old;
      emfr_new=(emfr_old-term1)/denom;
    }
  return emfr_new;
}
//____________________________________ re-calculates jet EtaDet after removing EM object
//_____________ This function has been updated on 06/27/08.
//_____________ Implemented fix for large unphysical DelEta=etaOld-etaNew
double TMyJetFilterModule::CorrectEtaDet(TLorentzVector *vec_pho, TLorentzVector *vec_old, 
					 double jetetadet_old, double pho_etadet) {
  double E_jet=vec_old->E();
  double Pt_jet=vec_old->Pt();
  double Phi_jet=vec_old->Phi();
  TLorentzVector dummy_jet;
  dummy_jet.SetPtEtaPhiE(Pt_jet,jetetadet_old,Phi_jet,E_jet);
  double E_pho=vec_pho->E();
  double Pt_pho=vec_pho->Pt();
  double Phi_pho=vec_pho->Phi();
  TLorentzVector dummy_pho;  
  dummy_pho.SetPtEtaPhiE(Pt_pho,pho_etadet,Phi_pho,E_pho);
  dummy_jet=dummy_jet-dummy_pho;
  double etadet_new=jetetadet_old;
  if(dummy_jet.E()>0.0 && dummy_jet.Pt()>0.0 && Pt_jet>Pt_pho) etadet_new=dummy_jet.Eta();
  if(fabs(etadet_new-jetetadet_old)>0.8) etadet_new=jetetadet_old;
  return etadet_new;
}
//__________________________________ does my jets after removing EM objetcs, to be called after DoMyJetNoMatch
void TMyJetFilterModule::DoMyJetWithMatch(TStnJetBlock* fJetBlock, CommonStuff miscstuff, JetStuff &jetstuff, MatchStudyHisto_t& Hist) {

  int _jetcone=0;

  if(fabs(fJetBlock->ConeSize()-0.4)<0.01) _jetcone=0;
  if(fabs(fJetBlock->ConeSize()-0.7)<0.01) _jetcone=1;
  if(fabs(fJetBlock->ConeSize()-1.0)<0.01) _jetcone=2;  
  fJTC_coneSize=_jetcone;
  //_________________________ Initializing Jet corrections
  CorInit lev1;
  CorInit lev4;
  CorInit lev5;
  CorInit lev6;
  CorInit lev7;
  lev1.level=1;
  lev1.nvx=myNvx_class12;
  lev1.cone=fJTC_coneSize;
  lev1.version=fJTC_version;
  lev1.sys=fJTC_systcode; 
  lev1.imode=fJTC_imode;  
  lev1.Nrun=myJetRun;
  lev4.level=4;
  lev4.nvx=myNvx_class12;
  lev4.cone=fJTC_coneSize;
  lev4.version=fJTC_version;
  lev4.sys=fJTC_systcode;  
  lev4.imode=fJTC_imode;  
  lev4.Nrun=myJetRun;
  lev5.level=5;
  lev5.nvx=myNvx_class12;
  lev5.cone=fJTC_coneSize;
  lev5.version=fJTC_version;
  lev5.sys=fJTC_systcode;
  lev5.imode=fJTC_imode;    
  lev5.Nrun=myJetRun; 
  lev6.level=6;
  lev6.nvx=myNvx_class12;
  lev6.cone=fJTC_coneSize;
  lev6.version=fJTC_version;
  lev6.sys=fJTC_systcode;
  lev6.imode=fJTC_imode;  
  lev6.Nrun=myJetRun;
  lev7.level=7;
  lev7.nvx=myNvx_class12;
  lev7.cone=fJTC_coneSize;
  lev7.version=fJTC_version;
  lev7.sys=fJTC_systcode;
  lev7.imode=fJTC_imode;  
  lev7.Nrun=myJetRun;

  MatchStuff dummymatch;
  ClearMatchStuff();

  int _Npho_match=0;
  int _Nele_match=0;
  double epsilon=1.0E-10;
  for(int i=0; i<jetstuff.myNjet; i++)
    {
      float _etadet_tmp=jetstuff.EtaDet[i]; // new line, 10/20/05 
      TLorentzVector *_jet=&jetstuff.Jet_raw[i];
      //_____ removing photons
      for(int j=0; j<miscstuff.myRawPhoton.size() && _Npho_match<miscstuff.myRawPhoton.size(); j++)
	{
	  TLorentzVector *_pho=&miscstuff.myRawPhoton[j];
	  double _match_dR;
	  double _match_dEta;
	  double _match_dPhi;
	  int match_stat=MyMatchPhoJet(jetstuff.JetBlockInd[i],miscstuff.myPhoInd[j],-1,
				       fJetBlock,_pho,_jet,_match_dR,_match_dPhi,_match_dEta);
	  if(match_stat==1)
	    {
	      _Npho_match++;
	      jetstuff.Nobj_match[i]=jetstuff.Nobj_match[i]+1;
	      jetstuff.Npho_match[i]=jetstuff.Npho_match[i]+1;
	      if((jetstuff.Npho_match[i]+jetstuff.Nele_match[i])==1) // filling only first match
		{
		  dummymatch.JetInd_match=i;
		  dummymatch.EmInd_match=j;
		  dummymatch.EmObjType_match=0; // photons
		  matchstuff.push_back(dummymatch);
		}
	      // here, I re-calculate jet EmFr 
	      jetstuff.EmFrCorr[i]=CorrectEmFr(jetstuff.EmFrCorr[i],miscstuff.myPhoEmFr[j],
					       jetstuff.Jet_raw_noEMobj[i].E(),miscstuff.myRawPhoton[j].E());
	      // corrected EtaDet is to be calculated before removing EM object 
	      _etadet_tmp=CorrectEtaDet(_pho,&jetstuff.Jet_raw_noEMobj[i], 
					jetstuff.EtaDetCorr[i],miscstuff.myPhoEtaDet[j]); // new line, 10/20/05
	      jetstuff.EtaDetCorr[i]=_etadet_tmp;  // new line, 10/20/05
	      double _jet_phi=jetstuff.Jet_raw[i].Phi();
	      double _jet_eta=jetstuff.Jet_raw[i].Eta();
	      if(jetstuff.Jet_raw_noEMobj[i].E()>miscstuff.myRawPhoton[j].E()) 
		jetstuff.Jet_raw_noEMobj[i]=jetstuff.Jet_raw_noEMobj[i]-miscstuff.myRawPhoton[j]; // removing raw photon from raw jet
	      else jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon);
	      if(jetstuff.Jet_raw_noEMobj[i].Pt()<epsilon) jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon); // new, 05/28/08
	      if(jetstuff.Jet_raw_noEMobj[i].E()<jetstuff.Jet_raw_noEMobj[i].P() 
		 || jetstuff.Jet_raw_noEMobj[i].E()<epsilon) jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon); 
	      if(jetstuff.Jet_raw[i].DeltaR(jetstuff.Jet_raw_noEMobj[i])>2.0*(fJetBlock->ConeSize())) 
		{
		  jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon); 
		}
	    }
	}
      //_____ removing electrons
      for(int j=0; j<miscstuff.myRawElectron.size() && _Nele_match<miscstuff.myRawElectron.size(); j++)
	{
	  TLorentzVector *_ele=&miscstuff.myRawElectron[j];
	  double _match_dR;
	  double _match_dEta;
	  double _match_dPhi;
	  int match_stat=MyMatchPhoJet(jetstuff.JetBlockInd[i],-1,miscstuff.myEleInd[j],
				       fJetBlock,_ele,_jet,_match_dR,_match_dPhi,_match_dEta);
	  if(match_stat==1)
	    {
	      _Nele_match++;
	      jetstuff.Nobj_match[i]=jetstuff.Nobj_match[i]+1;
	      jetstuff.Nele_match[i]=jetstuff.Nele_match[i]+1;
	      if((jetstuff.Nele_match[i]+jetstuff.Npho_match[i])==1) // filling only first match
		{
		  dummymatch.JetInd_match=i;
		  dummymatch.EmInd_match=j;
		  dummymatch.EmObjType_match=1; // electrons
		  matchstuff.push_back(dummymatch);
		}
	      // here, I re-calculate jet EmFr 
	      jetstuff.EmFrCorr[i]=CorrectEmFr(jetstuff.EmFrCorr[i],miscstuff.myEleEmFr[j],
					       jetstuff.Jet_raw_noEMobj[i].E(),miscstuff.myRawElectron[j].E());
	      // corrected EtaDet is to be calculated before removing EM object 
	      _etadet_tmp=CorrectEtaDet(_ele,&jetstuff.Jet_raw_noEMobj[i], 
					jetstuff.EtaDetCorr[i],miscstuff.myEleEtaDet[j]); // new line, 10/20/05
	      jetstuff.EtaDetCorr[i]=_etadet_tmp;  // new line, 10/20/05
	      double _jet_phi=jetstuff.Jet_raw[i].Phi();
	      double _jet_eta=jetstuff.Jet_raw[i].Eta();
	      if(jetstuff.Jet_raw_noEMobj[i].E()>miscstuff.myRawElectron[j].E()) 
		jetstuff.Jet_raw_noEMobj[i]=jetstuff.Jet_raw_noEMobj[i]-miscstuff.myRawElectron[j]; // removing raw electron from raw jet
	      else jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon);
	      if(jetstuff.Jet_raw_noEMobj[i].Pt()<epsilon) jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon); // new, 05/28/08
	      if(jetstuff.Jet_raw_noEMobj[i].E()<jetstuff.Jet_raw_noEMobj[i].P() 
		 || jetstuff.Jet_raw_noEMobj[i].E()<epsilon) jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon); 
	      if(jetstuff.Jet_raw[i].DeltaR(jetstuff.Jet_raw_noEMobj[i])>2.0*(fJetBlock->ConeSize())) 
		{
		  jetstuff.Jet_raw_noEMobj[i].SetPtEtaPhiM(epsilon,_jet_eta,_jet_phi,0.3*epsilon); 
		}
	    }
	}
      if((jetstuff.Nele_match[i]+jetstuff.Npho_match[i])>0) // correcting jet energy after removing EM objetcs
	{
	  TLorentzVector _rawJet=jetstuff.Jet_raw_noEMobj[i];
	  TLorentzVector _rawJet_tmp;
	  _rawJet_tmp=_rawJet;
	  float _myEmFr_tmp=jetstuff.EmFrCorr[i];
	  double corr7=GetCorrection(lev7,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
	  _myEmFr_tmp=jetstuff.EmFrCorr[i]; // do this again because EmFr can be potentially changed in GetCorrection
	  _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
	  double corr6=GetCorrection(lev6,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
	  _myEmFr_tmp=jetstuff.EmFrCorr[i]; // do this again because EmFr can be potentially changed in GetCorrection
	  _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
	  double corr5=GetCorrection(lev5,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
	  _myEmFr_tmp=jetstuff.EmFrCorr[i]; // do this again because EmFr can be potentially changed in GetCorrection
	  _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
	  double corr4=GetCorrection(lev4,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
	  _myEmFr_tmp=jetstuff.EmFrCorr[i]; // do this again because EmFr can be potentially changed in GetCorrection
	  _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
	  double corr1=GetCorrection(lev1,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);	  
	  if(corr1<0.0) corr1=epsilon;
	  if(corr4<0.0) corr4=epsilon;
	  if(corr5<0.0) corr5=epsilon;
	  if(corr6<0.0) corr6=epsilon;
	  if(corr7<0.0) corr7=epsilon;
	  jetstuff.Jet_lev1_noEMobj[i]=_rawJet*corr1; 
	  jetstuff.Jet_lev4_noEMobj[i]=_rawJet*corr4; 
	  jetstuff.Jet_lev5_noEMobj[i]=_rawJet*corr5; 
	  jetstuff.Jet_lev6_noEMobj[i]=_rawJet*corr6; 
	  jetstuff.Jet_lev7_noEMobj[i]=_rawJet*corr7; 	  
	}
      if(fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())>=MinJetEta && fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<=MaxJetEta)
	{
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>5.0) jetstuff.myNjet_th5++;
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>10.0) jetstuff.myNjet_th10++;
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>15.0) jetstuff.myNjet_th15++;
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>20.0) jetstuff.myNjet_th20++;
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>25.0) jetstuff.myNjet_th25++;
	}
    }
  if(_Nele_match!=miscstuff.myRawElectron.size() || _Npho_match!=miscstuff.myRawPhoton.size()) bad_EMjet_match_flag=0;
  for(int i=0; i<matchstuff.size(); i++)
    {
      FillMatchingHistograms(Hist,jetstuff,miscstuff,matchstuff[i]);
    }
  return;
}
//__________________________________ does my jets, but doesn't remove EM objetcs
void TMyJetFilterModule::DoMyJetNoMatch(TStnJetBlock* fJetBlock, JetStuff &jetstuff) {

  int _jetcone=0;
  if(fabs(fJetBlock->ConeSize()-0.4)<0.01) _jetcone=0;
  if(fabs(fJetBlock->ConeSize()-0.7)<0.01) _jetcone=1;
  if(fabs(fJetBlock->ConeSize()-1.0)<0.01) _jetcone=2;

  fJTC_coneSize=_jetcone;
  //_________________________ Initializing Jet corrections
  CorInit lev1;
  CorInit lev4;
  CorInit lev5;
  CorInit lev6;
  CorInit lev7;
  lev1.level=1;
  lev1.nvx=myNvx_class12;
  lev1.cone=fJTC_coneSize;
  lev1.version=fJTC_version;
  lev1.sys=fJTC_systcode; 
  lev1.imode=fJTC_imode;  
  lev1.Nrun=myJetRun;
  lev4.level=4;
  lev4.nvx=myNvx_class12;
  lev4.cone=fJTC_coneSize;
  lev4.version=fJTC_version;
  lev4.sys=fJTC_systcode;  
  lev4.imode=fJTC_imode;  
  lev4.Nrun=myJetRun;
  lev5.level=5;
  lev5.nvx=myNvx_class12;
  lev5.cone=fJTC_coneSize;
  lev5.version=fJTC_version;
  lev5.sys=fJTC_systcode;
  lev5.imode=fJTC_imode;    
  lev5.Nrun=myJetRun; 
  lev6.level=6;
  lev6.nvx=myNvx_class12;
  lev6.cone=fJTC_coneSize;
  lev6.version=fJTC_version;
  lev6.sys=fJTC_systcode;
  lev6.imode=fJTC_imode;  
  lev6.Nrun=myJetRun;
  lev7.level=7;
  lev7.nvx=myNvx_class12;
  lev7.cone=fJTC_coneSize;
  lev7.version=fJTC_version;
  lev7.sys=fJTC_systcode;
  lev7.imode=fJTC_imode;  
  lev7.Nrun=myJetRun;

  jetstuff.myNjet=fJetBlock->NJets();
  for(int i=0; i<jetstuff.myNjet; i++)
    {
      TStnJet* jet = fJetBlock->Jet(i);
      jetstuff.JetBlockInd.push_back(i);
      jetstuff.JetNtrk.push_back(jet->NTracks());
      jetstuff.JetNtwr.push_back(jet->NTowers());
      jetstuff.EtaDet.push_back(jet->DetEta());
      jetstuff.EtaDetCorr.push_back(jet->DetEta()); // for a moment, make it the same as "EtaDet"
      jetstuff.EmFrRaw.push_back(jet->Emfr());
      jetstuff.EmFrCorr.push_back(jet->Emfr()); // for a moment, make it the same as "EmFrRaw"

      jetstuff.Nobj_match.push_back(0); // these are packed with zero's for a moment 
      jetstuff.Npho_match.push_back(0);  
      jetstuff.Nele_match.push_back(0);  
      jetstuff.Nmu_match.push_back(0);   
      jetstuff.Ntau_match.push_back(0);  
      jetstuff.Nbtag_match.push_back(0);     

      //__________________ getting raw jets
      TLorentzVector _rawJet;
      TLorentzVector _rawJet_tmp;
      _rawJet.SetPx(jet->Momentum()->Px());
      _rawJet.SetPy(jet->Momentum()->Py());
      _rawJet.SetPz(jet->Momentum()->Pz());
      _rawJet.SetE(jet->Momentum()->E());
      jetstuff.Jet_raw.push_back(_rawJet);
      jetstuff.Jet_raw_noEMobj.push_back(_rawJet); // for a moment, make it the same as "Jet_raw"
      
      float _myEmFr_tmp=jet->Emfr();
      float _etadet_tmp=jet->DetEta();
      _rawJet_tmp=_rawJet;
      double corr7=GetCorrection(lev7,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
      _myEmFr_tmp=jet->Emfr(); // do this again because EmFr can be potentially changed in GetCorrection
      _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
      double corr6=GetCorrection(lev6,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
      _myEmFr_tmp=jet->Emfr(); // do this again because EmFr can be potentially changed in GetCorrection
      _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
      double corr5=GetCorrection(lev5,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
      _myEmFr_tmp=jet->Emfr(); // do this again because EmFr can be potentially changed in GetCorrection
      _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
      double corr4=GetCorrection(lev4,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);
      _myEmFr_tmp=jet->Emfr(); // do this again because EmFr can be potentially changed in GetCorrection
      _rawJet_tmp=_rawJet; // do this again because _rawJet_tmp can be potentially changed in GetCorrection
      double corr1=GetCorrection(lev1,_rawJet_tmp,_myEmFr_tmp,_etadet_tmp);

      if(corr1<0.0) corr1=0.0;
      if(corr4<0.0) corr4=0.0;
      if(corr5<0.0) corr5=0.0;
      if(corr6<0.0) corr6=0.0;
      if(corr7<0.0) corr7=0.0;      
      jetstuff.Jet_lev1.push_back(_rawJet*corr1);
      jetstuff.Jet_lev1_noEMobj.push_back(_rawJet*corr1); // for a moment, make it the same as "Jet_lev1"
      jetstuff.Jet_lev4.push_back(_rawJet*corr4);
      jetstuff.Jet_lev4_noEMobj.push_back(_rawJet*corr4); // for a moment, make it the same as "Jet_lev4"
      jetstuff.Jet_lev5.push_back(_rawJet*corr5);
      jetstuff.Jet_lev5_noEMobj.push_back(_rawJet*corr5); // for a moment, make it the same as "Jet_lev5"
      jetstuff.Jet_lev6.push_back(_rawJet*corr6);
      jetstuff.Jet_lev6_noEMobj.push_back(_rawJet*corr6); // for a moment, make it the same as "Jet_lev6"
      jetstuff.Jet_lev7.push_back(_rawJet*corr7);
      jetstuff.Jet_lev7_noEMobj.push_back(_rawJet*corr7); // for a moment, make it the same as "Jet_lev7"
            
    }
  return;
}

//____________ looks for vertex giving min MET
int TMyJetFilterModule::DiPhoNewVx(CommonStuff& miscstuff, JetStuff& jetstuff, double phoZvx, 
				   std::vector<double> ZvxVec, VxMetStudyHisto_t& Hist) {
  int swap=0;
  miscstuff.newVertexZ=phoZvx; // setting old best vertex
  if(miscstuff.myRawPhoton.size()>1 && ZvxVec.size()>1 && fDoVxSwap==1)
    {
      double dz_worse=0.0;
      TLorentzVector pho1old;
      TLorentzVector pho2old;
      TLorentzVector pho1new;
      TLorentzVector pho2new;
      double MinMet=jetstuff.myMETcorr_th15.Mod();
      TVector2 oldMet=jetstuff.myMETcorr_th15;
      TVector2 newMet=jetstuff.myMETcorr_th15;
      TVector2 MetCorr;
      TVector2 MetCorrFnl;
      MetCorr.Set(0.0,0.0);
      MetCorrFnl.Set(0.0,0.0);
      int vx_ind=0;

      pho1old=miscstuff.myRawPhoton[0];
      pho2old=miscstuff.myRawPhoton[1];
      pho1new=pho1old;
      pho2new=pho2old;
      for(int i=0; i<ZvxVec.size(); i++)
	{
	  if(fabs(phoZvx-ZvxVec[i])>dz_worse) dz_worse=fabs(phoZvx-ZvxVec[i]);
	  PhoVxChange(pho1old,miscstuff.myCorrPhoton[0].Eta(),phoZvx,ZvxVec[i],pho1new);
	  PhoVxChange(pho2old,miscstuff.myCorrPhoton[1].Eta(),phoZvx,ZvxVec[i],pho2new);
	  double x=pho1new.Px()+pho2new.Px()-pho1old.Px()-pho2old.Px();
	  double y=pho1new.Py()+pho2new.Py()-pho1old.Py()-pho2old.Py();
	  MetCorr.Set(-x,-y);
	  if((oldMet+MetCorr).Mod()<MinMet)
	    {
	      newMet=oldMet+MetCorr;
	      swap=1;
	      vx_ind=i;
	      MetCorrFnl=MetCorr;
	      MinMet=(oldMet+MetCorr).Mod(); // added on 05/16/08
	    }
	}
      Hist.MetVxSwapFrq->Fill(swap);
      Hist.MetVxOldMet_vs_dZworse->Fill(dz_worse,oldMet.Mod()); 
      Hist.MetVxNewMet_vs_dZworse->Fill(dz_worse,newMet.Mod());

      if(swap==1)
	{
	  Hist.MetVxDelMet->Fill(oldMet.Mod()-newMet.Mod());
	  Hist.MetVxOldMet->Fill(oldMet.Mod());
	  Hist.MetVxNewMet->Fill(newMet.Mod());
	  Hist.MetVxNjet15->Fill(jetstuff.myNjet_th15);
	  jetstuff.myMETcorr_th5=jetstuff.myMETcorr_th5+MetCorrFnl;
	  jetstuff.myMETcorr_th10=jetstuff.myMETcorr_th10+MetCorrFnl;
	  jetstuff.myMETcorr_th15=jetstuff.myMETcorr_th15+MetCorrFnl;
	  jetstuff.myMETcorr_th20=jetstuff.myMETcorr_th20+MetCorrFnl;
	  PhoVxChange(pho1old,miscstuff.myCorrPhoton[0].Eta(),phoZvx,ZvxVec[vx_ind],pho1new);
	  PhoVxChange(pho2old,miscstuff.myCorrPhoton[1].Eta(),phoZvx,ZvxVec[vx_ind],pho2new);
	  double pcr1=miscstuff.myCorrPhoton[0].Pt()/miscstuff.myRawPhoton[0].Pt();
	  double pcr2=miscstuff.myCorrPhoton[1].Pt()/miscstuff.myRawPhoton[1].Pt();
	  miscstuff.myRawPhoton[0]=pho1new;
	  miscstuff.myRawPhoton[1]=pho2new;
	  miscstuff.myCorrPhoton[0]=pcr1*pho1new;
	  miscstuff.myCorrPhoton[1]=pcr2*pho2new;
	  miscstuff.newVertexZ=ZvxVec[vx_ind]; // setting new vertex
	}
    }
  return swap;
}

//____________ changes vertex for photon
void TMyJetFilterModule::PhoVxChange(TLorentzVector pho_old, double pho_eta, 
				     double z_old, double z_new, TLorentzVector& pho_new) {

  double hemi = (pho_eta>0.0? 1.0 : -1.0);
  double sint = sin(pho_old.Theta());
  double cott = hemi*sqrt(1.0-sint*sint)/sint;
 
  double corr;
  double newsint;
  double newcott;

  // central only, for now
  double dz = (183.9*cott+z_old) - z_new;
  newcott = dz/183.9;
  newsint = 183.9/sqrt(183.9*183.9 + dz*dz);
  corr = newsint/sint;
  
//   // plug      
//   double r = (hemi*185.4-z_old)/cott;
//   double dz = hemi*185.4-z_new;
//   newcott = dz/r;
//   newsint = r/sqrt(r*r+dz*dz);
//   corr = newsint/sint;

  double cost  = hemi*sqrt(1.0-newsint*newsint);
  pho_new.SetPxPyPzE(pho_old.Px()*corr,pho_old.Py()*corr,pho_old.E()*cost,pho_old.E());

  return;
}


//--------------------------- 09/20/06 ----------------------------------
//____ This is new function to generate Met due to EM object energy resolution
void TMyJetFilterModule::GenerateMyEMobjMet(CommonStuff miscstuff, int systcode, TVector2 &myEMGenMet) {
  // Resolution: G/Et=sqrt(p0*p0/Et+p1*p1)
  double p0[2]; // resolution params: [0]=CEM; [1]=PEM
  double p1[2];
  double p0_er[2]; 
  double p1_er[2];
  //______________ CEM parametrization (temporary)
  p0[0]=0.135; // according to hep-ex/0510047 (jes nim)
  p1[0]=0.015;  // according to hep-ex/0510047 (jes nim)
  p0_er[0]=0.01*p0[0]; // ? guesstimate 
  p1_er[0]=0.01*p1[0]; // ? guesstimate 
  //______________ PEM parametrization (temporary)
  p0[1]=0.16; // according to hep-ex/0510047 (jes nim)
  p1[1]=0.01;  // according to hep-ex/0510047 (jes nim)
  p0_er[1]=0.01*p0[1]; // ? guesstimate 
  p1_er[1]=0.01*p1[1]; // ? guesstimate 
  //--------------------------------------
  int det_code=0;
  TLorentzVector emmetsum(0.0,0.0,0.0,0.0);
  TLorentzVector emmetsum_devm(0.0,0.0,0.0,0.0);
  TLorentzVector emmetsum_devp(0.0,0.0,0.0,0.0);
  for(int i=0; i<miscstuff.myRawPhoton.size(); i++)
    {
      if(fabs(miscstuff.myPhoEtaDet[i])<=1.1) det_code=0;
      else det_code=1;
      double obj_Pt=miscstuff.myCorrPhoton[i].Pt();
      double P_0=(p0[det_code]+systcode*p0_er[det_code])*(p0[det_code]+systcode*p0_er[det_code]);
      double P_1=(p1[det_code]+systcode*p1_er[det_code])*(p1[det_code]+systcode*p1_er[det_code]);
      double sigmaEM=sqrt(P_0/obj_Pt+P_1);
      double scale_factor=gRandom->Gaus(1.0,sigmaEM); // get jet energy scale factor
      if(miscstuff.myRawElectron.size()<2)
	{
	  if(i<2) while(scale_factor*miscstuff.myCorrPhoton[i].Pt()<13.0) scale_factor=gRandom->Gaus(1.0,sigmaEM);
	  if(i>=2) while(scale_factor*miscstuff.myCorrPhoton[i].Pt()<7.0) scale_factor=gRandom->Gaus(1.0,sigmaEM);
        }
      if(miscstuff.myRawElectron.size()>=2) while(scale_factor*miscstuff.myCorrPhoton[i].Pt()<7.0) scale_factor=gRandom->Gaus(1.0,sigmaEM);
      emmetsum=emmetsum+(1.0-scale_factor)*miscstuff.myCorrPhoton[i];
    }
  for(int i=0; i<miscstuff.myRawElectron.size(); i++)
    {
      if(fabs(miscstuff.myEleEtaDet[i])<=1.1) det_code=0;
      else det_code=1;
      double obj_Pt=miscstuff.myCorrElectron[i].Pt();
      double P_0=(p0[det_code]+systcode*p0_er[det_code])*(p0[det_code]+systcode*p0_er[det_code]);
      double P_1=(p1[det_code]+systcode*p1_er[det_code])*(p1[det_code]+systcode*p1_er[det_code]);
      double sigmaEM=sqrt(P_0/obj_Pt+P_1);
      double scale_factor=gRandom->Gaus(1.0,sigmaEM); // get jet energy scale factor
      if(miscstuff.myRawElectron.size()<2) while(scale_factor*miscstuff.myCorrElectron[i].Pt()<13.0) scale_factor=gRandom->Gaus(1.0,sigmaEM);
      if(miscstuff.myRawElectron.size()>=2)
	{
	  if(i==0) while(scale_factor*miscstuff.myCorrElectron[i].Pt()<20.0) scale_factor=gRandom->Gaus(1.0,sigmaEM);
	  if(i>0) while(scale_factor*miscstuff.myCorrElectron[i].Pt()<10.0) scale_factor=gRandom->Gaus(1.0,sigmaEM);
	}
      emmetsum=emmetsum+(1.0-scale_factor)*miscstuff.myCorrElectron[i];
    }
  myEMGenMet.Set(emmetsum.Px(),emmetsum.Py());

  return;
}
//_________ This function adds Met to closest jet, the output is "new" JetLev6
void TMyJetFilterModule::MyNewJetWithMet(JetStuff &jetstuff) {
  std::vector<double> dphi_jetmet;
  dphi_jetmet.clear();
  double phi_met=jetstuff.myMETcorr_th15.Phi();
  int case_switchJ=0; // for jets not matched to EM objects
  int closejet_indJ=-1; // for jets not matched to EM objects
  int NrawJet=0;
  for(int i=0; i<jetstuff.Jet_lev6_noEMobj.size(); i++) // packing "jetstuff.newJetLev6" with "old" jets 
    {
      jetstuff.newJetLev6.push_back(jetstuff.Jet_lev6_noEMobj[i]);
      NrawJet++;
      if(jetstuff.myMETcorr_th15.Mod()>0.0) 
	{
	  double phi_jet=jetstuff.Jet_lev6_noEMobj[i].Phi();
	  double dphi=fabs(TVector2::Phi_mpi_pi(phi_jet-phi_met));
	  dphi_jetmet.push_back(dphi);
	  double metjetRatio=jetstuff.myMETcorr_th15.Mod()*cos(dphi)/jetstuff.Jet_lev6_noEMobj[i].Pt();
	  double jetRatio=jetstuff.Jet_raw_noEMobj[i].Pt()/jetstuff.Jet_lev6_noEMobj[i].Pt();

	  double low_lim1=-0.5; // metjetRatio>-0.5 --- from Et(true)/Et(lev6) studies
// 	  double up_lim=3.0; // metjetRatio<2.5 --- from Et(true)/Et(lev6) studies
	  double up_lim=5.0; // metjetRatio<2.5 --- from Et(true)/Et(lev6) studies
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()<15.0) metjetRatio=metjetRatio-1.0+jetRatio;
// 	  if((dphi<0.4 || (TMath::Pi()-dphi)<0.4) 
// 	     && (jetstuff.Npho_match[i]+jetstuff.Nele_match[i])==0 
// 	     && metjetRatio>low_lim1 && metjetRatio<up_lim) 
	  if((dphi<0.4 || (TMath::Pi()-dphi)<0.4) 
	     && metjetRatio>low_lim1 && metjetRatio<up_lim) 
	    {
	      case_switchJ++;
	      closejet_indJ=i;
	    }
	}
    }
  if(dphi_jetmet.size()!=jetstuff.Jet_lev6_noEMobj.size() || NrawJet==0) return; 
  if(NrawJet==1 && case_switchJ==0) return;
  if(case_switchJ>1) return; // to be removed if case-2 is considered
  if(case_switchJ==1 && jetstuff.Jet_lev6_noEMobj[closejet_indJ].Pt()>3.0) // CASE-1 for unmatched jets only
    {
      double phi_jet=jetstuff.Jet_lev6_noEMobj[closejet_indJ].Phi();
      double eta_jet=jetstuff.Jet_lev6_noEMobj[closejet_indJ].Eta();
      double pt_jet=jetstuff.Jet_lev6_noEMobj[closejet_indJ].Pt();
      double raw_pt_jet=jetstuff.Jet_raw_noEMobj[closejet_indJ].Pt();
      double e_jet=jetstuff.Jet_lev6_noEMobj[closejet_indJ].E();
      double dphi=fabs(TVector2::Phi_mpi_pi(phi_jet-phi_met));
      double pt_scale=(jetstuff.myMETcorr_th15.Mod()*cos(dphi)+pt_jet)/pt_jet;
      if(pt_jet<15.0) pt_scale=pt_scale-1.0+raw_pt_jet/pt_jet;
      if(pt_scale<0.0) pt_scale=1.0E-6; 
      jetstuff.newJetLev6[closejet_indJ].SetPtEtaPhiE(pt_jet*pt_scale,eta_jet,phi_jet,e_jet*pt_scale);
    }
  return;
}

//___ This function returns upper limit of allowed jet energy fluctuation.
double TMyJetFilterModule::MyIntegralUpLimit(double jet_E, double eta_det, int stat_code, int syst_code) {
  double value=5.0; // maximum allowed: E(det)/E(true)-1<=5.0
  double parJER[5];
  parJER[0]=MyJer_meanG(jet_E,eta_det,0,syst_code); // for now systcode is used as jer_stat_code
  parJER[1]=MyJer_sigmaG(jet_E,eta_det,0,syst_code);
  parJER[2]=MyJer_mpvL(jet_E,eta_det,0,syst_code);
  parJER[3]=MyJer_sigmaL(jet_E,eta_det,0,syst_code);
  parJER[4]=MyJer_normG(jet_E,eta_det,0,syst_code);

  double lim_L=5.0;
  double lim_G=5.0;
  //------ calculating limit for Landau part
  //--- This limit is roughly equivalent to 1.0E-6 significance level of JER Landau part if it is found in range [-1.0;10.0] 
  if(fabs(1+parJER[2]-3.7*parJER[3])>0.0) lim_L=(3.7*parJER[3]-parJER[2])/(1+parJER[2]-3.7*parJER[3]);
  if(lim_L>5.0 || lim_L<parJER[3]) lim_L=5.0;
  //------ calculating limit for Gaussian part taking into account relative normalization of Gaussian
  if(parJER[4]>0.0 && parJER[4]<=1.0)
    {
      double sig_tmp=-log10(parJER[4]/(1+parJER[4]));
      double sig=4.2-sig_tmp; // 4.2 roughly corresponds to 4*Sigma significance level (~1.0E-5)
      if(sig<0.0) sig=0.0;
      double n_sigma=0.6807+1.035*sig-0.05574*sig*sig; // crude parametrization of N_sigma vs. significance
      if(fabs(1+parJER[0]-n_sigma*parJER[1])>0.0) lim_G=(n_sigma*parJER[1]-parJER[0])/(1+parJER[0]-n_sigma*parJER[1]);
      else // just to make a "smooth" transition between Landau and Gauss
	{
	  if(parJER[0]<1.0 && parJER[0]>0.0) lim_G=1.0/parJER[0]-1.0;
	  else lim_G=-1.0;
	}
      if(lim_G>5.0 || lim_G<parJER[1]) lim_G=5.0;     
    }
  //------ deciding what limit should be used: Landau or Gauss
  if(parJER[4]>0.0) // gauss is non-zero
    {
      if(lim_L<lim_G) value=lim_G; // Landau lim smaller 
      else value=lim_L;// Landau lim larger 
    }
  else value=lim_L; // gauss is zero
  if(value>5.0) value=5.0;
  return value;
}

//___ This function clears params for MetProb
void TMyJetFilterModule::ClearMetProbStuff(MetProbStuff& stuff) {
    stuff.max_MetProbInteg=1.0;
  return;
}

//___ returns relative position of EM shower inside CEM tower
double TMyJetFilterModule::MyInCemTowerEta(double eta_det) {
  double rel_eta=-10.0;
  double theta_boundary[12]={90.0,82.526,75.297,68.516,62.310,56.735,51.790,47.436,43.614,40.261,36.822,33.524};
  double eta_l, eta_r, d_eta;
  double _pi=TMath::Pi();
  for(int i=1; i<12; i++)
    {
      eta_l=fabs(log(tan(_pi*theta_boundary[i-1]/(2.0*180.0))));
      eta_r=fabs(log(tan(_pi*theta_boundary[i]/(2.0*180.0))));
      d_eta=eta_r-eta_l;
      if(fabs(eta_det)>eta_l && fabs(eta_det)<=eta_r)
	{
	  rel_eta=fabs(fabs(eta_det)-eta_l)/d_eta;
	  break;
	}
    }
  return rel_eta;
}


//___ This function inits params for MetProb
void TMyJetFilterModule::InitMetProbStuff(MetProbStuff& stuff,JetStuff jetstuff, TVector2 myMetVec, int systcode, int systcodeUncl) {

  double jet_EtCut=15.0;
  double _met=myMetVec.Mod();

  //-------------------------- Getting unclustered energy parameters
  double _meanX=0.0;
  double _sigmaX=0.0;
  double _meanY=0.0;
  double _sigmaY=0.0;
  double _normX=0.0;
  double _scaleX=0.0;
  double _normY=0.0;
  double _scaleY=0.0;
  GetMyUnclMetResolution(jetstuff.mySumEtCorr_th15,fJTC_imode,fUnclParamSwitch,systcodeUncl,_sigmaX,_sigmaY,_meanX,_meanY,_normX,_normY,_scaleX,_scaleY);

  //------------------------------------------------------------
  // calculating precision for multi-D integration
  //______ uncl. energy part
  TF1* ueFun=new TF1("ue",UnclMetResolution,-1000.0,1000.0,4);
  ueFun->SetParameter(0,_meanX);
  ueFun->SetParameter(1,_sigmaX);
  ueFun->SetParameter(2,_normX);
  ueFun->SetParameter(3,_scaleX);
  double ue_lim=5.0*_scaleX*_sigmaX>_met ? 5.0*_scaleX*_sigmaX : 2.0*_met;
  double scaleF=ueFun->Integral(-1.0*ue_lim,1.0*ue_lim);
  double test_prob;
  if(scaleF>0.0) test_prob=1.0-(ueFun->Integral(-1.0*_met,_met))/scaleF;
  else test_prob=1.0;
  if(test_prob<=0.0) test_prob=1.0E-19;
  if(test_prob>1.0) test_prob=1.0; 
  stuff.max_MetProbInteg=stuff.max_MetProbInteg*(1.0-test_prob); // calculating upper limit on MetProb
  ueFun->SetParameter(0,_meanY);
  ueFun->SetParameter(1,_sigmaY);
  ueFun->SetParameter(2,_normY);
  ueFun->SetParameter(3,_scaleY);
  ue_lim=5.0*_scaleY*_sigmaY>_met ? 5.0*_scaleY*_sigmaY : 2.0*_met;
  scaleF=ueFun->Integral(-1.0*ue_lim,1.0*ue_lim);
  if(scaleF>0.0) test_prob=1.0-(ueFun->Integral(-1.0*_met,_met))/scaleF;
  else test_prob=1.0;
  if(test_prob<=0.0) test_prob=1.0E-19;
  if(test_prob>1.0) test_prob=1.0; 
  stuff.max_MetProbInteg=stuff.max_MetProbInteg*(1.0-test_prob); // calculating upper limit on MetProb
  delete ueFun;
  //------------------------------------------------------------
  //______ jet part
  for(int i=0; i<jetstuff.newJetLev6.size(); i++)
    {
      if(jetstuff.newJetLev6[i].Pt()>3.0 && fabs(jetstuff.newJetLev6[i].Eta())<=MaxJetEta)
	{
	  double parJER[5];
	  parJER[0]=MyJer_meanG(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode); // for now systcode is used as jer_stat_code
	  parJER[1]=MyJer_sigmaG(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	  parJER[2]=MyJer_mpvL(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	  parJER[3]=MyJer_sigmaL(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	  parJER[4]=MyJer_normG(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);

	  double jer_limit=MyIntegralUpLimit(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	  TF1* JerFun=new TF1("jer",MyJER,-1.0,jer_limit,5);
	  for(int par_ind=0; par_ind<5; par_ind++)
	    {
	      JerFun->SetParameter(par_ind,parJER[par_ind]);
	    }
	  double tot_jetInt=JerFun->Integral(-1.0,jer_limit);
	  double off_set=JerFun->GetMaximumX(-1.0,1.0); // returns mpv of JER function;

	  if(jetstuff.newJetLev6[i].Pt()-_met>jet_EtCut)
	    {
	      double x1=-_met/jetstuff.newJetLev6[i].Pt()+off_set;
	      double x2=_met/jetstuff.newJetLev6[i].Pt()+off_set;
	      if(x1<-1.0) x1=-1.0;
	      if(x2>jer_limit) x2=jer_limit;  
	      test_prob=1.0-(JerFun->Integral(x1,x2))/tot_jetInt;
	      if(test_prob<=0.0) test_prob=1.0E-19;
	      if(test_prob>1.0) test_prob=1.0;
	      stuff.max_MetProbInteg=stuff.max_MetProbInteg*(1.0-test_prob); // calculating upper limit on MetProb
	    }
	  else
	    {
	      double x1=jet_EtCut/jetstuff.newJetLev6[i].Pt()-1.0+off_set;
	      double x2=_met/jetstuff.newJetLev6[i].Pt()+off_set;
	      if(x2<x1) x2=x1;
	      if(x2>jer_limit) x2=jer_limit;  
	      test_prob=1.0-(JerFun->Integral(-1.0,x2))/tot_jetInt;
	      if(test_prob<=0.0) test_prob=1.0E-19;
	      if(test_prob>1.0) test_prob=1.0;
	      if(jetstuff.newJetLev6[i].Pt()+_met>jet_EtCut) stuff.max_MetProbInteg=stuff.max_MetProbInteg*(1.0-test_prob); // upper lim on MetProb
	    }
	  delete JerFun;
	}
    }

  return;
}

//___ This function returns input parameters for MetSig correction
double TMyJetFilterModule::MetSigCorrPAR(int ind, int njet15, int isMC, int sample_id) {
  double param=0.0;
  double par_arr[3][6]; // fixed array length on 06/20/08
  int jetind=0;
  if(njet15==0) jetind=0;
  if(njet15==1) jetind=1;
  if(njet15>=2) jetind=2;
  if(ind<0 || ind>5) return 0.0; // fixed on 06/23/08
  if(isMC==0) // for MC
    {
      if(sample_id==0) // Pythia ggX signal
	{
	  // Pythia calibration params are the same as in the e-log entry on 06/23/08
	  par_arr[0][0]=0.008;  par_arr[1][0]=0.1586;  par_arr[2][0]=0.1438;
	  par_arr[0][1]=-3.088; par_arr[1][1]=1.515;   par_arr[2][1]=1.4; 
	  par_arr[0][2]=-2.625;	par_arr[1][2]=-0.104;  par_arr[2][2]=-0.081;
	  par_arr[0][3]=0.1807;	par_arr[1][3]=0.00076; par_arr[2][3]=0.000179;
	  par_arr[0][4]=2.247;  par_arr[1][4]=0.507;   par_arr[2][4]=0.143;  
// 	  par_arr[0][5]=6.17;   par_arr[1][5]=15.11;   par_arr[2][5]=12.57;  
	  par_arr[0][5]=6.17;   par_arr[1][5]=12.0;   par_arr[2][5]=9.0;  
	}
      if(sample_id==2) // Pythia cem-cem Z->ee
	{
	  // fixed some entires on 06/20/08 (made the same as in 01/20/08 -- "Re-calibration of MetSig")
	  par_arr[0][0]=0.00986; par_arr[1][0]=0.6469;  par_arr[2][0]=0.5971;
	  par_arr[0][1]=-2.19; 	 par_arr[1][1]=1.507;   par_arr[2][1]=1.382; 
	  par_arr[0][2]=-2.10;	 par_arr[1][2]=-0.1073; par_arr[2][2]=-0.0857;
	  par_arr[0][3]=0.1774;	 par_arr[1][3]=0.00564; par_arr[2][3]=0.00121;
	  par_arr[0][4]=2.168;   par_arr[1][4]=0.6112;  par_arr[2][4]=0.359;  
// 	  par_arr[0][5]=5.97;    par_arr[1][5]=10.65;   par_arr[2][5]=15.01;  
	  par_arr[0][5]=5.97;    par_arr[1][5]=12.0;   par_arr[2][5]=9.0;  
	}
      if(sample_id==3) // Pythia pho-jet(Pt_hat>22) (if Z->ee parameterization is used)  
	{
	  par_arr[0][0]=0.00986; par_arr[1][0]=0.1624;    par_arr[2][0]=0.1418;
	  par_arr[0][1]=-2.19; 	 par_arr[1][1]=1.641;     par_arr[2][1]=1.405; 
	  par_arr[0][2]=-2.10;	 par_arr[1][2]=-0.0276;   par_arr[2][2]=-0.06082;
	  par_arr[0][3]=0.1774;	 par_arr[1][3]=0.000395;  par_arr[2][3]=0.000426;
	  par_arr[0][4]=2.168;   par_arr[1][4]=0.4546;    par_arr[2][4]=0.40;  
	  par_arr[0][5]=5.97;    par_arr[1][5]=19.01;     par_arr[2][5]=19.01;  
	}
    }
  if(isMC==1) // for DATA
    {
      if(sample_id==0) // ggX signal
	{
	  // fixed some entires on 06/20/08 (made the same as in 01/20/08 -- "Re-calibration of MetSig")
	  par_arr[0][0]=0.00693; par_arr[1][0]=0.6237; par_arr[2][0]=0.587;
	  par_arr[0][1]=-3.37; 	 par_arr[1][1]=1.387;  par_arr[2][1]=1.316; 
	  par_arr[0][2]=-2.79;	 par_arr[1][2]=-0.180; par_arr[2][2]=-0.127;
	  par_arr[0][3]=0.1838;	 par_arr[1][3]=0.0083; par_arr[2][3]=0.0022;
	  par_arr[0][4]=2.26;    par_arr[1][4]=0.624;  par_arr[2][4]=0.36;  
// 	  par_arr[0][5]=5.59;    par_arr[1][5]=11.81;  par_arr[2][5]=14.75;  
	  par_arr[0][5]=5.59;    par_arr[1][5]=12.0;  par_arr[2][5]=9.0;  
	}
      if(sample_id==1) // ggX sideband
	{
	  par_arr[0][0]=0.00849; par_arr[1][0]=0.5939; par_arr[2][0]=0.570;
	  par_arr[0][1]=-3.04; 	 par_arr[1][1]=1.295;  par_arr[2][1]=1.273; 
	  par_arr[0][2]=-2.61;	 par_arr[1][2]=-0.227; par_arr[2][2]=-0.141;
	  par_arr[0][3]=0.1813;	 par_arr[1][3]=0.0161; par_arr[2][3]=0.0051;
	  par_arr[0][4]=2.277;   par_arr[1][4]=0.724;  par_arr[2][4]=0.50;  
// 	  par_arr[0][5]=5.39;    par_arr[1][5]=8.69;   par_arr[2][5]=11.65;  
	  par_arr[0][5]=5.39;    par_arr[1][5]=12.0;   par_arr[2][5]=9.0;  
	}
      if(sample_id==2) // cem-cem Z->ee
	{
	  // fixed some entires on 06/20/08 (made the same as in 01/20/08 -- "Re-calibration of MetSig")
	  par_arr[0][0]=0.0065;  par_arr[1][0]=0.6395; par_arr[2][0]=0.611;
	  par_arr[0][1]=-4.03; 	 par_arr[1][1]=1.504;  par_arr[2][1]=1.466; 
	  par_arr[0][2]=-3.70;	 par_arr[1][2]=-0.140; par_arr[2][2]=-0.041;
	  par_arr[0][3]=0.1794;	 par_arr[1][3]=0.0142; par_arr[2][3]=0.00056;
	  par_arr[0][4]=2.151;   par_arr[1][4]=0.675;  par_arr[2][4]=0.17;  
// 	  par_arr[0][5]=6.11;    par_arr[1][5]=12.65;  par_arr[2][5]=14.35;  
	  par_arr[0][5]=6.11;    par_arr[1][5]=12.0;  par_arr[2][5]=9.0;  
	}
      if(sample_id==3) // Use Pythia pho-jet(Pt_hat>22) for a moment (if Z->ee parameterization is used)  
	{
	  par_arr[0][0]=0.00986; par_arr[1][0]=0.1624;    par_arr[2][0]=0.1418;
	  par_arr[0][1]=-2.19; 	 par_arr[1][1]=1.641;     par_arr[2][1]=1.405; 
	  par_arr[0][2]=-2.10;	 par_arr[1][2]=-0.0276;   par_arr[2][2]=-0.06082;
	  par_arr[0][3]=0.1774;	 par_arr[1][3]=0.000395;  par_arr[2][3]=0.000426;
	  par_arr[0][4]=2.168;   par_arr[1][4]=0.4546;    par_arr[2][4]=0.40;  
	  par_arr[0][5]=5.97;    par_arr[1][5]=19.01;     par_arr[2][5]=19.01;  
	}
    }

  param=par_arr[jetind][ind];
  return param;
}


//______________ This functio returns corrected (true) MetSig
double TMyJetFilterModule::MetSigCorrection(double rawSig) {
  double corr=1.0;
  if(fSampleID>=0 && fSampleID<=4)
    {
      float cut1=0.0;
      float cut2=20.0;
      TF1 *fitFun=new TF1("fit",rawMetSigFunc,cut1,cut2,5);
      int njet=jet04stuff.myNjet_th15;
      fitFun->SetParameter(0,MetSigCorrPAR(0,njet,fJTC_imode,fSampleID));
      fitFun->SetParameter(1,MetSigCorrPAR(1,njet,fJTC_imode,fSampleID));
      fitFun->SetParameter(2,MetSigCorrPAR(2,njet,fJTC_imode,fSampleID));
      fitFun->SetParameter(3,MetSigCorrPAR(3,njet,fJTC_imode,fSampleID));
      fitFun->SetParameter(4,MetSigCorrPAR(4,njet,fJTC_imode,fSampleID));
      
      double bin_int=0.0;
      double bin_int0=0.0;
      double last_bin_slope=1.0;
      double tot_int=fitFun->Integral(0.0,20.0);
      double par5=MetSigCorrPAR(5,njet,fJTC_imode,fSampleID); // fixed par5 on 06/20/08
      
      bin_int=fitFun->Integral(0.0,rawSig);
      if(tot_int>0.0 && par5>0.0) bin_int=bin_int/tot_int;
      else 
	{
	  delete fitFun;
	  return rawSig;
	}
      if(bin_int>0.0 && bin_int<1.0 && rawSig<par5 && rawSig>0.0) corr=-log10(1-bin_int)/rawSig;
      else 
	{
	  bin_int0=fitFun->Integral(0.0,par5);
	  bin_int0=bin_int0/tot_int;
	  last_bin_slope=-log10(1-bin_int0)/par5;      
	  corr=last_bin_slope;
	}
      if(corr<0.0) corr=1.0;
      delete fitFun;
    }
  return rawSig*corr;
}

//___ This function returns my Met significance for all events
double TMyJetFilterModule::MyTotalMetSignificance(JetStuff jetstuff, TVector2 myMetVec, int systcode, int systcodeUncl) {

  ClearMetProbStuff(metsigstuff); //clears metprob stuff
  InitMetProbStuff(metsigstuff,jetstuff,myMetVec,systcode,systcodeUncl); //inits params for MetProb

  double metSig_est=0.0;
  if(metsigstuff.max_MetProbInteg>0.0 && metsigstuff.max_MetProbInteg<1.0) metSig_est=-1.0*log10(1.0-metsigstuff.max_MetProbInteg);
  if(metsigstuff.max_MetProbInteg<=0.0) metSig_est=0.0;
  if(metsigstuff.max_MetProbInteg>=1.0) metSig_est=19.0;
  if((19.0-metSig_est)>0.1) metSig_est=MetSigCorrection(metSig_est);
  return metSig_est;
}

//___ filling final histogram for MetSig correction
void TMyJetFilterModule::FinalMetSigCorrHisto(MetStudyHisto_t& Hist) {
  int nbins=Hist.fMetSigCalib_estimate->GetNbinsX();
  int Nevnt=Hist.fMetSigCalib_estimate->GetEntries();
  double bin_val=0.0;
  double sum=0.0;
  double corr=0.0;
  double corr_err=0.0;
  for(int i=0; i<nbins; i++)
    {
      bin_val=Hist.fMetSigCalib_estimate->GetBinContent(i+1);
      if(bin_val>0.0) sum=sum+bin_val/(1.0*Nevnt);
      if(sum<1.0)
	{
	  corr=-1.0*log10(1.0-sum);
	  if(bin_val>0.0 && Nevnt>0) corr_err=sqrt(bin_val)/(log(10.0)*(1.0-sum)*Nevnt);
	  else corr_err=0.0;
	  if(corr_err>0.0) 
	    {
	      Hist.fMetSig_corrFactor->SetBinContent(i+1,corr);
	      Hist.fMetSig_corrFactor->SetBinError(i+1,corr_err);
	    }
	}
      else 
	{
	  Hist.fMetSig_corrFactor->SetBinContent(i+1,log10(1.0*Nevnt));
	  Hist.fMetSig_corrFactor->SetBinError(i+1,1.0/log(10.0));	  
	}
    }

  //---------------------- calculating efficiency of MetSig cut for toy MC
  for(int i=1; i<5; i++)
    {
      Hist.fMetSigToy_eff[i-1]->Divide(Hist.fMetSigToy_Met[i],Hist.fMetSigToy_Met[0]);
      nbins=Hist.fMetSigToy_eff[i-1]->GetNbinsX();
      for(int j=0; j<nbins; j++)
	{
	  double val1=Hist.fMetSigToy_Met[i]->GetBinContent(j+1);
	  double val2=Hist.fMetSigToy_Met[0]->GetBinContent(j+1);
	  double err=0.0;
	  if(val2>0.0) err=sqrt(val1*(1.0-val1/val2))/val2; // this efficiency is wrong. need a precise formula for efficiency
	  Hist.fMetSigToy_eff[i-1]->SetBinError(j+1,err);
	}
    }
  return;
}


//___ This is new function to generate Met; it takes care of unclustered & jet components of Met.
//___ cleanup histograms for generated met are also filled here.
void TMyJetFilterModule::GenerateMyTotalMet(JetStuff jetstuff, CommonStuff miscstuff, MetCleanupHisto_t& Hist, 
					    int systcode, int systcodeUncl, int metcode, int rnd_seed, TVector2 &myGenMet) {
  if(systcode!=0 || systcodeUncl!=0) gRandom->SetSeed(rnd_seed);
  std::vector<TLorentzVector> jet_smeared; // new as of 04/03/07
  jet_smeared.clear(); // new as of 04/03/07
  myGenMet.Set(0.0,0.0);
  //___________ generating met due to jets
  double SumEtJet_smear=0.0; // U.E.+M.I. for jets above threshold after smearing
  double SumEtJet=0.0;       // U.E.+M.I. for jets above threshold before smearing 
  double SumEtRawJet=0.0;
  double SumEtRawJet_smear=0.0;
  double Pt_cut[5]={2000.0,5.0,10.0,15.0,20.0};
  std::vector<int> jet_ind; // index of smeared jets fluctuated above Pt-cut
  double cut;
  double scale_factor=1.0;
  TLorentzVector jetmetsum(0.0,0.0,0.0,0.0);
  jet_smeared.clear(); // new as of 04/03/07, need to clear again
  TVector2 myJetMet(0.0,0.0);
  int NjetCut=0;
  if(metcode==0) NjetCut=jetstuff.myNjet;   
  if(metcode==1) NjetCut=jetstuff.myNjet_th5;   
  if(metcode==2) NjetCut=jetstuff.myNjet_th10;   
  if(metcode==3) NjetCut=jetstuff.myNjet_th15;   
  if(metcode==4) NjetCut=jetstuff.myNjet_th20;   
  if(metcode>0 && metcode<5 && NjetCut>0) 
    {
      cut=Pt_cut[metcode];
      for(int i=0; i<jetstuff.newJetLev6.size(); i++) // "jetstuff.Jet_lev6_noEMobj" is replaced by "jetstuff.newJetLev6" (11/02/06)
	{
	  //on line below I use exactly the same eta cut as in MET correction
	  if(jetstuff.newJetLev6[i].Pt()>3.0 && fabs(jetstuff.newJetLev6[i].Eta())<=MaxJetEta) // "jetstuff.Jet_lev6_noEMobj" is replaced by "jetstuff.newJetLev6" (11/02/06) 
	    {
	      double parJER[5];
	      parJER[0]=MyJer_meanG(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode); // for now systcode is used as jer_stat_code
	      parJER[1]=MyJer_sigmaG(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	      parJER[2]=MyJer_mpvL(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	      parJER[3]=MyJer_sigmaL(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	      parJER[4]=MyJer_normG(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	      double jer_limit=MyIntegralUpLimit(jetstuff.newJetLev6[i].E(),jetstuff.EtaDetCorr[i],0,systcode);
	      TF1* JerFun=new TF1("jer",MyJER,-1.0,jer_limit,5);
	      //------ setting Gaussian
	      JerFun->SetParameter(0,parJER[0]); 
	      JerFun->SetParameter(1,parJER[1]); 
	      //------ setting Landau
	      JerFun->SetParameter(2,parJER[2]);
	      JerFun->SetParameter(3,parJER[3]);
	      //------ setting Gaussian normalization
	      JerFun->SetParameter(4,parJER[4]);
	      double off_set=JerFun->GetMaximumX(-1.0,1.0); // returns mpv of JER function;
	      scale_factor=1.0-off_set+JerFun->GetRandom(); // get jet energy scale factor; default=assume jet scale is 1.0
// 	      scale_factor=1.0+JerFun->GetRandom(); // get jet energy scale factor
	      if(scale_factor<0.0) scale_factor=0.0; 
	      delete JerFun;
	      jet_smeared.push_back(scale_factor*jetstuff.newJetLev6[i]); // new as of 04/03/07
	      if((scale_factor*jetstuff.newJetLev6[i]).Pt()>cut) // "jetstuff.Jet_lev6_noEMobj" is replaced by "jetstuff.newJetLev6" (11/02/06)
		{
		  jet_ind.push_back(i); // temporary; commented out on 06/27/06 for studies
		  jetmetsum=jetmetsum+(1.0-scale_factor)*jetstuff.newJetLev6[i]; // "jetstuff.Jet_lev6_noEMobj" is replaced by "jetstuff.newJetLev6" (11/02/06)
		  // SumEtJet_smear= Sum(U.E.+M.I.)
		  SumEtJet_smear=SumEtJet_smear+jetstuff.Jet_lev5_noEMobj[i].Pt()
		    +jetstuff.Jet_lev1_noEMobj[i].Pt()
		    -jetstuff.Jet_lev4_noEMobj[i].Pt()
		    -jetstuff.Jet_lev6_noEMobj[i].Pt(); // Jet_lev6_noEMobj added on 06/26/06
		  SumEtRawJet_smear=SumEtRawJet_smear+jetstuff.Jet_raw_noEMobj[i].Pt();
		}
	      if(jetstuff.Jet_lev6_noEMobj[i].Pt()>cut) 
		{
		  SumEtJet=SumEtJet+jetstuff.Jet_lev5_noEMobj[i].Pt()
		    +jetstuff.Jet_lev1_noEMobj[i].Pt()
		    -jetstuff.Jet_lev4_noEMobj[i].Pt()
		    -jetstuff.Jet_lev6_noEMobj[i].Pt(); // Jet_lev6_noEMobj added on 06/26/06
		  SumEtRawJet=SumEtRawJet+jetstuff.Jet_raw_noEMobj[i].Pt();
		}
	    }
	}
      myJetMet.Set(jetmetsum.Px(),jetmetsum.Py());   
    }
  //_____________ generating unclustered component of Met
  double x;
  double y;
  double _meanX=0.0;
  double _sigmaX=0.0;
  double _meanY=0.0;
  double _sigmaY=0.0;
  double _normX=0.0;
  double _scaleX=0.0;
  double _normY=0.0;
  double _scaleY=0.0;
  double sumEt=0.0;
  double sumEt_raw=0.0;  
  //--------------------- this chunk of code is modified on 11/09/06
  if(metcode==1) sumEt_raw=jetstuff.mySumEtCorr_th5-SumEtJet+SumEtRawJet;
  if(metcode==2) sumEt_raw=jetstuff.mySumEtCorr_th10-SumEtJet+SumEtRawJet;
  if(metcode==3) sumEt_raw=jetstuff.mySumEtCorr_th15-SumEtJet+SumEtRawJet;
  if(metcode==4) sumEt_raw=jetstuff.mySumEtCorr_th20-SumEtJet+SumEtRawJet;
  if(metcode<1 || metcode>4) sumEt_raw=miscstuff.mySumEt_raw;
  sumEt=sumEt_raw+SumEtJet_smear-SumEtRawJet_smear;
  //------------------------------------------------ end of 11/09/06 part
  if(sumEt<0.0) sumEt=0.0;
  GetMyUnclMetResolution(sumEt,fJTC_imode,fUnclParamSwitch,systcodeUncl,_sigmaX,_sigmaY,_meanX,_meanY,_normX,_normY,_scaleX,_scaleY);
  //------- new part (05/24/07)
  TF1* UnclMetFun=new TF1("fit",UnclMetResolution,-200.0,200.0,4);
  //------ setting 1st Gaussian
  UnclMetFun->SetParameter(0,_meanX);
  UnclMetFun->SetParameter(1,_sigmaX);  
  //------ setting 2nd Gaussian
  UnclMetFun->SetParameter(2,_normX);  
  UnclMetFun->SetParameter(3,_scaleX);
  x=UnclMetFun->GetRandom();
  UnclMetFun->SetParameter(0,_meanY);
  UnclMetFun->SetParameter(1,_sigmaY);  
  //------ setting 2nd Gaussian
  UnclMetFun->SetParameter(2,_normY);  
  UnclMetFun->SetParameter(3,_scaleY);
  y=UnclMetFun->GetRandom();
  delete UnclMetFun;
  //------- end of new part (05/24/07)
  myGenMet.Set(x,y); 
  myGenMet=myGenMet+myJetMet;
//   //_______________ new part, 09/20/06
//   TVector2 myEMGenMet(0.0,0.0);
//   GenerateMyEMobjMet(miscstuff,systcode,myEMGenMet);
//   myGenMet=myGenMet+myEMGenMet;
  //___________________________________ filling GenMet cleanup histograms
  if(fAnalysisMode==0) FillGenMetCleanupHistograms(Hist,jetstuff,miscstuff,myGenMet,jetstuff.Jet_lev6_noEMobj); // histo for generated met cleanup studies

  return;
}

//_______________ ZEROes met_results arrays; to be called in BeginJob
void TMyJetFilterModule::CleanMetResults(MetResults &metstuff) {
  
  for(int i=0; i<3; i++)
    {
      for(int j=0; j<10; j++)
	{
	  metstuff.ana20Njet_dt[i][j]=0; 
	  metstuff.ana25Njet_dt[i][j]=0; 
	  metstuff.ana30Njet_dt[i][j]=0; 
	  metstuff.ana35Njet_dt[i][j]=0; 
	  metstuff.ana40Njet_dt[i][j]=0; 
	  metstuff.ana45Njet_dt[i][j]=0; 
	  metstuff.ana50Njet_dt[i][j]=0; 
	  metstuff.ana75Njet_dt[i][j]=0; 
	  metstuff.ana100Njet_dt[i][j]=0; 
	  metstuff.ana150Njet_dt[i][j]=0; 
	  for(int l=0; l<20; l++)
	    {
	      metstuff.ana20Njet_bg[l][i][j]=0; 
	      metstuff.ana25Njet_bg[l][i][j]=0; 
	      metstuff.ana30Njet_bg[l][i][j]=0; 
	      metstuff.ana35Njet_bg[l][i][j]=0; 
	      metstuff.ana40Njet_bg[l][i][j]=0; 
	      metstuff.ana45Njet_bg[l][i][j]=0; 
	      metstuff.ana50Njet_bg[l][i][j]=0; 
	      metstuff.ana75Njet_bg[l][i][j]=0; 
	      metstuff.ana100Njet_bg[l][i][j]=0; 
	      metstuff.ana150Njet_bg[l][i][j]=0; 
	    }

	  metstuff.Met20Njet_dt[i][j]=0; 
	  metstuff.Met25Njet_dt[i][j]=0; 
	  metstuff.Met30Njet_dt[i][j]=0; 
	  metstuff.Met35Njet_dt[i][j]=0; 
	  metstuff.Met40Njet_dt[i][j]=0; 
	  metstuff.Met45Njet_dt[i][j]=0; 
	  metstuff.Met50Njet_dt[i][j]=0; 
	  metstuff.Met75Njet_dt[i][j]=0; 
	  metstuff.Met100Njet_dt[i][j]=0; 
	  metstuff.Met150Njet_dt[i][j]=0; 
	  metstuff.Met20Njet_def[i][j]=0; 
	  metstuff.Met25Njet_def[i][j]=0; 
	  metstuff.Met30Njet_def[i][j]=0; 
	  metstuff.Met35Njet_def[i][j]=0; 
	  metstuff.Met40Njet_def[i][j]=0; 
	  metstuff.Met45Njet_def[i][j]=0; 
	  metstuff.Met50Njet_def[i][j]=0;
	  metstuff.Met75Njet_def[i][j]=0; 
	  metstuff.Met100Njet_def[i][j]=0; 
	  metstuff.Met150Njet_def[i][j]=0;

	  metstuff.Met20Njet_gen[i][j]=0.0; 
	  metstuff.Met25Njet_gen[i][j]=0.0; 
	  metstuff.Met30Njet_gen[i][j]=0.0; 
	  metstuff.Met35Njet_gen[i][j]=0.0; 
	  metstuff.Met40Njet_gen[i][j]=0.0; 
	  metstuff.Met45Njet_gen[i][j]=0.0; 
	  metstuff.Met50Njet_gen[i][j]=0.0; 
	  metstuff.Met75Njet_gen[i][j]=0.0; 
	  metstuff.Met100Njet_gen[i][j]=0.0; 
	  metstuff.Met150Njet_gen[i][j]=0.0; 
	  metstuff.Met20Njet_genstat[i][j]=0.0; 
	  metstuff.Met25Njet_genstat[i][j]=0.0; 
	  metstuff.Met30Njet_genstat[i][j]=0.0; 
	  metstuff.Met35Njet_genstat[i][j]=0.0; 
	  metstuff.Met40Njet_genstat[i][j]=0.0; 
	  metstuff.Met45Njet_genstat[i][j]=0.0; 
	  metstuff.Met50Njet_genstat[i][j]=0.0; 
	  metstuff.Met75Njet_genstat[i][j]=0.0; 
	  metstuff.Met100Njet_genstat[i][j]=0.0; 
	  metstuff.Met150Njet_genstat[i][j]=0.0; 
	  metstuff.Met20Njet_gensyst[i][j]=0.0; 
	  metstuff.Met25Njet_gensyst[i][j]=0.0; 
	  metstuff.Met30Njet_gensyst[i][j]=0.0; 
	  metstuff.Met35Njet_gensyst[i][j]=0.0; 
	  metstuff.Met40Njet_gensyst[i][j]=0.0; 
	  metstuff.Met45Njet_gensyst[i][j]=0.0; 
	  metstuff.Met50Njet_gensyst[i][j]=0.0;
	  metstuff.Met75Njet_gensyst[i][j]=0.0; 
	  metstuff.Met100Njet_gensyst[i][j]=0.0; 
	  metstuff.Met150Njet_gensyst[i][j]=0.0;
	} 
    }
  return;
}

void TMyJetFilterModule::MyMetEventCount(JetStuff jetstuff, CommonStuff miscstuff, int metcode, MetResults &metstuff) {
  double met=0.0;
  int njet15=0;
  int njet20=0;
  int njet25=0;
  
  if(metcode==1) met=jetstuff.myMETcorr_th5.Mod(); 
  if(metcode==2) met=jetstuff.myMETcorr_th10.Mod(); 
  if(metcode==3) met=jetstuff.myMETcorr_th15.Mod(); 
  if(metcode==4) met=jetstuff.myMETcorr_th20.Mod();
  if(metcode<1 || metcode>4) met=miscstuff.myMET_raw.Mod();
  njet15= (jetstuff.myNjet_th15 < 10) ? jetstuff.myNjet_th15 : 9; 
  njet20= (jetstuff.myNjet_th20 < 10) ? jetstuff.myNjet_th20 : 9; 
  njet25= (jetstuff.myNjet_th25 < 10) ? jetstuff.myNjet_th25 : 9; 
  
  if(met>20) 
    {
      metstuff.Met20Njet_dt[0][njet15]++;
      metstuff.Met20Njet_dt[1][njet20]++;
      metstuff.Met20Njet_dt[2][njet25]++;
    }
  if(met>25) 
    {
      metstuff.Met25Njet_dt[0][njet15]++;
      metstuff.Met25Njet_dt[1][njet20]++;
      metstuff.Met25Njet_dt[2][njet25]++;
    }
  if(met>30) 
    {
      metstuff.Met30Njet_dt[0][njet15]++;
      metstuff.Met30Njet_dt[1][njet20]++;
      metstuff.Met30Njet_dt[2][njet25]++;
    }
  if(met>35) 
    {
      metstuff.Met35Njet_dt[0][njet15]++;
      metstuff.Met35Njet_dt[1][njet20]++;
      metstuff.Met35Njet_dt[2][njet25]++;
    }
  if(met>40) 
    {
      metstuff.Met40Njet_dt[0][njet15]++;
      metstuff.Met40Njet_dt[1][njet20]++;
      metstuff.Met40Njet_dt[2][njet25]++;
    }
  if(met>45) 
    {
      metstuff.Met45Njet_dt[0][njet15]++;
      metstuff.Met45Njet_dt[1][njet20]++;
      metstuff.Met45Njet_dt[2][njet25]++;
    }
  if(met>50) 
    {
      metstuff.Met50Njet_dt[0][njet15]++;
      metstuff.Met50Njet_dt[1][njet20]++;
      metstuff.Met50Njet_dt[2][njet25]++;
    }
  if(met>75) 
    {
      metstuff.Met75Njet_dt[0][njet15]++;
      metstuff.Met75Njet_dt[1][njet20]++;
      metstuff.Met75Njet_dt[2][njet25]++;
    }
  if(met>100) 
    {
      metstuff.Met100Njet_dt[0][njet15]++;
      metstuff.Met100Njet_dt[1][njet20]++;
      metstuff.Met100Njet_dt[2][njet25]++;
    }
  if(met>150) 
    {
      metstuff.Met150Njet_dt[0][njet15]++;
      metstuff.Met150Njet_dt[1][njet20]++;
      metstuff.Met150Njet_dt[2][njet25]++;
    }
  return;
}

//______________ counts generated events above Met cut
void TMyJetFilterModule::MyMetModelEventCount(JetStuff jetstuff, TVector2 myGenMet_def,MetResults &metstuff) {
  int njet15=0;
  int njet20=0;
  int njet25=0;
  
  double met_def=myGenMet_def.Mod();
  
  njet15= (jetstuff.myNjet_th15 < 10) ? jetstuff.myNjet_th15 : 9; 
  njet20= (jetstuff.myNjet_th20 < 10) ? jetstuff.myNjet_th20 : 9; 
  njet25= (jetstuff.myNjet_th20 < 10) ? jetstuff.myNjet_th25 : 9; 
  
  //_____________ default parametrization
  if(met_def>20.0 && met_def<2000.0) 
    {
      metstuff.Met20Njet_def[0][njet15]++;
      metstuff.Met20Njet_def[1][njet20]++;
      metstuff.Met20Njet_def[2][njet25]++;
    }
  if(met_def>25.0 && met_def<2000.0) 
    {
      metstuff.Met25Njet_def[0][njet15]++;
      metstuff.Met25Njet_def[1][njet20]++;
      metstuff.Met25Njet_def[2][njet25]++;
    }
  if(met_def>30.0 && met_def<2000.0) 
    {
      metstuff.Met30Njet_def[0][njet15]++;
      metstuff.Met30Njet_def[1][njet20]++;
      metstuff.Met30Njet_def[2][njet25]++;
    }
  if(met_def>35.0 && met_def<2000.0) 
    {
      metstuff.Met35Njet_def[0][njet15]++;
      metstuff.Met35Njet_def[1][njet20]++;
      metstuff.Met35Njet_def[2][njet25]++;
    }
  if(met_def>40.0 && met_def<2000.0) 
    {
      metstuff.Met40Njet_def[0][njet15]++;
      metstuff.Met40Njet_def[1][njet20]++;
      metstuff.Met40Njet_def[2][njet25]++;
    }
  if(met_def>45.0 && met_def<2000.0) 
    {
      metstuff.Met45Njet_def[0][njet15]++;
      metstuff.Met45Njet_def[1][njet20]++;
      metstuff.Met45Njet_def[2][njet25]++;
    }
  if(met_def>50.0 && met_def<2000.0) 
    {
      metstuff.Met50Njet_def[0][njet15]++;
      metstuff.Met50Njet_def[1][njet20]++;
      metstuff.Met50Njet_def[2][njet25]++;
    }
  if(met_def>75.0 && met_def<2000.0) 
    {
      metstuff.Met75Njet_def[0][njet15]++;
      metstuff.Met75Njet_def[1][njet20]++;
      metstuff.Met75Njet_def[2][njet25]++;
    }
  if(met_def>100.0 && met_def<2000.0) 
    {
      metstuff.Met100Njet_def[0][njet15]++;
      metstuff.Met100Njet_def[1][njet20]++;
      metstuff.Met100Njet_def[2][njet25]++;
    }
  if(met_def>150.0 && met_def<2000.0) 
    {
      metstuff.Met150Njet_def[0][njet15]++;
      metstuff.Met150Njet_def[1][njet20]++;
      metstuff.Met150Njet_def[2][njet25]++;
    }
  return;
}


//______________ prints out a comparison of Met in Data to Met Model predictions
void TMyJetFilterModule::MyMetResults(MetResults &metstuff) {

  if(Npoints>0)
    {
      double dummy=0.0;
      double dummy1=0.0;
      double dummy2=0.0;
      double syst_J1=0.0;
      double syst_J2=0.0;
      double syst_U1=0.0;
      double syst_U2=0.0;
      double syst_tmp20[3][10];
      double syst_tmp25[3][10];
      double syst_tmp30[3][10];
      double syst_tmp35[3][10];
      double syst_tmp40[3][10];
      double syst_tmp45[3][10];
      double syst_tmp50[3][10];
      double syst_tmp75[3][10];
      double syst_tmp100[3][10];
      double syst_tmp150[3][10];
      for(int i=0; i<3; i++)
	{
	  for(int j=0; j<10; j++)
	    {
	      if(fAnalysisMode==1)
		{
		  //--------- new event count
		  metstuff.Met20Njet_dt[i][j]=metstuff.ana20Njet_dt[i][j]; 
		  metstuff.Met25Njet_dt[i][j]=metstuff.ana25Njet_dt[i][j]; 
		  metstuff.Met30Njet_dt[i][j]=metstuff.ana30Njet_dt[i][j]; 
		  metstuff.Met35Njet_dt[i][j]=metstuff.ana35Njet_dt[i][j]; 
		  metstuff.Met40Njet_dt[i][j]=metstuff.ana40Njet_dt[i][j]; 
		  metstuff.Met45Njet_dt[i][j]=metstuff.ana45Njet_dt[i][j]; 
		  metstuff.Met50Njet_dt[i][j]=metstuff.ana50Njet_dt[i][j]; 
		  metstuff.Met75Njet_dt[i][j]=metstuff.ana75Njet_dt[i][j]; 
		  metstuff.Met100Njet_dt[i][j]=metstuff.ana100Njet_dt[i][j]; 
		  metstuff.Met150Njet_dt[i][j]=metstuff.ana150Njet_dt[i][j];

		  metstuff.Met20Njet_gen[i][j]=(1.0*metstuff.ana20Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met25Njet_gen[i][j]=(1.0*metstuff.ana25Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met30Njet_gen[i][j]=(1.0*metstuff.ana30Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met35Njet_gen[i][j]=(1.0*metstuff.ana35Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met40Njet_gen[i][j]=(1.0*metstuff.ana40Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met45Njet_gen[i][j]=(1.0*metstuff.ana45Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met50Njet_gen[i][j]=(1.0*metstuff.ana50Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met75Njet_gen[i][j]=(1.0*metstuff.ana75Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met100Njet_gen[i][j]=(1.0*metstuff.ana100Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met150Njet_gen[i][j]=(1.0*metstuff.ana150Njet_bg[0][i][j])/Npoints;

		  metstuff.Met20Njet_genstat[i][j]=sqrt(1.0*metstuff.ana20Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met25Njet_genstat[i][j]=sqrt(1.0*metstuff.ana25Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met30Njet_genstat[i][j]=sqrt(1.0*metstuff.ana30Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met35Njet_genstat[i][j]=sqrt(1.0*metstuff.ana35Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met40Njet_genstat[i][j]=sqrt(1.0*metstuff.ana40Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met45Njet_genstat[i][j]=sqrt(1.0*metstuff.ana45Njet_bg[0][i][j])/Npoints; 
		  metstuff.Met50Njet_genstat[i][j]=sqrt(1.0*metstuff.ana50Njet_bg[0][i][j])/Npoints;
		  metstuff.Met75Njet_genstat[i][j]=sqrt(1.0*metstuff.ana75Njet_bg[0][i][j])/Npoints;
		  metstuff.Met100Njet_genstat[i][j]=sqrt(1.0*metstuff.ana100Njet_bg[0][i][j])/Npoints;
		  metstuff.Met150Njet_genstat[i][j]=sqrt(1.0*metstuff.ana150Njet_bg[0][i][j])/Npoints;
		  
		  syst_tmp20[i][j]=0.0;
		  syst_tmp25[i][j]=0.0;
		  syst_tmp30[i][j]=0.0;
		  syst_tmp35[i][j]=0.0;
		  syst_tmp40[i][j]=0.0;
		  syst_tmp45[i][j]=0.0;
		  syst_tmp50[i][j]=0.0;
		  syst_tmp75[i][j]=0.0;
		  syst_tmp100[i][j]=0.0;
		  syst_tmp150[i][j]=0.0;

		  for(int l=0; l<10; l++)
		    {
		      if(l==0)
			{
			  dummy=fabs(metstuff.ana20Njet_bg[0][i][j]-metstuff.ana20Njet_bg[1][i][j])*1.0;
			  syst_tmp20[i][j]=syst_tmp20[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana25Njet_bg[0][i][j]-metstuff.ana25Njet_bg[1][i][j])*1.0;
			  syst_tmp25[i][j]=syst_tmp25[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana30Njet_bg[0][i][j]-metstuff.ana30Njet_bg[1][i][j])*1.0;
			  syst_tmp30[i][j]=syst_tmp30[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana35Njet_bg[0][i][j]-metstuff.ana35Njet_bg[1][i][j])*1.0;
			  syst_tmp35[i][j]=syst_tmp35[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana40Njet_bg[0][i][j]-metstuff.ana40Njet_bg[1][i][j])*1.0;
			  syst_tmp40[i][j]=syst_tmp40[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana45Njet_bg[0][i][j]-metstuff.ana45Njet_bg[1][i][j])*1.0;
			  syst_tmp45[i][j]=syst_tmp45[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana50Njet_bg[0][i][j]-metstuff.ana50Njet_bg[1][i][j])*1.0;
			  syst_tmp50[i][j]=syst_tmp50[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana75Njet_bg[0][i][j]-metstuff.ana75Njet_bg[1][i][j])*1.0;
			  syst_tmp75[i][j]=syst_tmp75[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana100Njet_bg[0][i][j]-metstuff.ana100Njet_bg[1][i][j])*1.0;
			  syst_tmp100[i][j]=syst_tmp100[i][j]+dummy*dummy;
			  dummy=fabs(metstuff.ana150Njet_bg[0][i][j]-metstuff.ana150Njet_bg[1][i][j])*1.0;		      
			  syst_tmp150[i][j]=syst_tmp150[i][j]+dummy*dummy;
			}
		      else
			{
			  dummy1=fabs(metstuff.ana20Njet_bg[0][i][j]-metstuff.ana20Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana20Njet_bg[0][i][j]-metstuff.ana20Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp20[i][j]=syst_tmp20[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana25Njet_bg[0][i][j]-metstuff.ana25Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana25Njet_bg[0][i][j]-metstuff.ana25Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp25[i][j]=syst_tmp25[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana30Njet_bg[0][i][j]-metstuff.ana30Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana30Njet_bg[0][i][j]-metstuff.ana30Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp30[i][j]=syst_tmp30[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana35Njet_bg[0][i][j]-metstuff.ana35Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana35Njet_bg[0][i][j]-metstuff.ana35Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp35[i][j]=syst_tmp35[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana40Njet_bg[0][i][j]-metstuff.ana40Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana40Njet_bg[0][i][j]-metstuff.ana40Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp40[i][j]=syst_tmp40[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana45Njet_bg[0][i][j]-metstuff.ana45Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana45Njet_bg[0][i][j]-metstuff.ana45Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp45[i][j]=syst_tmp45[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana50Njet_bg[0][i][j]-metstuff.ana50Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana50Njet_bg[0][i][j]-metstuff.ana50Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp50[i][j]=syst_tmp50[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana75Njet_bg[0][i][j]-metstuff.ana75Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana75Njet_bg[0][i][j]-metstuff.ana75Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp75[i][j]=syst_tmp75[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana100Njet_bg[0][i][j]-metstuff.ana100Njet_bg[l*2][i][j])*1.0;
			  dummy2=fabs(metstuff.ana100Njet_bg[0][i][j]-metstuff.ana100Njet_bg[l*2+1][i][j])*1.0;
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp100[i][j]=syst_tmp100[i][j]+dummy*dummy;
			  dummy1=fabs(metstuff.ana150Njet_bg[0][i][j]-metstuff.ana150Njet_bg[l*2][i][j])*1.0;		      
			  dummy2=fabs(metstuff.ana150Njet_bg[0][i][j]-metstuff.ana150Njet_bg[l*2+1][i][j])*1.0;		      
			  dummy=(dummy1>dummy2) ? dummy1 : dummy2;
			  syst_tmp150[i][j]=syst_tmp150[i][j]+dummy*dummy;
			}
		    }
		  metstuff.Met20Njet_gensyst[i][j]=sqrt(1.0*syst_tmp20[i][j])/Npoints; 
		  metstuff.Met25Njet_gensyst[i][j]=sqrt(1.0*syst_tmp25[i][j])/Npoints; 
		  metstuff.Met30Njet_gensyst[i][j]=sqrt(1.0*syst_tmp30[i][j])/Npoints; 
		  metstuff.Met35Njet_gensyst[i][j]=sqrt(1.0*syst_tmp35[i][j])/Npoints; 
		  metstuff.Met40Njet_gensyst[i][j]=sqrt(1.0*syst_tmp40[i][j])/Npoints; 
		  metstuff.Met45Njet_gensyst[i][j]=sqrt(1.0*syst_tmp45[i][j])/Npoints; 
		  metstuff.Met50Njet_gensyst[i][j]=sqrt(1.0*syst_tmp50[i][j])/Npoints;
		  metstuff.Met75Njet_gensyst[i][j]=sqrt(1.0*syst_tmp75[i][j])/Npoints;
		  metstuff.Met100Njet_gensyst[i][j]=sqrt(1.0*syst_tmp100[i][j])/Npoints;
		  metstuff.Met150Njet_gensyst[i][j]=sqrt(1.0*syst_tmp150[i][j])/Npoints;
		}
	      else
		{
		  //--------- old events count
		  metstuff.Met20Njet_genstat[i][j]=sqrt(1.0*metstuff.Met20Njet_def[i][j])/Npoints; 
		  metstuff.Met25Njet_genstat[i][j]=sqrt(1.0*metstuff.Met25Njet_def[i][j])/Npoints; 
		  metstuff.Met30Njet_genstat[i][j]=sqrt(1.0*metstuff.Met30Njet_def[i][j])/Npoints; 
		  metstuff.Met35Njet_genstat[i][j]=sqrt(1.0*metstuff.Met35Njet_def[i][j])/Npoints; 
		  metstuff.Met40Njet_genstat[i][j]=sqrt(1.0*metstuff.Met40Njet_def[i][j])/Npoints; 
		  metstuff.Met45Njet_genstat[i][j]=sqrt(1.0*metstuff.Met45Njet_def[i][j])/Npoints; 
		  metstuff.Met50Njet_genstat[i][j]=sqrt(1.0*metstuff.Met50Njet_def[i][j])/Npoints;
		  metstuff.Met75Njet_genstat[i][j]=sqrt(1.0*metstuff.Met75Njet_def[i][j])/Npoints;
		  metstuff.Met100Njet_genstat[i][j]=sqrt(1.0*metstuff.Met100Njet_def[i][j])/Npoints;
		  metstuff.Met150Njet_genstat[i][j]=sqrt(1.0*metstuff.Met150Njet_def[i][j])/Npoints;
		  		  
		  metstuff.Met20Njet_gen[i][j]=1.0*metstuff.Met20Njet_def[i][j]/Npoints; 
		  metstuff.Met25Njet_gen[i][j]=1.0*metstuff.Met25Njet_def[i][j]/Npoints; 
		  metstuff.Met30Njet_gen[i][j]=1.0*metstuff.Met30Njet_def[i][j]/Npoints; 
		  metstuff.Met35Njet_gen[i][j]=1.0*metstuff.Met35Njet_def[i][j]/Npoints; 
		  metstuff.Met40Njet_gen[i][j]=1.0*metstuff.Met40Njet_def[i][j]/Npoints; 
		  metstuff.Met45Njet_gen[i][j]=1.0*metstuff.Met45Njet_def[i][j]/Npoints; 
		  metstuff.Met50Njet_gen[i][j]=1.0*metstuff.Met50Njet_def[i][j]/Npoints;
		  metstuff.Met75Njet_gen[i][j]=1.0*metstuff.Met75Njet_def[i][j]/Npoints;
		  metstuff.Met100Njet_gen[i][j]=1.0*metstuff.Met100Njet_def[i][j]/Npoints;
		  metstuff.Met150Njet_gen[i][j]=1.0*metstuff.Met150Njet_def[i][j]/Npoints;
		}
	    }
	}
    }

  ofstream outfile(fDatFileName, std::ios::out);
  if (! outfile) 
    {
      std::cerr<<"Error in openning of .DAT file\n";
    }
  if(outfile)
    {
      outfile<<"---------------------------- Results ---------------------------"<<"\n";
      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 20 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met20Njet_dt[0][i]<<"            "
			 <<metstuff.Met20Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met20Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met20Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met20Njet_dt[0][i]<<"            "
		      <<metstuff.Met20Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met20Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met20Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met20Njet_dt[1][i]<<"            "
			 <<metstuff.Met20Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met20Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met20Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met20Njet_dt[1][i]<<"            "
		      <<metstuff.Met20Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met20Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met20Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met20Njet_dt[2][i]<<"            "
			 <<metstuff.Met20Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met20Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met20Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met20Njet_dt[2][i]<<"            "
		      <<metstuff.Met20Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met20Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met20Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 25 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met25Njet_dt[0][i]<<"            "
			 <<metstuff.Met25Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met25Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met25Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met25Njet_dt[0][i]<<"            "
		      <<metstuff.Met25Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met25Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met25Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met25Njet_dt[1][i]<<"            "
			 <<metstuff.Met25Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met25Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met25Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met25Njet_dt[1][i]<<"            "
		      <<metstuff.Met25Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met25Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met25Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met25Njet_dt[2][i]<<"            "
			 <<metstuff.Met25Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met25Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met25Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met25Njet_dt[2][i]<<"            "
		      <<metstuff.Met25Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met25Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met25Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 30 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met30Njet_dt[0][i]<<"            "
			 <<metstuff.Met30Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met30Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met30Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met30Njet_dt[0][i]<<"            "
		      <<metstuff.Met30Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met30Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met30Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met30Njet_dt[1][i]<<"            "
			 <<metstuff.Met30Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met30Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met30Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met30Njet_dt[1][i]<<"            "
		      <<metstuff.Met30Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met30Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met30Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met30Njet_dt[2][i]<<"            "
			 <<metstuff.Met30Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met30Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met30Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met30Njet_dt[2][i]<<"            "
		      <<metstuff.Met30Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met30Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met30Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 35 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met35Njet_dt[0][i]<<"            "
			 <<metstuff.Met35Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met35Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met35Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met35Njet_dt[0][i]<<"            "
		      <<metstuff.Met35Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met35Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met35Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met35Njet_dt[1][i]<<"            "
			 <<metstuff.Met35Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met35Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met35Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met35Njet_dt[1][i]<<"            "
		      <<metstuff.Met35Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met35Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met35Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met35Njet_dt[2][i]<<"            "
			 <<metstuff.Met35Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met35Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met35Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met35Njet_dt[2][i]<<"            "
		      <<metstuff.Met35Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met35Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met35Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 40 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met40Njet_dt[0][i]<<"            "
			 <<metstuff.Met40Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met40Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met40Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met40Njet_dt[0][i]<<"            "
		      <<metstuff.Met40Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met40Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met40Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met40Njet_dt[1][i]<<"            "
			 <<metstuff.Met40Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met40Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met40Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met40Njet_dt[1][i]<<"            "
		      <<metstuff.Met40Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met40Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met40Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met40Njet_dt[2][i]<<"            "
			 <<metstuff.Met40Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met40Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met40Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met40Njet_dt[2][i]<<"            "
		      <<metstuff.Met40Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met40Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met40Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 45 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met45Njet_dt[0][i]<<"            "
			 <<metstuff.Met45Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met45Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met45Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met45Njet_dt[0][i]<<"            "
		      <<metstuff.Met45Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met45Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met45Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met45Njet_dt[1][i]<<"            "
			 <<metstuff.Met45Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met45Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met45Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met45Njet_dt[1][i]<<"            "
		      <<metstuff.Met45Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met45Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met45Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met45Njet_dt[2][i]<<"            "
			 <<metstuff.Met45Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met45Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met45Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met45Njet_dt[2][i]<<"            "
		      <<metstuff.Met45Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met45Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met45Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 50 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met50Njet_dt[0][i]<<"            "
			 <<metstuff.Met50Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met50Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met50Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met50Njet_dt[0][i]<<"            "
		      <<metstuff.Met50Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met50Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met50Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met50Njet_dt[1][i]<<"            "
			 <<metstuff.Met50Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met50Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met50Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met50Njet_dt[1][i]<<"            "
		      <<metstuff.Met50Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met50Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met50Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met50Njet_dt[2][i]<<"            "
			 <<metstuff.Met50Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met50Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met50Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met50Njet_dt[2][i]<<"            "
		      <<metstuff.Met50Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met50Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met50Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 75 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met75Njet_dt[0][i]<<"            "
			 <<metstuff.Met75Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met75Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met75Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met75Njet_dt[0][i]<<"            "
		      <<metstuff.Met75Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met75Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met75Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met75Njet_dt[1][i]<<"            "
			 <<metstuff.Met75Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met75Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met75Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met75Njet_dt[1][i]<<"            "
		      <<metstuff.Met75Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met75Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met75Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met75Njet_dt[2][i]<<"            "
			 <<metstuff.Met75Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met75Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met75Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met75Njet_dt[2][i]<<"            "
		      <<metstuff.Met75Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met75Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met75Njet_gensyst[2][i]<<std::endl; 
	}
      
      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 100 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met100Njet_dt[0][i]<<"            "
			 <<metstuff.Met100Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met100Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met100Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met100Njet_dt[0][i]<<"            "
		      <<metstuff.Met100Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met100Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met100Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met100Njet_dt[1][i]<<"            "
			 <<metstuff.Met100Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met100Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met100Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met100Njet_dt[1][i]<<"            "
		      <<metstuff.Met100Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met100Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met100Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met100Njet_dt[2][i]<<"            "
			 <<metstuff.Met100Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met100Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met100Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met100Njet_dt[2][i]<<"            "
		      <<metstuff.Met100Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met100Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met100Njet_gensyst[2][i]<<std::endl; 
	}
      
      outfile<<"________________________________________________________________"<<"\n";
      outfile<<"                                                                "<<"\n";
      outfile<<" Met > 150 GeV         observed         predicted"<<"\n";
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet15="<<i<<"            "
			 <<metstuff.Met150Njet_dt[0][i]<<"            "
			 <<metstuff.Met150Njet_gen[0][i]<<" +/- "
			 <<metstuff.Met150Njet_genstat[0][i]<<" +/- "
			 <<metstuff.Met150Njet_gensyst[0][i]<<"\n";
	  else outfile<<" Njet15>="<<i<<"            "
		      <<metstuff.Met150Njet_dt[0][i]<<"            "
		      <<metstuff.Met150Njet_gen[0][i]<<" +/- "
		      <<metstuff.Met150Njet_genstat[0][i]<<" +/- "
		      <<metstuff.Met150Njet_gensyst[0][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet20="<<i<<"            "
			 <<metstuff.Met150Njet_dt[1][i]<<"            "
			 <<metstuff.Met150Njet_gen[1][i]<<" +/- "
			 <<metstuff.Met150Njet_genstat[1][i]<<" +/- "
			 <<metstuff.Met150Njet_gensyst[1][i]<<"\n";
	  else outfile<<" Njet20>="<<i<<"            "
		      <<metstuff.Met150Njet_dt[1][i]<<"            "
		      <<metstuff.Met150Njet_gen[1][i]<<" +/- "
		      <<metstuff.Met150Njet_genstat[1][i]<<" +/- "
		      <<metstuff.Met150Njet_gensyst[1][i]<<std::endl; 
	}
      outfile<<"                                                                "<<"\n";
      for(int i=0; i<10; i++)
	{
	  if(i<9) outfile<<"  Njet25="<<i<<"            "
			 <<metstuff.Met150Njet_dt[2][i]<<"            "
			 <<metstuff.Met150Njet_gen[2][i]<<" +/- "
			 <<metstuff.Met150Njet_genstat[2][i]<<" +/- "
			 <<metstuff.Met150Njet_gensyst[2][i]<<"\n";
	  else outfile<<" Njet25>="<<i<<"            "
		      <<metstuff.Met150Njet_dt[2][i]<<"            "
		      <<metstuff.Met150Njet_gen[2][i]<<" +/- "
		      <<metstuff.Met150Njet_genstat[2][i]<<" +/- "
		      <<metstuff.Met150Njet_gensyst[2][i]<<std::endl; 
	}

      outfile<<"---- The End!------"<<std::endl;
    }
  return;
}

//_______________ selects large MET events; writes them to file
int TMyJetFilterModule::MyLargeMetEvent(JetStuff jetstuff, CommonStuff miscstuff, int metscenario, int Nvx12, int runN, int eventN) {
  int largemet_code=0;
  if(fSelectMetEvent!=0)
    {
      int Nexo_obj=0;
      //__________________cuts
      //   double cut_MEt=30.0;
      double cut_MEt=20.0;
      
      //_________________ contribution from MET
      if(metscenario==0 && miscstuff.myMET_raw.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==1 && jetstuff.myMETcorr_th5.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==2 && jetstuff.myMETcorr_th10.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==3 && jetstuff.myMETcorr_th15.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==4 && jetstuff.myMETcorr_th20.Mod() > cut_MEt) Nexo_obj++;
      if((metscenario<0 || metscenario>4) && miscstuff.myMET_raw.Mod() > cut_MEt) Nexo_obj++;
      
      //__________________________ printing out interesting event
      if(Nexo_obj>0)
	{
	  largemet_code=1;
	  //____________________ opening existing file
	  ofstream outfile(fLargeMetEventFileName, std::ios::app);
	  if (! outfile) 
	    {
	      std::cerr<<"Error in openning of .DAT file\n";
	    }
	  if(outfile)
	    {  
	      outfile<<"_____________________________________________________________________________"<<"\n";
	      outfile<<"Run "<<runN<<"  Event "<<eventN<<"\n";
	      outfile<<"Nvx12 "<<Nvx12<<"\n";	  
	      outfile<<"_______ Npho="<<miscstuff.myCorrPhoton.size()<<"\n";
	      //_________________ printing photons
	      for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
		{
		  outfile<<"...... pho-"<<i+1
			 <<" Et="<<miscstuff.myCorrPhoton[i].Pt()
			 <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrPhoton[i].Phi())
			 <<" eta="<<miscstuff.myCorrPhoton[i].Eta()
			 <<" eta_det="<<miscstuff.myPhoEtaDet[i]<<"\n";
		}
	      outfile<<"_______ Nele="<<miscstuff.myCorrElectron.size()<<"\n";
	      //_________________ printing electrons
	      for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
		{
		  outfile<<"...... ele-"<<i+1
			 <<" Et="<<miscstuff.myCorrElectron[i].Pt()
			 <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrElectron[i].Phi())
			 <<" eta="<<miscstuff.myCorrElectron[i].Eta()
			 <<" eta_det="<<miscstuff.myEleEtaDet[i]<<"\n";
		}
	      // 	  outfile<<"_______ Njet15="<<jetstuff.myNjet_th15<<"\n";
	      outfile<<"_______ Njet5="<<jetstuff.myNjet_th5<<"\n";
	      //_________________ printing jets
	      for(int i=0; i<jetstuff.myNjet; i++)
		{
		  // 	      if(jetstuff.Jet_lev6_noEMobj[i].Pt() >=15.0) outfile<<"...... jet-"<<i+1
		  if(jetstuff.Jet_lev6_noEMobj[i].Pt() >=5.0) outfile<<"...... jet-"<<i+1
								     <<" Et="<<jetstuff.Jet_lev6_noEMobj[i].Pt()
								     <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[i].Phi())
								     <<" eta="<<jetstuff.Jet_lev6_noEMobj[i].Eta()
								     <<" eta_det="<<jetstuff.EtaDet[i]
								     <<" raw_em_fr="<<jetstuff.EmFrRaw[i]<<"\n";
		  
		}    
	      //_________________ printing MET
	      if(metscenario==0) outfile<<"_______ MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	      if(metscenario==1) outfile<<"_______ MET="<<jetstuff.myMETcorr_th5.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th5.Phi())<<"\n";
	      if(metscenario==2) outfile<<"_______ MET="<<jetstuff.myMETcorr_th10.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th10.Phi())<<"\n";
	      if(metscenario==3) outfile<<"_______ MET="<<jetstuff.myMETcorr_th15.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th15.Phi())<<"\n";
	      if(metscenario==4) outfile<<"_______ MET="<<jetstuff.myMETcorr_th20.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th20.Phi())<<"\n";
	      if(metscenario<0 || metscenario>4) outfile<<"_______ MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	      outfile<<"............................................................................."<<std::endl;	  
	    }
	}
    }
  return largemet_code;
}

//_______________ event print-out
void TMyJetFilterModule::MyDumpEvent(JetStuff jetstuff, CommonStuff miscstuff, int Nvx12, int runN, int eventN) {
  
  //__________________________ printing out interesting event
  if(fDumpEvent==1)
    {
      //____________________ opening existing file
      ofstream outfile(fDumpEventFileName, std::ios::app);
      if (! outfile) 
	{
	  std::cerr<<"Error in openning of .DAT file\n";
	}
      if(outfile)
	{  
	  outfile<<"_____________________________________________________________________________"<<"\n";
	  outfile<<"Run "<<runN<<"  Event "<<eventN<<"\n";
	  outfile<<"Nvx12 "<<Nvx12<<"\n";	  
	  outfile<<"_______ Npho="<<miscstuff.myCorrPhoton.size()<<"\n";
	  //_________________ printing photons
	  outfile<<"___ printing corrected photons ____"<<"\n"; 
	  for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
	    {
	      outfile<<"...... pho-"<<i+1
		     <<" Et="<<miscstuff.myCorrPhoton[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrPhoton[i].Phi())
		     <<" eta="<<miscstuff.myCorrPhoton[i].Eta()
		     <<" eta_det="<<miscstuff.myPhoEtaDet[i]<<"\n";
	    }
	  outfile<<"___ printing raw photons ____"<<"\n";
	  for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
	    {
	      outfile<<"...... pho-"<<i+1
		     <<" raw Et="<<miscstuff.myRawPhoton[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myRawPhoton[i].Phi())
		     <<" eta="<<miscstuff.myRawPhoton[i].Eta()
		     <<" index="<<miscstuff.myPhoInd[i]<<"\n";
	    }
	  
	  outfile<<"_______ Nele="<<miscstuff.myCorrElectron.size()<<"\n";
	  //_________________ printing electrons
	  outfile<<"___ printing corrected electrons ____"<<"\n";
	  for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
	    {
	      outfile<<"...... ele-"<<i+1
		     <<" Et="<<miscstuff.myCorrElectron[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrElectron[i].Phi())
		     <<" eta="<<miscstuff.myCorrElectron[i].Eta()
		     <<" eta_det="<<miscstuff.myEleEtaDet[i]<<"\n";
	    }
	  outfile<<"___ printing raw electrons ____"<<"\n";
	  for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
	    {
	      outfile<<"...... ele-"<<i+1
		     <<" raw Et="<<miscstuff.myRawElectron[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myRawElectron[i].Phi())
		     <<" eta="<<miscstuff.myRawElectron[i].Eta()
		     <<" index="<<miscstuff.myEleInd[i]<<"\n";
	    }
	  
	  outfile<<"_______ Njet="<<jetstuff.myNjet<<"\n";
	  //_________________ printing jets
	  outfile<<"___ printing corrected jets after removing EM object ____"<<"\n";
	  for(int i=0; i<jetstuff.myNjet; i++)
	    {
	      outfile<<"...... jet-"<<i+1
		     <<" Et="<<jetstuff.Jet_lev6_noEMobj[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[i].Phi())
		     <<" eta="<<jetstuff.Jet_lev6_noEMobj[i].Eta()
		     <<" cor_eta_det="<<jetstuff.EtaDetCorr[i]
		     <<" cor_em_fr="<<jetstuff.EmFrCorr[i]<<"\n";
	    }
	  outfile<<"___ printing raw jets after removing EM object ____"<<"\n";
	  for(int i=0; i<jetstuff.myNjet; i++)
	    {
	      outfile<<"...... jet-"<<i+1
		     <<" Et="<<jetstuff.Jet_raw_noEMobj[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_raw_noEMobj[i].Phi())
		     <<" eta="<<jetstuff.Jet_raw_noEMobj[i].Eta()
		     <<" cor_eta_det="<<jetstuff.EtaDetCorr[i]
		     <<" cor_em_fr="<<jetstuff.EmFrCorr[i]<<"\n";
	    }

	  outfile<<"___ printing corrected jets before removing EM object ____"<<"\n";
	  for(int i=0; i<jetstuff.myNjet; i++)
	    {
	      outfile<<"...... jet-"<<i+1
		     <<" Et="<<jetstuff.Jet_lev6[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_lev6[i].Phi())
		     <<" eta="<<jetstuff.Jet_lev6[i].Eta()
		     <<" raw_eta_det="<<jetstuff.EtaDet[i]
		     <<" raw_em_fr="<<jetstuff.EmFrRaw[i]<<"\n";
	    }
	  outfile<<"___ printing raw jets before removing EM object ____"<<"\n";
	  for(int i=0; i<jetstuff.myNjet; i++)
	    {
	      outfile<<"...... jet-"<<i+1
		     <<" Et="<<jetstuff.Jet_raw[i].Pt()
		     <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_raw[i].Phi())
		     <<" eta="<<jetstuff.Jet_raw[i].Eta()
		     <<" raw_eta_det="<<jetstuff.EtaDet[i]
		     <<" raw_em_fr="<<jetstuff.EmFrRaw[i]<<"\n";
	    }

	  //_________________ printing SumEt
	  outfile<<"_______ raw SumEt="<<miscstuff.mySumEt_raw<<"\n";
	  outfile<<"_______ corr SumEt="<<jetstuff.mySumEtCorr_th15<<"\n";
	  outfile<<"............................................................................."<<std::endl;	  
    
	  //_________________ printing MET
	  outfile<<"_______ raw MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	  outfile<<"_______ corr MET="<<jetstuff.myMETcorr_th15.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th15.Phi())<<"\n";
	  outfile<<"............................................................................."<<std::endl;	  
	}
    }
  return;
}
 
//_______________ selects my exotic events; writes them to file
int TMyJetFilterModule::MyExoticEvent(JetStuff jetstuff, CommonStuff miscstuff, int metscenario, int runN, int eventN) {
  int exo_code=0;
  if(fSelectExoticEvent!=0)
    {
      int Nexo_obj=0;
      //__________________cuts
      int cut_Nexo_obj=3;
      double cut_Et_pho[3]={20.0,20.0,13.0};
      double cut_Et_ele=13.0;
      double cut_Et_jet=50.0; // default = 15.0
      double cut_MEt=30.0;
      
      //_________________ counting jets
      for(int i=0; i<jetstuff.myNjet; i++)
	{
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt() > cut_Et_jet) Nexo_obj++;
	}    
      //_________________ counting photons
      for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
	{
	  if(i<3 && miscstuff.myCorrPhoton[i].Pt() > cut_Et_pho[i]) Nexo_obj++;
	  if(i>2 && miscstuff.myCorrPhoton[i].Pt() > cut_Et_pho[2]) Nexo_obj++;
	}
      //_________________ counting electrons
      for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
	{
	  if(miscstuff.myCorrElectron[i].Pt() > cut_Et_ele) Nexo_obj++;
	}
      //_________________ contribution from MET
      if(metscenario==0 && miscstuff.myMET_raw.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==1 && jetstuff.myMETcorr_th5.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==2 && jetstuff.myMETcorr_th10.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==3 && jetstuff.myMETcorr_th15.Mod() > cut_MEt) Nexo_obj++;
      if(metscenario==4 && jetstuff.myMETcorr_th20.Mod() > cut_MEt) Nexo_obj++;
      if((metscenario<0 || metscenario>4) && miscstuff.myMET_raw.Mod() > cut_MEt) Nexo_obj++;
      
      //__________________________ printing out interesting event
      if(Nexo_obj>=cut_Nexo_obj)
	{
	  exo_code=1;
	  //____________________ opening existing file
	  ofstream outfile(fRearEventFileName, std::ios::app);
	  if (! outfile) 
	    {
	      std::cerr<<"Error in openning of .DAT file\n";
	    }
	  if(outfile)
	    {  
	      outfile<<"_____________________________________________________________________________"<<"\n";
	      outfile<<"Run "<<runN<<"  Event "<<eventN<<"\n";
	      outfile<<"_______ Npho="<<miscstuff.myCorrPhoton.size()<<"\n";
	      //_________________ printing photons
	      for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
		{
		  outfile<<"...... pho-"<<i+1
			 <<" Et="<<miscstuff.myCorrPhoton[i].Pt()
			 <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrPhoton[i].Phi())
			 <<" eta="<<miscstuff.myCorrPhoton[i].Eta()<<"\n";
		}
	      outfile<<"_______ Nele="<<miscstuff.myCorrElectron.size()<<"\n";
	  //_________________ printing electrons
	      for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
		{
		  outfile<<"...... ele-"<<i+1
			 <<" Et="<<miscstuff.myCorrElectron[i].Pt()
			 <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrElectron[i].Phi())
		     <<" eta="<<miscstuff.myCorrElectron[i].Eta()<<"\n";
		}
	      outfile<<"_______ Njet15="<<jetstuff.myNjet_th15<<"\n";
	      //_________________ printing jets
	      for(int i=0; i<jetstuff.myNjet; i++)
		{
		  if(jetstuff.Jet_lev6_noEMobj[i].Pt() >=15.0) outfile<<"...... jet-"<<i+1
								      <<" Et="<<jetstuff.Jet_lev6_noEMobj[i].Pt()
								      <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[i].Phi())
								      <<" eta="<<jetstuff.Jet_lev6_noEMobj[i].Eta()<<"\n";
		}    
	      //_________________ printing MET
	      if(metscenario==0) outfile<<"_______ MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	      if(metscenario==1) outfile<<"_______ MET="<<jetstuff.myMETcorr_th5.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th5.Phi())<<"\n";
	      if(metscenario==2) outfile<<"_______ MET="<<jetstuff.myMETcorr_th10.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th10.Phi())<<"\n";
	      if(metscenario==3) outfile<<"_______ MET="<<jetstuff.myMETcorr_th15.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th15.Phi())<<"\n";
	      if(metscenario==4) outfile<<"_______ MET="<<jetstuff.myMETcorr_th20.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th20.Phi())<<"\n";
	      if(metscenario<0 || metscenario>4) outfile<<"_______ MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	      outfile<<"............................................................................."<<std::endl;	  
	    }
	}
    }
  return exo_code;
}


//_______________ selects my very exotic events; writes them to file
int TMyJetFilterModule::MyVeryExoticEvent(JetStuff jetstuff, CommonStuff miscstuff, int metscenario, 
			int runN, int eventN, int nvx12, std::vector<double> zvx_vec) {
  int exo_code=0;
  if(fSelectExoticEvent!=0)
    {

      //__________________cuts
      
      double cut_Et_pho=200.0;
      double cut_Et_jet=150.0;
      double cut_MEt=40.0;
      double cut_Ht=450.0;
      double cut_Mall=450.0;
      double cut_Mgg=250.0;
      double cut_Mggj=400.0;
      double cut_Mggjj=500.0;
      double cut_Mgj=300.0;
      double cut_Mjj=200.0;
      
      double _Ht=0.0;
      double _Mall=0.0;
      double _Mgg=0.0;
      double _Mggj1=0.0;
      double _Mggjj=0.0;
      double _Mjj=0.0;
      double _Mg1j1=0.0;
      double _Mg2j2=0.0;
      double _Mg1j2=0.0;
      double _Mg2j1=0.0;
      
      TLorentzVector all_vec(0.0,0.0,0.0,0.0);
      //_________________ counting jets
      for(int i=0; i<jetstuff.myNjet; i++)
	{
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt() > cut_Et_jet) exo_code++;
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt() > 15.0) 
	    {
	      _Ht=_Ht+jetstuff.Jet_lev6_noEMobj[i].Pt();
	      all_vec=all_vec+jetstuff.Jet_lev6_noEMobj[i];
	    }
	}    
      //_________________ counting photons
      for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
	{
	  if(miscstuff.myCorrPhoton[i].Pt() > cut_Et_pho) exo_code++;
	  _Ht=_Ht+miscstuff.myCorrPhoton[i].Pt();
	  all_vec=all_vec+miscstuff.myCorrPhoton[i];
	}
      //_________________ contribution from MET
      
      TVector2 met_vec(0.0,0.0);
      if(metscenario==0) met_vec=miscstuff.myMET_raw;
      if(metscenario==1) met_vec=jetstuff.myMETcorr_th5;
      if(metscenario==2) met_vec=jetstuff.myMETcorr_th10;
      if(metscenario==3) met_vec=jetstuff.myMETcorr_th15;
      if(metscenario==4) met_vec=jetstuff.myMETcorr_th20;
      if(metscenario<0 || metscenario>4) met_vec=miscstuff.myMET_raw;
      if(met_vec.Mod() > cut_MEt) exo_code++;
      _Ht=_Ht+met_vec.Mod();
      
      //_________________ counting electrons
      for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
	{
	  _Ht=_Ht+miscstuff.myCorrElectron[i].Pt();
	  all_vec=all_vec+miscstuff.myCorrElectron[i];
	}
      
      _Mall=all_vec.M();
      _Mgg=(miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[1]).M();
      if(jetstuff.myNjet_th15>0) _Mggj1=(miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[1]+jetstuff.Jet_lev6_noEMobj[0]).M();
      if(jetstuff.myNjet_th15>1)
	{
	  _Mggjj=(miscstuff.myCorrPhoton[0]+miscstuff.myCorrPhoton[1]+jetstuff.Jet_lev6_noEMobj[0]+jetstuff.Jet_lev6_noEMobj[1]).M();
	  _Mjj=(jetstuff.Jet_lev6_noEMobj[0]+jetstuff.Jet_lev6_noEMobj[1]).M();
	  _Mg1j1=(miscstuff.myCorrPhoton[0]+jetstuff.Jet_lev6_noEMobj[0]).M();
	  _Mg2j2=(miscstuff.myCorrPhoton[1]+jetstuff.Jet_lev6_noEMobj[1]).M();
	  _Mg1j2=(miscstuff.myCorrPhoton[0]+jetstuff.Jet_lev6_noEMobj[1]).M();
	  _Mg2j1=(miscstuff.myCorrPhoton[1]+jetstuff.Jet_lev6_noEMobj[0]).M();
	}
      
      if(_Ht > cut_Ht) exo_code++;
      if(_Mall > cut_Mall) exo_code++;
      if(_Mgg > cut_Mgg) exo_code++;
      if(_Mggj1 > cut_Mggj) exo_code++;
      if(_Mggjj > cut_Mggjj) exo_code++;
      if(_Mjj > cut_Mjj) exo_code++;
      if(_Mg1j1 > cut_Mgj) exo_code++;
      if(_Mg2j2 > cut_Mgj) exo_code++;
      if(_Mg1j2 > cut_Mgj) exo_code++;
      if(_Mg2j1 > cut_Mgj) exo_code++;
      
      
      //__________________________ printing out interesting event
      if(exo_code>0)
	{
	  //____________________ opening existing file
	  ofstream outfile(fExoticEventFileName, std::ios::app);
	  if (! outfile) 
	    {
	      std::cerr<<"Error in openning of .DAT file\n";
	    }
	  if(outfile)
	    {  
	      outfile<<"_____________________________________________________________________________"<<"\n";
	      outfile<<"Run "<<runN<<"  Event "<<eventN<<"\n";
	      outfile<<"_______ Nvx12="<<nvx12<<"\n";
	      for(int i=0; i<zvx_vec.size(); i++)
		{
		  outfile<<"...... vx-"<<i<<" z="<<zvx_vec[i]<<"\n";
		}
	      //_________________ printing photons
	      for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
		{
		  outfile<<"...... pho-"<<i+1
			 <<" Et="<<miscstuff.myCorrPhoton[i].Pt()
			 <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrPhoton[i].Phi())
			 <<" eta="<<miscstuff.myCorrPhoton[i].Eta()
			 <<" eta_det="<<miscstuff.myPhoEtaDet[i]<<"\n";
		}
	      outfile<<"_______ Nele="<<miscstuff.myCorrElectron.size()<<"\n";
	      //_________________ printing electrons
	      for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
		{
		  outfile<<"...... ele-"<<i+1
			 <<" Et="<<miscstuff.myCorrElectron[i].Pt()
			 <<" Phi="<<TVector2::Phi_0_2pi(miscstuff.myCorrElectron[i].Phi())
			 <<" eta="<<miscstuff.myCorrElectron[i].Eta()<<"\n";
		}
	      outfile<<"_______ Njet15="<<jetstuff.myNjet_th15<<"\n";
	      //_________________ printing jets
	      for(int i=0; i<jetstuff.myNjet; i++)
		{
		  if(jetstuff.Jet_lev6_noEMobj[i].Pt() >=15.0) outfile<<"...... jet-"<<i+1
								      <<" Et="<<jetstuff.Jet_lev6_noEMobj[i].Pt()
								      <<" Phi="<<TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[i].Phi())
								      <<" eta="<<jetstuff.Jet_lev6_noEMobj[i].Eta()
								      <<" eta_det="<<jetstuff.EtaDetCorr[i]
								      <<" emFr="<<jetstuff.EmFrCorr[i]<<"\n";
		}    
	      //_________________ printing MET
	      if(metscenario==0) outfile<<"_______ MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	      if(metscenario==1) outfile<<"_______ MET="<<jetstuff.myMETcorr_th5.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th5.Phi())<<"\n";
	      if(metscenario==2) outfile<<"_______ MET="<<jetstuff.myMETcorr_th10.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th10.Phi())<<"\n";
	      if(metscenario==3) outfile<<"_______ MET="<<jetstuff.myMETcorr_th15.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th15.Phi())<<"\n";
	      if(metscenario==4) outfile<<"_______ MET="<<jetstuff.myMETcorr_th20.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(jetstuff.myMETcorr_th20.Phi())<<"\n";
	      if(metscenario<0 || metscenario>4) outfile<<"_______ MET="<<miscstuff.myMET_raw.Mod()<<" MET_phi="<<TVector2::Phi_0_2pi(miscstuff.myMET_raw.Phi())<<"\n";
	      
	      outfile<<"_______ Ht="<<_Ht<<"\n";
	      outfile<<"_______ M(all)="<<_Mall<<"\n";
	      outfile<<"_______ M(dipho)="<<_Mgg<<"\n";
	      outfile<<"_______ M(dipho+jet)="<<_Mggj1<<"\n";
	      outfile<<"_______ M(dipho+dijet)="<<_Mggjj<<"\n";
	      outfile<<"_______ M(dijet)="<<_Mjj<<"\n";
	      outfile<<"_______ M(pho1+jet1)="<<_Mg1j1<<"\n";
	      outfile<<"_______ M(pho2+jet2)="<<_Mg2j2<<"\n";
	      outfile<<"_______ M(pho1+jet2)="<<_Mg1j2<<"\n";
	      outfile<<"_______ M(pho2+jet1)="<<_Mg2j1<<"\n";
	      
	      outfile<<"............................................................................."<<std::endl;	  
	    }
	}
    }
  return exo_code;
}


//________ creates a list of towers for all jets
void TMyJetFilterModule::MatchCalorTowers(int jet_ind,
					    TStnJetBlock* fJetBlock,
					    TCalDataBlock *fCalDataBlock,
					    CalDataArray* cdholder) {
  cdholder->clear();
  TStnLinkBlock* links = fJetBlock->TowerLinkList();
  int nptow = links->NLinks(jet_ind);

  TCalTower* ctower = NULL;
  for(int j=0; j<nptow; j++) 
    {
      int iptow = links->Index(jet_ind,j);
      int iphi = iptow & 0x3F;
      int ieta = (iptow>>8) & 0x3F;
      
      ctower = fCalDataBlock->Tower(ieta,iphi);
      cdholder->push_back(ctower);
    }

  std::sort(cdholder->begin(), cdholder->end(),SortTowersByEnergy);
  
  return;
}

//________ creates a list of towers for all EM objects
void TMyJetFilterModule::MatchCalorTowers(int pho_ind,
					    TStnPhotonBlock* fPhotonBlock,
					    TCalDataBlock *fCalDataBlock,
					    CalDataArray* cdholder) {
  cdholder->clear();
  TStnLinkBlock* links = fPhotonBlock->TowerLinkList();
  int nptow = links->NLinks(pho_ind);
  TCalTower* ctower = NULL;
  for(int j=0; j<nptow; j++) 
    {
      int iptow = links->Index(pho_ind,j);
      int iphi = iptow & 0x3F;
      int ieta = (iptow>>8) & 0x3F;
      
      ctower = fCalDataBlock->Tower(ieta,iphi);
      cdholder->push_back(ctower);
    }
  
  std::sort(cdholder->begin(),cdholder->end(),SortTowersByEnergy);
  
  return;
}

//________ creates a list of towers for electrons
void TMyJetFilterModule::MatchCalorTowers(int ele_ind,
					  TStnElectronBlock* fElectronBlock,
					  TCalDataBlock *fCalDataBlock,
					  CalDataArray* cdholder) {
  cdholder->clear();
  TStnLinkBlock* links = fElectronBlock->TowerLinkList();
  int nptow = links->NLinks(ele_ind);
  TCalTower* ctower = NULL;
  for(int j=0; j<nptow; j++) 
    {
      int iptow = links->Index(ele_ind,j);
      int iphi = iptow & 0x3F;
      int ieta = (iptow>>8) & 0x3F;
      
      ctower = fCalDataBlock->Tower(ieta,iphi);
      cdholder->push_back(ctower);
    }
  
  std::sort(cdholder->begin(),cdholder->end(),SortTowersByEnergy);
  
  return;
}

//_____________________________________________________________________________
int TMyJetFilterModule::BeginJob() {


//_____________________________________________________ register the data block
  RegisterDataBlock("JetBlock","TStnJetBlock",&fJetBlockClu04);

//---------- need this for jet-EM matching
  RegisterDataBlock("CalDataBlock","TCalDataBlock",&fCalData);
  RegisterDataBlock("PhotonBlock","TStnPhotonBlock",&fPhotonBlock);
  RegisterDataBlock("ElectronBlock","TStnElectronBlock",&fElectronBlock);

//_____________________________________________________ book histograms

  BookHistograms();
  CleanMetResults(met_results);

  //_________ opening a file to write my exotic events (to be filled later)
  ofstream outfile(fRearEventFileName, std::ios::out); // re-creating file
  if (! outfile) 
    {
      std::cerr<<"Error in openning of .DAT file\n";
    }
  if(outfile)
    {
      outfile<<"--------------- My exotic event list ---------------------------"<<"\n";
      outfile<<"________________________________________________________________"<<std::endl;
    }
  ofstream outfile1(fLargeMetEventFileName, std::ios::out); // re-creating file
  if (! outfile1) 
    {
      std::cerr<<"Error in openning of .DAT file\n";
    }
  ofstream outfile0(fDumpEventFileName, std::ios::out); // re-creating file
  if (! outfile0) 
    {
      std::cerr<<"Error in openning of .DAT file\n";
    }
  if(outfile1)
    {
      outfile1<<"--------------- My large MET event list ------------------------"<<"\n";
      outfile1<<"________________________________________________________________"<<std::endl;
    }
  ofstream outfile2(fExoticEventFileName, std::ios::out); // re-creating file
  if (! outfile2) 
    {
      std::cerr<<"Error in openning of .DAT file\n";
    }
  if(outfile2)
    {
      outfile2<<"--------------- My very exotic event list ------------------------"<<"\n";
      outfile2<<"________________________________________________________________"<<std::endl;
    }
 
  EventCount_b=0;
  EventCount_a=0;

  return 0;
}


//_____________________________________________________________________________
int TMyJetFilterModule::BeginRun() {
  return 0;
}

//_____________________________________________________________________________
int TMyJetFilterModule::Event(int ientry) {

  EventCount_b++;
  ClearModuleOutput();
  SigMetEvent_status=0; // re-setting status code for Significan Met event
  bad_EMjet_match_flag=1; // by default no events flagged "bad" in the beginning
  bool pass   = true;

  myJetRun=GetHeaderBlock()->RunNumber(); // obtaining run number, myJetRun is globaly defined 

  //_________________________________________________________________________
  //---------  Accessing Jet Blocks 
  fJetBlockClu04->GetEntry(ientry);

  if(! fPhotonBlock) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fPhotonBlock->GetEntry(ientry);

  if(! fCalData) 
    {
      pass=false;
      SetPassed(0);
      return -1;
    }
  fCalData->GetEntry(ientry);

  if(! fElectronBlock)
    {
      pass=false;
      SetPassed(0);
      return -1;      
    }
  fElectronBlock->GetEntry(ientry);


//------------------------------------- accessing MyVertexFilter
  TMyVertexFilterModule* MyVertex=
    (TMyVertexFilterModule*) ((TStnAna*) GetAna()->GetModule("MyVertexFilter")); 
  std::vector<double> zvxvec;
  double zvx_best=MyVertex->GetmyZvx_best();
  double zvx_2nd=-1000.0;
  myNvx_class12=MyVertex->GetmyNvx12(); //num of class12 vertices, same as GetmyNvx(5) 
  double dzvx_2best=MyVertex->GetmyZsep_best(); // Zsep of two best vertices
  int myNvx_all=MyVertex->GetmyNvx(); // number of all vertices
  if(myNvx_all>1) zvx_2nd=MyVertex->GetmyZvx_2nd();
  double dzvx_best2worse=-1000.0; // worse Zsep between best any other vertex
  double zvx_worse=-1000.0; // largest Zvx 
  for(int i=0; i<myNvx_all; i++)
    {
      zvxvec.push_back(MyVertex->GetmyZvx(i));
      double _dz=zvx_best-(MyVertex->GetmyZvx(i));
      if(fabs(_dz)>dzvx_best2worse) dzvx_best2worse=fabs(_dz);
      if(fabs(MyVertex->GetmyZvx(i))>zvx_worse) zvx_worse=fabs(MyVertex->GetmyZvx(i));
    }
  double _zvx[3];
  _zvx[0]=zvx_best;
  _zvx[1]=zvx_2nd;
  _zvx[2]=zvx_worse;


  //  myZjet=zvx_jet; //------

  DoCommonStuff(allstuff); // reads raw Met, pho, ele info and fills CommonStuff
  DoMyJet(fJetBlockClu04,allstuff,jet04stuff,fMatchPhoJet04); // does my JetClu04 jets
  DoMyMet(allstuff,jet04stuff); // corrects Met & SumEt for JetClu04 jets
  int vx_swap=DiPhoNewVx(allstuff,jet04stuff,zvx_best,zvxvec,fVxMetStudy); // swap vertices to minimize MET
  MyNewJetWithMet(jet04stuff); // adding jet and Met

  //-------------------------------------------------------------------------------
  // Filling histograms before event cuts >>>>>>>>
  //_______________________________________________________________________________
  FillJetHistogramsB(fHistJet04,jet04stuff,zvx_best-fJetBlockClu04->ZVertex(),myNvx_class12); // filling general histo for JetClu04

  //-------------------------------------------------------------------------------
  // Applying event Cuts
  //_______________________________________________________________________________

  //....... temporary cuts
  pass=false;

  if(allstuff.myCorrPhoton.size()>=2)
    {
      if(allstuff.myCorrPhoton[0].Pt()>=13.0 && allstuff.myCorrPhoton[1].Pt()>=13.0) pass=true;
      else 
	{
	  SetPassed(0);
	  return 0;      
	}
    }

  if(MyAnalysisCut(jet04stuff,allstuff,fMyMetScenario)==1) pass=true;
  else 
    {
      SetPassed(0);
      return 0;      
    }
  if(MyNjetCut(jet04stuff)==1) pass=true; // added on 11/07/05
  else 
    {
      SetPassed(0);
      return 0;      
    } 
  if(MyAngularCut(jet04stuff,allstuff)==1) pass=true; // added on 03/08/06 (temporary)
  else
    {
      SetPassed(0);
      return 0;      
    }

  int Nduplicate=MyDuplicateCut(allstuff);
  if(fRemoveDuplicate==1 && Nduplicate>0) // removing duplicates
    {
      SetPassed(0);
      return 0;      
    }
  else pass=true;
  if((fRemoveDuplicate+Nduplicate)<0) // selecting duplicates
    {
      SetPassed(0);
      return 0;      
    }
  else pass=true;

  
  if(pass==true) DoMyAnalysis(jet04stuff,allstuff); // filling analysis histo; needs to be before MetCleanUpCut

  double _dPhi0=0.0; //dummy
  double _dPhi2=10.0; //dummy
  if(allstuff.myCorrPhoton.size()>1) 
    {
      _dPhi0=fabs(TVector2::Phi_mpi_pi(allstuff.myCorrPhoton[0].Phi()-allstuff.myCorrPhoton[1].Phi()));
      _dPhi2=fabs(TVector2::Phi_mpi_pi(allstuff.myCorrPhoton[1].Phi()-jet04stuff.myMETcorr_th15.Phi()));
    }
  if(fSelectGMSBevent==1 
     && MyGMSBevent(_dPhi0,_dPhi2,allstuff.myCorrPhoton[0].Pt(),MyHtAll(jet04stuff,allstuff,3),myMetSig,jet04stuff.myNjet_th15)<1) // reject failed event
    {
      SetPassed(0);
      return 0;            
    }
  else pass=true;
  if(fSelectGMSBevent==-1 
     && MyGMSBevent(_dPhi0,_dPhi2,allstuff.myCorrPhoton[0].Pt(),MyHtAll(jet04stuff,allstuff,3),myMetSig,jet04stuff.myNjet_th15)>0) // reject passed event
    {
      SetPassed(0);
      return 0;            
    }
  else pass=true;
  
  
//   int Nbadmet=MyMetCleanUpCut(jet04stuff,allstuff);
  int Nbadmet=MyMetCleanUpCut(jet04stuff,allstuff,jet04stuff.Jet_lev6_noEMobj,jet04stuff.myMETcorr_th15); // new as of 04/04/07
  if(fRemoveBadMet==1 && Nbadmet>0) // removing events with bad MET
    {
      SetPassed(0);
      return 0;      
    }
  else pass=true;
  if((fRemoveBadMet+Nbadmet)<0) // selecting events with bad MET
    {
      SetPassed(0);
      return 0;      
    }
  else pass=true;
    
  if(pass)
    {
      SetPassed(1);
      //-------------------------------------------------------------------------------
      // Filling histos for events which pass the cuts
      //_______________________________________________________________________________
      FillJetHistogramsA(fHistJet04,jet04stuff,zvx_best-fJetBlockClu04->ZVertex(),myNvx_class12); // filling general histo for JetClu04
      if(fAnalysisMode==0) // tmp, introduced on 01/02/08
	{
	  FillMetCleanupHistograms(fCleanup,jet04stuff,allstuff,3); // histo for met cleanup studies
	  FillMetStudyHistograms(fMetStudyJet04sc3,jet04stuff,allstuff,3,myNvx_class12,dzvx_2best,dzvx_best2worse,_zvx); // met study histo for JetClu 0.4 and Et>15 GeV
	  MyMetEventCount(jet04stuff,allstuff,3,met_results); // counting number of data events with Met>cut
	  FillXsecStudyHistograms(fDiphoXsec,jet04stuff,allstuff);
	  FillPhoMetStudyHistograms(fPhoMetStudy,jet04stuff.myMETcorr_th15,allstuff,zvx_best);
	}      
      int exo_event=MyExoticEvent(jet04stuff,allstuff,3,GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber());
      int veryexo_event=MyVeryExoticEvent(jet04stuff,allstuff,3,GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber(),myNvx_class12,zvxvec);
      int met_event=MyLargeMetEvent(jet04stuff,allstuff,3,myNvx_class12,GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber());
//       MyDumpEvent(jet04stuff,allstuff,myNvx_class12,GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber());
      if(fSelectMetEvent==1 && met_event==0) 
	{
	  pass=false;
	  SetPassed(0);
	} 
      if(fSelectExoticEvent==1 && exo_event==0) 
	{
	  pass=false;
	  SetPassed(0);
	} 
      
      //_____ selecting events according to MetSignificance
      if(myMetSig>=fMetSig_cut) SigMetEvent_status=1; // new as of 12/09/07
      if(fSelectSigMetEvent==1 && SigMetEvent_status==0) 
	{
	  pass=false;
	  SetPassed(0); // selecting event with Significant Met
	}
      if(fSelectSigMetEvent==-1 && SigMetEvent_status==1) 
	{
	  pass=false;
	  SetPassed(0); // rejecting event with Significant Met
	}
    }   
  else SetPassed(0);
  if(pass==true) 
    {
      EventCount_a++;
      MyDumpEvent(jet04stuff,allstuff,myNvx_class12,GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber());
    }
  return 0;
}

//_____________________________________________________________________________
void TMyJetFilterModule::Display() {

  return;
}

//________ calls Sumw2 for final analysis histograms
void TMyJetFilterModule::FinalAnalysisHistoStep1(AnalysisHisto_t& Hist) {
  Hist.fAna_MetAll->Sumw2();
  Hist.fAna_MetSig->Sumw2();
  Hist.fAna_Met->Sumw2();
  Hist.fAna_M->Sumw2();
  Hist.fAna_dPhi->Sumw2();
  Hist.fAna_Njet15->Sumw2();
  Hist.fAna_Njet20->Sumw2();
  Hist.fAna_Njet25->Sumw2();
  Hist.fAna_Qt->Sumw2();
  Hist.fAna_Et1->Sumw2();
  Hist.fAna_Et2->Sumw2();
  Hist.fAna_Etjet->Sumw2();
  Hist.fAna_Ht->Sumw2();
  Hist.fAna_Mjj->Sumw2();
  Hist.fAna_Nem->Sumw2();
  Hist.fAna_Mej->Sumw2();
  Hist.fAna_Mextra->Sumw2();
  Hist.fAna_Etem->Sumw2();
  Hist.fAna_dPhi1->Sumw2();
  Hist.fAna_dPhi2->Sumw2();
  Hist.fAna_dPhi3->Sumw2();
  Hist.fAna_dPhi4->Sumw2();
  Hist.fAna_dPhi5->Sumw2();
  return;
}

//________ normalizes final background analysis histograms to Nevents
void TMyJetFilterModule::FinalAnalysisHistoStep2(AnalysisHisto_t& Hist) {
  
  TF1* h_norm=new TF1("f1","1.0",-1000.0,10000.0);
  Hist.fAna_MetAll->Divide(h_norm,1.0*Npoints);
  Hist.fAna_MetSig->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Met->Divide(h_norm,1.0*Npoints);
  Hist.fAna_M->Divide(h_norm,1.0*Npoints);
  Hist.fAna_dPhi->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Njet15->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Njet20->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Njet25->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Qt->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Et1->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Et2->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Etjet->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Ht->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Mjj->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Nem->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Mej->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Mextra->Divide(h_norm,1.0*Npoints);
  Hist.fAna_Etem->Divide(h_norm,1.0*Npoints);
  Hist.fAna_dPhi1->Divide(h_norm,1.0*Npoints);
  Hist.fAna_dPhi2->Divide(h_norm,1.0*Npoints);
  Hist.fAna_dPhi3->Divide(h_norm,1.0*Npoints);
  Hist.fAna_dPhi4->Divide(h_norm,1.0*Npoints);
  Hist.fAna_dPhi5->Divide(h_norm,1.0*Npoints);

  delete h_norm;
  return;
}
//________ multiplies final analysis histograms by event weight
void TMyJetFilterModule::FinalAnalysisHistoStep3(AnalysisHisto_t& Hist) {
  
  TF1* h_norm=new TF1("f1","1.0",-1000.0,10000.0);
  Hist.fAna_MetAll->Multiply(h_norm,fEventWeight);
  Hist.fAna_MetSig->Multiply(h_norm,fEventWeight);
  Hist.fAna_Met->Multiply(h_norm,fEventWeight);
  Hist.fAna_M->Multiply(h_norm,fEventWeight);
  Hist.fAna_dPhi->Multiply(h_norm,fEventWeight);
  Hist.fAna_Njet15->Multiply(h_norm,fEventWeight);
  Hist.fAna_Njet20->Multiply(h_norm,fEventWeight);
  Hist.fAna_Njet25->Multiply(h_norm,fEventWeight);
  Hist.fAna_Qt->Multiply(h_norm,fEventWeight);
  Hist.fAna_Et1->Multiply(h_norm,fEventWeight);
  Hist.fAna_Et2->Multiply(h_norm,fEventWeight);
  Hist.fAna_Etjet->Multiply(h_norm,fEventWeight);
  Hist.fAna_Ht->Multiply(h_norm,fEventWeight);
  Hist.fAna_Mjj->Multiply(h_norm,fEventWeight);
  Hist.fAna_Nem->Multiply(h_norm,fEventWeight);
  Hist.fAna_Mej->Multiply(h_norm,fEventWeight);
  Hist.fAna_Mextra->Multiply(h_norm,fEventWeight);
  Hist.fAna_Etem->Multiply(h_norm,fEventWeight);
  Hist.fAna_dPhi1->Multiply(h_norm,fEventWeight);
  Hist.fAna_dPhi2->Multiply(h_norm,fEventWeight);
  Hist.fAna_dPhi3->Multiply(h_norm,fEventWeight);
  Hist.fAna_dPhi4->Multiply(h_norm,fEventWeight);
  Hist.fAna_dPhi5->Multiply(h_norm,fEventWeight);

  delete h_norm;
  return;
}

int TMyJetFilterModule::EndJob() {

  if(fAnalysisMode==1)
    {
      int N_data=fAna_data.fAna_Met->GetEntries();
      double N_qcd=0.0;
      double N_qcd_stat=0.0;
      double N_qcd_syst=0.0;
      double dN_syst[10];
      if(Npoints>0)
	{
	  N_qcd=1.0*fAna_def.fAna_Met->GetEntries()/(1.0*Npoints);
	  N_qcd_stat=sqrt(1.0*fAna_def.fAna_Met->GetEntries())/(1.0*Npoints);
	  dN_syst[0]=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue1.fAna_Met->GetEntries()));

	  double d1;
	  double d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue2.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue3.fAna_Met->GetEntries()));
	  dN_syst[1]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue4.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue5.fAna_Met->GetEntries()));
	  dN_syst[2]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue6.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue7.fAna_Met->GetEntries()));
	  dN_syst[3]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue8.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_ue9.fAna_Met->GetEntries()));
	  dN_syst[4]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer1.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer2.fAna_Met->GetEntries()));
	  dN_syst[5]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer3.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer4.fAna_Met->GetEntries()));
	  dN_syst[6]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer5.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer6.fAna_Met->GetEntries()));
	  dN_syst[7]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer7.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer8.fAna_Met->GetEntries()));
	  dN_syst[8]= d1>d2 ? d1 : d2;
	  d1=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer9.fAna_Met->GetEntries()));
	  d2=fabs(1.0*(fAna_def.fAna_Met->GetEntries()-fAna_jer10.fAna_Met->GetEntries()));
	  dN_syst[9]= d1>d2 ? d1 : d2;
	  for(int i=0; i<10; i++)
	    {
	      N_qcd_syst=N_qcd_syst+dN_syst[i]*dN_syst[i];
	    }
	  N_qcd_syst=sqrt(N_qcd_syst)/(1.0*Npoints);
	}

      std::cout<<"----------  TMyJetFilterModule Analysis Summary  ------------------"<<std::endl;
      std::cout<<"..........Data observed "<<N_data<<std::endl;
      std::cout<<"....MetModel prediction "<<N_qcd<<"+-"<<N_qcd_stat<<"+-"<<N_qcd_syst<<std::endl;

      FinalAnalysisHistoStep1(fAna_bckg);
      DoFinalAnalysisHisto(fAna_bckg,fAna_ue1,fAna_def);
      DoFinalAnalysisHisto(fAna_bckg,fAna_ue2,fAna_ue3);
      DoFinalAnalysisHisto(fAna_bckg,fAna_ue4,fAna_ue5);
      DoFinalAnalysisHisto(fAna_bckg,fAna_ue6,fAna_ue7);
      DoFinalAnalysisHisto(fAna_bckg,fAna_ue8,fAna_ue9);
      DoFinalAnalysisHisto(fAna_bckg,fAna_jer1,fAna_jer2);
      DoFinalAnalysisHisto(fAna_bckg,fAna_jer3,fAna_jer4);
      DoFinalAnalysisHisto(fAna_bckg,fAna_jer5,fAna_jer6);
      DoFinalAnalysisHisto(fAna_bckg,fAna_jer7,fAna_jer8);
      DoFinalAnalysisHisto(fAna_bckg,fAna_jer9,fAna_jer10);
      FinalAnalysisHistoStep2(fAna_bckg);
      if(fUseEventWeight==1)
	{
	  FinalAnalysisHistoStep3(fAna_data);
	  FinalAnalysisHistoStep2(fAna_def);
	  FinalAnalysisHistoStep3(fAna_def);
	  FinalAnalysisHistoStep3(fAna_bckg);
	}
    }
  else
    {
      DoFinalPhoMetHisto(fPhoMetStudy);
      FinalMetSigCorrHisto(fMetStudyJet04sc3);      
    }
  MyMetResults(met_results);

  std::cout<<"----------  TMyJetFilterModule Summary  ------------------"<<std::endl;
  std::cout<<"..........Number of events before cuts "<<EventCount_b<<std::endl;
  std::cout<<"..........Number of events after cuts "<<EventCount_a<<std::endl;

  return 0;
}

double TMyJetFilterModule::GetCorrection(CorInit settings, TLorentzVector vec, 
					 float& emf, float etad) {
  int nrun = settings.Nrun; 
  int nVertex = settings.nvx; 
  int coneSize=settings.cone;  
  int version=settings.version;  
  int syscode=settings.sys; 
  int level=settings.level;
  int imode=settings.imode;

  JetEnergyCorrections myJetEnergyCorrections=
    JetEnergyCorrections("JetCorrections","JetCorrections",
			 level,nVertex,coneSize,version,syscode,nrun,imode); 

  HepLorentzVector P4Jet; 
  P4Jet.setPx(vec.Px()); 
  P4Jet.setPy(vec.Py()); 
  P4Jet.setPz(vec.Pz()); 
  P4Jet.setE(vec.E());
  if(abs(syscode)>0) 
    {
      int n_sigma= (syscode>0) ? 1 : -1 ;
      myJetEnergyCorrections.setTotalSysUncertainties(n_sigma);
    }
  double scaleFactor = myJetEnergyCorrections.doEnergyCorrections(P4Jet,emf,etad); 
  return scaleFactor; 
}

double TMyJetFilterModule::GetCorrection(TLorentzVector vec, float& emf, float etad) {

  int nrun = myJetRun; 
  int nVertex = myNvx_class12; 
  int coneSize=fJTC_coneSize;  
  int version=fJTC_version;  
  int syscode=fJTC_systcode; 
  int level=fJTC_level;
  int imode=fJTC_imode;

  JetEnergyCorrections myJetEnergyCorrections=
    JetEnergyCorrections("JetCorrections","JetCorrections",
			 level,nVertex,coneSize,version,syscode,nrun,imode); 

  HepLorentzVector P4Jet; 
  P4Jet.setPx(vec.Px()); 
  P4Jet.setPy(vec.Py()); 
  P4Jet.setPz(vec.Pz()); 
  P4Jet.setE(vec.E()); 
  if(abs(syscode)>0) 
    {
      int n_sigma= (syscode>0) ? 1 : -1 ;
      myJetEnergyCorrections.setTotalSysUncertainties(n_sigma);
    }
  double scaleFactor = myJetEnergyCorrections.doEnergyCorrections(P4Jet,emf,etad); 
  return scaleFactor; 
}

//_____________________________________________________________ Balance of two leading jets
// !!!!!!!!      OLD stuff, but I still need it  !!!!!!!!! 
double TMyJetFilterModule::GetBalance2(double pt1, double pt2, double phi1, double phi2) {
  double balX;
  double balY;
  double bal=9999.0;
  balX=pt1*TMath::Cos(phi1)+pt2*TMath::Cos(phi2);
  balY=pt1*TMath::Sin(phi1)+pt2*TMath::Sin(phi2);
  if(fabs(pt1+pt2)>0.0) bal=TMath::Sqrt(balX*balX+balY*balY)/(pt1+pt2);
  return bal;
}
double TMyJetFilterModule::GetBalance2(std::vector<TLorentzVector> vec){
  double bal=9999.0;
  if(vec.size()>=2)
    {
      double pt_1=vec[0].Pt();
      double pt_2=vec[1].Pt();
      double Phi_1=vec[0].Phi();
      double Phi_2=vec[1].Phi();
      bal=GetBalance2(pt_1,pt_2,Phi_1,Phi_2);
    }
  return bal;
}

//________________________________________________ Theta* or dijet scattering angle
//------------------- Input params are eta's or true rapidities
double TMyJetFilterModule::GetThetaStar(double y1, double y2) {
  double tcos;
  double y=(y1-y2)/2.0;
  double t=0.0;
  tcos=(TMath::Exp(y)-TMath::Exp(-y))/(TMath::Exp(y)+TMath::Exp(-y));
  if(fabs(tcos)<=1.0) t=TMath::ACos(tcos);
  return t;
}
double TMyJetFilterModule::GetThetaStar(std::vector<TLorentzVector> vec) {
  double t=0.0;
  if(vec.size()>=2)
    {
      double Y1=vec[0].Rapidity();
      double Y2=vec[1].Rapidity();
      t=GetThetaStar(Y1, Y2);
    }
  return t;
}


//__________________________________________________ returns Kt of two leading jets
double TMyJetFilterModule::GetMyKtKick(std::vector<TLorentzVector> vec) {
  double kt_kick=0.0;
  if(vec.size()>=2)
    {
      double pt_1=vec[0].Pt();
      double pt_2=vec[1].Pt();
      kt_kick=(pt_1+pt_2)*GetBalance2(vec);
    }  
  return kt_kick;
}
//__________________________________________________ returns Phi of two leading jets
double TMyJetFilterModule::GetMyPhiKt2L(std::vector<TLorentzVector> vec) {
  double phi_kick=-1.0E6;
  if(vec.size()>=2)
    {
      double pt=(vec[0]+vec[1]).Pt();
      if(pt>0.0) phi_kick=TVector2::Phi_0_2pi((vec[0]+vec[1]).Phi());
    }  
  return phi_kick;
}
//__________________________________________________ returns Phi of sumKt of all jets
double TMyJetFilterModule::GetMyPhiKtAll(std::vector<TLorentzVector> vec) {
  double phi_extra=-1.0E6;
  if(vec.size()>0)
    {
      TLorentzVector extra_jets(0.0,0.0,0.0,0.0);
      for(int i=0; i<vec.size(); i++)
	{ 
	  extra_jets=extra_jets+vec[i]; 
	}
      double pt=extra_jets.Pt();
      if(pt>0.0) phi_extra=TVector2::Phi_0_2pi(extra_jets.Phi());
    }  
  return phi_extra;
}

//__________________________________________________ returns 1 if jet is matched
//                                                   calculates dR, dPhi, dEta between pho & jet   
int TMyJetFilterModule::MyMatchPhoJet(int jet_ind, int pho_ind, int ele_ind,TStnJetBlock* fJetBlock,
				      TLorentzVector *mypho,TLorentzVector *myjet, 
				      double &dR_fj, double &dPhi_fj, double &dEta_fj)
{
  int match_code=0;

  if(jet_ind<0) return match_code;
  if(pho_ind<0 && ele_ind<0) return match_code;
  
  if(pho_ind>=0)
    {
      CalDataArray jet_towers;
      CalDataArray pho_towers;
      MatchCalorTowers(jet_ind,fJetBlock,fCalData,&jet_towers);
      MatchCalorTowers(pho_ind,fPhotonBlock,fCalData,&pho_towers);
      CalDataArrayI tt_em;
      CalDataArrayI tt_jet;
      for(tt_em = pho_towers.begin(); tt_em != pho_towers.end(); tt_em++)
	{
	  TCalTower* calt_em = *tt_em;
	  int iEta_em = calt_em->IEta();
	  int iPhi_em = calt_em->IPhi();
	  for(tt_jet = jet_towers.begin(); tt_jet != jet_towers.end(); tt_jet++)
	    {
	      TCalTower* calt_jet = *tt_jet;
	      int iEta_jet = calt_jet->IEta();
	      int iPhi_jet = calt_jet->IPhi();
	      if(iEta_em==iEta_jet && iPhi_em==iPhi_jet) match_code=1;
	      if(match_code==1) break;
	    } 
	  if(match_code==1) break; 
	}  
    }
  
  if(ele_ind>=0)
    {
      CalDataArray jet_towers;
      CalDataArray ele_towers;
      MatchCalorTowers(jet_ind,fJetBlock,fCalData,&jet_towers);
      MatchCalorTowers(ele_ind,fElectronBlock,fCalData,&ele_towers);
      CalDataArrayI tt_em;
      CalDataArrayI tt_jet;
      for(tt_em = ele_towers.begin(); tt_em != ele_towers.end(); tt_em++)
	{
	  TCalTower* calt_em = *tt_em;
	  int iEta_em = calt_em->IEta();
	  int iPhi_em = calt_em->IPhi();
	  for(tt_jet = jet_towers.begin(); tt_jet != jet_towers.end(); tt_jet++)
	    {
	      TCalTower* calt_jet = *tt_jet;
	      int iEta_jet = calt_jet->IEta();
	      int iPhi_jet = calt_jet->IPhi();
	      if(iEta_em==iEta_jet && iPhi_em==iPhi_jet) match_code=1;
	      if(match_code==1) break;
	    }
	  if(match_code==1) break;
	}  
    }
  
  TLorentzVector vec=*myjet;
  double dR=mypho->DeltaR(vec);
  dR_fj=dR;
  dPhi_fj=mypho->DeltaPhi(vec);
  dEta_fj=mypho->Eta()-myjet->Eta();
  return match_code;
}

void TMyJetFilterModule::ClearModuleOutput()       // clears the Module output from 		 
{                              // previous event.				        	 

  //-------- my new global output parameters 
  myMetSig=0.0;
  myMetSig_gen=0.0;
  myGenMetVec.Set(0.0,0.0);
  ClearJetStuff(jet04stuff); // clears JetClu-0.4 stuff 
  ClearCommonStuff(allstuff); // clears common stuff
  //----- end of my new output params 
  //.............................................................
  //  ClearMatchStuff(matchstuff);

  return;
}

void TMyJetFilterModule::ClearJetStuff(JetStuff &stuff) { // clears the JetStuff structures
  
  stuff.myMETcorr_th5.Set(-1.0E6,-1.0E6); 
  stuff.mySumEtCorr_th5=-1.0E6;
  stuff.mySumEtJet_th5=-1.0E6;
  stuff.myMETcorr_th10.Set(-1.0E6,-1.0E6);
  stuff.mySumEtCorr_th10=-1.0E6;
  stuff.mySumEtJet_th10=-1.0E6;
  stuff.myMETcorr_th15.Set(-1.0E6,-1.0E6);
  stuff.mySumEtCorr_th15=-1.0E6;
  stuff.mySumEtJet_th15=-1.0E6;
  stuff.myMETcorr_th20.Set(-1.0E6,-1.0E6);
  stuff.mySumEtCorr_th20=-1.0E6;
  stuff.mySumEtJet_th20=-1.0E6;
  stuff.myNjet=0; 
  stuff.myNjet_th5=0; 
  stuff.myNjet_th10=0;
  stuff.myNjet_th15=0;
  stuff.myNjet_th20=0;
  stuff.myNjet_th25=0;
  stuff.Jet_raw.clear();      
  stuff.Jet_lev1.clear();     
  stuff.Jet_lev4.clear();     
  stuff.Jet_lev5.clear();     
  stuff.Jet_lev6.clear();     
  stuff.Jet_lev7.clear();     
  stuff.Jet_raw_noEMobj.clear();      
  stuff.Jet_lev1_noEMobj.clear();     
  stuff.Jet_lev4_noEMobj.clear();     
  stuff.Jet_lev5_noEMobj.clear();     
  stuff.Jet_lev6_noEMobj.clear();     
  stuff.Jet_lev7_noEMobj.clear();
  stuff.newJetLev6.clear();     
  stuff.JetNtrk.clear();  
  stuff.JetNtwr.clear();  
  stuff.EtaDet.clear();   
  stuff.EtaDetCorr.clear();   
  stuff.EmFrRaw.clear();  
  stuff.EmFrCorr.clear(); 
  stuff.Nobj_match.clear(); 
  stuff.Npho_match.clear(); 
  stuff.Nele_match.clear(); 
  stuff.Nmu_match.clear(); 
  stuff.Ntau_match.clear(); 
  stuff.Nbtag_match.clear(); 
  stuff.JetBlockInd.clear();
  return; 		 
}
//_________________________ clears parameters which do not depend on Jet Cone size
void TMyJetFilterModule::ClearCommonStuff(CommonStuff &stuff) { // clears CommonStuff structures 
  stuff.myRawPhoton.clear();    
  stuff.myCorrPhoton.clear();
  stuff.myPhoInd.clear();
  stuff.myPhoEmFr.clear(); 
  stuff.myPhoEtaDet.clear();
  stuff.myPhoXces.clear();
  stuff.myPhoZces.clear();
  stuff.myRawElectron.clear();
  stuff.myEleInd.clear();
  stuff.myCorrElectron.clear(); 
  stuff.myEleEmFr.clear();      
  stuff.myEleEtaDet.clear();
  stuff.myElePhiDet.clear();
  stuff.myElePprEt.clear();
  stuff.myEleXces.clear();
  stuff.myEleZces.clear();
  stuff.myRawMuon.clear();      
  stuff.myCorrMuon.clear();     
  stuff.myRawTau.clear();       
  stuff.myCorrTau.clear();      
  stuff.myRawBjet.clear();      
  stuff.myCorrBjet.clear();     
  stuff.myMET_raw.Set(-1.0E6,-1.0E6); 
  stuff.myMET0_raw.Set(-1.0E6,-1.0E6); 
  stuff.mySumEt_raw=-1.0E6;
  stuff.newVertexZ=-1000.0;

  return;
}

void TMyJetFilterModule::ClearMatchStuff() {
  matchstuff.clear();
  return;
}
  

//__________________________________________________________ accessors to the
//__________________________________________________________ output params
//_________ need to specify which jets to return (variable "cone"): 0--cone 0.4; 1--cone 0.7; 2--cone 1.0

TLorentzVector* TMyJetFilterModule::GetMyJet_raw(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_raw.size()) return &_stuff.Jet_raw[i];
  else return NULL;
}
TLorentzVector* TMyJetFilterModule::GetMyJet_lev1(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev1.size()) return &_stuff.Jet_lev1[i];
  else return NULL;
} 
TLorentzVector* TMyJetFilterModule::GetMyJet_lev4(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev4.size()) return &_stuff.Jet_lev4[i];
  else return NULL;
} 
TLorentzVector* TMyJetFilterModule::GetMyJet_lev5(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev5.size()) return &_stuff.Jet_lev5[i];
  else return NULL;
} 
TLorentzVector* TMyJetFilterModule::GetMyJet_lev6(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev6.size()) return &_stuff.Jet_lev6[i];
  else return NULL;
} 
TLorentzVector* TMyJetFilterModule::GetMyJetNoEMobj_raw(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_raw_noEMobj.size()) return &_stuff.Jet_raw_noEMobj[i];
  else return NULL;
} 
TLorentzVector* TMyJetFilterModule::GetMyJetNoEMobj_lev1(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev1_noEMobj.size()) return &_stuff.Jet_lev1_noEMobj[i];
  else return NULL;
} 
TLorentzVector* TMyJetFilterModule::GetMyJetNoEMobj_lev4(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev4_noEMobj.size()) return &_stuff.Jet_lev4_noEMobj[i];
  else return NULL;
}  
TLorentzVector* TMyJetFilterModule::GetMyJetNoEMobj_lev5(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev5_noEMobj.size()) return &_stuff.Jet_lev5_noEMobj[i];
  else return NULL;
}  
TLorentzVector* TMyJetFilterModule::GetMyJetNoEMobj_lev6(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev6_noEMobj.size()) return &_stuff.Jet_lev6_noEMobj[i];
  else return NULL;
} 
double TMyJetFilterModule::GetMyJetEtaDet(int cone, int i) { // before removing EM object 
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EtaDet.size()) return _stuff.EtaDet[i];
  else return -1.0E6;
}
double TMyJetFilterModule::GetMyJetEtaDetCorr(int cone, int i) { // after removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EtaDetCorr.size()) return _stuff.EtaDetCorr[i];
  else return -1.0E6;
}
double TMyJetFilterModule::GetMyJetEmFrRaw(int cone, int i) {  // before removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EmFrRaw.size()) return _stuff.EmFrRaw[i];
  else return -1.0E6;
}
double TMyJetFilterModule::GetMyJetEmFrCorr(int cone, int i) { // before removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EmFrCorr.size()) return _stuff.EmFrCorr[i];
  else return -1.0E6;
}
int TMyJetFilterModule::GetMyJetNtrk(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.JetNtrk.size()) return _stuff.JetNtrk[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNtwr(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.JetNtwr.size()) return _stuff.JetNtwr[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNobjMatch(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nobj_match.size()) return _stuff.Nobj_match[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNphoMatch(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Npho_match.size()) return _stuff.Npho_match[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNeleMatch(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nele_match.size()) return _stuff.Nele_match[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNmuMatch(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nmu_match.size()) return _stuff.Nmu_match[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNtauMatch(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Ntau_match.size()) return _stuff.Ntau_match[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetNbtagMatch(int cone, int i) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nbtag_match.size()) return _stuff.Nbtag_match[i];
  else return -1;
}
int TMyJetFilterModule::GetMyJetBlockInd(int cone, int i) { // original jet index in JetBlock, need this after jet reordering
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.JetBlockInd.size()) return _stuff.JetBlockInd[i];
  else return -1;
}
int TMyJetFilterModule::GetMyNjet(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20, 5--et>25  
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) return _stuff.myNjet;
  if(threshold==1) return _stuff.myNjet_th5;
  if(threshold==2) return _stuff.myNjet_th10;
  if(threshold==3) return _stuff.myNjet_th15;
  if(threshold==4) return _stuff.myNjet_th20;
  if(threshold==5) return _stuff.myNjet_th25;
  if(threshold<0 || threshold>5) return -1;
}
double TMyJetFilterModule::GetMySumEtCorr(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20  
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) return allstuff.mySumEt_raw; // for consistency
  if(threshold==1) return _stuff.mySumEtCorr_th5;
  if(threshold==2) return _stuff.mySumEtCorr_th10;
  if(threshold==3) return _stuff.mySumEtCorr_th15;
  if(threshold==4) return _stuff.mySumEtCorr_th20;
  if(threshold<0 || threshold>4) return -1.0E6;
}
double TMyJetFilterModule::GetMyHtCorr(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20 
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  return MyHtAll(_stuff,allstuff,threshold); 
}
double TMyJetFilterModule::GetMyMetCorr(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20 
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) return allstuff.myMET_raw.Mod(); // for consistency
  if(threshold==1) return _stuff.myMETcorr_th5.Mod();
  if(threshold==2) return _stuff.myMETcorr_th10.Mod();
  if(threshold==3) return _stuff.myMETcorr_th15.Mod();
  if(threshold==4) return _stuff.myMETcorr_th20.Mod();
  if(threshold<0 || threshold>4) return -1.0E6;
}
double TMyJetFilterModule::GetMyMetXCorr(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) return allstuff.myMET_raw.Px(); // for consistency
  if(threshold==1) return _stuff.myMETcorr_th5.Px();
  if(threshold==2) return _stuff.myMETcorr_th10.Px();
  if(threshold==3) return _stuff.myMETcorr_th15.Px();
  if(threshold==4) return _stuff.myMETcorr_th20.Px();
  if(threshold<0 || threshold>4) return -1.0E6;
}
double TMyJetFilterModule::GetMyMetYCorr(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) return allstuff.myMET_raw.Py(); // for consistency
  if(threshold==1) return _stuff.myMETcorr_th5.Py();
  if(threshold==2) return _stuff.myMETcorr_th10.Py();
  if(threshold==3) return _stuff.myMETcorr_th15.Py();
  if(threshold==4) return _stuff.myMETcorr_th20.Py();
  if(threshold<0 || threshold>4) return -1.0E6;
}
double TMyJetFilterModule::GetMyMetPhiCorr(int cone, int threshold) {// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) return allstuff.myMET_raw.Phi(); // for consistency
  if(threshold==1) return _stuff.myMETcorr_th5.Phi();
  if(threshold==2) return _stuff.myMETcorr_th10.Phi();
  if(threshold==3) return _stuff.myMETcorr_th15.Phi();
  if(threshold==4) return _stuff.myMETcorr_th20.Phi();
  if(threshold<0 || threshold>4) return -1.0E6;
}

//______ returns number of photons
int TMyJetFilterModule::GetMyNpho() {
  return allstuff.myCorrPhoton.size();
}

//______ returns corrected photon after vertex swap
TLorentzVector* TMyJetFilterModule::GetMyCorrPhoton(int i) {
  if(i>=0 && i<allstuff.myCorrPhoton.size()) return &allstuff.myCorrPhoton[i];
  else return NULL;
}

//____ returns vertex position that minimizes MET in di-pho events
double TMyJetFilterModule::GetMyVertexZ() {
  return allstuff.newVertexZ;
}

//__________________________________________________________ setters of the
//__________________________________________________________ output params

//_________ need to specify which jets to return (variable "cone"): 0--cone 0.4; 1--cone 0.7; 2--cone 1.0
void TMyJetFilterModule::SetMyJet_raw(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_raw.size()) _stuff.Jet_raw[i]=vec;
  else _stuff.Jet_raw.push_back(vec);
  return;
}
void TMyJetFilterModule::SetMyJet_lev1(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev1.size()) _stuff.Jet_lev1[i]=vec;
  else _stuff.Jet_lev1.push_back(vec);
  return;
}
void TMyJetFilterModule::SetMyJet_lev4(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev4.size()) _stuff.Jet_lev4[i]=vec;
  else _stuff.Jet_lev4.push_back(vec);
  return;
} 
void TMyJetFilterModule::SetMyJet_lev5(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev5.size()) _stuff.Jet_lev5[i]=vec;
  else _stuff.Jet_lev5.push_back(vec);
  return;
} 
void TMyJetFilterModule::SetMyJet_lev6(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev6.size()) _stuff.Jet_lev6[i]=vec;
  else _stuff.Jet_lev6.push_back(vec);
  return;
} 
void TMyJetFilterModule::SetMyJetNoEMobj_raw(int cone, int i, TLorentzVector vec)  {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_raw_noEMobj.size()) _stuff.Jet_raw_noEMobj[i]=vec;
  else _stuff.Jet_raw_noEMobj.push_back(vec);
  return;
} 
void TMyJetFilterModule::SetMyJetNoEMobj_lev1(int cone, int i, TLorentzVector vec)  {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev1_noEMobj.size()) _stuff.Jet_lev1_noEMobj[i]=vec;
  else _stuff.Jet_lev1_noEMobj.push_back(vec);
  return;
}
void TMyJetFilterModule::SetMyJetNoEMobj_lev4(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev4_noEMobj.size()) _stuff.Jet_lev4_noEMobj[i]=vec;
  else _stuff.Jet_lev4_noEMobj.push_back(vec);
  return;
}  
void TMyJetFilterModule::SetMyJetNoEMobj_lev5(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev5_noEMobj.size()) _stuff.Jet_lev5_noEMobj[i]=vec;
  else _stuff.Jet_lev5_noEMobj.push_back(vec);
  return;
}  
void TMyJetFilterModule::SetMyJetNoEMobj_lev6(int cone, int i, TLorentzVector vec) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Jet_lev6_noEMobj.size()) _stuff.Jet_lev6_noEMobj[i]=vec;
  else _stuff.Jet_lev6_noEMobj.push_back(vec);
  return;
} 
void TMyJetFilterModule::SetMyJetEtaDet(int cone, int i, double param) { // before removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EtaDet.size()) _stuff.EtaDet[i]=param;
  else _stuff.EtaDet.push_back(param);
  return;
} 
void TMyJetFilterModule::SetMyJetEtaDetCorr(int cone, int i, double param) { // after removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EtaDetCorr.size()) _stuff.EtaDetCorr[i]=param;
  else _stuff.EtaDetCorr.push_back(param);
  return;
} 
void TMyJetFilterModule::SetMyJetEmFrRaw(int cone, int i, double param) { // before removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EmFrRaw.size()) _stuff.EmFrRaw[i]=param;
  else _stuff.EmFrRaw.push_back(param);
  return;
} 
void TMyJetFilterModule::SetMyJetEmFrCorr(int cone, int i, double param) { // before removing EM object
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.EmFrCorr.size()) _stuff.EmFrCorr[i]=param;
  else _stuff.EmFrCorr.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNtrk(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.JetNtrk.size()) _stuff.JetNtrk[i]=param;
  else _stuff.JetNtrk.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNtwr(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.JetNtwr.size()) _stuff.JetNtwr[i]=param;
  else _stuff.JetNtwr.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNobjMatch(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nobj_match.size()) _stuff.Nobj_match[i]=param;
  else _stuff.Nobj_match.push_back(param);
  return;
 }
void TMyJetFilterModule::SetMyJetNphoMatch(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Npho_match.size()) _stuff.Npho_match[i]=param;
  else _stuff.Npho_match.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNeleMatch(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nele_match.size()) _stuff.Nele_match[i]=param;
  else _stuff.Nele_match.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNmuMatch(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nmu_match.size()) _stuff.Nmu_match[i]=param;
  else _stuff.Nmu_match.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNtauMatch(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Ntau_match.size()) _stuff.Ntau_match[i]=param;
  else _stuff.Ntau_match.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetNbtagMatch(int cone, int i, int param) {
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.Nbtag_match.size()) _stuff.Nbtag_match[i]=param;
  else _stuff.Nbtag_match.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyJetBlockInd(int cone, int i, int param) { 
// original jet index in JetBlock, need this after jet reordering
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(i>=0 && i<_stuff.JetBlockInd.size()) _stuff.JetBlockInd[i]=param;
  else _stuff.JetBlockInd.push_back(param);
  return;
}
void TMyJetFilterModule::SetMyNjet(int cone, int threshold, int param) {
  // thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20, 5--et>25
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) _stuff.myNjet=param;
  if(threshold==1) _stuff.myNjet_th5=param;
  if(threshold==2) _stuff.myNjet_th10=param;
  if(threshold==3) _stuff.myNjet_th15=param;
  if(threshold==4) _stuff.myNjet_th20=param;
  if(threshold==5) _stuff.myNjet_th25=param;
  if(threshold<0 || threshold>5) return;
  return;
}
void TMyJetFilterModule::SetMySumEtCorr(int cone, int threshold, double param) {
// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) allstuff.mySumEt_raw=param; // for consistency
  if(threshold==1) _stuff.mySumEtCorr_th5=param;
  if(threshold==2) _stuff.mySumEtCorr_th10=param;
  if(threshold==3) _stuff.mySumEtCorr_th15=param;
  if(threshold==4) _stuff.mySumEtCorr_th20=param;
  if(threshold<0 || threshold>4) return;
  return;
}
void TMyJetFilterModule::SetMyMetCorr(int cone, int threshold, double px, double py) { 
// thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) allstuff.myMET_raw.Set(px,py); // for consistency
  if(threshold==1) _stuff.myMETcorr_th5.Set(px,py);
  if(threshold==2) _stuff.myMETcorr_th10.Set(px,py);
  if(threshold==3) _stuff.myMETcorr_th15.Set(px,py);
  if(threshold==4) _stuff.myMETcorr_th20.Set(px,py);
  if(threshold<0 || threshold>4) return;
  return;
}
void TMyJetFilterModule::SetMyMetCorr(int cone, int threshold, const TVector2& vec) {
 // thresholdcode= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
  JetStuff _stuff;
  if(cone==0) _stuff=jet04stuff;
  if(threshold==0) allstuff.myMET_raw.Set(vec); // for consistency
  if(threshold==1) _stuff.myMETcorr_th5.Set(vec);
  if(threshold==2) _stuff.myMETcorr_th10.Set(vec);
  if(threshold==3) _stuff.myMETcorr_th15.Set(vec);
  if(threshold==4) _stuff.myMETcorr_th20.Set(vec);
  if(threshold<0 || threshold>4) return;
  return;
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//   My Cuts are defined here
//___________________________________________________________________
int TMyJetFilterModule::MyNjetCut(JetStuff jetstuff) {
  if(jetstuff.myNjet<MinNjet || jetstuff.myNjet>MaxNjet) return 0;
  if(jetstuff.myNjet_th5<MinNjet5 || jetstuff.myNjet_th5>MaxNjet5) return 0;
  if(jetstuff.myNjet_th10<MinNjet10 || jetstuff.myNjet_th10>MaxNjet10) return 0;
  if(jetstuff.myNjet_th15<MinNjet15 || jetstuff.myNjet_th15>MaxNjet15) return 0;
  if(jetstuff.myNjet_th20<MinNjet20 || jetstuff.myNjet_th20>MaxNjet20) return 0;
  if(jetstuff.myNjet_th25<MinNjet25 || jetstuff.myNjet_th25>MaxNjet25) return 0;
  return 1;
}

//--------------------------------------------------------------------------
int TMyJetFilterModule::MyGenericCut(JetStuff jetstuff, double dz) {
  //__________________ cut on dZ=Zvx-Zjet
  if(fabs(dz)<MindZ || fabs(dz)>MaxdZ) return 0;
  //__________________ cut on 1st jet Et
  if(jetstuff.myNjet>0) 
    if(fabs(jetstuff.Jet_lev6_noEMobj[0].Eta())>MinJetEta && 
       fabs(jetstuff.Jet_lev6_noEMobj[0].Eta())<MaxJetEta &&
       (jetstuff.Jet_lev6_noEMobj[0].Pt()<MinEt1st || jetstuff.Jet_lev6_noEMobj[0].Pt()>MaxEt1st)) return 0;
  //__________________ cut on 2nd jet Et
  if(jetstuff.myNjet>1) 
    if(fabs(jetstuff.Jet_lev6_noEMobj[1].Eta())>MinJetEta && 
       fabs(jetstuff.Jet_lev6_noEMobj[1].Eta())<MaxJetEta &&
       (jetstuff.Jet_lev6_noEMobj[1].Pt()<MinEt2nd || jetstuff.Jet_lev6_noEMobj[1].Pt()>MaxEt2nd)) return 0;
  return 1;
}

//--------------------------------------------------------------------------
int TMyJetFilterModule::MyAngularCut(JetStuff jetstuff, CommonStuff miscstuff) {
  double dPhiMin=100.0;
  double dEtaMin=100.0;
  double dRMin=100.0;
  for(int i=0; i<jetstuff.myNjet; i++)
    {
      if(fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())>MinJetEta && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<MaxJetEta &&
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())>MinEtThr && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())<MaxEtThr)
	{
 	  // looping over all photons
 	  for(int j=0; j<miscstuff.myCorrPhoton.size(); j++)
	    {
	      double dPhi=fabs(TVector2::Phi_mpi_pi(jetstuff.Jet_lev6_noEMobj[i].Phi()-miscstuff.myCorrPhoton[j].Phi()));
	      double dEta=fabs(jetstuff.Jet_lev6_noEMobj[i].Eta()-miscstuff.myCorrPhoton[j].Eta());
	      double dR=sqrt(dPhi*dPhi+dEta*dEta);
	      if(dPhi<dPhiMin) dPhiMin=dPhi;
	      if(dEta<dEtaMin) dEtaMin=dEta;
	      if(dR<dRMin) dRMin=dR;
	      if(dPhi<MinDeltaPhigj || dPhi>MaxDeltaPhigj) return 0;
	      if(dEta<MinDeltaEtagj || dEta>MaxDeltaEtagj) return 0;
	      if(dR<MinDeltaRgj || dR>MaxDeltaRgj) return 0;
	    }
	} 
    }
  if(dPhiMin<MinDeltaPhigjMin || dPhiMin>MaxDeltaPhigjMin) return 0;
  if(dEtaMin<MinDeltaEtagjMin || dEtaMin>MaxDeltaEtagjMin) return 0;
  if(dRMin<MinDeltaRgjMin || dRMin>MaxDeltaRgjMin) return 0;
  return 1;
}
 
//--------------------------------------------------------------------------
int TMyJetFilterModule::MyDuplicateCut(CommonStuff miscstuff) {
  
  double dRMin=0.2;
  int passcode=0;
  if(fRemoveDuplicate!=0)
    {
      if(bad_EMjet_match_flag==0) return 1;
      for(int j=0; j<miscstuff.myCorrPhoton.size(); j++)
 	{
 	  for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
 	    {
 	      if(fabs(miscstuff.myEleEtaDet[i])<1.2)
 		{
 		  double dPhi=fabs(TVector2::Phi_mpi_pi(miscstuff.myElePhiDet[i]-miscstuff.myCorrPhoton[j].Phi()));
 		  double dEta=fabs(miscstuff.myEleEtaDet[i]-miscstuff.myPhoEtaDet[j]);
 		  double dR=sqrt(dPhi*dPhi+dEta*dEta);
 		  if(dR<dRMin) return 1;
 		}
 	    }
 	}
    }
  return passcode;
}
 

//--------------------------------------------------------------------------
int TMyJetFilterModule::MyMassCut(JetStuff jetstuff, CommonStuff miscstuff) {
  double Mj1g1=0.0;
  double Mj1g2=0.0;
  double Mj2g1=0.0;
  double Mj2g2=0.0;
  double Mjj=0.0;
  int jetid=-1;
  int ind1=-1;
  int ind2=-1;
  for(int i=0; i<jetstuff.myNjet; i++)
    {
      if(fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())>MinJetEta && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<MaxJetEta &&
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())>MinEtThr && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())<MaxEtThr)
	{
	  jetid++;
	  if(jetid==0) ind1=i;
	  if(jetid==1) ind2=i;
	  // assuming that there are at least two photons
	  for(int j=0; j<2; j++)
	    {
	      double M=(jetstuff.Jet_lev6_noEMobj[i]+miscstuff.myCorrPhoton[j]).M();
	      if(jetid==0 && j==0) Mj1g1=M;
	      if(jetid==0 && j==1) Mj1g2=M;
	      if(jetid==1 && j==0) Mj2g1=M;
	      if(jetid==1 && j==1) Mj2g2=M;
	      if(M<MinMjg || M>MaxMjg) return 0;
	    }
	} 
    }
  if(jetid>-1)
    {
      if(Mj1g1<MinMj1g1 || Mj1g1>MaxMj1g1) return 0;
      if(Mj1g2<MinMj1g2 || Mj1g2>MaxMj1g2) return 0;
      if(jetid>0) 
	{
	  Mjj=(jetstuff.Jet_lev6_noEMobj[ind1]+jetstuff.Jet_lev6_noEMobj[ind2]).M();
	  if(Mj2g1<MinMj2g1 || Mj2g1>MaxMj2g1) return 0;
	  if(Mj2g2<MinMj2g2 || Mj2g2>MaxMj2g2) return 0;
	  if(Mjj<MinMjj || Mjj>MaxMjj) return 0;
	}
    }
  return 1;
}

//--------------------------------------------------------------------------
// Specific GMSB cuts
int TMyJetFilterModule::MyGMSBevent(double dPhi0, double dPhi2, double Et_pho1, double Ht, double _metsig, int njet) {
  int pass_code=1;
  int ind=-1;
  if(njet==0) ind=0;
  if(njet==1) ind=1;
  if(njet>1) ind=2;
  if(ind>-1)
    {
      if(Et_pho1<GMSBcut_Et1pho[ind]) return 0;
      if(Ht<GMSBcut_Ht[ind]) return 0;
      if(_metsig<GMSBcut_metsig[ind]) return 0;
      if(dPhi0>GMSBcut_dPhi0[ind]) return 0;
      if(dPhi2<GMSBcut_dPhi2[ind]) return 0;
    }
  return pass_code;
}


//--------------------------------------------------------------------------
int TMyJetFilterModule::MyAnalysisCut(JetStuff jetstuff, CommonStuff miscstuff, int metcode) {
  //--- temporarely commented out
//   if(MyQtJet(jetstuff)<MinQtJet || MyQtJet(jetstuff)>MaxQtJet) return 0;
//   if(MyHtAll(jetstuff,miscstuff,metcode)<MinHt || MyHtAll(jetstuff,miscstuff,metcode)>MaxHt) return 0;
  return 1;
}

//----- Test version as of 04/04/07
//--------------------------------------------------------------------------
// ATTN!!! corrected jet & met are used in this cut
//
// This version of cuts can be used for generated MET in MetModel studies.
//
int TMyJetFilterModule::MyMetCleanUpCut(JetStuff jetstuff, CommonStuff miscstuff, std::vector<TLorentzVector> jetvec, TVector2 metvec) {
  int Nbadmetjet=0;
  if(abs(fRemoveBadMet)>0) // new as of 12/14/07
    {
      double MetEM_dPhi_max=0.4;
      double MetPho_dPhi_max=0.3;
      double emXces_max_pho=18.5;
      double emXces_max_ele=13.0;
      for(int i=0; i<miscstuff.myCorrPhoton.size(); i++) // don't look at 1st photon for twr-9 effect
	{
	  double dPhi=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(miscstuff.myCorrPhoton[i].Phi())-TVector2::Phi_0_2pi(metvec.Phi())));
	  if(miscstuff.myCorrPhoton.size()>1)
	    {
	      if(i>0 && (fabs(miscstuff.myPhoEtaDet[i])>1.0 || fabs(miscstuff.myPhoEtaDet[i])<0.1) && dPhi<MetPho_dPhi_max) Nbadmetjet++;
	      if(i>0 && fabs(miscstuff.myPhoXces[i])>emXces_max_pho && dPhi<MetEM_dPhi_max) Nbadmetjet++;
	    }
	  else
	    {
	      if(fabs((miscstuff.myPhoEtaDet[i])>1.0 || fabs(miscstuff.myPhoEtaDet[i])<0.1) && dPhi<MetPho_dPhi_max) Nbadmetjet++;
	      if(fabs(miscstuff.myPhoXces[i])>emXces_max_pho && dPhi<MetEM_dPhi_max) Nbadmetjet++;
	    }
	}      
      for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
	{
	  double dPhi1=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(miscstuff.myCorrElectron[i].Phi())-TVector2::Phi_0_2pi(metvec.Phi())));
	  double dPhi2=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(miscstuff.myElePhiDet[i])-TVector2::Phi_0_2pi(metvec.Phi())));
	  double dPhi=(dPhi1<dPhi2) ? dPhi1 : dPhi2;
	  if(miscstuff.myCorrElectron.size()>1)
	    {
	      if(i>0 && fabs(miscstuff.myEleXces[i])>emXces_max_ele && dPhi<MetEM_dPhi_max) Nbadmetjet++;
	      if(i>0 && fabs(fabs(miscstuff.myEleEtaDet[i])-1.05)<0.05 && dPhi<MetEM_dPhi_max) Nbadmetjet++; // new as of 06/25/08
	    }
	  else
	    {
	      if(fabs(miscstuff.myEleXces[i])>emXces_max_ele && dPhi<MetEM_dPhi_max) Nbadmetjet++;
	      if(fabs(fabs(miscstuff.myEleEtaDet[i])-1.05)<0.05 && dPhi<MetEM_dPhi_max) Nbadmetjet++; // new as of 06/25/08	      
	    }
	}      

      //---------------------- This part was added on 07/03/08, to remove events where a photon got lost in CEM cracks  
      double jet_minPt=5.0;
      double jet_maxEta=1.3;
      double jet_maxEmFr1=0.875;
      double jet_maxEmFr2=0.3;
      double MetJet_dPhi_max=0.3;
      int jet_NtwrMax=10;
      int jet_NtrkMax=5;

      double dPhi_min=TMath::Pi();
      double eta_det=10.0;
      double emfr=0.5;
      int ntwr=100;
      int ntrk=100;
      for(int i=0; i<jetstuff.Jet_lev6_noEMobj.size(); i++)
	{
	  if(jetstuff.Jet_lev6_noEMobj[i].Pt()>jet_minPt && 
	     fabs(jetstuff.EtaDet[i])<1.3 && 
	     jetstuff.Nobj_match[i]==0)
	    {
	      double dPhi=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(jetstuff.Jet_lev6_noEMobj[i].Phi())-TVector2::Phi_0_2pi(metvec.Phi())));
	      if(dPhi<dPhi_min) 
		{
		  dPhi_min=dPhi;
		  eta_det=jetstuff.EtaDet[i];
		  emfr=jetstuff.EmFrRaw[i];
		  ntwr=jetstuff.JetNtwr[i];
		  ntrk=jetstuff.JetNtrk[i];
		}
	    }
	}
      if(dPhi_min<MetJet_dPhi_max && emfr>jet_maxEmFr1 && ntwr<jet_NtwrMax && ntrk<jet_NtrkMax && fabs(eta_det)<1.1) Nbadmetjet++;
      if(dPhi_min<MetJet_dPhi_max && emfr<jet_maxEmFr2 && ntwr<jet_NtwrMax && ntrk<jet_NtrkMax 
	 && (fabs(eta_det)<0.1 || (fabs(eta_det)>1.1 && fabs(eta_det)<1.2))) Nbadmetjet++;
    }
  return Nbadmetjet;
}


//________________________________ returns Qt of all jets above Eta & Et thresholds
double TMyJetFilterModule::MyQtJet(JetStuff jetstuff) {
  double qt=-1.0E6;
  TLorentzVector vec(0.0,0.0,0.0,0.0);
  for(int i=0; i<jetstuff.myNjet; i++)
    {
      if(fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())>MinJetEta && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<MaxJetEta &&
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())>MinEtThr && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())<MaxEtThr)
	{
	  vec=vec+jetstuff.Jet_lev6_noEMobj[i];
	}
    }  
  if(vec.E()>0.0) qt=vec.Pt();
  return qt;
}
//________________________________ returns SumEt=jets+photons+leptons+taus+met (jets above Eta & Et thresholds)
//                                 metscenario= 0--raw, 1--et>5, 2--et>10, 3--et>15, 4--et>20
double TMyJetFilterModule::MyHtAll(JetStuff jetstuff, CommonStuff miscstuff, int metscenario) {
  double ht=0.0;
  //_________________ contribution from jets
  for(int i=0; i<jetstuff.myNjet; i++)
    {
      if(fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())>MinJetEta && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Eta())<MaxJetEta &&
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())>MinEtThr && 
	 fabs(jetstuff.Jet_lev6_noEMobj[i].Pt())<MaxEtThr) ht=ht+jetstuff.Jet_lev6_noEMobj[i].Pt();
    }  
  //_________________ contribution from photons
  for(int i=0; i<miscstuff.myCorrPhoton.size(); i++)
    {
      ht=ht+miscstuff.myCorrPhoton[i].Pt();
    }
  //_________________ contribution from electrons
  for(int i=0; i<miscstuff.myCorrElectron.size(); i++)
    {
      ht=ht+miscstuff.myCorrElectron[i].Pt();
    }
  //_________________ contribution from muons
  for(int i=0; i<miscstuff.myCorrMuon.size(); i++)
    {
      ht=ht+miscstuff.myCorrMuon[i].Pt();
    }
  //_________________ contribution from taus
  for(int i=0; i<miscstuff.myCorrTau.size(); i++)
    {
      ht=ht+miscstuff.myCorrTau[i].Pt();
    }
  //_________________ contribution from MET
  if(metscenario==0) ht=ht+miscstuff.myMET_raw.Mod();
  if(metscenario==1) ht=ht+jetstuff.myMETcorr_th5.Mod();
  if(metscenario==2) ht=ht+jetstuff.myMETcorr_th10.Mod();
  if(metscenario==3) ht=ht+jetstuff.myMETcorr_th15.Mod();
  if(metscenario==4) ht=ht+jetstuff.myMETcorr_th20.Mod();
  if(metscenario<0 || metscenario>4) ht=ht+miscstuff.myMET_raw.Mod();
  return ht;
}

