#ifndef TMYEVNT_HH
#define TMYEVNT_HH

#if !defined (__CINT__) || defined (__MAKECINT__)

#include "TH1.h"
#include "TH2.h"
#include "TProfile.h"
#include <vector>

#include <Stntuple/loop/TStnModule.hh>
#include "Stntuple/obj/TStnDBManager.hh"
#include "Stntuple/obj/TStnTriggerTable.hh"
//------declaration of blocks to be read
#include <Stntuple/obj/TCalDataBlock.hh>
#include <Stntuple/obj/TStnPhotonBlock.hh>
#include <Stntuple/obj/TStnHeaderBlock.hh>
#include <Stntuple/obj/TStnTriggerBlock.hh>
#include <Stntuple/obj/TStnVertexBlock.hh>
#include <Stntuple/obj/TStnJetBlock.hh>
#include <Stntuple/obj/TStnMetBlock.hh>
#include <Stntuple/obj/TStnCosmicBlock.hh>
#include <CalorGeometry/CalConstants.hh>
#include "TGoodRun.hh"

#endif


class TMyEventFilterModule: public TStnModule {
public:

  struct Hist_t {
                      //---- before cuts
    TH1F*  fEvntSumEt_b;
    TH1F*  fEvntMEt_b;
    TH1F*  fEvntMEtSig_b;    
    TH1F*  fEvntLum_b;
    TH1F*  fEvntNvx_b;
    TH1F*  fEvntNEmObj_b;
    TH1F*  fEvntNTowers_b;    // Number of Calorimeter towers 
    TH1F*  fEvntNTowersOot_b; // Number of Out-Of-Time towers
    TH1F*  fEvntNJet_b;
    TH1F*  fEvntNMuon_b;
    TH1F*  fEvntNTrack_b;
                      //---- after cuts 
    TH1F*  fEvntSumEt_a;
    TH1F*  fEvntMEt_a;
    TH1F*  fEvntMEtSig_a;    
    TH1F*  fEvntLum_a;
    TH1F*  fEvntNvx_a;
    TH1F*  fEvntNEmObj_a;
    TH1F*  fEvntNTowers_a;
    TH1F*  fEvntNTowersOot_a;
    TH1F*  fEvntNJet_a;
    TH1F*  fEvntNMuon_a;
    TH1F*  fEvntNTrack_a;
  };

  struct MetHist_t {
    // definitions of Met: [0]--using z=0; [1]--lepton zvx or 1st vertex from ZVertex;
    // [2]--highest Pt zvx(?) and corrected for tracks; [3]--highest Pt zvx;
    // [4]--highest Pt zvx and (x,y) beam off-set

    // definition of SumEt: [0]--using z=0; [1]--lepton zvx or 1st vertex from ZVertex;
    // [2]--highest Pt zvx.
 
    //++++++++++++++++++++++++++++ before cuts
    TH1F*  fEvntMet_b[5]; // missing Et according to various methods
    TH1F*  fEvntMetPhi_b[5]; // Phi of missing Et according to various methods
    TH1F*  fEvntMetX_b[5]; // X-projection of MEt
    TH1F*  fEvntMetY_b[5]; // Y-projection of MEt
    TH1F*  fEvntSumEt_b[3]; // sum Et according to various methods
    
    //    TProfile* fEvntMetVsZvx_b[5]; // comment: this is not filled here 
    TProfile* fEvntMetVsNvx_b[5]; // MEt vs Nvx
    TProfile* fEvntMetVsLum_b[5]; // MEt vs Lum
    TProfile* fEvntMetVsSumEt_b[5]; // MEt vs SumEt [0],[1] or [2] (depending on the case)
    TProfile* fEvntMetVsPhi_b[5];  // MEt vs MetPhi
    TProfile* fEvntMetXVsMetY_b[5];  // MEt_X vs Met_Y

    TProfile* fEvntMet4VsRun_b; // Met4 vs. Run number for events with Nvx12=1 
    TProfile* fEvntMet4XVsRun_b; // Met4_X vs. Run number for events with Nvx12=1 
    TProfile* fEvntMet4YVsRun_b; // Met4_Y vs. Run number for events with Nvx12=1 
    TProfile* fEvntSumet2VsRun_b; // Sumet2 vs. Run number for event with Nvx12=1

    TProfile* fEvntMet4_2VsRun_b; // Met4^2 vs. Run number for events with Nvx12=1 (will use to obtain resolution)
    TProfile* fEvntMet4X_2VsRun_b; // Met4_X^2 vs. Run number for events with Nvx12=1 
    TProfile* fEvntMet4Y_2VsRun_b; // Met4_Y^2 vs. Run number for events with Nvx12=1 
    TProfile* fEvntSumet2_2VsRun_b; // Sumet2^2 vs. Run number for event with Nvx12=1

    TProfile* fEvntMet4VsNmu_b; // Met4 vs. number of muons 
    TProfile* fEvntMet4nvx1VsLum_b; // Met4 vs. Lum for events with Nvx12=1 

    TProfile* fEvntMet3VsRun_b; // Met3 vs. Run number for events with Nvx12=1 
    TProfile* fEvntMet3XVsRun_b; // Met3_X vs. Run number for events with Nvx12=1 
    TProfile* fEvntMet3YVsRun_b; // Met3_Y vs. Run number for events with Nvx12=1 


    //++++++++++++++++++++++++++++ after cuts
    TH1F*  fEvntMet_a[5];
    TH1F*  fEvntMetPhi_a[5];
    TH1F*  fEvntMetX_a[5];
    TH1F*  fEvntMetY_a[5];
    TH1F*  fEvntSumEt_a[3];
    
    //    TProfile* fEvntMetVsZvx_a[5]; // comment: this is not filled here 
    TProfile* fEvntMetVsNvx_a[5];
    TProfile* fEvntMetVsLum_a[5];
    TProfile* fEvntMetVsSumEt_a[5];
    TProfile* fEvntMetVsPhi_a[5]; 
    TProfile* fEvntMetXVsMetY_a[5];

    TProfile* fEvntMet4VsRun_a;
    TProfile* fEvntMet4XVsRun_a;
    TProfile* fEvntMet4YVsRun_a;
    TProfile* fEvntSumet2VsRun_a;

    TProfile* fEvntMet4_2VsRun_a; 
    TProfile* fEvntMet4X_2VsRun_a;
    TProfile* fEvntMet4Y_2VsRun_a;
    TProfile* fEvntSumet2_2VsRun_a;

    TProfile* fEvntMet4VsNmu_a;
    TProfile* fEvntMet4nvx1VsLum_a;

    TProfile* fEvntMet3VsRun_a; 
    TProfile* fEvntMet3XVsRun_a; 
    TProfile* fEvntMet3YVsRun_a; 

  };

  struct CalHist_t {
    TH1F*  fCalNspike;  // total number of pmt spikes per event
    TH1F*  fCalEspike;  // spike's total  Energy;
    TH1F*  fCalHadEspike;  // spike's HAD  Energy;
    TH1F*  fCalEmEspike;   // spike's EM  Energy;
    TH1F*  fCalHadTDCspike; // timing of HAD spikes;

    TH2F*  fCalEMtwr;  // spike tower map for EM 
    TH2F*  fCalCHAtwr;  // spike tower map for CHA 
    TH2F*  fCalWHAtwr;  // spike tower map for WHA 

    TH1F*  fCalPmtEmAssm_bad;  // pmt assymetry for bad EM towers
    TH1F*  fCalPmtHadAssm_bad;  // pmt assymetry for bad HAD towers
    TProfile* fCalPmtAssmVsRun[19]; // pmt assymetry vs. Run num ber for bad towers
    TH1F*  fCalBad_dPhi[19]; // dPhi=Phi(met)-Phi(bad tower) if |asymmetry|>0.55
    TH1F*  fCalBad_MetRatio[19]; // MET/Et(bad tower) if |asymmetry|>0.55

    TH1F*  fCalEm_dPhi; // dPhi=Phi(met)-Phi(em spike) if EmEnergy>10
    TH1F*  fCalEm_MetRatio; // MET/Et(em spike) if EmEnergy>10 
    TH1F*  fCalHad_dPhi; // dPhi=Phi(met)-Phi(had spike) if HadEnergy>10
    TH1F*  fCalHad_MetRatio; // MET/Et(had spike) if HadEnergy>10 

    TH1F*  fCalPmtEmAssm_le10;  // pmt assymetry for towers with EmEnergy<10
    TH1F*  fCalPmtHadAssm_le10; // pmt assymetry for towers with HadEnergy<10
    TH1F*  fCalPmtEmAssm_ge10;  // pmt assymetry for towers with EmEnergy>10
    TH1F*  fCalPmtHadAssm_ge10; // pmt assymetry for towers with HadEnergy>10

    TH1F*  fCalPmtCemAssm_le10;  //CEM pmt assymetry for towers with EmEnergy<10
    TH1F*  fCalPmtChaAssm_le10; // CHA pmt assymetry for towers with HadEnergy<10, outside overlap
    TH1F*  fCalPmtWhaAssm_le10; // WHA pmt assymetry for towers with HadEnergy<10, outside overlap
    TH1F*  fCalPmtCemAssm_ge10;  // CEM pmt assymetry for towers with EmEnergy>10
    TH1F*  fCalPmtChaAssm_ge10; // CHA pmt assymetry for towers with HadEnergy>10, outside overlap
    TH1F*  fCalPmtWhaAssm_ge10; // WHA pmt assymetry for towers with HadEnergy>10, outside overlap

    TH1F*  fCalPmtChaAssm_overlap_le10; // CHA pmt assymetry for towers with HadEnergy<10, inside overlap
    TH1F*  fCalPmtWhaAssm_overlap_le10; // WHA pmt assymetry for towers with HadEnergy<10, inside overlap
    TH1F*  fCalPmtChaAssm_overlap_ge10; // CHA pmt assymetry for towers with HadEnergy>10, inside overlap
    TH1F*  fCalPmtWhaAssm_overlap_ge10; // WHA pmt assymetry for towers with HadEnergy>10, inside overlap

    TH1F*  fCalPmtHadAssm_ge10_intime;  // pmt assymetry for towers with HadEnergy>10 and |HadTdc|<40.0 ns
    TH1F*  fCalPmtHadAssm_ge10_outtime; // pmt assymetry for towers with HadEnergy>10 and |HadTdc|>40.0 ns
    TH2F*  fCalEmPmtAssm_vs_PmtSum; // (pmt1-pmt2)/(pmt1+pmt2) for em energy
    TH2F*  fCalHadPmtAssm_vs_PmtSum; // (pmt1-pmt2)/(pmt1+pmt2) for had energy

    TH1F*  fTest_dPhiSpikeMet; // dPhi=Phi(EM spike)-Phi(Met)
    TH1F*  fTest_SpikeMetRatio;// Met/Et(spike)
    TH1F*  fTest_Ntwr;         // number of towers in EM object with spike
    TH1F*  fTest_HadEm;        // Had/Em for EM object with spike
    TH1F*  fTest_EwireEspike;  // E(ces wire)/E(spike)
    TH1F*  fTest_EstripEspike; // E(ces strip)/E(spike)
    TH1F*  fTest_Chi2;         // Chi2 of EM object with spike
  };

  struct BadTower {
    int phiI;
    int etaI;
    int histoI;
    int run1;
    int run2;
  };
//-----------------------------------------------------------------------------
// Jet20=0;
// Jet50=1;
// Jet70=2;
// Jet100=3;
// Jet05(ST5)=4;
// Jet10(ST10)=5;
// MinBias=6;
// All=1000; 
//-----------------------------------------------------------------------------

  enum { Jet20=0, Jet50=1, Jet70=2, Jet100=3, Jet05=4, Jet10=5, MinBias=6, All=1000};


protected:
					// pointers to the data blocks used,
					// header block is always available via
                                        // TStnModule::GetHeaderBlock()
  TStnDBManager* dbm;
  TStnTriggerTable* tt;

  TGoodRun* goodrun; // declaring Ray's GoodRun  

  TCalDataBlock*     fCalData;					
  TStnVertexBlock*   fZVertexBlock;
  TStnJetBlock*      fJetBlockClu04;
  TStnJetBlock*      fJetBlockClu07;
  TStnJetBlock*      fJetBlockClu10;
  TStnJetBlock*      fJetBlockMid04;
  TStnJetBlock*      fJetBlockMid07;
  TStnJetBlock*      fJetBlockMid10;
//   TStnJetBlock*      fJetBlockKt04;
//   TStnJetBlock*      fJetBlockKt07;
//   TStnJetBlock*      fJetBlockKt10;
  TStnPhotonBlock* fPhotonBlock;
  TStnMetBlock*      fMetBlock;
  TStnTriggerBlock*  fTriggerBlock;

  typedef std::vector<TCalTower*> CalDataArray; // need for beam halo
  typedef std::vector<TCalTower*>::iterator CalDataArrayI; // need for beam halo

					// histograms filled
  Hist_t    fHist;
  MetHist_t fMetHist;
  CalHist_t fCalHist;
  CalHist_t fCalHist_EMobj;   // spike studies for EM objects
  CalHist_t fCalHist_goodjet; // spike studies for "good" jets
  CalHist_t fCalHist_badjet;  // spike studies for "bad" jets


					// cuts
  bool passGlobal;

  int fUseVerbose;   // status code to invoke Debugging mode (print out)
  int fDataType;     // status code for data to be used: data=0, MC=1
  int fUseFindSpike; // status code for PMT spike studies
  int fUseSpikeFilter; // status code for PMT spike filter
  int fJetType;      // jet algo code: 0-JetClu(0.4), 1-JetClu(0.7), 2-JetClu(1.0)
                       //                3-MidPoint(0.4), 4-MidPoint(0.7), 5-MidPoint(1.0)
                       //                6-KtCl(0.4), 7-KtCl(0.7), 8-KtCl(1.0)

  double  fMinEmPMTasym; // minimum EM PMT asym
  double  fMinHadPMTasym; // minimum HAD PMT asym
  double  fMaxEmPMTasym; // maximum EM PMT asym
  double  fMaxHadPMTasym; // maximum HAD PMT asym

  double  fMinEmPmtE; // minimum EM PMT energy
  double  fMinHadPmtE; // minimum HAD PMT energy
 
  double  fMinSumEt;
  double  fMaxSumEt;
  double  fMinMEt;
  double  fMaxMEt;
  double  fMinMEtSig;
  double  fMaxMEtSig;
  double  fMinLum;
  double  fMaxLum;
  int  fMinNvx;
  int  fMaxNvx;  
  int  fMinNEmObj;
  int  fMaxNEmObj;
  int  fMinNTowers;
  int  fMaxNTowers;
  int  fMinNTowersOot;
  int  fMaxNTowersOot;
  int  fMinNJet;
  int  fMaxNJet;
  int  fMinNMuon;
  int  fMaxNMuon;
  int  fMinNTrack;
  int  fMaxNTrack;

  int  fMyTrigger;  // defines data type to be selected: Jet20=0, Jet50=1, 
                      // Jet70=2, Jet100=3, Jet05=4, Jet10=5, MinBias=6, All=1000

  // global variables
  double fLum;
  int fNEmObj;
  int myRunN;
  int fNMuon;
  int fNTrack;
  int fNTowers;
  int fNTowersOot;
  int fNJet;
  int vx_num;
  int fmyNvx12;
  double fMEt;
  double fSumEt;
  double fMEtSig;

  std::vector<BadTower> badEmTwr;  // list of bad EM towers
  std::vector<BadTower> badHadTwr; // list of bad HAD towers

  // Output parameters
  int Nspike_global;   // global number of spikes; to be used in cut
  double outMet[5];    // definitions of Met: [0]--using z=0; [1]--lepton zvx or 1st vertex from ZVertex;
  double outMetPhi[5]; // [2]--highest Pt zvx(?) and corrected for tracks; [3]--highest Pt zvx;
                       // [4]--highest Pt zvx and (x,y) beam off-set
  double outMetZvx;    // vertex used to correct Met
  double outSumEt[3];  // definition of SumEt: [0]--using z=0; [1]--lepton zvx or 1st vertex from ZVertex;
                       // [2]--highest Pt zvx.
 
  char* fDatFileName;

  //______________________________ MyGoodRunList implementation (temporary?)
  int fUseMyGoodRunList;
  int fUseMyEventList; // file name to be set by "fMyGoodRunFile"
  int fUseExcludeEvent; // switch to exclude events
  int fUseOldNewGoodRun; // switch to use old/new version of GoodRun 

  std::vector<int> myGoodRuns;
  std::vector<int> myEvntList_run;   // these two vectors have to be hadled together
  std::vector<int> myEvntList_event; // these two vectors have to be hadled together
  char* fMyGoodRunFile; // good run list
  char* fMyExcludeEventFile; // old version of ExcludeEvent, keep for compatibility 
  char* fMyEventRunFile; // "run/event" list file to be used for Select/Exclude event functions

public:
  TMyEventFilterModule(const char* name ="MyEventFilter", 
			  const char* title="MyEventFilter");
  ~TMyEventFilterModule();
					// ****** accessors

  Hist_t*             GetHist()          { return &fHist; }
  MetHist_t*          GetMetHist()       { return &fMetHist; }
  CalHist_t*          GetCalHist()       { return &fCalHist; }

  TCalDataBlock*      GetCalDataBlock()  { return fCalData; }
  TStnVertexBlock*    GetZVertexBlock()  { return fZVertexBlock; }
  TStnJetBlock*       GetJetBlockClu04() { return fJetBlockClu04; }
  TStnJetBlock*       GetJetBlockClu07() { return fJetBlockClu07; }
  TStnJetBlock*       GetJetBlockClu10() { return fJetBlockClu10; }
  TStnJetBlock*       GetJetBlockMid04() { return fJetBlockMid04; }
  TStnJetBlock*       GetJetBlockMid07() { return fJetBlockMid07; }
  TStnJetBlock*       GetJetBlockMid10() { return fJetBlockMid10; }
//   TStnJetBlock*       GetJetBlockKt04()  { return fJetBlockKt04; }
//   TStnJetBlock*       GetJetBlockKt07()  { return fJetBlockKt07; }
//   TStnJetBlock*       GetJetBlockKt10()  { return fJetBlockKt10; }
  TStnMetBlock*       GetMetBlock()      { return fMetBlock; }
  TStnTriggerBlock*   GetTriggerBlock()  { return fTriggerBlock; }
  TStnPhotonBlock*    GetPhotonBlock()   { return fPhotonBlock; }

					// cut values
  int  GetUseVerbose()    { return fUseVerbose; }
  int  GetDataType()      { return fDataType; }
  int  GetJetType()       { return fJetType; }
  int  GetUseFindSpike()  { return fUseFindSpike; }
  int  GetUseSpikeFilter() { return fUseSpikeFilter; }

  double  GetMinEmPMTasym() { return fMinEmPMTasym; }
  double  GetMinHadPMTasym() { return fMinHadPMTasym; }
  double  GetMaxEmPMTasym() { return fMaxEmPMTasym; }
  double  GetMaxHadPMTasym() { return fMaxHadPMTasym; }

  double  GetMinEmPmtE() { return fMinEmPmtE; }
  double  GetMinHadPmtE() { return fMinHadPmtE; }

  double  GetMinSumEt()    { return fMinSumEt; } 
  double  GetMaxSumEt()    { return fMaxSumEt; } 
  double  GetMinMEt()      { return fMinMEt; }   
  double  GetMaxMEt()      { return fMaxMEt; }   
  double  GetMinMEtSig()   { return fMinMEtSig; }
  double  GetMaxMEtSig()   { return fMaxMEtSig; }
  double  GetMinLum()      { return fMinLum; }   
  double  GetMaxLum()      { return fMaxLum; }  
  int  GetMinNvx()	     { return fMinNvx; }	
  int  GetMaxNvx()  	     { return fMaxNvx; }  	
  int  GetMinNEmObj()	     { return fMinNEmObj; }	
  int  GetMaxNEmObj()	     { return fMaxNEmObj; }	
  int  GetMinNTowers()     { return fMinNTowers; }	
  int  GetMaxNTowers()     { return fMaxNTowers; }	
  int  GetMinNTowersOot()  { return fMinNTowersOot; }	
  int  GetMaxNTowersOot()  { return fMaxNTowersOot; }	
  int  GetMinNJet()        { return fMinNJet; }	
  int  GetMaxNJet()        { return fMaxNJet; }	
  int  GetMinNMuon()	     { return fMinNMuon; }	
  int  GetMaxNMuon()	     { return fMaxNMuon; }	
  int  GetMinNTrack()	     { return fMinNTrack; }	
  int  GetMaxNTrack()      { return fMaxNTrack; }    

  int  GetMyTrigger()      { return fMyTrigger; }
  int  GetUseMyEventList()   { return fUseMyEventList; }
  int  GetUseExcludeEvent()  { return fUseExcludeEvent; }
  int  GetUseOldNewGoodRun() { return fUseOldNewGoodRun; } 

  // +++++  Accessors to Output parameters
  //.......................................
  double GetMet(int i) { if(i<5) return outMet[i]; else return -1.0E6; }
  double GetMetPhi(int i) { if(i<5) return outMetPhi[i]; else return -1.0E6; }
  double GetMetX(int i) { if(i<5) return outMet[i]*cos(outMetPhi[i]); else return -1.0E6; }
  double GetMetY(int i) { if(i<5) return outMet[i]*sin(outMetPhi[i]); else return -1.0E6; }   
  double GetMetZvx() { return outMetZvx; }   
  double GetSumEt(int i) { if(i<3) return outSumEt[i]; else return -1.0E6; } 


  char* GetDatFileName()     { return fDatFileName; }
 
					// ****** setters

  void SetUseVerbose    (int cut)  { fUseVerbose = cut; }
  void SetDataType      (int cut)  { fDataType = cut; }
  void SetJetType       (int cut)  { fJetType = cut; }
  void SetUseFindSpike  (int cut)  { fUseFindSpike = cut; }
  void SetUseSpikeFilter(int cut)  { fUseSpikeFilter = cut; }

  void SetMinEmPMTasym(double cut)  { fMinEmPMTasym = cut; }
  void SetMinHadPMTasym(double cut) { fMinHadPMTasym = cut; }
  void SetMaxEmPMTasym(double cut)  { fMaxEmPMTasym = cut; }
  void SetMaxHadPMTasym(double cut) { fMaxHadPMTasym = cut; }

  void SetMinEmPmtE(double cut)     { fMinEmPmtE = cut; }
  void SetMinHadPmtE(double cut)    { fMinHadPmtE = cut; }

  void  SetMinSumEt      (double cut)    { fMinSumEt = cut; } 
  void  SetMaxSumEt      (double cut)    { fMaxSumEt = cut; } 
  void  SetMinMEt        (double cut)    { fMinMEt = cut; }   
  void  SetMaxMEt        (double cut)    { fMaxMEt = cut; }   
  void  SetMinMEtSig     (double cut)    { fMinMEtSig = cut; }
  void  SetMaxMEtSig     (double cut)    { fMaxMEtSig = cut; }
  void  SetMinLum        (double cut)    { fMinLum = cut; }   
  void  SetMaxLum        (double cut)    { fMaxLum = cut; }  
  void  SetMinNvx        (int cut)	   { fMinNvx = cut; }	
  void  SetMaxNvx        (int cut)  	   { fMaxNvx = cut; }  	
  void  SetMinNEmObj     (int cut)	   { fMinNEmObj = cut; }	
  void  SetMaxNEmObj     (int cut)	   { fMaxNEmObj = cut; }	
  void  SetMinNTowers    (int cut)       { fMinNTowers = cut; }	
  void  SetMaxNTowers    (int cut)       { fMaxNTowers = cut; }	
  void  SetMinNTowersOot (int cut)       { fMinNTowersOot = cut; }	
  void  SetMaxNTowersOot (int cut)       { fMaxNTowersOot = cut; }	
  void  SetMinNJet       (int cut)	   { fMinNJet = cut; }	
  void  SetMaxNJet       (int cut)	   { fMaxNJet = cut; }	
  void  SetMinNMuon      (int cut)	   { fMinNMuon = cut; }	
  void  SetMaxNMuon      (int cut)	   { fMaxNMuon = cut; }	
  void  SetMinNTrack     (int cut)	   { fMinNTrack = cut; }	
  void  SetMaxNTrack     (int cut)       { fMaxNTrack = cut; }    

  void  SetMyTrigger     (int cut)       { fMyTrigger = cut; }

  // +++++  Setters of Output parameters
  //.......................................
  void SetMet(int i, double value) { if(i<5) outMet[i]=value; else return; }
  void SetMetPhi(int i, double value) { if(i<5) outMetPhi[i]=value; else return; }
  void SetMetZvx(double value) { outMetZvx=value; }   
  void SetSumEt(int i, double value) { if(i<3) outSumEt[i]=value; else return; } 

  void  SetDatFileName   (char* fname)       { fDatFileName = fname; }    

  //______________________________ MyGoodRunList implementation (temporary?)
  void  SetUseMyGoodRunList (int cut) { fUseMyGoodRunList = cut; }
  void  SetUseMyEventList(int cut)    { fUseMyEventList = cut; }
  void  SetUseExcludeEvent(int cut)   { fUseExcludeEvent = cut; }
  void  SetUseOldNewGoodRun(int cut)  { fUseOldNewGoodRun = cut; } 

  //___________________ new GoodRun version
//   void SetMyGoodRunList(char* goodrunfile) {
// //     goodrun->Read(goodrunfile);
//     int dummy=goodrun->TGoodRun::Read(goodrunfile);
//     return;
//   }
  int MyGoodRunFlag(int runN, int secN) {
    int flag=1;
    if(fUseMyGoodRunList==1) 
      {
	if(goodrun->Good(runN,secN)==true) flag=1;
	else flag=0;
      }
    return flag;
  }

  void  SetMyGoodRunList(int runN) { 
    for(int i=0; i<myGoodRuns.size(); i++) 
      { if(runN==0 || runN==myGoodRuns[i]) return; }
    myGoodRuns.push_back(runN);
    return;
  } 
  void  SetMyEventList(int runN, int eventN) { 
    for(int i=0; i<myEvntList_run.size(); i++) 
      { if(runN==0 || (runN==myEvntList_run[i] && eventN==myEvntList_event[i])) return; }
    myEvntList_run.push_back(runN);
    myEvntList_event.push_back(eventN);
    return;
  } 
  void  PrintMyGoodRunList() {
    for(int i=0; i<myGoodRuns.size(); i++) 
      std::cout<<myGoodRuns[i]<<std::endl;
  }
  void  PrintMyEventList() {
    for(int i=0; i<myEvntList_run.size(); i++) 
      std::cout<<myEvntList_run[i]<<"  "<<myEvntList_event[i]<<std::endl;
  }
  void  SetMyGoodRunFile(char* fname) { fMyGoodRunFile = fname; }
  void  SetMyExcludeEventFile(char* fname) { fMyExcludeEventFile = fname; }
  void  SetMyEventRunFile(char* fname) { fMyEventRunFile = fname; }

  int   MyGoodRunFlag (int runN) {
//     if(fUseMyGoodRunList==1 || fUseMyEventList==1) 
    if((fUseMyGoodRunList+fUseMyEventList+fUseExcludeEvent)>0) 
      {
	for(int i=0; i<myGoodRuns.size(); i++)
	  { 
	    if(myGoodRuns[i]==runN) return 1;
	  }
	return 0;
      }
    else return 1;
  }
  int MyGoodEventFlag(int runN, int eventN) {
    if(fUseMyEventList==1 && fUseExcludeEvent==0) 
      {
	for(int i=0; i<myEvntList_run.size(); i++)
	  { if(runN==myEvntList_run[i] && eventN==myEvntList_event[i]) return 1; }
	return 0;
      }
    else return 1;
  }
  int MyExcludeEventFlag(int runN, int eventN) {
    if(fUseMyEventList==0 && fUseExcludeEvent==1) 
      {
	for(int i=0; i<myEvntList_run.size(); i++)
	  { if(runN==myEvntList_run[i] && eventN==myEvntList_event[i]) return 0; }
	return 1;
      }
    else return 1;
  }

  //------------------------------------- end of GoodRun Stuff

  void    Display();
					// ****** overloaded methods of 
					// TStnModule
  int     BeginJob();
  int     BeginRun();
  int     Event   (int ientry);
  int     EndJob  ();
					// ****** other methods
  void    BookHistograms();
  void    BookMetHistograms(MetHist_t& Hist, const char* Folder);
  void    BookCalHistograms(CalHist_t& Hist, const char* Folder);
  void    FillMetHistogramsB(MetHist_t& Hist);
  void    FillMetHistogramsA(MetHist_t& Hist);

  void MatchCalorTowers(TStnJet* jet,
			TStnJetBlock* fJetBlock,
			TCalDataBlock *fCalDataBlock,
			CalDataArray* cdholder);
  void MatchCalorTowers(int pho_ind,
			TStnPhotonBlock* fPhotonBlock,
			TCalDataBlock *fCalDataBlock,
			CalDataArray* cdholder);

  int MyGoodJet(TStnJetBlock* fJetBlock, int& jet1_ind, int& jet2_ind); // for spike studies: checks if there are "good" jets and returns their indices
  int MyBadJet(TStnJetBlock* fJetBlock, TStnMetBlock* fMet_Block, int& jet_ind); // for spike studies: checks if there is a "bad" jet and returns its index

  int FindPmtSpikes(CalDataArray* towers, double& EmESpike, double& HadESpike, double& spikeHadTdc, CalHist_t& Hist);
  void DoMyCalStuff(TStnJetBlock* fJetBlock,TStnPhotonBlock* fPhotonBlock,TCalDataBlock *fCalDataBlock,CalHist_t& Hist);
  static int towerInd(int iEta) { return  iEta >= TENETA/2 ? iEta - TENETA/2 : -(TENETA/2 - 1 - iEta); }
    
  void    ClearModuleOutput(); // clears the Module output in the beginning of every event
  void    FillOutput(); // filling output params
  ClassDef(TMyEventFilterModule,0)
};

#endif
