/*
  Module to filter events, book basic event Histos
  This a prototype of event filter for dijet, pho+jet 
  and dipho analysis.

  !!!! NOTE: in the future, each Module has to perform its 
  own not overlapping with other bloks task !!!! 

  See myEventFilter.C program for example of how to use TMyEventFilterModule
*/


//_____________________________________________________________________________
// Em filter module
//_____________________________________________________________________________
#include <iomanip>
#include <iostream>
#include <fstream>
#include <algorithm>
#include "TF1.h"
#include "TCanvas.h"
#include "TMath.h"
#include "Stntuple/loop/TStnAna.hh"
#include "TMyEventFilterModule_ggX.hh"

// bool SortTowersByEnergy(TCalTower* c1, TCalTower* c2){
//   if(c1->EmEnergy() > c2->EmEnergy()) return true;
//   else return false;
// }
bool SortTowersByEnergy(TCalTower* c1, TCalTower* c2){
  if(c1->Energy() > c2->Energy()) return true;
  else return false;
}


// ClassImp(TMyEventFilterModule)
//_____________________________________________________________________________
TMyEventFilterModule::TMyEventFilterModule(const char* name, const char* title):
  TStnModule(name,title)
{
  fUseVerbose=0;
  fDataType=0; // Data type: real data=0, MC=1
  fJetType=1; // JetClu0.7 is default
  fUseFindSpike=0; // 0--don't look for spikes; 1--look for spikes
  fUseSpikeFilter=0; // 0==do nothing; 1==remove spikes; -1==select spikes
  //------- setting default cut values
//   fMinEmPMTasym=0.55;
//   fMinHadPMTasym=0.55; 
//   fMaxEmPMTasym=1.0; 
//   fMaxHadPMTasym=1.0;
//   fMinEmPmtE=5.0; 
//   fMinHadPmtE=5.0;
  fMinEmPMTasym=0.65;
  fMinHadPMTasym=0.85; 
  fMaxEmPMTasym=1.0; 
  fMaxHadPMTasym=1.0;
  fMinEmPmtE=10.0; 
  fMinHadPmtE=10.0;

  fMinSumEt=-1.0;
  fMaxSumEt=9999.0;
  fMinMEt=-1.0;
  fMaxMEt=9999.0;
  fMinMEtSig=-1.0;
  fMaxMEtSig=9999.0;
  fMinLum=-1.0;
  fMaxLum=1.0E35;
  fMinNvx=-1;
  fMaxNvx=10000;  
  fMinNEmObj=-1;
  fMaxNEmObj=10000;
  fMinNTowers=-1;
  fMaxNTowers=10000;
  fMinNTowersOot=-1;
  fMaxNTowersOot=10000;
  fMinNJet=-1;
  fMaxNJet=10000;
  fMinNMuon=-1;
  fMaxNMuon=10000;
  fMinNTrack=-1;
  fMaxNTrack=10000;
  fMyTrigger=1000;
  fDatFileName="results/MyEventFilter_output.dat";
  fMyGoodRunFile="Stntuple/ana/MyGoodRun_dijet_v6_all.dat";
  fMyExcludeEventFile="results/event_myDiPhoggX_cdip0da_diphoton_090105t23.dat";
  fMyEventRunFile="results/event_myDiPhoggX_cdip0da_diphoton_090105t23.dat";
  fUseMyGoodRunList=0; // Use MyGoodRunList only if fUseMyGoodRunList=1 
  fUseMyEventList=0; // use EventList only if fUseMyEventList=1
  fUseExcludeEvent=0; // use Exclude event only if fUseMyEventList=1 and fUseExcludeEvent=1
  fUseOldNewGoodRun=1; // GoodRun version: 1-- new (>=v10); 0--(<=v7)
  std::cout<<"Hi, entering TMyEventFilterModule"<<std::endl;
}

//_____________________________________________________________________________
TMyEventFilterModule::~TMyEventFilterModule() {
}

//_____________________________________________________________________________
void TMyEventFilterModule::BookHistograms() {
  char name[200];
  char title[200];

  TFolder* fol;
  TFolder* hist_folder;
  
  char folder_name[200];
  //-----------------------------------------------------------------------------
  //  clear the histogram list
  //-----------------------------------------------------------------------------
  DeleteHistograms();
  hist_folder = (TFolder*) GetFolder()->FindObject("Hist");
  //-----------------------------------------------------------------------------
  //  Met histograms 
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"MEt");
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookMetHistograms(fMetHist,Form("Hist/%s",folder_name));


  //-----------------------------------------------------------------------------
  //  Cal histograms for spike studies
  //-----------------------------------------------------------------------------
  sprintf(folder_name,"Calor"); // for all objects
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookCalHistograms(fCalHist,Form("Hist/%s",folder_name));

  sprintf(folder_name,"Calor_EMobj"); // for EM objects
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookCalHistograms(fCalHist_EMobj,Form("Hist/%s",folder_name));

  sprintf(folder_name,"Calor_goodJet"); // for "good" jets
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookCalHistograms(fCalHist_goodjet,Form("Hist/%s",folder_name));

  sprintf(folder_name,"Calor_badJet"); // for "bad" jets
  fol = (TFolder*) hist_folder->FindObject(folder_name);
  if (! fol) fol = hist_folder->AddFolder(folder_name,folder_name);
  BookCalHistograms(fCalHist_badjet,Form("Hist/%s",folder_name));

  //------ booking histograms
  //-------------- ideally, histo params has 
  //-------------- to be passed into module 
  //-------------- from outside: <- to be done

                            //---- before cuts

  HBook1F(fHist.fEvntSumEt_b,"SumEt_before","SumEt",400,0.0,4000.0);
  HBook1F(fHist.fEvntMEt_b,"MEt_before","MEt",800,0.0,800.0);
  HBook1F(fHist.fEvntMEtSig_b,"MEtSig_before","MEt significance",1000,0.0,100.0);    
  HBook1F(fHist.fEvntLum_b,"Lum_before","Int. Lum",1000,0.0,400.0);
  HBook1F(fHist.fEvntNvx_b,"Nvx_before","Number(vertices)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNEmObj_b,"NEmObj_before","Number(EM objetcs)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNTowers_b,"NTow_before","Number(towers)",4000,-0.5,3999.5);
  HBook1F(fHist.fEvntNTowersOot_b,"NTowOot_before","Number(Out-of-time towers)",1000,-0.5,999.5);
  if(fJetType==0) HBook1F(fHist.fEvntNJet_b,"NJet_before",
			  "Number(JetClue04 jets)",100,-0.5,99.5);
  if(fJetType==1) HBook1F(fHist.fEvntNJet_b,"NJet_before",
			  "Number(JetClue07 jets)",100,-0.5,99.5);
  if(fJetType==2) HBook1F(fHist.fEvntNJet_b,"NJet_before",
			  "Number(JetClue10 jets)",100,-0.5,99.5);
  if(fJetType==3) HBook1F(fHist.fEvntNJet_b,"NJet_before",
			  "Number(MidPoint04 jets)",100,-0.5,99.5);
  if(fJetType==4) HBook1F(fHist.fEvntNJet_b,"NJet_before",
			  "Number(MidPoint07 jets)",100,-0.5,99.5);
  if(fJetType==5) HBook1F(fHist.fEvntNJet_b,"NJet_before",
			  "Number(MidPoint10 jets)",100,-0.5,99.5);
//   if(fJetType==6) HBook1F(fHist.fEvntNJet_b,"NJet_before",
// 			  "Number(Kt04 jets)",100,-0.5,99.5);
//   if(fJetType==7) HBook1F(fHist.fEvntNJet_b,"NJet_before",
// 			  "Number(Kt07 jets)",100,-0.5,99.5);
//   if(fJetType==8) HBook1F(fHist.fEvntNJet_b,"NJet_before",
// 			  "Number(Kt10 jets)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNMuon_b,"NMu_before","Number(muons)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNTrack_b,"NTrk_before","Number(tracks)",1000,-0.5,999.5);

                             //---- after cuts

  HBook1F(fHist.fEvntSumEt_a,"SumEt_after","SumEt",400,0.0,4000.0);
  HBook1F(fHist.fEvntMEt_a,"MEt_after","MEt",800,0.0,800.0);
  HBook1F(fHist.fEvntMEtSig_a,"MEtSig_after","MEt significance",1000,0.0,100.0);    
  HBook1F(fHist.fEvntLum_a,"Lum_after","Int. Lum",1000,0.0,400.0);
  HBook1F(fHist.fEvntNvx_a,"Nvx_after","Number(vertices)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNEmObj_a,"NEmObj_after","Number(EM objetcs)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNTowers_a,"NTow_after","Number(towers)",4000,-0.5,3999.5);
  HBook1F(fHist.fEvntNTowersOot_a,"NTowOot_after","Number(Out-of-time towers)",1000,-0.5,999.5);
  if(fJetType==0) HBook1F(fHist.fEvntNJet_a,"NJet_after",
			  "Number(JetClue04 jets)",100,-0.5,99.5);
  if(fJetType==1) HBook1F(fHist.fEvntNJet_a,"NJet_after",
			  "Number(JetClue07 jets)",100,-0.5,99.5);
  if(fJetType==2) HBook1F(fHist.fEvntNJet_a,"NJet_after",
			  "Number(JetClue10 jets)",100,-0.5,99.5);
  if(fJetType==3) HBook1F(fHist.fEvntNJet_a,"NJet_after",
			  "Number(MidPoint04 jets)",100,-0.5,99.5);
  if(fJetType==4) HBook1F(fHist.fEvntNJet_a,"NJet_after",
			  "Number(MidPoint07 jets)",100,-0.5,99.5);
  if(fJetType==5) HBook1F(fHist.fEvntNJet_a,"NJet_after",
			  "Number(MidPoint10 jets)",100,-0.5,99.5);
//   if(fJetType==6) HBook1F(fHist.fEvntNJet_a,"NJet_after",
// 			  "Number(Kt04 jets)",100,-0.5,99.5);
//   if(fJetType==7) HBook1F(fHist.fEvntNJet_a,"NJet_after",
// 			  "Number(Kt07 jets)",100,-0.5,99.5);
//   if(fJetType==8) HBook1F(fHist.fEvntNJet_a,"NJet_after",
// 			  "Number(Kt10 jets)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNMuon_a,"NMu_after","Number(muons)",100,-0.5,99.5);
  HBook1F(fHist.fEvntNTrack_a,"NTrk_after","Number(tracks)",1000,-0.5,999.5);

}

void TMyEventFilterModule::BookCalHistograms(CalHist_t& Hist, const char* Folder) {
  char name [200];
  char title[200];
  // book histograms

  sprintf(name,"CalEMtwr");
  sprintf(title," EM towers with spikes");
  Hist.fCalEMtwr=new TH2F(name,title,23,-11.5,11.5,24,-0.5,23.5);
  AddHistogram(Hist.fCalEMtwr,Folder);
  sprintf(name,"CalCHAtwr");
  sprintf(title," CHA towers with spikes");
  Hist.fCalCHAtwr=new TH2F(name,title,23,-11.5,11.5,24,-0.5,23.5);
  AddHistogram(Hist.fCalCHAtwr,Folder);
  sprintf(name,"CalWHAtwr");
  sprintf(title," WHA towers with spikes");
  Hist.fCalWHAtwr=new TH2F(name,title,23,-11.5,11.5,24,-0.5,23.5);
  AddHistogram(Hist.fCalWHAtwr,Folder);

  //____________________________________ bad tower studies
  sprintf(name,"CalPmtAssmVsRun[0]");
  sprintf(title,"CEM tower (0,2): (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[0]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[0],Folder);
  sprintf(name,"CalPmtAssmVsRun[1]");
  sprintf(title,"CEM tower (4,8): (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[1]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[1],Folder);
  sprintf(name,"CalPmtAssmVsRun[2]");
  sprintf(title,"CEM tower (4,7): (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[2]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[2],Folder);
  sprintf(name,"CalPmtAssmVsRun[3]");
  sprintf(title,"CEM tower (23,3): (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[3]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[3],Folder);
  sprintf(name,"CalPmtAssmVsRun[4]");
  sprintf(title,"WHA tower (2,-11): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[4]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[4],Folder);
  sprintf(name,"CalPmtAssmVsRun[5]");
  sprintf(title,"WHA tower (0,-10): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[5]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[5],Folder);
  sprintf(name,"CalPmtAssmVsRun[6]");
  sprintf(title,"CHA tower (23,-1): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[6]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[6],Folder);
  sprintf(name,"CalPmtAssmVsRun[7]");
  sprintf(title,"CHA tower (5,7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[7]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[7],Folder);
  sprintf(name,"CalPmtAssmVsRun[8]");
  sprintf(title,"CHA tower (5,6): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[8]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[8],Folder);
  sprintf(name,"CalPmtAssmVsRun[9]");
  sprintf(title,"WHA tower (22,8): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[9]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[9],Folder);
  sprintf(name,"CalPmtAssmVsRun[10]");
  sprintf(title,"WHA tower (1,9): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[10]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[10],Folder);
  sprintf(name,"CalPmtAssmVsRun[11]");
  sprintf(title,"WHA tower (12,10): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[11]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[11],Folder);
  sprintf(name,"CalPmtAssmVsRun[12]");
  sprintf(title,"CHA tower (11,-7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[12]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[12],Folder);
  sprintf(name,"CalPmtAssmVsRun[13]");
  sprintf(title,"CHA tower (12,-7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[13]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[13],Folder);
  sprintf(name,"CalPmtAssmVsRun[14]");
  sprintf(title,"CHA tower (7,7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[14]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[14],Folder);
  sprintf(name,"CalPmtAssmVsRun[15]");
  sprintf(title,"CHA tower (9,7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[15]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[15],Folder);
  sprintf(name,"CalPmtAssmVsRun[16]");
  sprintf(title,"CHA tower (10,7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[16]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[16],Folder);
  sprintf(name,"CalPmtAssmVsRun[17]");
  sprintf(title,"CHA tower (14,7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[17]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[17],Folder);
  sprintf(name,"CalPmtAssmVsRun[18]");
  sprintf(title,"CHA tower (19,7): (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) vs. Run");
  Hist.fCalPmtAssmVsRun[18]=new TProfile(name,title,500,130000.0,230000.0,-1.01,1.01);
  AddHistogram(Hist.fCalPmtAssmVsRun[18],Folder);


  sprintf(name,"CalBad_dPhi[0]");
  sprintf(title,"CEM tower (0,2): d#phi=#phi_{EM spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[0]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[0],Folder);
  sprintf(name,"CalBad_MetRatio[0]");
  sprintf(title,"CEM tower (0,2): #slash{E}_{T}/E_{T}^{EM spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[0]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[0],Folder);
  sprintf(name,"CalBad_dPhi[1]");
  sprintf(title,"CEM tower (4,8): d#phi=#phi_{EM spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[1]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[1],Folder);
  sprintf(name,"CalBad_MetRatio[1]");
  sprintf(title,"CEM tower (4,8): #slash{E}_{T}/E_{T}^{EM spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[1]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[1],Folder);
  sprintf(name,"CalBad_dPhi[2]");
  sprintf(title,"CEM tower (4,7): d#phi=#phi_{EM spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[2]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[2],Folder);
  sprintf(name,"CalBad_MetRatio[2]");
  sprintf(title,"CEM tower (4,7): #slash{E}_{T}/E_{T}^{EM spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[2]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[2],Folder);
  sprintf(name,"CalBad_dPhi[3]");
  sprintf(title,"CEM tower (23,3): d#phi=#phi_{EM spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[3]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[3],Folder);
  sprintf(name,"CalBad_MetRatio[3]");
  sprintf(title,"CEM tower (23,3): #slash{E}_{T}/E_{T}^{EM spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[3]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[3],Folder);
  sprintf(name,"CalBad_dPhi[4]");
  sprintf(title,"WHA tower (2,-11): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[4]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[4],Folder);
  sprintf(name,"CalBad_MetRatio[4]");
  sprintf(title,"WHA tower (2,-11): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[4]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[4],Folder);
  sprintf(name,"CalBad_dPhi[5]");
  sprintf(title,"WHA tower (0,-10): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[5]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[5],Folder);
  sprintf(name,"CalBad_MetRatio[5]");
  sprintf(title,"WHA tower (0,-10): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[5]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[5],Folder);
  sprintf(name,"CalBad_dPhi[6]");
  sprintf(title,"CHA tower (23,-1): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[6]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[6],Folder);
  sprintf(name,"CalBad_MetRatio[6]");
  sprintf(title,"CHA tower (23,-1): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[6]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[6],Folder);
  sprintf(name,"CalBad_dPhi[7]");
  sprintf(title,"CHA tower (5,7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[7]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[7],Folder);
  sprintf(name,"CalBad_MetRatio[7]");
  sprintf(title,"CHA tower (5,7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[7]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[7],Folder);
  sprintf(name,"CalBad_dPhi[8]");
  sprintf(title,"CHA tower (5,6): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[8]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[8],Folder);
  sprintf(name,"CalBad_MetRatio[8]");
  sprintf(title,"CHA tower (5,6): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[8]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[8],Folder);
  sprintf(name,"CalBad_dPhi[9]");
  sprintf(title,"WHA tower (22,8): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[9]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[9],Folder);
  sprintf(name,"CalBad_MetRatio[9]");
  sprintf(title,"WHA tower (22,8): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[9]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[9],Folder);
  sprintf(name,"CalBad_dPhi[10]");
  sprintf(title,"WHA tower (1,9): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[10]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[10],Folder);
  sprintf(name,"CalBad_MetRatio[10]");
  sprintf(title,"WHA tower (1,9): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[10]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[10],Folder);
  sprintf(name,"CalBad_dPhi[11]");
  sprintf(title,"WHA tower (12,10): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_dPhi[11]=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalBad_dPhi[11],Folder);
  sprintf(name,"CalBad_MetRatio[11]");
  sprintf(title,"WHA tower (12,10): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
  Hist.fCalBad_MetRatio[11]=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalBad_MetRatio[11],Folder);


//   sprintf(name,"CalBad_dPhi[12]");
//   sprintf(title,"CHA tower (11,-7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[12]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[12],Folder);
//   sprintf(name,"CalBad_MetRatio[12]");
//   sprintf(title,"CHA tower (11,-7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[12]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[12],Folder);
//   sprintf(name,"CalBad_dPhi[13]");
//   sprintf(title,"CHA tower (12,-7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[13]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[13],Folder);
//   sprintf(name,"CalBad_MetRatio[13]");
//   sprintf(title,"CHA tower (12,-7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[13]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[13],Folder);
//   sprintf(name,"CalBad_dPhi[14]");
//   sprintf(title,"CHA tower (7,7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[14]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[14],Folder);
//   sprintf(name,"CalBad_MetRatio[14]");
//   sprintf(title,"CHA tower (7,7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[14]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[14],Folder);
//   sprintf(name,"CalBad_dPhi[15]");
//   sprintf(title,"CHA tower (9,7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[15]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[15],Folder);
//   sprintf(name,"CalBad_MetRatio[15]");
//   sprintf(title,"CHA tower (9,7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[15]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[15],Folder);
//   sprintf(name,"CalBad_dPhi[16]");
//   sprintf(title,"CHA tower (10,7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[16]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[16],Folder);
//   sprintf(name,"CalBad_MetRatio[16]");
//   sprintf(title,"CHA tower (10,7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[16]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[16],Folder);
//   sprintf(name,"CalBad_dPhi[17]");
//   sprintf(title,"CHA tower (14,7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[17]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[17],Folder);
//   sprintf(name,"CalBad_MetRatio[17]");
//   sprintf(title,"CHA tower (14,7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[17]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[17],Folder);
//   sprintf(name,"CalBad_dPhi[18]");
//   sprintf(title,"CHA tower (19,7): d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_dPhi[18]=new TH1F(name,title,100,0.0,3.15);
//   AddHistogram(Hist.fCalBad_dPhi[18],Folder);
//   sprintf(name,"CalBad_MetRatio[18]");
//   sprintf(title,"CHA tower (19,7): #slash{E}_{T}/E_{T}^{HAD spike} if (Q_{pmt1}-Q_{pmt2})/(Q_{pmt1}+Q_{pmt2})>0.55");
//   Hist.fCalBad_MetRatio[18]=new TH1F(name,title,500,0.0,10.0);
//   AddHistogram(Hist.fCalBad_MetRatio[18],Folder);
   //___________________________________________________________________________________________________________

  sprintf(name,"CalEm_dPhi");
  sprintf(title,"d#phi=#phi_{EM spike}-#phi_{#slash{E}_{T}} if E_{em}^{twr}>10 GeV");
  Hist.fCalEm_dPhi=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalEm_dPhi,Folder);
  sprintf(name,"CalEm_MetRatio");
  sprintf(title,"#slash{E}_{T}/E_{T}^{EM spike} if E_{em}^{twr}>10 GeV");
  Hist.fCalEm_MetRatio=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalEm_MetRatio,Folder);
  sprintf(name,"CalHad_dPhi");
  sprintf(title,"d#phi=#phi_{HAD spike}-#phi_{#slash{E}_{T}} if E_{had}^{twr}>10 GeV");
  Hist.fCalHad_dPhi=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fCalHad_dPhi,Folder);
  sprintf(name,"CalHad_MetRatio");
  sprintf(title,"#slash{E}_{T}/E_{T}^{HAD spike} if E_{had}^{twr}>10 GeV");
  Hist.fCalHad_MetRatio=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fCalHad_MetRatio,Folder);

  sprintf(name,"CalPmtEmAssm_bad");
  sprintf(title,"pmt asymmetry for bad EM towers: (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2})");
  Hist.fCalPmtEmAssm_bad=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtEmAssm_bad,Folder);
  sprintf(name,"CalPmtHadAssm_bad");
  sprintf(title,"pmt asymmetry for bad HAD towers: (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2})");
  Hist.fCalPmtHadAssm_bad=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtHadAssm_bad,Folder);

  sprintf(name,"CalPmtEmAssm_le10");
  sprintf(title,"pmt asymmetry: (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2}) if E_{em}^{twr}<10 GeV");
  Hist.fCalPmtEmAssm_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtEmAssm_le10,Folder);
  sprintf(name,"CalPmtHadAssm_le10");
  sprintf(title,"pmt asymmetry: (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) if E_{had}^{twr}<10 GeV");
  Hist.fCalPmtHadAssm_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtHadAssm_le10,Folder);
  sprintf(name,"CalPmtEmAssm_ge10");
  sprintf(title,"pmt asymmetry: (E_{em}^{pmt1}-E_{em}^{pmt2})/(E_{em}^{pmt1}+E_{em}^{pmt2}) if E_{em}^{twr}>10 GeV");
  Hist.fCalPmtEmAssm_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtEmAssm_ge10,Folder);
  sprintf(name,"CalPmtHadAssm_ge10");
  sprintf(title,"pmt asymmetry: (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) if E_{had}^{twr}>10 GeV");
  Hist.fCalPmtHadAssm_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtHadAssm_ge10,Folder);

  sprintf(name,"CalPmtCemAssm_le10");
  sprintf(title,"pmt asymmetry: (E_{cem}^{pmt1}-E_{cem}^{pmt2})/(E_{cem}^{pmt1}+E_{cem}^{pmt2}) if E_{cem}^{twr}<10 GeV");
  Hist.fCalPmtCemAssm_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtCemAssm_le10,Folder);
  sprintf(name,"CalPmtChaAssm_le10");
  sprintf(title,"pmt asymmetry outside overlap: (E_{cha}^{pmt1}-E_{cha}^{pmt2})/(E_{cha}^{pmt1}+E_{cha}^{pmt2}) if E_{cha}^{twr}<10 GeV");
  Hist.fCalPmtChaAssm_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtChaAssm_le10,Folder);
  sprintf(name,"CalPmtWhaAssm_le10");
  sprintf(title,"pmt asymmetry outside overlap: (E_{wha}^{pmt1}-E_{wha}^{pmt2})/(E_{wha}^{pmt1}+E_{wha}^{pmt2}) if E_{wha}^{twr}<10 GeV");
  Hist.fCalPmtWhaAssm_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtWhaAssm_le10,Folder);

  sprintf(name,"CalPmtCemAssm_ge10");
  sprintf(title,"pmt asymmetry: (E_{cem}^{pmt1}-E_{cem}^{pmt2})/(E_{cem}^{pmt1}+E_{cem}^{pmt2}) if E_{cem}^{twr}>10 GeV");
  Hist.fCalPmtCemAssm_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtCemAssm_ge10,Folder);
  sprintf(name,"CalPmtChaAssm_ge10");
  sprintf(title,"pmt asymmetry outside overlap: (E_{cha}^{pmt1}-E_{cha}^{pmt2})/(E_{cha}^{pmt1}+E_{cha}^{pmt2}) if E_{cha}^{twr}>10 GeV");
  Hist.fCalPmtChaAssm_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtChaAssm_ge10,Folder);
  sprintf(name,"CalPmtWhaAssm_ge10");
  sprintf(title,"pmt asymmetry outside overlap: (E_{wha}^{pmt1}-E_{wha}^{pmt2})/(E_{wha}^{pmt1}+E_{wha}^{pmt2}) if E_{wha}^{twr}>10 GeV");
  Hist.fCalPmtWhaAssm_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtWhaAssm_ge10,Folder);

  sprintf(name,"CalPmtChaAssm_overlap_le10");
  sprintf(title,"pmt asymmetry in overlap region: (E_{cha}^{pmt1}-E_{cha}^{pmt2})/(E_{cha}^{pmt1}+E_{cha}^{pmt2}) if E_{had}^{twr}<10 GeV");
  Hist.fCalPmtChaAssm_overlap_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtChaAssm_overlap_le10,Folder);
  sprintf(name,"CalPmtWhaAssm_overlap_le10");
  sprintf(title,"pmt asymmetry in overlap region: (E_{wha}^{pmt1}-E_{wha}^{pmt2})/(E_{wha}^{pmt1}+E_{wha}^{pmt2}) if E_{had}^{twr}<10 GeV");
  Hist.fCalPmtWhaAssm_overlap_le10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtWhaAssm_overlap_le10,Folder);
  sprintf(name,"CalPmtChaAssm_overlap_ge10");
  sprintf(title,"pmt asymmetry in overlap region: (E_{cha}^{pmt1}-E_{cha}^{pmt2})/(E_{cha}^{pmt1}+E_{cha}^{pmt2}) if E_{had}^{twr}>10 GeV");
  Hist.fCalPmtChaAssm_overlap_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtChaAssm_overlap_ge10,Folder);
  sprintf(name,"CalPmtWhaAssm_overlap_ge10");
  sprintf(title,"pmt asymmetry in overlap region: (E_{wha}^{pmt1}-E_{wha}^{pmt2})/(E_{wha}^{pmt1}+E_{wha}^{pmt2}) if E_{had}^{twr}>10 GeV");
  Hist.fCalPmtWhaAssm_overlap_ge10=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtWhaAssm_overlap_ge10,Folder);

  sprintf(name,"CalPmtHadAssm_ge10_intime");
  sprintf(title,"pmt asymmetry: (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) if E_{had}^{twr}>10 GeV and |HadTdc|<40 ns");
  Hist.fCalPmtHadAssm_ge10_intime=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtHadAssm_ge10_intime,Folder);
  sprintf(name,"CalPmtHadAssm_ge10_outtime");
  sprintf(title,"pmt asymmetry: (E_{had}^{pmt1}-E_{had}^{pmt2})/(E_{had}^{pmt1}+E_{had}^{pmt2}) if E_{had}^{twr}>10 GeV and 40<|HadTdc|<80 ns");
  Hist.fCalPmtHadAssm_ge10_outtime=new TH1F(name,title,200,-1.0,1.0);
  AddHistogram(Hist.fCalPmtHadAssm_ge10_outtime,Folder);

  sprintf(name,"CalEmPmtAssm_vs_PmtSum");
  sprintf(title,"E_{em}^{pmt1}-E_{em}^{pmt2} vs. E_{em}^{pmt1}+E_{em}^{pmt2} ");
  Hist.fCalEmPmtAssm_vs_PmtSum=new TH2F(name,title,100,-1.0,1.0,300,0.0,300.0);
  AddHistogram(Hist.fCalEmPmtAssm_vs_PmtSum,Folder);
  sprintf(name,"CalHadPmtAssm_vs_PmtSum");
  sprintf(title,"E_{had}^{pmt1}-E_{had}^{pmt2} vs. E_{had}^{pmt1}+E_{had}^{pmt2}");
  Hist.fCalHadPmtAssm_vs_PmtSum=new TH2F(name,title,100,-1.0,1.0,300,0.0,300.0);
  AddHistogram(Hist.fCalHadPmtAssm_vs_PmtSum,Folder);

  sprintf(name,"CalNspike");
  sprintf(title,"Total number of spikes per event");
  Hist.fCalNspike=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fCalNspike,Folder);
  sprintf(name,"CalEspike");
  sprintf(title,"Energy of spikes");
  Hist.fCalEspike=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fCalEspike,Folder);
  sprintf(name,"CalHadEspike");
  sprintf(title,"Energy of HAD spikes");
  Hist.fCalHadEspike=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fCalHadEspike,Folder);
  sprintf(name,"CalEmEspike");
  sprintf(title,"Energy of EM spikes");
  Hist.fCalEmEspike=new TH1F(name,title,1000,0.0,1000.0);
  AddHistogram(Hist.fCalEmEspike,Folder);
  sprintf(name,"CalHadTDCspike");
  sprintf(title,"Timing of HAD spikes");
  Hist.fCalHadTDCspike=new TH1F(name,title,1000,-200.0,200.0);
  AddHistogram(Hist.fCalHadTDCspike,Folder);


  sprintf(name,"Test_dPhiSpikeMet");
  sprintf(title,"d#phi=#phi_{spike}-#phi_{#slash{E}_{T}}");
  Hist.fTest_dPhiSpikeMet=new TH1F(name,title,100,0.0,3.15);
  AddHistogram(Hist.fTest_dPhiSpikeMet,Folder);
  sprintf(name,"Test_SpikeMetRatio");
  sprintf(title,"#slash{E}_{T}/E_{T}^{spike}");
  Hist.fTest_SpikeMetRatio=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fTest_SpikeMetRatio,Folder);
  sprintf(name,"Test_Ntwr");
  sprintf(title,"N_{twr} in object with spike");
  Hist.fTest_Ntwr=new TH1F(name,title,10,-0.5,9.5);
  AddHistogram(Hist.fTest_Ntwr,Folder);
  sprintf(name,"Test_HadEm");
  sprintf(title,"Had/Em in object with spike");
  Hist.fTest_HadEm=new TH1F(name,title,100,0.0,1.0);
  AddHistogram(Hist.fTest_HadEm,Folder);
  sprintf(name,"Test_EwireEspike");
  sprintf(title,"E_{CES wire}/E_{spike}");
  Hist.fTest_EwireEspike=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fTest_EwireEspike,Folder);
  sprintf(name,"Test_EstripEspike");
  sprintf(title,"E_{CES strip}/E_{spike}");
  Hist.fTest_EstripEspike=new TH1F(name,title,500,0.0,10.0);
  AddHistogram(Hist.fTest_EstripEspike,Folder);
  sprintf(name,"Test_Chi2");
  sprintf(title,"E_{CES strip}/E_{spike}");
  Hist.fTest_Chi2=new TH1F(name,title,300,0.0,30.0);
  AddHistogram(Hist.fTest_Chi2,Folder);

  return;
}

void TMyEventFilterModule::BookMetHistograms(MetHist_t& Hist, const char* Folder) {
  char name [200];
  char title[200];
  // book histograms  

  //--------- before cuts ---------------
  sprintf(name,"Met4VsRun_b");
  sprintf(title,"meth4 MEt Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet4VsRun_b,Folder);
  sprintf(name,"Met4XVsRun_b");
  sprintf(title,"meth4 MEtX Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4XVsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet4XVsRun_b,Folder);
  sprintf(name,"Met4YVsRun_b");
  sprintf(title,"meth4 MEtY Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4YVsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet4YVsRun_b,Folder);
  sprintf(name,"Met3VsRun_b");
  sprintf(title,"meth3 MEt Vs. Run for N_{vx12}=1");
  Hist.fEvntMet3VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet3VsRun_b,Folder);
  sprintf(name,"Met3XVsRun_b");
  sprintf(title,"meth3 MEtX Vs. Run for N_{vx12}=1");
  Hist.fEvntMet3XVsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet3XVsRun_b,Folder);
  sprintf(name,"Met3YVsRun_b");
  sprintf(title,"meth3 MEtY Vs. Run for N_{vx12}=1");
  Hist.fEvntMet3YVsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet3YVsRun_b,Folder);
  sprintf(name,"Sumet2VsRun_b");
  sprintf(title,"meth2 Sum E_{T} Vs. Run for N_{vx12}=1");
  Hist.fEvntSumet2VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1.0,2000.0);
  AddHistogram(Hist.fEvntSumet2VsRun_b,Folder);

  sprintf(name,"Met4_2VsRun_b");
  sprintf(title,"meth4 MEt^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4_2VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1.0,40000.0);
  AddHistogram(Hist.fEvntMet4_2VsRun_b,Folder);
  sprintf(name,"Met4X_2VsRun_b");
  sprintf(title,"meth4 MEtX^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4X_2VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-40000.0,40000.0);
  AddHistogram(Hist.fEvntMet4X_2VsRun_b,Folder);
  sprintf(name,"Met4Y_2VsRun_b");
  sprintf(title,"meth4 MEtY^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4Y_2VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-40000.0,40000.0);
  AddHistogram(Hist.fEvntMet4Y_2VsRun_b,Folder);
  sprintf(name,"Sumet2_2VsRun_b");
  sprintf(title,"meth2 Sum E_{T}^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntSumet2_2VsRun_b=new TProfile(name,title,500,130000.0,230000.0,-1.0,4000000.0);
  AddHistogram(Hist.fEvntSumet2_2VsRun_b,Folder);

  sprintf(name,"Met4VsNmu_b");
  sprintf(title,"meth4 MEt Vs. number of muons");
  Hist.fEvntMet4VsNmu_b=new TProfile(name,title,11,-0.5,10.5,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet4VsNmu_b,Folder);
  sprintf(name,"Met4nvx1VsLum_b");
  sprintf(title,"meth4 MEt vs. Lum for N_{vx12}=1");
  Hist.fEvntMet4nvx1VsLum_b=new TProfile(name,title,40,0.0,200.0,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet4nvx1VsLum_b,Folder);

  //--------- after cuts ---------------
  sprintf(name,"Met4VsRun_a");
  sprintf(title,"meth4 MEt Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet4VsRun_a,Folder);
  sprintf(name,"Met4XVsRun_a");
  sprintf(title,"meth4 MEtX Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4XVsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet4XVsRun_a,Folder);
  sprintf(name,"Met4YVsRun_a");
  sprintf(title,"meth4 MEtY Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4YVsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet4YVsRun_a,Folder);
  sprintf(name,"Met3VsRun_a");
  sprintf(title,"meth3 MEt Vs. Run for N_{vx12}=1");
  Hist.fEvntMet3VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet3VsRun_a,Folder);
  sprintf(name,"Met3XVsRun_a");
  sprintf(title,"meth3 MEtX Vs. Run for N_{vx12}=1");
  Hist.fEvntMet3XVsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet3XVsRun_a,Folder);
  sprintf(name,"Met3YVsRun_a");
  sprintf(title,"meth3 MEtY Vs. Run for N_{vx12}=1");
  Hist.fEvntMet3YVsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1000.0,1000.0);
  AddHistogram(Hist.fEvntMet3YVsRun_a,Folder);
  sprintf(name,"Sumet2VsRun_a");
  sprintf(title,"meth2 Sum E_{T} Vs. Run for N_{vx12}=1");
  Hist.fEvntSumet2VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1.0,2000.0);
  AddHistogram(Hist.fEvntSumet2VsRun_a,Folder);

  sprintf(name,"Met4_2VsRun_a");
  sprintf(title,"meth4 MEt^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4_2VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1.0,40000.0);
  AddHistogram(Hist.fEvntMet4_2VsRun_a,Folder);
  sprintf(name,"Met4X_2VsRun_a");
  sprintf(title,"meth4 MEtX^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4X_2VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-40000.0,40000.0);
  AddHistogram(Hist.fEvntMet4X_2VsRun_a,Folder);
  sprintf(name,"Met4Y_2VsRun_a");
  sprintf(title,"meth4 MEtY^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntMet4Y_2VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-40000.0,40000.0);
  AddHistogram(Hist.fEvntMet4Y_2VsRun_a,Folder);
  sprintf(name,"Sumet2_2VsRun_a");
  sprintf(title,"meth2 Sum E_{T}^{2} Vs. Run for N_{vx12}=1");
  Hist.fEvntSumet2_2VsRun_a=new TProfile(name,title,100,130000.0,230000.0,-1.0,4000000.0);
  AddHistogram(Hist.fEvntSumet2_2VsRun_a,Folder);

  sprintf(name,"Met4VsNmu_a");
  sprintf(title,"meth4 MEt Vs. number of muons");
  Hist.fEvntMet4VsNmu_a=new TProfile(name,title,11,-0.5,10.5,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet4VsNmu_a,Folder);
  sprintf(name,"Met4nvx1VsLum_a");
  sprintf(title,"meth4 MEt vs. Lum for N_{vx12}=1");
  Hist.fEvntMet4nvx1VsLum_a=new TProfile(name,title,40,0.0,200.0,-1.0,1000.0);
  AddHistogram(Hist.fEvntMet4nvx1VsLum_a,Folder);

  for(int i=0; i<5; i++)
    {
  //__________________________________ before cuts
      sprintf(name,"Met_b[%i]",i);
      sprintf(title,"MEt_%i",i);
      Hist.fEvntMet_b[i]=new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fEvntMet_b[i],Folder);
      sprintf(name,"MetX_b[%i]",i);
      sprintf(title,"MEt_%i, x-projection",i);
      Hist.fEvntMetX_b[i]=new TH1F(name,title,1000,-500.0,500.0);
      AddHistogram(Hist.fEvntMetX_b[i],Folder);
      sprintf(name,"MetY_b[%i]",i);
      sprintf(title,"MEt_%i, y-projection",i);
      Hist.fEvntMetY_b[i]=new TH1F(name,title,1000,-500.0,500.0);
      AddHistogram(Hist.fEvntMetY_b[i],Folder);
      sprintf(name,"MetPhi_b[%i]",i);
      sprintf(title,"#phi of MEt_%i",i);
      Hist.fEvntMetPhi_b[i]=new TH1F(name,title,140,-0.5,6.5);
      AddHistogram(Hist.fEvntMetPhi_b[i],Folder);
      if(i<3)
	{
	  sprintf(name,"SumEt_b[%i]",i);
	  sprintf(title,"#sum E_{T}_%i",i);
	  Hist.fEvntSumEt_b[i]=new TH1F(name,title,2000,0.0,2000.0);
	  AddHistogram(Hist.fEvntSumEt_b[i],Folder);
	}
      sprintf(name,"MetVsNvx_b[%i]",i);
      sprintf(title,"MEt_%i vs N_{vx}",i);
      Hist.fEvntMetVsNvx_b[i]=new TProfile(name,title,50,-0.5,49.5,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsNvx_b[i],Folder);
      sprintf(name,"MetVsLum_b[%i]",i);
      sprintf(title,"MEt_%i vs Lum",i);
      Hist.fEvntMetVsLum_b[i]=new TProfile(name,title,40,0.0,200.0,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsLum_b[i],Folder);
      sprintf(name,"MetVsSumEt_b[%i]",i);
      sprintf(title,"MEt_%i vs #sum E_{T}",i);
      Hist.fEvntMetVsSumEt_b[i]=new TProfile(name,title,400,0.0,2000.0,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsSumEt_b[i],Folder);
      sprintf(name,"MetVsPhi_b[%i]",i);
      sprintf(title,"MEt_%i vs #phi",i);
      Hist.fEvntMetVsPhi_b[i]=new TProfile(name,title,70,-0.5,6.5,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsPhi_b[i],Folder);
      sprintf(name,"MetXVsMetY_b[%i]",i);
      sprintf(title,"|MEtX_%i| vs |MetY_%i|",i,i);
      Hist.fEvntMetXVsMetY_b[i]=new TProfile(name,title,500,0.0,1000.0,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetXVsMetY_b[i],Folder);

  //__________________________________ after cuts
      sprintf(name,"Met_a[%i]",i);
      sprintf(title,"MEt_%i",i);
      Hist.fEvntMet_a[i]=new TH1F(name,title,1000,0.0,1000.0);
      AddHistogram(Hist.fEvntMet_a[i],Folder);
      sprintf(name,"MetX_a[%i]",i);
      sprintf(title,"MEt_%i, x-projection",i);
      Hist.fEvntMetX_a[i]=new TH1F(name,title,1000,-500.0,500.0);
      AddHistogram(Hist.fEvntMetX_a[i],Folder);
      sprintf(name,"MetY_a[%i]",i);
      sprintf(title,"MEt_%i, y-projection",i);
      Hist.fEvntMetY_a[i]=new TH1F(name,title,1000,-500.0,500.0);
      AddHistogram(Hist.fEvntMetY_a[i],Folder);
      sprintf(name,"MetPhi_a[%i]",i);
      sprintf(title,"#phi of MEt_%i",i);
      Hist.fEvntMetPhi_a[i]=new TH1F(name,title,140,-0.5,6.5);
      AddHistogram(Hist.fEvntMetPhi_a[i],Folder);
      if(i<3)
	{
	  sprintf(name,"SumEt_a[%i]",i);
	  sprintf(title,"#sum E_{T}_%i",i);
	  Hist.fEvntSumEt_a[i]=new TH1F(name,title,2000,0.0,2000.0);
	  AddHistogram(Hist.fEvntSumEt_a[i],Folder);
	}
      sprintf(name,"MetVsNvx_a[%i]",i);
      sprintf(title,"MEt_%i vs N_{vx}",i);
      Hist.fEvntMetVsNvx_a[i]=new TProfile(name,title,50,-0.5,49.5,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsNvx_a[i],Folder);
      sprintf(name,"MetVsLum_a[%i]",i);
      sprintf(title,"MEt_%i vs Lum",i);
      Hist.fEvntMetVsLum_a[i]=new TProfile(name,title,40,0.0,200.0,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsLum_a[i],Folder);
      sprintf(name,"MetVsSumEt_a[%i]",i);
      sprintf(title,"MEt_%i vs #sum E_{T}",i);
      Hist.fEvntMetVsSumEt_a[i]=new TProfile(name,title,400,0.0,2000.0,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsSumEt_a[i],Folder);
      sprintf(name,"MetVsPhi_a[%i]",i);
      sprintf(title,"MEt_%i vs #phi",i);
      Hist.fEvntMetVsPhi_a[i]=new TProfile(name,title,70,-0.5,6.5,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetVsPhi_a[i],Folder);
      sprintf(name,"MetXVsMetY_a[%i]",i);
      sprintf(title,"|MEtX_%i| vs |MetY_%i|",i,i);
      Hist.fEvntMetXVsMetY_a[i]=new TProfile(name,title,500,0.0,1000.0,-1.0,1000.0);
      AddHistogram(Hist.fEvntMetXVsMetY_a[i],Folder);
    }
  return;
}

void TMyEventFilterModule::FillMetHistogramsB(MetHist_t& Hist) {

  //++++++++++++++++++++++++++++ before cuts
  Hist.fEvntMet4VsNmu_b->Fill(fNMuon,outMet[4]);
  if(fmyNvx12==1)
    {
      Hist.fEvntMet4VsRun_b->Fill(GetHeaderBlock()->RunNumber(),outMet[4]);
      Hist.fEvntMet4XVsRun_b->Fill(GetHeaderBlock()->RunNumber(),outMet[4]*cos(outMetPhi[4]));
      Hist.fEvntMet4YVsRun_b->Fill(GetHeaderBlock()->RunNumber(),outMet[4]*sin(outMetPhi[4]));
      Hist.fEvntMet3VsRun_b->Fill(GetHeaderBlock()->RunNumber(),outMet[3]);
      Hist.fEvntMet3XVsRun_b->Fill(GetHeaderBlock()->RunNumber(),outMet[3]*cos(outMetPhi[3]));
      Hist.fEvntMet3YVsRun_b->Fill(GetHeaderBlock()->RunNumber(),outMet[3]*sin(outMetPhi[3]));
      Hist.fEvntSumet2VsRun_b->Fill(GetHeaderBlock()->RunNumber(),outSumEt[2]);
      Hist.fEvntMet4_2VsRun_b->Fill(GetHeaderBlock()->RunNumber(),pow(outMet[4],2.0));
      Hist.fEvntMet4X_2VsRun_b->Fill(GetHeaderBlock()->RunNumber(),pow(outMet[4]*cos(outMetPhi[4]),2.0));
      Hist.fEvntMet4Y_2VsRun_b->Fill(GetHeaderBlock()->RunNumber(),pow(outMet[4]*sin(outMetPhi[4]),2.0));
      Hist.fEvntSumet2_2VsRun_b->Fill(GetHeaderBlock()->RunNumber(),pow(outSumEt[2],2.0));
      Hist.fEvntMet4nvx1VsLum_b->Fill(fLum,outMet[4]);
    }

  for(int i=0; i<5; i++)
    {
      Hist.fEvntMet_b[i]->Fill(outMet[i]); 
      Hist.fEvntMetPhi_b[i]->Fill(outMetPhi[i]); 
      Hist.fEvntMetX_b[i]->Fill(outMet[i]*cos(outMetPhi[i]));
      Hist.fEvntMetY_b[i]->Fill(outMet[i]*sin(outMetPhi[i]));
      if(i<3) Hist.fEvntSumEt_b[i]->Fill(outSumEt[i]);
    
      Hist.fEvntMetVsNvx_b[i]->Fill(vx_num,outMet[i]);
      Hist.fEvntMetVsLum_b[i]->Fill(fLum,outMet[i]);
      if(i<2) Hist.fEvntMetVsSumEt_b[i]->Fill(outSumEt[i],outMet[i]); 
      else Hist.fEvntMetVsSumEt_b[i]->Fill(outSumEt[2],outMet[i]);
      Hist.fEvntMetVsPhi_b[i]->Fill(outMetPhi[i],outMet[i]); 
      Hist.fEvntMetXVsMetY_b[i]->Fill(fabs(outMet[i]*sin(outMetPhi[i])),
				      fabs(outMet[i]*cos(outMetPhi[i])));
    }

  return;
}

void TMyEventFilterModule::FillMetHistogramsA(MetHist_t& Hist) {
  //++++++++++++++++++++++++++++ after cuts
  Hist.fEvntMet4VsNmu_a->Fill(fNMuon,outMet[4]);
  if(fmyNvx12==1)
    {
      Hist.fEvntMet4VsRun_a->Fill(GetHeaderBlock()->RunNumber(),outMet[4]);
      Hist.fEvntMet4XVsRun_a->Fill(GetHeaderBlock()->RunNumber(),outMet[4]*cos(outMetPhi[4]));
      Hist.fEvntMet4YVsRun_a->Fill(GetHeaderBlock()->RunNumber(),outMet[4]*sin(outMetPhi[4]));
      Hist.fEvntMet3VsRun_a->Fill(GetHeaderBlock()->RunNumber(),outMet[3]);
      Hist.fEvntMet3XVsRun_a->Fill(GetHeaderBlock()->RunNumber(),outMet[3]*cos(outMetPhi[3]));
      Hist.fEvntMet3YVsRun_a->Fill(GetHeaderBlock()->RunNumber(),outMet[3]*sin(outMetPhi[3]));
      Hist.fEvntSumet2VsRun_a->Fill(GetHeaderBlock()->RunNumber(),outSumEt[2]);
      Hist.fEvntMet4_2VsRun_a->Fill(GetHeaderBlock()->RunNumber(),pow(outMet[4],2.0));
      Hist.fEvntMet4X_2VsRun_a->Fill(GetHeaderBlock()->RunNumber(),pow(outMet[4]*cos(outMetPhi[4]),2.0));
      Hist.fEvntMet4Y_2VsRun_a->Fill(GetHeaderBlock()->RunNumber(),pow(outMet[4]*sin(outMetPhi[4]),2.0));
      Hist.fEvntSumet2_2VsRun_a->Fill(GetHeaderBlock()->RunNumber(),pow(outSumEt[2],2.0));
      Hist.fEvntMet4nvx1VsLum_a->Fill(fLum,outMet[4]);
    }

  for(int i=0; i<5; i++)
    {
      Hist.fEvntMet_a[i]->Fill(outMet[i]); 
      Hist.fEvntMetPhi_a[i]->Fill(outMetPhi[i]); 
      Hist.fEvntMetX_a[i]->Fill(outMet[i]*cos(outMetPhi[i]));
      Hist.fEvntMetY_a[i]->Fill(outMet[i]*sin(outMetPhi[i]));
      if(i<3) Hist.fEvntSumEt_a[i]->Fill(outSumEt[i]);
    
      Hist.fEvntMetVsNvx_a[i]->Fill(vx_num,outMet[i]);
      Hist.fEvntMetVsLum_a[i]->Fill(fLum,outMet[i]);
      if(i<2) Hist.fEvntMetVsSumEt_a[i]->Fill(outSumEt[i],outMet[i]); 
      else Hist.fEvntMetVsSumEt_a[i]->Fill(outSumEt[2],outMet[i]);
      Hist.fEvntMetVsPhi_a[i]->Fill(outMetPhi[i],outMet[i]); 
      Hist.fEvntMetXVsMetY_a[i]->Fill(fabs(outMet[i]*sin(outMetPhi[i])),
				      fabs(outMet[i]*cos(outMetPhi[i])));
    }
  return;
}

//________ creates a list of towers for all jets
void TMyEventFilterModule::MatchCalorTowers(TStnJet* jet,
					    TStnJetBlock* fJetBlock,
					    TCalDataBlock *fCalDataBlock,
					    CalDataArray* cdholder) {
  cdholder->clear();
  TStnLinkBlock* links = fJetBlock->TowerLinkList();
  int nptow = links->NLinks(jet->Number());

  TCalTower* ctower = NULL;
  for(int j=0; j<nptow; j++) 
    {
      int iptow = links->Index(jet->Number(),j);
      int iphi = iptow & 0x3F;
      int ieta = (iptow>>8) & 0x3F;
      
      ctower = fCalDataBlock->Tower(ieta,iphi);
      cdholder->push_back(ctower);
    }

  std::sort(cdholder->begin(), cdholder->end(),SortTowersByEnergy);
  
  return;
}

//________ creates a list of towers for all EM objects
void TMyEventFilterModule::MatchCalorTowers(int pho_ind,
					    TStnPhotonBlock* fPhotonBlock,
					    TCalDataBlock *fCalDataBlock,
					    CalDataArray* cdholder) {
  cdholder->clear();
  TStnLinkBlock* links = fPhotonBlock->TowerLinkList();
  int nptow = links->NLinks(pho_ind);
  TCalTower* ctower = NULL;
  for(int j=0; j<nptow; j++) 
    {
      int iptow = links->Index(pho_ind,j);
      int iphi = iptow & 0x3F;
      int ieta = (iptow>>8) & 0x3F;
      
      ctower = fCalDataBlock->Tower(ieta,iphi);
      cdholder->push_back(ctower);
    }
  
  std::sort(cdholder->begin(),cdholder->end(),SortTowersByEnergy);
  
  return;
}

//___ finds sipkes, fills histo, returns spike Et  
int TMyEventFilterModule::FindPmtSpikes(CalDataArray* towers, double& EmESpike, double& HadESpike, double& spikeHadTdc, CalHist_t& Hist) {

  int spike_code=0;

  CalDataArrayI tti;
  EmESpike = 0.0;
  HadESpike = 0.0;
  spikeHadTdc = -1.0E6;
  for(tti = towers->begin(); tti != towers->end(); tti++)
    {
      TCalTower* calt = *tti;
      int iEta = calt->IEta();
      int iPhi = calt->IPhi();
      if(fabs(1.0*towerInd(iEta)) > 11) continue; // cover all 2-pmt towers

      int good_CEMtower=0; // should be ZERO for MY good towers 
      int good_CHAtower=0; // should be ZERO for MY good towers 
      int good_WHAtower=0; // should be ZERO for MY good towers 
      float asymCEM=-10.0;
      float asymCHAD=-10.0;
      float asymWHAD=-10.0;
      float pmt0 = 0.0;
      float pmt1 = 0.0;
      float cha_TDC = -1.0E6;
      float wha_TDC = -1.0E6;

      if(abs(towerInd(iEta)) <= 5)
	{
	  pmt0 = calt->EmPmt(0);
	  pmt1 = calt->EmPmt(1);
	  if(pmt0+pmt1 > 200) asymCEM = (pmt0-pmt1)/(pmt0+pmt1);	    
	  pmt0 = calt->HadPmt(0);
	  pmt1 = calt->HadPmt(1);
	  cha_TDC = calt->HadTdc(0);
	  if(pmt0+pmt1 > 200) asymCHAD = (pmt0-pmt1)/(pmt0+pmt1);	    
	}
      if(abs(towerInd(iEta)) > 5 && abs(towerInd(iEta)) <= 7)
	{
	  pmt0 = calt->EmPmt(0);
	  pmt1 = calt->EmPmt(1);
	  if(pmt0+pmt1 > 200) asymCEM = (pmt0-pmt1)/(pmt0+pmt1);	
	  pmt0 = calt->HadPmt(0);
	  pmt1 = calt->HadPmt(1);
	  cha_TDC = calt->HadTdc(0);		  
	  if(pmt0+pmt1 > 200) asymCHAD = (pmt0-pmt1)/(pmt0+pmt1);	    
	  pmt0 = calt->HadPmt(2);
	  pmt1 = calt->HadPmt(3);
	  wha_TDC = calt->HadTdc(1);
	  if(pmt0+pmt1 > 200) asymWHAD = (pmt0-pmt1)/(pmt0+pmt1);	    
	}     
      if(abs(towerInd(iEta)) > 7 && abs(towerInd(iEta)) <=9)
	{
	  pmt0 = calt->EmPmt(0);
	  pmt1 = calt->EmPmt(1);
	  if(pmt0+pmt1 > 200) asymCEM = (pmt0-pmt1)/(pmt0+pmt1);	    
	  pmt0 = calt->HadPmt(0);
	  pmt1 = calt->HadPmt(1);
	  wha_TDC = calt->HadTdc(1);
	  if(pmt0+pmt1 > 200) asymWHAD = (pmt0-pmt1)/(pmt0+pmt1);	    
	}
      if(abs(towerInd(iEta)) == 10)
	{
	  pmt0 = calt->HadPmt(0);
	  pmt1 = calt->HadPmt(1);
	  wha_TDC = calt->HadTdc(1);
	  if(pmt0+pmt1 > 200) asymWHAD = (pmt0-pmt1)/(pmt0+pmt1);	    
	}
      if(abs(towerInd(iEta)) == 11)
	{
	  pmt0 = calt->HadPmt(2);
	  pmt1 = calt->HadPmt(3);
	  wha_TDC = calt->HadTdc(1);
	  if(pmt0+pmt1 > 200) asymWHAD = (pmt0-pmt1)/(pmt0+pmt1);	    
	}     
      float EmEng=calt->EmEnergy();
      float HadEng=calt->HadEnergy();

      float twrEmEt = EmEng*fabs(sin(calt->Theta()*TMath::Pi()/180.0));
      float twrHadEt = HadEng*fabs(sin(calt->Theta()*TMath::Pi()/180.0));
      float twrEmPhi = calt->Phi();
      float twrHadPhi = calt->Phi();
      float dphimetEM = -1.0*TMath::Pi()/2.0;
      float dphimetHAD = -1.0*TMath::Pi()/2.0;
      float metEM=-1.0;
      float metHAD=-1.0;
      if(twrEmEt>0.0) 
	{
	  metEM=fMetBlock->Met(0)/twrEmEt;
	  dphimetEM=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(twrEmPhi)-TVector2::Phi_0_2pi(fMetBlock->MetPhi(0))));
	}
      if(twrHadEt>0.0) 
	{
	  metHAD=fMetBlock->Met(0)/twrHadEt;
	  dphimetHAD=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(twrHadPhi)-TVector2::Phi_0_2pi(fMetBlock->MetPhi(0))));
	}

      if(fabs(asymCEM)<=1.0)
	{
	  for(int ik=0; ik<badEmTwr.size(); ik++)
	    {
	      if(towerInd(iEta)==badEmTwr[ik].etaI && iPhi==badEmTwr[ik].phiI) 
		{
		  good_CEMtower++;
		  if(EmEng>10.0) Hist.fCalPmtEmAssm_bad->Fill(asymCEM);
		  Hist.fCalPmtAssmVsRun[badEmTwr[ik].histoI]->Fill(GetHeaderBlock()->RunNumber(),asymCEM);
		  if(fabs(asymCEM)>0.55 && EmEng>fMinEmPmtE)
		    {
		      Hist.fCalBad_dPhi[badEmTwr[ik].histoI]->Fill(dphimetEM);
		      Hist.fCalBad_MetRatio[badEmTwr[ik].histoI]->Fill(metEM);
		    }
		  break;
		}
	    }

	  if(good_CEMtower==0)
	    {
	      if(EmEng<10.0) 
		{
		  Hist.fCalPmtEmAssm_le10->Fill(asymCEM);
		  Hist.fCalPmtCemAssm_le10->Fill(asymCEM);
		}
	      else 
		{
		  Hist.fCalPmtEmAssm_ge10->Fill(asymCEM);
		  Hist.fCalPmtCemAssm_ge10->Fill(asymCEM);
		}
	      Hist.fCalEmPmtAssm_vs_PmtSum->Fill(asymCEM,EmEng);
	    }
 	  if(fabs(asymCEM)>fMinEmPMTasym && fabs(asymCEM)<=fMaxEmPMTasym && EmEng>fMinEmPmtE)
// 	  if(fabs(asymCEM)>0.5 && fabs(asymCEM)<=1.0 && EmEng>10.0)
//  	  if(fabs(asymCEM)>0.55 && fabs(asymCEM)<0.85 && EmEng>10.0)
//  	  if(asymCEM>0.55 && asymCEM<0.85 && EmEng>10.0)
//  	  if(asymCEM>-0.85 && asymCEM<-0.65 && EmEng>10.0)
	    {
	      spike_code++;
	      EmESpike+=EmEng; // does it make sense to sum up energy for spikes?
	      Hist.fCalEMtwr->Fill(towerInd(iEta),iPhi);
	      Hist.fCalEm_dPhi->Fill(dphimetEM);
	      Hist.fCalEm_MetRatio->Fill(metEM);
	    }
	}
      if(fabs(asymCHAD)<=1.0)
	{
	  for(int ik=0; ik<badHadTwr.size(); ik++)
	    {
	      if(towerInd(iEta)==badHadTwr[ik].etaI && iPhi==badHadTwr[ik].phiI) 
		{
		  good_CHAtower++;
		  Hist.fCalPmtAssmVsRun[badHadTwr[ik].histoI]->Fill(GetHeaderBlock()->RunNumber(),asymCHAD);
		  if((GetHeaderBlock()->RunNumber())>badHadTwr[ik].run1 && (GetHeaderBlock()->RunNumber())<badHadTwr[ik].run2) 
		    {
		      if(HadEng>10.0) Hist.fCalPmtHadAssm_bad->Fill(asymCHAD);
		      if(fabs(asymCHAD)>0.55 && HadEng>fMinHadPmtE)
			{
			  Hist.fCalBad_dPhi[badHadTwr[ik].histoI]->Fill(dphimetHAD);
			  Hist.fCalBad_MetRatio[badHadTwr[ik].histoI]->Fill(metHAD);
			}
		    }
		  break;
		}
	    }

	  if(good_CHAtower==0)
	    {
	      if(HadEng<10.0) 
		{
		  Hist.fCalPmtHadAssm_le10->Fill(asymCHAD);
		  if(abs(towerInd(iEta))<6) Hist.fCalPmtChaAssm_le10->Fill(asymCHAD);
		  else Hist.fCalPmtChaAssm_overlap_le10->Fill(asymCHAD);
		}
	      else 
		{
		  Hist.fCalPmtHadAssm_ge10->Fill(asymCHAD);
		  if(abs(towerInd(iEta))<6) Hist.fCalPmtChaAssm_ge10->Fill(asymCHAD);
		  else Hist.fCalPmtChaAssm_overlap_ge10->Fill(asymCHAD);
		  if(fabs(cha_TDC)<40.0) Hist.fCalPmtHadAssm_ge10_intime->Fill(asymCHAD);
		  if(fabs(cha_TDC)>40.0 && fabs(cha_TDC)<80.0) Hist.fCalPmtHadAssm_ge10_outtime->Fill(asymCHAD);
		}
	      Hist.fCalHadPmtAssm_vs_PmtSum->Fill(asymCHAD,HadEng);
	    }
 	  if(fabs(asymCHAD)>fMinHadPMTasym && fabs(asymCHAD)<=fMaxHadPMTasym && HadEng>fMinHadPmtE)
// 	  if(fabs(asymCHAD)>0.5 && fabs(asymCHAD)<=1.0 && HadEng>10.0)
	    {
	      spike_code++;
	      HadESpike+=HadEng; // does it make sense to sum up energy for spikes?
	      spikeHadTdc=cha_TDC;
	      Hist.fCalHadTDCspike->Fill(cha_TDC); // timing of HAD spikes;
	      Hist.fCalCHAtwr->Fill(towerInd(iEta),iPhi);
	      Hist.fCalHad_dPhi->Fill(dphimetHAD);
	      Hist.fCalHad_MetRatio->Fill(metHAD);
	    }
	}
      if(fabs(asymWHAD)<=1.0)
	{
	  for(int ik=0; ik<badHadTwr.size(); ik++)
	    {
	      if(towerInd(iEta)==badHadTwr[ik].etaI && iPhi==badHadTwr[ik].phiI) 
		{
		  good_WHAtower++; 
		  Hist.fCalPmtAssmVsRun[badHadTwr[ik].histoI]->Fill(GetHeaderBlock()->RunNumber(),asymWHAD);
		  if((GetHeaderBlock()->RunNumber())>badHadTwr[ik].run1 && (GetHeaderBlock()->RunNumber())<badHadTwr[ik].run2) 
		    {
		      if(HadEng>10.0) Hist.fCalPmtHadAssm_bad->Fill(asymWHAD);
		      if(fabs(asymWHAD)>0.55 && HadEng>fMinHadPmtE)
			{
			  Hist.fCalBad_dPhi[badHadTwr[ik].histoI]->Fill(dphimetHAD);
			  Hist.fCalBad_MetRatio[badHadTwr[ik].histoI]->Fill(metHAD);
			}
		    }
		  break;
		}
	    }

	  if(good_WHAtower==0)
	    {
	      if(HadEng<10.0) 
		{
		  Hist.fCalPmtHadAssm_le10->Fill(asymWHAD);
		  if(abs(towerInd(iEta))>7 && abs(towerInd(iEta))<11) Hist.fCalPmtWhaAssm_le10->Fill(asymWHAD);
		  else Hist.fCalPmtWhaAssm_overlap_le10->Fill(asymWHAD);
		}
	      else 
		{
		  Hist.fCalPmtHadAssm_ge10->Fill(asymWHAD);
		  if(abs(towerInd(iEta))>7 && abs(towerInd(iEta))<11) Hist.fCalPmtWhaAssm_ge10->Fill(asymWHAD);
		  else Hist.fCalPmtWhaAssm_overlap_ge10->Fill(asymWHAD);
		  if(fabs(wha_TDC)<40.0) Hist.fCalPmtHadAssm_ge10_intime->Fill(asymWHAD);
		  if(fabs(wha_TDC)>40.0 && fabs(wha_TDC)<80.0) Hist.fCalPmtHadAssm_ge10_outtime->Fill(asymWHAD);	      
		}
	      Hist.fCalHadPmtAssm_vs_PmtSum->Fill(asymWHAD,HadEng);
	    }
	  if(fabs(asymWHAD)>fMinHadPMTasym && fabs(asymWHAD)<=fMaxHadPMTasym && HadEng>fMinHadPmtE)
// 	  if(fabs(asymWHAD)>0.5 && fabs(asymWHAD)<=1.0 && HadEng>10.0)
	    {
	      spike_code++;
	      HadESpike+=HadEng; // does it make sense to sum up energy for spikes?
	      spikeHadTdc=wha_TDC;
	      Hist.fCalHadTDCspike->Fill(wha_TDC); // timing of HAD spikes;
	      Hist.fCalWHAtwr->Fill(towerInd(iEta),iPhi);
	      Hist.fCalHad_dPhi->Fill(dphimetHAD);
	      Hist.fCalHad_MetRatio->Fill(metHAD);
	    }
	}
    }
  return spike_code;
}

//_________________________________ for spike studies: checks if there are "good" jets and returns their indices
int TMyEventFilterModule::MyGoodJet(TStnJetBlock* fJetBlock, int& jet1_ind, int& jet2_ind) {
  int passcode=0;
  jet1_ind=-1;
  jet2_ind=-1;
  if(fJetBlock->NJets()<2) return 0;
  else
    {
      for(int i=0; i < 2; i++) // loops over two leading jets only
	{
	  TStnJet* _jet=fJetBlock->Jet(i);
	  if(_jet->EmFract()<0.1) return 0; // removing HAD spike candidates
	  if(_jet->EmFract()>0.9) return 0; // removing EM spike candidates and EM objects
	  if(fabs(_jet->DetEta())<1.3 && (_jet->NTracks())<2) return 0;
	}
      double dphi=fabs(TVector2::Phi_mpi_pi((fJetBlock->Jet(0)->Phi())-(fJetBlock->Jet(1)->Phi())));
      double bal=fabs(((fJetBlock->Jet(0)->Et())-(fJetBlock->Jet(1)->Et()))/((fJetBlock->Jet(0)->Et())+(fJetBlock->Jet(1)->Et())));
      if(dphi<2.7) return 0;
      if(bal>0.3) return 0;
      jet1_ind=0;
      jet2_ind=1;
      passcode=1;
    }
  return passcode;
}


// //_________________________________ for spike studies: checks if there is a "bad" jet and returns its index
// int TMyEventFilterModule::MyBadJet(TStnJetBlock* fJetBlock, TStnMetBlock* fMet_Block, int& jet_ind) {
//   int passcode=0;
//   jet_ind=-1;
//   if(fNMuon>0) return 0;
//   for(int i=0; i < fJetBlock->NJets(); i++) // loops over jets
//     {
//       TStnJet* _jet=fJetBlock->Jet(i);
//       if(_jet->EmFract()>0.1) continue;
//       if(fabs(_jet->DetEta())<1.3 && (_jet->NTracks())>1) continue;
//       if(fabs(_jet->DetEta())>1.3) continue;
//       if((_jet->NTowers())>3) continue;
//       double seedEt_frac=(_jet->SeedEt())/(_jet->Et());
//       if(seedEt_frac<0.8) continue;
//       double trkPt_frac=(_jet->MaxTrackPt())/(_jet->Et());
//       if(trkPt_frac>0.2) continue;
//       double dphimet=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(_jet->Phi())-TVector2::Phi_0_2pi(fMet_Block->MetPhi(4))));
//       if(dphimet<2.7) continue;
//       double metbal=(fMet_Block->Met(4))/(_jet->Et());
//       if(metbal<0.8 || metbal>1.2) continue;
//       jet_ind=i;
//       for(int j=0; j < fJetBlock->NJets(); j++) // checking dPhi
// 	{
// 	  if(j!=jet_ind) 
// 	    {
// 	      double dphi=fabs(TVector2::Phi_mpi_pi((fJetBlock->Jet(jet_ind)->Phi())-(fJetBlock->Jet(j)->Phi())));
// 	      if(dphi>2.7) 
// 		{
// 		  jet_ind=-1;
// 		  return 0;
// 		}
// 	    }
// 	}
//       passcode=1;
//       break;
//     }
//   return passcode;
// }

//_________________________________ for spike studies: checks if there is a "bad" jet and returns its index
int TMyEventFilterModule::MyBadJet(TStnJetBlock* fJetBlock, TStnMetBlock* fMet_Block, int& jet_ind) {
  int passcode=0;
  jet_ind=-1;
  if(fNMuon>0) return 0;
  for(int i=0; i < fJetBlock->NJets(); i++) // loops over jets
    {
      TStnJet* _jet=fJetBlock->Jet(i);
      if(_jet->EmFract()>0.1) continue;
//       if(fabs(_jet->DetEta())<1.3 && (_jet->NTracks())>1) continue;
//       if(fabs(_jet->DetEta())>1.3) continue;
//       if((_jet->NTowers())>3) continue;
//       double seedEt_frac=(_jet->SeedEt())/(_jet->Et());
//       if(seedEt_frac<0.8) continue;
//       double trkPt_frac=(_jet->MaxTrackPt())/(_jet->Et());
//       if(trkPt_frac>0.2) continue;
      double dphimet=fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(_jet->Phi())-TVector2::Phi_0_2pi(fMet_Block->MetPhi(4))));
      if(dphimet<2.7) continue;
      double metbal=(fMet_Block->Met(4))/(_jet->Et());
      if(metbal<0.8 || metbal>1.2) continue;
      jet_ind=i;
//       for(int j=0; j < fJetBlock->NJets(); j++) // checking dPhi
// 	{
// 	  if(j!=jet_ind) 
// 	    {
// 	      double dphi=fabs(TVector2::Phi_mpi_pi((fJetBlock->Jet(jet_ind)->Phi())-(fJetBlock->Jet(j)->Phi())));
// 	      if(dphi>2.7) 
// 		{
// 		  jet_ind=-1;
// 		  return 0;
// 		}
// 	    }
// 	}
      passcode=1;
      break;
    }
  return passcode;
}


//________ does all my cal stuff
void TMyEventFilterModule::DoMyCalStuff(TStnJetBlock* fJetBlock,TStnPhotonBlock* fPhotonBlock,TCalDataBlock *fCalDataBlock,CalHist_t& Hist) {

  int Nspikes=0;
  int Nspikes_g=0;
  int Nspikes_b=0;
  double EmE_spike=0.0;
  double HadE_spike=0.0;
  double HadTdc_spike=-1.0E6;
  int goodjet1=-1;
  int goodjet2=-1;
  int badjet=-1;
  int goodjet_found=MyGoodJet(fJetBlock,goodjet1,goodjet2);
  int badjet_found=MyBadJet(fJetBlock,fMetBlock,badjet);

  //________ looking for spikes in all jets
  for(int i=0; i < fJetBlock->NJets(); i++)
    {
      CalDataArray calholder;
      MatchCalorTowers(fJetBlock->Jet(i),fJetBlock,fCalDataBlock,&calholder);
      Nspikes+=FindPmtSpikes(&calholder,EmE_spike,HadE_spike,HadTdc_spike,Hist);
      if(EmE_spike+HadE_spike>0.0) Hist.fCalEspike->Fill(EmE_spike+HadE_spike);
      if(EmE_spike>0.0) Hist.fCalEmEspike->Fill(EmE_spike);
      if(HadE_spike>0.0) 
	{
	  Hist.fCalHadEspike->Fill(HadE_spike);
	  Hist.fTest_dPhiSpikeMet->Fill(fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(fJetBlock->Jet(i)->Phi())-
								  TVector2::Phi_0_2pi(fMetBlock->MetPhi(4)))));
	  Hist.fTest_SpikeMetRatio->Fill((fMetBlock->Met(4))/(fJetBlock->Jet(i)->Et()));
	  Hist.fTest_Ntwr->Fill(fJetBlock->Jet(i)->NTowers());       
	  Hist.fTest_HadEm->Fill(fJetBlock->Jet(i)->EmFract()); // For had spikes HadEm<->EmFr       	  
	}
      //________ looking for spikes in "good" jets
      if(i<2 && goodjet_found==1 && (goodjet1==i || goodjet2==i))
	{
	  MatchCalorTowers(fJetBlock->Jet(i),fJetBlock,fCalDataBlock,&calholder);
	  Nspikes_g+=FindPmtSpikes(&calholder,EmE_spike,HadE_spike,HadTdc_spike,fCalHist_goodjet);
	  if(EmE_spike+HadE_spike>0.0) fCalHist_goodjet.fCalEspike->Fill(EmE_spike+HadE_spike);
	  if(EmE_spike>0.0) fCalHist_goodjet.fCalEmEspike->Fill(EmE_spike);
	  if(HadE_spike>0.0) 
	    {
	      fCalHist_goodjet.fCalHadEspike->Fill(HadE_spike);
	      fCalHist_goodjet.fTest_dPhiSpikeMet->Fill(fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(fJetBlock->Jet(i)->Phi())-
										  TVector2::Phi_0_2pi(fMetBlock->MetPhi(4)))));
	      fCalHist_goodjet.fTest_SpikeMetRatio->Fill((fMetBlock->Met(4))/(fJetBlock->Jet(i)->Et()));
	      fCalHist_goodjet.fTest_Ntwr->Fill(fJetBlock->Jet(i)->NTowers());       
	      fCalHist_goodjet.fTest_HadEm->Fill(fJetBlock->Jet(i)->EmFract()); // For had spikes HadEm<->EmFr       
	    }
	}
      //________ looking for spikes in "bad" jets
      if(badjet_found==1 && badjet==i)
	{
	  MatchCalorTowers(fJetBlock->Jet(i),fJetBlock,fCalDataBlock,&calholder);
	  Nspikes_b+=FindPmtSpikes(&calholder,EmE_spike,HadE_spike,HadTdc_spike,fCalHist_badjet);
	  if(EmE_spike+HadE_spike>0.0) fCalHist_badjet.fCalEspike->Fill(EmE_spike+HadE_spike);
	  if(EmE_spike>0.0) fCalHist_badjet.fCalEmEspike->Fill(EmE_spike);
	  if(HadE_spike>0.0) 
	    {
	      fCalHist_badjet.fCalHadEspike->Fill(HadE_spike);
	      fCalHist_badjet.fTest_dPhiSpikeMet->Fill(fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(fJetBlock->Jet(i)->Phi())-TVector2::Phi_0_2pi(fMetBlock->MetPhi(4)))));
	      fCalHist_badjet.fTest_SpikeMetRatio->Fill((fMetBlock->Met(4))/(fJetBlock->Jet(i)->Et()));
	      fCalHist_badjet.fTest_Ntwr->Fill(fJetBlock->Jet(i)->NTowers());       
	      fCalHist_badjet.fTest_HadEm->Fill(fJetBlock->Jet(i)->EmFract()); // For had spikes HadEm<->EmFr       
	    }
	}

    }
  Hist.fCalNspike->Fill(Nspikes);
  Nspike_global=Nspikes;
  if(goodjet_found==1 && goodjet1==0 && goodjet2==1) fCalHist_goodjet.fCalNspike->Fill(Nspikes_g);
  if(badjet_found==1) fCalHist_badjet.fCalNspike->Fill(Nspikes_b);

  //________ looking for spikes in EM objects
  Nspikes=0;
  EmE_spike=0.0;   
  HadE_spike=0.0;   
  for(int i=0; i < fPhotonBlock->NPhotons(); i++)
    {
      //________________________________________ new cuts (12/30/05) to select EM objects
      TStnPhoton* Pho=fPhotonBlock->Photon(i);
      if(Pho->Detector()!=0) continue; // remove Plug photons
//       if(fabs(Pho->XCes())<21.0) continue; // removing good clusters
//       if(fabs(Pho->ZCes())>9.0 && fabs(Pho->ZCes())<230.0) continue; // removing good clusters
      if((Pho->Chi2())>20.0) continue; // removing bad clusters
      if(fabs(Pho->XCes())>21.0) continue; // removing bad clusters
      if(fabs(Pho->ZCes())<9.0 || fabs(Pho->ZCes())>230.0) continue; // removing bad clusters
//       if((Pho->CesStripE())/(Pho->Momentum()->E())>0.1) continue;
//       if((Pho->CesWireE())/(Pho->Momentum()->E())>0.1) continue;
      //________________________________________ end of new cuts

      CalDataArray calholder;
      MatchCalorTowers(i,fPhotonBlock,fCalDataBlock,&calholder);
      Nspikes+=FindPmtSpikes(&calholder,EmE_spike,HadE_spike,HadTdc_spike,fCalHist_EMobj);
      if(EmE_spike+HadE_spike>0.0) fCalHist_EMobj.fCalEspike->Fill(EmE_spike+HadE_spike);
      if(EmE_spike>0.0) 
	{
	  fCalHist_EMobj.fCalEmEspike->Fill(EmE_spike);
	  fCalHist_EMobj.fTest_dPhiSpikeMet->Fill(fabs(TVector2::Phi_mpi_pi(TVector2::Phi_0_2pi(Pho->Phi())-TVector2::Phi_0_2pi(fMetBlock->MetPhi(4)))));
	  fCalHist_EMobj.fTest_SpikeMetRatio->Fill((fMetBlock->Met(4))/Pho->Et());
	  fCalHist_EMobj.fTest_Ntwr->Fill(Pho->NTower());       
	  fCalHist_EMobj.fTest_HadEm->Fill(Pho->HadEm());       
	  fCalHist_EMobj.fTest_EwireEspike->Fill(Pho->CesWireE()/EmE_spike);  
	  fCalHist_EMobj.fTest_EstripEspike->Fill(Pho->CesStripE()/EmE_spike); 
	  fCalHist_EMobj.fTest_Chi2->Fill(Pho->Chi2());   
	}
      if(HadE_spike>0.0) fCalHist_EMobj.fCalHadEspike->Fill(HadE_spike);
    }
  fCalHist_EMobj.fCalNspike->Fill(Nspikes);

  return;
}


//_____________________________________________________________________________
int TMyEventFilterModule::BeginJob() {

  goodrun=new TGoodRun();

  if(fUseOldNewGoodRun==1) //___________ new version of goodrun
    {
      if(fUseMyGoodRunList==1) goodrun->Read(fMyGoodRunFile);
      if(fUseMyEventList==1 || fUseExcludeEvent==1) 
	{
	  ifstream file1;
	  int Nrun=0;
	  int Nevent=0;
	  file1.open(fMyEventRunFile);
	  while(file1)
	    {
	      file1>>Nrun>>Nevent;
	      SetMyGoodRunList(Nrun);
	      SetMyEventList(Nrun,Nevent);
	    }
	  file1.close();
	  PrintMyEventList();
	}
    }
  else //_______________________________ old version of goodrun
    {

      if((fUseMyGoodRunList==1 || fUseMyEventList==1) && fUseExcludeEvent==0)
	{
	  //----------- modified part ---------------------
	  ifstream file1;
	  int Nrun=0;
	  int Nevent=0;
	  file1.open(fMyGoodRunFile);
	  if(fUseMyGoodRunList==1 && fUseMyEventList==0)
	    {
	      while (file1)
		{
		  file1>>Nrun;
		  SetMyGoodRunList(Nrun);
		}
	    }
	  if((fUseMyGoodRunList==1 && fUseMyEventList==1) ||
	     (fUseMyGoodRunList==0 && fUseMyEventList==1))
	    {
	      while (file1)
		{
		  file1>>Nrun>>Nevent;
		  SetMyGoodRunList(Nrun);
		  SetMyEventList(Nrun,Nevent);
		}
	    }
	  file1.close();
	}
      
      if(fUseMyGoodRunList==1 && fUseExcludeEvent==1)
	{
	  //----------- modified part ---------------------
	  ifstream file1;
	  ifstream file2;
	  int Nrun=0;
	  int Nevent=0;
	  file1.open(fMyGoodRunFile);
	  while (file1)
	    {
	      file1>>Nrun;
	      SetMyGoodRunList(Nrun);
	    }
	  file1.close();
	  file2.open(fMyExcludeEventFile);
	  while (file2)
	    {
	      file2>>Nrun>>Nevent;
	      SetMyGoodRunList(Nrun);
	      SetMyEventList(Nrun,Nevent);
	    }
	  file2.close();
	  //_______________ end of modified part ___________________ 
	}
    }

				// register the data block
  RegisterDataBlock("CalDataBlock" ,"TCalDataBlock"    ,&fCalData);
  RegisterDataBlock("ZVertexBlock" ,"TStnVertexBlock"  ,&fZVertexBlock); // ZVertex Collection 
  if(fJetType==0) RegisterDataBlock("JetBlock","TStnJetBlock",&fJetBlockClu04);// registring JetClue04
  if(fJetType==1) RegisterDataBlock("PROD@JetCluModule-cone0.7","TStnJetBlock",&fJetBlockClu07);
  if(fJetType==2) RegisterDataBlock("PROD@JetCluModule-cone1.0","TStnJetBlock",&fJetBlockClu10);
  if(fJetType==3) RegisterDataBlock("PROD@MidPointModule-cone0.4","TStnJetBlock",&fJetBlockMid04);
  if(fJetType==4) RegisterDataBlock("PROD@MidPointModule-cone0.7","TStnJetBlock",&fJetBlockMid07);
  if(fJetType==5) RegisterDataBlock("PROD@MidPointModule-cone1.0","TStnJetBlock",&fJetBlockMid10);
//   if(fJetType==6) RegisterDataBlock("PROD@KtClusModule-cone0.4","TStnJetBlock",&fJetBlockKt04);
//   if(fJetType==7) RegisterDataBlock("PROD@KtClusModule-cone0.7","TStnJetBlock",&fJetBlockKt07);
//   if(fJetType==8) RegisterDataBlock("PROD@KtClusModule-cone1.0","TStnJetBlock",&fJetBlockKt10);
  RegisterDataBlock("MetBlock"     ,"TStnMetBlock"     ,&fMetBlock);
  RegisterDataBlock("TriggerBlock"  ,"TStnTriggerBlock" ,&fTriggerBlock);
  RegisterDataBlock("PhotonBlock" ,"TStnPhotonBlock",&fPhotonBlock );

					// book histograms
  BookHistograms();

  //_____________________________ creating a list of BAD EM towers
  BadTower _twr;
  _twr.phiI=0;
  _twr.etaI=2;
  _twr.histoI=0;
  _twr.run1=-1;
  _twr.run2=-1;
  badEmTwr.push_back(_twr);
  _twr.phiI=4;
  _twr.etaI=8;
  _twr.histoI=1;
  _twr.run1=-1;
  _twr.run2=-1;
  badEmTwr.push_back(_twr);
  _twr.phiI=4;
  _twr.etaI=7;
  _twr.histoI=2;
  _twr.run1=-1;
  _twr.run2=-1;
  badEmTwr.push_back(_twr);
  _twr.phiI=23;
  _twr.etaI=3;
  _twr.histoI=3;
  _twr.run1=-1;
  _twr.run2=-1;
  badEmTwr.push_back(_twr);
  //_____________________________ creating a list of BAD HAD towers
  _twr.phiI=2;
  _twr.etaI=-11;
  _twr.histoI=4;
  _twr.run1=182800;
  _twr.run2=186600;
  badHadTwr.push_back(_twr);
  _twr.phiI=0;
  _twr.etaI=-10;
  _twr.histoI=5;
  _twr.run1=164600;
  _twr.run2=169000;
  badHadTwr.push_back(_twr);
  _twr.phiI=23;
  _twr.etaI=-1;
  _twr.histoI=6;
  _twr.run1=138500;
  _twr.run2=156500;
  badHadTwr.push_back(_twr);
  _twr.phiI=5;
  _twr.etaI=7;
  _twr.histoI=7;
  _twr.run1=138000;
  _twr.run2=188000;
  badHadTwr.push_back(_twr);
  _twr.phiI=5;
  _twr.etaI=6;
  _twr.histoI=8;
  _twr.run1=138000;
  _twr.run2=188000;
  badHadTwr.push_back(_twr);
  _twr.phiI=22;
  _twr.etaI=8;
  _twr.histoI=9;
  _twr.run1=160500;
  _twr.run2=164500;
  badHadTwr.push_back(_twr);
  _twr.phiI=1;
  _twr.etaI=9;
  _twr.histoI=10;
  _twr.run1=152400;
  _twr.run2=154400;
  badHadTwr.push_back(_twr);
  _twr.phiI=12;
  _twr.etaI=10;
  _twr.histoI=11;
  _twr.run1=151200;
  _twr.run2=156600;
  badHadTwr.push_back(_twr);
//   _twr.phiI=11;
//   _twr.etaI=-7;
//   _twr.histoI=12;
//   badHadTwr.push_back(_twr);
//   _twr.phiI=12;
//   _twr.etaI=-7;
//   _twr.histoI=13;
//   badHadTwr.push_back(_twr);
//   _twr.phiI=7;
//   _twr.etaI=7;
//   _twr.histoI=14;
//   badHadTwr.push_back(_twr);
//   _twr.phiI=9;
//   _twr.etaI=7;
//   _twr.histoI=15;
//   badHadTwr.push_back(_twr);
//   _twr.phiI=10;
//   _twr.etaI=7;
//   _twr.histoI=16;
//   badHadTwr.push_back(_twr);
//   _twr.phiI=14;
//   _twr.etaI=7;
//   _twr.histoI=17;
//   badHadTwr.push_back(_twr);
//   _twr.phiI=19;
//   _twr.etaI=7;
//   _twr.histoI=18;
//   badHadTwr.push_back(_twr);

  return 0;
}


//_____________________________________________________________________________
int TMyEventFilterModule::BeginRun() {

  passGlobal = true;
//  std::cout<<"_____TMyEventFilterModule::BeginRun ===>  Starting run "
//	   <<GetHeaderBlock()->RunNumber()<<std::endl;
  int passrun=1;
  
  if(fUseOldNewGoodRun==1) passrun=MyGoodRunFlag(GetHeaderBlock()->RunNumber(),GetHeaderBlock()->SectionNumber()); 
  else passrun=MyGoodRunFlag(GetHeaderBlock()->RunNumber());

//   if(MyGoodRunFlag(GetHeaderBlock()->RunNumber())!=1)
  if(passrun!=1)
    {
      passGlobal = false;
      std::cout<<"________ ATTN!!! Run "<<(GetHeaderBlock()->RunNumber())
	       <<" didn't pass GoodRun cut"<<std::endl;
      SetPassed(0);
    }
  dbm=TStnDBManager::Instance();
  tt=(TStnTriggerTable*) dbm->GetTable("TriggerTable");

  return 0;
}

//_____________________________________________________________________________
int TMyEventFilterModule::Event(int ientry) {
    
  ClearModuleOutput();
  bool pass   = true;

  if(fUseOldNewGoodRun==1 && fUseMyGoodRunList==1) 
    {
      if(MyGoodRunFlag(GetHeaderBlock()->RunNumber(),GetHeaderBlock()->SectionNumber())!=1) 
	{
	  if(fUseVerbose==1) std::cout<<" ATTN!!! This event is from BAD Run Section: Run="
				      <<(GetHeaderBlock()->RunNumber())
				      <<" Section="<<GetHeaderBlock()->SectionNumber()<<std::endl;
	  pass=false;
	  SetPassed(0);
	  return 0;	  
	}
    }

  if(MyGoodEventFlag(GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber())!=1)
    {
      if(fUseVerbose==1) std::cout<<" ATTN!!! This event is not in my GoodEvent list: Run="
				  <<(GetHeaderBlock()->RunNumber())
				  <<" Event="<<GetHeaderBlock()->EventNumber()<<std::endl;
      pass=false;
      SetPassed(0);
      return 0;
    }
  if(MyExcludeEventFlag(GetHeaderBlock()->RunNumber(),GetHeaderBlock()->EventNumber())==0)
    {
      if(fUseVerbose==1) std::cout<<" ATTN!!! This event is on my ExcludeEvent list: Run="
				  <<(GetHeaderBlock()->RunNumber())
				  <<" Event="<<GetHeaderBlock()->EventNumber()<<std::endl;
      pass=false;
      SetPassed(0);
      return 0;
    }
  //--------------------------------------------------------------------------------
  // accessing Header Block
 
  fLum=(GetHeaderBlock()->InstLum())*1.0E-30;
  fNEmObj=GetHeaderBlock()->NCdfEmObjects();
  myRunN=GetHeaderBlock()->RunNumber();
  fNMuon=GetHeaderBlock()->NCdfMuons();
  fNTrack=GetHeaderBlock()->NTracks();

  if(passGlobal)
    {

      fHist.fEvntLum_b->Fill(fLum);
      fHist.fEvntNEmObj_b->Fill(fNEmObj);
      fHist.fEvntNMuon_b->Fill(fNMuon);
      fHist.fEvntNTrack_b->Fill(fNTrack);   // supposedly defTracks
  //--------------------------------------------------------------------------------
  // accessing Calorimeter Block

      fCalData->GetEntry(ientry);
      fNTowers=fCalData->NTowers();
      fNTowersOot=fCalData->NTowersOot();
      fHist.fEvntNTowers_b->Fill(fNTowers);
      fHist.fEvntNTowersOot_b->Fill(fNTowersOot);

  //--------------------------------------------------------------------------------
  // accessing Jet Blocks (vertex strategy "1")

      fNJet=0;

      if(fJetType==0) 
	{
	  fJetBlockClu04->GetEntry(ientry);
	  fNJet=fJetBlockClu04->NJets();
	  
	}
      if(fJetType==1) 
	{
	  fJetBlockClu07->GetEntry(ientry);
	  fNJet=fJetBlockClu07->NJets();
	}
      if(fJetType==2) 
	{
	  fJetBlockClu10->GetEntry(ientry);
	  fNJet=fJetBlockClu10->NJets();
	}
      if(fJetType==3) 
	{
	  fJetBlockMid04->GetEntry(ientry);
	  fNJet=fJetBlockMid04->NJets();
	}
      if(fJetType==4) 
	{
	  fJetBlockMid07->GetEntry(ientry);
	  fNJet=fJetBlockMid07->NJets();
	}
      if(fJetType==5) 
	{
	  fJetBlockMid10->GetEntry(ientry);
	  fNJet=fJetBlockMid10->NJets();
	}
//       if(fJetType==6) fNJet=fJetBlockKt04->GetEntry(ientry)->NJets();
//       if(fJetType==7) fNJet=fJetBlockKt07->GetEntry(ientry)->NJets();
//       if(fJetType==8) fNJet=fJetBlockKt10->GetEntry(ientry)->NJets();

      fHist.fEvntNJet_b->Fill(fNJet);


  //--------------------------------------------------------------------------------
  // accessing ZVertex Block

      fZVertexBlock->GetEntry(ientry);
      vx_num=fZVertexBlock->NVertices();
      fHist.fEvntNvx_b->Fill(vx_num);
      fmyNvx12=0;
      for (int j=0; j<vx_num; j++) 
	{
	  TStnVertex *vertex= fZVertexBlock->Vertex(j);
	  if(vertex->VClass()>=12) fmyNvx12++;
	}

  //--------------------------------------------------------------------------------
  // accessing Met Block

      fMetBlock->GetEntry(ientry);
      fMEt=fMetBlock->Met(1); // MEt with respect to best vertex(?)
      //  double fSumEt=fMetBlock->Sumet(2); // SumEt with respect to jet vertex(?)
      fSumEt=fMetBlock->fSumet;
      fMEtSig=1000.0;
      if(fSumEt>0.0) fMEtSig=fMEt/sqrt(fSumEt);  
      fHist.fEvntSumEt_b->Fill(fSumEt);
      fHist.fEvntMEt_b->Fill(fMEt);
      fHist.fEvntMEtSig_b->Fill(fMEtSig);    
      FillOutput(); // filling output params
      FillMetHistogramsB(fMetHist);

  //--------------------------------------------------------------------------------
  // accessing Photon Block
      fPhotonBlock->GetEntry(ientry);

  //--------------------------------------------------------------------------------
  // accessing Trigger Block 

      if(fDataType==0) 
	{
	  fTriggerBlock->GetEntry(ientry);
	  TObjArray*  triggerList = new TObjArray(200);
	  int nmb     = fTriggerBlock->GetListOfPassedTriggers(tt,"MINBIAS_",3,triggerList);
	  int nmult   = fTriggerBlock->GetListOfPassedTriggers(tt,"MULTIPLICITY_",3,triggerList);
	  int njet20  = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_20",3,triggerList);
	  int njet20C = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_20_C",3,triggerList);
	  int njet20N = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_20_N",3,triggerList);
	  int njet50  = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_50",3,triggerList);
	  int njet70  = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_70",3,triggerList);
	  int njet70N = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_70_N",3,triggerList);
	  int njet100 = fTriggerBlock->GetListOfPassedTriggers(tt,"JET_100",3,triggerList);
	  
	  int njet15L2  = fTriggerBlock->GetListOfPassedTriggers(tt,"L2_JET15",2,triggerList);
	  int njet60L2  = fTriggerBlock->GetListOfPassedTriggers(tt,"L2_JET60",2,triggerList);
	  
	  delete triggerList;
	  
	  // SELECT JET_20_v (remove JET_20_NO_L2)
	  if (fMyTrigger==Jet20)
	    {
	      if ( njet20==0 || njet15L2==0 || njet20==njet20N || njet20==(njet20N+njet20C) ) 
		{
		  pass=false;
		  SetPassed(0);
		  return 0;
		}
	    }
	  // SELECT JET_70_v (remove JET_70_NO_L2)
	  if (fMyTrigger==Jet70)
	    {
	      if ( njet70==0 || njet60L2==0 || njet70==njet70N )
		{
		  pass=false;
		  SetPassed(0);
		  return 0;
	    }
	    }
	  if (fMyTrigger==MinBias)
	    {
	      if ( nmb==0 ) 
		{
		  pass=false;
		  SetPassed(0);
		  return 0;
		}
	    }    
	}

  //-------------------------------------------------------------------------------
  // Applying event Cuts

      if(fLum<fMinLum || fLum>fMaxLum) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass Lum cut "<<fLum<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fNEmObj<fMinNEmObj || fNEmObj>fMaxNEmObj) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass NEmObj cut "<<fNEmObj<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fNTowers<fMinNTowers || fNTowers>fMaxNTowers) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass NTowers cut "<<fNTowers<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fNTowersOot<fMinNTowersOot || fNTowersOot>fMaxNTowersOot) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass NTowersOot cut "<<fNTowersOot<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fNJet<fMinNJet || fNJet>fMaxNJet) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass NJet cut "<<fNJet<<std::endl;
	  SetPassed(0);
	  return 0;
	} 
      if(fNMuon<fMinNMuon || fNMuon>fMaxNMuon) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass NMuon cut "<<fNMuon<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fNTrack<fMinNTrack || fNTrack>fMaxNTrack) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass NTrack cut "<<fNTrack<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(vx_num<fMinNvx || vx_num>fMaxNvx) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass Nvx cut "<<vx_num<<std::endl;      
	  SetPassed(0);
	  return 0;
	}
      if(fMEt<fMinMEt || fMEt>fMaxMEt) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass MEt cut "<<fMEt<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fSumEt<fMinSumEt || fSumEt>fMaxSumEt) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass SumEt cut "<<fSumEt<<std::endl;
	  SetPassed(0);
	  return 0;
	}
      if(fMEtSig<fMinMEtSig || fMEtSig>fMaxMEtSig) 
	{
	  pass=false;
	  if(fUseVerbose==1) std::cout<<"Event "<<ientry
				      <<" didn't pass MEtSig cut "<<fMEtSig<<std::endl;
	  SetPassed(0);
	  return 0;
	}

      //_______________ removing spikes ____________________________

      if(fUseFindSpike==1)
	{
	  if(fJetType==0) DoMyCalStuff(fJetBlockClu04,fPhotonBlock,fCalData,fCalHist);
	  if(fJetType==1) DoMyCalStuff(fJetBlockClu07,fPhotonBlock,fCalData,fCalHist); 
	  if(fJetType==2) DoMyCalStuff(fJetBlockClu10,fPhotonBlock,fCalData,fCalHist);
		
	  if(fUseSpikeFilter==1 && Nspike_global>0) // removing events with PMT spikes
	    {
	      pass=false;
	      if(fUseVerbose==1) 
		std::cout<<"Event "<<ientry<<" has PMT spike"<<std::endl;
	      SetPassed(0);
	      return 0;           	      
	    }
	  if((fUseSpikeFilter+Nspike_global)<0) // selecting events with PMT spikes 
	    {
	      pass=false;
	      if(fUseVerbose==1) 
		std::cout<<"Event "<<ientry<<" has no PMT spike"<<std::endl;
	      SetPassed(0);
	      return 0;           	      
	    }
	}
  //-------------------------------------------------------------------------------
  // Filling histos for events which pass the cuts

      if ( pass )
	{	  
	  SetPassed(1);

// 	  if(fUseFindSpike==1)
// 	    {
// 	      if(fJetType==0) DoMyCalStuff(fJetBlockClu04,fPhotonBlock,fCalData,fCalHist);
// 	      if(fJetType==1) DoMyCalStuff(fJetBlockClu07,fPhotonBlock,fCalData,fCalHist); 
// 	      if(fJetType==2) DoMyCalStuff(fJetBlockClu10,fPhotonBlock,fCalData,fCalHist);
// 	    }
	  fHist.fEvntLum_a->Fill(fLum);
	  fHist.fEvntNEmObj_a->Fill(fNEmObj);
	  fHist.fEvntNTowers_a->Fill(fNTowers);
	  fHist.fEvntNTowersOot_a->Fill(fNTowersOot);
	  fHist.fEvntNJet_a->Fill(fNJet); 
	  fHist.fEvntNMuon_a->Fill(fNMuon);
	  fHist.fEvntNTrack_a->Fill(fNTrack);   
	  fHist.fEvntNvx_a->Fill(vx_num);
	  fHist.fEvntSumEt_a->Fill(fSumEt);
	  fHist.fEvntMEt_a->Fill(fMEt);
	  fHist.fEvntMEtSig_a->Fill(fMEtSig); 
	  FillMetHistogramsA(fMetHist);
	}   
      else SetPassed(0);
    }
  else 
    {
      SetPassed(0); 
    }
  return 0;
}

//_____________________________________________________________________________
void TMyEventFilterModule::Display() {

  TCanvas* MyFilter = new TCanvas("MyEventFilt","MyEventFilter Printout",100,100,700,900);
  MyFilter->Divide(2,3);
  MyFilter->cd(1); fHist.fEvntNJet_b->Draw();
  MyFilter->cd(2); fHist.fEvntNMuon_b->Draw();
  MyFilter->cd(3); fHist.fEvntNEmObj_b->Draw();
  MyFilter->cd(4); fHist.fEvntNJet_a->Draw();
  MyFilter->cd(5); fHist.fEvntNMuon_a->Draw();
  MyFilter->cd(6); fHist.fEvntNEmObj_a->Draw();

  return;
}

int TMyEventFilterModule::EndJob() {

  ofstream outfile(fDatFileName, std::ios::out);
  if (! outfile) 
    {
      std::cerr<<"Error of openning of .DAT file\n";
    }
  if(outfile)
    {

      std::cout<<"---------- Cross Check -------------------------"<<std::endl;
      std::cout<<"..........Number of events before cuts "<<fHist.fEvntLum_b->GetEntries()<<std::endl;
      std::cout<<"..........Number of events after cuts  "<<fHist.fEvntLum_a->GetEntries()<<std::endl;

      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"------  TMyEventFilterModule Summary  -------------"<<"\n";
      outfile<<"___________________________________________________"<<"\n";
      char outputstring[200];
      sprintf(outputstring,"..........Number of events before cuts = %f",fHist.fEvntLum_b->GetEntries());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,"..........Number of events after cuts = %f",fHist.fEvntLum_a->GetEntries());
      outfile<<outputstring<<"\n";
      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"-------- BEFORE CUTS ------------------------------"<<"\n";
      outfile<<"Format of output: ___Histo name___mean___rms___"<<"\n";
      outfile<<"..................................................."<<"\n";
      sprintf(outputstring,
	      "...fEvntLum_b  %f   %f",fHist.fEvntLum_b->GetMean(),
	      fHist.fEvntLum_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNEmObj_b   %f   %f",fHist.fEvntNEmObj_b->GetMean(),
	      fHist.fEvntNEmObj_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNTowers_b   %f   %f",fHist.fEvntNTowers_b->GetMean(),
	      fHist.fEvntNTowers_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNTowersOot_b   %f   %f",fHist.fEvntNTowersOot_b->GetMean(),
	      fHist.fEvntNTowersOot_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNJet_b   %f   %f",fHist.fEvntNJet_b->GetMean(),
	      fHist.fEvntNJet_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNMuon_b   %f   %f",fHist.fEvntNMuon_b->GetMean(),
	      fHist.fEvntNMuon_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNTrack_b   %f   %f",fHist.fEvntNTrack_b->GetMean(),
	      fHist.fEvntNTrack_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNvx_b   %f   %f",fHist.fEvntNvx_b->GetMean(),
	      fHist.fEvntNvx_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntSumEt_b   %f   %f",fHist.fEvntSumEt_b->GetMean(),
	      fHist.fEvntSumEt_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntMEt_b   %f   %f",fHist.fEvntMEt_b->GetMean(),
	      fHist.fEvntMEt_b->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntMEtSig_b   %f   %f",fHist.fEvntMEtSig_b->GetMean(),
	      fHist.fEvntMEtSig_b->GetRMS());
      outfile<<outputstring<<"\n";

      outfile<<"---------------------------------------------------"<<"\n";
      outfile<<"-------- AFTER CUTS ------------------------------"<<"\n";
      outfile<<"Format of output: ___Histo name___mean___rms___"<<"\n";
      outfile<<"..................................................."<<"\n";
      sprintf(outputstring,
	      "...fEvntLum_a  %f   %f",fHist.fEvntLum_a->GetMean(),
	      fHist.fEvntLum_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNEmObj_a   %f   %f",fHist.fEvntNEmObj_a->GetMean(),
	      fHist.fEvntNEmObj_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNTowers_a   %f   %f",fHist.fEvntNTowers_a->GetMean(),
	      fHist.fEvntNTowers_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNTowersOot_a   %f   %f",fHist.fEvntNTowersOot_a->GetMean(),
	      fHist.fEvntNTowersOot_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNJet_a   %f   %f",fHist.fEvntNJet_a->GetMean(),
	      fHist.fEvntNJet_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNMuon_a   %f   %f",fHist.fEvntNMuon_a->GetMean(),
	      fHist.fEvntNMuon_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNTrack_a   %f   %f",fHist.fEvntNTrack_a->GetMean(),
	      fHist.fEvntNTrack_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntNvx_a   %f   %f",fHist.fEvntNvx_a->GetMean(),
	      fHist.fEvntNvx_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntSumEt_a   %f   %f",fHist.fEvntSumEt_a->GetMean(),
	      fHist.fEvntSumEt_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntMEt_a   %f   %f",fHist.fEvntMEt_a->GetMean(),
	      fHist.fEvntMEt_a->GetRMS());
      outfile<<outputstring<<"\n";
      sprintf(outputstring,
	      "...fEvntMEtSig_a   %f   %f",fHist.fEvntMEtSig_a->GetMean(),
	      fHist.fEvntMEtSig_a->GetRMS());
      outfile<<outputstring<<"\n";      
    }

  outfile<<"---- The End!------"<<std::endl;

  delete goodrun;
  return 0;
}

void TMyEventFilterModule::ClearModuleOutput()
{
  for(int i=0; i<5; i++)
    {
      outMet[i]=-1.0E6;    
      outMetPhi[i]=-1.0E6; 
      if(i<3) outSumEt[i]=-1.0E6;  
    }   
  outMetZvx=-1.0E6;    

  fLum=-1.0E6;
  fNEmObj=-1;
  myRunN=-1;
  fNMuon=-1;
  fNTrack=-1;
  fNTowers=-1;
  fNTowersOot=-1;
  fNJet=-1;
  vx_num=-1;
  fMEt=-1.0E6;
  fSumEt=-1.0E6;
  fMEtSig=-1.0E6;
  Nspike_global=0;

  return;
}

void TMyEventFilterModule::FillOutput()
{
  for(int i=0; i<5; i++)
    {
      outMet[i]=fMetBlock->Met(i);    
      outMetPhi[i]=fMetBlock->MetPhi(i); 
      if(i<3) 
	{
	  outSumEt[i]=fMetBlock->Sumet(i);
	  if(outSumEt[i]>2000.0) outSumEt[i]=fMetBlock->Sumet(0); // if Nvx12=0, Sumet(1) & Sumet(2) return 1000000
	}  
    }   
  outMetZvx=fMetBlock->Z0();    
  return;
}

