
#if !defined (__CINT__) || defined (__MAKECINT__)
#include "TObject.h"
#endif

class TGoodRun : public TObject {
public:
  TGoodRun();
  ~TGoodRun();
  TGoodRun(const char* fname);
  int Read(const char* fname);

  bool Good(int run, int runSec=-1);
  float Lum(int run);  // by run number
  float LumFrac(int run); // fraction of lum up to this run

  int NRun() {return nrun;}
  int NEntry() {return n;}
  int Run(int index) {return r[index];}
  int LowSec(int index) {return l[index];}
  int HighSec(int index) {return h[index];}
  float LumInd(int index) {return lum[index];}
  int NFound() { return nFound; }
  float FoundLum();
  float TotLum() { return totLum; }
  float TotLum(int run1, int run2);

  void Split(int ns=5);
  int  SplitInd(int ns, int run);

protected:

  int n;
  int nrun;
  int r[5000];
  int l[5000];
  int h[5000];
  int flag[5000];
  float lum[5000];
  float lumSum[5000];
  int nFound;
  float totLum,foundLum;

  ClassDef(TGoodRun,0)

};

