
#include <fstream>
#include <iostream>

#include "TGoodRun.hh"

using std::cout;
using std::endl;

 ClassImp(TGoodRun)

//_____________________________________________________________________________
TGoodRun::TGoodRun()
{
  n=0;
  totLum = 0.0;
  foundLum = 0.0;
  nFound = 0;
}

//_____________________________________________________________________________
TGoodRun::TGoodRun(const char* fname)
{
  n=0;
  totLum = 0.0;
  foundLum = 0.0;
  nFound = 0;
  Read(fname);
}

//_____________________________________________________________________________
TGoodRun::~TGoodRun() {
}

//_____________________________________________________________________________
int TGoodRun::Read(const char* fname) {
  n = 0;
  ifstream  ingood(fname);
  if(!ingood.good()) {
    std::cout << "Error opening " << fname << " good run list" << std::endl;
    return 1;
  }
  while(!ingood.eof()) {
    ingood >> r[n] >> l[n] >> h[n] >> lum[n];
    flag[n] = 0;
    n++;
  }
  n--;
  ingood.close();

  nrun = 0;
  int crun = -1;
  for(int i=0; i<n; i++) {
    totLum += lum[i];
    lumSum[i] = totLum;
    if(r[i]!=crun) {
      nrun++;
      crun = r[i];
    }
  }

  std::cout << "Read " << n << " entries, " 
	    << nrun << " good runs from "<< fname 
	    << std::endl;
  std::cout << "Total lum= " << totLum/1000.0 << " pb " 
	    << " *1.019 = " << 1.019*totLum/1000.0 << " pb " 
	    << std::endl;

  return 0;
}

//_____________________________________________________________________________
bool TGoodRun::Good(int run, int runSec) {
  for (int i=0; i<n; i++) {
    if(r[i]==run) {
      if( runSec<0 || 
	  (runSec >= l[i] && runSec <= h[i]) || 
	  (runSec >= l[i] && h[i]<0)    ) {
	flag[i] |= 1;
	return true;
      }
    }
  }
  return false;
}

//_____________________________________________________________________________
float TGoodRun::Lum(int run) {
  float lsum = 0.0;
  for (int i=0; i<n; i++) {
    if(r[i]==run) lsum += lum[i];
  }
  return lsum;
}

//_____________________________________________________________________________
float TGoodRun::TotLum(int run1, int run2) {
  float lsum = 0.0;
  for (int i=0; i<n; i++) {
    if(r[i]>=run1 && r[i]<=run2) lsum += lum[i];
  }
  return lsum;
}

//_____________________________________________________________________________
float TGoodRun::LumFrac(int run) {
  for (int i=0; i<n; i++) {
    if(r[i]==run) return lumSum[i]/lumSum[n-1];
  }
  return -1.0;
}

//_____________________________________________________________________________
float TGoodRun::FoundLum() {
  foundLum = 0.0;
  nFound = 0;
  for (int i=0; i<n; i++) {
    if((flag[i]&0x1)>0) {
      nFound++;
      foundLum += lum[i];
    }
  }
  return foundLum;
}

//_____________________________________________________________________________
void TGoodRun::Split(int ns) {
  float splitLum = totLum/ns;
  float x = 0.0;
  for (int i=0; i<n; i++) {
    x += lum[i];
    if(x>splitLum) {
      printf("Run %6d    int lum  %5.1f\n",r[i],x);
      x = 0.0;
    }
  }
  return;
}

//_____________________________________________________________________________
int TGoodRun::SplitInd(int ns, int run) {
  float splitLum = totLum/ns;
  float x = 0.0;
  int per = 0;
  for (int i=0; i<n; i++) {
    x += lum[i];
    per = int( x/splitLum-0.001 );
    if(run==r[i]) return per;
  }
  return -1;
}



